/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.MessageExoType;
import net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithUpdateStairs;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CommunicationExoTile
extends AbstractTile
implements TileWithUpdateStairs {
    private final LivingSpace livingSpace;
    private final MessageExo message;
    private final Rose skin;
    private final ISkinParam skinParam;
    private final TileArguments tileArguments;

    @Override
    public Event getEvent() {
        return this.message;
    }

    public CommunicationExoTile(LivingSpace livingSpace, MessageExo message, Rose skin, ISkinParam skinParam, TileArguments tileArguments) {
        this.tileArguments = tileArguments;
        this.livingSpace = livingSpace;
        this.message = message;
        this.skin = skin;
        this.skinParam = skinParam;
    }

    @Override
    public double getYPoint(StringBounder stringBounder) {
        return this.getComponent(stringBounder).getYPoint(stringBounder);
    }

    private ArrowComponent getComponent(StringBounder stringBounder) {
        ArrowConfiguration arrowConfiguration = this.message.getArrowConfiguration();
        if (this.message.getType().getDirection() == -1) {
            arrowConfiguration = arrowConfiguration.reverse();
        }
        ArrowComponent comp = this.skin.createComponentArrow(this.message.getUsedStyles(), arrowConfiguration, this.skinParam, this.message.getLabelNumbered());
        return comp;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ArrowComponent comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double x1 = this.getPoint1Value(stringBounder);
        double x2 = this.getPoint2Value(stringBounder);
        int level = this.livingSpace.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
        if (level > 0) {
            if (this.message.getType().isRightBorder()) {
                x1 += 5.0 * (double)level;
            } else {
                x2 += 5.0 * (double)(level - 2);
            }
        }
        ArrowConfiguration arrowConfiguration = this.message.getArrowConfiguration();
        MessageExoType type = this.message.getType();
        if (arrowConfiguration.getDecoration1() == ArrowDecoration.CIRCLE && type == MessageExoType.FROM_LEFT) {
            x1 += 6.0;
        }
        if (arrowConfiguration.getDecoration2() == ArrowDecoration.CIRCLE && type == MessageExoType.TO_LEFT) {
            x1 += 6.0;
        }
        if (arrowConfiguration.getDecoration2() == ArrowDecoration.CIRCLE && type == MessageExoType.TO_RIGHT) {
            x2 -= 6.0;
        }
        if (arrowConfiguration.getDecoration1() == ArrowDecoration.CIRCLE && type == MessageExoType.FROM_RIGHT) {
            x2 -= 6.0;
        }
        Area area = new Area(x2 - x1, dim.getHeight());
        ug = ug.apply(new UTranslate(x1, 0.0));
        comp.drawU(ug, area, (Context2D)((Object)ug));
    }

    private boolean isShortArrow() {
        return this.message.isShortArrow();
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        ArrowComponent comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        return dim.getHeight();
    }

    private double getPreferredWidth(StringBounder stringBounder) {
        ArrowComponent comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        return dim.getWidth();
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        ArrowComponent comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double width = dim.getWidth();
        if (!this.message.getType().isRightBorder()) {
            this.livingSpace.getPosC(stringBounder).ensureBiggerThan(this.tileArguments.getOrigin().addFixed(width));
        }
    }

    @Override
    public void updateStairs(StringBounder stringBounder, double y) {
        ArrowComponent comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double arrowY = comp.getStartPoint(stringBounder, dim).getY();
        this.livingSpace.addStepForLivebox(this.getEvent(), y + arrowY);
    }

    private Real getPoint1(StringBounder stringBounder) {
        if (this.message.getType().isRightBorder()) {
            return this.livingSpace.getPosC(stringBounder);
        }
        return this.tileArguments.getOrigin();
    }

    private double getPoint1Value(StringBounder stringBounder) {
        if (this.message.getType().isRightBorder()) {
            return this.livingSpace.getPosC(stringBounder).getCurrentValue();
        }
        if (this.isShortArrow()) {
            return this.getPoint2Value(stringBounder) - this.getPreferredWidth(stringBounder);
        }
        return this.tileArguments.getBorder1();
    }

    private double getPoint2Value(StringBounder stringBounder) {
        if (this.message.getType().isRightBorder()) {
            if (this.isShortArrow()) {
                return this.getPoint1Value(stringBounder) + this.getPreferredWidth(stringBounder);
            }
            return this.tileArguments.getBorder2();
        }
        return this.livingSpace.getPosC(stringBounder).getCurrentValue();
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        return this.getPoint1(stringBounder);
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        ArrowComponent comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double width = dim.getWidth();
        return this.getPoint1(stringBounder).addFixed(width);
    }
}

