/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.ComplementPattern;
import net.sourceforge.plantuml.project3.Failable;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.LoadInDays;

public class ComplementSeveralDays
implements ComplementPattern {
    @Override
    public IRegex toRegex(String suffix) {
        return new RegexConcat(new RegexLeaf("COMPLEMENT" + suffix, "(\\d+)[%s]+(days?|weeks?)"));
    }

    @Override
    public Failable<Complement> getComplement(GanttDiagram system, RegexResult arg, String suffix) {
        String number = arg.get("COMPLEMENT" + suffix, 0);
        boolean inWeeks = arg.get("COMPLEMENT" + suffix, 1).startsWith("w");
        int factor = inWeeks ? system.daysInWeek() : 1;
        int days = Integer.parseInt(number) * factor;
        return Failable.ok(LoadInDays.inDay(days));
    }
}

