/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.comp;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.TextLimitFinder;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UParamNull;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.comp.CompressionMode;
import net.sourceforge.plantuml.ugraphic.comp.SlotSet;

public class SlotFinder
implements UGraphic {
    private final SlotSet slot;
    private final StringBounder stringBounder;
    private final UTranslate translate;
    private final CompressionMode mode;

    @Override
    public boolean matchesProperty(String propertyName) {
        return false;
    }

    public double dpiFactor() {
        return 1.0;
    }

    @Override
    public UGraphic apply(UChange change) {
        if (change instanceof UTranslate) {
            return new SlotFinder(this.mode, this.stringBounder, this.slot, this.translate.compose((UTranslate)change));
        }
        if (change instanceof UStroke) {
            return new SlotFinder(this);
        }
        if (change instanceof UChangeBackColor) {
            return new SlotFinder(this);
        }
        if (change instanceof UChangeColor) {
            return new SlotFinder(this);
        }
        throw new UnsupportedOperationException();
    }

    public SlotFinder(CompressionMode mode, StringBounder stringBounder) {
        this(mode, stringBounder, new SlotSet(), new UTranslate());
    }

    private SlotFinder(CompressionMode mode, StringBounder stringBounder, SlotSet slot, UTranslate translate) {
        this.stringBounder = stringBounder;
        this.slot = slot;
        this.translate = translate;
        this.mode = mode;
    }

    private SlotFinder(SlotFinder other) {
        this(other.mode, other.stringBounder, other.slot, other.translate);
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    @Override
    public UParam getParam() {
        return new UParamNull();
    }

    @Override
    public void draw(UShape shape) {
        double x = this.translate.getDx();
        double y = this.translate.getDy();
        if (shape instanceof URectangle) {
            URectangle rect = (URectangle)shape;
            if (this.mode == CompressionMode.ON_X && rect.isIgnoreForCompression()) {
                this.drawRectangle(x, y, new URectangle(2.0, rect.getHeight()));
                this.drawRectangle(x + rect.getWidth() - 2.0, y, new URectangle(2.0, rect.getHeight()));
                return;
            }
            if (this.mode == CompressionMode.ON_Y && rect.isIgnoreForCompression()) {
                this.drawRectangle(x, y, new URectangle(rect.getWidth(), 2.0));
                this.drawRectangle(x, y + rect.getHeight() - 2.0, new URectangle(rect.getWidth(), 2.0));
                return;
            }
            this.drawRectangle(x, y, (URectangle)shape);
        } else if (shape instanceof UPath) {
            this.drawPath(x, y, (UPath)shape);
        } else if (shape instanceof UPolygon) {
            this.drawPolygon(x, y, (UPolygon)shape);
        } else if (shape instanceof UEllipse) {
            this.drawEllipse(x, y, (UEllipse)shape);
        } else if (shape instanceof UText) {
            this.drawText(x, y, (UText)shape);
        } else if (shape instanceof UEmpty) {
            this.drawEmpty(x, y, (UEmpty)shape);
        }
    }

    private void drawPath(double x, double y, UPath shape) {
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(x + shape.getMinX(), x + shape.getMaxX());
        } else {
            this.slot.addSlot(y + shape.getMinY(), y + shape.getMaxY());
        }
    }

    private void drawEmpty(double x, double y, UEmpty shape) {
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(x, x + shape.getWidth());
        } else {
            this.slot.addSlot(y, y + shape.getHeight());
        }
    }

    private void drawText(double x, double y, UText shape) {
        TextLimitFinder finder = new TextLimitFinder(this.stringBounder, false);
        finder.apply(new UTranslate(x, y)).draw(shape);
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(finder.getMinX(), finder.getMaxX());
        } else {
            this.slot.addSlot(finder.getMinY(), finder.getMaxY());
        }
    }

    private void drawEllipse(double x, double y, UEllipse shape) {
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(x, x + shape.getWidth());
        } else {
            this.slot.addSlot(y, y + shape.getHeight());
        }
    }

    private void drawPolygon(double x, double y, UPolygon shape) {
        if (this.mode == shape.isIgnoreForCompression()) {
            return;
        }
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(x + shape.getMinX(), x + shape.getMaxX());
        } else {
            this.slot.addSlot(y + shape.getMinY(), y + shape.getMaxY());
        }
    }

    private void drawRectangle(double x, double y, URectangle shape) {
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(x, x + shape.getWidth());
        } else {
            this.slot.addSlot(y, y + shape.getHeight());
        }
    }

    @Override
    public ColorMapper getColorMapper() {
        return new ColorMapperIdentity();
    }

    @Override
    public void startUrl(Url url) {
    }

    @Override
    public void closeAction() {
    }

    public SlotSet getSlotSet() {
        return this.slot;
    }

    @Override
    public void flushUg() {
    }
}

