/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.SkinParamColors;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileBox
extends AbstractFtile {
    private double padding = 10.0;
    private final TextBlock tb;
    private double roundCorner = 25.0;
    private final double shadowing;
    private final HorizontalAlignment horizontalAlignment;
    private double minimumWidth = 0.0;
    private final LinkRendering inRendering;
    private final Swimlane swimlane;
    private final BoxStyle boxStyle;
    private final HtmlColor borderColor;
    private final HtmlColor backColor;
    private final Style style;
    private final String print;

    private double padding() {
        return this.padding;
    }

    public static StyleSignature getDefaultStyleDefinitionActivity() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public static StyleSignature getDefaultStyleDefinitionArrow() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    @Override
    public final LinkRendering getInLinkRendering() {
        return this.inRendering;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    public static FtileBox create(ISkinParam skinParam, Display label, Swimlane swimlane, BoxStyle boxStyle) {
        Style style = null;
        Style styleArrow = null;
        if (SkinParam.USE_STYLES()) {
            style = FtileBox.getDefaultStyleDefinitionActivity().getMergedStyle(skinParam.getCurrentStyleBuilder());
            styleArrow = FtileBox.getDefaultStyleDefinitionArrow().getMergedStyle(skinParam.getCurrentStyleBuilder());
        }
        return new FtileBox(skinParam, label, swimlane, boxStyle, style, styleArrow);
    }

    public static FtileBox createWbs(StyleBuilder styleBuilder, ISkinParam skinParam, Display label, StyleSignature styleDefinition) {
        Style style = null;
        Style styleArrow = null;
        if (SkinParam.USE_STYLES()) {
            styleArrow = style = styleDefinition.getMergedStyle(styleBuilder);
        }
        return new FtileBox(skinParam, label, null, BoxStyle.PLAIN, style, styleArrow);
    }

    public static FtileBox createWbs(Style style, ISkinParam skinParam, Display label) {
        Style styleArrow = null;
        if (SkinParam.USE_STYLES()) {
            styleArrow = style;
        }
        return new FtileBox(skinParam, label, null, BoxStyle.PLAIN, style, styleArrow);
    }

    public static FtileBox createMindMap(StyleBuilder styleBuilder, ISkinParam skinParam, Display label, StyleSignature styleDefinition) {
        Style style = null;
        Style styleArrow = null;
        if (SkinParam.USE_STYLES()) {
            styleArrow = style = styleDefinition.getMergedStyle(styleBuilder);
        }
        return new FtileBox(skinParam, label, null, BoxStyle.PLAIN, style, styleArrow);
    }

    private FtileBox(ISkinParam skinParam, Display label, Swimlane swimlane, BoxStyle boxStyle, Style style, Style styleArrow) {
        super(skinParam);
        LineBreakStrategy wrapWidth;
        FontConfiguration fc;
        this.style = style;
        this.boxStyle = boxStyle;
        this.swimlane = swimlane;
        if (SkinParam.USE_STYLES()) {
            this.inRendering = new LinkRendering(Rainbow.build(styleArrow, this.getIHtmlColorSet()));
            Colors specBack = null;
            if (skinParam instanceof SkinParamColors) {
                specBack = ((SkinParamColors)skinParam).getColors();
            }
            style = style.eventuallyOverride(specBack);
            this.borderColor = style.value(PName.LineColor).asColor(this.getIHtmlColorSet());
            this.backColor = style.value(PName.BackGroundColor).asColor(this.getIHtmlColorSet());
            fc = style.getFontConfiguration(this.getIHtmlColorSet());
            this.horizontalAlignment = style.getHorizontalAlignment();
            this.padding = style.getPadding().asDouble();
            this.roundCorner = style.value(PName.RoundCorner).asDouble();
            this.shadowing = style.value(PName.Shadowing).asDouble();
            wrapWidth = style.wrapWidth();
            this.minimumWidth = style.value(PName.MinimumWidth).asDouble();
        } else {
            this.inRendering = new LinkRendering(Rainbow.build(skinParam));
            this.borderColor = SkinParamUtils.getColor(this.skinParam(), null, ColorParam.activityBorder);
            this.backColor = SkinParamUtils.getColor(this.skinParam(), null, ColorParam.activityBackground);
            fc = new FontConfiguration(skinParam, FontParam.ACTIVITY, null);
            this.horizontalAlignment = HorizontalAlignment.LEFT;
            this.shadowing = this.skinParam().shadowing(null) ? 3.0 : 0.0;
            wrapWidth = skinParam.wrapWidth();
        }
        Sheet sheet = new CreoleParser(fc, skinParam.getDefaultTextAlignment(this.horizontalAlignment), skinParam, CreoleMode.FULL).createSheet(label);
        this.tb = new SheetBlock2(new SheetBlock1(sheet, wrapWidth, skinParam.getPadding()), new MyStencil(), new UStroke(1.0));
        this.print = label.toString();
    }

    public String toString() {
        return this.print;
    }

    @Override
    public void drawU(UGraphic ug) {
        FtileGeometry dimTotal = this.calculateDimension(ug.getStringBounder());
        double widthTotal = ((Dimension2D)dimTotal).getWidth();
        double heightTotal = ((Dimension2D)dimTotal).getHeight();
        UDrawable rect = this.boxStyle.getUDrawable(widthTotal, heightTotal, this.shadowing, this.roundCorner);
        UStroke thickness = SkinParam.USE_STYLES() ? this.style.getStroke() : this.getThickness();
        ug = ug.apply(new UChangeColor(this.borderColor)).apply(new UChangeBackColor(this.backColor)).apply(thickness);
        rect.drawU(ug);
        if (this.horizontalAlignment == HorizontalAlignment.LEFT) {
            this.tb.drawU(ug.apply(new UTranslate(this.padding(), this.padding())));
        } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
            Dimension2D dimTb = this.tb.calculateDimension(ug.getStringBounder());
            this.tb.drawU(ug.apply(new UTranslate(((Dimension2D)dimTotal).getWidth() - dimTb.getWidth() - this.padding(), this.padding())));
        } else if (this.horizontalAlignment == HorizontalAlignment.CENTER) {
            Dimension2D dimTb = this.tb.calculateDimension(ug.getStringBounder());
            this.tb.drawU(ug.apply(new UTranslate((((Dimension2D)dimTotal).getWidth() - dimTb.getWidth()) / 2.0, this.padding())));
        }
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        Dimension2D dim = this.tb.calculateDimension(stringBounder);
        dim = Dimension2DDouble.delta(dim, 2.0 * this.padding(), 2.0 * this.padding());
        dim = Dimension2DDouble.atLeast(dim, this.minimumWidth, 0.0);
        return new FtileGeometry(dim, dim.getWidth() / 2.0, 0.0, dim.getHeight());
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    class MyStencil
    implements Stencil {
        MyStencil() {
        }

        @Override
        public double getStartingX(StringBounder stringBounder, double y) {
            return -FtileBox.this.padding();
        }

        @Override
        public double getEndingX(StringBounder stringBounder, double y) {
            FtileGeometry dim = FtileBox.this.calculateDimension(stringBounder);
            return ((Dimension2D)dim).getWidth() - FtileBox.this.padding();
        }
    }
}

