/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.TitleStrategy;

public abstract class ReallyAbstractPlayer
implements Player {
    protected final ISkinParam skinParam;
    protected final TimingRuler ruler;
    protected final TitleStrategy titleStrategy;
    private final Display title;

    public ReallyAbstractPlayer(TitleStrategy titleStrategy, String title, ISkinParam skinParam, TimingRuler ruler) {
        this.skinParam = skinParam;
        this.ruler = ruler;
        this.titleStrategy = titleStrategy;
        this.title = Display.getWithNewlines(title);
    }

    @Override
    public double getFirstColumnWidth(StringBounder stringBounder) {
        return 40.0;
    }

    protected final FontConfiguration getFontConfiguration() {
        return new FontConfiguration(this.skinParam, FontParam.TIMING, null);
    }

    protected final TextBlock getTitle() {
        return this.title.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    private TextBlock createTextBlock(String value) {
        Display display = Display.getWithNewlines(value);
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }
}

