/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.nwdiag.DiagElement;
import net.sourceforge.plantuml.nwdiag.Network;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class LinkedElement {
    private final TextBlock ad1;
    private final TextBlock box;
    private final TextBlock ad2;
    private final Network network;
    private final DiagElement element;
    private final double marginAd = 10.0;
    private final double marginBox = 15.0;

    public LinkedElement(TextBlock ad1, TextBlock box, TextBlock ad2, Network network, DiagElement element) {
        this.ad1 = ad1;
        this.box = box;
        this.ad2 = ad2;
        this.network = network;
        this.element = element;
    }

    public MinMax getMinMax(StringBounder stringBounder, double width, double height) {
        double xMiddle = width / 2.0;
        double yMiddle = height / 2.0;
        Dimension2D dimBox = this.box.calculateDimension(stringBounder);
        double x1 = xMiddle - dimBox.getWidth() / 2.0;
        double y1 = yMiddle - dimBox.getHeight() / 2.0;
        double x2 = xMiddle + dimBox.getWidth() / 2.0;
        double y2 = yMiddle + dimBox.getHeight() / 2.0;
        return MinMax.getEmpty(false).addPoint(x1 - 5.0, y1 - 5.0).addPoint(x2 + 5.0, y2 + 5.0);
    }

    public void drawMe(UGraphic ug, double width, double height) {
        double xMiddle = width / 2.0;
        double yMiddle = height / 2.0;
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimBox = this.box.calculateDimension(stringBounder);
        double y1 = yMiddle - dimBox.getHeight() / 2.0;
        double y2 = yMiddle + dimBox.getHeight() / 2.0;
        this.drawCenter(ug, this.box, xMiddle, yMiddle);
        HtmlColor color = ColorParam.activityBorder.getDefaultValue();
        ug = ug.apply(new UChangeColor(color));
        this.drawHLine(ug, xMiddle, 5.0, y1);
        if (this.ad2 != null) {
            this.drawHLine(ug, xMiddle, y2, height);
        }
        this.drawCenter(ug, this.ad1, xMiddle, (5.0 + y1) / 2.0);
        if (this.ad2 != null) {
            this.drawCenter(ug, this.ad2, xMiddle, (y2 + height - 5.0) / 2.0);
        }
    }

    private void drawCenter(UGraphic ug, TextBlock block, double x, double y) {
        Dimension2D dim = block.calculateDimension(ug.getStringBounder());
        block.drawU(ug.apply(new UTranslate(x - dim.getWidth() / 2.0, y - dim.getHeight() / 2.0)));
    }

    private void drawHLine(UGraphic ug, double x, double y1, double y2) {
        ULine line = new ULine(0.0, y2 - y1);
        ug.apply(new UTranslate(x, y1)).draw(line);
    }

    public Dimension2D naturalDimension(StringBounder stringBounder) {
        Dimension2D dim1 = this.ad1.calculateDimension(stringBounder);
        Dimension2D dimBox = this.box.calculateDimension(stringBounder);
        Dimension2D dim2 = this.ad2 == null ? new Dimension2DDouble(0.0, 0.0) : this.ad2.calculateDimension(stringBounder);
        double width = MathUtils.max(dim1.getWidth() + 20.0, dimBox.getWidth() + 30.0, dim2.getWidth() + 20.0);
        double height = dim1.getHeight() + 20.0 + dimBox.getHeight() + 30.0 + dim2.getHeight() + 20.0;
        return new Dimension2DDouble(width, height);
    }

    public final Network getNetwork() {
        return this.network;
    }

    public final DiagElement getElement() {
        return this.element;
    }
}

