/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.ReallyAbstractPlayer;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.TitleStrategy;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class PlayerBinary
extends ReallyAbstractPlayer
implements Player {
    private static final int HEIGHT = 30;
    private final SortedMap<TimeTick, Boolean> values = new TreeMap<TimeTick, Boolean>();
    private final double ymargin = 8.0;

    public PlayerBinary(TitleStrategy titleStrategy, String code, ISkinParam skinParam, TimingRuler ruler) {
        super(titleStrategy, code, skinParam, ruler);
    }

    @Override
    public double getHeight(StringBounder stringBounder) {
        return 30.0;
    }

    private SymbolContext getContext() {
        return new SymbolContext(HtmlColorUtils.COL_D7E0F2, HtmlColorUtils.COL_038048).withStroke(new UStroke(1.5));
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addNote(TimeTick now, Display note, Position position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void defineState(String stateCode, String label) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setState(TimeTick now, String comment, Colors color, String ... states) {
        boolean state = this.getState(states[0]);
        this.values.put(now, state);
    }

    private boolean getState(String value) {
        return "1".equals(value) || "high".equalsIgnoreCase(value);
    }

    @Override
    public void createConstraint(TimeTick tick1, TimeTick tick2, String message) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawFrameTitle(UGraphic ug) {
    }

    private double getYpos(boolean state) {
        return state ? 8.0 : 22.0;
    }

    @Override
    public void drawContent(UGraphic ug) {
        ug = this.getContext().apply(ug);
        double lastx = 0.0;
        boolean lastValue = false;
        for (Map.Entry<TimeTick, Boolean> ent : this.values.entrySet()) {
            double x = this.ruler.getPosInPixel(ent.getKey());
            ug.apply(new UTranslate(lastx, this.getYpos(lastValue))).draw(new ULine(x - lastx, 0.0));
            if (lastValue != ent.getValue()) {
                ug.apply(new UTranslate(x, 8.0)).draw(new ULine(0.0, 14.0));
            }
            lastx = x;
            lastValue = ent.getValue();
        }
        ug.apply(new UTranslate(lastx, this.getYpos(lastValue))).draw(new ULine(this.ruler.getWidth() - lastx, 0.0));
    }

    @Override
    public void drawLeftHeader(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        TextBlock title = this.getTitle();
        Dimension2D dim = title.calculateDimension(stringBounder);
        double y = (this.getHeight(stringBounder) - dim.getHeight()) / 2.0;
        title.drawU(ug.apply(new UTranslate(0.0, y)));
    }

    @Override
    public double getWidthHeader(StringBounder stringBounder) {
        return this.getTitle().calculateDimension(stringBounder).getWidth() + 5.0;
    }
}

