/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.Styleable;

public enum ComponentType implements Styleable
{
    ARROW,
    ACTOR_HEAD,
    ACTOR_TAIL,
    BOUNDARY_HEAD,
    BOUNDARY_TAIL,
    CONTROL_HEAD,
    CONTROL_TAIL,
    ENTITY_HEAD,
    ENTITY_TAIL,
    QUEUE_HEAD,
    QUEUE_TAIL,
    DATABASE_HEAD,
    DATABASE_TAIL,
    COLLECTIONS_HEAD,
    COLLECTIONS_TAIL,
    ALIVE_BOX_CLOSE_CLOSE,
    ALIVE_BOX_CLOSE_OPEN,
    ALIVE_BOX_OPEN_CLOSE,
    ALIVE_BOX_OPEN_OPEN,
    DELAY_TEXT,
    DESTROY,
    DELAY_LINE,
    PARTICIPANT_LINE,
    CONTINUE_LINE,
    GROUPING_ELSE,
    GROUPING_HEADER,
    GROUPING_SPACE,
    NEWPAGE,
    NOTE,
    NOTE_HEXAGONAL,
    NOTE_BOX,
    DIVIDER,
    REFERENCE,
    ENGLOBER,
    PARTICIPANT_HEAD,
    PARTICIPANT_TAIL;


    public boolean isArrow() {
        return this == ARROW;
    }

    @Override
    public StyleSignature getDefaultStyleDefinition() {
        if (this == PARTICIPANT_HEAD || this == PARTICIPANT_TAIL) {
            return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.participant);
        }
        if (this == PARTICIPANT_LINE || this == CONTINUE_LINE) {
            return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.lifeLine);
        }
        if (this == ALIVE_BOX_CLOSE_CLOSE || this == ALIVE_BOX_CLOSE_OPEN || this == ALIVE_BOX_OPEN_CLOSE || this == ALIVE_BOX_OPEN_OPEN) {
            return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.lifeLine);
        }
        if (this == DESTROY) {
            return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.lifeLine);
        }
        if (this == DIVIDER) {
            return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.separator);
        }
        if (this == ENGLOBER) {
            return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.box);
        }
        if (this == NOTE) {
            return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.note);
        }
        if (this == DELAY_TEXT) {
            return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.delay);
        }
        if (this == DELAY_LINE) {
            return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.delay);
        }
        if (SkinParam.USE_STYLES()) {
            throw new UnsupportedOperationException(this.toString());
        }
        return StyleSignature.of(SName.root);
    }
}

