/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.ComplementColors;
import net.sourceforge.plantuml.project3.ComplementPattern;
import net.sourceforge.plantuml.project3.Failable;
import net.sourceforge.plantuml.project3.GanttDiagram;

public class ComplementInColors
implements ComplementPattern {
    @Override
    public IRegex toRegex(String suffix) {
        return new RegexLeaf("COMPLEMENT" + suffix, "in[%s+](#?\\w+)(?:/(#?\\w+))?");
    }

    @Override
    public Failable<Complement> getComplement(GanttDiagram system, RegexResult arg, String suffix) {
        String color1 = arg.get("COMPLEMENT" + suffix, 0);
        String color2 = arg.get("COMPLEMENT" + suffix, 1);
        HtmlColor col1 = system.getIHtmlColorSet().getColorIfValid(color1);
        HtmlColor col2 = system.getIHtmlColorSet().getColorIfValid(color2);
        return Failable.ok(new ComplementColors(col1, col2));
    }
}

