/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.utils.UniqueSequence;

public final class FactoryNoteActivityCommand
implements SingleMultiFactoryCommand<ActivityDiagram> {
    private IRegex getRegexConcatMultiLine() {
        return RegexConcat.build(FactoryNoteActivityCommand.class.getName() + "multi", RegexLeaf.start(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(right|left|top|bottom)"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    private IRegex getRegexConcatSingleLine() {
        return RegexConcat.build(FactoryNoteActivityCommand.class.getName() + "single", RegexLeaf.start(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(right|left|top|bottom)"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("NOTE", "(.*)"), RegexLeaf.end());
    }

    @Override
    public Command<ActivityDiagram> createMultiLine(boolean withBracket) {
        return new CommandMultilines2<ActivityDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^[%s]*end[%s]?note$";
            }

            @Override
            public final CommandExecutionResult executeNow(ActivityDiagram diagram, BlocLines lines) {
                RegexResult arg = this.getStartingPattern().matcher(lines.getFirst499().getTrimmed().getString());
                lines = lines.subExtract(1, 1);
                lines = lines.removeEmptyColumns();
                Display strings = lines.toDisplay();
                Url url = null;
                if (strings.size() > 0) {
                    UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
                    url = urlBuilder.getUrl(strings.get(0).toString());
                }
                if (url != null) {
                    strings = strings.subList(1, strings.size());
                }
                String codeString = UniqueSequence.getString("GMN");
                Ident ident = diagram.buildLeafIdent(codeString);
                Ident code = diagram.V1972() ? ident : diagram.buildCode(codeString);
                ILeaf note = diagram.createLeaf(ident, code, strings, LeafType.NOTE, null);
                if (url != null) {
                    note.addUrl(url);
                }
                return FactoryNoteActivityCommand.this.executeInternal(diagram, arg, note);
            }
        };
    }

    @Override
    public Command<ActivityDiagram> createSingleLine() {
        return new SingleLineCommand2<ActivityDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(ActivityDiagram diagram, LineLocation location, RegexResult arg) {
                String tmp = UniqueSequence.getString("GN");
                Ident ident = diagram.buildLeafIdent(tmp);
                Ident code = diagram.V1972() ? ident : diagram.buildCode(tmp);
                IEntity note = diagram.createNote(ident, code, Display.getWithNewlines(arg.get("NOTE", 0)));
                return FactoryNoteActivityCommand.this.executeInternal(diagram, arg, note);
            }
        };
    }

    private CommandExecutionResult executeInternal(ActivityDiagram diagram, RegexResult arg, IEntity note) {
        Link link;
        note.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("COLOR", 0)));
        IEntity activity = diagram.getLastEntityConsulted();
        if (activity == null) {
            activity = diagram.getStart();
        }
        Position position = Position.valueOf(StringUtils.goUpperCase(arg.get("POSITION", 0))).withRankdir(diagram.getSkinParam().getRankdir());
        LinkType type = new LinkType(LinkDecor.NONE, LinkDecor.NONE).goDashed();
        if (position == Position.RIGHT) {
            link = new Link(activity, note, type, Display.NULL, 1, diagram.getSkinParam().getCurrentStyleBuilder());
        } else if (position == Position.LEFT) {
            link = new Link(note, activity, type, Display.NULL, 1, diagram.getSkinParam().getCurrentStyleBuilder());
        } else if (position == Position.BOTTOM) {
            link = new Link(activity, note, type, Display.NULL, 2, diagram.getSkinParam().getCurrentStyleBuilder());
        } else if (position == Position.TOP) {
            link = new Link(note, activity, type, Display.NULL, 2, diagram.getSkinParam().getCurrentStyleBuilder());
        } else {
            throw new IllegalArgumentException();
        }
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }
}

