/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.cute.InfiniteLine;

public class CrossingSimple {
    private final double radius;
    private final InfiniteLine line;

    public CrossingSimple(double radius, InfiniteLine line) {
        this.radius = radius;
        this.line = line;
    }

    private double pow2(double x) {
        return x * x;
    }

    private double sgn(double x) {
        if (x < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    public List<Point2D> intersection() {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        double delta = this.pow2(this.radius * this.line.getDr()) - this.pow2(this.line.getDiscriminant());
        if (delta < 0.0) {
            return result;
        }
        double x = (this.line.getDiscriminant() * this.line.getDeltaY() + this.sgn(this.line.getDeltaY()) * this.line.getDeltaX() * Math.sqrt(delta)) / this.pow2(this.line.getDr());
        double y = (-this.line.getDiscriminant() * this.line.getDeltaX() + Math.abs(this.line.getDeltaY()) * Math.sqrt(delta)) / this.pow2(this.line.getDr());
        result.add(new Point2D.Double(x, y));
        x = (this.line.getDiscriminant() * this.line.getDeltaY() - this.sgn(this.line.getDeltaY()) * this.line.getDeltaX() * Math.sqrt(delta)) / this.pow2(this.line.getDr());
        y = (-this.line.getDiscriminant() * this.line.getDeltaX() - Math.abs(this.line.getDeltaY()) * Math.sqrt(delta)) / this.pow2(this.line.getDr());
        result.add(new Point2D.Double(x, y));
        return result;
    }
}

