/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.timingdiagram.TimeArrow;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TimeConstraint {
    private final TimeTick tick1;
    private final TimeTick tick2;
    private final Display label;

    public TimeConstraint(TimeTick tick1, TimeTick tick2, String label) {
        this.tick1 = tick1;
        this.tick2 = tick2;
        this.label = Display.getWithNewlines(label);
    }

    public final TimeTick getTick1() {
        return this.tick1;
    }

    public final TimeTick getTick2() {
        return this.tick2;
    }

    public final Display getLabel() {
        return this.label;
    }

    private TextBlock getTextBlock(Display display, ISkinParam skinParam) {
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, skinParam);
    }

    private FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(14);
        return new FontConfiguration(font, HtmlColorUtils.BLACK, HtmlColorUtils.BLUE, false);
    }

    public void drawU(UGraphic ug, TimingRuler ruler, ISkinParam skinParam) {
        ug = ug.apply(new UChangeColor(HtmlColorUtils.RED)).apply(new UChangeBackColor(HtmlColorUtils.RED));
        double x1 = ruler.getPosInPixel(this.tick1);
        double x2 = ruler.getPosInPixel(this.tick2);
        ULine line = new ULine(x2 - x1, 0.0);
        ug = ug.apply(new UTranslate(x1, 0.0));
        ug.draw(line);
        ug.draw(this.getPolygon(-1.5707963267948966, new Point2D.Double(0.0, 0.0)));
        ug.draw(this.getPolygon(1.5707963267948966, new Point2D.Double(x2 - x1, 0.0)));
        TextBlock text = this.getTextBlock(this.label, skinParam);
        Dimension2D dimText = text.calculateDimension(ug.getStringBounder());
        double x = (x2 - x1 - dimText.getWidth()) / 2.0;
        UTranslate tr = new UTranslate(x, -5.0 - dimText.getHeight());
        text.drawU(ug.apply(tr));
    }

    private UPolygon getPolygon(double angle, Point2D end) {
        double delta = 0.3490658503988659;
        Point2D pt1 = TimeArrow.onCircle(end, angle + 0.3490658503988659);
        Point2D pt2 = TimeArrow.onCircle(end, angle - 0.3490658503988659);
        UPolygon polygon = new UPolygon();
        polygon.addPoint(pt1.getX(), pt1.getY());
        polygon.addPoint(pt2.getX(), pt2.getY());
        polygon.addPoint(end.getX(), end.getY());
        return polygon;
    }
}

