/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupRoot;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.HideOrShow2;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.entity.EntityImpl;
import net.sourceforge.plantuml.skin.VisibilityModifier;

public final class EntityFactory {
    private final Map<String, ILeaf> leafsByCode;
    private final Map<String, IGroup> groupsByCode;
    final Map<Ident, ILeaf> leafs2 = new LinkedHashMap<Ident, ILeaf>();
    final Map<Ident, IGroup> groups2 = new LinkedHashMap<Ident, IGroup>();
    private final List<Link> links = new ArrayList<Link>();
    private int rawLayout;
    private final IGroup rootGroup = new GroupRoot(this);
    private final List<HideOrShow2> hides2;
    private final List<HideOrShow2> removed;
    public final CucaDiagram namespaceSeparator;

    public EntityFactory(List<HideOrShow2> hides2, List<HideOrShow2> removed, CucaDiagram namespaceSeparator) {
        this.hides2 = hides2;
        this.removed = removed;
        this.namespaceSeparator = namespaceSeparator;
        this.leafsByCode = new LinkedHashMap<String, ILeaf>();
        this.groupsByCode = new LinkedHashMap<String, IGroup>();
    }

    public boolean isHidden(ILeaf leaf) {
        boolean hidden = false;
        for (HideOrShow2 hide : this.hides2) {
            hidden = hide.apply(hidden, leaf);
        }
        return hidden;
    }

    public boolean isRemoved(ILeaf leaf) {
        boolean result = false;
        for (HideOrShow2 hide : this.removed) {
            result = hide.apply(result, leaf);
        }
        return result;
    }

    public void thisIsGoingToBeALeaf(Ident ident) {
    }

    public void thisIsNotArealGroup(Ident ident) {
    }

    public ILeaf createLeaf(Ident ident, Code code, Display display, LeafType entityType, IGroup parentContainer, Set<VisibilityModifier> hides, String namespaceSeparator) {
        if (entityType == null) {
            throw new IllegalArgumentException();
        }
        Bodier bodier = new Bodier(entityType, hides);
        EntityImpl result = new EntityImpl(ident, code, this, bodier, parentContainer, entityType, namespaceSeparator, this.rawLayout);
        bodier.setLeaf(result);
        result.setDisplay(display);
        return result;
    }

    public IGroup createGroup(Ident ident, Code code, Display display, Code namespace, GroupType groupType, IGroup parentContainer, Set<VisibilityModifier> hides, String namespaceSeparator) {
        if (groupType == null) {
            throw new IllegalArgumentException();
        }
        Bodier bodier = new Bodier(null, hides);
        EntityImpl result = new EntityImpl(ident, code, this, bodier, parentContainer, groupType, namespace, namespaceSeparator, this.rawLayout);
        if (!Display.isNull(display)) {
            result.setDisplay(display);
        }
        return result;
    }

    public void addLeaf(ILeaf entity) {
        if (!this.namespaceSeparator.V1972()) {
            this.leafsByCode.put(entity.getCodeGetName(), entity);
        }
        this.leafs2.put(entity.getIdent(), entity);
        if (this.namespaceSeparator.V1972()) {
            this.ensureParentIsCreated(entity.getIdent());
        }
    }

    public void addGroup(IGroup group) {
        if (!this.namespaceSeparator.V1972()) {
            this.groupsByCode.put(group.getCodeGetName(), group);
        }
        this.groups2.put(group.getIdent(), group);
        if (this.namespaceSeparator.V1972()) {
            this.ensureParentIsCreated(group.getIdent());
        }
    }

    private void ensureParentIsCreated(Ident ident) {
        if (this.groups2.get(ident.parent()) != null) {
            return;
        }
        this.getParentContainer(ident, null);
    }

    void removeGroup(String name) {
        if (this.namespaceSeparator.V1972()) {
            throw new UnsupportedOperationException();
        }
        IEntity removed = this.groupsByCode.remove(name);
        if (removed == null) {
            throw new IllegalArgumentException();
        }
        IEntity removed2 = this.groups2.remove(removed.getIdent());
        if (removed != removed2) {
            EntityFactory.bigError();
        }
    }

    void removeGroup(Ident ident) {
        IEntity removed = this.groups2.remove(ident);
        if (removed == null) {
            throw new IllegalArgumentException();
        }
    }

    public static void bigError() {
    }

    void removeLeaf(String name) {
        if (this.namespaceSeparator.V1972()) {
            throw new UnsupportedOperationException();
        }
        IEntity removed = this.leafsByCode.remove(name);
        if (removed == null) {
            throw new IllegalArgumentException();
        }
        IEntity removed2 = this.leafs2.remove(removed.getIdent());
        if (removed != removed2) {
            EntityFactory.bigError();
        }
    }

    void removeLeaf(Ident ident) {
        IEntity removed = this.leafs2.remove(ident);
        if (removed == null) {
            System.err.println("leafs2=" + this.leafs2.keySet());
            throw new IllegalArgumentException(ident.toString());
        }
    }

    private void removeLeaf1972(ILeaf leaf) {
        boolean removed = this.leafs2.values().remove(leaf);
        if (!removed) {
            System.err.println("leafs2=" + this.leafs2.keySet());
            throw new IllegalArgumentException(leaf.toString());
        }
    }

    public IGroup muteToGroup(String name, Code namespace, GroupType type, IGroup parent) {
        if (this.namespaceSeparator.V1972()) {
            throw new UnsupportedOperationException();
        }
        ILeaf leaf = this.leafsByCode.get(name);
        ((EntityImpl)leaf).muteToGroup(namespace, type, parent);
        IGroup result = (IGroup)((Object)leaf);
        this.removeLeaf(name);
        return result;
    }

    public IGroup muteToGroup1972(Ident ident, Code namespace, GroupType type, IGroup parent) {
        if (!this.namespaceSeparator.V1972()) {
            throw new UnsupportedOperationException();
        }
        ILeaf leaf = this.namespaceSeparator.getNamespaceSeparator() == null ? this.getLeafVerySmart(ident) : this.leafs2.get(ident);
        ((EntityImpl)leaf).muteToGroup(namespace, type, parent);
        IGroup result = (IGroup)((Object)leaf);
        this.removeLeaf1972(leaf);
        return result;
    }

    public IGroup getRootGroup() {
        return this.rootGroup;
    }

    public final ILeaf getLeafStrict(Ident ident) {
        return this.leafs2.get(ident);
    }

    public final ILeaf getLeafSmart(Ident ident) {
        if (!this.namespaceSeparator.V1972()) {
            throw new UnsupportedOperationException();
        }
        ILeaf result = this.leafs2.get(ident);
        if (result == null && ident.size() == 1) {
            for (Map.Entry<Ident, ILeaf> ent : this.leafs2.entrySet()) {
                if (!ent.getKey().getLast().equals(ident.getLast())) continue;
                return ent.getValue();
            }
        }
        return result;
    }

    public final ILeaf getLeafVerySmart(Ident ident) {
        if (!this.namespaceSeparator.V1972()) {
            throw new UnsupportedOperationException();
        }
        ILeaf result = this.leafs2.get(ident);
        if (result == null) {
            for (Map.Entry<Ident, ILeaf> ent : this.leafs2.entrySet()) {
                if (!ent.getKey().getLast().equals(ident.getLast())) continue;
                return ent.getValue();
            }
        }
        return result;
    }

    public Ident buildFullyQualified(Ident currentPath, Ident id) {
        if (!currentPath.equals(id) && (this.leafs2.containsKey(id) || this.groups2.containsKey(id))) {
            return id;
        }
        if (id.size() > 1) {
            return id;
        }
        return currentPath.add(id);
    }

    public final IGroup getGroupStrict(Ident ident) {
        if (this.namespaceSeparator.getNamespaceSeparator() == null) {
            return this.getGroupVerySmart(ident);
        }
        IGroup result = this.groups2.get(ident);
        return result;
    }

    public final IGroup getGroupVerySmart(Ident ident) {
        IGroup result = this.groups2.get(ident);
        if (result == null) {
            for (Map.Entry<Ident, IGroup> ent : this.groups2.entrySet()) {
                if (!ent.getKey().getLast().equals(ident.getLast())) continue;
                return ent.getValue();
            }
        }
        return result;
    }

    public final ILeaf getLeaf(Code code) {
        if (this.namespaceSeparator.V1972()) {
            throw new UnsupportedOperationException();
        }
        ILeaf result = this.leafsByCode.get(code.getName());
        if (result != null && result != this.leafs2.get(result.getIdent())) {
            EntityFactory.bigError();
        }
        return result;
    }

    public final IGroup getGroup(Code code) {
        if (this.namespaceSeparator.V1972()) {
            throw new UnsupportedOperationException();
        }
        IGroup result = this.groupsByCode.get(code.getName());
        if (result != null && result != this.groups2.get(result.getIdent())) {
            EntityFactory.bigError();
        }
        return result;
    }

    public final Collection<ILeaf> leafs() {
        if (this.namespaceSeparator.V1972()) {
            return this.leafs2();
        }
        Collection<ILeaf> result = Collections.unmodifiableCollection(this.leafsByCode.values());
        if (!new ArrayList<ILeaf>(result).equals(new ArrayList<ILeaf>(this.leafs2()))) {
            EntityFactory.bigError();
        }
        return result;
    }

    public final Collection<IGroup> groups() {
        if (this.namespaceSeparator.V1972()) {
            return this.groups2();
        }
        Collection<IGroup> result = Collections.unmodifiableCollection(this.groupsByCode.values());
        if (!new ArrayList<IGroup>(result).equals(new ArrayList<IGroup>(this.groups2()))) {
            EntityFactory.bigError();
        }
        return result;
    }

    public final Collection<IGroup> groups2() {
        Collection<IGroup> result = Collections.unmodifiableCollection(this.groups2.values());
        return Collections.unmodifiableCollection(result);
    }

    public final Collection<ILeaf> leafs2() {
        Collection<ILeaf> result = Collections.unmodifiableCollection(this.leafs2.values());
        return Collections.unmodifiableCollection(result);
    }

    public void incRawLayout() {
        ++this.rawLayout;
    }

    public final List<Link> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public void addLink(Link link) {
        if (link.isSingle() && this.containsSimilarLink(link)) {
            return;
        }
        this.links.add(link);
    }

    private boolean containsSimilarLink(Link other) {
        for (Link link : this.links) {
            if (!other.sameConnections(link)) continue;
            return true;
        }
        return false;
    }

    public void removeLink(Link link) {
        boolean ok = this.links.remove(link);
        if (!ok) {
            throw new IllegalArgumentException();
        }
    }

    public IGroup getParentContainer(Ident ident, IGroup parentContainer) {
        if (this.namespaceSeparator.V1972()) {
            Ident parent = ident.parent();
            if (parent.isRoot()) {
                return this.rootGroup;
            }
            IGroup result = this.getGroupStrict(parent);
            if (result != null) {
                return result;
            }
            System.err.println("getParentContainer::groups2=" + this.groups2);
            result = this.createGroup(parent, parent, Display.getWithNewlines(parent.getName()), null, GroupType.PACKAGE, null, Collections.<VisibilityModifier>emptySet(), this.namespaceSeparator.getNamespaceSeparator());
            this.addGroup(result);
            return result;
        }
        if (parentContainer == null) {
            throw new IllegalArgumentException();
        }
        return parentContainer;
    }
}

