/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.style.AutomaticCounter;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.Value;
import net.sourceforge.plantuml.style.ValueImpl;

public class FromSkinparamToStyle {
    private static final Map<String, List<Data>> knowlegde = new HashMap<String, List<Data>>();
    private final List<Style> styles = new ArrayList<Style>();
    private String stereo = null;

    public FromSkinparamToStyle(String key, String value, AutomaticCounter counter) {
        List<Data> datas;
        if (value.equals("right:right")) {
            value = "right";
        }
        if (key.contains("<<")) {
            StringTokenizer st = new StringTokenizer(key, "<>");
            key = st.nextToken();
            this.stereo = st.nextToken();
        }
        if ((datas = knowlegde.get(key.toLowerCase())) != null) {
            for (Data data : datas) {
                this.addStyle(data.propertyName, new ValueImpl(value, counter), data.styleNames);
            }
        } else if (key.equalsIgnoreCase("shadowing")) {
            this.addStyle(PName.Shadowing, this.getShadowingValue(value, counter), SName.root);
        } else if (key.equalsIgnoreCase("noteshadowing")) {
            this.addStyle(PName.Shadowing, this.getShadowingValue(value, counter), SName.root, SName.note);
        }
    }

    private ValueImpl getShadowingValue(String value, AutomaticCounter counter) {
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no")) {
            return new ValueImpl("0", counter);
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
            return new ValueImpl("3", counter);
        }
        return new ValueImpl(value, counter);
    }

    private void addStyle(PName propertyName, Value value, SName ... styleNames) {
        EnumMap<PName, Value> map = new EnumMap<PName, Value>(PName.class);
        map.put(propertyName, value);
        StyleSignature sig = StyleSignature.of(styleNames);
        if (this.stereo != null) {
            sig = sig.add(this.stereo);
        }
        this.styles.add(new Style(sig, map));
    }

    public List<Style> getStyles() {
        return Collections.unmodifiableList(this.styles);
    }

    private static void addConvert(String skinparam, PName propertyName, SName ... styleNames) {
        List<Data> datas = knowlegde.get(skinparam = skinparam.toLowerCase());
        if (datas == null) {
            datas = new ArrayList<Data>();
            knowlegde.put(skinparam, datas);
        }
        datas.add(new Data(propertyName, styleNames));
    }

    private static void addConFont(String skinparam, SName ... styleNames) {
        FromSkinparamToStyle.addConvert(skinparam + "FontSize", PName.FontSize, styleNames);
        FromSkinparamToStyle.addConvert(skinparam + "FontStyle", PName.FontStyle, styleNames);
        FromSkinparamToStyle.addConvert(skinparam + "FontColor", PName.FontColor, styleNames);
        FromSkinparamToStyle.addConvert(skinparam + "FontName", PName.FontName, styleNames);
    }

    static {
        FromSkinparamToStyle.addConvert("participantClickableBackgroundColor", PName.BackGroundColor, SName.participant, SName.clickable);
        FromSkinparamToStyle.addConvert("participantClickableBorderColor", PName.LineColor, SName.participant, SName.clickable);
        FromSkinparamToStyle.addConvert("participantBackgroundColor", PName.BackGroundColor, SName.participant);
        FromSkinparamToStyle.addConvert("participantBorderColor", PName.LineColor, SName.participant);
        FromSkinparamToStyle.addConvert("participantBorderThickness", PName.LineThickness, SName.participant);
        FromSkinparamToStyle.addConFont("participant", SName.participant);
        FromSkinparamToStyle.addConvert("boundaryBackgroundColor", PName.BackGroundColor, SName.boundary);
        FromSkinparamToStyle.addConvert("boundaryBorderColor", PName.LineColor, SName.boundary);
        FromSkinparamToStyle.addConvert("boundaryBorderThickness", PName.LineThickness, SName.boundary);
        FromSkinparamToStyle.addConFont("boundary", SName.boundary);
        FromSkinparamToStyle.addConvert("controlBackgroundColor", PName.BackGroundColor, SName.control);
        FromSkinparamToStyle.addConvert("controlBorderColor", PName.LineColor, SName.control);
        FromSkinparamToStyle.addConvert("controlBorderThickness", PName.LineThickness, SName.control);
        FromSkinparamToStyle.addConFont("control", SName.control);
        FromSkinparamToStyle.addConvert("collectionsBackgroundColor", PName.BackGroundColor, SName.collections);
        FromSkinparamToStyle.addConvert("collectionsBorderColor", PName.LineColor, SName.collections);
        FromSkinparamToStyle.addConvert("collectionsBorderThickness", PName.LineThickness, SName.collections);
        FromSkinparamToStyle.addConFont("collections", SName.collections);
        FromSkinparamToStyle.addConvert("actorBackgroundColor", PName.BackGroundColor, SName.actor);
        FromSkinparamToStyle.addConvert("actorBorderColor", PName.LineColor, SName.actor);
        FromSkinparamToStyle.addConvert("actorBorderThickness", PName.LineThickness, SName.actor);
        FromSkinparamToStyle.addConFont("actor", SName.actor);
        FromSkinparamToStyle.addConvert("databaseBackgroundColor", PName.BackGroundColor, SName.database);
        FromSkinparamToStyle.addConvert("databaseBorderColor", PName.LineColor, SName.database);
        FromSkinparamToStyle.addConvert("databaseBorderThickness", PName.LineThickness, SName.database);
        FromSkinparamToStyle.addConFont("database", SName.database);
        FromSkinparamToStyle.addConvert("entityBackgroundColor", PName.BackGroundColor, SName.entity);
        FromSkinparamToStyle.addConvert("entityBorderColor", PName.LineColor, SName.entity);
        FromSkinparamToStyle.addConvert("entityBorderThickness", PName.LineThickness, SName.entity);
        FromSkinparamToStyle.addConFont("entity", SName.entity);
        FromSkinparamToStyle.addConFont("footer", SName.footer);
        FromSkinparamToStyle.addConvert("sequenceStereotypeFontSize", PName.FontSize, SName.stereotype);
        FromSkinparamToStyle.addConvert("sequenceStereotypeFontStyle", PName.FontStyle, SName.stereotype);
        FromSkinparamToStyle.addConvert("sequenceStereotypeFontColor", PName.FontColor, SName.stereotype);
        FromSkinparamToStyle.addConvert("sequenceStereotypeFontName", PName.FontName, SName.stereotype);
        FromSkinparamToStyle.addConvert("SequenceReferenceBorderColor", PName.LineColor, SName.reference);
        FromSkinparamToStyle.addConvert("SequenceReferenceBorderColor", PName.LineColor, SName.referenceHeader);
        FromSkinparamToStyle.addConvert("SequenceReferenceBackgroundColor", PName.BackGroundColor, SName.reference);
        FromSkinparamToStyle.addConvert("sequenceReferenceHeaderBackgroundColor", PName.BackGroundColor, SName.referenceHeader);
        FromSkinparamToStyle.addConFont("sequenceReference", SName.reference);
        FromSkinparamToStyle.addConFont("sequenceReference", SName.referenceHeader);
        FromSkinparamToStyle.addConvert("sequenceGroupBorderThickness", PName.LineThickness, SName.group);
        FromSkinparamToStyle.addConvert("SequenceGroupBorderColor", PName.LineColor, SName.group);
        FromSkinparamToStyle.addConvert("SequenceGroupBorderColor", PName.LineColor, SName.groupHeader);
        FromSkinparamToStyle.addConvert("SequenceGroupBackgroundColor", PName.BackGroundColor, SName.groupHeader);
        FromSkinparamToStyle.addConFont("SequenceGroup", SName.group);
        FromSkinparamToStyle.addConFont("SequenceGroupHeader", SName.groupHeader);
        FromSkinparamToStyle.addConvert("SequenceBoxBorderColor", PName.LineColor, SName.box);
        FromSkinparamToStyle.addConvert("SequenceBoxBackgroundColor", PName.BackGroundColor, SName.box);
        FromSkinparamToStyle.addConvert("SequenceLifeLineBorderColor", PName.LineColor, SName.lifeLine);
        FromSkinparamToStyle.addConvert("SequenceLifeLineBackgroundColor", PName.BackGroundColor, SName.lifeLine);
        FromSkinparamToStyle.addConvert("sequenceDividerBackgroundColor", PName.BackGroundColor, SName.separator);
        FromSkinparamToStyle.addConvert("sequenceDividerBorderColor", PName.LineColor, SName.separator);
        FromSkinparamToStyle.addConFont("sequenceDivider", SName.separator);
        FromSkinparamToStyle.addConvert("sequenceDividerBorderThickness", PName.LineThickness, SName.separator);
        FromSkinparamToStyle.addConvert("SequenceMessageAlignment", PName.HorizontalAlignment, SName.arrow);
        FromSkinparamToStyle.addConFont("note", SName.note);
        FromSkinparamToStyle.addConvert("noteBorderThickness", PName.LineThickness, SName.note);
        FromSkinparamToStyle.addConvert("noteBackgroundColor", PName.BackGroundColor, SName.note);
        FromSkinparamToStyle.addConvert("packageBackgroundColor", PName.BackGroundColor, SName.group);
        FromSkinparamToStyle.addConvert("packageBorderColor", PName.LineColor, SName.group);
        FromSkinparamToStyle.addConvert("PartitionBorderColor", PName.LineColor, SName.partition);
        FromSkinparamToStyle.addConvert("PartitionBackgroundColor", PName.BackGroundColor, SName.partition);
        FromSkinparamToStyle.addConFont("Partition", SName.partition);
        FromSkinparamToStyle.addConvert("hyperlinkColor", PName.HyperLinkColor, SName.root);
        FromSkinparamToStyle.addConvert("activityStartColor", PName.LineColor, SName.circle);
        FromSkinparamToStyle.addConvert("activityBarColor", PName.LineColor, SName.activityBar);
        FromSkinparamToStyle.addConvert("activityBorderColor", PName.LineColor, SName.activity);
        FromSkinparamToStyle.addConvert("activityBorderThickness", PName.LineThickness, SName.activity);
        FromSkinparamToStyle.addConvert("activityBackgroundColor", PName.BackGroundColor, SName.activity);
        FromSkinparamToStyle.addConFont("activity", SName.activity);
        FromSkinparamToStyle.addConvert("activityDiamondBackgroundColor", PName.BackGroundColor, SName.diamond);
        FromSkinparamToStyle.addConvert("activityDiamondBorderColor", PName.LineColor, SName.diamond);
        FromSkinparamToStyle.addConFont("activityDiamond", SName.diamond);
        FromSkinparamToStyle.addConvert("arrowColor", PName.LineColor, SName.arrow);
        FromSkinparamToStyle.addConFont("arrow", SName.arrow);
        FromSkinparamToStyle.addConvert("arrowThickness", PName.LineThickness, SName.arrow);
        FromSkinparamToStyle.addConvert("arrowColor", PName.LineColor, SName.arrow);
        FromSkinparamToStyle.addConvert("arrowStyle", PName.LineStyle, SName.arrow);
        FromSkinparamToStyle.addConvert("defaulttextalignment", PName.HorizontalAlignment, SName.root);
        FromSkinparamToStyle.addConvert("defaultFontName", PName.FontName, SName.root);
        FromSkinparamToStyle.addConFont("SwimlaneTitle", SName.swimlane);
        FromSkinparamToStyle.addConvert("SwimlaneTitleBackgroundColor", PName.BackGroundColor, SName.swimlane);
        FromSkinparamToStyle.addConvert("SwimlaneBorderColor", PName.LineColor, SName.swimlane);
        FromSkinparamToStyle.addConvert("SwimlaneBorderThickness", PName.LineThickness, SName.swimlane);
        FromSkinparamToStyle.addConvert("roundCorner", PName.RoundCorner, SName.root);
        FromSkinparamToStyle.addConvert("titleBorderThickness", PName.LineThickness, SName.title);
        FromSkinparamToStyle.addConvert("titleBorderColor", PName.LineColor, SName.title);
        FromSkinparamToStyle.addConvert("titleBackgroundColor", PName.BackGroundColor, SName.title);
        FromSkinparamToStyle.addConvert("titleBorderRoundCorner", PName.RoundCorner, SName.title);
        FromSkinparamToStyle.addConFont("title", SName.title);
        FromSkinparamToStyle.addConvert("legendBorderThickness", PName.LineThickness, SName.legend);
        FromSkinparamToStyle.addConvert("legendBorderColor", PName.LineColor, SName.legend);
        FromSkinparamToStyle.addConvert("legendBackgroundColor", PName.BackGroundColor, SName.legend);
        FromSkinparamToStyle.addConvert("legendBorderRoundCorner", PName.RoundCorner, SName.legend);
        FromSkinparamToStyle.addConFont("legend", SName.legend);
        FromSkinparamToStyle.addConvert("noteTextAlignment", PName.HorizontalAlignment, SName.note);
    }

    static class Data {
        private final PName propertyName;
        private final SName[] styleNames;

        Data(PName propertyName, SName[] styleNames) {
            this.propertyName = propertyName;
            this.styleNames = styleNames;
        }
    }
}

