/*
    Generated by sbus code generator

    Copyright (C) 2017 Red Hat

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <errno.h>
#include <talloc.h>
#include <tevent.h>
#include <dbus/dbus.h>

#include "sbus/sbus_private.h"
#include "sbus/interface/sbus_iterator_readers.h"
#include "sbus/interface_dbus/sbus_dbus_client_async.h"
#include "sss_iface/sbus_sss_arguments.h"
#include "sss_iface/sbus_sss_keygens.h"
#include "sss_iface/sbus_sss_client_properties.h"

struct sbus_method_in__out__state {
    int dummy;
};

static void sbus_method_in__out__done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in__out__send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     sbus_invoker_keygen keygen,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method)
{
    struct sbus_method_in__out__state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in__out__state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }


    subreq = sbus_call_method_send(state, conn, NULL, keygen, NULL,
                                   bus, path, iface, method, NULL);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in__out__done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in__out__done(struct tevent_req *subreq)
{
    struct sbus_method_in__out__state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in__out__state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in__out__recv
    (struct tevent_req *req)
{
    TEVENT_REQ_RETURN_ON_ERROR(req);

    return EOK;
}

struct sbus_method_in_pam_data_out_pam_response_state {
    struct _sbus_sss_invoker_args_pam_data in;
    struct _sbus_sss_invoker_args_pam_response *out;
};

static void sbus_method_in_pam_data_out_pam_response_done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in_pam_data_out_pam_response_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     sbus_invoker_keygen keygen,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     struct pam_data * arg0)
{
    struct sbus_method_in_pam_data_out_pam_response_state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in_pam_data_out_pam_response_state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }

    state->out = talloc_zero(state, struct _sbus_sss_invoker_args_pam_response);
    if (state->out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    state->in.arg0 = arg0;

    subreq = sbus_call_method_send(state, conn, NULL, keygen,
                                   (sbus_invoker_writer_fn)_sbus_sss_invoker_write_pam_data,
                                   bus, path, iface, method, &state->in);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in_pam_data_out_pam_response_done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in_pam_data_out_pam_response_done(struct tevent_req *subreq)
{
    struct sbus_method_in_pam_data_out_pam_response_state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in_pam_data_out_pam_response_state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    ret = sbus_read_output(state->out, reply, (sbus_invoker_reader_fn)_sbus_sss_invoker_read_pam_response, state->out);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in_pam_data_out_pam_response_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     struct pam_data ** _arg0)
{
    struct sbus_method_in_pam_data_out_pam_response_state *state;
    state = tevent_req_data(req, struct sbus_method_in_pam_data_out_pam_response_state);

    TEVENT_REQ_RETURN_ON_ERROR(req);

    *_arg0 = talloc_steal(mem_ctx, state->out->arg0);

    return EOK;
}

struct sbus_method_in_raw_out_qus_state {
    struct _sbus_sss_invoker_args_qus *out;
};

static void sbus_method_in_raw_out_qus_done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in_raw_out_qus_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     DBusMessage *raw_message)
{
    struct sbus_method_in_raw_out_qus_state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in_raw_out_qus_state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }

    state->out = talloc_zero(state, struct _sbus_sss_invoker_args_qus);
    if (state->out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }


    subreq = sbus_call_method_send(state, conn, raw_message, NULL, NULL, NULL,
                                   dbus_message_get_path(raw_message),
                                   dbus_message_get_interface(raw_message),
                                   dbus_message_get_member(raw_message), NULL);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in_raw_out_qus_done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in_raw_out_qus_done(struct tevent_req *subreq)
{
    struct sbus_method_in_raw_out_qus_state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in_raw_out_qus_state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    ret = sbus_read_output(state->out, reply, (sbus_invoker_reader_fn)_sbus_sss_invoker_read_qus, state->out);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in_raw_out_qus_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     uint16_t* _arg0,
     uint32_t* _arg1,
     const char ** _arg2)
{
    struct sbus_method_in_raw_out_qus_state *state;
    state = tevent_req_data(req, struct sbus_method_in_raw_out_qus_state);

    TEVENT_REQ_RETURN_ON_ERROR(req);

    *_arg0 = state->out->arg0;
    *_arg1 = state->out->arg1;
    *_arg2 = talloc_steal(mem_ctx, state->out->arg2);

    return EOK;
}

struct sbus_method_in_s_out__state {
    struct _sbus_sss_invoker_args_s in;
};

static void sbus_method_in_s_out__done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in_s_out__send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     sbus_invoker_keygen keygen,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0)
{
    struct sbus_method_in_s_out__state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in_s_out__state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }

    state->in.arg0 = arg0;

    subreq = sbus_call_method_send(state, conn, NULL, keygen,
                                   (sbus_invoker_writer_fn)_sbus_sss_invoker_write_s,
                                   bus, path, iface, method, &state->in);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in_s_out__done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in_s_out__done(struct tevent_req *subreq)
{
    struct sbus_method_in_s_out__state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in_s_out__state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in_s_out__recv
    (struct tevent_req *req)
{
    TEVENT_REQ_RETURN_ON_ERROR(req);

    return EOK;
}

struct sbus_method_in_s_out_as_state {
    struct _sbus_sss_invoker_args_s in;
    struct _sbus_sss_invoker_args_as *out;
};

static void sbus_method_in_s_out_as_done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in_s_out_as_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     sbus_invoker_keygen keygen,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0)
{
    struct sbus_method_in_s_out_as_state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in_s_out_as_state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }

    state->out = talloc_zero(state, struct _sbus_sss_invoker_args_as);
    if (state->out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    state->in.arg0 = arg0;

    subreq = sbus_call_method_send(state, conn, NULL, keygen,
                                   (sbus_invoker_writer_fn)_sbus_sss_invoker_write_s,
                                   bus, path, iface, method, &state->in);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in_s_out_as_done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in_s_out_as_done(struct tevent_req *subreq)
{
    struct sbus_method_in_s_out_as_state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in_s_out_as_state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    ret = sbus_read_output(state->out, reply, (sbus_invoker_reader_fn)_sbus_sss_invoker_read_as, state->out);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in_s_out_as_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     const char *** _arg0)
{
    struct sbus_method_in_s_out_as_state *state;
    state = tevent_req_data(req, struct sbus_method_in_s_out_as_state);

    TEVENT_REQ_RETURN_ON_ERROR(req);

    *_arg0 = talloc_steal(mem_ctx, state->out->arg0);

    return EOK;
}

struct sbus_method_in_s_out_b_state {
    struct _sbus_sss_invoker_args_s in;
    struct _sbus_sss_invoker_args_b *out;
};

static void sbus_method_in_s_out_b_done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in_s_out_b_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     sbus_invoker_keygen keygen,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0)
{
    struct sbus_method_in_s_out_b_state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in_s_out_b_state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }

    state->out = talloc_zero(state, struct _sbus_sss_invoker_args_b);
    if (state->out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    state->in.arg0 = arg0;

    subreq = sbus_call_method_send(state, conn, NULL, keygen,
                                   (sbus_invoker_writer_fn)_sbus_sss_invoker_write_s,
                                   bus, path, iface, method, &state->in);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in_s_out_b_done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in_s_out_b_done(struct tevent_req *subreq)
{
    struct sbus_method_in_s_out_b_state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in_s_out_b_state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    ret = sbus_read_output(state->out, reply, (sbus_invoker_reader_fn)_sbus_sss_invoker_read_b, state->out);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in_s_out_b_recv
    (struct tevent_req *req,
     bool* _arg0)
{
    struct sbus_method_in_s_out_b_state *state;
    state = tevent_req_data(req, struct sbus_method_in_s_out_b_state);

    TEVENT_REQ_RETURN_ON_ERROR(req);

    *_arg0 = state->out->arg0;

    return EOK;
}

struct sbus_method_in_s_out_qus_state {
    struct _sbus_sss_invoker_args_s in;
    struct _sbus_sss_invoker_args_qus *out;
};

static void sbus_method_in_s_out_qus_done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in_s_out_qus_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     sbus_invoker_keygen keygen,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0)
{
    struct sbus_method_in_s_out_qus_state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in_s_out_qus_state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }

    state->out = talloc_zero(state, struct _sbus_sss_invoker_args_qus);
    if (state->out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    state->in.arg0 = arg0;

    subreq = sbus_call_method_send(state, conn, NULL, keygen,
                                   (sbus_invoker_writer_fn)_sbus_sss_invoker_write_s,
                                   bus, path, iface, method, &state->in);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in_s_out_qus_done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in_s_out_qus_done(struct tevent_req *subreq)
{
    struct sbus_method_in_s_out_qus_state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in_s_out_qus_state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    ret = sbus_read_output(state->out, reply, (sbus_invoker_reader_fn)_sbus_sss_invoker_read_qus, state->out);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in_s_out_qus_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     uint16_t* _arg0,
     uint32_t* _arg1,
     const char ** _arg2)
{
    struct sbus_method_in_s_out_qus_state *state;
    state = tevent_req_data(req, struct sbus_method_in_s_out_qus_state);

    TEVENT_REQ_RETURN_ON_ERROR(req);

    *_arg0 = state->out->arg0;
    *_arg1 = state->out->arg1;
    *_arg2 = talloc_steal(mem_ctx, state->out->arg2);

    return EOK;
}

struct sbus_method_in_s_out_s_state {
    struct _sbus_sss_invoker_args_s in;
    struct _sbus_sss_invoker_args_s *out;
};

static void sbus_method_in_s_out_s_done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in_s_out_s_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     sbus_invoker_keygen keygen,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0)
{
    struct sbus_method_in_s_out_s_state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in_s_out_s_state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }

    state->out = talloc_zero(state, struct _sbus_sss_invoker_args_s);
    if (state->out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    state->in.arg0 = arg0;

    subreq = sbus_call_method_send(state, conn, NULL, keygen,
                                   (sbus_invoker_writer_fn)_sbus_sss_invoker_write_s,
                                   bus, path, iface, method, &state->in);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in_s_out_s_done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in_s_out_s_done(struct tevent_req *subreq)
{
    struct sbus_method_in_s_out_s_state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in_s_out_s_state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    ret = sbus_read_output(state->out, reply, (sbus_invoker_reader_fn)_sbus_sss_invoker_read_s, state->out);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in_s_out_s_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     const char ** _arg0)
{
    struct sbus_method_in_s_out_s_state *state;
    state = tevent_req_data(req, struct sbus_method_in_s_out_s_state);

    TEVENT_REQ_RETURN_ON_ERROR(req);

    *_arg0 = talloc_steal(mem_ctx, state->out->arg0);

    return EOK;
}

struct sbus_method_in_sqq_out_q_state {
    struct _sbus_sss_invoker_args_sqq in;
    struct _sbus_sss_invoker_args_q *out;
};

static void sbus_method_in_sqq_out_q_done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in_sqq_out_q_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     sbus_invoker_keygen keygen,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0,
     uint16_t arg1,
     uint16_t arg2)
{
    struct sbus_method_in_sqq_out_q_state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in_sqq_out_q_state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }

    state->out = talloc_zero(state, struct _sbus_sss_invoker_args_q);
    if (state->out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    state->in.arg0 = arg0;
    state->in.arg1 = arg1;
    state->in.arg2 = arg2;

    subreq = sbus_call_method_send(state, conn, NULL, keygen,
                                   (sbus_invoker_writer_fn)_sbus_sss_invoker_write_sqq,
                                   bus, path, iface, method, &state->in);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in_sqq_out_q_done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in_sqq_out_q_done(struct tevent_req *subreq)
{
    struct sbus_method_in_sqq_out_q_state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in_sqq_out_q_state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    ret = sbus_read_output(state->out, reply, (sbus_invoker_reader_fn)_sbus_sss_invoker_read_q, state->out);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in_sqq_out_q_recv
    (struct tevent_req *req,
     uint16_t* _arg0)
{
    struct sbus_method_in_sqq_out_q_state *state;
    state = tevent_req_data(req, struct sbus_method_in_sqq_out_q_state);

    TEVENT_REQ_RETURN_ON_ERROR(req);

    *_arg0 = state->out->arg0;

    return EOK;
}

struct sbus_method_in_ssau_out__state {
    struct _sbus_sss_invoker_args_ssau in;
};

static void sbus_method_in_ssau_out__done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in_ssau_out__send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     sbus_invoker_keygen keygen,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0,
     const char * arg1,
     uint32_t * arg2)
{
    struct sbus_method_in_ssau_out__state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in_ssau_out__state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }

    state->in.arg0 = arg0;
    state->in.arg1 = arg1;
    state->in.arg2 = arg2;

    subreq = sbus_call_method_send(state, conn, NULL, keygen,
                                   (sbus_invoker_writer_fn)_sbus_sss_invoker_write_ssau,
                                   bus, path, iface, method, &state->in);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in_ssau_out__done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in_ssau_out__done(struct tevent_req *subreq)
{
    struct sbus_method_in_ssau_out__state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in_ssau_out__state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in_ssau_out__recv
    (struct tevent_req *req)
{
    TEVENT_REQ_RETURN_ON_ERROR(req);

    return EOK;
}

struct sbus_method_in_u_out__state {
    struct _sbus_sss_invoker_args_u in;
};

static void sbus_method_in_u_out__done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in_u_out__send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     sbus_invoker_keygen keygen,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     uint32_t arg0)
{
    struct sbus_method_in_u_out__state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in_u_out__state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }

    state->in.arg0 = arg0;

    subreq = sbus_call_method_send(state, conn, NULL, keygen,
                                   (sbus_invoker_writer_fn)_sbus_sss_invoker_write_u,
                                   bus, path, iface, method, &state->in);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in_u_out__done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in_u_out__done(struct tevent_req *subreq)
{
    struct sbus_method_in_u_out__state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in_u_out__state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in_u_out__recv
    (struct tevent_req *req)
{
    TEVENT_REQ_RETURN_ON_ERROR(req);

    return EOK;
}

struct sbus_method_in_us_out__state {
    struct _sbus_sss_invoker_args_us in;
};

static void sbus_method_in_us_out__done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in_us_out__send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     sbus_invoker_keygen keygen,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     uint32_t arg0,
     const char * arg1)
{
    struct sbus_method_in_us_out__state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in_us_out__state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }

    state->in.arg0 = arg0;
    state->in.arg1 = arg1;

    subreq = sbus_call_method_send(state, conn, NULL, keygen,
                                   (sbus_invoker_writer_fn)_sbus_sss_invoker_write_us,
                                   bus, path, iface, method, &state->in);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in_us_out__done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in_us_out__done(struct tevent_req *subreq)
{
    struct sbus_method_in_us_out__state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in_us_out__state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in_us_out__recv
    (struct tevent_req *req)
{
    TEVENT_REQ_RETURN_ON_ERROR(req);

    return EOK;
}

struct sbus_method_in_usq_out__state {
    struct _sbus_sss_invoker_args_usq in;
};

static void sbus_method_in_usq_out__done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in_usq_out__send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     sbus_invoker_keygen keygen,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     uint32_t arg0,
     const char * arg1,
     uint16_t arg2)
{
    struct sbus_method_in_usq_out__state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in_usq_out__state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }

    state->in.arg0 = arg0;
    state->in.arg1 = arg1;
    state->in.arg2 = arg2;

    subreq = sbus_call_method_send(state, conn, NULL, keygen,
                                   (sbus_invoker_writer_fn)_sbus_sss_invoker_write_usq,
                                   bus, path, iface, method, &state->in);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in_usq_out__done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in_usq_out__done(struct tevent_req *subreq)
{
    struct sbus_method_in_usq_out__state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in_usq_out__state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in_usq_out__recv
    (struct tevent_req *req)
{
    TEVENT_REQ_RETURN_ON_ERROR(req);

    return EOK;
}

struct sbus_method_in_uss_out__state {
    struct _sbus_sss_invoker_args_uss in;
};

static void sbus_method_in_uss_out__done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in_uss_out__send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     sbus_invoker_keygen keygen,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     uint32_t arg0,
     const char * arg1,
     const char * arg2)
{
    struct sbus_method_in_uss_out__state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in_uss_out__state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }

    state->in.arg0 = arg0;
    state->in.arg1 = arg1;
    state->in.arg2 = arg2;

    subreq = sbus_call_method_send(state, conn, NULL, keygen,
                                   (sbus_invoker_writer_fn)_sbus_sss_invoker_write_uss,
                                   bus, path, iface, method, &state->in);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in_uss_out__done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in_uss_out__done(struct tevent_req *subreq)
{
    struct sbus_method_in_uss_out__state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in_uss_out__state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in_uss_out__recv
    (struct tevent_req *req)
{
    TEVENT_REQ_RETURN_ON_ERROR(req);

    return EOK;
}

struct sbus_method_in_uss_out_qus_state {
    struct _sbus_sss_invoker_args_uss in;
    struct _sbus_sss_invoker_args_qus *out;
};

static void sbus_method_in_uss_out_qus_done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in_uss_out_qus_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     sbus_invoker_keygen keygen,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     uint32_t arg0,
     const char * arg1,
     const char * arg2)
{
    struct sbus_method_in_uss_out_qus_state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in_uss_out_qus_state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }

    state->out = talloc_zero(state, struct _sbus_sss_invoker_args_qus);
    if (state->out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    state->in.arg0 = arg0;
    state->in.arg1 = arg1;
    state->in.arg2 = arg2;

    subreq = sbus_call_method_send(state, conn, NULL, keygen,
                                   (sbus_invoker_writer_fn)_sbus_sss_invoker_write_uss,
                                   bus, path, iface, method, &state->in);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in_uss_out_qus_done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in_uss_out_qus_done(struct tevent_req *subreq)
{
    struct sbus_method_in_uss_out_qus_state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in_uss_out_qus_state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    ret = sbus_read_output(state->out, reply, (sbus_invoker_reader_fn)_sbus_sss_invoker_read_qus, state->out);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in_uss_out_qus_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     uint16_t* _arg0,
     uint32_t* _arg1,
     const char ** _arg2)
{
    struct sbus_method_in_uss_out_qus_state *state;
    state = tevent_req_data(req, struct sbus_method_in_uss_out_qus_state);

    TEVENT_REQ_RETURN_ON_ERROR(req);

    *_arg0 = state->out->arg0;
    *_arg1 = state->out->arg1;
    *_arg2 = talloc_steal(mem_ctx, state->out->arg2);

    return EOK;
}

struct sbus_method_in_uus_out_qus_state {
    struct _sbus_sss_invoker_args_uus in;
    struct _sbus_sss_invoker_args_qus *out;
};

static void sbus_method_in_uus_out_qus_done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in_uus_out_qus_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     sbus_invoker_keygen keygen,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     uint32_t arg0,
     uint32_t arg1,
     const char * arg2)
{
    struct sbus_method_in_uus_out_qus_state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in_uus_out_qus_state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }

    state->out = talloc_zero(state, struct _sbus_sss_invoker_args_qus);
    if (state->out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    state->in.arg0 = arg0;
    state->in.arg1 = arg1;
    state->in.arg2 = arg2;

    subreq = sbus_call_method_send(state, conn, NULL, keygen,
                                   (sbus_invoker_writer_fn)_sbus_sss_invoker_write_uus,
                                   bus, path, iface, method, &state->in);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in_uus_out_qus_done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in_uus_out_qus_done(struct tevent_req *subreq)
{
    struct sbus_method_in_uus_out_qus_state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in_uus_out_qus_state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    ret = sbus_read_output(state->out, reply, (sbus_invoker_reader_fn)_sbus_sss_invoker_read_qus, state->out);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in_uus_out_qus_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     uint16_t* _arg0,
     uint32_t* _arg1,
     const char ** _arg2)
{
    struct sbus_method_in_uus_out_qus_state *state;
    state = tevent_req_data(req, struct sbus_method_in_uus_out_qus_state);

    TEVENT_REQ_RETURN_ON_ERROR(req);

    *_arg0 = state->out->arg0;
    *_arg1 = state->out->arg1;
    *_arg2 = talloc_steal(mem_ctx, state->out->arg2);

    return EOK;
}

struct sbus_method_in_uusss_out_qus_state {
    struct _sbus_sss_invoker_args_uusss in;
    struct _sbus_sss_invoker_args_qus *out;
};

static void sbus_method_in_uusss_out_qus_done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in_uusss_out_qus_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     sbus_invoker_keygen keygen,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     uint32_t arg0,
     uint32_t arg1,
     const char * arg2,
     const char * arg3,
     const char * arg4)
{
    struct sbus_method_in_uusss_out_qus_state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in_uusss_out_qus_state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }

    state->out = talloc_zero(state, struct _sbus_sss_invoker_args_qus);
    if (state->out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    state->in.arg0 = arg0;
    state->in.arg1 = arg1;
    state->in.arg2 = arg2;
    state->in.arg3 = arg3;
    state->in.arg4 = arg4;

    subreq = sbus_call_method_send(state, conn, NULL, keygen,
                                   (sbus_invoker_writer_fn)_sbus_sss_invoker_write_uusss,
                                   bus, path, iface, method, &state->in);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in_uusss_out_qus_done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in_uusss_out_qus_done(struct tevent_req *subreq)
{
    struct sbus_method_in_uusss_out_qus_state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in_uusss_out_qus_state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    ret = sbus_read_output(state->out, reply, (sbus_invoker_reader_fn)_sbus_sss_invoker_read_qus, state->out);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in_uusss_out_qus_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     uint16_t* _arg0,
     uint32_t* _arg1,
     const char ** _arg2)
{
    struct sbus_method_in_uusss_out_qus_state *state;
    state = tevent_req_data(req, struct sbus_method_in_uusss_out_qus_state);

    TEVENT_REQ_RETURN_ON_ERROR(req);

    *_arg0 = state->out->arg0;
    *_arg1 = state->out->arg1;
    *_arg2 = talloc_steal(mem_ctx, state->out->arg2);

    return EOK;
}

struct sbus_method_in_uuus_out_qus_state {
    struct _sbus_sss_invoker_args_uuus in;
    struct _sbus_sss_invoker_args_qus *out;
};

static void sbus_method_in_uuus_out_qus_done(struct tevent_req *subreq);

static struct tevent_req *
sbus_method_in_uuus_out_qus_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     sbus_invoker_keygen keygen,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     uint32_t arg0,
     uint32_t arg1,
     uint32_t arg2,
     const char * arg3)
{
    struct sbus_method_in_uuus_out_qus_state *state;
    struct tevent_req *subreq;
    struct tevent_req *req;
    errno_t ret;

    req = tevent_req_create(mem_ctx, &state, struct sbus_method_in_uuus_out_qus_state);
    if (req == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create tevent request!\n");
        return NULL;
    }

    state->out = talloc_zero(state, struct _sbus_sss_invoker_args_qus);
    if (state->out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    state->in.arg0 = arg0;
    state->in.arg1 = arg1;
    state->in.arg2 = arg2;
    state->in.arg3 = arg3;

    subreq = sbus_call_method_send(state, conn, NULL, keygen,
                                   (sbus_invoker_writer_fn)_sbus_sss_invoker_write_uuus,
                                   bus, path, iface, method, &state->in);
    if (subreq == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to create subrequest!\n");
        ret = ENOMEM;
        goto done;
    }

    tevent_req_set_callback(subreq, sbus_method_in_uuus_out_qus_done, req);

    ret = EAGAIN;

done:
    if (ret != EAGAIN) {
        tevent_req_error(req, ret);
        tevent_req_post(req, conn->ev);
    }

    return req;
}

static void sbus_method_in_uuus_out_qus_done(struct tevent_req *subreq)
{
    struct sbus_method_in_uuus_out_qus_state *state;
    struct tevent_req *req;
    DBusMessage *reply;
    errno_t ret;

    req = tevent_req_callback_data(subreq, struct tevent_req);
    state = tevent_req_data(req, struct sbus_method_in_uuus_out_qus_state);

    ret = sbus_call_method_recv(state, subreq, &reply);
    talloc_zfree(subreq);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    ret = sbus_read_output(state->out, reply, (sbus_invoker_reader_fn)_sbus_sss_invoker_read_qus, state->out);
    if (ret != EOK) {
        tevent_req_error(req, ret);
        return;
    }

    tevent_req_done(req);
    return;
}

static errno_t
sbus_method_in_uuus_out_qus_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     uint16_t* _arg0,
     uint32_t* _arg1,
     const char ** _arg2)
{
    struct sbus_method_in_uuus_out_qus_state *state;
    state = tevent_req_data(req, struct sbus_method_in_uuus_out_qus_state);

    TEVENT_REQ_RETURN_ON_ERROR(req);

    *_arg0 = state->out->arg0;
    *_arg1 = state->out->arg1;
    *_arg2 = talloc_steal(mem_ctx, state->out->arg2);

    return EOK;
}

struct tevent_req *
sbus_call_fleet_ProcessSSSDFiles_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t arg_uid,
     const char * arg_user_dir,
     uint16_t arg_prio)
{
    return sbus_method_in_usq_out__send(mem_ctx, conn, NULL,
        busname, object_path, "org.freedesktop.FleetCommanderClient", "ProcessSSSDFiles", arg_uid, arg_user_dir, arg_prio);
}

errno_t
sbus_call_fleet_ProcessSSSDFiles_recv
    (struct tevent_req *req)
{
    return sbus_method_in_usq_out__recv(req);
}

struct tevent_req *
sbus_call_dp_access_RefreshRules_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path)
{
    return sbus_method_in__out__send(mem_ctx, conn, _sbus_sss_key_,
        busname, object_path, "sssd.DataProvider.AccessControl", "RefreshRules");
}

errno_t
sbus_call_dp_access_RefreshRules_recv
    (struct tevent_req *req)
{
    return sbus_method_in__out__recv(req);
}

struct tevent_req *
sbus_call_dp_autofs_Enumerate_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t arg_dp_flags,
     const char * arg_mapname)
{
    return sbus_method_in_us_out__send(mem_ctx, conn, _sbus_sss_key_us_0_1,
        busname, object_path, "sssd.DataProvider.Autofs", "Enumerate", arg_dp_flags, arg_mapname);
}

errno_t
sbus_call_dp_autofs_Enumerate_recv
    (struct tevent_req *req)
{
    return sbus_method_in_us_out__recv(req);
}

struct tevent_req *
sbus_call_dp_autofs_GetEntry_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t arg_dp_flags,
     const char * arg_mapname,
     const char * arg_entryname)
{
    return sbus_method_in_uss_out__send(mem_ctx, conn, _sbus_sss_key_uss_0_1_2,
        busname, object_path, "sssd.DataProvider.Autofs", "GetEntry", arg_dp_flags, arg_mapname, arg_entryname);
}

errno_t
sbus_call_dp_autofs_GetEntry_recv
    (struct tevent_req *req)
{
    return sbus_method_in_uss_out__recv(req);
}

struct tevent_req *
sbus_call_dp_autofs_GetMap_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t arg_dp_flags,
     const char * arg_mapname)
{
    return sbus_method_in_us_out__send(mem_ctx, conn, _sbus_sss_key_us_0_1,
        busname, object_path, "sssd.DataProvider.Autofs", "GetMap", arg_dp_flags, arg_mapname);
}

errno_t
sbus_call_dp_autofs_GetMap_recv
    (struct tevent_req *req)
{
    return sbus_method_in_us_out__recv(req);
}

struct tevent_req *
sbus_call_dp_backend_IsOnline_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_domain_name)
{
    return sbus_method_in_s_out_b_send(mem_ctx, conn, _sbus_sss_key_s_0,
        busname, object_path, "sssd.DataProvider.Backend", "IsOnline", arg_domain_name);
}

errno_t
sbus_call_dp_backend_IsOnline_recv
    (struct tevent_req *req,
     bool* _status)
{
    return sbus_method_in_s_out_b_recv(req, _status);
}

struct tevent_req *
sbus_call_dp_client_Register_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_Name)
{
    return sbus_method_in_s_out__send(mem_ctx, conn, NULL,
        busname, object_path, "sssd.DataProvider.Client", "Register", arg_Name);
}

errno_t
sbus_call_dp_client_Register_recv
    (struct tevent_req *req)
{
    return sbus_method_in_s_out__recv(req);
}

struct tevent_req *
sbus_call_dp_failover_ActiveServer_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_service_name)
{
    return sbus_method_in_s_out_s_send(mem_ctx, conn, _sbus_sss_key_s_0,
        busname, object_path, "sssd.DataProvider.Failover", "ActiveServer", arg_service_name);
}

errno_t
sbus_call_dp_failover_ActiveServer_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     const char ** _server)
{
    return sbus_method_in_s_out_s_recv(mem_ctx, req, _server);
}

struct tevent_req *
sbus_call_dp_failover_ListServers_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_service_name)
{
    return sbus_method_in_s_out_as_send(mem_ctx, conn, _sbus_sss_key_s_0,
        busname, object_path, "sssd.DataProvider.Failover", "ListServers", arg_service_name);
}

errno_t
sbus_call_dp_failover_ListServers_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     const char *** _servers)
{
    return sbus_method_in_s_out_as_recv(mem_ctx, req, _servers);
}

struct tevent_req *
sbus_call_dp_failover_ListServices_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_domain_name)
{
    return sbus_method_in_s_out_as_send(mem_ctx, conn, _sbus_sss_key_s_0,
        busname, object_path, "sssd.DataProvider.Failover", "ListServices", arg_domain_name);
}

errno_t
sbus_call_dp_failover_ListServices_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     const char *** _services)
{
    return sbus_method_in_s_out_as_recv(mem_ctx, req, _services);
}

struct tevent_req *
sbus_call_proxy_auth_PAM_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     struct pam_data * arg_pam_data)
{
    return sbus_method_in_pam_data_out_pam_response_send(mem_ctx, conn, NULL,
        busname, object_path, "sssd.ProxyChild.Auth", "PAM", arg_pam_data);
}

errno_t
sbus_call_proxy_auth_PAM_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     struct pam_data ** _pam_response)
{
    return sbus_method_in_pam_data_out_pam_response_recv(mem_ctx, req, _pam_response);
}

struct tevent_req *
sbus_call_proxy_client_Register_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t arg_ID)
{
    return sbus_method_in_u_out__send(mem_ctx, conn, NULL,
        busname, object_path, "sssd.ProxyChild.Client", "Register", arg_ID);
}

errno_t
sbus_call_proxy_client_Register_recv
    (struct tevent_req *req)
{
    return sbus_method_in_u_out__recv(req);
}

struct tevent_req *
sbus_call_resp_domain_SetActive_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_name)
{
    return sbus_method_in_s_out__send(mem_ctx, conn, _sbus_sss_key_s_0,
        busname, object_path, "sssd.Responder.Domain", "SetActive", arg_name);
}

errno_t
sbus_call_resp_domain_SetActive_recv
    (struct tevent_req *req)
{
    return sbus_method_in_s_out__recv(req);
}

struct tevent_req *
sbus_call_resp_domain_SetInconsistent_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_name)
{
    return sbus_method_in_s_out__send(mem_ctx, conn, _sbus_sss_key_s_0,
        busname, object_path, "sssd.Responder.Domain", "SetInconsistent", arg_name);
}

errno_t
sbus_call_resp_domain_SetInconsistent_recv
    (struct tevent_req *req)
{
    return sbus_method_in_s_out__recv(req);
}

struct tevent_req *
sbus_call_resp_negcache_ResetGroups_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path)
{
    return sbus_method_in__out__send(mem_ctx, conn, _sbus_sss_key_,
        busname, object_path, "sssd.Responder.NegativeCache", "ResetGroups");
}

errno_t
sbus_call_resp_negcache_ResetGroups_recv
    (struct tevent_req *req)
{
    return sbus_method_in__out__recv(req);
}

struct tevent_req *
sbus_call_resp_negcache_ResetUsers_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path)
{
    return sbus_method_in__out__send(mem_ctx, conn, _sbus_sss_key_,
        busname, object_path, "sssd.Responder.NegativeCache", "ResetUsers");
}

errno_t
sbus_call_resp_negcache_ResetUsers_recv
    (struct tevent_req *req)
{
    return sbus_method_in__out__recv(req);
}

struct tevent_req *
sbus_call_dp_dp_getAccountDomain_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t arg_dp_flags,
     uint32_t arg_entry_type,
     const char * arg_filter)
{
    return sbus_method_in_uus_out_qus_send(mem_ctx, conn, _sbus_sss_key_uus_0_1_2,
        busname, object_path, "sssd.dataprovider", "getAccountDomain", arg_dp_flags, arg_entry_type, arg_filter);
}

errno_t
sbus_call_dp_dp_getAccountDomain_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     uint16_t* _dp_error,
     uint32_t* _error,
     const char ** _domain_name)
{
    return sbus_method_in_uus_out_qus_recv(mem_ctx, req, _dp_error, _error, _domain_name);
}

struct tevent_req *
sbus_call_dp_dp_getAccountInfo_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t arg_dp_flags,
     uint32_t arg_entry_type,
     const char * arg_filter,
     const char * arg_domain,
     const char * arg_extra)
{
    return sbus_method_in_uusss_out_qus_send(mem_ctx, conn, _sbus_sss_key_uusss_0_1_2_3_4,
        busname, object_path, "sssd.dataprovider", "getAccountInfo", arg_dp_flags, arg_entry_type, arg_filter, arg_domain, arg_extra);
}

errno_t
sbus_call_dp_dp_getAccountInfo_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     uint16_t* _dp_error,
     uint32_t* _error,
     const char ** _error_message)
{
    return sbus_method_in_uusss_out_qus_recv(mem_ctx, req, _dp_error, _error, _error_message);
}

struct tevent_req *
sbus_call_dp_dp_getDomains_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_domain_hint)
{
    return sbus_method_in_s_out_qus_send(mem_ctx, conn, _sbus_sss_key_s_0,
        busname, object_path, "sssd.dataprovider", "getDomains", arg_domain_hint);
}

errno_t
sbus_call_dp_dp_getDomains_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     uint16_t* _dp_error,
     uint32_t* _error,
     const char ** _error_message)
{
    return sbus_method_in_s_out_qus_recv(mem_ctx, req, _dp_error, _error, _error_message);
}

struct tevent_req *
sbus_call_dp_dp_hostHandler_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t arg_dp_flags,
     const char * arg_name,
     const char * arg_alias)
{
    return sbus_method_in_uss_out_qus_send(mem_ctx, conn, _sbus_sss_key_uss_0_1,
        busname, object_path, "sssd.dataprovider", "hostHandler", arg_dp_flags, arg_name, arg_alias);
}

errno_t
sbus_call_dp_dp_hostHandler_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     uint16_t* _dp_error,
     uint32_t* _error,
     const char ** _error_message)
{
    return sbus_method_in_uss_out_qus_recv(mem_ctx, req, _dp_error, _error, _error_message);
}

struct tevent_req *
sbus_call_dp_dp_pamHandler_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     struct pam_data * arg_pam_data)
{
    return sbus_method_in_pam_data_out_pam_response_send(mem_ctx, conn, NULL,
        busname, object_path, "sssd.dataprovider", "pamHandler", arg_pam_data);
}

errno_t
sbus_call_dp_dp_pamHandler_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     struct pam_data ** _pam_response)
{
    return sbus_method_in_pam_data_out_pam_response_recv(mem_ctx, req, _pam_response);
}

struct tevent_req *
sbus_call_dp_dp_resolverHandler_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t arg_dp_flags,
     uint32_t arg_entry_type,
     uint32_t arg_filter_type,
     const char * arg_filter_value)
{
    return sbus_method_in_uuus_out_qus_send(mem_ctx, conn, _sbus_sss_key_uuus_0_1_2_3,
        busname, object_path, "sssd.dataprovider", "resolverHandler", arg_dp_flags, arg_entry_type, arg_filter_type, arg_filter_value);
}

errno_t
sbus_call_dp_dp_resolverHandler_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     uint16_t* _dp_error,
     uint32_t* _error,
     const char ** _error_message)
{
    return sbus_method_in_uuus_out_qus_recv(mem_ctx, req, _dp_error, _error, _error_message);
}

struct tevent_req *
sbus_call_dp_dp_sudoHandler_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     DBusMessage *raw_message)
{
    return sbus_method_in_raw_out_qus_send(mem_ctx, conn, raw_message);
}

errno_t
sbus_call_dp_dp_sudoHandler_recv
    (TALLOC_CTX *mem_ctx,
     struct tevent_req *req,
     uint16_t* _dp_error,
     uint32_t* _error,
     const char ** _error_message)
{
    return sbus_method_in_raw_out_qus_recv(mem_ctx, req, _dp_error, _error, _error_message);
}

struct tevent_req *
sbus_call_monitor_RegisterService_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_name,
     uint16_t arg_version,
     uint16_t arg_type)
{
    return sbus_method_in_sqq_out_q_send(mem_ctx, conn, NULL,
        busname, object_path, "sssd.monitor", "RegisterService", arg_name, arg_version, arg_type);
}

errno_t
sbus_call_monitor_RegisterService_recv
    (struct tevent_req *req,
     uint16_t* _monitor_version)
{
    return sbus_method_in_sqq_out_q_recv(req, _monitor_version);
}

struct tevent_req *
sbus_call_nss_memcache_InvalidateAllGroups_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path)
{
    return sbus_method_in__out__send(mem_ctx, conn, _sbus_sss_key_,
        busname, object_path, "sssd.nss.MemoryCache", "InvalidateAllGroups");
}

errno_t
sbus_call_nss_memcache_InvalidateAllGroups_recv
    (struct tevent_req *req)
{
    return sbus_method_in__out__recv(req);
}

struct tevent_req *
sbus_call_nss_memcache_InvalidateAllInitgroups_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path)
{
    return sbus_method_in__out__send(mem_ctx, conn, _sbus_sss_key_,
        busname, object_path, "sssd.nss.MemoryCache", "InvalidateAllInitgroups");
}

errno_t
sbus_call_nss_memcache_InvalidateAllInitgroups_recv
    (struct tevent_req *req)
{
    return sbus_method_in__out__recv(req);
}

struct tevent_req *
sbus_call_nss_memcache_InvalidateAllUsers_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path)
{
    return sbus_method_in__out__send(mem_ctx, conn, _sbus_sss_key_,
        busname, object_path, "sssd.nss.MemoryCache", "InvalidateAllUsers");
}

errno_t
sbus_call_nss_memcache_InvalidateAllUsers_recv
    (struct tevent_req *req)
{
    return sbus_method_in__out__recv(req);
}

struct tevent_req *
sbus_call_nss_memcache_InvalidateGroupById_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t arg_gid)
{
    return sbus_method_in_u_out__send(mem_ctx, conn, _sbus_sss_key_u_0,
        busname, object_path, "sssd.nss.MemoryCache", "InvalidateGroupById", arg_gid);
}

errno_t
sbus_call_nss_memcache_InvalidateGroupById_recv
    (struct tevent_req *req)
{
    return sbus_method_in_u_out__recv(req);
}

struct tevent_req *
sbus_call_nss_memcache_UpdateInitgroups_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_user,
     const char * arg_domain,
     uint32_t * arg_groups)
{
    return sbus_method_in_ssau_out__send(mem_ctx, conn, NULL,
        busname, object_path, "sssd.nss.MemoryCache", "UpdateInitgroups", arg_user, arg_domain, arg_groups);
}

errno_t
sbus_call_nss_memcache_UpdateInitgroups_recv
    (struct tevent_req *req)
{
    return sbus_method_in_ssau_out__recv(req);
}

struct tevent_req *
sbus_call_service_clearEnumCache_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path)
{
    return sbus_method_in__out__send(mem_ctx, conn, NULL,
        busname, object_path, "sssd.service", "clearEnumCache");
}

errno_t
sbus_call_service_clearEnumCache_recv
    (struct tevent_req *req)
{
    return sbus_method_in__out__recv(req);
}

struct tevent_req *
sbus_call_service_clearMemcache_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path)
{
    return sbus_method_in__out__send(mem_ctx, conn, NULL,
        busname, object_path, "sssd.service", "clearMemcache");
}

errno_t
sbus_call_service_clearMemcache_recv
    (struct tevent_req *req)
{
    return sbus_method_in__out__recv(req);
}

struct tevent_req *
sbus_call_service_clearNegcache_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path)
{
    return sbus_method_in__out__send(mem_ctx, conn, NULL,
        busname, object_path, "sssd.service", "clearNegcache");
}

errno_t
sbus_call_service_clearNegcache_recv
    (struct tevent_req *req)
{
    return sbus_method_in__out__recv(req);
}

struct tevent_req *
sbus_call_service_goOffline_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path)
{
    return sbus_method_in__out__send(mem_ctx, conn, NULL,
        busname, object_path, "sssd.service", "goOffline");
}

errno_t
sbus_call_service_goOffline_recv
    (struct tevent_req *req)
{
    return sbus_method_in__out__recv(req);
}

struct tevent_req *
sbus_call_service_resInit_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path)
{
    return sbus_method_in__out__send(mem_ctx, conn, NULL,
        busname, object_path, "sssd.service", "resInit");
}

errno_t
sbus_call_service_resInit_recv
    (struct tevent_req *req)
{
    return sbus_method_in__out__recv(req);
}

struct tevent_req *
sbus_call_service_resetOffline_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path)
{
    return sbus_method_in__out__send(mem_ctx, conn, NULL,
        busname, object_path, "sssd.service", "resetOffline");
}

errno_t
sbus_call_service_resetOffline_recv
    (struct tevent_req *req)
{
    return sbus_method_in__out__recv(req);
}

struct tevent_req *
sbus_call_service_rotateLogs_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path)
{
    return sbus_method_in__out__send(mem_ctx, conn, NULL,
        busname, object_path, "sssd.service", "rotateLogs");
}

errno_t
sbus_call_service_rotateLogs_recv
    (struct tevent_req *req)
{
    return sbus_method_in__out__recv(req);
}

struct tevent_req *
sbus_call_service_sysbusReconnect_send
    (TALLOC_CTX *mem_ctx,
     struct sbus_connection *conn,
     const char *busname,
     const char *object_path)
{
    return sbus_method_in__out__send(mem_ctx, conn, NULL,
        busname, object_path, "sssd.service", "sysbusReconnect");
}

errno_t
sbus_call_service_sysbusReconnect_recv
    (struct tevent_req *req)
{
    return sbus_method_in__out__recv(req);
}

