/*
    Generated by sbus code generator

    Copyright (C) 2017 Red Hat

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <errno.h>
#include <talloc.h>
#include <dbus/dbus.h>

#include "sbus/sbus_sync.h"
#include "sbus/sbus_sync_private.h"
#include "sbus/sbus_message.h"
#include "sbus/interface/sbus_iterator_readers.h"
#include "sbus/interface_dbus/sbus_dbus_client_sync.h"
#include "sbus/interface_dbus/sbus_dbus_arguments.h"
#include "sbus/interface_dbus/sbus_dbus_client_properties.h"

static errno_t
sbus_method_in_raw_out_
    (struct sbus_sync_connection *conn,
     DBusMessage *raw_message)
{
    TALLOC_CTX *tmp_ctx;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }


    ret = sbus_sync_call_method(tmp_ctx, conn, raw_message, NULL, NULL,
                                dbus_message_get_path(raw_message),
                                dbus_message_get_interface(raw_message),
                                dbus_message_get_member(raw_message),
                                NULL, &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_method_in_s_out_raw
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0,
     DBusMessage **_reply)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_dbus_invoker_args_s in;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    in.arg0 = arg0;

    ret = sbus_sync_call_method(tmp_ctx, conn, NULL,
                                (sbus_invoker_writer_fn)_sbus_dbus_invoker_write_s,
                                bus, path, iface, method, &in, &reply);
    if (ret != EOK) {
        goto done;
    }

    /* Bounded reference cannot be unreferenced with dbus_message_unref.
     * For that reason we do not allow NULL memory context as it would
     * result in leaking the message memory. */
    if (mem_ctx == NULL) {
        ret = EINVAL;
        goto done;
    }

    ret = sbus_message_bound_ref(mem_ctx, reply);
    if (ret != EOK) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to bound message [%d]: %s\n",
              ret, sss_strerror(ret));
        goto done;
    }

    *_reply = reply;

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_method_in_ss_out_raw
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0,
     const char * arg1,
     DBusMessage **_reply)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_dbus_invoker_args_ss in;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    in.arg0 = arg0;
    in.arg1 = arg1;

    ret = sbus_sync_call_method(tmp_ctx, conn, NULL,
                                (sbus_invoker_writer_fn)_sbus_dbus_invoker_write_ss,
                                bus, path, iface, method, &in, &reply);
    if (ret != EOK) {
        goto done;
    }

    /* Bounded reference cannot be unreferenced with dbus_message_unref.
     * For that reason we do not allow NULL memory context as it would
     * result in leaking the message memory. */
    if (mem_ctx == NULL) {
        ret = EINVAL;
        goto done;
    }

    ret = sbus_message_bound_ref(mem_ctx, reply);
    if (ret != EOK) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to bound message [%d]: %s\n",
              ret, sss_strerror(ret));
        goto done;
    }

    *_reply = reply;

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

errno_t
sbus_call_DBusProperties_Get
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_interface_name,
     const char * arg_property_name,
     DBusMessage **_reply)
{
     return sbus_method_in_ss_out_raw(mem_ctx, conn,
          busname, object_path, "org.freedesktop.DBus.Properties", "Get", arg_interface_name, arg_property_name,
          _reply);
}

errno_t
sbus_call_DBusProperties_GetAll
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_interface_name,
     DBusMessage **_reply)
{
     return sbus_method_in_s_out_raw(mem_ctx, conn,
          busname, object_path, "org.freedesktop.DBus.Properties", "GetAll", arg_interface_name,
          _reply);
}

errno_t
sbus_call_DBusProperties_Set
    (struct sbus_sync_connection *conn,
     DBusMessage *raw_message)
{
     return sbus_method_in_raw_out_(conn,
          raw_message);
}

