/*
    Generated by sbus code generator

    Copyright (C) 2017 Red Hat

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <errno.h>
#include <talloc.h>
#include <dbus/dbus.h>

#include "sbus/sbus_sync.h"
#include "sbus/sbus_sync_private.h"
#include "sbus/sbus_message.h"
#include "sbus/interface/sbus_iterator_readers.h"
#include "sbus/interface_dbus/sbus_dbus_client_sync.h"
#include "sss_iface/sbus_sss_arguments.h"
#include "sss_iface/sbus_sss_client_properties.h"

static errno_t
sbus_method_in_ss_out_o
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0,
     const char * arg1,
     const char ** _arg0)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_sss_invoker_args_ss in;
    struct _sbus_sss_invoker_args_o *out;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_sss_invoker_args_o);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    in.arg0 = arg0;
    in.arg1 = arg1;

    ret = sbus_sync_call_method(tmp_ctx, conn, NULL,
                                (sbus_invoker_writer_fn)_sbus_sss_invoker_write_ss,
                                bus, path, iface, method, &in, &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = sbus_read_output(out, reply, (sbus_invoker_reader_fn)_sbus_sss_invoker_read_o, out);
    if (ret != EOK) {
        goto done;
    }

    *_arg0 = talloc_steal(mem_ctx, out->arg0);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

errno_t
sbus_call_systemd_RestartUnit
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_name,
     const char * arg_mode,
     const char ** _arg_job)
{
     return sbus_method_in_ss_out_o(mem_ctx, conn,
          busname, object_path, "org.freedesktop.systemd1.Manager", "RestartUnit", arg_name, arg_mode,
          _arg_job);
}

errno_t
sbus_call_systemd_StartUnit
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_name,
     const char * arg_mode,
     const char ** _arg_job)
{
     return sbus_method_in_ss_out_o(mem_ctx, conn,
          busname, object_path, "org.freedesktop.systemd1.Manager", "StartUnit", arg_name, arg_mode,
          _arg_job);
}

errno_t
sbus_call_systemd_StopUnit
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_name,
     const char * arg_mode,
     const char ** _arg_job)
{
     return sbus_method_in_ss_out_o(mem_ctx, conn,
          busname, object_path, "org.freedesktop.systemd1.Manager", "StopUnit", arg_name, arg_mode,
          _arg_job);
}
