// GENERATED FILE - DO NOT EDIT.
// Generated by generate_tests.py
//
// Copyright (c) 2022 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "../diff_test_utils.h"

#include "gtest/gtest.h"

namespace spvtools {
namespace diff {
namespace {

// Test where variable set/binding/location decorations are different between
// src and dst fragment shaders.
constexpr char kSrc[] = R"(OpCapability Shader
OpMemoryModel Logical GLSL450
OpEntryPoint Fragment %63 "main" %4 %22
OpExecutionMode %63 OriginUpperLeft
OpSource GLSL 450
OpName %4 "_ue"
OpName %8 "_uf"
OpName %11 "_ug"
OpName %12 "_uA"
OpMemberName %12 0 "_ux"
OpName %14 "_uc"
OpName %15 "_uB"
OpMemberName %15 0 "_ux"
OpName %20 "_ud"
OpName %22 "_ucol"
OpName %26 "ANGLEDepthRangeParams"
OpMemberName %26 0 "near"
OpMemberName %26 1 "far"
OpMemberName %26 2 "diff"
OpMemberName %26 3 "reserved"
OpName %27 "ANGLEUniformBlock"
OpMemberName %27 0 "viewport"
OpMemberName %27 1 "clipDistancesEnabled"
OpMemberName %27 2 "xfbActiveUnpaused"
OpMemberName %27 3 "xfbVerticesPerInstance"
OpMemberName %27 4 "numSamples"
OpMemberName %27 5 "xfbBufferOffsets"
OpMemberName %27 6 "acbBufferOffsets"
OpMemberName %27 7 "depthRange"
OpName %29 "ANGLEUniforms"
OpName %33 "_uc"
OpName %32 "_uh"
OpName %49 "_ux"
OpName %50 "_uy"
OpName %48 "_ui"
OpName %63 "main"
OpName %65 "param"
OpName %68 "param"
OpName %73 "param"
OpDecorate %4 Location 0
OpDecorate %8 RelaxedPrecision
OpDecorate %8 DescriptorSet 0
OpDecorate %8 Binding 0
OpDecorate %11 DescriptorSet 0
OpDecorate %11 Binding 1
OpMemberDecorate %12 0 Offset 0
OpMemberDecorate %12 0 RelaxedPrecision
OpDecorate %12 Block
OpDecorate %14 DescriptorSet 0
OpDecorate %14 Binding 2
OpMemberDecorate %15 0 Offset 0
OpMemberDecorate %15 0 RelaxedPrecision
OpDecorate %15 BufferBlock
OpDecorate %20 DescriptorSet 0
OpDecorate %20 Binding 3
OpDecorate %22 RelaxedPrecision
OpDecorate %22 Location 0
OpMemberDecorate %26 0 Offset 0
OpMemberDecorate %26 1 Offset 4
OpMemberDecorate %26 2 Offset 8
OpMemberDecorate %26 3 Offset 12
OpMemberDecorate %27 0 Offset 0
OpMemberDecorate %27 1 Offset 16
OpMemberDecorate %27 2 Offset 20
OpMemberDecorate %27 3 Offset 24
OpMemberDecorate %27 4 Offset 28
OpMemberDecorate %27 5 Offset 32
OpMemberDecorate %27 6 Offset 48
OpMemberDecorate %27 7 Offset 64
OpMemberDecorate %27 2 RelaxedPrecision
OpMemberDecorate %27 4 RelaxedPrecision
OpDecorate %27 Block
OpDecorate %29 DescriptorSet 0
OpDecorate %29 Binding 4
OpDecorate %32 RelaxedPrecision
OpDecorate %33 RelaxedPrecision
OpDecorate %36 RelaxedPrecision
OpDecorate %37 RelaxedPrecision
OpDecorate %38 RelaxedPrecision
OpDecorate %39 RelaxedPrecision
OpDecorate %41 RelaxedPrecision
OpDecorate %42 RelaxedPrecision
OpDecorate %43 RelaxedPrecision
OpDecorate %48 RelaxedPrecision
OpDecorate %49 RelaxedPrecision
OpDecorate %50 RelaxedPrecision
OpDecorate %52 RelaxedPrecision
OpDecorate %53 RelaxedPrecision
OpDecorate %54 RelaxedPrecision
OpDecorate %55 RelaxedPrecision
OpDecorate %56 RelaxedPrecision
OpDecorate %57 RelaxedPrecision
OpDecorate %58 RelaxedPrecision
OpDecorate %59 RelaxedPrecision
OpDecorate %60 RelaxedPrecision
OpDecorate %67 RelaxedPrecision
OpDecorate %68 RelaxedPrecision
OpDecorate %72 RelaxedPrecision
OpDecorate %73 RelaxedPrecision
OpDecorate %75 RelaxedPrecision
OpDecorate %76 RelaxedPrecision
OpDecorate %77 RelaxedPrecision
OpDecorate %80 RelaxedPrecision
OpDecorate %81 RelaxedPrecision
%1 = OpTypeFloat 32
%2 = OpTypeVector %1 4
%5 = OpTypeImage %1 2D 0 0 0 1 Unknown
%6 = OpTypeSampledImage %5
%9 = OpTypeImage %1 2D 0 0 0 2 Rgba8
%12 = OpTypeStruct %2
%15 = OpTypeStruct %2
%16 = OpTypeInt 32 0
%17 = OpConstant %16 2
%18 = OpTypeArray %15 %17
%23 = OpTypeInt 32 1
%24 = OpTypeVector %23 4
%25 = OpTypeVector %16 4
%26 = OpTypeStruct %1 %1 %1 %1
%27 = OpTypeStruct %2 %16 %16 %23 %23 %24 %25 %26
%35 = OpTypeVector %1 2
%40 = OpTypeVector %23 2
%61 = OpTypeVoid
%69 = OpConstant %16 0
%78 = OpConstant %16 1
%3 = OpTypePointer Input %2
%7 = OpTypePointer UniformConstant %6
%10 = OpTypePointer UniformConstant %9
%13 = OpTypePointer Uniform %12
%19 = OpTypePointer Uniform %18
%21 = OpTypePointer Output %2
%28 = OpTypePointer Uniform %27
%30 = OpTypePointer Function %2
%70 = OpTypePointer Uniform %2
%31 = OpTypeFunction %2 %30
%47 = OpTypeFunction %2 %30 %30
%62 = OpTypeFunction %61
%4 = OpVariable %3 Input
%8 = OpVariable %7 UniformConstant
%11 = OpVariable %10 UniformConstant
%14 = OpVariable %13 Uniform
%20 = OpVariable %19 Uniform
%22 = OpVariable %21 Output
%29 = OpVariable %28 Uniform
%32 = OpFunction %2 None %31
%33 = OpFunctionParameter %30
%34 = OpLabel
%36 = OpLoad %6 %8
%37 = OpLoad %2 %33
%38 = OpVectorShuffle %35 %37 %37 0 1
%39 = OpImageSampleImplicitLod %2 %36 %38
%41 = OpLoad %2 %33
%42 = OpVectorShuffle %35 %41 %41 2 3
%43 = OpConvertFToS %40 %42
%44 = OpLoad %9 %11
%45 = OpImageRead %2 %44 %43
%46 = OpFAdd %2 %39 %45
OpReturnValue %46
OpFunctionEnd
%48 = OpFunction %2 None %47
%49 = OpFunctionParameter %30
%50 = OpFunctionParameter %30
%51 = OpLabel
%52 = OpLoad %2 %49
%53 = OpVectorShuffle %35 %52 %52 0 1
%54 = OpLoad %2 %50
%55 = OpVectorShuffle %35 %54 %54 2 3
%56 = OpCompositeExtract %1 %53 0
%57 = OpCompositeExtract %1 %53 1
%58 = OpCompositeExtract %1 %55 0
%59 = OpCompositeExtract %1 %55 1
%60 = OpCompositeConstruct %2 %56 %57 %58 %59
OpReturnValue %60
OpFunctionEnd
%63 = OpFunction %61 None %62
%64 = OpLabel
%65 = OpVariable %30 Function
%68 = OpVariable %30 Function
%73 = OpVariable %30 Function
%66 = OpLoad %2 %4
OpStore %65 %66
%67 = OpFunctionCall %2 %32 %65
%71 = OpAccessChain %70 %14 %69
%72 = OpLoad %2 %71
OpStore %68 %72
%74 = OpAccessChain %70 %20 %69 %69
%75 = OpLoad %2 %74
OpStore %73 %75
%76 = OpFunctionCall %2 %48 %68 %73
%77 = OpFAdd %2 %67 %76
%79 = OpAccessChain %70 %20 %78 %69
%80 = OpLoad %2 %79
%81 = OpFAdd %2 %77 %80
OpStore %22 %81
OpReturn
OpFunctionEnd
)";
constexpr char kDst[] = R"(OpCapability Shader
OpMemoryModel Logical GLSL450
OpEntryPoint Fragment %63 "main" %4 %22
OpExecutionMode %63 OriginUpperLeft
OpSource GLSL 450
OpName %4 "_ue"
OpName %8 "_uf"
OpName %11 "_ug"
OpName %12 "_uA"
OpMemberName %12 0 "_ux"
OpName %14 "_uc"
OpName %15 "_uB"
OpMemberName %15 0 "_ux"
OpName %20 "_ud"
OpName %22 "_ucol"
OpName %26 "ANGLEDepthRangeParams"
OpMemberName %26 0 "near"
OpMemberName %26 1 "far"
OpMemberName %26 2 "diff"
OpMemberName %26 3 "reserved"
OpName %27 "ANGLEUniformBlock"
OpMemberName %27 0 "viewport"
OpMemberName %27 1 "clipDistancesEnabled"
OpMemberName %27 2 "xfbActiveUnpaused"
OpMemberName %27 3 "xfbVerticesPerInstance"
OpMemberName %27 4 "numSamples"
OpMemberName %27 5 "xfbBufferOffsets"
OpMemberName %27 6 "acbBufferOffsets"
OpMemberName %27 7 "depthRange"
OpName %29 "ANGLEUniforms"
OpName %33 "_uc"
OpName %32 "_uh"
OpName %49 "_ux"
OpName %50 "_uy"
OpName %48 "_ui"
OpName %63 "main"
OpName %65 "param"
OpName %68 "param"
OpName %73 "param"
OpDecorate %4 Location 1
OpDecorate %8 RelaxedPrecision
OpDecorate %8 DescriptorSet 2
OpDecorate %8 Binding 0
OpDecorate %11 DescriptorSet 3
OpDecorate %11 Binding 0
OpMemberDecorate %12 0 Offset 0
OpMemberDecorate %12 0 RelaxedPrecision
OpDecorate %12 Block
OpDecorate %14 DescriptorSet 3
OpDecorate %14 Binding 1
OpMemberDecorate %15 0 Offset 0
OpMemberDecorate %15 0 RelaxedPrecision
OpDecorate %15 BufferBlock
OpDecorate %20 DescriptorSet 3
OpDecorate %20 Binding 2
OpDecorate %22 RelaxedPrecision
OpDecorate %22 Location 1
OpMemberDecorate %26 0 Offset 0
OpMemberDecorate %26 1 Offset 4
OpMemberDecorate %26 2 Offset 8
OpMemberDecorate %26 3 Offset 12
OpMemberDecorate %27 0 Offset 0
OpMemberDecorate %27 1 Offset 16
OpMemberDecorate %27 2 Offset 20
OpMemberDecorate %27 3 Offset 24
OpMemberDecorate %27 4 Offset 28
OpMemberDecorate %27 5 Offset 32
OpMemberDecorate %27 6 Offset 48
OpMemberDecorate %27 7 Offset 64
OpMemberDecorate %27 2 RelaxedPrecision
OpMemberDecorate %27 4 RelaxedPrecision
OpDecorate %27 Block
OpDecorate %29 DescriptorSet 0
OpDecorate %29 Binding 0
OpDecorate %32 RelaxedPrecision
OpDecorate %33 RelaxedPrecision
OpDecorate %36 RelaxedPrecision
OpDecorate %37 RelaxedPrecision
OpDecorate %38 RelaxedPrecision
OpDecorate %39 RelaxedPrecision
OpDecorate %41 RelaxedPrecision
OpDecorate %42 RelaxedPrecision
OpDecorate %43 RelaxedPrecision
OpDecorate %48 RelaxedPrecision
OpDecorate %49 RelaxedPrecision
OpDecorate %50 RelaxedPrecision
OpDecorate %52 RelaxedPrecision
OpDecorate %53 RelaxedPrecision
OpDecorate %54 RelaxedPrecision
OpDecorate %55 RelaxedPrecision
OpDecorate %56 RelaxedPrecision
OpDecorate %57 RelaxedPrecision
OpDecorate %58 RelaxedPrecision
OpDecorate %59 RelaxedPrecision
OpDecorate %60 RelaxedPrecision
OpDecorate %67 RelaxedPrecision
OpDecorate %68 RelaxedPrecision
OpDecorate %72 RelaxedPrecision
OpDecorate %73 RelaxedPrecision
OpDecorate %75 RelaxedPrecision
OpDecorate %76 RelaxedPrecision
OpDecorate %77 RelaxedPrecision
OpDecorate %80 RelaxedPrecision
OpDecorate %81 RelaxedPrecision
%1 = OpTypeFloat 32
%2 = OpTypeVector %1 4
%5 = OpTypeImage %1 2D 0 0 0 1 Unknown
%6 = OpTypeSampledImage %5
%9 = OpTypeImage %1 2D 0 0 0 2 Rgba8
%12 = OpTypeStruct %2
%15 = OpTypeStruct %2
%16 = OpTypeInt 32 0
%17 = OpConstant %16 2
%18 = OpTypeArray %15 %17
%23 = OpTypeInt 32 1
%24 = OpTypeVector %23 4
%25 = OpTypeVector %16 4
%26 = OpTypeStruct %1 %1 %1 %1
%27 = OpTypeStruct %2 %16 %16 %23 %23 %24 %25 %26
%35 = OpTypeVector %1 2
%40 = OpTypeVector %23 2
%61 = OpTypeVoid
%69 = OpConstant %16 0
%78 = OpConstant %16 1
%82 = OpTypePointer Private %2
%3 = OpTypePointer Input %2
%7 = OpTypePointer UniformConstant %6
%10 = OpTypePointer UniformConstant %9
%13 = OpTypePointer Uniform %12
%19 = OpTypePointer Uniform %18
%83 = OpTypePointer Private %2
%21 = OpTypePointer Output %2
%28 = OpTypePointer Uniform %27
%30 = OpTypePointer Function %2
%70 = OpTypePointer Uniform %2
%31 = OpTypeFunction %2 %30
%47 = OpTypeFunction %2 %30 %30
%62 = OpTypeFunction %61
%4 = OpVariable %3 Input
%8 = OpVariable %7 UniformConstant
%11 = OpVariable %10 UniformConstant
%14 = OpVariable %13 Uniform
%20 = OpVariable %19 Uniform
%22 = OpVariable %21 Output
%29 = OpVariable %28 Uniform
%84 = OpConstant %23 0
%85 = OpConstant %1 0.5
%32 = OpFunction %2 None %31
%33 = OpFunctionParameter %30
%34 = OpLabel
%36 = OpLoad %6 %8
%37 = OpLoad %2 %33
%38 = OpVectorShuffle %35 %37 %37 0 1
%39 = OpImageSampleImplicitLod %2 %36 %38
%41 = OpLoad %2 %33
%42 = OpVectorShuffle %35 %41 %41 2 3
%43 = OpConvertFToS %40 %42
%44 = OpLoad %9 %11
%45 = OpImageRead %2 %44 %43
%46 = OpFAdd %2 %39 %45
OpReturnValue %46
OpFunctionEnd
%48 = OpFunction %2 None %47
%49 = OpFunctionParameter %30
%50 = OpFunctionParameter %30
%51 = OpLabel
%52 = OpLoad %2 %49
%53 = OpVectorShuffle %35 %52 %52 0 1
%54 = OpLoad %2 %50
%55 = OpVectorShuffle %35 %54 %54 2 3
%56 = OpCompositeExtract %1 %53 0
%57 = OpCompositeExtract %1 %53 1
%58 = OpCompositeExtract %1 %55 0
%59 = OpCompositeExtract %1 %55 1
%60 = OpCompositeConstruct %2 %56 %57 %58 %59
OpReturnValue %60
OpFunctionEnd
%63 = OpFunction %61 None %62
%64 = OpLabel
%65 = OpVariable %30 Function
%68 = OpVariable %30 Function
%73 = OpVariable %30 Function
%66 = OpLoad %2 %4
OpStore %65 %66
%67 = OpFunctionCall %2 %32 %65
%71 = OpAccessChain %70 %14 %69
%72 = OpLoad %2 %71
OpStore %68 %72
%74 = OpAccessChain %70 %20 %69 %69
%75 = OpLoad %2 %74
OpStore %73 %75
%76 = OpFunctionCall %2 %48 %68 %73
%77 = OpFAdd %2 %67 %76
%79 = OpAccessChain %70 %20 %78 %69
%80 = OpLoad %2 %79
%81 = OpFAdd %2 %77 %80
OpStore %22 %81
OpReturn
OpFunctionEnd
)";

TEST(DiffTest, DifferentDecorationsFragment) {
  constexpr char kDiff[] = R"( ; SPIR-V
 ; Version: 1.6
 ; Generator: Khronos SPIR-V Tools Assembler; 0
-; Bound: 82
+; Bound: 86
 ; Schema: 0
 OpCapability Shader
 OpMemoryModel Logical GLSL450
 OpEntryPoint Fragment %63 "main" %4 %22
 OpExecutionMode %63 OriginUpperLeft
 OpSource GLSL 450
 OpName %4 "_ue"
 OpName %8 "_uf"
 OpName %11 "_ug"
 OpName %12 "_uA"
 OpMemberName %12 0 "_ux"
 OpName %14 "_uc"
 OpName %15 "_uB"
 OpMemberName %15 0 "_ux"
 OpName %20 "_ud"
 OpName %22 "_ucol"
 OpName %26 "ANGLEDepthRangeParams"
 OpMemberName %26 0 "near"
 OpMemberName %26 1 "far"
 OpMemberName %26 2 "diff"
 OpMemberName %26 3 "reserved"
 OpName %27 "ANGLEUniformBlock"
 OpMemberName %27 0 "viewport"
 OpMemberName %27 1 "clipDistancesEnabled"
 OpMemberName %27 2 "xfbActiveUnpaused"
 OpMemberName %27 3 "xfbVerticesPerInstance"
 OpMemberName %27 4 "numSamples"
 OpMemberName %27 5 "xfbBufferOffsets"
 OpMemberName %27 6 "acbBufferOffsets"
 OpMemberName %27 7 "depthRange"
 OpName %29 "ANGLEUniforms"
 OpName %33 "_uc"
 OpName %32 "_uh"
 OpName %49 "_ux"
 OpName %50 "_uy"
 OpName %48 "_ui"
 OpName %63 "main"
 OpName %65 "param"
 OpName %68 "param"
 OpName %73 "param"
-OpDecorate %4 Location 0
+OpDecorate %4 Location 1
 OpDecorate %8 RelaxedPrecision
-OpDecorate %8 DescriptorSet 0
+OpDecorate %8 DescriptorSet 2
 OpDecorate %8 Binding 0
-OpDecorate %11 DescriptorSet 0
+OpDecorate %11 DescriptorSet 3
-OpDecorate %11 Binding 1
+OpDecorate %11 Binding 0
 OpMemberDecorate %12 0 Offset 0
 OpMemberDecorate %12 0 RelaxedPrecision
 OpDecorate %12 Block
-OpDecorate %14 DescriptorSet 0
+OpDecorate %14 DescriptorSet 3
-OpDecorate %14 Binding 2
+OpDecorate %14 Binding 1
 OpMemberDecorate %15 0 Offset 0
 OpMemberDecorate %15 0 RelaxedPrecision
 OpDecorate %15 BufferBlock
-OpDecorate %20 DescriptorSet 0
+OpDecorate %20 DescriptorSet 3
-OpDecorate %20 Binding 3
+OpDecorate %20 Binding 2
 OpDecorate %22 RelaxedPrecision
-OpDecorate %22 Location 0
+OpDecorate %22 Location 1
 OpMemberDecorate %26 0 Offset 0
 OpMemberDecorate %26 1 Offset 4
 OpMemberDecorate %26 2 Offset 8
 OpMemberDecorate %26 3 Offset 12
 OpMemberDecorate %27 0 Offset 0
 OpMemberDecorate %27 1 Offset 16
 OpMemberDecorate %27 2 Offset 20
 OpMemberDecorate %27 3 Offset 24
 OpMemberDecorate %27 4 Offset 28
 OpMemberDecorate %27 5 Offset 32
 OpMemberDecorate %27 6 Offset 48
 OpMemberDecorate %27 7 Offset 64
 OpMemberDecorate %27 2 RelaxedPrecision
 OpMemberDecorate %27 4 RelaxedPrecision
 OpDecorate %27 Block
 OpDecorate %29 DescriptorSet 0
-OpDecorate %29 Binding 4
+OpDecorate %29 Binding 0
 OpDecorate %32 RelaxedPrecision
 OpDecorate %33 RelaxedPrecision
 OpDecorate %36 RelaxedPrecision
 OpDecorate %37 RelaxedPrecision
 OpDecorate %38 RelaxedPrecision
 OpDecorate %39 RelaxedPrecision
 OpDecorate %41 RelaxedPrecision
 OpDecorate %42 RelaxedPrecision
 OpDecorate %43 RelaxedPrecision
 OpDecorate %48 RelaxedPrecision
 OpDecorate %49 RelaxedPrecision
 OpDecorate %50 RelaxedPrecision
 OpDecorate %52 RelaxedPrecision
 OpDecorate %53 RelaxedPrecision
 OpDecorate %54 RelaxedPrecision
 OpDecorate %55 RelaxedPrecision
 OpDecorate %56 RelaxedPrecision
 OpDecorate %57 RelaxedPrecision
 OpDecorate %58 RelaxedPrecision
 OpDecorate %59 RelaxedPrecision
 OpDecorate %60 RelaxedPrecision
 OpDecorate %67 RelaxedPrecision
 OpDecorate %68 RelaxedPrecision
 OpDecorate %72 RelaxedPrecision
 OpDecorate %73 RelaxedPrecision
 OpDecorate %75 RelaxedPrecision
 OpDecorate %76 RelaxedPrecision
 OpDecorate %77 RelaxedPrecision
 OpDecorate %80 RelaxedPrecision
 OpDecorate %81 RelaxedPrecision
 %1 = OpTypeFloat 32
 %2 = OpTypeVector %1 4
 %5 = OpTypeImage %1 2D 0 0 0 1 Unknown
 %6 = OpTypeSampledImage %5
 %9 = OpTypeImage %1 2D 0 0 0 2 Rgba8
 %12 = OpTypeStruct %2
 %15 = OpTypeStruct %2
 %16 = OpTypeInt 32 0
 %17 = OpConstant %16 2
 %18 = OpTypeArray %15 %17
 %23 = OpTypeInt 32 1
 %24 = OpTypeVector %23 4
 %25 = OpTypeVector %16 4
 %26 = OpTypeStruct %1 %1 %1 %1
 %27 = OpTypeStruct %2 %16 %16 %23 %23 %24 %25 %26
 %35 = OpTypeVector %1 2
 %40 = OpTypeVector %23 2
 %61 = OpTypeVoid
 %69 = OpConstant %16 0
 %78 = OpConstant %16 1
+%82 = OpTypePointer Private %2
 %3 = OpTypePointer Input %2
 %7 = OpTypePointer UniformConstant %6
 %10 = OpTypePointer UniformConstant %9
 %13 = OpTypePointer Uniform %12
 %19 = OpTypePointer Uniform %18
+%83 = OpTypePointer Private %2
 %21 = OpTypePointer Output %2
 %28 = OpTypePointer Uniform %27
 %30 = OpTypePointer Function %2
 %70 = OpTypePointer Uniform %2
 %31 = OpTypeFunction %2 %30
 %47 = OpTypeFunction %2 %30 %30
 %62 = OpTypeFunction %61
 %4 = OpVariable %3 Input
 %8 = OpVariable %7 UniformConstant
 %11 = OpVariable %10 UniformConstant
 %14 = OpVariable %13 Uniform
 %20 = OpVariable %19 Uniform
 %22 = OpVariable %21 Output
 %29 = OpVariable %28 Uniform
+%84 = OpConstant %23 0
+%85 = OpConstant %1 0.5
 %32 = OpFunction %2 None %31
 %33 = OpFunctionParameter %30
 %34 = OpLabel
 %36 = OpLoad %6 %8
 %37 = OpLoad %2 %33
 %38 = OpVectorShuffle %35 %37 %37 0 1
 %39 = OpImageSampleImplicitLod %2 %36 %38
 %41 = OpLoad %2 %33
 %42 = OpVectorShuffle %35 %41 %41 2 3
 %43 = OpConvertFToS %40 %42
 %44 = OpLoad %9 %11
 %45 = OpImageRead %2 %44 %43
 %46 = OpFAdd %2 %39 %45
 OpReturnValue %46
 OpFunctionEnd
 %48 = OpFunction %2 None %47
 %49 = OpFunctionParameter %30
 %50 = OpFunctionParameter %30
 %51 = OpLabel
 %52 = OpLoad %2 %49
 %53 = OpVectorShuffle %35 %52 %52 0 1
 %54 = OpLoad %2 %50
 %55 = OpVectorShuffle %35 %54 %54 2 3
 %56 = OpCompositeExtract %1 %53 0
 %57 = OpCompositeExtract %1 %53 1
 %58 = OpCompositeExtract %1 %55 0
 %59 = OpCompositeExtract %1 %55 1
 %60 = OpCompositeConstruct %2 %56 %57 %58 %59
 OpReturnValue %60
 OpFunctionEnd
 %63 = OpFunction %61 None %62
 %64 = OpLabel
 %65 = OpVariable %30 Function
 %68 = OpVariable %30 Function
 %73 = OpVariable %30 Function
 %66 = OpLoad %2 %4
 OpStore %65 %66
 %67 = OpFunctionCall %2 %32 %65
 %71 = OpAccessChain %70 %14 %69
 %72 = OpLoad %2 %71
 OpStore %68 %72
 %74 = OpAccessChain %70 %20 %69 %69
 %75 = OpLoad %2 %74
 OpStore %73 %75
 %76 = OpFunctionCall %2 %48 %68 %73
 %77 = OpFAdd %2 %67 %76
 %79 = OpAccessChain %70 %20 %78 %69
 %80 = OpLoad %2 %79
 %81 = OpFAdd %2 %77 %80
 OpStore %22 %81
 OpReturn
 OpFunctionEnd
)";
  Options options;
  DoStringDiffTest(kSrc, kDst, kDiff, options);
}

TEST(DiffTest, DifferentDecorationsFragmentNoDebug) {
  constexpr char kSrcNoDebug[] = R"(OpCapability Shader
OpMemoryModel Logical GLSL450
OpEntryPoint Fragment %63 "main" %4 %22
OpExecutionMode %63 OriginUpperLeft
OpSource GLSL 450
OpDecorate %4 Location 0
OpDecorate %8 RelaxedPrecision
OpDecorate %8 DescriptorSet 0
OpDecorate %8 Binding 0
OpDecorate %11 DescriptorSet 0
OpDecorate %11 Binding 1
OpMemberDecorate %12 0 Offset 0
OpMemberDecorate %12 0 RelaxedPrecision
OpDecorate %12 Block
OpDecorate %14 DescriptorSet 0
OpDecorate %14 Binding 2
OpMemberDecorate %15 0 Offset 0
OpMemberDecorate %15 0 RelaxedPrecision
OpDecorate %15 BufferBlock
OpDecorate %20 DescriptorSet 0
OpDecorate %20 Binding 3
OpDecorate %22 RelaxedPrecision
OpDecorate %22 Location 0
OpMemberDecorate %26 0 Offset 0
OpMemberDecorate %26 1 Offset 4
OpMemberDecorate %26 2 Offset 8
OpMemberDecorate %26 3 Offset 12
OpMemberDecorate %27 0 Offset 0
OpMemberDecorate %27 1 Offset 16
OpMemberDecorate %27 2 Offset 20
OpMemberDecorate %27 3 Offset 24
OpMemberDecorate %27 4 Offset 28
OpMemberDecorate %27 5 Offset 32
OpMemberDecorate %27 6 Offset 48
OpMemberDecorate %27 7 Offset 64
OpMemberDecorate %27 2 RelaxedPrecision
OpMemberDecorate %27 4 RelaxedPrecision
OpDecorate %27 Block
OpDecorate %29 DescriptorSet 0
OpDecorate %29 Binding 4
OpDecorate %32 RelaxedPrecision
OpDecorate %33 RelaxedPrecision
OpDecorate %36 RelaxedPrecision
OpDecorate %37 RelaxedPrecision
OpDecorate %38 RelaxedPrecision
OpDecorate %39 RelaxedPrecision
OpDecorate %41 RelaxedPrecision
OpDecorate %42 RelaxedPrecision
OpDecorate %43 RelaxedPrecision
OpDecorate %48 RelaxedPrecision
OpDecorate %49 RelaxedPrecision
OpDecorate %50 RelaxedPrecision
OpDecorate %52 RelaxedPrecision
OpDecorate %53 RelaxedPrecision
OpDecorate %54 RelaxedPrecision
OpDecorate %55 RelaxedPrecision
OpDecorate %56 RelaxedPrecision
OpDecorate %57 RelaxedPrecision
OpDecorate %58 RelaxedPrecision
OpDecorate %59 RelaxedPrecision
OpDecorate %60 RelaxedPrecision
OpDecorate %67 RelaxedPrecision
OpDecorate %68 RelaxedPrecision
OpDecorate %72 RelaxedPrecision
OpDecorate %73 RelaxedPrecision
OpDecorate %75 RelaxedPrecision
OpDecorate %76 RelaxedPrecision
OpDecorate %77 RelaxedPrecision
OpDecorate %80 RelaxedPrecision
OpDecorate %81 RelaxedPrecision
%1 = OpTypeFloat 32
%2 = OpTypeVector %1 4
%5 = OpTypeImage %1 2D 0 0 0 1 Unknown
%6 = OpTypeSampledImage %5
%9 = OpTypeImage %1 2D 0 0 0 2 Rgba8
%12 = OpTypeStruct %2
%15 = OpTypeStruct %2
%16 = OpTypeInt 32 0
%17 = OpConstant %16 2
%18 = OpTypeArray %15 %17
%23 = OpTypeInt 32 1
%24 = OpTypeVector %23 4
%25 = OpTypeVector %16 4
%26 = OpTypeStruct %1 %1 %1 %1
%27 = OpTypeStruct %2 %16 %16 %23 %23 %24 %25 %26
%35 = OpTypeVector %1 2
%40 = OpTypeVector %23 2
%61 = OpTypeVoid
%69 = OpConstant %16 0
%78 = OpConstant %16 1
%3 = OpTypePointer Input %2
%7 = OpTypePointer UniformConstant %6
%10 = OpTypePointer UniformConstant %9
%13 = OpTypePointer Uniform %12
%19 = OpTypePointer Uniform %18
%21 = OpTypePointer Output %2
%28 = OpTypePointer Uniform %27
%30 = OpTypePointer Function %2
%70 = OpTypePointer Uniform %2
%31 = OpTypeFunction %2 %30
%47 = OpTypeFunction %2 %30 %30
%62 = OpTypeFunction %61
%4 = OpVariable %3 Input
%8 = OpVariable %7 UniformConstant
%11 = OpVariable %10 UniformConstant
%14 = OpVariable %13 Uniform
%20 = OpVariable %19 Uniform
%22 = OpVariable %21 Output
%29 = OpVariable %28 Uniform
%32 = OpFunction %2 None %31
%33 = OpFunctionParameter %30
%34 = OpLabel
%36 = OpLoad %6 %8
%37 = OpLoad %2 %33
%38 = OpVectorShuffle %35 %37 %37 0 1
%39 = OpImageSampleImplicitLod %2 %36 %38
%41 = OpLoad %2 %33
%42 = OpVectorShuffle %35 %41 %41 2 3
%43 = OpConvertFToS %40 %42
%44 = OpLoad %9 %11
%45 = OpImageRead %2 %44 %43
%46 = OpFAdd %2 %39 %45
OpReturnValue %46
OpFunctionEnd
%48 = OpFunction %2 None %47
%49 = OpFunctionParameter %30
%50 = OpFunctionParameter %30
%51 = OpLabel
%52 = OpLoad %2 %49
%53 = OpVectorShuffle %35 %52 %52 0 1
%54 = OpLoad %2 %50
%55 = OpVectorShuffle %35 %54 %54 2 3
%56 = OpCompositeExtract %1 %53 0
%57 = OpCompositeExtract %1 %53 1
%58 = OpCompositeExtract %1 %55 0
%59 = OpCompositeExtract %1 %55 1
%60 = OpCompositeConstruct %2 %56 %57 %58 %59
OpReturnValue %60
OpFunctionEnd
%63 = OpFunction %61 None %62
%64 = OpLabel
%65 = OpVariable %30 Function
%68 = OpVariable %30 Function
%73 = OpVariable %30 Function
%66 = OpLoad %2 %4
OpStore %65 %66
%67 = OpFunctionCall %2 %32 %65
%71 = OpAccessChain %70 %14 %69
%72 = OpLoad %2 %71
OpStore %68 %72
%74 = OpAccessChain %70 %20 %69 %69
%75 = OpLoad %2 %74
OpStore %73 %75
%76 = OpFunctionCall %2 %48 %68 %73
%77 = OpFAdd %2 %67 %76
%79 = OpAccessChain %70 %20 %78 %69
%80 = OpLoad %2 %79
%81 = OpFAdd %2 %77 %80
OpStore %22 %81
OpReturn
OpFunctionEnd

)";
  constexpr char kDstNoDebug[] = R"(OpCapability Shader
OpMemoryModel Logical GLSL450
OpEntryPoint Fragment %63 "main" %4 %22
OpExecutionMode %63 OriginUpperLeft
OpSource GLSL 450
OpDecorate %4 Location 1
OpDecorate %8 RelaxedPrecision
OpDecorate %8 DescriptorSet 2
OpDecorate %8 Binding 0
OpDecorate %11 DescriptorSet 3
OpDecorate %11 Binding 0
OpMemberDecorate %12 0 Offset 0
OpMemberDecorate %12 0 RelaxedPrecision
OpDecorate %12 Block
OpDecorate %14 DescriptorSet 3
OpDecorate %14 Binding 1
OpMemberDecorate %15 0 Offset 0
OpMemberDecorate %15 0 RelaxedPrecision
OpDecorate %15 BufferBlock
OpDecorate %20 DescriptorSet 3
OpDecorate %20 Binding 2
OpDecorate %22 RelaxedPrecision
OpDecorate %22 Location 1
OpMemberDecorate %26 0 Offset 0
OpMemberDecorate %26 1 Offset 4
OpMemberDecorate %26 2 Offset 8
OpMemberDecorate %26 3 Offset 12
OpMemberDecorate %27 0 Offset 0
OpMemberDecorate %27 1 Offset 16
OpMemberDecorate %27 2 Offset 20
OpMemberDecorate %27 3 Offset 24
OpMemberDecorate %27 4 Offset 28
OpMemberDecorate %27 5 Offset 32
OpMemberDecorate %27 6 Offset 48
OpMemberDecorate %27 7 Offset 64
OpMemberDecorate %27 2 RelaxedPrecision
OpMemberDecorate %27 4 RelaxedPrecision
OpDecorate %27 Block
OpDecorate %29 DescriptorSet 0
OpDecorate %29 Binding 0
OpDecorate %32 RelaxedPrecision
OpDecorate %33 RelaxedPrecision
OpDecorate %36 RelaxedPrecision
OpDecorate %37 RelaxedPrecision
OpDecorate %38 RelaxedPrecision
OpDecorate %39 RelaxedPrecision
OpDecorate %41 RelaxedPrecision
OpDecorate %42 RelaxedPrecision
OpDecorate %43 RelaxedPrecision
OpDecorate %48 RelaxedPrecision
OpDecorate %49 RelaxedPrecision
OpDecorate %50 RelaxedPrecision
OpDecorate %52 RelaxedPrecision
OpDecorate %53 RelaxedPrecision
OpDecorate %54 RelaxedPrecision
OpDecorate %55 RelaxedPrecision
OpDecorate %56 RelaxedPrecision
OpDecorate %57 RelaxedPrecision
OpDecorate %58 RelaxedPrecision
OpDecorate %59 RelaxedPrecision
OpDecorate %60 RelaxedPrecision
OpDecorate %67 RelaxedPrecision
OpDecorate %68 RelaxedPrecision
OpDecorate %72 RelaxedPrecision
OpDecorate %73 RelaxedPrecision
OpDecorate %75 RelaxedPrecision
OpDecorate %76 RelaxedPrecision
OpDecorate %77 RelaxedPrecision
OpDecorate %80 RelaxedPrecision
OpDecorate %81 RelaxedPrecision
%1 = OpTypeFloat 32
%2 = OpTypeVector %1 4
%5 = OpTypeImage %1 2D 0 0 0 1 Unknown
%6 = OpTypeSampledImage %5
%9 = OpTypeImage %1 2D 0 0 0 2 Rgba8
%12 = OpTypeStruct %2
%15 = OpTypeStruct %2
%16 = OpTypeInt 32 0
%17 = OpConstant %16 2
%18 = OpTypeArray %15 %17
%23 = OpTypeInt 32 1
%24 = OpTypeVector %23 4
%25 = OpTypeVector %16 4
%26 = OpTypeStruct %1 %1 %1 %1
%27 = OpTypeStruct %2 %16 %16 %23 %23 %24 %25 %26
%35 = OpTypeVector %1 2
%40 = OpTypeVector %23 2
%61 = OpTypeVoid
%69 = OpConstant %16 0
%78 = OpConstant %16 1
%82 = OpTypePointer Private %2
%3 = OpTypePointer Input %2
%7 = OpTypePointer UniformConstant %6
%10 = OpTypePointer UniformConstant %9
%13 = OpTypePointer Uniform %12
%19 = OpTypePointer Uniform %18
%83 = OpTypePointer Private %2
%21 = OpTypePointer Output %2
%28 = OpTypePointer Uniform %27
%30 = OpTypePointer Function %2
%70 = OpTypePointer Uniform %2
%31 = OpTypeFunction %2 %30
%47 = OpTypeFunction %2 %30 %30
%62 = OpTypeFunction %61
%4 = OpVariable %3 Input
%8 = OpVariable %7 UniformConstant
%11 = OpVariable %10 UniformConstant
%14 = OpVariable %13 Uniform
%20 = OpVariable %19 Uniform
%22 = OpVariable %21 Output
%29 = OpVariable %28 Uniform
%84 = OpConstant %23 0
%85 = OpConstant %1 0.5
%32 = OpFunction %2 None %31
%33 = OpFunctionParameter %30
%34 = OpLabel
%36 = OpLoad %6 %8
%37 = OpLoad %2 %33
%38 = OpVectorShuffle %35 %37 %37 0 1
%39 = OpImageSampleImplicitLod %2 %36 %38
%41 = OpLoad %2 %33
%42 = OpVectorShuffle %35 %41 %41 2 3
%43 = OpConvertFToS %40 %42
%44 = OpLoad %9 %11
%45 = OpImageRead %2 %44 %43
%46 = OpFAdd %2 %39 %45
OpReturnValue %46
OpFunctionEnd
%48 = OpFunction %2 None %47
%49 = OpFunctionParameter %30
%50 = OpFunctionParameter %30
%51 = OpLabel
%52 = OpLoad %2 %49
%53 = OpVectorShuffle %35 %52 %52 0 1
%54 = OpLoad %2 %50
%55 = OpVectorShuffle %35 %54 %54 2 3
%56 = OpCompositeExtract %1 %53 0
%57 = OpCompositeExtract %1 %53 1
%58 = OpCompositeExtract %1 %55 0
%59 = OpCompositeExtract %1 %55 1
%60 = OpCompositeConstruct %2 %56 %57 %58 %59
OpReturnValue %60
OpFunctionEnd
%63 = OpFunction %61 None %62
%64 = OpLabel
%65 = OpVariable %30 Function
%68 = OpVariable %30 Function
%73 = OpVariable %30 Function
%66 = OpLoad %2 %4
OpStore %65 %66
%67 = OpFunctionCall %2 %32 %65
%71 = OpAccessChain %70 %14 %69
%72 = OpLoad %2 %71
OpStore %68 %72
%74 = OpAccessChain %70 %20 %69 %69
%75 = OpLoad %2 %74
OpStore %73 %75
%76 = OpFunctionCall %2 %48 %68 %73
%77 = OpFAdd %2 %67 %76
%79 = OpAccessChain %70 %20 %78 %69
%80 = OpLoad %2 %79
%81 = OpFAdd %2 %77 %80
OpStore %22 %81
OpReturn
OpFunctionEnd
)";
  constexpr char kDiff[] = R"( ; SPIR-V
 ; Version: 1.6
 ; Generator: Khronos SPIR-V Tools Assembler; 0
-; Bound: 82
+; Bound: 92
 ; Schema: 0
 OpCapability Shader
 OpMemoryModel Logical GLSL450
 OpEntryPoint Fragment %63 "main" %4 %22
 OpExecutionMode %63 OriginUpperLeft
 OpSource GLSL 450
-OpDecorate %4 Location 0
+OpDecorate %4 Location 1
 OpDecorate %8 RelaxedPrecision
-OpDecorate %8 DescriptorSet 0
+OpDecorate %8 DescriptorSet 2
 OpDecorate %8 Binding 0
-OpDecorate %11 DescriptorSet 0
+OpDecorate %11 DescriptorSet 3
-OpDecorate %11 Binding 1
+OpDecorate %11 Binding 0
 OpMemberDecorate %12 0 Offset 0
 OpMemberDecorate %12 0 RelaxedPrecision
 OpDecorate %12 Block
+OpDecorate %82 DescriptorSet 3
+OpDecorate %82 Binding 1
-OpDecorate %14 DescriptorSet 0
+OpDecorate %14 DescriptorSet 3
 OpDecorate %14 Binding 2
 OpMemberDecorate %15 0 Offset 0
 OpMemberDecorate %15 0 RelaxedPrecision
 OpDecorate %15 BufferBlock
-OpDecorate %20 DescriptorSet 0
-OpDecorate %20 Binding 3
 OpDecorate %22 RelaxedPrecision
-OpDecorate %22 Location 0
+OpDecorate %22 Location 1
 OpMemberDecorate %26 0 Offset 0
 OpMemberDecorate %26 1 Offset 4
 OpMemberDecorate %26 2 Offset 8
 OpMemberDecorate %26 3 Offset 12
 OpMemberDecorate %27 0 Offset 0
 OpMemberDecorate %27 1 Offset 16
 OpMemberDecorate %27 2 Offset 20
 OpMemberDecorate %27 3 Offset 24
 OpMemberDecorate %27 4 Offset 28
 OpMemberDecorate %27 5 Offset 32
 OpMemberDecorate %27 6 Offset 48
 OpMemberDecorate %27 7 Offset 64
 OpMemberDecorate %27 2 RelaxedPrecision
 OpMemberDecorate %27 4 RelaxedPrecision
 OpDecorate %27 Block
-OpDecorate %29 DescriptorSet 0
-OpDecorate %29 Binding 4
+OpDecorate %83 DescriptorSet 0
+OpDecorate %83 Binding 0
 OpDecorate %32 RelaxedPrecision
-OpDecorate %33 RelaxedPrecision
+OpDecorate %84 RelaxedPrecision
 OpDecorate %36 RelaxedPrecision
 OpDecorate %37 RelaxedPrecision
 OpDecorate %38 RelaxedPrecision
 OpDecorate %39 RelaxedPrecision
 OpDecorate %41 RelaxedPrecision
 OpDecorate %42 RelaxedPrecision
 OpDecorate %43 RelaxedPrecision
 OpDecorate %48 RelaxedPrecision
-OpDecorate %49 RelaxedPrecision
-OpDecorate %50 RelaxedPrecision
+OpDecorate %85 RelaxedPrecision
+OpDecorate %86 RelaxedPrecision
 OpDecorate %52 RelaxedPrecision
 OpDecorate %53 RelaxedPrecision
 OpDecorate %54 RelaxedPrecision
 OpDecorate %55 RelaxedPrecision
 OpDecorate %56 RelaxedPrecision
 OpDecorate %57 RelaxedPrecision
 OpDecorate %58 RelaxedPrecision
 OpDecorate %59 RelaxedPrecision
 OpDecorate %60 RelaxedPrecision
 OpDecorate %67 RelaxedPrecision
 OpDecorate %68 RelaxedPrecision
 OpDecorate %72 RelaxedPrecision
 OpDecorate %73 RelaxedPrecision
 OpDecorate %75 RelaxedPrecision
 OpDecorate %76 RelaxedPrecision
 OpDecorate %77 RelaxedPrecision
 OpDecorate %80 RelaxedPrecision
 OpDecorate %81 RelaxedPrecision
 %1 = OpTypeFloat 32
 %2 = OpTypeVector %1 4
 %5 = OpTypeImage %1 2D 0 0 0 1 Unknown
 %6 = OpTypeSampledImage %5
 %9 = OpTypeImage %1 2D 0 0 0 2 Rgba8
 %12 = OpTypeStruct %2
 %15 = OpTypeStruct %2
 %16 = OpTypeInt 32 0
 %17 = OpConstant %16 2
 %18 = OpTypeArray %15 %17
 %23 = OpTypeInt 32 1
 %24 = OpTypeVector %23 4
 %25 = OpTypeVector %16 4
 %26 = OpTypeStruct %1 %1 %1 %1
 %27 = OpTypeStruct %2 %16 %16 %23 %23 %24 %25 %26
 %35 = OpTypeVector %1 2
 %40 = OpTypeVector %23 2
 %61 = OpTypeVoid
 %69 = OpConstant %16 0
 %78 = OpConstant %16 1
+%88 = OpTypePointer Private %2
 %3 = OpTypePointer Input %2
 %7 = OpTypePointer UniformConstant %6
 %10 = OpTypePointer UniformConstant %9
 %13 = OpTypePointer Uniform %12
 %19 = OpTypePointer Uniform %18
+%89 = OpTypePointer Private %2
 %21 = OpTypePointer Output %2
 %28 = OpTypePointer Uniform %27
 %30 = OpTypePointer Function %2
 %70 = OpTypePointer Uniform %2
 %31 = OpTypeFunction %2 %30
 %47 = OpTypeFunction %2 %30 %30
 %62 = OpTypeFunction %61
 %4 = OpVariable %3 Input
 %8 = OpVariable %7 UniformConstant
 %11 = OpVariable %10 UniformConstant
+%82 = OpVariable %13 Uniform
-%14 = OpVariable %13 Uniform
+%14 = OpVariable %19 Uniform
-%20 = OpVariable %19 Uniform
 %22 = OpVariable %21 Output
-%29 = OpVariable %28 Uniform
+%83 = OpVariable %28 Uniform
+%90 = OpConstant %23 0
+%91 = OpConstant %1 0.5
 %32 = OpFunction %2 None %31
-%33 = OpFunctionParameter %30
+%84 = OpFunctionParameter %30
 %34 = OpLabel
 %36 = OpLoad %6 %8
-%37 = OpLoad %2 %33
+%37 = OpLoad %2 %84
 %38 = OpVectorShuffle %35 %37 %37 0 1
 %39 = OpImageSampleImplicitLod %2 %36 %38
-%41 = OpLoad %2 %33
+%41 = OpLoad %2 %84
 %42 = OpVectorShuffle %35 %41 %41 2 3
 %43 = OpConvertFToS %40 %42
 %44 = OpLoad %9 %11
 %45 = OpImageRead %2 %44 %43
 %46 = OpFAdd %2 %39 %45
 OpReturnValue %46
 OpFunctionEnd
 %48 = OpFunction %2 None %47
-%49 = OpFunctionParameter %30
-%50 = OpFunctionParameter %30
+%85 = OpFunctionParameter %30
+%86 = OpFunctionParameter %30
 %51 = OpLabel
-%52 = OpLoad %2 %49
+%52 = OpLoad %2 %85
 %53 = OpVectorShuffle %35 %52 %52 0 1
-%54 = OpLoad %2 %50
+%54 = OpLoad %2 %86
 %55 = OpVectorShuffle %35 %54 %54 2 3
 %56 = OpCompositeExtract %1 %53 0
 %57 = OpCompositeExtract %1 %53 1
 %58 = OpCompositeExtract %1 %55 0
 %59 = OpCompositeExtract %1 %55 1
 %60 = OpCompositeConstruct %2 %56 %57 %58 %59
 OpReturnValue %60
 OpFunctionEnd
 %63 = OpFunction %61 None %62
 %64 = OpLabel
 %65 = OpVariable %30 Function
 %68 = OpVariable %30 Function
 %73 = OpVariable %30 Function
 %66 = OpLoad %2 %4
 OpStore %65 %66
 %67 = OpFunctionCall %2 %32 %65
-%71 = OpAccessChain %70 %14 %69
+%87 = OpAccessChain %70 %82 %69
-%72 = OpLoad %2 %71
+%72 = OpLoad %2 %87
 OpStore %68 %72
-%74 = OpAccessChain %70 %20 %69 %69
+%74 = OpAccessChain %70 %14 %69 %69
 %75 = OpLoad %2 %74
 OpStore %73 %75
 %76 = OpFunctionCall %2 %48 %68 %73
 %77 = OpFAdd %2 %67 %76
-%79 = OpAccessChain %70 %20 %78 %69
+%79 = OpAccessChain %70 %14 %78 %69
 %80 = OpLoad %2 %79
 %81 = OpFAdd %2 %77 %80
 OpStore %22 %81
 OpReturn
 OpFunctionEnd
)";
  Options options;
  DoStringDiffTest(kSrcNoDebug, kDstNoDebug, kDiff, options);
}

TEST(DiffTest, DifferentDecorationsFragmentIgnoreLocation) {
  constexpr char kDiff[] = R"( ; SPIR-V
 ; Version: 1.6
 ; Generator: Khronos SPIR-V Tools Assembler; 0
-; Bound: 82
+; Bound: 86
 ; Schema: 0
 OpCapability Shader
 OpMemoryModel Logical GLSL450
 OpEntryPoint Fragment %63 "main" %4 %22
 OpExecutionMode %63 OriginUpperLeft
 OpSource GLSL 450
 OpName %4 "_ue"
 OpName %8 "_uf"
 OpName %11 "_ug"
 OpName %12 "_uA"
 OpMemberName %12 0 "_ux"
 OpName %14 "_uc"
 OpName %15 "_uB"
 OpMemberName %15 0 "_ux"
 OpName %20 "_ud"
 OpName %22 "_ucol"
 OpName %26 "ANGLEDepthRangeParams"
 OpMemberName %26 0 "near"
 OpMemberName %26 1 "far"
 OpMemberName %26 2 "diff"
 OpMemberName %26 3 "reserved"
 OpName %27 "ANGLEUniformBlock"
 OpMemberName %27 0 "viewport"
 OpMemberName %27 1 "clipDistancesEnabled"
 OpMemberName %27 2 "xfbActiveUnpaused"
 OpMemberName %27 3 "xfbVerticesPerInstance"
 OpMemberName %27 4 "numSamples"
 OpMemberName %27 5 "xfbBufferOffsets"
 OpMemberName %27 6 "acbBufferOffsets"
 OpMemberName %27 7 "depthRange"
 OpName %29 "ANGLEUniforms"
 OpName %33 "_uc"
 OpName %32 "_uh"
 OpName %49 "_ux"
 OpName %50 "_uy"
 OpName %48 "_ui"
 OpName %63 "main"
 OpName %65 "param"
 OpName %68 "param"
 OpName %73 "param"
-OpDecorate %4 Location 0
+OpDecorate %4 Location 1
 OpDecorate %8 RelaxedPrecision
-OpDecorate %8 DescriptorSet 0
+OpDecorate %8 DescriptorSet 2
 OpDecorate %8 Binding 0
-OpDecorate %11 DescriptorSet 0
+OpDecorate %11 DescriptorSet 3
-OpDecorate %11 Binding 1
+OpDecorate %11 Binding 0
 OpMemberDecorate %12 0 Offset 0
 OpMemberDecorate %12 0 RelaxedPrecision
 OpDecorate %12 Block
-OpDecorate %14 DescriptorSet 0
+OpDecorate %14 DescriptorSet 3
-OpDecorate %14 Binding 2
+OpDecorate %14 Binding 1
 OpMemberDecorate %15 0 Offset 0
 OpMemberDecorate %15 0 RelaxedPrecision
 OpDecorate %15 BufferBlock
-OpDecorate %20 DescriptorSet 0
+OpDecorate %20 DescriptorSet 3
-OpDecorate %20 Binding 3
+OpDecorate %20 Binding 2
 OpDecorate %22 RelaxedPrecision
-OpDecorate %22 Location 0
+OpDecorate %22 Location 1
 OpMemberDecorate %26 0 Offset 0
 OpMemberDecorate %26 1 Offset 4
 OpMemberDecorate %26 2 Offset 8
 OpMemberDecorate %26 3 Offset 12
 OpMemberDecorate %27 0 Offset 0
 OpMemberDecorate %27 1 Offset 16
 OpMemberDecorate %27 2 Offset 20
 OpMemberDecorate %27 3 Offset 24
 OpMemberDecorate %27 4 Offset 28
 OpMemberDecorate %27 5 Offset 32
 OpMemberDecorate %27 6 Offset 48
 OpMemberDecorate %27 7 Offset 64
 OpMemberDecorate %27 2 RelaxedPrecision
 OpMemberDecorate %27 4 RelaxedPrecision
 OpDecorate %27 Block
 OpDecorate %29 DescriptorSet 0
-OpDecorate %29 Binding 4
+OpDecorate %29 Binding 0
 OpDecorate %32 RelaxedPrecision
 OpDecorate %33 RelaxedPrecision
 OpDecorate %36 RelaxedPrecision
 OpDecorate %37 RelaxedPrecision
 OpDecorate %38 RelaxedPrecision
 OpDecorate %39 RelaxedPrecision
 OpDecorate %41 RelaxedPrecision
 OpDecorate %42 RelaxedPrecision
 OpDecorate %43 RelaxedPrecision
 OpDecorate %48 RelaxedPrecision
 OpDecorate %49 RelaxedPrecision
 OpDecorate %50 RelaxedPrecision
 OpDecorate %52 RelaxedPrecision
 OpDecorate %53 RelaxedPrecision
 OpDecorate %54 RelaxedPrecision
 OpDecorate %55 RelaxedPrecision
 OpDecorate %56 RelaxedPrecision
 OpDecorate %57 RelaxedPrecision
 OpDecorate %58 RelaxedPrecision
 OpDecorate %59 RelaxedPrecision
 OpDecorate %60 RelaxedPrecision
 OpDecorate %67 RelaxedPrecision
 OpDecorate %68 RelaxedPrecision
 OpDecorate %72 RelaxedPrecision
 OpDecorate %73 RelaxedPrecision
 OpDecorate %75 RelaxedPrecision
 OpDecorate %76 RelaxedPrecision
 OpDecorate %77 RelaxedPrecision
 OpDecorate %80 RelaxedPrecision
 OpDecorate %81 RelaxedPrecision
 %1 = OpTypeFloat 32
 %2 = OpTypeVector %1 4
 %5 = OpTypeImage %1 2D 0 0 0 1 Unknown
 %6 = OpTypeSampledImage %5
 %9 = OpTypeImage %1 2D 0 0 0 2 Rgba8
 %12 = OpTypeStruct %2
 %15 = OpTypeStruct %2
 %16 = OpTypeInt 32 0
 %17 = OpConstant %16 2
 %18 = OpTypeArray %15 %17
 %23 = OpTypeInt 32 1
 %24 = OpTypeVector %23 4
 %25 = OpTypeVector %16 4
 %26 = OpTypeStruct %1 %1 %1 %1
 %27 = OpTypeStruct %2 %16 %16 %23 %23 %24 %25 %26
 %35 = OpTypeVector %1 2
 %40 = OpTypeVector %23 2
 %61 = OpTypeVoid
 %69 = OpConstant %16 0
 %78 = OpConstant %16 1
+%82 = OpTypePointer Private %2
 %3 = OpTypePointer Input %2
 %7 = OpTypePointer UniformConstant %6
 %10 = OpTypePointer UniformConstant %9
 %13 = OpTypePointer Uniform %12
 %19 = OpTypePointer Uniform %18
+%83 = OpTypePointer Private %2
 %21 = OpTypePointer Output %2
 %28 = OpTypePointer Uniform %27
 %30 = OpTypePointer Function %2
 %70 = OpTypePointer Uniform %2
 %31 = OpTypeFunction %2 %30
 %47 = OpTypeFunction %2 %30 %30
 %62 = OpTypeFunction %61
 %4 = OpVariable %3 Input
 %8 = OpVariable %7 UniformConstant
 %11 = OpVariable %10 UniformConstant
 %14 = OpVariable %13 Uniform
 %20 = OpVariable %19 Uniform
 %22 = OpVariable %21 Output
 %29 = OpVariable %28 Uniform
+%84 = OpConstant %23 0
+%85 = OpConstant %1 0.5
 %32 = OpFunction %2 None %31
 %33 = OpFunctionParameter %30
 %34 = OpLabel
 %36 = OpLoad %6 %8
 %37 = OpLoad %2 %33
 %38 = OpVectorShuffle %35 %37 %37 0 1
 %39 = OpImageSampleImplicitLod %2 %36 %38
 %41 = OpLoad %2 %33
 %42 = OpVectorShuffle %35 %41 %41 2 3
 %43 = OpConvertFToS %40 %42
 %44 = OpLoad %9 %11
 %45 = OpImageRead %2 %44 %43
 %46 = OpFAdd %2 %39 %45
 OpReturnValue %46
 OpFunctionEnd
 %48 = OpFunction %2 None %47
 %49 = OpFunctionParameter %30
 %50 = OpFunctionParameter %30
 %51 = OpLabel
 %52 = OpLoad %2 %49
 %53 = OpVectorShuffle %35 %52 %52 0 1
 %54 = OpLoad %2 %50
 %55 = OpVectorShuffle %35 %54 %54 2 3
 %56 = OpCompositeExtract %1 %53 0
 %57 = OpCompositeExtract %1 %53 1
 %58 = OpCompositeExtract %1 %55 0
 %59 = OpCompositeExtract %1 %55 1
 %60 = OpCompositeConstruct %2 %56 %57 %58 %59
 OpReturnValue %60
 OpFunctionEnd
 %63 = OpFunction %61 None %62
 %64 = OpLabel
 %65 = OpVariable %30 Function
 %68 = OpVariable %30 Function
 %73 = OpVariable %30 Function
 %66 = OpLoad %2 %4
 OpStore %65 %66
 %67 = OpFunctionCall %2 %32 %65
 %71 = OpAccessChain %70 %14 %69
 %72 = OpLoad %2 %71
 OpStore %68 %72
 %74 = OpAccessChain %70 %20 %69 %69
 %75 = OpLoad %2 %74
 OpStore %73 %75
 %76 = OpFunctionCall %2 %48 %68 %73
 %77 = OpFAdd %2 %67 %76
 %79 = OpAccessChain %70 %20 %78 %69
 %80 = OpLoad %2 %79
 %81 = OpFAdd %2 %77 %80
 OpStore %22 %81
 OpReturn
 OpFunctionEnd
)";
  Options options;
  options.ignore_location = true;
  DoStringDiffTest(kSrc, kDst, kDiff, options);
}

TEST(DiffTest, DifferentDecorationsFragmentIgnoreSetBindingLocation) {
  constexpr char kDiff[] = R"( ; SPIR-V
 ; Version: 1.6
 ; Generator: Khronos SPIR-V Tools Assembler; 0
-; Bound: 82
+; Bound: 86
 ; Schema: 0
 OpCapability Shader
 OpMemoryModel Logical GLSL450
 OpEntryPoint Fragment %63 "main" %4 %22
 OpExecutionMode %63 OriginUpperLeft
 OpSource GLSL 450
 OpName %4 "_ue"
 OpName %8 "_uf"
 OpName %11 "_ug"
 OpName %12 "_uA"
 OpMemberName %12 0 "_ux"
 OpName %14 "_uc"
 OpName %15 "_uB"
 OpMemberName %15 0 "_ux"
 OpName %20 "_ud"
 OpName %22 "_ucol"
 OpName %26 "ANGLEDepthRangeParams"
 OpMemberName %26 0 "near"
 OpMemberName %26 1 "far"
 OpMemberName %26 2 "diff"
 OpMemberName %26 3 "reserved"
 OpName %27 "ANGLEUniformBlock"
 OpMemberName %27 0 "viewport"
 OpMemberName %27 1 "clipDistancesEnabled"
 OpMemberName %27 2 "xfbActiveUnpaused"
 OpMemberName %27 3 "xfbVerticesPerInstance"
 OpMemberName %27 4 "numSamples"
 OpMemberName %27 5 "xfbBufferOffsets"
 OpMemberName %27 6 "acbBufferOffsets"
 OpMemberName %27 7 "depthRange"
 OpName %29 "ANGLEUniforms"
 OpName %33 "_uc"
 OpName %32 "_uh"
 OpName %49 "_ux"
 OpName %50 "_uy"
 OpName %48 "_ui"
 OpName %63 "main"
 OpName %65 "param"
 OpName %68 "param"
 OpName %73 "param"
-OpDecorate %4 Location 0
+OpDecorate %4 Location 1
 OpDecorate %8 RelaxedPrecision
-OpDecorate %8 DescriptorSet 0
+OpDecorate %8 DescriptorSet 2
 OpDecorate %8 Binding 0
-OpDecorate %11 DescriptorSet 0
+OpDecorate %11 DescriptorSet 3
-OpDecorate %11 Binding 1
+OpDecorate %11 Binding 0
 OpMemberDecorate %12 0 Offset 0
 OpMemberDecorate %12 0 RelaxedPrecision
 OpDecorate %12 Block
-OpDecorate %14 DescriptorSet 0
+OpDecorate %14 DescriptorSet 3
-OpDecorate %14 Binding 2
+OpDecorate %14 Binding 1
 OpMemberDecorate %15 0 Offset 0
 OpMemberDecorate %15 0 RelaxedPrecision
 OpDecorate %15 BufferBlock
-OpDecorate %20 DescriptorSet 0
+OpDecorate %20 DescriptorSet 3
-OpDecorate %20 Binding 3
+OpDecorate %20 Binding 2
 OpDecorate %22 RelaxedPrecision
-OpDecorate %22 Location 0
+OpDecorate %22 Location 1
 OpMemberDecorate %26 0 Offset 0
 OpMemberDecorate %26 1 Offset 4
 OpMemberDecorate %26 2 Offset 8
 OpMemberDecorate %26 3 Offset 12
 OpMemberDecorate %27 0 Offset 0
 OpMemberDecorate %27 1 Offset 16
 OpMemberDecorate %27 2 Offset 20
 OpMemberDecorate %27 3 Offset 24
 OpMemberDecorate %27 4 Offset 28
 OpMemberDecorate %27 5 Offset 32
 OpMemberDecorate %27 6 Offset 48
 OpMemberDecorate %27 7 Offset 64
 OpMemberDecorate %27 2 RelaxedPrecision
 OpMemberDecorate %27 4 RelaxedPrecision
 OpDecorate %27 Block
 OpDecorate %29 DescriptorSet 0
-OpDecorate %29 Binding 4
+OpDecorate %29 Binding 0
 OpDecorate %32 RelaxedPrecision
 OpDecorate %33 RelaxedPrecision
 OpDecorate %36 RelaxedPrecision
 OpDecorate %37 RelaxedPrecision
 OpDecorate %38 RelaxedPrecision
 OpDecorate %39 RelaxedPrecision
 OpDecorate %41 RelaxedPrecision
 OpDecorate %42 RelaxedPrecision
 OpDecorate %43 RelaxedPrecision
 OpDecorate %48 RelaxedPrecision
 OpDecorate %49 RelaxedPrecision
 OpDecorate %50 RelaxedPrecision
 OpDecorate %52 RelaxedPrecision
 OpDecorate %53 RelaxedPrecision
 OpDecorate %54 RelaxedPrecision
 OpDecorate %55 RelaxedPrecision
 OpDecorate %56 RelaxedPrecision
 OpDecorate %57 RelaxedPrecision
 OpDecorate %58 RelaxedPrecision
 OpDecorate %59 RelaxedPrecision
 OpDecorate %60 RelaxedPrecision
 OpDecorate %67 RelaxedPrecision
 OpDecorate %68 RelaxedPrecision
 OpDecorate %72 RelaxedPrecision
 OpDecorate %73 RelaxedPrecision
 OpDecorate %75 RelaxedPrecision
 OpDecorate %76 RelaxedPrecision
 OpDecorate %77 RelaxedPrecision
 OpDecorate %80 RelaxedPrecision
 OpDecorate %81 RelaxedPrecision
 %1 = OpTypeFloat 32
 %2 = OpTypeVector %1 4
 %5 = OpTypeImage %1 2D 0 0 0 1 Unknown
 %6 = OpTypeSampledImage %5
 %9 = OpTypeImage %1 2D 0 0 0 2 Rgba8
 %12 = OpTypeStruct %2
 %15 = OpTypeStruct %2
 %16 = OpTypeInt 32 0
 %17 = OpConstant %16 2
 %18 = OpTypeArray %15 %17
 %23 = OpTypeInt 32 1
 %24 = OpTypeVector %23 4
 %25 = OpTypeVector %16 4
 %26 = OpTypeStruct %1 %1 %1 %1
 %27 = OpTypeStruct %2 %16 %16 %23 %23 %24 %25 %26
 %35 = OpTypeVector %1 2
 %40 = OpTypeVector %23 2
 %61 = OpTypeVoid
 %69 = OpConstant %16 0
 %78 = OpConstant %16 1
+%82 = OpTypePointer Private %2
 %3 = OpTypePointer Input %2
 %7 = OpTypePointer UniformConstant %6
 %10 = OpTypePointer UniformConstant %9
 %13 = OpTypePointer Uniform %12
 %19 = OpTypePointer Uniform %18
+%83 = OpTypePointer Private %2
 %21 = OpTypePointer Output %2
 %28 = OpTypePointer Uniform %27
 %30 = OpTypePointer Function %2
 %70 = OpTypePointer Uniform %2
 %31 = OpTypeFunction %2 %30
 %47 = OpTypeFunction %2 %30 %30
 %62 = OpTypeFunction %61
 %4 = OpVariable %3 Input
 %8 = OpVariable %7 UniformConstant
 %11 = OpVariable %10 UniformConstant
 %14 = OpVariable %13 Uniform
 %20 = OpVariable %19 Uniform
 %22 = OpVariable %21 Output
 %29 = OpVariable %28 Uniform
+%84 = OpConstant %23 0
+%85 = OpConstant %1 0.5
 %32 = OpFunction %2 None %31
 %33 = OpFunctionParameter %30
 %34 = OpLabel
 %36 = OpLoad %6 %8
 %37 = OpLoad %2 %33
 %38 = OpVectorShuffle %35 %37 %37 0 1
 %39 = OpImageSampleImplicitLod %2 %36 %38
 %41 = OpLoad %2 %33
 %42 = OpVectorShuffle %35 %41 %41 2 3
 %43 = OpConvertFToS %40 %42
 %44 = OpLoad %9 %11
 %45 = OpImageRead %2 %44 %43
 %46 = OpFAdd %2 %39 %45
 OpReturnValue %46
 OpFunctionEnd
 %48 = OpFunction %2 None %47
 %49 = OpFunctionParameter %30
 %50 = OpFunctionParameter %30
 %51 = OpLabel
 %52 = OpLoad %2 %49
 %53 = OpVectorShuffle %35 %52 %52 0 1
 %54 = OpLoad %2 %50
 %55 = OpVectorShuffle %35 %54 %54 2 3
 %56 = OpCompositeExtract %1 %53 0
 %57 = OpCompositeExtract %1 %53 1
 %58 = OpCompositeExtract %1 %55 0
 %59 = OpCompositeExtract %1 %55 1
 %60 = OpCompositeConstruct %2 %56 %57 %58 %59
 OpReturnValue %60
 OpFunctionEnd
 %63 = OpFunction %61 None %62
 %64 = OpLabel
 %65 = OpVariable %30 Function
 %68 = OpVariable %30 Function
 %73 = OpVariable %30 Function
 %66 = OpLoad %2 %4
 OpStore %65 %66
 %67 = OpFunctionCall %2 %32 %65
 %71 = OpAccessChain %70 %14 %69
 %72 = OpLoad %2 %71
 OpStore %68 %72
 %74 = OpAccessChain %70 %20 %69 %69
 %75 = OpLoad %2 %74
 OpStore %73 %75
 %76 = OpFunctionCall %2 %48 %68 %73
 %77 = OpFAdd %2 %67 %76
 %79 = OpAccessChain %70 %20 %78 %69
 %80 = OpLoad %2 %79
 %81 = OpFAdd %2 %77 %80
 OpStore %22 %81
 OpReturn
 OpFunctionEnd
)";
  Options options;
  options.ignore_set_binding = true;
  options.ignore_location = true;
  DoStringDiffTest(kSrc, kDst, kDiff, options);
}

}  // namespace
}  // namespace diff
}  // namespace spvtools
