/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.xmlpull.v1.builder.xpath.jaxen.Navigator;
import org.xmlpull.v1.builder.xpath.jaxen.UnsupportedAxisException;
import org.xmlpull.v1.builder.xpath.jaxen.util.StackedIterator;

public class PrecedingAxisIterator
implements Iterator {
    private static final Iterator EMPTY_ITERATOR = Collections.EMPTY_LIST.iterator();
    private Object contextNode;
    private Navigator navigator;
    private Iterator siblings;
    private Iterator currentSibling;

    public PrecedingAxisIterator(Object contextNode, Navigator navigator) throws UnsupportedAxisException {
        this.contextNode = contextNode;
        this.navigator = navigator;
        this.siblings = navigator.getPrecedingSiblingAxisIterator(contextNode);
        this.currentSibling = EMPTY_ITERATOR;
    }

    private boolean goBack() {
        while (!this.siblings.hasNext()) {
            if (this.goUp()) continue;
            return false;
        }
        Object prevSibling = this.siblings.next();
        try {
            this.currentSibling = new ReverseDescendantOrSelfAxisIterator(prevSibling);
            return true;
        }
        catch (UnsupportedAxisException e) {
            return false;
        }
    }

    private boolean goUp() {
        if (this.contextNode == null || this.navigator.isDocument(this.contextNode)) {
            return false;
        }
        try {
            this.contextNode = this.navigator.getParentNode(this.contextNode);
            if (this.contextNode != null && !this.navigator.isDocument(this.contextNode)) {
                this.siblings = this.navigator.getPrecedingSiblingAxisIterator(this.contextNode);
                return true;
            }
            return false;
        }
        catch (UnsupportedAxisException e) {
            return false;
        }
    }

    public boolean hasNext() {
        while (!this.currentSibling.hasNext()) {
            if (this.goBack()) continue;
            return false;
        }
        return true;
    }

    public Object next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentSibling.next();
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private final class ReverseDescendantOrSelfAxisIterator
    extends StackedIterator {
        ReverseDescendantOrSelfAxisIterator(Object contextNode) throws UnsupportedAxisException {
            this.pushIterator(PrecedingAxisIterator.this.navigator.getSelfAxisIterator(contextNode));
            this.init(contextNode, PrecedingAxisIterator.this.navigator);
        }

        protected Iterator createIterator(Object contextNode) {
            try {
                Iterator iter = PrecedingAxisIterator.this.navigator.getChildAxisIterator(contextNode);
                if (iter == null) {
                    return null;
                }
                LinkedList reverse = new LinkedList();
                while (iter.hasNext()) {
                    reverse.addFirst(iter.next());
                }
                return reverse.iterator();
            }
            catch (UnsupportedAxisException unsupportedAxisException) {
                return null;
            }
        }
    }
}

