; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
AllowNoIcons=yes
AppCopyright=Copyright (C) 1989-2018 by Paul Mattes, GTRC and others
AppName=wc3270
AppPublisher=Paul Mattes
AppPublisherURL=http://x3270.bgp.nu
AppSupportURL=http://x3270.bgp.nu
AppUpdatesURL=http://x3270.bgp.nu
AppVerName=wc3270 3.6ga5
ArchitecturesInstallIn64BitMode=x64
ChangesAssociations=yes
Compression=lzma
DefaultDirName={pf}\wc3270
DefaultGroupName=wc3270
DisableDirPage=no
MinVersion=0,5.1
OutputBaseFilename=wc3270-3.6ga5-setup
OutputDir=.
SolidCompression=yes
WizardSmallImageFile=x3270-icon2.bmp
SignTool=mystandard $f

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Components]
Name: "base"; Description: "Basic executables"; Types: full compact custom; Flags: fixed
Name: "wizard"; Description: "Session Wizard"; Types: full compact custom
Name: "ws3270"; Description: "ws3270 (scripting app)"; Types: full custom
Name: "help"; Description: "Help files"; Types: full custom

[InstallDelete]
; Get rid of the AppData CA root certs files. The new install puts it in {app}.
;; Skip the rule below because it interferes with installing as SYSTEM and is
;; likely unnecessary now.
;Type: files; Name: "{userappdata}\root_certs.txt"
Type: files; Name: "{commonappdata}\root_certs.txt"
Type: files; Name: "{app}\root_certs.txt"
; Get rid of the old New wc3270 Session desktop icon.
;; Skip the rule below because it interferes with installing as SYSTEM and is
;; likely unnecessary now.
;Type: files; Name: "{userdesktop}\New wc3270 Session.lnk"
; Get rid of the old 'New wc3270 Session' start menu item.  It might be in
; the common programs group or the user programs group.
Type: files; Name: "{commonprograms}\{groupname}\New wc3270 Session.lnk"
;; Skip the rule below because it interferes with installing as SYSTEM and is
;; likely unnecessary now.
;Type: files; Name: "{userprograms}\{groupname}\New wc3270 Session.lnk"
; Get rid of the old networking DLLs.
Type: files; Name: "{app}\w3n4.dll"
Type: files; Name: "{app}\w3n46.dll"
Type: files; Name: "{app}\shf.dll"
; Get rid of ead3270.
Type: files; Name: "{app}\ead3270.exe"
; Get rid of Explore AppData on the Start menu.
Type: files; Name: "{group}\wc3270 Explore AppData"

[Files]
Source: "..\obj\win32\wc3270\wc3270.exe"; DestDir: "{app}"; Flags: ignoreversion; Check: not Is64BitInstallMode
Source: "..\obj\win64\wc3270\wc3270.exe"; DestDir: "{app}"; Flags: ignoreversion; Check: Is64BitInstallMode
Source: "..\obj\win32\ws3270\ws3270.exe"; DestDir: "{app}"; Flags: ignoreversion; Check: not Is64BitInstallMode; Components: ws3270
Source: "..\obj\win64\ws3270\ws3270.exe"; DestDir: "{app}"; Flags: ignoreversion; Check: Is64BitInstallMode; Components: ws3270
Source: "..\obj\win32\wpr3287\wpr3287.exe"; DestDir: "{app}"; Flags: ignoreversion; Check: not Is64BitInstallMode
Source: "..\obj\win64\wpr3287\wpr3287.exe"; DestDir: "{app}"; Flags: ignoreversion; Check: Is64BitInstallMode
Source: "..\obj\win32\wc3270\catf.exe"; DestDir: "{app}"; Flags: ignoreversion; Check: not Is64BitInstallMode
Source: "..\obj\win64\wc3270\catf.exe"; DestDir: "{app}"; Flags: ignoreversion; Check: Is64BitInstallMode
Source: "..\obj\win32\wc3270\mkshort.exe"; DestDir: "{app}"; Flags: ignoreversion deleteafterinstall; Check: not Is64BitInstallMode
Source: "..\obj\win64\wc3270\mkshort.exe"; DestDir: "{app}"; Flags: ignoreversion deleteafterinstall; Check: Is64BitInstallMode
Source: "..\obj\win32\wc3270\wc3270wiz.exe"; DestDir: "{app}"; Flags: ignoreversion; Check: not Is64BitInstallMode; Components: wizard
Source: "..\obj\win64\wc3270\wc3270wiz.exe"; DestDir: "{app}"; Flags: ignoreversion; Check: Is64BitInstallMode; Components: wizard
Source: "..\obj\win32\ws3270\x3270if.exe"; DestDir: "{app}"; Flags: ignoreversion; Check: not Is64BitInstallMode; Components: ws3270
Source: "..\obj\win64\ws3270\x3270if.exe"; DestDir: "{app}"; Flags: ignoreversion; Check: Is64BitInstallMode; Components: ws3270
Source: "html\Bugs.html"; DestDir: "{app}\html"; Components: help; Flags: ignoreversion
Source: "html\Build.html"; DestDir: "{app}\html"; Components: help; Flags: ignoreversion
Source: "html\FAQ.html"; DestDir: "{app}\html"; Components: help; Flags: ignoreversion
Source: "html\Intro.html"; DestDir: "{app}\html"; Components: help; Flags: ignoreversion
Source: "html\Keymap.html"; DestDir: "{app}\html"; Components: help; Flags: ignoreversion
Source: "html\Lineage.html"; DestDir: "{app}\html"; Components: help; Flags: ignoreversion
Source: "html\ReleaseNotes.html"; DestDir: "{app}\html"; Components: help; Flags: ignoreversion
Source: "html\Resources.html"; DestDir: "{app}\html"; Components: help; Flags: ignoreversion
Source: "html\README.html"; DestDir: "{app}\html"; Components: help; Flags: ignoreversion
Source: "html\SSL.html"; DestDir: "{app}\html"; Components: help; Flags: ignoreversion
Source: "html\wc3270-man.html"; DestDir: "{app}\html"; Components: help; Flags: ignoreversion
Source: "html\wc3270-script.html"; DestDir: "{app}\html"; Components: help; Flags: ignoreversion
Source: "..\ws3270\html\ws3270-man.html"; DestDir: "{app}\html"; Components: help; Flags: ignoreversion
Source: "..\wpr3287\html\wpr3287-man.html"; DestDir: "{app}\html"; Components: help; Flags: ignoreversion
Source: "html\Wishlist.html"; DestDir: "{app}\html"; Components: help; Flags: ignoreversion
Source: "..\ws3270\html\Windows-x3270if.html"; DestDir: "{app}\html"; Components: help; Flags: ignoreversion
Source: "LICENSE.txt"; DestDir: "{app}"; Flags: ignoreversion
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Tasks]
Name: "desktopicons"; Description: "Create desktop icons"; GroupDescription: "{cm:AdditionalIcons}"
Name: "migratefiles"; Description: "Migrate existing session files from AppData to Documents (can choose files)"; GroupDescription: "File Migration:"

[Code]
function myHelp(Param: String): String;
begin
; result := '/c start /b ' + GetShortName(ExpandConstant('{app}') + '\html\README.html');
 result := '/c start ' + GetShortName(ExpandConstant('{app}') + '\html\README.html');
end;
function InitializeSetup(): Boolean;
var
  uninstaller: String;
  ErrorCode: Integer;
begin
  if (Is64BitInstallMode) and (RegKeyExists(HKEY_LOCAL_MACHINE_32,
    'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\wc3270_is1')) then
  begin
    // We are in 64-bit mode and a 32-bit version is already installed.
    // Ask if they want to remove it.
    if (not WizardSilent) and (MsgBox('A 32-bit version of wc3270 is already installed and must be removed before a 64-bit version can be installed. Remove it now?', mbConfirmation, MB_YESNO) = IDNO) then
      begin
        // They don't want to remove the old version. Can't proceed.
        Result := False
      end // IDNO
    else
      begin
	// They do want to remove the old version.
        RegQueryStringValue(HKEY_LOCAL_MACHINE_32,
          'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\wc3270_is1',
          'UninstallString', uninstaller);
          ShellExec('runas', uninstaller, '/SILENT', '', SW_HIDE, ewWaitUntilTerminated, ErrorCode);
	// We can continue.
        Result := True
      end // IDYES
    end
  else
  // There is no old 32-bit version to remove.
  begin
    result := True
  end // no 32-bit to remove
end; // InitializeSetup

[Icons]
Name: "{group}\Session Wizard"; Filename: "{app}\wc3270wiz.exe"; WorkingDir: "{app}"; Components: wizard
Name: "{group}\Run wc3270"; Filename: "{app}\wc3270.exe"; WorkingDir: "{app}"
Name: "{group}\wc3270 Documentation"; Filename: "{app}\html\README.html"; Components: help

[Registry]
Root: HKCR; Subkey: ".wc3270"; ValueType: string; ValueName: ""; ValueData: "wc3270"; Flags: uninsdeletevalue
Root: HKCR; Subkey: "wc3270"; ValueType: string; ValueName: ""; ValueData: "wc3270 Emulator Session"; Flags: uninsdeletekey
Root: HKCR; Subkey: "wc3270\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\wc3270.exe,0"
Root: HKCR; Subkey: "wc3270\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\wc3270.exe"" ""%1"""
Root: HKCR; Subkey: "wc3270\shell\edit\command"; ValueType: string; ValueName: ""; ValueData: """{app}\wc3270wiz.exe"" -e ""%1"""; Components: wizard
Root: HKCR; Subkey: ".wc3270km"; ValueType: string; ValueName: ""; ValueData: "wc3270 keymap"; Flags: uninsdeletevalue
Root: HKCR; Subkey: "wc3270 keymap"; ValueType: string; ValueName: ""; ValueData: "wc3270 emulator keymap"; Flags: uninsdeletekey
Root: HKCR; Subkey: "wc3270 keymap\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\wc3270.exe,1"
Root: HKCR; Subkey: "wc3270 keymap\shell\open\command"; ValueType: string; ValueName: ""; ValueData: "notepad.exe ""%1"""
Root: HKCR; Subkey: "wc3270 keymap\shell\edit\command"; ValueType: string; ValueName: ""; ValueData: "notepad.exe ""%1"""

[Run]
Filename: "{app}\wc3270wiz.exe"; Description: "{cm:LaunchProgram,Session Wizard}"; Components: wizard; Flags: nowait postinstall skipifsilent
Filename: "{cmd}"; Parameters: {code:MyHelp}; Description: "{cm:LaunchProgram,Online Documentation}"; Components: help; Flags: nowait postinstall skipifsilent
Filename: "{app}\mkshort.exe"; Parameters: """{app}"" wc3270.exe ""{commondesktop}\wc3270.lnk"""; Flags: nowait runhidden; Tasks: desktopicons
Filename: "{app}\mkshort.exe"; Parameters: """{app}"" wc3270wiz.exe ""{commondesktop}\Session Wizard.lnk"""; Flags: nowait runhidden; Tasks: desktopicons; Components: wizard
; Run the upgrade wizard.
Filename: "{app}\wc3270wiz.exe"; Parameters: "-U"; Flags: nowait skipifsilent; Components: wizard; Tasks: migratefiles
Filename: "{app}\wc3270wiz.exe"; Parameters: "-Ua"; Flags: nowait runhidden skipifnotsilent; Components: wizard; Tasks: migratefiles

[UninstallDelete]
Type: files; Name: "{commondesktop}\wc3270.lnk"; Tasks: desktopicons
Type: files; Name: "{commondesktop}\Session Wizard.lnk"; Tasks: desktopicons
Type: dirifempty; Name: "{app}"
