// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See helper_file_generator.py for modifications


/***************************************************************************
 *
 * Copyright (c) 2015-2022 The Khronos Group Inc.
 * Copyright (c) 2015-2022 Valve Corporation
 * Copyright (c) 2015-2022 LunarG, Inc.
 * Copyright (c) 2015-2022 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Author: Mark Lobodzinski <mark@lunarg.com>
 * Author: Courtney Goeltzenleuchter <courtneygo@google.com>
 * Author: Tobin Ehlis <tobine@google.com>
 * Author: Chris Forbes <chrisforbes@google.com>
 * Author: John Zulauf<jzulauf@lunarg.com>
 * Author: Tony Barbour <tony@lunarg.com>
 *
 ****************************************************************************/

#include "synchronization_validation_types.h"

// clang-format off

// Unique bit for each  stage/access combination

// Map of the StageAccessIndices from the StageAccess Bit
const layer_data::unordered_map<SyncStageAccessFlags, SyncStageAccessIndex> syncStageAccessIndexByStageAccessBit  = {
    { SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ_BIT, SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ },
    { SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT },
    { SYNC_INDEX_INPUT_INDEX_READ_BIT, SYNC_INDEX_INPUT_INDEX_READ },
    { SYNC_VERTEX_ATTRIBUTE_INPUT_VERTEX_ATTRIBUTE_READ_BIT, SYNC_VERTEX_ATTRIBUTE_INPUT_VERTEX_ATTRIBUTE_READ },
    { SYNC_VERTEX_SHADER_ACCELERATION_STRUCTURE_READ_BIT, SYNC_VERTEX_SHADER_ACCELERATION_STRUCTURE_READ },
    { SYNC_VERTEX_SHADER_SHADER_BINDING_TABLE_READ_BIT, SYNC_VERTEX_SHADER_SHADER_BINDING_TABLE_READ },
    { SYNC_VERTEX_SHADER_SHADER_SAMPLED_READ_BIT, SYNC_VERTEX_SHADER_SHADER_SAMPLED_READ },
    { SYNC_VERTEX_SHADER_SHADER_STORAGE_READ_BIT, SYNC_VERTEX_SHADER_SHADER_STORAGE_READ },
    { SYNC_VERTEX_SHADER_SHADER_STORAGE_WRITE_BIT, SYNC_VERTEX_SHADER_SHADER_STORAGE_WRITE },
    { SYNC_VERTEX_SHADER_UNIFORM_READ_BIT, SYNC_VERTEX_SHADER_UNIFORM_READ },
    { SYNC_TESSELLATION_CONTROL_SHADER_ACCELERATION_STRUCTURE_READ_BIT, SYNC_TESSELLATION_CONTROL_SHADER_ACCELERATION_STRUCTURE_READ },
    { SYNC_TESSELLATION_CONTROL_SHADER_SHADER_BINDING_TABLE_READ_BIT, SYNC_TESSELLATION_CONTROL_SHADER_SHADER_BINDING_TABLE_READ },
    { SYNC_TESSELLATION_CONTROL_SHADER_SHADER_SAMPLED_READ_BIT, SYNC_TESSELLATION_CONTROL_SHADER_SHADER_SAMPLED_READ },
    { SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_READ_BIT, SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_READ },
    { SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_WRITE_BIT, SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_WRITE },
    { SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ_BIT, SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ },
    { SYNC_TESSELLATION_EVALUATION_SHADER_ACCELERATION_STRUCTURE_READ_BIT, SYNC_TESSELLATION_EVALUATION_SHADER_ACCELERATION_STRUCTURE_READ },
    { SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_BINDING_TABLE_READ_BIT, SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_BINDING_TABLE_READ },
    { SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_SAMPLED_READ_BIT, SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_SAMPLED_READ },
    { SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_READ_BIT, SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_READ },
    { SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_WRITE_BIT, SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_WRITE },
    { SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ_BIT, SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ },
    { SYNC_GEOMETRY_SHADER_ACCELERATION_STRUCTURE_READ_BIT, SYNC_GEOMETRY_SHADER_ACCELERATION_STRUCTURE_READ },
    { SYNC_GEOMETRY_SHADER_SHADER_BINDING_TABLE_READ_BIT, SYNC_GEOMETRY_SHADER_SHADER_BINDING_TABLE_READ },
    { SYNC_GEOMETRY_SHADER_SHADER_SAMPLED_READ_BIT, SYNC_GEOMETRY_SHADER_SHADER_SAMPLED_READ },
    { SYNC_GEOMETRY_SHADER_SHADER_STORAGE_READ_BIT, SYNC_GEOMETRY_SHADER_SHADER_STORAGE_READ },
    { SYNC_GEOMETRY_SHADER_SHADER_STORAGE_WRITE_BIT, SYNC_GEOMETRY_SHADER_SHADER_STORAGE_WRITE },
    { SYNC_GEOMETRY_SHADER_UNIFORM_READ_BIT, SYNC_GEOMETRY_SHADER_UNIFORM_READ },
    { SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT },
    { SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_EXT },
    { SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_WRITE_EXT },
    { SYNC_FRAGMENT_DENSITY_PROCESS_BIT_EXT_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, SYNC_FRAGMENT_DENSITY_PROCESS_EXT_FRAGMENT_DENSITY_MAP_READ_EXT },
    { SYNC_TASK_SHADER_NV_ACCELERATION_STRUCTURE_READ_BIT, SYNC_TASK_SHADER_NV_ACCELERATION_STRUCTURE_READ },
    { SYNC_TASK_SHADER_NV_SHADER_BINDING_TABLE_READ_BIT, SYNC_TASK_SHADER_NV_SHADER_BINDING_TABLE_READ },
    { SYNC_TASK_SHADER_NV_SHADER_SAMPLED_READ_BIT, SYNC_TASK_SHADER_NV_SHADER_SAMPLED_READ },
    { SYNC_TASK_SHADER_NV_SHADER_STORAGE_READ_BIT, SYNC_TASK_SHADER_NV_SHADER_STORAGE_READ },
    { SYNC_TASK_SHADER_NV_SHADER_STORAGE_WRITE_BIT, SYNC_TASK_SHADER_NV_SHADER_STORAGE_WRITE },
    { SYNC_TASK_SHADER_NV_UNIFORM_READ_BIT, SYNC_TASK_SHADER_NV_UNIFORM_READ },
    { SYNC_MESH_SHADER_NV_ACCELERATION_STRUCTURE_READ_BIT, SYNC_MESH_SHADER_NV_ACCELERATION_STRUCTURE_READ },
    { SYNC_MESH_SHADER_NV_SHADER_BINDING_TABLE_READ_BIT, SYNC_MESH_SHADER_NV_SHADER_BINDING_TABLE_READ },
    { SYNC_MESH_SHADER_NV_SHADER_SAMPLED_READ_BIT, SYNC_MESH_SHADER_NV_SHADER_SAMPLED_READ },
    { SYNC_MESH_SHADER_NV_SHADER_STORAGE_READ_BIT, SYNC_MESH_SHADER_NV_SHADER_STORAGE_READ },
    { SYNC_MESH_SHADER_NV_SHADER_STORAGE_WRITE_BIT, SYNC_MESH_SHADER_NV_SHADER_STORAGE_WRITE },
    { SYNC_MESH_SHADER_NV_UNIFORM_READ_BIT, SYNC_MESH_SHADER_NV_UNIFORM_READ },
    { SYNC_FRAGMENT_SHADING_RATE_ATTACHMENT_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT, SYNC_FRAGMENT_SHADING_RATE_ATTACHMENT_FRAGMENT_SHADING_RATE_ATTACHMENT_READ },
    { SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT, SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ },
    { SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE },
    { SYNC_FRAGMENT_SHADER_ACCELERATION_STRUCTURE_READ_BIT, SYNC_FRAGMENT_SHADER_ACCELERATION_STRUCTURE_READ },
    { SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ_BIT, SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ },
    { SYNC_FRAGMENT_SHADER_SHADER_BINDING_TABLE_READ_BIT, SYNC_FRAGMENT_SHADER_SHADER_BINDING_TABLE_READ },
    { SYNC_FRAGMENT_SHADER_SHADER_SAMPLED_READ_BIT, SYNC_FRAGMENT_SHADER_SHADER_SAMPLED_READ },
    { SYNC_FRAGMENT_SHADER_SHADER_STORAGE_READ_BIT, SYNC_FRAGMENT_SHADER_SHADER_STORAGE_READ },
    { SYNC_FRAGMENT_SHADER_SHADER_STORAGE_WRITE_BIT, SYNC_FRAGMENT_SHADER_SHADER_STORAGE_WRITE },
    { SYNC_FRAGMENT_SHADER_UNIFORM_READ_BIT, SYNC_FRAGMENT_SHADER_UNIFORM_READ },
    { SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT, SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ },
    { SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE },
    { SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_BIT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ },
    { SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_EXT },
    { SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE_BIT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE },
    { SYNC_COMPUTE_SHADER_ACCELERATION_STRUCTURE_READ_BIT, SYNC_COMPUTE_SHADER_ACCELERATION_STRUCTURE_READ },
    { SYNC_COMPUTE_SHADER_SHADER_BINDING_TABLE_READ_BIT, SYNC_COMPUTE_SHADER_SHADER_BINDING_TABLE_READ },
    { SYNC_COMPUTE_SHADER_SHADER_SAMPLED_READ_BIT, SYNC_COMPUTE_SHADER_SHADER_SAMPLED_READ },
    { SYNC_COMPUTE_SHADER_SHADER_STORAGE_READ_BIT, SYNC_COMPUTE_SHADER_SHADER_STORAGE_READ },
    { SYNC_COMPUTE_SHADER_SHADER_STORAGE_WRITE_BIT, SYNC_COMPUTE_SHADER_SHADER_STORAGE_WRITE },
    { SYNC_COMPUTE_SHADER_UNIFORM_READ_BIT, SYNC_COMPUTE_SHADER_UNIFORM_READ },
    { SYNC_COPY_TRANSFER_READ_BIT, SYNC_COPY_TRANSFER_READ },
    { SYNC_COPY_TRANSFER_WRITE_BIT, SYNC_COPY_TRANSFER_WRITE },
    { SYNC_RESOLVE_TRANSFER_READ_BIT, SYNC_RESOLVE_TRANSFER_READ },
    { SYNC_RESOLVE_TRANSFER_WRITE_BIT, SYNC_RESOLVE_TRANSFER_WRITE },
    { SYNC_BLIT_TRANSFER_READ_BIT, SYNC_BLIT_TRANSFER_READ },
    { SYNC_BLIT_TRANSFER_WRITE_BIT, SYNC_BLIT_TRANSFER_WRITE },
    { SYNC_CLEAR_TRANSFER_WRITE_BIT, SYNC_CLEAR_TRANSFER_WRITE },
    { SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_READ_BIT_NV, SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_READ_NV },
    { SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_WRITE_BIT_NV, SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_WRITE_NV },
    { SYNC_CONDITIONAL_RENDERING_BIT_EXT_CONDITIONAL_RENDERING_READ_BIT_EXT, SYNC_CONDITIONAL_RENDERING_EXT_CONDITIONAL_RENDERING_READ_EXT },
    { SYNC_RAY_TRACING_SHADER_ACCELERATION_STRUCTURE_READ_BIT, SYNC_RAY_TRACING_SHADER_ACCELERATION_STRUCTURE_READ },
    { SYNC_RAY_TRACING_SHADER_SHADER_BINDING_TABLE_READ_BIT, SYNC_RAY_TRACING_SHADER_SHADER_BINDING_TABLE_READ },
    { SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ_BIT, SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ },
    { SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ_BIT, SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ },
    { SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE_BIT, SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE },
    { SYNC_RAY_TRACING_SHADER_UNIFORM_READ_BIT, SYNC_RAY_TRACING_SHADER_UNIFORM_READ },
    { SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_READ_BIT, SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_READ },
    { SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_WRITE_BIT, SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_WRITE },
    { SYNC_ACCELERATION_STRUCTURE_BUILD_INDIRECT_COMMAND_READ_BIT, SYNC_ACCELERATION_STRUCTURE_BUILD_INDIRECT_COMMAND_READ },
    { SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_BINDING_TABLE_READ_BIT, SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_BINDING_TABLE_READ },
    { SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_SAMPLED_READ_BIT, SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_SAMPLED_READ },
    { SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_STORAGE_READ_BIT, SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_STORAGE_READ },
    { SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_READ_BIT, SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_READ },
    { SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_WRITE_BIT, SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_WRITE },
    { SYNC_ACCELERATION_STRUCTURE_BUILD_UNIFORM_READ_BIT, SYNC_ACCELERATION_STRUCTURE_BUILD_UNIFORM_READ },
    { SYNC_VIDEO_DECODE_VIDEO_DECODE_READ_BIT, SYNC_VIDEO_DECODE_VIDEO_DECODE_READ },
    { SYNC_VIDEO_DECODE_VIDEO_DECODE_WRITE_BIT, SYNC_VIDEO_DECODE_VIDEO_DECODE_WRITE },
    { SYNC_VIDEO_ENCODE_VIDEO_ENCODE_READ_BIT, SYNC_VIDEO_ENCODE_VIDEO_ENCODE_READ },
    { SYNC_VIDEO_ENCODE_VIDEO_ENCODE_WRITE_BIT, SYNC_VIDEO_ENCODE_VIDEO_ENCODE_WRITE },
    { SYNC_SUBPASS_SHADING_HUAWEI_INPUT_ATTACHMENT_READ_BIT, SYNC_SUBPASS_SHADING_HUAWEI_INPUT_ATTACHMENT_READ },
    { SYNC_HOST_HOST_READ_BIT, SYNC_HOST_HOST_READ },
    { SYNC_HOST_HOST_WRITE_BIT, SYNC_HOST_HOST_WRITE },
    { SYNC_IMAGE_LAYOUT_TRANSITION_BIT, SYNC_IMAGE_LAYOUT_TRANSITION },
    { SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER_BIT, SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER },
};

// Array of text names and component masks for each stage/access index
const std::array<SyncStageAccessInfoType, 100> syncStageAccessInfoByStageAccessIndex { {
    {
        "SYNC_ACCESS_INDEX_NONE",
        VK_PIPELINE_STAGE_2_NONE_KHR,
        VK_ACCESS_2_NONE_KHR,
        SYNC_ACCESS_INDEX_NONE,
        SyncStageAccessFlags(0)
    },
    {
        "SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ",
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT,
        VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT,
        SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ,
        SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ_BIT
    },
    {
        "SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT",
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT,
        VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT,
        SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT,
        SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT
    },
    {
        "SYNC_INDEX_INPUT_INDEX_READ",
        VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT,
        VK_ACCESS_2_INDEX_READ_BIT,
        SYNC_INDEX_INPUT_INDEX_READ,
        SYNC_INDEX_INPUT_INDEX_READ_BIT
    },
    {
        "SYNC_VERTEX_ATTRIBUTE_INPUT_VERTEX_ATTRIBUTE_READ",
        VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT,
        VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT,
        SYNC_VERTEX_ATTRIBUTE_INPUT_VERTEX_ATTRIBUTE_READ,
        SYNC_VERTEX_ATTRIBUTE_INPUT_VERTEX_ATTRIBUTE_READ_BIT
    },
    {
        "SYNC_VERTEX_SHADER_ACCELERATION_STRUCTURE_READ",
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT,
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR,
        SYNC_VERTEX_SHADER_ACCELERATION_STRUCTURE_READ,
        SYNC_VERTEX_SHADER_ACCELERATION_STRUCTURE_READ_BIT
    },
    {
        "SYNC_VERTEX_SHADER_SHADER_BINDING_TABLE_READ",
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT,
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR,
        SYNC_VERTEX_SHADER_SHADER_BINDING_TABLE_READ,
        SYNC_VERTEX_SHADER_SHADER_BINDING_TABLE_READ_BIT
    },
    {
        "SYNC_VERTEX_SHADER_SHADER_SAMPLED_READ",
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT,
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT,
        SYNC_VERTEX_SHADER_SHADER_SAMPLED_READ,
        SYNC_VERTEX_SHADER_SHADER_SAMPLED_READ_BIT
    },
    {
        "SYNC_VERTEX_SHADER_SHADER_STORAGE_READ",
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT,
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT,
        SYNC_VERTEX_SHADER_SHADER_STORAGE_READ,
        SYNC_VERTEX_SHADER_SHADER_STORAGE_READ_BIT
    },
    {
        "SYNC_VERTEX_SHADER_SHADER_STORAGE_WRITE",
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT,
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT,
        SYNC_VERTEX_SHADER_SHADER_STORAGE_WRITE,
        SYNC_VERTEX_SHADER_SHADER_STORAGE_WRITE_BIT
    },
    {
        "SYNC_VERTEX_SHADER_UNIFORM_READ",
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT,
        VK_ACCESS_2_UNIFORM_READ_BIT,
        SYNC_VERTEX_SHADER_UNIFORM_READ,
        SYNC_VERTEX_SHADER_UNIFORM_READ_BIT
    },
    {
        "SYNC_TESSELLATION_CONTROL_SHADER_ACCELERATION_STRUCTURE_READ",
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT,
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR,
        SYNC_TESSELLATION_CONTROL_SHADER_ACCELERATION_STRUCTURE_READ,
        SYNC_TESSELLATION_CONTROL_SHADER_ACCELERATION_STRUCTURE_READ_BIT
    },
    {
        "SYNC_TESSELLATION_CONTROL_SHADER_SHADER_BINDING_TABLE_READ",
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT,
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR,
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_BINDING_TABLE_READ,
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_BINDING_TABLE_READ_BIT
    },
    {
        "SYNC_TESSELLATION_CONTROL_SHADER_SHADER_SAMPLED_READ",
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT,
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT,
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_SAMPLED_READ,
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_SAMPLED_READ_BIT
    },
    {
        "SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_READ",
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT,
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT,
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_READ,
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_READ_BIT
    },
    {
        "SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_WRITE",
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT,
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT,
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_WRITE,
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_WRITE_BIT
    },
    {
        "SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ",
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT,
        VK_ACCESS_2_UNIFORM_READ_BIT,
        SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ,
        SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ_BIT
    },
    {
        "SYNC_TESSELLATION_EVALUATION_SHADER_ACCELERATION_STRUCTURE_READ",
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT,
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR,
        SYNC_TESSELLATION_EVALUATION_SHADER_ACCELERATION_STRUCTURE_READ,
        SYNC_TESSELLATION_EVALUATION_SHADER_ACCELERATION_STRUCTURE_READ_BIT
    },
    {
        "SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_BINDING_TABLE_READ",
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT,
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR,
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_BINDING_TABLE_READ,
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_BINDING_TABLE_READ_BIT
    },
    {
        "SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_SAMPLED_READ",
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT,
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT,
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_SAMPLED_READ,
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_SAMPLED_READ_BIT
    },
    {
        "SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_READ",
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT,
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT,
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_READ,
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_READ_BIT
    },
    {
        "SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_WRITE",
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT,
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT,
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_WRITE,
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_WRITE_BIT
    },
    {
        "SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ",
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT,
        VK_ACCESS_2_UNIFORM_READ_BIT,
        SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ,
        SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ_BIT
    },
    {
        "SYNC_GEOMETRY_SHADER_ACCELERATION_STRUCTURE_READ",
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT,
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR,
        SYNC_GEOMETRY_SHADER_ACCELERATION_STRUCTURE_READ,
        SYNC_GEOMETRY_SHADER_ACCELERATION_STRUCTURE_READ_BIT
    },
    {
        "SYNC_GEOMETRY_SHADER_SHADER_BINDING_TABLE_READ",
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT,
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR,
        SYNC_GEOMETRY_SHADER_SHADER_BINDING_TABLE_READ,
        SYNC_GEOMETRY_SHADER_SHADER_BINDING_TABLE_READ_BIT
    },
    {
        "SYNC_GEOMETRY_SHADER_SHADER_SAMPLED_READ",
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT,
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT,
        SYNC_GEOMETRY_SHADER_SHADER_SAMPLED_READ,
        SYNC_GEOMETRY_SHADER_SHADER_SAMPLED_READ_BIT
    },
    {
        "SYNC_GEOMETRY_SHADER_SHADER_STORAGE_READ",
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT,
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT,
        SYNC_GEOMETRY_SHADER_SHADER_STORAGE_READ,
        SYNC_GEOMETRY_SHADER_SHADER_STORAGE_READ_BIT
    },
    {
        "SYNC_GEOMETRY_SHADER_SHADER_STORAGE_WRITE",
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT,
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT,
        SYNC_GEOMETRY_SHADER_SHADER_STORAGE_WRITE,
        SYNC_GEOMETRY_SHADER_SHADER_STORAGE_WRITE_BIT
    },
    {
        "SYNC_GEOMETRY_SHADER_UNIFORM_READ",
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT,
        VK_ACCESS_2_UNIFORM_READ_BIT,
        SYNC_GEOMETRY_SHADER_UNIFORM_READ,
        SYNC_GEOMETRY_SHADER_UNIFORM_READ_BIT
    },
    {
        "SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT",
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT,
        VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT,
        SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT,
        SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT
    },
    {
        "SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_EXT",
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT,
        VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT,
        SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_EXT,
        SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT
    },
    {
        "SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_WRITE_EXT",
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT,
        VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT,
        SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_WRITE_EXT,
        SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_WRITE_BIT_EXT
    },
    {
        "SYNC_FRAGMENT_DENSITY_PROCESS_EXT_FRAGMENT_DENSITY_MAP_READ_EXT",
        VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT,
        VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT,
        SYNC_FRAGMENT_DENSITY_PROCESS_EXT_FRAGMENT_DENSITY_MAP_READ_EXT,
        SYNC_FRAGMENT_DENSITY_PROCESS_BIT_EXT_FRAGMENT_DENSITY_MAP_READ_BIT_EXT
    },
    {
        "SYNC_TASK_SHADER_NV_ACCELERATION_STRUCTURE_READ",
        VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV,
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR,
        SYNC_TASK_SHADER_NV_ACCELERATION_STRUCTURE_READ,
        SYNC_TASK_SHADER_NV_ACCELERATION_STRUCTURE_READ_BIT
    },
    {
        "SYNC_TASK_SHADER_NV_SHADER_BINDING_TABLE_READ",
        VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV,
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR,
        SYNC_TASK_SHADER_NV_SHADER_BINDING_TABLE_READ,
        SYNC_TASK_SHADER_NV_SHADER_BINDING_TABLE_READ_BIT
    },
    {
        "SYNC_TASK_SHADER_NV_SHADER_SAMPLED_READ",
        VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV,
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT,
        SYNC_TASK_SHADER_NV_SHADER_SAMPLED_READ,
        SYNC_TASK_SHADER_NV_SHADER_SAMPLED_READ_BIT
    },
    {
        "SYNC_TASK_SHADER_NV_SHADER_STORAGE_READ",
        VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV,
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT,
        SYNC_TASK_SHADER_NV_SHADER_STORAGE_READ,
        SYNC_TASK_SHADER_NV_SHADER_STORAGE_READ_BIT
    },
    {
        "SYNC_TASK_SHADER_NV_SHADER_STORAGE_WRITE",
        VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV,
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT,
        SYNC_TASK_SHADER_NV_SHADER_STORAGE_WRITE,
        SYNC_TASK_SHADER_NV_SHADER_STORAGE_WRITE_BIT
    },
    {
        "SYNC_TASK_SHADER_NV_UNIFORM_READ",
        VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV,
        VK_ACCESS_2_UNIFORM_READ_BIT,
        SYNC_TASK_SHADER_NV_UNIFORM_READ,
        SYNC_TASK_SHADER_NV_UNIFORM_READ_BIT
    },
    {
        "SYNC_MESH_SHADER_NV_ACCELERATION_STRUCTURE_READ",
        VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV,
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR,
        SYNC_MESH_SHADER_NV_ACCELERATION_STRUCTURE_READ,
        SYNC_MESH_SHADER_NV_ACCELERATION_STRUCTURE_READ_BIT
    },
    {
        "SYNC_MESH_SHADER_NV_SHADER_BINDING_TABLE_READ",
        VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV,
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR,
        SYNC_MESH_SHADER_NV_SHADER_BINDING_TABLE_READ,
        SYNC_MESH_SHADER_NV_SHADER_BINDING_TABLE_READ_BIT
    },
    {
        "SYNC_MESH_SHADER_NV_SHADER_SAMPLED_READ",
        VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV,
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT,
        SYNC_MESH_SHADER_NV_SHADER_SAMPLED_READ,
        SYNC_MESH_SHADER_NV_SHADER_SAMPLED_READ_BIT
    },
    {
        "SYNC_MESH_SHADER_NV_SHADER_STORAGE_READ",
        VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV,
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT,
        SYNC_MESH_SHADER_NV_SHADER_STORAGE_READ,
        SYNC_MESH_SHADER_NV_SHADER_STORAGE_READ_BIT
    },
    {
        "SYNC_MESH_SHADER_NV_SHADER_STORAGE_WRITE",
        VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV,
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT,
        SYNC_MESH_SHADER_NV_SHADER_STORAGE_WRITE,
        SYNC_MESH_SHADER_NV_SHADER_STORAGE_WRITE_BIT
    },
    {
        "SYNC_MESH_SHADER_NV_UNIFORM_READ",
        VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV,
        VK_ACCESS_2_UNIFORM_READ_BIT,
        SYNC_MESH_SHADER_NV_UNIFORM_READ,
        SYNC_MESH_SHADER_NV_UNIFORM_READ_BIT
    },
    {
        "SYNC_FRAGMENT_SHADING_RATE_ATTACHMENT_FRAGMENT_SHADING_RATE_ATTACHMENT_READ",
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR,
        VK_ACCESS_2_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR,
        SYNC_FRAGMENT_SHADING_RATE_ATTACHMENT_FRAGMENT_SHADING_RATE_ATTACHMENT_READ,
        SYNC_FRAGMENT_SHADING_RATE_ATTACHMENT_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT
    },
    {
        "SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ",
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT,
        VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT,
        SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ,
        SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT
    },
    {
        "SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE",
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT,
        VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT,
        SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE,
        SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT
    },
    {
        "SYNC_FRAGMENT_SHADER_ACCELERATION_STRUCTURE_READ",
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT,
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR,
        SYNC_FRAGMENT_SHADER_ACCELERATION_STRUCTURE_READ,
        SYNC_FRAGMENT_SHADER_ACCELERATION_STRUCTURE_READ_BIT
    },
    {
        "SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ",
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT,
        VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT,
        SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ,
        SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ_BIT
    },
    {
        "SYNC_FRAGMENT_SHADER_SHADER_BINDING_TABLE_READ",
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT,
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR,
        SYNC_FRAGMENT_SHADER_SHADER_BINDING_TABLE_READ,
        SYNC_FRAGMENT_SHADER_SHADER_BINDING_TABLE_READ_BIT
    },
    {
        "SYNC_FRAGMENT_SHADER_SHADER_SAMPLED_READ",
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT,
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT,
        SYNC_FRAGMENT_SHADER_SHADER_SAMPLED_READ,
        SYNC_FRAGMENT_SHADER_SHADER_SAMPLED_READ_BIT
    },
    {
        "SYNC_FRAGMENT_SHADER_SHADER_STORAGE_READ",
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT,
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT,
        SYNC_FRAGMENT_SHADER_SHADER_STORAGE_READ,
        SYNC_FRAGMENT_SHADER_SHADER_STORAGE_READ_BIT
    },
    {
        "SYNC_FRAGMENT_SHADER_SHADER_STORAGE_WRITE",
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT,
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT,
        SYNC_FRAGMENT_SHADER_SHADER_STORAGE_WRITE,
        SYNC_FRAGMENT_SHADER_SHADER_STORAGE_WRITE_BIT
    },
    {
        "SYNC_FRAGMENT_SHADER_UNIFORM_READ",
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT,
        VK_ACCESS_2_UNIFORM_READ_BIT,
        SYNC_FRAGMENT_SHADER_UNIFORM_READ,
        SYNC_FRAGMENT_SHADER_UNIFORM_READ_BIT
    },
    {
        "SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ",
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT,
        VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT,
        SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ,
        SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT
    },
    {
        "SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE",
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT,
        VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT,
        SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE,
        SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT
    },
    {
        "SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ",
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT,
        VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT,
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ,
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_BIT
    },
    {
        "SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_EXT",
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT,
        VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT,
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_EXT,
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT
    },
    {
        "SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE",
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT,
        VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT,
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE,
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE_BIT
    },
    {
        "SYNC_COMPUTE_SHADER_ACCELERATION_STRUCTURE_READ",
        VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT,
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR,
        SYNC_COMPUTE_SHADER_ACCELERATION_STRUCTURE_READ,
        SYNC_COMPUTE_SHADER_ACCELERATION_STRUCTURE_READ_BIT
    },
    {
        "SYNC_COMPUTE_SHADER_SHADER_BINDING_TABLE_READ",
        VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT,
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR,
        SYNC_COMPUTE_SHADER_SHADER_BINDING_TABLE_READ,
        SYNC_COMPUTE_SHADER_SHADER_BINDING_TABLE_READ_BIT
    },
    {
        "SYNC_COMPUTE_SHADER_SHADER_SAMPLED_READ",
        VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT,
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT,
        SYNC_COMPUTE_SHADER_SHADER_SAMPLED_READ,
        SYNC_COMPUTE_SHADER_SHADER_SAMPLED_READ_BIT
    },
    {
        "SYNC_COMPUTE_SHADER_SHADER_STORAGE_READ",
        VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT,
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT,
        SYNC_COMPUTE_SHADER_SHADER_STORAGE_READ,
        SYNC_COMPUTE_SHADER_SHADER_STORAGE_READ_BIT
    },
    {
        "SYNC_COMPUTE_SHADER_SHADER_STORAGE_WRITE",
        VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT,
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT,
        SYNC_COMPUTE_SHADER_SHADER_STORAGE_WRITE,
        SYNC_COMPUTE_SHADER_SHADER_STORAGE_WRITE_BIT
    },
    {
        "SYNC_COMPUTE_SHADER_UNIFORM_READ",
        VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT,
        VK_ACCESS_2_UNIFORM_READ_BIT,
        SYNC_COMPUTE_SHADER_UNIFORM_READ,
        SYNC_COMPUTE_SHADER_UNIFORM_READ_BIT
    },
    {
        "SYNC_COPY_TRANSFER_READ",
        VK_PIPELINE_STAGE_2_COPY_BIT,
        VK_ACCESS_2_TRANSFER_READ_BIT,
        SYNC_COPY_TRANSFER_READ,
        SYNC_COPY_TRANSFER_READ_BIT
    },
    {
        "SYNC_COPY_TRANSFER_WRITE",
        VK_PIPELINE_STAGE_2_COPY_BIT,
        VK_ACCESS_2_TRANSFER_WRITE_BIT,
        SYNC_COPY_TRANSFER_WRITE,
        SYNC_COPY_TRANSFER_WRITE_BIT
    },
    {
        "SYNC_RESOLVE_TRANSFER_READ",
        VK_PIPELINE_STAGE_2_RESOLVE_BIT,
        VK_ACCESS_2_TRANSFER_READ_BIT,
        SYNC_RESOLVE_TRANSFER_READ,
        SYNC_RESOLVE_TRANSFER_READ_BIT
    },
    {
        "SYNC_RESOLVE_TRANSFER_WRITE",
        VK_PIPELINE_STAGE_2_RESOLVE_BIT,
        VK_ACCESS_2_TRANSFER_WRITE_BIT,
        SYNC_RESOLVE_TRANSFER_WRITE,
        SYNC_RESOLVE_TRANSFER_WRITE_BIT
    },
    {
        "SYNC_BLIT_TRANSFER_READ",
        VK_PIPELINE_STAGE_2_BLIT_BIT,
        VK_ACCESS_2_TRANSFER_READ_BIT,
        SYNC_BLIT_TRANSFER_READ,
        SYNC_BLIT_TRANSFER_READ_BIT
    },
    {
        "SYNC_BLIT_TRANSFER_WRITE",
        VK_PIPELINE_STAGE_2_BLIT_BIT,
        VK_ACCESS_2_TRANSFER_WRITE_BIT,
        SYNC_BLIT_TRANSFER_WRITE,
        SYNC_BLIT_TRANSFER_WRITE_BIT
    },
    {
        "SYNC_CLEAR_TRANSFER_WRITE",
        VK_PIPELINE_STAGE_2_CLEAR_BIT,
        VK_ACCESS_2_TRANSFER_WRITE_BIT,
        SYNC_CLEAR_TRANSFER_WRITE,
        SYNC_CLEAR_TRANSFER_WRITE_BIT
    },
    {
        "SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_READ_NV",
        VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV,
        VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV,
        SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_READ_NV,
        SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_READ_BIT_NV
    },
    {
        "SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_WRITE_NV",
        VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV,
        VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV,
        SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_WRITE_NV,
        SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_WRITE_BIT_NV
    },
    {
        "SYNC_CONDITIONAL_RENDERING_EXT_CONDITIONAL_RENDERING_READ_EXT",
        VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT,
        VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT,
        SYNC_CONDITIONAL_RENDERING_EXT_CONDITIONAL_RENDERING_READ_EXT,
        SYNC_CONDITIONAL_RENDERING_BIT_EXT_CONDITIONAL_RENDERING_READ_BIT_EXT
    },
    {
        "SYNC_RAY_TRACING_SHADER_ACCELERATION_STRUCTURE_READ",
        VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR,
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR,
        SYNC_RAY_TRACING_SHADER_ACCELERATION_STRUCTURE_READ,
        SYNC_RAY_TRACING_SHADER_ACCELERATION_STRUCTURE_READ_BIT
    },
    {
        "SYNC_RAY_TRACING_SHADER_SHADER_BINDING_TABLE_READ",
        VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR,
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR,
        SYNC_RAY_TRACING_SHADER_SHADER_BINDING_TABLE_READ,
        SYNC_RAY_TRACING_SHADER_SHADER_BINDING_TABLE_READ_BIT
    },
    {
        "SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ",
        VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR,
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT,
        SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ,
        SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ_BIT
    },
    {
        "SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ",
        VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR,
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT,
        SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ,
        SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ_BIT
    },
    {
        "SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE",
        VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR,
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT,
        SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE,
        SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE_BIT
    },
    {
        "SYNC_RAY_TRACING_SHADER_UNIFORM_READ",
        VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR,
        VK_ACCESS_2_UNIFORM_READ_BIT,
        SYNC_RAY_TRACING_SHADER_UNIFORM_READ,
        SYNC_RAY_TRACING_SHADER_UNIFORM_READ_BIT
    },
    {
        "SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_READ",
        VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR,
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR,
        SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_READ,
        SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_READ_BIT
    },
    {
        "SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_WRITE",
        VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR,
        VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR,
        SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_WRITE,
        SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_WRITE_BIT
    },
    {
        "SYNC_ACCELERATION_STRUCTURE_BUILD_INDIRECT_COMMAND_READ",
        VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR,
        VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT,
        SYNC_ACCELERATION_STRUCTURE_BUILD_INDIRECT_COMMAND_READ,
        SYNC_ACCELERATION_STRUCTURE_BUILD_INDIRECT_COMMAND_READ_BIT
    },
    {
        "SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_BINDING_TABLE_READ",
        VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR,
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR,
        SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_BINDING_TABLE_READ,
        SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_BINDING_TABLE_READ_BIT
    },
    {
        "SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_SAMPLED_READ",
        VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR,
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT,
        SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_SAMPLED_READ,
        SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_SAMPLED_READ_BIT
    },
    {
        "SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_STORAGE_READ",
        VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR,
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT,
        SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_STORAGE_READ,
        SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_STORAGE_READ_BIT
    },
    {
        "SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_READ",
        VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR,
        VK_ACCESS_2_TRANSFER_READ_BIT,
        SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_READ,
        SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_READ_BIT
    },
    {
        "SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_WRITE",
        VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR,
        VK_ACCESS_2_TRANSFER_WRITE_BIT,
        SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_WRITE,
        SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_WRITE_BIT
    },
    {
        "SYNC_ACCELERATION_STRUCTURE_BUILD_UNIFORM_READ",
        VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR,
        VK_ACCESS_2_UNIFORM_READ_BIT,
        SYNC_ACCELERATION_STRUCTURE_BUILD_UNIFORM_READ,
        SYNC_ACCELERATION_STRUCTURE_BUILD_UNIFORM_READ_BIT
    },
    {
        "SYNC_VIDEO_DECODE_VIDEO_DECODE_READ",
        VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR,
        VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR,
        SYNC_VIDEO_DECODE_VIDEO_DECODE_READ,
        SYNC_VIDEO_DECODE_VIDEO_DECODE_READ_BIT
    },
    {
        "SYNC_VIDEO_DECODE_VIDEO_DECODE_WRITE",
        VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR,
        VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR,
        SYNC_VIDEO_DECODE_VIDEO_DECODE_WRITE,
        SYNC_VIDEO_DECODE_VIDEO_DECODE_WRITE_BIT
    },
    {
        "SYNC_VIDEO_ENCODE_VIDEO_ENCODE_READ",
        VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR,
        VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR,
        SYNC_VIDEO_ENCODE_VIDEO_ENCODE_READ,
        SYNC_VIDEO_ENCODE_VIDEO_ENCODE_READ_BIT
    },
    {
        "SYNC_VIDEO_ENCODE_VIDEO_ENCODE_WRITE",
        VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR,
        VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR,
        SYNC_VIDEO_ENCODE_VIDEO_ENCODE_WRITE,
        SYNC_VIDEO_ENCODE_VIDEO_ENCODE_WRITE_BIT
    },
    {
        "SYNC_SUBPASS_SHADING_HUAWEI_INPUT_ATTACHMENT_READ",
        VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI,
        VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT,
        SYNC_SUBPASS_SHADING_HUAWEI_INPUT_ATTACHMENT_READ,
        SYNC_SUBPASS_SHADING_HUAWEI_INPUT_ATTACHMENT_READ_BIT
    },
    {
        "SYNC_HOST_HOST_READ",
        VK_PIPELINE_STAGE_2_HOST_BIT,
        VK_ACCESS_2_HOST_READ_BIT,
        SYNC_HOST_HOST_READ,
        SYNC_HOST_HOST_READ_BIT
    },
    {
        "SYNC_HOST_HOST_WRITE",
        VK_PIPELINE_STAGE_2_HOST_BIT,
        VK_ACCESS_2_HOST_WRITE_BIT,
        SYNC_HOST_HOST_WRITE,
        SYNC_HOST_HOST_WRITE_BIT
    },
    {
        "SYNC_IMAGE_LAYOUT_TRANSITION",
        VK_PIPELINE_STAGE_2_NONE_KHR,
        VK_ACCESS_2_NONE_KHR,
        SYNC_IMAGE_LAYOUT_TRANSITION,
        SYNC_IMAGE_LAYOUT_TRANSITION_BIT
    },
    {
        "SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER",
        VK_PIPELINE_STAGE_2_NONE_KHR,
        VK_ACCESS_2_NONE_KHR,
        SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER,
        SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER_BIT
    },
} };

// Constants defining the mask of all read and write stage_access states
// Bit order mask of stage_access bit for each stage
const std::map<VkPipelineStageFlags2, SyncStageAccessFlags> syncStageAccessMaskByStageBit {
    { VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, (
        SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ_BIT |
        SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT
    )},
    { VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT, (
        SYNC_VERTEX_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_VERTEX_SHADER_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_VERTEX_SHADER_SHADER_SAMPLED_READ_BIT |
        SYNC_VERTEX_SHADER_SHADER_STORAGE_READ_BIT |
        SYNC_VERTEX_SHADER_SHADER_STORAGE_WRITE_BIT |
        SYNC_VERTEX_SHADER_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT, (
        SYNC_TESSELLATION_CONTROL_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_SAMPLED_READ_BIT |
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_READ_BIT |
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_WRITE_BIT |
        SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT, (
        SYNC_TESSELLATION_EVALUATION_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_SAMPLED_READ_BIT |
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_READ_BIT |
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_WRITE_BIT |
        SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT, (
        SYNC_GEOMETRY_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_GEOMETRY_SHADER_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_GEOMETRY_SHADER_SHADER_SAMPLED_READ_BIT |
        SYNC_GEOMETRY_SHADER_SHADER_STORAGE_READ_BIT |
        SYNC_GEOMETRY_SHADER_SHADER_STORAGE_WRITE_BIT |
        SYNC_GEOMETRY_SHADER_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT, (
        SYNC_FRAGMENT_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ_BIT |
        SYNC_FRAGMENT_SHADER_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_FRAGMENT_SHADER_SHADER_SAMPLED_READ_BIT |
        SYNC_FRAGMENT_SHADER_SHADER_STORAGE_READ_BIT |
        SYNC_FRAGMENT_SHADER_SHADER_STORAGE_WRITE_BIT |
        SYNC_FRAGMENT_SHADER_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, (
        SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT |
        SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, (
        SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT |
        SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT, (
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_BIT |
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT |
        SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT, (
        SYNC_COMPUTE_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_COMPUTE_SHADER_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_COMPUTE_SHADER_SHADER_SAMPLED_READ_BIT |
        SYNC_COMPUTE_SHADER_SHADER_STORAGE_READ_BIT |
        SYNC_COMPUTE_SHADER_SHADER_STORAGE_WRITE_BIT |
        SYNC_COMPUTE_SHADER_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_HOST_BIT, (
        SYNC_HOST_HOST_READ_BIT |
        SYNC_HOST_HOST_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV, (
        SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_READ_BIT_NV |
        SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_WRITE_BIT_NV
    )},
    { VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, SYNC_CONDITIONAL_RENDERING_BIT_EXT_CONDITIONAL_RENDERING_READ_BIT_EXT},
    { VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV, (
        SYNC_TASK_SHADER_NV_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_TASK_SHADER_NV_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_TASK_SHADER_NV_SHADER_SAMPLED_READ_BIT |
        SYNC_TASK_SHADER_NV_SHADER_STORAGE_READ_BIT |
        SYNC_TASK_SHADER_NV_SHADER_STORAGE_WRITE_BIT |
        SYNC_TASK_SHADER_NV_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV, (
        SYNC_MESH_SHADER_NV_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_MESH_SHADER_NV_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_MESH_SHADER_NV_SHADER_SAMPLED_READ_BIT |
        SYNC_MESH_SHADER_NV_SHADER_STORAGE_READ_BIT |
        SYNC_MESH_SHADER_NV_SHADER_STORAGE_WRITE_BIT |
        SYNC_MESH_SHADER_NV_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR, (
        SYNC_RAY_TRACING_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_RAY_TRACING_SHADER_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ_BIT |
        SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ_BIT |
        SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE_BIT |
        SYNC_RAY_TRACING_SHADER_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, SYNC_FRAGMENT_SHADING_RATE_ATTACHMENT_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT},
    { VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, SYNC_FRAGMENT_DENSITY_PROCESS_BIT_EXT_FRAGMENT_DENSITY_MAP_READ_BIT_EXT},
    { VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, (
        SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT |
        SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT |
        SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_WRITE_BIT_EXT
    )},
    { VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, (
        SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_WRITE_BIT |
        SYNC_ACCELERATION_STRUCTURE_BUILD_INDIRECT_COMMAND_READ_BIT |
        SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_SAMPLED_READ_BIT |
        SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_STORAGE_READ_BIT |
        SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_READ_BIT |
        SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_WRITE_BIT |
        SYNC_ACCELERATION_STRUCTURE_BUILD_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR, (
        SYNC_VIDEO_DECODE_VIDEO_DECODE_READ_BIT |
        SYNC_VIDEO_DECODE_VIDEO_DECODE_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR, (
        SYNC_VIDEO_ENCODE_VIDEO_ENCODE_READ_BIT |
        SYNC_VIDEO_ENCODE_VIDEO_ENCODE_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_2_COPY_BIT, (
        SYNC_COPY_TRANSFER_READ_BIT |
        SYNC_COPY_TRANSFER_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_2_RESOLVE_BIT, (
        SYNC_RESOLVE_TRANSFER_READ_BIT |
        SYNC_RESOLVE_TRANSFER_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_2_BLIT_BIT, (
        SYNC_BLIT_TRANSFER_READ_BIT |
        SYNC_BLIT_TRANSFER_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_2_CLEAR_BIT, SYNC_CLEAR_TRANSFER_WRITE_BIT},
    { VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT, SYNC_INDEX_INPUT_INDEX_READ_BIT},
    { VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT, SYNC_VERTEX_ATTRIBUTE_INPUT_VERTEX_ATTRIBUTE_READ_BIT},
    { VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI, SYNC_SUBPASS_SHADING_HUAWEI_INPUT_ATTACHMENT_READ_BIT},
};

// Bit order mask of stage_access bit for each access
const std::map<VkAccessFlags2, SyncStageAccessFlags> syncStageAccessMaskByAccessBit {
    { VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT, (
        SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ_BIT |
        SYNC_ACCELERATION_STRUCTURE_BUILD_INDIRECT_COMMAND_READ_BIT
    )},
    { VK_ACCESS_2_INDEX_READ_BIT, SYNC_INDEX_INPUT_INDEX_READ_BIT},
    { VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT, SYNC_VERTEX_ATTRIBUTE_INPUT_VERTEX_ATTRIBUTE_READ_BIT},
    { VK_ACCESS_2_UNIFORM_READ_BIT, (
        SYNC_VERTEX_SHADER_UNIFORM_READ_BIT |
        SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ_BIT |
        SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ_BIT |
        SYNC_GEOMETRY_SHADER_UNIFORM_READ_BIT |
        SYNC_TASK_SHADER_NV_UNIFORM_READ_BIT |
        SYNC_MESH_SHADER_NV_UNIFORM_READ_BIT |
        SYNC_FRAGMENT_SHADER_UNIFORM_READ_BIT |
        SYNC_COMPUTE_SHADER_UNIFORM_READ_BIT |
        SYNC_RAY_TRACING_SHADER_UNIFORM_READ_BIT |
        SYNC_ACCELERATION_STRUCTURE_BUILD_UNIFORM_READ_BIT
    )},
    { VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT, (
        SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ_BIT |
        SYNC_SUBPASS_SHADING_HUAWEI_INPUT_ATTACHMENT_READ_BIT
    )},
    { VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_BIT},
    { VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE_BIT},
    { VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT, (
        SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT |
        SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT
    )},
    { VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, (
        SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT |
        SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT
    )},
    { VK_ACCESS_2_TRANSFER_READ_BIT, (
        SYNC_COPY_TRANSFER_READ_BIT |
        SYNC_RESOLVE_TRANSFER_READ_BIT |
        SYNC_BLIT_TRANSFER_READ_BIT |
        SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_READ_BIT
    )},
    { VK_ACCESS_2_TRANSFER_WRITE_BIT, (
        SYNC_COPY_TRANSFER_WRITE_BIT |
        SYNC_RESOLVE_TRANSFER_WRITE_BIT |
        SYNC_BLIT_TRANSFER_WRITE_BIT |
        SYNC_CLEAR_TRANSFER_WRITE_BIT |
        SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_WRITE_BIT
    )},
    { VK_ACCESS_2_HOST_READ_BIT, SYNC_HOST_HOST_READ_BIT},
    { VK_ACCESS_2_HOST_WRITE_BIT, SYNC_HOST_HOST_WRITE_BIT},
    { VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV, SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_READ_BIT_NV},
    { VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV, SYNC_COMMAND_PREPROCESS_BIT_NV_COMMAND_PREPROCESS_WRITE_BIT_NV},
    { VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT},
    { VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT, SYNC_CONDITIONAL_RENDERING_BIT_EXT_CONDITIONAL_RENDERING_READ_BIT_EXT},
    { VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, (
        SYNC_VERTEX_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_TESSELLATION_CONTROL_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_TESSELLATION_EVALUATION_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_GEOMETRY_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_TASK_SHADER_NV_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_MESH_SHADER_NV_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_FRAGMENT_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_COMPUTE_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_RAY_TRACING_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
        SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_READ_BIT
    )},
    { VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_WRITE_BIT},
    { VK_ACCESS_2_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR, SYNC_FRAGMENT_SHADING_RATE_ATTACHMENT_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT},
    { VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, SYNC_FRAGMENT_DENSITY_PROCESS_BIT_EXT_FRAGMENT_DENSITY_MAP_READ_BIT_EXT},
    { VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_WRITE_BIT_EXT},
    { VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, (
        SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT |
        SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT
    )},
    { VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT},
    { VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, (
        SYNC_VERTEX_SHADER_SHADER_SAMPLED_READ_BIT |
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_SAMPLED_READ_BIT |
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_SAMPLED_READ_BIT |
        SYNC_GEOMETRY_SHADER_SHADER_SAMPLED_READ_BIT |
        SYNC_TASK_SHADER_NV_SHADER_SAMPLED_READ_BIT |
        SYNC_MESH_SHADER_NV_SHADER_SAMPLED_READ_BIT |
        SYNC_FRAGMENT_SHADER_SHADER_SAMPLED_READ_BIT |
        SYNC_COMPUTE_SHADER_SHADER_SAMPLED_READ_BIT |
        SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ_BIT |
        SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_SAMPLED_READ_BIT
    )},
    { VK_ACCESS_2_SHADER_STORAGE_READ_BIT, (
        SYNC_VERTEX_SHADER_SHADER_STORAGE_READ_BIT |
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_READ_BIT |
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_READ_BIT |
        SYNC_GEOMETRY_SHADER_SHADER_STORAGE_READ_BIT |
        SYNC_TASK_SHADER_NV_SHADER_STORAGE_READ_BIT |
        SYNC_MESH_SHADER_NV_SHADER_STORAGE_READ_BIT |
        SYNC_FRAGMENT_SHADER_SHADER_STORAGE_READ_BIT |
        SYNC_COMPUTE_SHADER_SHADER_STORAGE_READ_BIT |
        SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ_BIT |
        SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_STORAGE_READ_BIT
    )},
    { VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, (
        SYNC_VERTEX_SHADER_SHADER_STORAGE_WRITE_BIT |
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_WRITE_BIT |
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_WRITE_BIT |
        SYNC_GEOMETRY_SHADER_SHADER_STORAGE_WRITE_BIT |
        SYNC_TASK_SHADER_NV_SHADER_STORAGE_WRITE_BIT |
        SYNC_MESH_SHADER_NV_SHADER_STORAGE_WRITE_BIT |
        SYNC_FRAGMENT_SHADER_SHADER_STORAGE_WRITE_BIT |
        SYNC_COMPUTE_SHADER_SHADER_STORAGE_WRITE_BIT |
        SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE_BIT
    )},
    { VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR, SYNC_VIDEO_DECODE_VIDEO_DECODE_READ_BIT},
    { VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR, SYNC_VIDEO_DECODE_VIDEO_DECODE_WRITE_BIT},
    { VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR, SYNC_VIDEO_ENCODE_VIDEO_ENCODE_READ_BIT},
    { VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR, SYNC_VIDEO_ENCODE_VIDEO_ENCODE_WRITE_BIT},
    { VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, (
        SYNC_VERTEX_SHADER_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_GEOMETRY_SHADER_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_TASK_SHADER_NV_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_MESH_SHADER_NV_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_FRAGMENT_SHADER_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_COMPUTE_SHADER_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_RAY_TRACING_SHADER_SHADER_BINDING_TABLE_READ_BIT |
        SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_BINDING_TABLE_READ_BIT
    )},
    { VK_ACCESS_2_MEMORY_READ_BIT, syncStageAccessReadMask},
    { VK_ACCESS_2_MEMORY_WRITE_BIT, syncStageAccessWriteMask},
};

// stage_access index for each stage and access
const std::map<VkPipelineStageFlags2, std::map<VkAccessFlags2, SyncStageAccessIndex>> syncStageAccessIndexByStageAndAccess {
    { VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, {
        { VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_READ },
        { VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_WRITE },
        { VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT, SYNC_ACCELERATION_STRUCTURE_BUILD_INDIRECT_COMMAND_READ },
        { VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_BINDING_TABLE_READ },
        { VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_SAMPLED_READ },
        { VK_ACCESS_2_SHADER_STORAGE_READ_BIT, SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_STORAGE_READ },
        { VK_ACCESS_2_TRANSFER_READ_BIT, SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_READ },
        { VK_ACCESS_2_TRANSFER_WRITE_BIT, SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_WRITE },
        { VK_ACCESS_2_UNIFORM_READ_BIT, SYNC_ACCELERATION_STRUCTURE_BUILD_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_2_BLIT_BIT, {
        { VK_ACCESS_2_TRANSFER_READ_BIT, SYNC_BLIT_TRANSFER_READ },
        { VK_ACCESS_2_TRANSFER_WRITE_BIT, SYNC_BLIT_TRANSFER_WRITE }
    } },
    { VK_PIPELINE_STAGE_2_CLEAR_BIT, {
        { VK_ACCESS_2_TRANSFER_WRITE_BIT, SYNC_CLEAR_TRANSFER_WRITE }
    } },
    { VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT, {
        { VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ },
        { VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_EXT },
        { VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT, SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE }
    } },
    { VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV, {
        { VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV, SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_READ_NV },
        { VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV, SYNC_COMMAND_PREPROCESS_NV_COMMAND_PREPROCESS_WRITE_NV }
    } },
    { VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT, {
        { VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, SYNC_COMPUTE_SHADER_ACCELERATION_STRUCTURE_READ },
        { VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, SYNC_COMPUTE_SHADER_SHADER_BINDING_TABLE_READ },
        { VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, SYNC_COMPUTE_SHADER_SHADER_SAMPLED_READ },
        { VK_ACCESS_2_SHADER_STORAGE_READ_BIT, SYNC_COMPUTE_SHADER_SHADER_STORAGE_READ },
        { VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, SYNC_COMPUTE_SHADER_SHADER_STORAGE_WRITE },
        { VK_ACCESS_2_UNIFORM_READ_BIT, SYNC_COMPUTE_SHADER_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, {
        { VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT, SYNC_CONDITIONAL_RENDERING_EXT_CONDITIONAL_RENDERING_READ_EXT }
    } },
    { VK_PIPELINE_STAGE_2_COPY_BIT, {
        { VK_ACCESS_2_TRANSFER_READ_BIT, SYNC_COPY_TRANSFER_READ },
        { VK_ACCESS_2_TRANSFER_WRITE_BIT, SYNC_COPY_TRANSFER_WRITE }
    } },
    { VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, {
        { VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT, SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ },
        { VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT }
    } },
    { VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, {
        { VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT, SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ },
        { VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE }
    } },
    { VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, {
        { VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, SYNC_FRAGMENT_DENSITY_PROCESS_EXT_FRAGMENT_DENSITY_MAP_READ_EXT }
    } },
    { VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT, {
        { VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, SYNC_FRAGMENT_SHADER_ACCELERATION_STRUCTURE_READ },
        { VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT, SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ },
        { VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, SYNC_FRAGMENT_SHADER_SHADER_BINDING_TABLE_READ },
        { VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, SYNC_FRAGMENT_SHADER_SHADER_SAMPLED_READ },
        { VK_ACCESS_2_SHADER_STORAGE_READ_BIT, SYNC_FRAGMENT_SHADER_SHADER_STORAGE_READ },
        { VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, SYNC_FRAGMENT_SHADER_SHADER_STORAGE_WRITE },
        { VK_ACCESS_2_UNIFORM_READ_BIT, SYNC_FRAGMENT_SHADER_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, {
        { VK_ACCESS_2_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR, SYNC_FRAGMENT_SHADING_RATE_ATTACHMENT_FRAGMENT_SHADING_RATE_ATTACHMENT_READ }
    } },
    { VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT, {
        { VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, SYNC_GEOMETRY_SHADER_ACCELERATION_STRUCTURE_READ },
        { VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, SYNC_GEOMETRY_SHADER_SHADER_BINDING_TABLE_READ },
        { VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, SYNC_GEOMETRY_SHADER_SHADER_SAMPLED_READ },
        { VK_ACCESS_2_SHADER_STORAGE_READ_BIT, SYNC_GEOMETRY_SHADER_SHADER_STORAGE_READ },
        { VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, SYNC_GEOMETRY_SHADER_SHADER_STORAGE_WRITE },
        { VK_ACCESS_2_UNIFORM_READ_BIT, SYNC_GEOMETRY_SHADER_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_2_HOST_BIT, {
        { VK_ACCESS_2_HOST_READ_BIT, SYNC_HOST_HOST_READ },
        { VK_ACCESS_2_HOST_WRITE_BIT, SYNC_HOST_HOST_WRITE }
    } },
    { VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT, {
        { VK_ACCESS_2_INDEX_READ_BIT, SYNC_INDEX_INPUT_INDEX_READ }
    } },
    { VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, {
        { VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT, SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ },
        { VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE }
    } },
    { VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV, {
        { VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, SYNC_MESH_SHADER_NV_ACCELERATION_STRUCTURE_READ },
        { VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, SYNC_MESH_SHADER_NV_SHADER_BINDING_TABLE_READ },
        { VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, SYNC_MESH_SHADER_NV_SHADER_SAMPLED_READ },
        { VK_ACCESS_2_SHADER_STORAGE_READ_BIT, SYNC_MESH_SHADER_NV_SHADER_STORAGE_READ },
        { VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, SYNC_MESH_SHADER_NV_SHADER_STORAGE_WRITE },
        { VK_ACCESS_2_UNIFORM_READ_BIT, SYNC_MESH_SHADER_NV_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR, {
        { VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, SYNC_RAY_TRACING_SHADER_ACCELERATION_STRUCTURE_READ },
        { VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, SYNC_RAY_TRACING_SHADER_SHADER_BINDING_TABLE_READ },
        { VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ },
        { VK_ACCESS_2_SHADER_STORAGE_READ_BIT, SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ },
        { VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE },
        { VK_ACCESS_2_UNIFORM_READ_BIT, SYNC_RAY_TRACING_SHADER_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_2_RESOLVE_BIT, {
        { VK_ACCESS_2_TRANSFER_READ_BIT, SYNC_RESOLVE_TRANSFER_READ },
        { VK_ACCESS_2_TRANSFER_WRITE_BIT, SYNC_RESOLVE_TRANSFER_WRITE }
    } },
    { VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI, {
        { VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT, SYNC_SUBPASS_SHADING_HUAWEI_INPUT_ATTACHMENT_READ }
    } },
    { VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV, {
        { VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, SYNC_TASK_SHADER_NV_ACCELERATION_STRUCTURE_READ },
        { VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, SYNC_TASK_SHADER_NV_SHADER_BINDING_TABLE_READ },
        { VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, SYNC_TASK_SHADER_NV_SHADER_SAMPLED_READ },
        { VK_ACCESS_2_SHADER_STORAGE_READ_BIT, SYNC_TASK_SHADER_NV_SHADER_STORAGE_READ },
        { VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, SYNC_TASK_SHADER_NV_SHADER_STORAGE_WRITE },
        { VK_ACCESS_2_UNIFORM_READ_BIT, SYNC_TASK_SHADER_NV_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT, {
        { VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, SYNC_TESSELLATION_CONTROL_SHADER_ACCELERATION_STRUCTURE_READ },
        { VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, SYNC_TESSELLATION_CONTROL_SHADER_SHADER_BINDING_TABLE_READ },
        { VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, SYNC_TESSELLATION_CONTROL_SHADER_SHADER_SAMPLED_READ },
        { VK_ACCESS_2_SHADER_STORAGE_READ_BIT, SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_READ },
        { VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_WRITE },
        { VK_ACCESS_2_UNIFORM_READ_BIT, SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT, {
        { VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, SYNC_TESSELLATION_EVALUATION_SHADER_ACCELERATION_STRUCTURE_READ },
        { VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_BINDING_TABLE_READ },
        { VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_SAMPLED_READ },
        { VK_ACCESS_2_SHADER_STORAGE_READ_BIT, SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_READ },
        { VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_WRITE },
        { VK_ACCESS_2_UNIFORM_READ_BIT, SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, {
        { VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT },
        { VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_EXT },
        { VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_WRITE_EXT }
    } },
    { VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT, {
        { VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT, SYNC_VERTEX_ATTRIBUTE_INPUT_VERTEX_ATTRIBUTE_READ }
    } },
    { VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT, {
        { VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, SYNC_VERTEX_SHADER_ACCELERATION_STRUCTURE_READ },
        { VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, SYNC_VERTEX_SHADER_SHADER_BINDING_TABLE_READ },
        { VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, SYNC_VERTEX_SHADER_SHADER_SAMPLED_READ },
        { VK_ACCESS_2_SHADER_STORAGE_READ_BIT, SYNC_VERTEX_SHADER_SHADER_STORAGE_READ },
        { VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, SYNC_VERTEX_SHADER_SHADER_STORAGE_WRITE },
        { VK_ACCESS_2_UNIFORM_READ_BIT, SYNC_VERTEX_SHADER_UNIFORM_READ }
    } },
    { VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR, {
        { VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR, SYNC_VIDEO_DECODE_VIDEO_DECODE_READ },
        { VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR, SYNC_VIDEO_DECODE_VIDEO_DECODE_WRITE }
    } },
    { VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR, {
        { VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR, SYNC_VIDEO_ENCODE_VIDEO_ENCODE_READ },
        { VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR, SYNC_VIDEO_ENCODE_VIDEO_ENCODE_WRITE }
    } },
};

// Direct VkPipelineStageFlags to valid VkAccessFlags lookup table
const std::map<VkPipelineStageFlags2, VkAccessFlags2> syncDirectStageToAccessMask {
    { VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, (
        VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT |
        VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT
    )},
    { VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT, (
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT |
        VK_ACCESS_2_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT, (
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT |
        VK_ACCESS_2_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT, (
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT |
        VK_ACCESS_2_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT, (
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT |
        VK_ACCESS_2_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT, (
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR |
        VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT |
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT |
        VK_ACCESS_2_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, (
        VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT |
        VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, (
        VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT |
        VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT, (
        VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT |
        VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT |
        VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT, (
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT |
        VK_ACCESS_2_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_HOST_BIT, (
        VK_ACCESS_2_HOST_READ_BIT |
        VK_ACCESS_2_HOST_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV, (
        VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV |
        VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV
    )},
    { VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT},
    { VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV, (
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT |
        VK_ACCESS_2_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV, (
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT |
        VK_ACCESS_2_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR, (
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT |
        VK_ACCESS_2_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, VK_ACCESS_2_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR},
    { VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT},
    { VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, (
        VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT |
        VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT |
        VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT
    )},
    { VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, (
        VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR |
        VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR |
        VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT |
        VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR |
        VK_ACCESS_2_SHADER_SAMPLED_READ_BIT |
        VK_ACCESS_2_SHADER_STORAGE_READ_BIT |
        VK_ACCESS_2_TRANSFER_READ_BIT |
        VK_ACCESS_2_TRANSFER_WRITE_BIT |
        VK_ACCESS_2_UNIFORM_READ_BIT
    )},
    { VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR, (
        VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR |
        VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR
    )},
    { VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR, (
        VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR |
        VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR
    )},
    { VK_PIPELINE_STAGE_2_COPY_BIT, (
        VK_ACCESS_2_TRANSFER_READ_BIT |
        VK_ACCESS_2_TRANSFER_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_2_RESOLVE_BIT, (
        VK_ACCESS_2_TRANSFER_READ_BIT |
        VK_ACCESS_2_TRANSFER_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_2_BLIT_BIT, (
        VK_ACCESS_2_TRANSFER_READ_BIT |
        VK_ACCESS_2_TRANSFER_WRITE_BIT
    )},
    { VK_PIPELINE_STAGE_2_CLEAR_BIT, VK_ACCESS_2_TRANSFER_WRITE_BIT},
    { VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT, VK_ACCESS_2_INDEX_READ_BIT},
    { VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT, VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT},
    { VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI, VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT},
};

// Pipeline stages corresponding to VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT for each VkQueueFlagBits
const std::map<VkQueueFlagBits, VkPipelineStageFlags2> syncAllCommandStagesByQueueFlags {
    { VK_QUEUE_COMPUTE_BIT, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT |
        VK_PIPELINE_STAGE_2_COPY_BIT |
        VK_PIPELINE_STAGE_2_RESOLVE_BIT |
        VK_PIPELINE_STAGE_2_BLIT_BIT |
        VK_PIPELINE_STAGE_2_CLEAR_BIT |
        VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV |
        VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT |
        VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR |
        VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_HOST_BIT
    )},
    { VK_QUEUE_GRAPHICS_BIT, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT |
        VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_COPY_BIT |
        VK_PIPELINE_STAGE_2_RESOLVE_BIT |
        VK_PIPELINE_STAGE_2_BLIT_BIT |
        VK_PIPELINE_STAGE_2_CLEAR_BIT |
        VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV |
        VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT |
        VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_HOST_BIT
    )},
    { VK_QUEUE_TRANSFER_BIT, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_COPY_BIT |
        VK_PIPELINE_STAGE_2_RESOLVE_BIT |
        VK_PIPELINE_STAGE_2_BLIT_BIT |
        VK_PIPELINE_STAGE_2_CLEAR_BIT |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_HOST_BIT
    )},
    { VK_QUEUE_VIDEO_DECODE_BIT_KHR, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_HOST_BIT
    )},
    { VK_QUEUE_VIDEO_ENCODE_BIT_KHR, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_HOST_BIT
    )},
};

// Masks of logically earlier stage flags for a given stage flag
const std::map<VkPipelineStageFlags2, VkPipelineStageFlags2> syncLogicallyEarlierStages {
    { VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT, VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT
    )},
    { VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT
    )},
    { VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT
    )},
    { VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT
    )},
    { VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT
    )},
    { VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT
    )},
    { VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT
    )},
    { VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT
    )},
    { VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV
    )},
    { VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV
    )},
    { VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT |
        VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR
    )},
    { VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT |
        VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT
    )},
    { VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT |
        VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT
    )},
    { VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT |
        VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT
    )},
    { VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT
    )},
    { VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_CLEAR_BIT, VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV, VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT
    )},
    { VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR, VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR, VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI, VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT |
        VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT |
        VK_PIPELINE_STAGE_2_COPY_BIT |
        VK_PIPELINE_STAGE_2_RESOLVE_BIT |
        VK_PIPELINE_STAGE_2_BLIT_BIT |
        VK_PIPELINE_STAGE_2_CLEAR_BIT |
        VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV |
        VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT |
        VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR |
        VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR |
        VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR |
        VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR |
        VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT
    )},
};

// Masks of logically later stage flags for a given stage flag
const std::map<VkPipelineStageFlags2, VkPipelineStageFlags2> syncLogicallyLaterStages {
    { VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT, (
        VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT |
        VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT |
        VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT |
        VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT |
        VK_PIPELINE_STAGE_2_COPY_BIT |
        VK_PIPELINE_STAGE_2_RESOLVE_BIT |
        VK_PIPELINE_STAGE_2_BLIT_BIT |
        VK_PIPELINE_STAGE_2_CLEAR_BIT |
        VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV |
        VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT |
        VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR |
        VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR |
        VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR |
        VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR |
        VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, (
        VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT |
        VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT, (
        VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT |
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT, (
        VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT, (
        VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT, (
        VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT |
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT, (
        VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT |
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT, (
        VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, (
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, (
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV, (
        VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV, (
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR |
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, (
        VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, (
        VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT |
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT, (
        VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT |
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, (
        VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT |
        VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT
    )},
    { VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT, VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT, VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_CLEAR_BIT, VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV, VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR, VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR, VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR, VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI, VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT},
    { VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT, VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT},
};

// Lookup table of stage orderings
const std::map<VkPipelineStageFlags2, int> syncStageOrder {
    { VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT, 0},
    { VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, 1},
    { VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT, 2},
    { VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT, 3},
    { VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT, 4},
    { VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT, 5},
    { VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT, 6},
    { VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT, 7},
    { VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, 8},
    { VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, 9},
    { VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV, 10},
    { VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV, 11},
    { VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, 12},
    { VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, 13},
    { VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT, 14},
    { VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, 15},
    { VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT, 16},
    { VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT, 17},
    { VK_PIPELINE_STAGE_2_COPY_BIT, 18},
    { VK_PIPELINE_STAGE_2_RESOLVE_BIT, 19},
    { VK_PIPELINE_STAGE_2_BLIT_BIT, 20},
    { VK_PIPELINE_STAGE_2_CLEAR_BIT, 21},
    { VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV, 22},
    { VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, 23},
    { VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR, 24},
    { VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, 25},
    { VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR, 26},
    { VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR, 27},
    { VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI, 28},
    { VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT, 29},
    { VK_PIPELINE_STAGE_2_HOST_BIT, 30},
};

const std::map<VkShaderStageFlagBits, SyncShaderStageAccess> syncStageAccessMaskByShaderStage {
    {VK_SHADER_STAGE_VERTEX_BIT, {
        SYNC_VERTEX_SHADER_SHADER_SAMPLED_READ, SYNC_VERTEX_SHADER_SHADER_STORAGE_READ, SYNC_VERTEX_SHADER_SHADER_STORAGE_WRITE, SYNC_VERTEX_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT, {
        SYNC_TESSELLATION_CONTROL_SHADER_SHADER_SAMPLED_READ, SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_READ, SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_WRITE, SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT, {
        SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_SAMPLED_READ, SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_READ, SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_WRITE, SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_GEOMETRY_BIT, {
        SYNC_GEOMETRY_SHADER_SHADER_SAMPLED_READ, SYNC_GEOMETRY_SHADER_SHADER_STORAGE_READ, SYNC_GEOMETRY_SHADER_SHADER_STORAGE_WRITE, SYNC_GEOMETRY_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_FRAGMENT_BIT, {
        SYNC_FRAGMENT_SHADER_SHADER_SAMPLED_READ, SYNC_FRAGMENT_SHADER_SHADER_STORAGE_READ, SYNC_FRAGMENT_SHADER_SHADER_STORAGE_WRITE, SYNC_FRAGMENT_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_COMPUTE_BIT, {
        SYNC_COMPUTE_SHADER_SHADER_SAMPLED_READ, SYNC_COMPUTE_SHADER_SHADER_STORAGE_READ, SYNC_COMPUTE_SHADER_SHADER_STORAGE_WRITE, SYNC_COMPUTE_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_RAYGEN_BIT_KHR, {
        SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ, SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ, SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE, SYNC_RAY_TRACING_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_ANY_HIT_BIT_KHR, {
        SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ, SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ, SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE, SYNC_RAY_TRACING_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_CLOSEST_HIT_BIT_KHR, {
        SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ, SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ, SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE, SYNC_RAY_TRACING_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_MISS_BIT_KHR, {
        SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ, SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ, SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE, SYNC_RAY_TRACING_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_INTERSECTION_BIT_KHR, {
        SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ, SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ, SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE, SYNC_RAY_TRACING_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_CALLABLE_BIT_KHR, {
        SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ, SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ, SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE, SYNC_RAY_TRACING_SHADER_UNIFORM_READ}},
    {VK_SHADER_STAGE_TASK_BIT_NV, {
        SYNC_TASK_SHADER_NV_SHADER_SAMPLED_READ, SYNC_TASK_SHADER_NV_SHADER_STORAGE_READ, SYNC_TASK_SHADER_NV_SHADER_STORAGE_WRITE, SYNC_TASK_SHADER_NV_UNIFORM_READ}},
    {VK_SHADER_STAGE_MESH_BIT_NV, {
        SYNC_MESH_SHADER_NV_SHADER_SAMPLED_READ, SYNC_MESH_SHADER_NV_SHADER_STORAGE_READ, SYNC_MESH_SHADER_NV_SHADER_STORAGE_WRITE, SYNC_MESH_SHADER_NV_UNIFORM_READ}},
};
