/* *** THIS FILE IS GENERATED - DO NOT EDIT! ***
 * See parameter_validation_generator.py for modifications
 *
 * Copyright (c) 2015-2023 The Khronos Group Inc.
 * Copyright (c) 2015-2023 LunarG, Inc.
 * Copyright (C) 2015-2023 Google Inc.
 * Copyright (c) 2015-2023 Valve Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Author: Mark Lobodzinski <mark@LunarG.com>
 * Author: Dave Houlton <daveh@LunarG.com>
 */


#include "chassis.h"

#include "stateless_validation.h"
#include "enum_flag_bits.h"

bool StatelessValidation::CheckPromotedApiAgainstVulkanVersion(VkInstance instance, const char *api_name, const uint32_t promoted_version) const {
    bool skip = false;
    if (api_version < promoted_version) {
        skip = LogError(instance,
                        kVUID_PVError_ApiVersionViolation, "Attempted to call %s() with an effective API version of %s"
                        "but this API was not promoted until version %s.", api_name, StringAPIVersion(api_version).c_str(),
                        StringAPIVersion(promoted_version).c_str());
    }
    return skip;
}

bool StatelessValidation::CheckPromotedApiAgainstVulkanVersion(VkPhysicalDevice pdev, const char *api_name, const uint32_t promoted_version) const {
    bool skip = false;
    const auto &target_pdev = physical_device_properties_map.find(pdev);
    if (target_pdev != physical_device_properties_map.end()) {
        auto effective_api_version = std::min(target_pdev->second->apiVersion, api_version);
        if (effective_api_version < promoted_version) {
            skip = LogError(instance,
                            kVUID_PVError_ApiVersionViolation, "Attempted to call %s() with an effective API version of %s, "
                            "which is the minimum of version requested in pApplicationInfo (%s) and supported by this physical device (%s), "
                            "but this API was not promoted until version %s.", api_name, StringAPIVersion(effective_api_version).c_str(),
                            StringAPIVersion(api_version).c_str(), StringAPIVersion(target_pdev->second->apiVersion).c_str(),
                            StringAPIVersion(promoted_version).c_str());
        }
    }
    return skip;
}

bool StatelessValidation::ValidatePnextStructContents(const char *api_name, const ParameterName &parameter_name,
                                                      const VkBaseOutStructure* header, const char *pnext_vuid, bool is_physdev_api, bool is_const_param) const {
    bool skip = false;
    switch(header->sType) {

        // Validation code for VkShaderModuleCreateInfo structure members
        case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO: { // Covers VUID-VkShaderModuleCreateInfo-sType-sType
            if (is_const_param) {
                VkShaderModuleCreateInfo *structure = (VkShaderModuleCreateInfo *) header;
                skip |= ValidateReservedFlags("VkShaderModuleCreateInfo", "flags", structure->flags, "VUID-VkShaderModuleCreateInfo-flags-zerobitmask");

                skip |= ValidateArray("VkShaderModuleCreateInfo", "codeSize / 4", "pCode", structure->codeSize / 4, &structure->pCode, true, true, kVUIDUndefined, "VUID-VkShaderModuleCreateInfo-pCode-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceSubgroupProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES: { // Covers VUID-VkPhysicalDeviceSubgroupProperties-sType-sType
            if (api_version < VK_API_VERSION_1_1) {
                skip |= LogError(
                           instance, pnext_vuid,
                           "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES) which was added in VK_API_VERSION_1_1 but the "
                           "current effective API version is %s.",
                           api_name, parameter_name.get_name().c_str(), StringAPIVersion(api_version).c_str());
            }
        } break;

        // Validation code for VkPhysicalDevice16BitStorageFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES: { // Covers VUID-VkPhysicalDevice16BitStorageFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_16BIT_STORAGE_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_16bit_storage))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES), but its parent extension "
                               "VK_KHR_16bit_storage has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDevice16BitStorageFeatures *structure = (VkPhysicalDevice16BitStorageFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDevice16BitStorageFeatures", "storageBuffer16BitAccess", structure->storageBuffer16BitAccess);

                skip |= ValidateBool32("VkPhysicalDevice16BitStorageFeatures", "uniformAndStorageBuffer16BitAccess", structure->uniformAndStorageBuffer16BitAccess);

                skip |= ValidateBool32("VkPhysicalDevice16BitStorageFeatures", "storagePushConstant16", structure->storagePushConstant16);

                skip |= ValidateBool32("VkPhysicalDevice16BitStorageFeatures", "storageInputOutput16", structure->storageInputOutput16);
            }
        } break;

        // Validation code for VkMemoryDedicatedRequirements structure members
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS: { // Covers VUID-VkMemoryDedicatedRequirements-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEDICATED_ALLOCATION_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_dedicated_allocation))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS), but its parent extension "
                               "VK_KHR_dedicated_allocation has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkMemoryDedicatedAllocateInfo structure members
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO: { // Covers VUID-VkMemoryDedicatedAllocateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEDICATED_ALLOCATION_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_dedicated_allocation))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO), but its parent extension "
                               "VK_KHR_dedicated_allocation has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkMemoryAllocateFlagsInfo structure members
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO: { // Covers VUID-VkMemoryAllocateFlagsInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEVICE_GROUP_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_device_group))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO), but its parent extension "
                               "VK_KHR_device_group has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkMemoryAllocateFlagsInfo *structure = (VkMemoryAllocateFlagsInfo *) header;
                skip |= ValidateFlags("VkMemoryAllocateFlagsInfo", "flags", "VkMemoryAllocateFlagBits", AllVkMemoryAllocateFlagBits, structure->flags, kOptionalFlags, "VUID-VkMemoryAllocateFlagsInfo-flags-parameter");
            }
        } break;

        // Validation code for VkDeviceGroupRenderPassBeginInfo structure members
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO: { // Covers VUID-VkDeviceGroupRenderPassBeginInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEVICE_GROUP_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_device_group))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO), but its parent extension "
                               "VK_KHR_device_group has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkDeviceGroupRenderPassBeginInfo *structure = (VkDeviceGroupRenderPassBeginInfo *) header;
                skip |= ValidateArray("VkDeviceGroupRenderPassBeginInfo", "deviceRenderAreaCount", "pDeviceRenderAreas", structure->deviceRenderAreaCount, &structure->pDeviceRenderAreas, false, true, kVUIDUndefined, "VUID-VkDeviceGroupRenderPassBeginInfo-pDeviceRenderAreas-parameter");

                if (structure->pDeviceRenderAreas != nullptr)
                {
                    for (uint32_t deviceRenderAreaIndex = 0; deviceRenderAreaIndex < structure->deviceRenderAreaCount; ++deviceRenderAreaIndex)
                    {
                    }
                }
            }
        } break;

        // Validation code for VkDeviceGroupCommandBufferBeginInfo structure members
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO: { // Covers VUID-VkDeviceGroupCommandBufferBeginInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEVICE_GROUP_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_device_group))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO), but its parent extension "
                               "VK_KHR_device_group has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkDeviceGroupSubmitInfo structure members
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO: { // Covers VUID-VkDeviceGroupSubmitInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEVICE_GROUP_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_device_group))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO), but its parent extension "
                               "VK_KHR_device_group has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkDeviceGroupSubmitInfo *structure = (VkDeviceGroupSubmitInfo *) header;
                skip |= ValidateArray("VkDeviceGroupSubmitInfo", "waitSemaphoreCount", "pWaitSemaphoreDeviceIndices", structure->waitSemaphoreCount, &structure->pWaitSemaphoreDeviceIndices, false, true, kVUIDUndefined, "VUID-VkDeviceGroupSubmitInfo-pWaitSemaphoreDeviceIndices-parameter");

                skip |= ValidateArray("VkDeviceGroupSubmitInfo", "commandBufferCount", "pCommandBufferDeviceMasks", structure->commandBufferCount, &structure->pCommandBufferDeviceMasks, false, true, kVUIDUndefined, "VUID-VkDeviceGroupSubmitInfo-pCommandBufferDeviceMasks-parameter");

                skip |= ValidateArray("VkDeviceGroupSubmitInfo", "signalSemaphoreCount", "pSignalSemaphoreDeviceIndices", structure->signalSemaphoreCount, &structure->pSignalSemaphoreDeviceIndices, false, true, kVUIDUndefined, "VUID-VkDeviceGroupSubmitInfo-pSignalSemaphoreDeviceIndices-parameter");
            }
        } break;

        // Validation code for VkDeviceGroupBindSparseInfo structure members
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO: { // Covers VUID-VkDeviceGroupBindSparseInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEVICE_GROUP_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_device_group))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO), but its parent extension "
                               "VK_KHR_device_group has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkBindBufferMemoryDeviceGroupInfo structure members
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO: { // Covers VUID-VkBindBufferMemoryDeviceGroupInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEVICE_GROUP_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_device_group))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO), but its parent extension "
                               "VK_KHR_device_group has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkBindBufferMemoryDeviceGroupInfo *structure = (VkBindBufferMemoryDeviceGroupInfo *) header;
                skip |= ValidateArray("VkBindBufferMemoryDeviceGroupInfo", "deviceIndexCount", "pDeviceIndices", structure->deviceIndexCount, &structure->pDeviceIndices, false, true, kVUIDUndefined, "VUID-VkBindBufferMemoryDeviceGroupInfo-pDeviceIndices-parameter");
            }
        } break;

        // Validation code for VkBindImageMemoryDeviceGroupInfo structure members
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO: { // Covers VUID-VkBindImageMemoryDeviceGroupInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEVICE_GROUP_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_device_group))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO), but its parent extension "
                               "VK_KHR_device_group has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkBindImageMemoryDeviceGroupInfo *structure = (VkBindImageMemoryDeviceGroupInfo *) header;
                skip |= ValidateArray("VkBindImageMemoryDeviceGroupInfo", "deviceIndexCount", "pDeviceIndices", structure->deviceIndexCount, &structure->pDeviceIndices, false, true, kVUIDUndefined, "VUID-VkBindImageMemoryDeviceGroupInfo-pDeviceIndices-parameter");

                skip |= ValidateArray("VkBindImageMemoryDeviceGroupInfo", "splitInstanceBindRegionCount", "pSplitInstanceBindRegions", structure->splitInstanceBindRegionCount, &structure->pSplitInstanceBindRegions, false, true, kVUIDUndefined, "VUID-VkBindImageMemoryDeviceGroupInfo-pSplitInstanceBindRegions-parameter");

                if (structure->pSplitInstanceBindRegions != nullptr)
                {
                    for (uint32_t splitInstanceBindRegionIndex = 0; splitInstanceBindRegionIndex < structure->splitInstanceBindRegionCount; ++splitInstanceBindRegionIndex)
                    {
                    }
                }
            }
        } break;

        // Validation code for VkDeviceGroupDeviceCreateInfo structure members
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO: { // Covers VUID-VkDeviceGroupDeviceCreateInfo-sType-sType
            if (is_const_param) {
                if (!instance_extensions.vk_khr_device_group_creation) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO), but its parent extension "
                               "VK_KHR_device_group_creation has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkDeviceGroupDeviceCreateInfo *structure = (VkDeviceGroupDeviceCreateInfo *) header;
                skip |= ValidateArray("VkDeviceGroupDeviceCreateInfo", "physicalDeviceCount", "pPhysicalDevices", structure->physicalDeviceCount, &structure->pPhysicalDevices, false, true, kVUIDUndefined, "VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceFeatures2 structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2: { // Covers VUID-VkPhysicalDeviceFeatures2-sType-sType
            if (is_const_param) {
                if (!instance_extensions.vk_khr_get_physical_device_properties2) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2), but its parent extension "
                               "VK_KHR_get_physical_device_properties2 has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceFeatures2 *structure = (VkPhysicalDeviceFeatures2 *) header;
                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.robustBufferAccess", structure->features.robustBufferAccess);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.fullDrawIndexUint32", structure->features.fullDrawIndexUint32);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.imageCubeArray", structure->features.imageCubeArray);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.independentBlend", structure->features.independentBlend);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.geometryShader", structure->features.geometryShader);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.tessellationShader", structure->features.tessellationShader);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.sampleRateShading", structure->features.sampleRateShading);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.dualSrcBlend", structure->features.dualSrcBlend);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.logicOp", structure->features.logicOp);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.multiDrawIndirect", structure->features.multiDrawIndirect);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.drawIndirectFirstInstance", structure->features.drawIndirectFirstInstance);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.depthClamp", structure->features.depthClamp);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.depthBiasClamp", structure->features.depthBiasClamp);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.fillModeNonSolid", structure->features.fillModeNonSolid);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.depthBounds", structure->features.depthBounds);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.wideLines", structure->features.wideLines);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.largePoints", structure->features.largePoints);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.alphaToOne", structure->features.alphaToOne);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.multiViewport", structure->features.multiViewport);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.samplerAnisotropy", structure->features.samplerAnisotropy);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.textureCompressionETC2", structure->features.textureCompressionETC2);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.textureCompressionASTC_LDR", structure->features.textureCompressionASTC_LDR);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.textureCompressionBC", structure->features.textureCompressionBC);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.occlusionQueryPrecise", structure->features.occlusionQueryPrecise);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.pipelineStatisticsQuery", structure->features.pipelineStatisticsQuery);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.vertexPipelineStoresAndAtomics", structure->features.vertexPipelineStoresAndAtomics);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.fragmentStoresAndAtomics", structure->features.fragmentStoresAndAtomics);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.shaderTessellationAndGeometryPointSize", structure->features.shaderTessellationAndGeometryPointSize);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.shaderImageGatherExtended", structure->features.shaderImageGatherExtended);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.shaderStorageImageExtendedFormats", structure->features.shaderStorageImageExtendedFormats);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.shaderStorageImageMultisample", structure->features.shaderStorageImageMultisample);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.shaderStorageImageReadWithoutFormat", structure->features.shaderStorageImageReadWithoutFormat);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.shaderStorageImageWriteWithoutFormat", structure->features.shaderStorageImageWriteWithoutFormat);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.shaderUniformBufferArrayDynamicIndexing", structure->features.shaderUniformBufferArrayDynamicIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.shaderSampledImageArrayDynamicIndexing", structure->features.shaderSampledImageArrayDynamicIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.shaderStorageBufferArrayDynamicIndexing", structure->features.shaderStorageBufferArrayDynamicIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.shaderStorageImageArrayDynamicIndexing", structure->features.shaderStorageImageArrayDynamicIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.shaderClipDistance", structure->features.shaderClipDistance);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.shaderCullDistance", structure->features.shaderCullDistance);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.shaderFloat64", structure->features.shaderFloat64);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.shaderInt64", structure->features.shaderInt64);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.shaderInt16", structure->features.shaderInt16);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.shaderResourceResidency", structure->features.shaderResourceResidency);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.shaderResourceMinLod", structure->features.shaderResourceMinLod);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.sparseBinding", structure->features.sparseBinding);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.sparseResidencyBuffer", structure->features.sparseResidencyBuffer);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.sparseResidencyImage2D", structure->features.sparseResidencyImage2D);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.sparseResidencyImage3D", structure->features.sparseResidencyImage3D);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.sparseResidency2Samples", structure->features.sparseResidency2Samples);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.sparseResidency4Samples", structure->features.sparseResidency4Samples);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.sparseResidency8Samples", structure->features.sparseResidency8Samples);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.sparseResidency16Samples", structure->features.sparseResidency16Samples);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.sparseResidencyAliased", structure->features.sparseResidencyAliased);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.variableMultisampleRate", structure->features.variableMultisampleRate);

                skip |= ValidateBool32("VkPhysicalDeviceFeatures2", "features.inheritedQueries", structure->features.inheritedQueries);
            }
        } break;

        // Validation code for VkPhysicalDevicePointClippingProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES: { // Covers VUID-VkPhysicalDevicePointClippingProperties-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MAINTENANCE_2_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_maintenance2))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES), but its parent extension "
                               "VK_KHR_maintenance2 has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkRenderPassInputAttachmentAspectCreateInfo structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO: { // Covers VUID-VkRenderPassInputAttachmentAspectCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MAINTENANCE_2_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_maintenance2))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO), but its parent extension "
                               "VK_KHR_maintenance2 has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkRenderPassInputAttachmentAspectCreateInfo *structure = (VkRenderPassInputAttachmentAspectCreateInfo *) header;
                skip |= ValidateArray("VkRenderPassInputAttachmentAspectCreateInfo", "aspectReferenceCount", "pAspectReferences", structure->aspectReferenceCount, &structure->pAspectReferences, true, true, "VUID-VkRenderPassInputAttachmentAspectCreateInfo-aspectReferenceCount-arraylength", "VUID-VkRenderPassInputAttachmentAspectCreateInfo-pAspectReferences-parameter");

                if (structure->pAspectReferences != nullptr)
                {
                    for (uint32_t aspectReferenceIndex = 0; aspectReferenceIndex < structure->aspectReferenceCount; ++aspectReferenceIndex)
                    {
                        skip |= ValidateFlags("VkRenderPassInputAttachmentAspectCreateInfo", ParameterName("pAspectReferences[%i].aspectMask", ParameterName::IndexVector{ aspectReferenceIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, structure->pAspectReferences[aspectReferenceIndex].aspectMask, kRequiredFlags, "VUID-VkInputAttachmentAspectReference-aspectMask-parameter", "VUID-VkInputAttachmentAspectReference-aspectMask-requiredbitmask");
                    }
                }
            }
        } break;

        // Validation code for VkImageViewUsageCreateInfo structure members
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO: { // Covers VUID-VkImageViewUsageCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MAINTENANCE_2_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_maintenance2))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO), but its parent extension "
                               "VK_KHR_maintenance2 has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkImageViewUsageCreateInfo *structure = (VkImageViewUsageCreateInfo *) header;
                skip |= ValidateFlags("VkImageViewUsageCreateInfo", "usage", "VkImageUsageFlagBits", AllVkImageUsageFlagBits, structure->usage, kRequiredFlags, "VUID-VkImageViewUsageCreateInfo-usage-parameter", "VUID-VkImageViewUsageCreateInfo-usage-requiredbitmask");
            }
        } break;

        // Validation code for VkPipelineTessellationDomainOriginStateCreateInfo structure members
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO: { // Covers VUID-VkPipelineTessellationDomainOriginStateCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MAINTENANCE_2_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_maintenance2))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO), but its parent extension "
                               "VK_KHR_maintenance2 has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPipelineTessellationDomainOriginStateCreateInfo *structure = (VkPipelineTessellationDomainOriginStateCreateInfo *) header;
                skip |= ValidateRangedEnum("VkPipelineTessellationDomainOriginStateCreateInfo", "domainOrigin", "VkTessellationDomainOrigin", AllVkTessellationDomainOriginEnums, structure->domainOrigin, "VUID-VkPipelineTessellationDomainOriginStateCreateInfo-domainOrigin-parameter");
            }
        } break;

        // Validation code for VkRenderPassMultiviewCreateInfo structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO: { // Covers VUID-VkRenderPassMultiviewCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MULTIVIEW_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_multiview))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO), but its parent extension "
                               "VK_KHR_multiview has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkRenderPassMultiviewCreateInfo *structure = (VkRenderPassMultiviewCreateInfo *) header;
                skip |= ValidateArray("VkRenderPassMultiviewCreateInfo", "subpassCount", "pViewMasks", structure->subpassCount, &structure->pViewMasks, false, true, kVUIDUndefined, "VUID-VkRenderPassMultiviewCreateInfo-pViewMasks-parameter");

                skip |= ValidateArray("VkRenderPassMultiviewCreateInfo", "dependencyCount", "pViewOffsets", structure->dependencyCount, &structure->pViewOffsets, false, true, kVUIDUndefined, "VUID-VkRenderPassMultiviewCreateInfo-pViewOffsets-parameter");

                skip |= ValidateArray("VkRenderPassMultiviewCreateInfo", "correlationMaskCount", "pCorrelationMasks", structure->correlationMaskCount, &structure->pCorrelationMasks, false, true, kVUIDUndefined, "VUID-VkRenderPassMultiviewCreateInfo-pCorrelationMasks-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceMultiviewFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES: { // Covers VUID-VkPhysicalDeviceMultiviewFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MULTIVIEW_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_multiview))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES), but its parent extension "
                               "VK_KHR_multiview has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceMultiviewFeatures *structure = (VkPhysicalDeviceMultiviewFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceMultiviewFeatures", "multiview", structure->multiview);

                skip |= ValidateBool32("VkPhysicalDeviceMultiviewFeatures", "multiviewGeometryShader", structure->multiviewGeometryShader);

                skip |= ValidateBool32("VkPhysicalDeviceMultiviewFeatures", "multiviewTessellationShader", structure->multiviewTessellationShader);
            }
        } break;

        // Validation code for VkPhysicalDeviceMultiviewProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES: { // Covers VUID-VkPhysicalDeviceMultiviewProperties-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MULTIVIEW_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_multiview))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES), but its parent extension "
                               "VK_KHR_multiview has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkPhysicalDeviceVariablePointersFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES: { // Covers VUID-VkPhysicalDeviceVariablePointersFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_VARIABLE_POINTERS_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_variable_pointers))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES), but its parent extension "
                               "VK_KHR_variable_pointers has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceVariablePointersFeatures *structure = (VkPhysicalDeviceVariablePointersFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceVariablePointersFeatures", "variablePointersStorageBuffer", structure->variablePointersStorageBuffer);

                skip |= ValidateBool32("VkPhysicalDeviceVariablePointersFeatures", "variablePointers", structure->variablePointers);
            }
        } break;

        // Validation code for VkPhysicalDeviceProtectedMemoryFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES: { // Covers VUID-VkPhysicalDeviceProtectedMemoryFeatures-sType-sType
            if (api_version < VK_API_VERSION_1_1) {
                skip |= LogError(
                           instance, pnext_vuid,
                           "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES) which was added in VK_API_VERSION_1_1 but the "
                           "current effective API version is %s.",
                           api_name, parameter_name.get_name().c_str(), StringAPIVersion(api_version).c_str());
            }
            if (is_const_param) {
                VkPhysicalDeviceProtectedMemoryFeatures *structure = (VkPhysicalDeviceProtectedMemoryFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceProtectedMemoryFeatures", "protectedMemory", structure->protectedMemory);
            }
        } break;

        // Validation code for VkPhysicalDeviceProtectedMemoryProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES: { // Covers VUID-VkPhysicalDeviceProtectedMemoryProperties-sType-sType
            if (api_version < VK_API_VERSION_1_1) {
                skip |= LogError(
                           instance, pnext_vuid,
                           "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES) which was added in VK_API_VERSION_1_1 but the "
                           "current effective API version is %s.",
                           api_name, parameter_name.get_name().c_str(), StringAPIVersion(api_version).c_str());
            }
        } break;

        // Validation code for VkProtectedSubmitInfo structure members
        case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO: { // Covers VUID-VkProtectedSubmitInfo-sType-sType
            if (api_version < VK_API_VERSION_1_1) {
                skip |= LogError(
                           instance, pnext_vuid,
                           "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO) which was added in VK_API_VERSION_1_1 but the "
                           "current effective API version is %s.",
                           api_name, parameter_name.get_name().c_str(), StringAPIVersion(api_version).c_str());
            }
            if (is_const_param) {
                VkProtectedSubmitInfo *structure = (VkProtectedSubmitInfo *) header;
                skip |= ValidateBool32("VkProtectedSubmitInfo", "protectedSubmit", structure->protectedSubmit);
            }
        } break;

        // Validation code for VkSamplerYcbcrConversionInfo structure members
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO: { // Covers VUID-VkSamplerYcbcrConversionInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SAMPLER_YCBCR_CONVERSION_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_sampler_ycbcr_conversion))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO), but its parent extension "
                               "VK_KHR_sampler_ycbcr_conversion has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkSamplerYcbcrConversionInfo *structure = (VkSamplerYcbcrConversionInfo *) header;
                skip |= ValidateRequiredHandle("VkSamplerYcbcrConversionInfo", "conversion", structure->conversion);
            }
        } break;

        // Validation code for VkBindImagePlaneMemoryInfo structure members
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO: { // Covers VUID-VkBindImagePlaneMemoryInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SAMPLER_YCBCR_CONVERSION_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_sampler_ycbcr_conversion))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO), but its parent extension "
                               "VK_KHR_sampler_ycbcr_conversion has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkBindImagePlaneMemoryInfo *structure = (VkBindImagePlaneMemoryInfo *) header;
                skip |= ValidateFlags("VkBindImagePlaneMemoryInfo", "planeAspect", "VkImageAspectFlagBits", AllVkImageAspectFlagBits, structure->planeAspect, kRequiredSingleBit, "VUID-VkBindImagePlaneMemoryInfo-planeAspect-parameter", "VUID-VkBindImagePlaneMemoryInfo-planeAspect-parameter");
            }
        } break;

        // Validation code for VkImagePlaneMemoryRequirementsInfo structure members
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO: { // Covers VUID-VkImagePlaneMemoryRequirementsInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SAMPLER_YCBCR_CONVERSION_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_sampler_ycbcr_conversion))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO), but its parent extension "
                               "VK_KHR_sampler_ycbcr_conversion has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkImagePlaneMemoryRequirementsInfo *structure = (VkImagePlaneMemoryRequirementsInfo *) header;
                skip |= ValidateFlags("VkImagePlaneMemoryRequirementsInfo", "planeAspect", "VkImageAspectFlagBits", AllVkImageAspectFlagBits, structure->planeAspect, kRequiredSingleBit, "VUID-VkImagePlaneMemoryRequirementsInfo-planeAspect-parameter", "VUID-VkImagePlaneMemoryRequirementsInfo-planeAspect-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceSamplerYcbcrConversionFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES: { // Covers VUID-VkPhysicalDeviceSamplerYcbcrConversionFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SAMPLER_YCBCR_CONVERSION_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_sampler_ycbcr_conversion))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES), but its parent extension "
                               "VK_KHR_sampler_ycbcr_conversion has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceSamplerYcbcrConversionFeatures *structure = (VkPhysicalDeviceSamplerYcbcrConversionFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceSamplerYcbcrConversionFeatures", "samplerYcbcrConversion", structure->samplerYcbcrConversion);
            }
        } break;

        // Validation code for VkSamplerYcbcrConversionImageFormatProperties structure members
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES: { // Covers VUID-VkSamplerYcbcrConversionImageFormatProperties-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SAMPLER_YCBCR_CONVERSION_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_sampler_ycbcr_conversion))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES), but its parent extension "
                               "VK_KHR_sampler_ycbcr_conversion has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkPhysicalDeviceExternalImageFormatInfo structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO: { // Covers VUID-VkPhysicalDeviceExternalImageFormatInfo-sType-sType
            if (is_const_param) {
                if (!instance_extensions.vk_khr_external_memory_capabilities) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO), but its parent extension "
                               "VK_KHR_external_memory_capabilities has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceExternalImageFormatInfo *structure = (VkPhysicalDeviceExternalImageFormatInfo *) header;
                skip |= ValidateFlags("VkPhysicalDeviceExternalImageFormatInfo", "handleType", "VkExternalMemoryHandleTypeFlagBits", AllVkExternalMemoryHandleTypeFlagBits, structure->handleType, kOptionalSingleBit, "VUID-VkPhysicalDeviceExternalImageFormatInfo-handleType-parameter");
            }
        } break;

        // Validation code for VkExternalImageFormatProperties structure members
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES: { // Covers VUID-VkExternalImageFormatProperties-sType-sType
            if (is_const_param) {
                if (!instance_extensions.vk_khr_external_memory_capabilities) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES), but its parent extension "
                               "VK_KHR_external_memory_capabilities has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkPhysicalDeviceIDProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES: { // Covers VUID-VkPhysicalDeviceIDProperties-sType-sType
            if (is_const_param) {
                if (!instance_extensions.vk_khr_external_fence_capabilities) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES), but its parent extension "
                               "VK_KHR_external_fence_capabilities has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkExternalMemoryImageCreateInfo structure members
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO: { // Covers VUID-VkExternalMemoryImageCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_EXTERNAL_MEMORY_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_external_memory))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO), but its parent extension "
                               "VK_KHR_external_memory has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkExternalMemoryImageCreateInfo *structure = (VkExternalMemoryImageCreateInfo *) header;
                skip |= ValidateFlags("VkExternalMemoryImageCreateInfo", "handleTypes", "VkExternalMemoryHandleTypeFlagBits", AllVkExternalMemoryHandleTypeFlagBits, structure->handleTypes, kOptionalFlags, "VUID-VkExternalMemoryImageCreateInfo-handleTypes-parameter");
            }
        } break;

        // Validation code for VkExternalMemoryBufferCreateInfo structure members
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO: { // Covers VUID-VkExternalMemoryBufferCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_EXTERNAL_MEMORY_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_external_memory))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO), but its parent extension "
                               "VK_KHR_external_memory has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkExternalMemoryBufferCreateInfo *structure = (VkExternalMemoryBufferCreateInfo *) header;
                skip |= ValidateFlags("VkExternalMemoryBufferCreateInfo", "handleTypes", "VkExternalMemoryHandleTypeFlagBits", AllVkExternalMemoryHandleTypeFlagBits, structure->handleTypes, kOptionalFlags, "VUID-VkExternalMemoryBufferCreateInfo-handleTypes-parameter");
            }
        } break;

        // Validation code for VkExportMemoryAllocateInfo structure members
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO: { // Covers VUID-VkExportMemoryAllocateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_EXTERNAL_MEMORY_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_external_memory))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO), but its parent extension "
                               "VK_KHR_external_memory has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkExportMemoryAllocateInfo *structure = (VkExportMemoryAllocateInfo *) header;
                skip |= ValidateFlags("VkExportMemoryAllocateInfo", "handleTypes", "VkExternalMemoryHandleTypeFlagBits", AllVkExternalMemoryHandleTypeFlagBits, structure->handleTypes, kOptionalFlags, "VUID-VkExportMemoryAllocateInfo-handleTypes-parameter");
            }
        } break;

        // Validation code for VkExportFenceCreateInfo structure members
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO: { // Covers VUID-VkExportFenceCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_EXTERNAL_FENCE_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_external_fence))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO), but its parent extension "
                               "VK_KHR_external_fence has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkExportFenceCreateInfo *structure = (VkExportFenceCreateInfo *) header;
                skip |= ValidateFlags("VkExportFenceCreateInfo", "handleTypes", "VkExternalFenceHandleTypeFlagBits", AllVkExternalFenceHandleTypeFlagBits, structure->handleTypes, kOptionalFlags, "VUID-VkExportFenceCreateInfo-handleTypes-parameter");
            }
        } break;

        // Validation code for VkExportSemaphoreCreateInfo structure members
        case VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO: { // Covers VUID-VkExportSemaphoreCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_EXTERNAL_SEMAPHORE_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_external_semaphore))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO), but its parent extension "
                               "VK_KHR_external_semaphore has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkExportSemaphoreCreateInfo *structure = (VkExportSemaphoreCreateInfo *) header;
                skip |= ValidateFlags("VkExportSemaphoreCreateInfo", "handleTypes", "VkExternalSemaphoreHandleTypeFlagBits", AllVkExternalSemaphoreHandleTypeFlagBits, structure->handleTypes, kOptionalFlags, "VUID-VkExportSemaphoreCreateInfo-handleTypes-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceMaintenance3Properties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES: { // Covers VUID-VkPhysicalDeviceMaintenance3Properties-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MAINTENANCE_3_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_maintenance3))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES), but its parent extension "
                               "VK_KHR_maintenance3 has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkPhysicalDeviceShaderDrawParametersFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES: { // Covers VUID-VkPhysicalDeviceShaderDrawParametersFeatures-sType-sType
            if (api_version < VK_API_VERSION_1_1) {
                skip |= LogError(
                           instance, pnext_vuid,
                           "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES) which was added in VK_API_VERSION_1_1 but the "
                           "current effective API version is %s.",
                           api_name, parameter_name.get_name().c_str(), StringAPIVersion(api_version).c_str());
            }
            if (is_const_param) {
                VkPhysicalDeviceShaderDrawParametersFeatures *structure = (VkPhysicalDeviceShaderDrawParametersFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShaderDrawParametersFeatures", "shaderDrawParameters", structure->shaderDrawParameters);
            }
        } break;

        // Validation code for VkPhysicalDeviceVulkan11Features structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES: { // Covers VUID-VkPhysicalDeviceVulkan11Features-sType-sType
            if (api_version < VK_API_VERSION_1_2) {
                skip |= LogError(
                           instance, pnext_vuid,
                           "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES) which was added in VK_API_VERSION_1_2 but the "
                           "current effective API version is %s.",
                           api_name, parameter_name.get_name().c_str(), StringAPIVersion(api_version).c_str());
            }
            if (is_const_param) {
                VkPhysicalDeviceVulkan11Features *structure = (VkPhysicalDeviceVulkan11Features *) header;
                skip |= ValidateBool32("VkPhysicalDeviceVulkan11Features", "storageBuffer16BitAccess", structure->storageBuffer16BitAccess);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan11Features", "uniformAndStorageBuffer16BitAccess", structure->uniformAndStorageBuffer16BitAccess);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan11Features", "storagePushConstant16", structure->storagePushConstant16);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan11Features", "storageInputOutput16", structure->storageInputOutput16);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan11Features", "multiview", structure->multiview);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan11Features", "multiviewGeometryShader", structure->multiviewGeometryShader);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan11Features", "multiviewTessellationShader", structure->multiviewTessellationShader);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan11Features", "variablePointersStorageBuffer", structure->variablePointersStorageBuffer);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan11Features", "variablePointers", structure->variablePointers);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan11Features", "protectedMemory", structure->protectedMemory);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan11Features", "samplerYcbcrConversion", structure->samplerYcbcrConversion);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan11Features", "shaderDrawParameters", structure->shaderDrawParameters);
            }
        } break;

        // Validation code for VkPhysicalDeviceVulkan11Properties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES: { // Covers VUID-VkPhysicalDeviceVulkan11Properties-sType-sType
            if (api_version < VK_API_VERSION_1_2) {
                skip |= LogError(
                           instance, pnext_vuid,
                           "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES) which was added in VK_API_VERSION_1_2 but the "
                           "current effective API version is %s.",
                           api_name, parameter_name.get_name().c_str(), StringAPIVersion(api_version).c_str());
            }
        } break;

        // Validation code for VkPhysicalDeviceVulkan12Features structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES: { // Covers VUID-VkPhysicalDeviceVulkan12Features-sType-sType
            if (api_version < VK_API_VERSION_1_2) {
                skip |= LogError(
                           instance, pnext_vuid,
                           "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES) which was added in VK_API_VERSION_1_2 but the "
                           "current effective API version is %s.",
                           api_name, parameter_name.get_name().c_str(), StringAPIVersion(api_version).c_str());
            }
            if (is_const_param) {
                VkPhysicalDeviceVulkan12Features *structure = (VkPhysicalDeviceVulkan12Features *) header;
                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "samplerMirrorClampToEdge", structure->samplerMirrorClampToEdge);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "drawIndirectCount", structure->drawIndirectCount);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "storageBuffer8BitAccess", structure->storageBuffer8BitAccess);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "uniformAndStorageBuffer8BitAccess", structure->uniformAndStorageBuffer8BitAccess);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "storagePushConstant8", structure->storagePushConstant8);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "shaderBufferInt64Atomics", structure->shaderBufferInt64Atomics);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "shaderSharedInt64Atomics", structure->shaderSharedInt64Atomics);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "shaderFloat16", structure->shaderFloat16);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "shaderInt8", structure->shaderInt8);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "descriptorIndexing", structure->descriptorIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "shaderInputAttachmentArrayDynamicIndexing", structure->shaderInputAttachmentArrayDynamicIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "shaderUniformTexelBufferArrayDynamicIndexing", structure->shaderUniformTexelBufferArrayDynamicIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "shaderStorageTexelBufferArrayDynamicIndexing", structure->shaderStorageTexelBufferArrayDynamicIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "shaderUniformBufferArrayNonUniformIndexing", structure->shaderUniformBufferArrayNonUniformIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "shaderSampledImageArrayNonUniformIndexing", structure->shaderSampledImageArrayNonUniformIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "shaderStorageBufferArrayNonUniformIndexing", structure->shaderStorageBufferArrayNonUniformIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "shaderStorageImageArrayNonUniformIndexing", structure->shaderStorageImageArrayNonUniformIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "shaderInputAttachmentArrayNonUniformIndexing", structure->shaderInputAttachmentArrayNonUniformIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "shaderUniformTexelBufferArrayNonUniformIndexing", structure->shaderUniformTexelBufferArrayNonUniformIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "shaderStorageTexelBufferArrayNonUniformIndexing", structure->shaderStorageTexelBufferArrayNonUniformIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "descriptorBindingUniformBufferUpdateAfterBind", structure->descriptorBindingUniformBufferUpdateAfterBind);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "descriptorBindingSampledImageUpdateAfterBind", structure->descriptorBindingSampledImageUpdateAfterBind);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "descriptorBindingStorageImageUpdateAfterBind", structure->descriptorBindingStorageImageUpdateAfterBind);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "descriptorBindingStorageBufferUpdateAfterBind", structure->descriptorBindingStorageBufferUpdateAfterBind);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "descriptorBindingUniformTexelBufferUpdateAfterBind", structure->descriptorBindingUniformTexelBufferUpdateAfterBind);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "descriptorBindingStorageTexelBufferUpdateAfterBind", structure->descriptorBindingStorageTexelBufferUpdateAfterBind);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "descriptorBindingUpdateUnusedWhilePending", structure->descriptorBindingUpdateUnusedWhilePending);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "descriptorBindingPartiallyBound", structure->descriptorBindingPartiallyBound);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "descriptorBindingVariableDescriptorCount", structure->descriptorBindingVariableDescriptorCount);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "runtimeDescriptorArray", structure->runtimeDescriptorArray);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "samplerFilterMinmax", structure->samplerFilterMinmax);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "scalarBlockLayout", structure->scalarBlockLayout);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "imagelessFramebuffer", structure->imagelessFramebuffer);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "uniformBufferStandardLayout", structure->uniformBufferStandardLayout);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "shaderSubgroupExtendedTypes", structure->shaderSubgroupExtendedTypes);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "separateDepthStencilLayouts", structure->separateDepthStencilLayouts);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "hostQueryReset", structure->hostQueryReset);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "timelineSemaphore", structure->timelineSemaphore);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "bufferDeviceAddress", structure->bufferDeviceAddress);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "bufferDeviceAddressCaptureReplay", structure->bufferDeviceAddressCaptureReplay);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "bufferDeviceAddressMultiDevice", structure->bufferDeviceAddressMultiDevice);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "vulkanMemoryModel", structure->vulkanMemoryModel);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "vulkanMemoryModelDeviceScope", structure->vulkanMemoryModelDeviceScope);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "vulkanMemoryModelAvailabilityVisibilityChains", structure->vulkanMemoryModelAvailabilityVisibilityChains);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "shaderOutputViewportIndex", structure->shaderOutputViewportIndex);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "shaderOutputLayer", structure->shaderOutputLayer);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan12Features", "subgroupBroadcastDynamicId", structure->subgroupBroadcastDynamicId);
            }
        } break;

        // Validation code for VkPhysicalDeviceVulkan12Properties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES: { // Covers VUID-VkPhysicalDeviceVulkan12Properties-sType-sType
            if (api_version < VK_API_VERSION_1_2) {
                skip |= LogError(
                           instance, pnext_vuid,
                           "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES) which was added in VK_API_VERSION_1_2 but the "
                           "current effective API version is %s.",
                           api_name, parameter_name.get_name().c_str(), StringAPIVersion(api_version).c_str());
            }
        } break;

        // Validation code for VkImageFormatListCreateInfo structure members
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO: { // Covers VUID-VkImageFormatListCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_IMAGE_FORMAT_LIST_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_image_format_list))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO), but its parent extension "
                               "VK_KHR_image_format_list has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkImageFormatListCreateInfo *structure = (VkImageFormatListCreateInfo *) header;
                skip |= ValidateRangedEnumArray("VkImageFormatListCreateInfo", "viewFormatCount", "pViewFormats", "VkFormat", AllVkFormatEnums, structure->viewFormatCount, structure->pViewFormats, false, true);
            }
        } break;

        // Validation code for VkPhysicalDevice8BitStorageFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES: { // Covers VUID-VkPhysicalDevice8BitStorageFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_8BIT_STORAGE_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_8bit_storage))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES), but its parent extension "
                               "VK_KHR_8bit_storage has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDevice8BitStorageFeatures *structure = (VkPhysicalDevice8BitStorageFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDevice8BitStorageFeatures", "storageBuffer8BitAccess", structure->storageBuffer8BitAccess);

                skip |= ValidateBool32("VkPhysicalDevice8BitStorageFeatures", "uniformAndStorageBuffer8BitAccess", structure->uniformAndStorageBuffer8BitAccess);

                skip |= ValidateBool32("VkPhysicalDevice8BitStorageFeatures", "storagePushConstant8", structure->storagePushConstant8);
            }
        } break;

        // Validation code for VkPhysicalDeviceDriverProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES: { // Covers VUID-VkPhysicalDeviceDriverProperties-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DRIVER_PROPERTIES_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_driver_properties))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES), but its parent extension "
                               "VK_KHR_driver_properties has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkPhysicalDeviceShaderAtomicInt64Features structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES: { // Covers VUID-VkPhysicalDeviceShaderAtomicInt64Features-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SHADER_ATOMIC_INT64_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_shader_atomic_int64))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES), but its parent extension "
                               "VK_KHR_shader_atomic_int64 has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceShaderAtomicInt64Features *structure = (VkPhysicalDeviceShaderAtomicInt64Features *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicInt64Features", "shaderBufferInt64Atomics", structure->shaderBufferInt64Atomics);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicInt64Features", "shaderSharedInt64Atomics", structure->shaderSharedInt64Atomics);
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderFloat16Int8Features structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES: { // Covers VUID-VkPhysicalDeviceShaderFloat16Int8Features-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SHADER_FLOAT16_INT8_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_shader_float16_int8))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES), but its parent extension "
                               "VK_KHR_shader_float16_int8 has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceShaderFloat16Int8Features *structure = (VkPhysicalDeviceShaderFloat16Int8Features *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShaderFloat16Int8Features", "shaderFloat16", structure->shaderFloat16);

                skip |= ValidateBool32("VkPhysicalDeviceShaderFloat16Int8Features", "shaderInt8", structure->shaderInt8);
            }
        } break;

        // Validation code for VkPhysicalDeviceFloatControlsProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES: { // Covers VUID-VkPhysicalDeviceFloatControlsProperties-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SHADER_FLOAT_CONTROLS_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_shader_float_controls))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES), but its parent extension "
                               "VK_KHR_shader_float_controls has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkDescriptorSetLayoutBindingFlagsCreateInfo structure members
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO: { // Covers VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_DESCRIPTOR_INDEXING_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_descriptor_indexing))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO), but its parent extension "
                               "VK_EXT_descriptor_indexing has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkDescriptorSetLayoutBindingFlagsCreateInfo *structure = (VkDescriptorSetLayoutBindingFlagsCreateInfo *) header;
                skip |= ValidateFlagsArray("VkDescriptorSetLayoutBindingFlagsCreateInfo", "bindingCount", "pBindingFlags", "VkDescriptorBindingFlagBits", AllVkDescriptorBindingFlagBits, structure->bindingCount, structure->pBindingFlags, false, false);
            }
        } break;

        // Validation code for VkPhysicalDeviceDescriptorIndexingFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES: { // Covers VUID-VkPhysicalDeviceDescriptorIndexingFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_DESCRIPTOR_INDEXING_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_descriptor_indexing))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES), but its parent extension "
                               "VK_EXT_descriptor_indexing has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceDescriptorIndexingFeatures *structure = (VkPhysicalDeviceDescriptorIndexingFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "shaderInputAttachmentArrayDynamicIndexing", structure->shaderInputAttachmentArrayDynamicIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "shaderUniformTexelBufferArrayDynamicIndexing", structure->shaderUniformTexelBufferArrayDynamicIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "shaderStorageTexelBufferArrayDynamicIndexing", structure->shaderStorageTexelBufferArrayDynamicIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "shaderUniformBufferArrayNonUniformIndexing", structure->shaderUniformBufferArrayNonUniformIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "shaderSampledImageArrayNonUniformIndexing", structure->shaderSampledImageArrayNonUniformIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "shaderStorageBufferArrayNonUniformIndexing", structure->shaderStorageBufferArrayNonUniformIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "shaderStorageImageArrayNonUniformIndexing", structure->shaderStorageImageArrayNonUniformIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "shaderInputAttachmentArrayNonUniformIndexing", structure->shaderInputAttachmentArrayNonUniformIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "shaderUniformTexelBufferArrayNonUniformIndexing", structure->shaderUniformTexelBufferArrayNonUniformIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "shaderStorageTexelBufferArrayNonUniformIndexing", structure->shaderStorageTexelBufferArrayNonUniformIndexing);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "descriptorBindingUniformBufferUpdateAfterBind", structure->descriptorBindingUniformBufferUpdateAfterBind);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "descriptorBindingSampledImageUpdateAfterBind", structure->descriptorBindingSampledImageUpdateAfterBind);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "descriptorBindingStorageImageUpdateAfterBind", structure->descriptorBindingStorageImageUpdateAfterBind);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "descriptorBindingStorageBufferUpdateAfterBind", structure->descriptorBindingStorageBufferUpdateAfterBind);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "descriptorBindingUniformTexelBufferUpdateAfterBind", structure->descriptorBindingUniformTexelBufferUpdateAfterBind);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "descriptorBindingStorageTexelBufferUpdateAfterBind", structure->descriptorBindingStorageTexelBufferUpdateAfterBind);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "descriptorBindingUpdateUnusedWhilePending", structure->descriptorBindingUpdateUnusedWhilePending);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "descriptorBindingPartiallyBound", structure->descriptorBindingPartiallyBound);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "descriptorBindingVariableDescriptorCount", structure->descriptorBindingVariableDescriptorCount);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorIndexingFeatures", "runtimeDescriptorArray", structure->runtimeDescriptorArray);
            }
        } break;

        // Validation code for VkPhysicalDeviceDescriptorIndexingProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES: { // Covers VUID-VkPhysicalDeviceDescriptorIndexingProperties-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_DESCRIPTOR_INDEXING_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_descriptor_indexing))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES), but its parent extension "
                               "VK_EXT_descriptor_indexing has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkDescriptorSetVariableDescriptorCountAllocateInfo structure members
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO: { // Covers VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_DESCRIPTOR_INDEXING_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_descriptor_indexing))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO), but its parent extension "
                               "VK_EXT_descriptor_indexing has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkDescriptorSetVariableDescriptorCountAllocateInfo *structure = (VkDescriptorSetVariableDescriptorCountAllocateInfo *) header;
                skip |= ValidateArray("VkDescriptorSetVariableDescriptorCountAllocateInfo", "descriptorSetCount", "pDescriptorCounts", structure->descriptorSetCount, &structure->pDescriptorCounts, false, true, kVUIDUndefined, "VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-pDescriptorCounts-parameter");
            }
        } break;

        // Validation code for VkDescriptorSetVariableDescriptorCountLayoutSupport structure members
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT: { // Covers VUID-VkDescriptorSetVariableDescriptorCountLayoutSupport-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_DESCRIPTOR_INDEXING_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_descriptor_indexing))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT), but its parent extension "
                               "VK_EXT_descriptor_indexing has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkSubpassDescriptionDepthStencilResolve structure members
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE: { // Covers VUID-VkSubpassDescriptionDepthStencilResolve-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEPTH_STENCIL_RESOLVE_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_depth_stencil_resolve))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE), but its parent extension "
                               "VK_KHR_depth_stencil_resolve has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkSubpassDescriptionDepthStencilResolve *structure = (VkSubpassDescriptionDepthStencilResolve *) header;
                skip |= ValidateStructType("VkSubpassDescriptionDepthStencilResolve", "pDepthStencilResolveAttachment", "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2", structure->pDepthStencilResolveAttachment, VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2, false, "VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-parameter", "VUID-VkAttachmentReference2-sType-sType");

                if (structure->pDepthStencilResolveAttachment != nullptr)
                {
                    skip |= ValidateRangedEnum("VkSubpassDescriptionDepthStencilResolve", "pDepthStencilResolveAttachment->layout", "VkImageLayout", AllVkImageLayoutEnums, structure->pDepthStencilResolveAttachment->layout, "VUID-VkAttachmentReference2-layout-parameter");
                }
            }
        } break;

        // Validation code for VkPhysicalDeviceDepthStencilResolveProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES: { // Covers VUID-VkPhysicalDeviceDepthStencilResolveProperties-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DEPTH_STENCIL_RESOLVE_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_depth_stencil_resolve))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES), but its parent extension "
                               "VK_KHR_depth_stencil_resolve has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkPhysicalDeviceScalarBlockLayoutFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES: { // Covers VUID-VkPhysicalDeviceScalarBlockLayoutFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_SCALAR_BLOCK_LAYOUT_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_scalar_block_layout))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES), but its parent extension "
                               "VK_EXT_scalar_block_layout has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceScalarBlockLayoutFeatures *structure = (VkPhysicalDeviceScalarBlockLayoutFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceScalarBlockLayoutFeatures", "scalarBlockLayout", structure->scalarBlockLayout);
            }
        } break;

        // Validation code for VkImageStencilUsageCreateInfo structure members
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO: { // Covers VUID-VkImageStencilUsageCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_SEPARATE_STENCIL_USAGE_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_separate_stencil_usage))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO), but its parent extension "
                               "VK_EXT_separate_stencil_usage has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkImageStencilUsageCreateInfo *structure = (VkImageStencilUsageCreateInfo *) header;
                skip |= ValidateFlags("VkImageStencilUsageCreateInfo", "stencilUsage", "VkImageUsageFlagBits", AllVkImageUsageFlagBits, structure->stencilUsage, kRequiredFlags, "VUID-VkImageStencilUsageCreateInfo-stencilUsage-parameter", "VUID-VkImageStencilUsageCreateInfo-stencilUsage-requiredbitmask");
            }
        } break;

        // Validation code for VkSamplerReductionModeCreateInfo structure members
        case VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO: { // Covers VUID-VkSamplerReductionModeCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_SAMPLER_FILTER_MINMAX_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_sampler_filter_minmax))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO), but its parent extension "
                               "VK_EXT_sampler_filter_minmax has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkSamplerReductionModeCreateInfo *structure = (VkSamplerReductionModeCreateInfo *) header;
                skip |= ValidateRangedEnum("VkSamplerReductionModeCreateInfo", "reductionMode", "VkSamplerReductionMode", AllVkSamplerReductionModeEnums, structure->reductionMode, "VUID-VkSamplerReductionModeCreateInfo-reductionMode-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceSamplerFilterMinmaxProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES: { // Covers VUID-VkPhysicalDeviceSamplerFilterMinmaxProperties-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_SAMPLER_FILTER_MINMAX_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_sampler_filter_minmax))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES), but its parent extension "
                               "VK_EXT_sampler_filter_minmax has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkPhysicalDeviceVulkanMemoryModelFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES: { // Covers VUID-VkPhysicalDeviceVulkanMemoryModelFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_VULKAN_MEMORY_MODEL_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_vulkan_memory_model))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES), but its parent extension "
                               "VK_KHR_vulkan_memory_model has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceVulkanMemoryModelFeatures *structure = (VkPhysicalDeviceVulkanMemoryModelFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceVulkanMemoryModelFeatures", "vulkanMemoryModel", structure->vulkanMemoryModel);

                skip |= ValidateBool32("VkPhysicalDeviceVulkanMemoryModelFeatures", "vulkanMemoryModelDeviceScope", structure->vulkanMemoryModelDeviceScope);

                skip |= ValidateBool32("VkPhysicalDeviceVulkanMemoryModelFeatures", "vulkanMemoryModelAvailabilityVisibilityChains", structure->vulkanMemoryModelAvailabilityVisibilityChains);
            }
        } break;

        // Validation code for VkPhysicalDeviceImagelessFramebufferFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES: { // Covers VUID-VkPhysicalDeviceImagelessFramebufferFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_IMAGELESS_FRAMEBUFFER_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_imageless_framebuffer))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES), but its parent extension "
                               "VK_KHR_imageless_framebuffer has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceImagelessFramebufferFeatures *structure = (VkPhysicalDeviceImagelessFramebufferFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceImagelessFramebufferFeatures", "imagelessFramebuffer", structure->imagelessFramebuffer);
            }
        } break;

        // Validation code for VkFramebufferAttachmentsCreateInfo structure members
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO: { // Covers VUID-VkFramebufferAttachmentsCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_IMAGELESS_FRAMEBUFFER_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_imageless_framebuffer))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO), but its parent extension "
                               "VK_KHR_imageless_framebuffer has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkFramebufferAttachmentsCreateInfo *structure = (VkFramebufferAttachmentsCreateInfo *) header;
                skip |= ValidateStructTypeArray("VkFramebufferAttachmentsCreateInfo", "attachmentImageInfoCount", "pAttachmentImageInfos", "VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO", structure->attachmentImageInfoCount, structure->pAttachmentImageInfos, VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO, false, true, "VUID-VkFramebufferAttachmentImageInfo-sType-sType", "VUID-VkFramebufferAttachmentsCreateInfo-pAttachmentImageInfos-parameter", kVUIDUndefined);

                if (structure->pAttachmentImageInfos != nullptr)
                {
                    for (uint32_t attachmentImageInfoIndex = 0; attachmentImageInfoIndex < structure->attachmentImageInfoCount; ++attachmentImageInfoIndex)
                    {
                        skip |= ValidateFlags("VkFramebufferAttachmentsCreateInfo", ParameterName("pAttachmentImageInfos[%i].flags", ParameterName::IndexVector{ attachmentImageInfoIndex }), "VkImageCreateFlagBits", AllVkImageCreateFlagBits, structure->pAttachmentImageInfos[attachmentImageInfoIndex].flags, kOptionalFlags, "VUID-VkFramebufferAttachmentImageInfo-flags-parameter");

                        skip |= ValidateFlags("VkFramebufferAttachmentsCreateInfo", ParameterName("pAttachmentImageInfos[%i].usage", ParameterName::IndexVector{ attachmentImageInfoIndex }), "VkImageUsageFlagBits", AllVkImageUsageFlagBits, structure->pAttachmentImageInfos[attachmentImageInfoIndex].usage, kRequiredFlags, "VUID-VkFramebufferAttachmentImageInfo-usage-parameter", "VUID-VkFramebufferAttachmentImageInfo-usage-requiredbitmask");

                        skip |= ValidateRangedEnumArray("VkFramebufferAttachmentsCreateInfo", ParameterName("pAttachmentImageInfos[%i].viewFormatCount", ParameterName::IndexVector{ attachmentImageInfoIndex }), ParameterName("pAttachmentImageInfos[%i].pViewFormats", ParameterName::IndexVector{ attachmentImageInfoIndex }), "VkFormat", AllVkFormatEnums, structure->pAttachmentImageInfos[attachmentImageInfoIndex].viewFormatCount, structure->pAttachmentImageInfos[attachmentImageInfoIndex].pViewFormats, false, true);
                    }
                }
            }
        } break;

        // Validation code for VkRenderPassAttachmentBeginInfo structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO: { // Covers VUID-VkRenderPassAttachmentBeginInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_IMAGELESS_FRAMEBUFFER_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_imageless_framebuffer))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO), but its parent extension "
                               "VK_KHR_imageless_framebuffer has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkRenderPassAttachmentBeginInfo *structure = (VkRenderPassAttachmentBeginInfo *) header;
                skip |= ValidateArray("VkRenderPassAttachmentBeginInfo", "attachmentCount", "pAttachments", structure->attachmentCount, &structure->pAttachments, false, true, kVUIDUndefined, "VUID-VkRenderPassAttachmentBeginInfo-pAttachments-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceUniformBufferStandardLayoutFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES: { // Covers VUID-VkPhysicalDeviceUniformBufferStandardLayoutFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_UNIFORM_BUFFER_STANDARD_LAYOUT_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_uniform_buffer_standard_layout))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES), but its parent extension "
                               "VK_KHR_uniform_buffer_standard_layout has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceUniformBufferStandardLayoutFeatures *structure = (VkPhysicalDeviceUniformBufferStandardLayoutFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceUniformBufferStandardLayoutFeatures", "uniformBufferStandardLayout", structure->uniformBufferStandardLayout);
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES: { // Covers VUID-VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SHADER_SUBGROUP_EXTENDED_TYPES_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_shader_subgroup_extended_types))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES), but its parent extension "
                               "VK_KHR_shader_subgroup_extended_types has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES: { // Covers VUID-VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_separate_depth_stencil_layouts))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES), but its parent extension "
                               "VK_KHR_separate_depth_stencil_layouts has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *structure = (VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures", "separateDepthStencilLayouts", structure->separateDepthStencilLayouts);
            }
        } break;

        // Validation code for VkAttachmentReferenceStencilLayout structure members
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT: { // Covers VUID-VkAttachmentReferenceStencilLayout-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_separate_depth_stencil_layouts))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT), but its parent extension "
                               "VK_KHR_separate_depth_stencil_layouts has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkAttachmentReferenceStencilLayout *structure = (VkAttachmentReferenceStencilLayout *) header;
                skip |= ValidateRangedEnum("VkAttachmentReferenceStencilLayout", "stencilLayout", "VkImageLayout", AllVkImageLayoutEnums, structure->stencilLayout, "VUID-VkAttachmentReferenceStencilLayout-stencilLayout-parameter");
            }
        } break;

        // Validation code for VkAttachmentDescriptionStencilLayout structure members
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT: { // Covers VUID-VkAttachmentDescriptionStencilLayout-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_separate_depth_stencil_layouts))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT), but its parent extension "
                               "VK_KHR_separate_depth_stencil_layouts has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkAttachmentDescriptionStencilLayout *structure = (VkAttachmentDescriptionStencilLayout *) header;
                skip |= ValidateRangedEnum("VkAttachmentDescriptionStencilLayout", "stencilInitialLayout", "VkImageLayout", AllVkImageLayoutEnums, structure->stencilInitialLayout, "VUID-VkAttachmentDescriptionStencilLayout-stencilInitialLayout-parameter");

                skip |= ValidateRangedEnum("VkAttachmentDescriptionStencilLayout", "stencilFinalLayout", "VkImageLayout", AllVkImageLayoutEnums, structure->stencilFinalLayout, "VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceHostQueryResetFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES: { // Covers VUID-VkPhysicalDeviceHostQueryResetFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_HOST_QUERY_RESET_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_host_query_reset))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES), but its parent extension "
                               "VK_EXT_host_query_reset has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceHostQueryResetFeatures *structure = (VkPhysicalDeviceHostQueryResetFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceHostQueryResetFeatures", "hostQueryReset", structure->hostQueryReset);
            }
        } break;

        // Validation code for VkPhysicalDeviceTimelineSemaphoreFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES: { // Covers VUID-VkPhysicalDeviceTimelineSemaphoreFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_TIMELINE_SEMAPHORE_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_timeline_semaphore))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES), but its parent extension "
                               "VK_KHR_timeline_semaphore has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceTimelineSemaphoreFeatures *structure = (VkPhysicalDeviceTimelineSemaphoreFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceTimelineSemaphoreFeatures", "timelineSemaphore", structure->timelineSemaphore);
            }
        } break;

        // Validation code for VkPhysicalDeviceTimelineSemaphoreProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES: { // Covers VUID-VkPhysicalDeviceTimelineSemaphoreProperties-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_TIMELINE_SEMAPHORE_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_timeline_semaphore))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES), but its parent extension "
                               "VK_KHR_timeline_semaphore has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkSemaphoreTypeCreateInfo structure members
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO: { // Covers VUID-VkSemaphoreTypeCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_TIMELINE_SEMAPHORE_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_timeline_semaphore))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO), but its parent extension "
                               "VK_KHR_timeline_semaphore has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkSemaphoreTypeCreateInfo *structure = (VkSemaphoreTypeCreateInfo *) header;
                skip |= ValidateRangedEnum("VkSemaphoreTypeCreateInfo", "semaphoreType", "VkSemaphoreType", AllVkSemaphoreTypeEnums, structure->semaphoreType, "VUID-VkSemaphoreTypeCreateInfo-semaphoreType-parameter");
            }
        } break;

        // Validation code for VkTimelineSemaphoreSubmitInfo structure members
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO: { // Covers VUID-VkTimelineSemaphoreSubmitInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_TIMELINE_SEMAPHORE_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_timeline_semaphore))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO), but its parent extension "
                               "VK_KHR_timeline_semaphore has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkPhysicalDeviceBufferDeviceAddressFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES: { // Covers VUID-VkPhysicalDeviceBufferDeviceAddressFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_BUFFER_DEVICE_ADDRESS_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_buffer_device_address))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES), but its parent extension "
                               "VK_KHR_buffer_device_address has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceBufferDeviceAddressFeatures *structure = (VkPhysicalDeviceBufferDeviceAddressFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceBufferDeviceAddressFeatures", "bufferDeviceAddress", structure->bufferDeviceAddress);

                skip |= ValidateBool32("VkPhysicalDeviceBufferDeviceAddressFeatures", "bufferDeviceAddressCaptureReplay", structure->bufferDeviceAddressCaptureReplay);

                skip |= ValidateBool32("VkPhysicalDeviceBufferDeviceAddressFeatures", "bufferDeviceAddressMultiDevice", structure->bufferDeviceAddressMultiDevice);
            }
        } break;

        // Validation code for VkBufferOpaqueCaptureAddressCreateInfo structure members
        case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO: { // Covers VUID-VkBufferOpaqueCaptureAddressCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_BUFFER_DEVICE_ADDRESS_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_buffer_device_address))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO), but its parent extension "
                               "VK_KHR_buffer_device_address has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkMemoryOpaqueCaptureAddressAllocateInfo structure members
        case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO: { // Covers VUID-VkMemoryOpaqueCaptureAddressAllocateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_BUFFER_DEVICE_ADDRESS_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_buffer_device_address))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO), but its parent extension "
                               "VK_KHR_buffer_device_address has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkPhysicalDeviceVulkan13Features structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES: { // Covers VUID-VkPhysicalDeviceVulkan13Features-sType-sType
            if (api_version < VK_API_VERSION_1_3) {
                skip |= LogError(
                           instance, pnext_vuid,
                           "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES) which was added in VK_API_VERSION_1_3 but the "
                           "current effective API version is %s.",
                           api_name, parameter_name.get_name().c_str(), StringAPIVersion(api_version).c_str());
            }
            if (is_const_param) {
                VkPhysicalDeviceVulkan13Features *structure = (VkPhysicalDeviceVulkan13Features *) header;
                skip |= ValidateBool32("VkPhysicalDeviceVulkan13Features", "robustImageAccess", structure->robustImageAccess);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan13Features", "inlineUniformBlock", structure->inlineUniformBlock);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan13Features", "descriptorBindingInlineUniformBlockUpdateAfterBind", structure->descriptorBindingInlineUniformBlockUpdateAfterBind);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan13Features", "pipelineCreationCacheControl", structure->pipelineCreationCacheControl);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan13Features", "privateData", structure->privateData);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan13Features", "shaderDemoteToHelperInvocation", structure->shaderDemoteToHelperInvocation);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan13Features", "shaderTerminateInvocation", structure->shaderTerminateInvocation);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan13Features", "subgroupSizeControl", structure->subgroupSizeControl);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan13Features", "computeFullSubgroups", structure->computeFullSubgroups);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan13Features", "synchronization2", structure->synchronization2);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan13Features", "textureCompressionASTC_HDR", structure->textureCompressionASTC_HDR);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan13Features", "shaderZeroInitializeWorkgroupMemory", structure->shaderZeroInitializeWorkgroupMemory);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan13Features", "dynamicRendering", structure->dynamicRendering);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan13Features", "shaderIntegerDotProduct", structure->shaderIntegerDotProduct);

                skip |= ValidateBool32("VkPhysicalDeviceVulkan13Features", "maintenance4", structure->maintenance4);
            }
        } break;

        // Validation code for VkPhysicalDeviceVulkan13Properties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES: { // Covers VUID-VkPhysicalDeviceVulkan13Properties-sType-sType
            if (api_version < VK_API_VERSION_1_3) {
                skip |= LogError(
                           instance, pnext_vuid,
                           "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES) which was added in VK_API_VERSION_1_3 but the "
                           "current effective API version is %s.",
                           api_name, parameter_name.get_name().c_str(), StringAPIVersion(api_version).c_str());
            }
        } break;

        // Validation code for VkPipelineCreationFeedbackCreateInfo structure members
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO: { // Covers VUID-VkPipelineCreationFeedbackCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_PIPELINE_CREATION_FEEDBACK_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_pipeline_creation_feedback))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO), but its parent extension "
                               "VK_EXT_pipeline_creation_feedback has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPipelineCreationFeedbackCreateInfo *structure = (VkPipelineCreationFeedbackCreateInfo *) header;
                skip |= ValidateRequiredPointer("VkPipelineCreationFeedbackCreateInfo", "pPipelineCreationFeedback", structure->pPipelineCreationFeedback, "VUID-VkPipelineCreationFeedbackCreateInfo-pPipelineCreationFeedback-parameter");

                if (structure->pPipelineCreationFeedback != nullptr)
                {
                }

                skip |= ValidateArray("VkPipelineCreationFeedbackCreateInfo", "pipelineStageCreationFeedbackCount", "pPipelineStageCreationFeedbacks", structure->pipelineStageCreationFeedbackCount, &structure->pPipelineStageCreationFeedbacks, false, true, kVUIDUndefined, "VUID-VkPipelineCreationFeedbackCreateInfo-pPipelineStageCreationFeedbacks-parameter");

                if (structure->pPipelineStageCreationFeedbacks != nullptr)
                {
                    for (uint32_t pipelineStageCreationFeedbackIndex = 0; pipelineStageCreationFeedbackIndex < structure->pipelineStageCreationFeedbackCount; ++pipelineStageCreationFeedbackIndex)
                    {
                    }
                }
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderTerminateInvocationFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES: { // Covers VUID-VkPhysicalDeviceShaderTerminateInvocationFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SHADER_TERMINATE_INVOCATION_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_shader_terminate_invocation))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES), but its parent extension "
                               "VK_KHR_shader_terminate_invocation has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceShaderTerminateInvocationFeatures *structure = (VkPhysicalDeviceShaderTerminateInvocationFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShaderTerminateInvocationFeatures", "shaderTerminateInvocation", structure->shaderTerminateInvocation);
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES: { // Covers VUID-VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_SHADER_DEMOTE_TO_HELPER_INVOCATION_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_shader_demote_to_helper_invocation))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES), but its parent extension "
                               "VK_EXT_shader_demote_to_helper_invocation has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *structure = (VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures", "shaderDemoteToHelperInvocation", structure->shaderDemoteToHelperInvocation);
            }
        } break;

        // Validation code for VkPhysicalDevicePrivateDataFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES: { // Covers VUID-VkPhysicalDevicePrivateDataFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_PRIVATE_DATA_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_private_data))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES), but its parent extension "
                               "VK_EXT_private_data has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDevicePrivateDataFeatures *structure = (VkPhysicalDevicePrivateDataFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDevicePrivateDataFeatures", "privateData", structure->privateData);
            }
        } break;

        // Validation code for VkDevicePrivateDataCreateInfo structure members
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO: { // Covers VUID-VkDevicePrivateDataCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_PRIVATE_DATA_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_private_data))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO), but its parent extension "
                               "VK_EXT_private_data has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkPhysicalDevicePipelineCreationCacheControlFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES: { // Covers VUID-VkPhysicalDevicePipelineCreationCacheControlFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_PIPELINE_CREATION_CACHE_CONTROL_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_pipeline_creation_cache_control))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES), but its parent extension "
                               "VK_EXT_pipeline_creation_cache_control has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDevicePipelineCreationCacheControlFeatures *structure = (VkPhysicalDevicePipelineCreationCacheControlFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDevicePipelineCreationCacheControlFeatures", "pipelineCreationCacheControl", structure->pipelineCreationCacheControl);
            }
        } break;

        // Validation code for VkMemoryBarrier2 structure members
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2: { // Covers VUID-VkMemoryBarrier2-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_synchronization2))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_MEMORY_BARRIER_2), but its parent extension "
                               "VK_KHR_synchronization2 has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkMemoryBarrier2 *structure = (VkMemoryBarrier2 *) header;
                skip |= ValidateFlags("VkMemoryBarrier2", "srcStageMask", "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, structure->srcStageMask, kOptionalFlags, "VUID-VkMemoryBarrier2-srcStageMask-parameter");

                skip |= ValidateFlags("VkMemoryBarrier2", "srcAccessMask", "VkAccessFlagBits2", AllVkAccessFlagBits2, structure->srcAccessMask, kOptionalFlags, "VUID-VkMemoryBarrier2-srcAccessMask-parameter");

                skip |= ValidateFlags("VkMemoryBarrier2", "dstStageMask", "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, structure->dstStageMask, kOptionalFlags, "VUID-VkMemoryBarrier2-dstStageMask-parameter");

                skip |= ValidateFlags("VkMemoryBarrier2", "dstAccessMask", "VkAccessFlagBits2", AllVkAccessFlagBits2, structure->dstAccessMask, kOptionalFlags, "VUID-VkMemoryBarrier2-dstAccessMask-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceSynchronization2Features structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES: { // Covers VUID-VkPhysicalDeviceSynchronization2Features-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_synchronization2))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES), but its parent extension "
                               "VK_KHR_synchronization2 has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceSynchronization2Features *structure = (VkPhysicalDeviceSynchronization2Features *) header;
                skip |= ValidateBool32("VkPhysicalDeviceSynchronization2Features", "synchronization2", structure->synchronization2);
            }
        } break;

        // Validation code for VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES: { // Covers VUID-VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_ZERO_INITIALIZE_WORKGROUP_MEMORY_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_zero_initialize_workgroup_memory))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES), but its parent extension "
                               "VK_KHR_zero_initialize_workgroup_memory has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *structure = (VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures", "shaderZeroInitializeWorkgroupMemory", structure->shaderZeroInitializeWorkgroupMemory);
            }
        } break;

        // Validation code for VkPhysicalDeviceImageRobustnessFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES: { // Covers VUID-VkPhysicalDeviceImageRobustnessFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_IMAGE_ROBUSTNESS_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_image_robustness))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES), but its parent extension "
                               "VK_EXT_image_robustness has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceImageRobustnessFeatures *structure = (VkPhysicalDeviceImageRobustnessFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceImageRobustnessFeatures", "robustImageAccess", structure->robustImageAccess);
            }
        } break;

        // Validation code for VkPhysicalDeviceSubgroupSizeControlFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES: { // Covers VUID-VkPhysicalDeviceSubgroupSizeControlFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_SUBGROUP_SIZE_CONTROL_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_subgroup_size_control))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES), but its parent extension "
                               "VK_EXT_subgroup_size_control has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceSubgroupSizeControlFeatures *structure = (VkPhysicalDeviceSubgroupSizeControlFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceSubgroupSizeControlFeatures", "subgroupSizeControl", structure->subgroupSizeControl);

                skip |= ValidateBool32("VkPhysicalDeviceSubgroupSizeControlFeatures", "computeFullSubgroups", structure->computeFullSubgroups);
            }
        } break;

        // Validation code for VkPhysicalDeviceSubgroupSizeControlProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES: { // Covers VUID-VkPhysicalDeviceSubgroupSizeControlProperties-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_SUBGROUP_SIZE_CONTROL_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_subgroup_size_control))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES), but its parent extension "
                               "VK_EXT_subgroup_size_control has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkPipelineShaderStageRequiredSubgroupSizeCreateInfo structure members
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO: { // Covers VUID-VkPipelineShaderStageRequiredSubgroupSizeCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_SUBGROUP_SIZE_CONTROL_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_subgroup_size_control))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO), but its parent extension "
                               "VK_EXT_subgroup_size_control has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkPhysicalDeviceInlineUniformBlockFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES: { // Covers VUID-VkPhysicalDeviceInlineUniformBlockFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_INLINE_UNIFORM_BLOCK_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_inline_uniform_block))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES), but its parent extension "
                               "VK_EXT_inline_uniform_block has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceInlineUniformBlockFeatures *structure = (VkPhysicalDeviceInlineUniformBlockFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceInlineUniformBlockFeatures", "inlineUniformBlock", structure->inlineUniformBlock);

                skip |= ValidateBool32("VkPhysicalDeviceInlineUniformBlockFeatures", "descriptorBindingInlineUniformBlockUpdateAfterBind", structure->descriptorBindingInlineUniformBlockUpdateAfterBind);
            }
        } break;

        // Validation code for VkPhysicalDeviceInlineUniformBlockProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES: { // Covers VUID-VkPhysicalDeviceInlineUniformBlockProperties-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_INLINE_UNIFORM_BLOCK_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_inline_uniform_block))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES), but its parent extension "
                               "VK_EXT_inline_uniform_block has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkWriteDescriptorSetInlineUniformBlock structure members
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK: { // Covers VUID-VkWriteDescriptorSetInlineUniformBlock-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_INLINE_UNIFORM_BLOCK_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_inline_uniform_block))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK), but its parent extension "
                               "VK_EXT_inline_uniform_block has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkWriteDescriptorSetInlineUniformBlock *structure = (VkWriteDescriptorSetInlineUniformBlock *) header;
                skip |= ValidateArray("VkWriteDescriptorSetInlineUniformBlock", "dataSize", "pData", structure->dataSize, &structure->pData, true, true, "VUID-VkWriteDescriptorSetInlineUniformBlock-dataSize-arraylength", "VUID-VkWriteDescriptorSetInlineUniformBlock-pData-parameter");
            }
        } break;

        // Validation code for VkDescriptorPoolInlineUniformBlockCreateInfo structure members
        case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO: { // Covers VUID-VkDescriptorPoolInlineUniformBlockCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_INLINE_UNIFORM_BLOCK_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_inline_uniform_block))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO), but its parent extension "
                               "VK_EXT_inline_uniform_block has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkPhysicalDeviceTextureCompressionASTCHDRFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES: { // Covers VUID-VkPhysicalDeviceTextureCompressionASTCHDRFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_TEXTURE_COMPRESSION_ASTC_HDR_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_texture_compression_astc_hdr))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES), but its parent extension "
                               "VK_EXT_texture_compression_astc_hdr has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceTextureCompressionASTCHDRFeatures *structure = (VkPhysicalDeviceTextureCompressionASTCHDRFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceTextureCompressionASTCHDRFeatures", "textureCompressionASTC_HDR", structure->textureCompressionASTC_HDR);
            }
        } break;

        // Validation code for VkPipelineRenderingCreateInfo structure members
        case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO: { // Covers VUID-VkPipelineRenderingCreateInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DYNAMIC_RENDERING_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_dynamic_rendering))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO), but its parent extension "
                               "VK_KHR_dynamic_rendering has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkPhysicalDeviceDynamicRenderingFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES: { // Covers VUID-VkPhysicalDeviceDynamicRenderingFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DYNAMIC_RENDERING_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_dynamic_rendering))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES), but its parent extension "
                               "VK_KHR_dynamic_rendering has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceDynamicRenderingFeatures *structure = (VkPhysicalDeviceDynamicRenderingFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceDynamicRenderingFeatures", "dynamicRendering", structure->dynamicRendering);
            }
        } break;

        // Validation code for VkCommandBufferInheritanceRenderingInfo structure members
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO: { // Covers VUID-VkCommandBufferInheritanceRenderingInfo-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DYNAMIC_RENDERING_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_dynamic_rendering))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO), but its parent extension "
                               "VK_KHR_dynamic_rendering has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkCommandBufferInheritanceRenderingInfo *structure = (VkCommandBufferInheritanceRenderingInfo *) header;
                skip |= ValidateFlags("VkCommandBufferInheritanceRenderingInfo", "flags", "VkRenderingFlagBits", AllVkRenderingFlagBits, structure->flags, kOptionalFlags, "VUID-VkCommandBufferInheritanceRenderingInfo-flags-parameter");

                skip |= ValidateRangedEnumArray("VkCommandBufferInheritanceRenderingInfo", "colorAttachmentCount", "pColorAttachmentFormats", "VkFormat", AllVkFormatEnums, structure->colorAttachmentCount, structure->pColorAttachmentFormats, false, true);

                skip |= ValidateRangedEnum("VkCommandBufferInheritanceRenderingInfo", "depthAttachmentFormat", "VkFormat", AllVkFormatEnums, structure->depthAttachmentFormat, "VUID-VkCommandBufferInheritanceRenderingInfo-depthAttachmentFormat-parameter");

                skip |= ValidateRangedEnum("VkCommandBufferInheritanceRenderingInfo", "stencilAttachmentFormat", "VkFormat", AllVkFormatEnums, structure->stencilAttachmentFormat, "VUID-VkCommandBufferInheritanceRenderingInfo-stencilAttachmentFormat-parameter");

                skip |= ValidateFlags("VkCommandBufferInheritanceRenderingInfo", "rasterizationSamples", "VkSampleCountFlagBits", AllVkSampleCountFlagBits, structure->rasterizationSamples, kOptionalSingleBit, "VUID-VkCommandBufferInheritanceRenderingInfo-rasterizationSamples-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderIntegerDotProductFeatures structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES: { // Covers VUID-VkPhysicalDeviceShaderIntegerDotProductFeatures-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SHADER_INTEGER_DOT_PRODUCT_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_shader_integer_dot_product))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES), but its parent extension "
                               "VK_KHR_shader_integer_dot_product has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceShaderIntegerDotProductFeatures *structure = (VkPhysicalDeviceShaderIntegerDotProductFeatures *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShaderIntegerDotProductFeatures", "shaderIntegerDotProduct", structure->shaderIntegerDotProduct);
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderIntegerDotProductProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES: { // Covers VUID-VkPhysicalDeviceShaderIntegerDotProductProperties-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_SHADER_INTEGER_DOT_PRODUCT_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_shader_integer_dot_product))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES), but its parent extension "
                               "VK_KHR_shader_integer_dot_product has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkPhysicalDeviceTexelBufferAlignmentProperties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES: { // Covers VUID-VkPhysicalDeviceTexelBufferAlignmentProperties-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_EXT_TEXEL_BUFFER_ALIGNMENT_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_ext_texel_buffer_alignment))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES), but its parent extension "
                               "VK_EXT_texel_buffer_alignment has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkFormatProperties3 structure members
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3: { // Covers VUID-VkFormatProperties3-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_FORMAT_FEATURE_FLAGS_2_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_format_feature_flags2))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3), but its parent extension "
                               "VK_KHR_format_feature_flags2 has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkPhysicalDeviceMaintenance4Features structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES: { // Covers VUID-VkPhysicalDeviceMaintenance4Features-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MAINTENANCE_4_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_maintenance4))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES), but its parent extension "
                               "VK_KHR_maintenance4 has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

            if (is_const_param) {
                VkPhysicalDeviceMaintenance4Features *structure = (VkPhysicalDeviceMaintenance4Features *) header;
                skip |= ValidateBool32("VkPhysicalDeviceMaintenance4Features", "maintenance4", structure->maintenance4);
            }
        } break;

        // Validation code for VkPhysicalDeviceMaintenance4Properties structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES: { // Covers VUID-VkPhysicalDeviceMaintenance4Properties-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_MAINTENANCE_4_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_maintenance4))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES), but its parent extension "
                               "VK_KHR_maintenance4 has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // No Validation code for VkImageSwapchainCreateInfoKHR structure members  -- Covers VUID-VkImageSwapchainCreateInfoKHR-sType-sType

        // Validation code for VkBindImageMemorySwapchainInfoKHR structure members
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR: { // Covers VUID-VkBindImageMemorySwapchainInfoKHR-sType-sType
            if (is_const_param) {
                VkBindImageMemorySwapchainInfoKHR *structure = (VkBindImageMemorySwapchainInfoKHR *) header;
                skip |= ValidateRequiredHandle("VkBindImageMemorySwapchainInfoKHR", "swapchain", structure->swapchain);
            }
        } break;

        // Validation code for VkDeviceGroupPresentInfoKHR structure members
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR: { // Covers VUID-VkDeviceGroupPresentInfoKHR-sType-sType
            if (is_const_param) {
                VkDeviceGroupPresentInfoKHR *structure = (VkDeviceGroupPresentInfoKHR *) header;
                skip |= ValidateArray("VkDeviceGroupPresentInfoKHR", "swapchainCount", "pDeviceMasks", structure->swapchainCount, &structure->pDeviceMasks, false, true, kVUIDUndefined, "VUID-VkDeviceGroupPresentInfoKHR-pDeviceMasks-parameter");

                skip |= ValidateFlags("VkDeviceGroupPresentInfoKHR", "mode", "VkDeviceGroupPresentModeFlagBitsKHR", AllVkDeviceGroupPresentModeFlagBitsKHR, structure->mode, kRequiredSingleBit, "VUID-VkDeviceGroupPresentInfoKHR-mode-parameter", "VUID-VkDeviceGroupPresentInfoKHR-mode-parameter");
            }
        } break;

        // Validation code for VkDeviceGroupSwapchainCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR: { // Covers VUID-VkDeviceGroupSwapchainCreateInfoKHR-sType-sType
            if (is_const_param) {
                VkDeviceGroupSwapchainCreateInfoKHR *structure = (VkDeviceGroupSwapchainCreateInfoKHR *) header;
                skip |= ValidateFlags("VkDeviceGroupSwapchainCreateInfoKHR", "modes", "VkDeviceGroupPresentModeFlagBitsKHR", AllVkDeviceGroupPresentModeFlagBitsKHR, structure->modes, kRequiredFlags, "VUID-VkDeviceGroupSwapchainCreateInfoKHR-modes-parameter", "VUID-VkDeviceGroupSwapchainCreateInfoKHR-modes-requiredbitmask");
            }
        } break;

        // Validation code for VkDisplayPresentInfoKHR structure members
        case VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR: { // Covers VUID-VkDisplayPresentInfoKHR-sType-sType
            if (is_const_param) {
                VkDisplayPresentInfoKHR *structure = (VkDisplayPresentInfoKHR *) header;
                skip |= ValidateBool32("VkDisplayPresentInfoKHR", "persistent", structure->persistent);
            }
        } break;

        // No Validation code for VkQueueFamilyQueryResultStatusPropertiesKHR structure members  -- Covers VUID-VkQueueFamilyQueryResultStatusPropertiesKHR-sType-sType

        // No Validation code for VkQueueFamilyVideoPropertiesKHR structure members  -- Covers VUID-VkQueueFamilyVideoPropertiesKHR-sType-sType

        // Validation code for VkVideoProfileInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR: { // Covers VUID-VkVideoProfileInfoKHR-sType-sType
            if (is_const_param) {
                VkVideoProfileInfoKHR *structure = (VkVideoProfileInfoKHR *) header;
                skip |= ValidateFlags("VkVideoProfileInfoKHR", "videoCodecOperation", "VkVideoCodecOperationFlagBitsKHR", AllVkVideoCodecOperationFlagBitsKHR, structure->videoCodecOperation, kRequiredSingleBit, "VUID-VkVideoProfileInfoKHR-videoCodecOperation-parameter", "VUID-VkVideoProfileInfoKHR-videoCodecOperation-parameter");

                skip |= ValidateFlags("VkVideoProfileInfoKHR", "chromaSubsampling", "VkVideoChromaSubsamplingFlagBitsKHR", AllVkVideoChromaSubsamplingFlagBitsKHR, structure->chromaSubsampling, kRequiredFlags, "VUID-VkVideoProfileInfoKHR-chromaSubsampling-parameter", "VUID-VkVideoProfileInfoKHR-chromaSubsampling-requiredbitmask");

                skip |= ValidateFlags("VkVideoProfileInfoKHR", "lumaBitDepth", "VkVideoComponentBitDepthFlagBitsKHR", AllVkVideoComponentBitDepthFlagBitsKHR, structure->lumaBitDepth, kRequiredFlags, "VUID-VkVideoProfileInfoKHR-lumaBitDepth-parameter", "VUID-VkVideoProfileInfoKHR-lumaBitDepth-requiredbitmask");

                skip |= ValidateFlags("VkVideoProfileInfoKHR", "chromaBitDepth", "VkVideoComponentBitDepthFlagBitsKHR", AllVkVideoComponentBitDepthFlagBitsKHR, structure->chromaBitDepth, kOptionalFlags, "VUID-VkVideoProfileInfoKHR-chromaBitDepth-parameter");
            }
        } break;

        // Validation code for VkVideoProfileListInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR: { // Covers VUID-VkVideoProfileListInfoKHR-sType-sType
            if (is_const_param) {
                VkVideoProfileListInfoKHR *structure = (VkVideoProfileListInfoKHR *) header;
                skip |= ValidateStructTypeArray("VkVideoProfileListInfoKHR", "profileCount", "pProfiles", "VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR", structure->profileCount, structure->pProfiles, VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR, false, true, "VUID-VkVideoProfileInfoKHR-sType-sType", "VUID-VkVideoProfileListInfoKHR-pProfiles-parameter", kVUIDUndefined);

                if (structure->pProfiles != nullptr)
                {
                    for (uint32_t profileIndex = 0; profileIndex < structure->profileCount; ++profileIndex)
                    {
                        skip |= ValidateFlags("VkVideoProfileListInfoKHR", ParameterName("pProfiles[%i].videoCodecOperation", ParameterName::IndexVector{ profileIndex }), "VkVideoCodecOperationFlagBitsKHR", AllVkVideoCodecOperationFlagBitsKHR, structure->pProfiles[profileIndex].videoCodecOperation, kRequiredSingleBit, "VUID-VkVideoProfileInfoKHR-videoCodecOperation-parameter", "VUID-VkVideoProfileInfoKHR-videoCodecOperation-parameter");

                        skip |= ValidateFlags("VkVideoProfileListInfoKHR", ParameterName("pProfiles[%i].chromaSubsampling", ParameterName::IndexVector{ profileIndex }), "VkVideoChromaSubsamplingFlagBitsKHR", AllVkVideoChromaSubsamplingFlagBitsKHR, structure->pProfiles[profileIndex].chromaSubsampling, kRequiredFlags, "VUID-VkVideoProfileInfoKHR-chromaSubsampling-parameter", "VUID-VkVideoProfileInfoKHR-chromaSubsampling-requiredbitmask");

                        skip |= ValidateFlags("VkVideoProfileListInfoKHR", ParameterName("pProfiles[%i].lumaBitDepth", ParameterName::IndexVector{ profileIndex }), "VkVideoComponentBitDepthFlagBitsKHR", AllVkVideoComponentBitDepthFlagBitsKHR, structure->pProfiles[profileIndex].lumaBitDepth, kRequiredFlags, "VUID-VkVideoProfileInfoKHR-lumaBitDepth-parameter", "VUID-VkVideoProfileInfoKHR-lumaBitDepth-requiredbitmask");

                        skip |= ValidateFlags("VkVideoProfileListInfoKHR", ParameterName("pProfiles[%i].chromaBitDepth", ParameterName::IndexVector{ profileIndex }), "VkVideoComponentBitDepthFlagBitsKHR", AllVkVideoComponentBitDepthFlagBitsKHR, structure->pProfiles[profileIndex].chromaBitDepth, kOptionalFlags, "VUID-VkVideoProfileInfoKHR-chromaBitDepth-parameter");
                    }
                }
            }
        } break;

        // No Validation code for VkVideoDecodeCapabilitiesKHR structure members  -- Covers VUID-VkVideoDecodeCapabilitiesKHR-sType-sType

        // Validation code for VkVideoDecodeUsageInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_USAGE_INFO_KHR: { // Covers VUID-VkVideoDecodeUsageInfoKHR-sType-sType
            if (is_const_param) {
                VkVideoDecodeUsageInfoKHR *structure = (VkVideoDecodeUsageInfoKHR *) header;
                skip |= ValidateFlags("VkVideoDecodeUsageInfoKHR", "videoUsageHints", "VkVideoDecodeUsageFlagBitsKHR", AllVkVideoDecodeUsageFlagBitsKHR, structure->videoUsageHints, kOptionalFlags, "VUID-VkVideoDecodeUsageInfoKHR-videoUsageHints-parameter");
            }
        } break;

        // Validation code for VkVideoDecodeH264ProfileInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_INFO_KHR: { // Covers VUID-VkVideoDecodeH264ProfileInfoKHR-sType-sType
            if (is_const_param) {
                VkVideoDecodeH264ProfileInfoKHR *structure = (VkVideoDecodeH264ProfileInfoKHR *) header;
                skip |= ValidateFlags("VkVideoDecodeH264ProfileInfoKHR", "pictureLayout", "VkVideoDecodeH264PictureLayoutFlagBitsKHR", AllVkVideoDecodeH264PictureLayoutFlagBitsKHR, structure->pictureLayout, kOptionalSingleBit, "VUID-VkVideoDecodeH264ProfileInfoKHR-pictureLayout-parameter");
            }
        } break;

        // No Validation code for VkVideoDecodeH264CapabilitiesKHR structure members  -- Covers VUID-VkVideoDecodeH264CapabilitiesKHR-sType-sType

        // Validation code for VkVideoDecodeH264SessionParametersAddInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR: { // Covers VUID-VkVideoDecodeH264SessionParametersAddInfoKHR-sType-sType
            if (is_const_param) {
                VkVideoDecodeH264SessionParametersAddInfoKHR *structure = (VkVideoDecodeH264SessionParametersAddInfoKHR *) header;
                skip |= ValidateArray("VkVideoDecodeH264SessionParametersAddInfoKHR", "stdSPSCount", "pStdSPSs", structure->stdSPSCount, &structure->pStdSPSs, false, true, kVUIDUndefined, "VUID-VkVideoDecodeH264SessionParametersAddInfoKHR-pStdSPSs-parameter");

                skip |= ValidateArray("VkVideoDecodeH264SessionParametersAddInfoKHR", "stdPPSCount", "pStdPPSs", structure->stdPPSCount, &structure->pStdPPSs, false, true, kVUIDUndefined, "VUID-VkVideoDecodeH264SessionParametersAddInfoKHR-pStdPPSs-parameter");
            }
        } break;

        // Validation code for VkVideoDecodeH264SessionParametersCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR: { // Covers VUID-VkVideoDecodeH264SessionParametersCreateInfoKHR-sType-sType
            if (is_const_param) {
                VkVideoDecodeH264SessionParametersCreateInfoKHR *structure = (VkVideoDecodeH264SessionParametersCreateInfoKHR *) header;
                skip |= ValidateStructType("VkVideoDecodeH264SessionParametersCreateInfoKHR", "pParametersAddInfo", "VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR", structure->pParametersAddInfo, VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR, false, "VUID-VkVideoDecodeH264SessionParametersCreateInfoKHR-pParametersAddInfo-parameter", "VUID-VkVideoDecodeH264SessionParametersAddInfoKHR-sType-sType");

                if (structure->pParametersAddInfo != nullptr)
                {
                    skip |= ValidateArray("VkVideoDecodeH264SessionParametersCreateInfoKHR", "pParametersAddInfo->stdSPSCount", "pParametersAddInfo->pStdSPSs", structure->pParametersAddInfo->stdSPSCount, &structure->pParametersAddInfo->pStdSPSs, false, true, kVUIDUndefined, "VUID-VkVideoDecodeH264SessionParametersAddInfoKHR-pStdSPSs-parameter");

                    skip |= ValidateArray("VkVideoDecodeH264SessionParametersCreateInfoKHR", "pParametersAddInfo->stdPPSCount", "pParametersAddInfo->pStdPPSs", structure->pParametersAddInfo->stdPPSCount, &structure->pParametersAddInfo->pStdPPSs, false, true, kVUIDUndefined, "VUID-VkVideoDecodeH264SessionParametersAddInfoKHR-pStdPPSs-parameter");
                }
            }
        } break;

        // Validation code for VkVideoDecodeH264PictureInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PICTURE_INFO_KHR: { // Covers VUID-VkVideoDecodeH264PictureInfoKHR-sType-sType
            if (is_const_param) {
                VkVideoDecodeH264PictureInfoKHR *structure = (VkVideoDecodeH264PictureInfoKHR *) header;
                skip |= ValidateRequiredPointer("VkVideoDecodeH264PictureInfoKHR", "pStdPictureInfo", structure->pStdPictureInfo, "VUID-VkVideoDecodeH264PictureInfoKHR-pStdPictureInfo-parameter");

                skip |= ValidateArray("VkVideoDecodeH264PictureInfoKHR", "sliceCount", "pSliceOffsets", structure->sliceCount, &structure->pSliceOffsets, true, true, "VUID-VkVideoDecodeH264PictureInfoKHR-sliceCount-arraylength", "VUID-VkVideoDecodeH264PictureInfoKHR-pSliceOffsets-parameter");
            }
        } break;

        // Validation code for VkVideoDecodeH264DpbSlotInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_DPB_SLOT_INFO_KHR: { // Covers VUID-VkVideoDecodeH264DpbSlotInfoKHR-sType-sType
            if (is_const_param) {
                VkVideoDecodeH264DpbSlotInfoKHR *structure = (VkVideoDecodeH264DpbSlotInfoKHR *) header;
                skip |= ValidateRequiredPointer("VkVideoDecodeH264DpbSlotInfoKHR", "pStdReferenceInfo", structure->pStdReferenceInfo, "VUID-VkVideoDecodeH264DpbSlotInfoKHR-pStdReferenceInfo-parameter");
            }
        } break;

        // Validation code for VkRenderingFragmentShadingRateAttachmentInfoKHR structure members
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR: { // Covers VUID-VkRenderingFragmentShadingRateAttachmentInfoKHR-sType-sType
            if (is_const_param) {
                VkRenderingFragmentShadingRateAttachmentInfoKHR *structure = (VkRenderingFragmentShadingRateAttachmentInfoKHR *) header;
                skip |= ValidateRangedEnum("VkRenderingFragmentShadingRateAttachmentInfoKHR", "imageLayout", "VkImageLayout", AllVkImageLayoutEnums, structure->imageLayout, "VUID-VkRenderingFragmentShadingRateAttachmentInfoKHR-imageLayout-parameter");

            }
        } break;

        // Validation code for VkRenderingFragmentDensityMapAttachmentInfoEXT structure members
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT: { // Covers VUID-VkRenderingFragmentDensityMapAttachmentInfoEXT-sType-sType
            if (is_const_param) {
                VkRenderingFragmentDensityMapAttachmentInfoEXT *structure = (VkRenderingFragmentDensityMapAttachmentInfoEXT *) header;
                skip |= ValidateRequiredHandle("VkRenderingFragmentDensityMapAttachmentInfoEXT", "imageView", structure->imageView);

                skip |= ValidateRangedEnum("VkRenderingFragmentDensityMapAttachmentInfoEXT", "imageLayout", "VkImageLayout", AllVkImageLayoutEnums, structure->imageLayout, "VUID-VkRenderingFragmentDensityMapAttachmentInfoEXT-imageLayout-parameter");
            }
        } break;

        // Validation code for VkAttachmentSampleCountInfoAMD structure members
        case VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD: { // Covers VUID-VkAttachmentSampleCountInfoAMD-sType-sType
            if (is_const_param) {
                if ((is_physdev_api && !SupportedByPdev(physical_device, VK_KHR_DYNAMIC_RENDERING_EXTENSION_NAME)) || (!is_physdev_api && !IsExtEnabled(device_extensions.vk_khr_dynamic_rendering))) {
                        skip |= LogError(
                               instance, pnext_vuid,
                               "%s: Includes a pNext pointer (%s) to a VkStructureType (VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD), but its parent extension "
                               "VK_KHR_dynamic_rendering has not been enabled.",
                               api_name, parameter_name.get_name().c_str());
                }
            }

        } break;

        // Validation code for VkMultiviewPerViewAttributesInfoNVX structure members
        case VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX: { // Covers VUID-VkMultiviewPerViewAttributesInfoNVX-sType-sType
            if (is_const_param) {
                VkMultiviewPerViewAttributesInfoNVX *structure = (VkMultiviewPerViewAttributesInfoNVX *) header;
                skip |= ValidateBool32("VkMultiviewPerViewAttributesInfoNVX", "perViewAttributes", structure->perViewAttributes);

                skip |= ValidateBool32("VkMultiviewPerViewAttributesInfoNVX", "perViewAttributesPositionXOnly", structure->perViewAttributesPositionXOnly);
            }
        } break;

#ifdef VK_USE_PLATFORM_WIN32_KHR
        // Validation code for VkImportMemoryWin32HandleInfoKHR structure members
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR: { // Covers VUID-VkImportMemoryWin32HandleInfoKHR-sType-sType
            if (is_const_param) {
                VkImportMemoryWin32HandleInfoKHR *structure = (VkImportMemoryWin32HandleInfoKHR *) header;
                skip |= ValidateFlags("VkImportMemoryWin32HandleInfoKHR", "handleType", "VkExternalMemoryHandleTypeFlagBits", AllVkExternalMemoryHandleTypeFlagBits, structure->handleType, kOptionalSingleBit, "VUID-VkImportMemoryWin32HandleInfoKHR-handleType-parameter");
            }
        } break;
#endif // VK_USE_PLATFORM_WIN32_KHR

        // No Validation code for VkExportMemoryWin32HandleInfoKHR structure members  -- Covers VUID-VkExportMemoryWin32HandleInfoKHR-sType-sType

        // Validation code for VkImportMemoryFdInfoKHR structure members
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR: { // Covers VUID-VkImportMemoryFdInfoKHR-sType-sType
            if (is_const_param) {
                VkImportMemoryFdInfoKHR *structure = (VkImportMemoryFdInfoKHR *) header;
                skip |= ValidateFlags("VkImportMemoryFdInfoKHR", "handleType", "VkExternalMemoryHandleTypeFlagBits", AllVkExternalMemoryHandleTypeFlagBits, structure->handleType, kOptionalSingleBit, "VUID-VkImportMemoryFdInfoKHR-handleType-parameter");
            }
        } break;

#ifdef VK_USE_PLATFORM_WIN32_KHR
        // Validation code for VkWin32KeyedMutexAcquireReleaseInfoKHR structure members
        case VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR: { // Covers VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-sType-sType
            if (is_const_param) {
                VkWin32KeyedMutexAcquireReleaseInfoKHR *structure = (VkWin32KeyedMutexAcquireReleaseInfoKHR *) header;
                skip |= ValidateArray("VkWin32KeyedMutexAcquireReleaseInfoKHR", "acquireCount", "pAcquireSyncs", structure->acquireCount, &structure->pAcquireSyncs, false, true, kVUIDUndefined, "VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireSyncs-parameter");

                skip |= ValidateArray("VkWin32KeyedMutexAcquireReleaseInfoKHR", "acquireCount", "pAcquireKeys", structure->acquireCount, &structure->pAcquireKeys, false, true, kVUIDUndefined, "VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireKeys-parameter");

                skip |= ValidateArray("VkWin32KeyedMutexAcquireReleaseInfoKHR", "acquireCount", "pAcquireTimeouts", structure->acquireCount, &structure->pAcquireTimeouts, false, true, kVUIDUndefined, "VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireTimeouts-parameter");

                skip |= ValidateArray("VkWin32KeyedMutexAcquireReleaseInfoKHR", "releaseCount", "pReleaseSyncs", structure->releaseCount, &structure->pReleaseSyncs, false, true, kVUIDUndefined, "VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pReleaseSyncs-parameter");

                skip |= ValidateArray("VkWin32KeyedMutexAcquireReleaseInfoKHR", "releaseCount", "pReleaseKeys", structure->releaseCount, &structure->pReleaseKeys, false, true, kVUIDUndefined, "VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pReleaseKeys-parameter");
            }
        } break;
#endif // VK_USE_PLATFORM_WIN32_KHR

        // No Validation code for VkExportSemaphoreWin32HandleInfoKHR structure members  -- Covers VUID-VkExportSemaphoreWin32HandleInfoKHR-sType-sType

        // No Validation code for VkD3D12FenceSubmitInfoKHR structure members  -- Covers VUID-VkD3D12FenceSubmitInfoKHR-sType-sType

        // No Validation code for VkPhysicalDevicePushDescriptorPropertiesKHR structure members  -- Covers VUID-VkPhysicalDevicePushDescriptorPropertiesKHR-sType-sType

        // Validation code for VkPresentRegionsKHR structure members
        case VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR: { // Covers VUID-VkPresentRegionsKHR-sType-sType
            if (is_const_param) {
                VkPresentRegionsKHR *structure = (VkPresentRegionsKHR *) header;
                skip |= ValidateArray("VkPresentRegionsKHR", "swapchainCount", "pRegions", structure->swapchainCount, &structure->pRegions, true, false, "VUID-VkPresentRegionsKHR-swapchainCount-arraylength", "VUID-VkPresentRegionsKHR-pRegions-parameter");

                if (structure->pRegions != nullptr)
                {
                    for (uint32_t swapchainIndex = 0; swapchainIndex < structure->swapchainCount; ++swapchainIndex)
                    {
                        if (structure->pRegions[swapchainIndex].pRectangles != nullptr)
                        {
                            for (uint32_t rectangleIndex = 0; rectangleIndex < structure->pRegions[swapchainIndex].rectangleCount; ++rectangleIndex)
                            {
                            }
                        }
                    }
                }
            }
        } break;

        // No Validation code for VkSharedPresentSurfaceCapabilitiesKHR structure members  -- Covers VUID-VkSharedPresentSurfaceCapabilitiesKHR-sType-sType

        // No Validation code for VkExportFenceWin32HandleInfoKHR structure members  -- Covers VUID-VkExportFenceWin32HandleInfoKHR-sType-sType

        // Validation code for VkPhysicalDevicePerformanceQueryFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR: { // Covers VUID-VkPhysicalDevicePerformanceQueryFeaturesKHR-sType-sType
            if (is_const_param) {
                VkPhysicalDevicePerformanceQueryFeaturesKHR *structure = (VkPhysicalDevicePerformanceQueryFeaturesKHR *) header;
                skip |= ValidateBool32("VkPhysicalDevicePerformanceQueryFeaturesKHR", "performanceCounterQueryPools", structure->performanceCounterQueryPools);

                skip |= ValidateBool32("VkPhysicalDevicePerformanceQueryFeaturesKHR", "performanceCounterMultipleQueryPools", structure->performanceCounterMultipleQueryPools);
            }
        } break;

        // No Validation code for VkPhysicalDevicePerformanceQueryPropertiesKHR structure members  -- Covers VUID-VkPhysicalDevicePerformanceQueryPropertiesKHR-sType-sType

        // Validation code for VkQueryPoolPerformanceCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR: { // Covers VUID-VkQueryPoolPerformanceCreateInfoKHR-sType-sType
            if (is_const_param) {
                VkQueryPoolPerformanceCreateInfoKHR *structure = (VkQueryPoolPerformanceCreateInfoKHR *) header;
                skip |= ValidateArray("VkQueryPoolPerformanceCreateInfoKHR", "counterIndexCount", "pCounterIndices", structure->counterIndexCount, &structure->pCounterIndices, true, true, "VUID-VkQueryPoolPerformanceCreateInfoKHR-counterIndexCount-arraylength", "VUID-VkQueryPoolPerformanceCreateInfoKHR-pCounterIndices-parameter");
            }
        } break;

        // No Validation code for VkPerformanceQuerySubmitInfoKHR structure members  -- Covers VUID-VkPerformanceQuerySubmitInfoKHR-sType-sType

#ifdef VK_ENABLE_BETA_EXTENSIONS
        // Validation code for VkPhysicalDevicePortabilitySubsetFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR: { // Covers VUID-VkPhysicalDevicePortabilitySubsetFeaturesKHR-sType-sType
            if (is_const_param) {
                VkPhysicalDevicePortabilitySubsetFeaturesKHR *structure = (VkPhysicalDevicePortabilitySubsetFeaturesKHR *) header;
                skip |= ValidateBool32("VkPhysicalDevicePortabilitySubsetFeaturesKHR", "constantAlphaColorBlendFactors", structure->constantAlphaColorBlendFactors);

                skip |= ValidateBool32("VkPhysicalDevicePortabilitySubsetFeaturesKHR", "events", structure->events);

                skip |= ValidateBool32("VkPhysicalDevicePortabilitySubsetFeaturesKHR", "imageViewFormatReinterpretation", structure->imageViewFormatReinterpretation);

                skip |= ValidateBool32("VkPhysicalDevicePortabilitySubsetFeaturesKHR", "imageViewFormatSwizzle", structure->imageViewFormatSwizzle);

                skip |= ValidateBool32("VkPhysicalDevicePortabilitySubsetFeaturesKHR", "imageView2DOn3DImage", structure->imageView2DOn3DImage);

                skip |= ValidateBool32("VkPhysicalDevicePortabilitySubsetFeaturesKHR", "multisampleArrayImage", structure->multisampleArrayImage);

                skip |= ValidateBool32("VkPhysicalDevicePortabilitySubsetFeaturesKHR", "mutableComparisonSamplers", structure->mutableComparisonSamplers);

                skip |= ValidateBool32("VkPhysicalDevicePortabilitySubsetFeaturesKHR", "pointPolygons", structure->pointPolygons);

                skip |= ValidateBool32("VkPhysicalDevicePortabilitySubsetFeaturesKHR", "samplerMipLodBias", structure->samplerMipLodBias);

                skip |= ValidateBool32("VkPhysicalDevicePortabilitySubsetFeaturesKHR", "separateStencilMaskRef", structure->separateStencilMaskRef);

                skip |= ValidateBool32("VkPhysicalDevicePortabilitySubsetFeaturesKHR", "shaderSampleRateInterpolationFunctions", structure->shaderSampleRateInterpolationFunctions);

                skip |= ValidateBool32("VkPhysicalDevicePortabilitySubsetFeaturesKHR", "tessellationIsolines", structure->tessellationIsolines);

                skip |= ValidateBool32("VkPhysicalDevicePortabilitySubsetFeaturesKHR", "tessellationPointMode", structure->tessellationPointMode);

                skip |= ValidateBool32("VkPhysicalDevicePortabilitySubsetFeaturesKHR", "triangleFans", structure->triangleFans);

                skip |= ValidateBool32("VkPhysicalDevicePortabilitySubsetFeaturesKHR", "vertexAttributeAccessBeyondStride", structure->vertexAttributeAccessBeyondStride);
            }
        } break;
#endif // VK_ENABLE_BETA_EXTENSIONS

        // No Validation code for VkPhysicalDevicePortabilitySubsetPropertiesKHR structure members  -- Covers VUID-VkPhysicalDevicePortabilitySubsetPropertiesKHR-sType-sType

        // Validation code for VkPhysicalDeviceShaderClockFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR: { // Covers VUID-VkPhysicalDeviceShaderClockFeaturesKHR-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceShaderClockFeaturesKHR *structure = (VkPhysicalDeviceShaderClockFeaturesKHR *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShaderClockFeaturesKHR", "shaderSubgroupClock", structure->shaderSubgroupClock);

                skip |= ValidateBool32("VkPhysicalDeviceShaderClockFeaturesKHR", "shaderDeviceClock", structure->shaderDeviceClock);
            }
        } break;

        // No Validation code for VkVideoDecodeH265ProfileInfoKHR structure members  -- Covers VUID-VkVideoDecodeH265ProfileInfoKHR-sType-sType

        // No Validation code for VkVideoDecodeH265CapabilitiesKHR structure members  -- Covers VUID-VkVideoDecodeH265CapabilitiesKHR-sType-sType

        // Validation code for VkVideoDecodeH265SessionParametersAddInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR: { // Covers VUID-VkVideoDecodeH265SessionParametersAddInfoKHR-sType-sType
            if (is_const_param) {
                VkVideoDecodeH265SessionParametersAddInfoKHR *structure = (VkVideoDecodeH265SessionParametersAddInfoKHR *) header;
                skip |= ValidateArray("VkVideoDecodeH265SessionParametersAddInfoKHR", "stdVPSCount", "pStdVPSs", structure->stdVPSCount, &structure->pStdVPSs, false, true, kVUIDUndefined, "VUID-VkVideoDecodeH265SessionParametersAddInfoKHR-pStdVPSs-parameter");

                skip |= ValidateArray("VkVideoDecodeH265SessionParametersAddInfoKHR", "stdSPSCount", "pStdSPSs", structure->stdSPSCount, &structure->pStdSPSs, false, true, kVUIDUndefined, "VUID-VkVideoDecodeH265SessionParametersAddInfoKHR-pStdSPSs-parameter");

                skip |= ValidateArray("VkVideoDecodeH265SessionParametersAddInfoKHR", "stdPPSCount", "pStdPPSs", structure->stdPPSCount, &structure->pStdPPSs, false, true, kVUIDUndefined, "VUID-VkVideoDecodeH265SessionParametersAddInfoKHR-pStdPPSs-parameter");
            }
        } break;

        // Validation code for VkVideoDecodeH265SessionParametersCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR: { // Covers VUID-VkVideoDecodeH265SessionParametersCreateInfoKHR-sType-sType
            if (is_const_param) {
                VkVideoDecodeH265SessionParametersCreateInfoKHR *structure = (VkVideoDecodeH265SessionParametersCreateInfoKHR *) header;
                skip |= ValidateStructType("VkVideoDecodeH265SessionParametersCreateInfoKHR", "pParametersAddInfo", "VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR", structure->pParametersAddInfo, VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR, false, "VUID-VkVideoDecodeH265SessionParametersCreateInfoKHR-pParametersAddInfo-parameter", "VUID-VkVideoDecodeH265SessionParametersAddInfoKHR-sType-sType");

                if (structure->pParametersAddInfo != nullptr)
                {
                    skip |= ValidateArray("VkVideoDecodeH265SessionParametersCreateInfoKHR", "pParametersAddInfo->stdVPSCount", "pParametersAddInfo->pStdVPSs", structure->pParametersAddInfo->stdVPSCount, &structure->pParametersAddInfo->pStdVPSs, false, true, kVUIDUndefined, "VUID-VkVideoDecodeH265SessionParametersAddInfoKHR-pStdVPSs-parameter");

                    skip |= ValidateArray("VkVideoDecodeH265SessionParametersCreateInfoKHR", "pParametersAddInfo->stdSPSCount", "pParametersAddInfo->pStdSPSs", structure->pParametersAddInfo->stdSPSCount, &structure->pParametersAddInfo->pStdSPSs, false, true, kVUIDUndefined, "VUID-VkVideoDecodeH265SessionParametersAddInfoKHR-pStdSPSs-parameter");

                    skip |= ValidateArray("VkVideoDecodeH265SessionParametersCreateInfoKHR", "pParametersAddInfo->stdPPSCount", "pParametersAddInfo->pStdPPSs", structure->pParametersAddInfo->stdPPSCount, &structure->pParametersAddInfo->pStdPPSs, false, true, kVUIDUndefined, "VUID-VkVideoDecodeH265SessionParametersAddInfoKHR-pStdPPSs-parameter");
                }
            }
        } break;

        // Validation code for VkVideoDecodeH265PictureInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PICTURE_INFO_KHR: { // Covers VUID-VkVideoDecodeH265PictureInfoKHR-sType-sType
            if (is_const_param) {
                VkVideoDecodeH265PictureInfoKHR *structure = (VkVideoDecodeH265PictureInfoKHR *) header;
                skip |= ValidateRequiredPointer("VkVideoDecodeH265PictureInfoKHR", "pStdPictureInfo", structure->pStdPictureInfo, "VUID-VkVideoDecodeH265PictureInfoKHR-pStdPictureInfo-parameter");

                skip |= ValidateArray("VkVideoDecodeH265PictureInfoKHR", "sliceSegmentCount", "pSliceSegmentOffsets", structure->sliceSegmentCount, &structure->pSliceSegmentOffsets, true, true, "VUID-VkVideoDecodeH265PictureInfoKHR-sliceSegmentCount-arraylength", "VUID-VkVideoDecodeH265PictureInfoKHR-pSliceSegmentOffsets-parameter");
            }
        } break;

        // Validation code for VkVideoDecodeH265DpbSlotInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_DPB_SLOT_INFO_KHR: { // Covers VUID-VkVideoDecodeH265DpbSlotInfoKHR-sType-sType
            if (is_const_param) {
                VkVideoDecodeH265DpbSlotInfoKHR *structure = (VkVideoDecodeH265DpbSlotInfoKHR *) header;
                skip |= ValidateRequiredPointer("VkVideoDecodeH265DpbSlotInfoKHR", "pStdReferenceInfo", structure->pStdReferenceInfo, "VUID-VkVideoDecodeH265DpbSlotInfoKHR-pStdReferenceInfo-parameter");
            }
        } break;

        // Validation code for VkDeviceQueueGlobalPriorityCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_KHR: { // Covers VUID-VkDeviceQueueGlobalPriorityCreateInfoKHR-sType-sType
            if (is_const_param) {
                VkDeviceQueueGlobalPriorityCreateInfoKHR *structure = (VkDeviceQueueGlobalPriorityCreateInfoKHR *) header;
                skip |= ValidateRangedEnum("VkDeviceQueueGlobalPriorityCreateInfoKHR", "globalPriority", "VkQueueGlobalPriorityKHR", AllVkQueueGlobalPriorityKHREnums, structure->globalPriority, "VUID-VkDeviceQueueGlobalPriorityCreateInfoKHR-globalPriority-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_KHR: { // Covers VUID-VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR *structure = (VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR *) header;
                skip |= ValidateBool32("VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR", "globalPriorityQuery", structure->globalPriorityQuery);
            }
        } break;

        // No Validation code for VkQueueFamilyGlobalPriorityPropertiesKHR structure members  -- Covers VUID-VkQueueFamilyGlobalPriorityPropertiesKHR-sType-sType

        // Validation code for VkFragmentShadingRateAttachmentInfoKHR structure members
        case VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR: { // Covers VUID-VkFragmentShadingRateAttachmentInfoKHR-sType-sType
            if (is_const_param) {
                VkFragmentShadingRateAttachmentInfoKHR *structure = (VkFragmentShadingRateAttachmentInfoKHR *) header;
                skip |= ValidateStructType("VkFragmentShadingRateAttachmentInfoKHR", "pFragmentShadingRateAttachment", "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2", structure->pFragmentShadingRateAttachment, VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2, false, "VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-parameter", "VUID-VkAttachmentReference2-sType-sType");

                if (structure->pFragmentShadingRateAttachment != nullptr)
                {
                    skip |= ValidateRangedEnum("VkFragmentShadingRateAttachmentInfoKHR", "pFragmentShadingRateAttachment->layout", "VkImageLayout", AllVkImageLayoutEnums, structure->pFragmentShadingRateAttachment->layout, "VUID-VkAttachmentReference2-layout-parameter");
                }

            }
        } break;

        // No Validation code for VkPipelineFragmentShadingRateStateCreateInfoKHR structure members  -- Covers VUID-VkPipelineFragmentShadingRateStateCreateInfoKHR-sType-sType

        // Validation code for VkPhysicalDeviceFragmentShadingRateFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR: { // Covers VUID-VkPhysicalDeviceFragmentShadingRateFeaturesKHR-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceFragmentShadingRateFeaturesKHR *structure = (VkPhysicalDeviceFragmentShadingRateFeaturesKHR *) header;
                skip |= ValidateBool32("VkPhysicalDeviceFragmentShadingRateFeaturesKHR", "pipelineFragmentShadingRate", structure->pipelineFragmentShadingRate);

                skip |= ValidateBool32("VkPhysicalDeviceFragmentShadingRateFeaturesKHR", "primitiveFragmentShadingRate", structure->primitiveFragmentShadingRate);

                skip |= ValidateBool32("VkPhysicalDeviceFragmentShadingRateFeaturesKHR", "attachmentFragmentShadingRate", structure->attachmentFragmentShadingRate);
            }
        } break;

        // No Validation code for VkPhysicalDeviceFragmentShadingRatePropertiesKHR structure members  -- Covers VUID-VkPhysicalDeviceFragmentShadingRatePropertiesKHR-sType-sType

        // Validation code for VkSurfaceProtectedCapabilitiesKHR structure members
        case VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR: { // Covers VUID-VkSurfaceProtectedCapabilitiesKHR-sType-sType
            if (is_const_param) {
                VkSurfaceProtectedCapabilitiesKHR *structure = (VkSurfaceProtectedCapabilitiesKHR *) header;
                skip |= ValidateBool32("VkSurfaceProtectedCapabilitiesKHR", "supportsProtected", structure->supportsProtected);
            }
        } break;

        // Validation code for VkPhysicalDevicePresentWaitFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR: { // Covers VUID-VkPhysicalDevicePresentWaitFeaturesKHR-sType-sType
            if (is_const_param) {
                VkPhysicalDevicePresentWaitFeaturesKHR *structure = (VkPhysicalDevicePresentWaitFeaturesKHR *) header;
                skip |= ValidateBool32("VkPhysicalDevicePresentWaitFeaturesKHR", "presentWait", structure->presentWait);
            }
        } break;

        // Validation code for VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR: { // Covers VUID-VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR-sType-sType
            if (is_const_param) {
                VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR *structure = (VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR *) header;
                skip |= ValidateBool32("VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR", "pipelineExecutableInfo", structure->pipelineExecutableInfo);
            }
        } break;

        // Validation code for VkPipelineLibraryCreateInfoKHR structure members
        case VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR: { // Covers VUID-VkPipelineLibraryCreateInfoKHR-sType-sType
            if (is_const_param) {
                VkPipelineLibraryCreateInfoKHR *structure = (VkPipelineLibraryCreateInfoKHR *) header;
                skip |= ValidateArray("VkPipelineLibraryCreateInfoKHR", "libraryCount", "pLibraries", structure->libraryCount, &structure->pLibraries, false, true, kVUIDUndefined, "VUID-VkPipelineLibraryCreateInfoKHR-pLibraries-parameter");
            }
        } break;

        // Validation code for VkPresentIdKHR structure members
        case VK_STRUCTURE_TYPE_PRESENT_ID_KHR: { // Covers VUID-VkPresentIdKHR-sType-sType
            if (is_const_param) {
                VkPresentIdKHR *structure = (VkPresentIdKHR *) header;
                skip |= ValidateArray("VkPresentIdKHR", "swapchainCount", "pPresentIds", structure->swapchainCount, &structure->pPresentIds, true, false, "VUID-VkPresentIdKHR-swapchainCount-arraylength", "VUID-VkPresentIdKHR-pPresentIds-parameter");
            }
        } break;

        // Validation code for VkPhysicalDevicePresentIdFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR: { // Covers VUID-VkPhysicalDevicePresentIdFeaturesKHR-sType-sType
            if (is_const_param) {
                VkPhysicalDevicePresentIdFeaturesKHR *structure = (VkPhysicalDevicePresentIdFeaturesKHR *) header;
                skip |= ValidateBool32("VkPhysicalDevicePresentIdFeaturesKHR", "presentId", structure->presentId);
            }
        } break;

        // No Validation code for VkVideoEncodeCapabilitiesKHR structure members  -- Covers VUID-VkVideoEncodeCapabilitiesKHR-sType-sType

#ifdef VK_ENABLE_BETA_EXTENSIONS
        // Validation code for VkVideoEncodeUsageInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_USAGE_INFO_KHR: { // Covers VUID-VkVideoEncodeUsageInfoKHR-sType-sType
            if (is_const_param) {
                VkVideoEncodeUsageInfoKHR *structure = (VkVideoEncodeUsageInfoKHR *) header;
                skip |= ValidateFlags("VkVideoEncodeUsageInfoKHR", "videoUsageHints", "VkVideoEncodeUsageFlagBitsKHR", AllVkVideoEncodeUsageFlagBitsKHR, structure->videoUsageHints, kOptionalFlags, "VUID-VkVideoEncodeUsageInfoKHR-videoUsageHints-parameter");

                skip |= ValidateFlags("VkVideoEncodeUsageInfoKHR", "videoContentHints", "VkVideoEncodeContentFlagBitsKHR", AllVkVideoEncodeContentFlagBitsKHR, structure->videoContentHints, kOptionalFlags, "VUID-VkVideoEncodeUsageInfoKHR-videoContentHints-parameter");

                skip |= ValidateRangedEnum("VkVideoEncodeUsageInfoKHR", "tuningMode", "VkVideoEncodeTuningModeKHR", AllVkVideoEncodeTuningModeKHREnums, structure->tuningMode, "VUID-VkVideoEncodeUsageInfoKHR-tuningMode-parameter");
            }
        } break;
#endif // VK_ENABLE_BETA_EXTENSIONS

        // No Validation code for VkVideoEncodeRateControlLayerInfoKHR structure members  -- Covers VUID-VkVideoEncodeRateControlLayerInfoKHR-sType-sType

#ifdef VK_ENABLE_BETA_EXTENSIONS
        // Validation code for VkVideoEncodeRateControlInfoKHR structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_INFO_KHR: { // Covers VUID-VkVideoEncodeRateControlInfoKHR-sType-sType
            if (is_const_param) {
                VkVideoEncodeRateControlInfoKHR *structure = (VkVideoEncodeRateControlInfoKHR *) header;
                skip |= ValidateReservedFlags("VkVideoEncodeRateControlInfoKHR", "flags", structure->flags, "VUID-VkVideoEncodeRateControlInfoKHR-flags-zerobitmask");

                skip |= ValidateFlags("VkVideoEncodeRateControlInfoKHR", "rateControlMode", "VkVideoEncodeRateControlModeFlagBitsKHR", AllVkVideoEncodeRateControlModeFlagBitsKHR, structure->rateControlMode, kRequiredSingleBit, "VUID-VkVideoEncodeRateControlInfoKHR-rateControlMode-parameter", "VUID-VkVideoEncodeRateControlInfoKHR-rateControlMode-parameter");

                skip |= ValidateStructTypeArray("VkVideoEncodeRateControlInfoKHR", "layerCount", "pLayerConfigs", "VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_LAYER_INFO_KHR", structure->layerCount, structure->pLayerConfigs, VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_LAYER_INFO_KHR, true, true, "VUID-VkVideoEncodeRateControlLayerInfoKHR-sType-sType", "VUID-VkVideoEncodeRateControlInfoKHR-pLayerConfigs-parameter", "VUID-VkVideoEncodeRateControlInfoKHR-layerCount-arraylength");

                if (structure->pLayerConfigs != nullptr)
                {
                    for (uint32_t layerIndex = 0; layerIndex < structure->layerCount; ++layerIndex)
                    {
                    }
                }
            }
        } break;
#endif // VK_ENABLE_BETA_EXTENSIONS

        // No Validation code for VkQueueFamilyCheckpointProperties2NV structure members  -- Covers VUID-VkQueueFamilyCheckpointProperties2NV-sType-sType

        // Validation code for VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR: { // Covers VUID-VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *structure = (VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *) header;
                skip |= ValidateBool32("VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR", "fragmentShaderBarycentric", structure->fragmentShaderBarycentric);
            }
        } break;

        // No Validation code for VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR structure members  -- Covers VUID-VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR-sType-sType

        // Validation code for VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR: { // Covers VUID-VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *structure = (VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR", "shaderSubgroupUniformControlFlow", structure->shaderSubgroupUniformControlFlow);
            }
        } break;

        // Validation code for VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR: { // Covers VUID-VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *structure = (VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *) header;
                skip |= ValidateBool32("VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR", "workgroupMemoryExplicitLayout", structure->workgroupMemoryExplicitLayout);

                skip |= ValidateBool32("VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR", "workgroupMemoryExplicitLayoutScalarBlockLayout", structure->workgroupMemoryExplicitLayoutScalarBlockLayout);

                skip |= ValidateBool32("VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR", "workgroupMemoryExplicitLayout8BitAccess", structure->workgroupMemoryExplicitLayout8BitAccess);

                skip |= ValidateBool32("VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR", "workgroupMemoryExplicitLayout16BitAccess", structure->workgroupMemoryExplicitLayout16BitAccess);
            }
        } break;

        // Validation code for VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR: { // Covers VUID-VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *structure = (VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *) header;
                skip |= ValidateBool32("VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR", "rayTracingMaintenance1", structure->rayTracingMaintenance1);

                skip |= ValidateBool32("VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR", "rayTracingPipelineTraceRaysIndirect2", structure->rayTracingPipelineTraceRaysIndirect2);
            }
        } break;

        // Validation code for VkDebugReportCallbackCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT: { // Covers VUID-VkDebugReportCallbackCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkDebugReportCallbackCreateInfoEXT *structure = (VkDebugReportCallbackCreateInfoEXT *) header;
                skip |= ValidateFlags("VkDebugReportCallbackCreateInfoEXT", "flags", "VkDebugReportFlagBitsEXT", AllVkDebugReportFlagBitsEXT, structure->flags, kOptionalFlags, "VUID-VkDebugReportCallbackCreateInfoEXT-flags-parameter");

                skip |= ValidateRequiredPointer("VkDebugReportCallbackCreateInfoEXT", "pfnCallback", reinterpret_cast<const void*>(structure->pfnCallback), "VUID-VkDebugReportCallbackCreateInfoEXT-pfnCallback-parameter");
            }
        } break;

        // Validation code for VkPipelineRasterizationStateRasterizationOrderAMD structure members
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD: { // Covers VUID-VkPipelineRasterizationStateRasterizationOrderAMD-sType-sType
            if (is_const_param) {
                VkPipelineRasterizationStateRasterizationOrderAMD *structure = (VkPipelineRasterizationStateRasterizationOrderAMD *) header;
                skip |= ValidateRangedEnum("VkPipelineRasterizationStateRasterizationOrderAMD", "rasterizationOrder", "VkRasterizationOrderAMD", AllVkRasterizationOrderAMDEnums, structure->rasterizationOrder, "VUID-VkPipelineRasterizationStateRasterizationOrderAMD-rasterizationOrder-parameter");
            }
        } break;

        // Validation code for VkDedicatedAllocationImageCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV: { // Covers VUID-VkDedicatedAllocationImageCreateInfoNV-sType-sType
            if (is_const_param) {
                VkDedicatedAllocationImageCreateInfoNV *structure = (VkDedicatedAllocationImageCreateInfoNV *) header;
                skip |= ValidateBool32("VkDedicatedAllocationImageCreateInfoNV", "dedicatedAllocation", structure->dedicatedAllocation);
            }
        } break;

        // Validation code for VkDedicatedAllocationBufferCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV: { // Covers VUID-VkDedicatedAllocationBufferCreateInfoNV-sType-sType
            if (is_const_param) {
                VkDedicatedAllocationBufferCreateInfoNV *structure = (VkDedicatedAllocationBufferCreateInfoNV *) header;
                skip |= ValidateBool32("VkDedicatedAllocationBufferCreateInfoNV", "dedicatedAllocation", structure->dedicatedAllocation);
            }
        } break;

        // No Validation code for VkDedicatedAllocationMemoryAllocateInfoNV structure members  -- Covers VUID-VkDedicatedAllocationMemoryAllocateInfoNV-sType-sType

        // Validation code for VkPhysicalDeviceTransformFeedbackFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceTransformFeedbackFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceTransformFeedbackFeaturesEXT *structure = (VkPhysicalDeviceTransformFeedbackFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceTransformFeedbackFeaturesEXT", "transformFeedback", structure->transformFeedback);

                skip |= ValidateBool32("VkPhysicalDeviceTransformFeedbackFeaturesEXT", "geometryStreams", structure->geometryStreams);
            }
        } break;

        // No Validation code for VkPhysicalDeviceTransformFeedbackPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceTransformFeedbackPropertiesEXT-sType-sType

        // Validation code for VkPipelineRasterizationStateStreamCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT: { // Covers VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkPipelineRasterizationStateStreamCreateInfoEXT *structure = (VkPipelineRasterizationStateStreamCreateInfoEXT *) header;
                skip |= ValidateReservedFlags("VkPipelineRasterizationStateStreamCreateInfoEXT", "flags", structure->flags, "VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-flags-zerobitmask");
            }
        } break;

        // No Validation code for VkVideoEncodeH264CapabilitiesEXT structure members  -- Covers VUID-VkVideoEncodeH264CapabilitiesEXT-sType-sType

#ifdef VK_ENABLE_BETA_EXTENSIONS
        // Validation code for VkVideoEncodeH264SessionParametersAddInfoEXT structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_EXT: { // Covers VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-sType-sType
            if (is_const_param) {
                VkVideoEncodeH264SessionParametersAddInfoEXT *structure = (VkVideoEncodeH264SessionParametersAddInfoEXT *) header;
                skip |= ValidateArray("VkVideoEncodeH264SessionParametersAddInfoEXT", "stdSPSCount", "pStdSPSs", structure->stdSPSCount, &structure->pStdSPSs, true, false, "VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-stdSPSCount-arraylength", "VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-pStdSPSs-parameter");

                skip |= ValidateArray("VkVideoEncodeH264SessionParametersAddInfoEXT", "stdPPSCount", "pStdPPSs", structure->stdPPSCount, &structure->pStdPPSs, true, false, "VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-stdPPSCount-arraylength", "VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-pStdPPSs-parameter");
            }
        } break;
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
        // Validation code for VkVideoEncodeH264SessionParametersCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_CREATE_INFO_EXT: { // Covers VUID-VkVideoEncodeH264SessionParametersCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkVideoEncodeH264SessionParametersCreateInfoEXT *structure = (VkVideoEncodeH264SessionParametersCreateInfoEXT *) header;
                skip |= ValidateStructType("VkVideoEncodeH264SessionParametersCreateInfoEXT", "pParametersAddInfo", "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_EXT", structure->pParametersAddInfo, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_EXT, false, "VUID-VkVideoEncodeH264SessionParametersCreateInfoEXT-pParametersAddInfo-parameter", "VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-sType-sType");

                if (structure->pParametersAddInfo != nullptr)
                {
                    skip |= ValidateArray("VkVideoEncodeH264SessionParametersCreateInfoEXT", "pParametersAddInfo->stdSPSCount", "pParametersAddInfo->pStdSPSs", structure->pParametersAddInfo->stdSPSCount, &structure->pParametersAddInfo->pStdSPSs, true, false, "VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-stdSPSCount-arraylength", "VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-pStdSPSs-parameter");

                    skip |= ValidateArray("VkVideoEncodeH264SessionParametersCreateInfoEXT", "pParametersAddInfo->stdPPSCount", "pParametersAddInfo->pStdPPSs", structure->pParametersAddInfo->stdPPSCount, &structure->pParametersAddInfo->pStdPPSs, true, false, "VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-stdPPSCount-arraylength", "VUID-VkVideoEncodeH264SessionParametersAddInfoEXT-pStdPPSs-parameter");
                }
            }
        } break;
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
        // Validation code for VkVideoEncodeH264VclFrameInfoEXT structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_VCL_FRAME_INFO_EXT: { // Covers VUID-VkVideoEncodeH264VclFrameInfoEXT-sType-sType
            if (is_const_param) {
                VkVideoEncodeH264VclFrameInfoEXT *structure = (VkVideoEncodeH264VclFrameInfoEXT *) header;
                skip |= ValidateStructType("VkVideoEncodeH264VclFrameInfoEXT", "pReferenceFinalLists", "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_REFERENCE_LISTS_INFO_EXT", structure->pReferenceFinalLists, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_REFERENCE_LISTS_INFO_EXT, false, "VUID-VkVideoEncodeH264VclFrameInfoEXT-pReferenceFinalLists-parameter", "VUID-VkVideoEncodeH264ReferenceListsInfoEXT-sType-sType");

                if (structure->pReferenceFinalLists != nullptr)
                {
                    skip |= ValidateStructTypeArray("VkVideoEncodeH264VclFrameInfoEXT", "pReferenceFinalLists->referenceList0EntryCount", "pReferenceFinalLists->pReferenceList0Entries", "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_EXT", structure->pReferenceFinalLists->referenceList0EntryCount, structure->pReferenceFinalLists->pReferenceList0Entries, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_EXT, false, true, "VUID-VkVideoEncodeH264DpbSlotInfoEXT-sType-sType", "VUID-VkVideoEncodeH264ReferenceListsInfoEXT-pReferenceList0Entries-parameter", kVUIDUndefined);

                    if (structure->pReferenceFinalLists->pReferenceList0Entries != nullptr)
                    {
                        for (uint32_t referenceList0EntryIndex = 0; referenceList0EntryIndex < structure->pReferenceFinalLists->referenceList0EntryCount; ++referenceList0EntryIndex)
                        {
                            skip |= ValidateRequiredPointer("VkVideoEncodeH264VclFrameInfoEXT", ParameterName("pReferenceFinalLists->pReferenceList0Entries[%i].pStdReferenceInfo", ParameterName::IndexVector{ referenceList0EntryIndex }), structure->pReferenceFinalLists->pReferenceList0Entries[referenceList0EntryIndex].pStdReferenceInfo, "VUID-VkVideoEncodeH264DpbSlotInfoEXT-pStdReferenceInfo-parameter");
                        }
                    }

                    skip |= ValidateStructTypeArray("VkVideoEncodeH264VclFrameInfoEXT", "pReferenceFinalLists->referenceList1EntryCount", "pReferenceFinalLists->pReferenceList1Entries", "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_EXT", structure->pReferenceFinalLists->referenceList1EntryCount, structure->pReferenceFinalLists->pReferenceList1Entries, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_EXT, false, true, "VUID-VkVideoEncodeH264DpbSlotInfoEXT-sType-sType", "VUID-VkVideoEncodeH264ReferenceListsInfoEXT-pReferenceList1Entries-parameter", kVUIDUndefined);

                    if (structure->pReferenceFinalLists->pReferenceList1Entries != nullptr)
                    {
                        for (uint32_t referenceList1EntryIndex = 0; referenceList1EntryIndex < structure->pReferenceFinalLists->referenceList1EntryCount; ++referenceList1EntryIndex)
                        {
                            skip |= ValidateRequiredPointer("VkVideoEncodeH264VclFrameInfoEXT", ParameterName("pReferenceFinalLists->pReferenceList1Entries[%i].pStdReferenceInfo", ParameterName::IndexVector{ referenceList1EntryIndex }), structure->pReferenceFinalLists->pReferenceList1Entries[referenceList1EntryIndex].pStdReferenceInfo, "VUID-VkVideoEncodeH264DpbSlotInfoEXT-pStdReferenceInfo-parameter");
                        }
                    }

                    skip |= ValidateRequiredPointer("VkVideoEncodeH264VclFrameInfoEXT", "pReferenceFinalLists->pMemMgmtCtrlOperations", structure->pReferenceFinalLists->pMemMgmtCtrlOperations, "VUID-VkVideoEncodeH264ReferenceListsInfoEXT-pMemMgmtCtrlOperations-parameter");
                }

                skip |= ValidateStructTypeArray("VkVideoEncodeH264VclFrameInfoEXT", "naluSliceEntryCount", "pNaluSliceEntries", "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_NALU_SLICE_INFO_EXT", structure->naluSliceEntryCount, structure->pNaluSliceEntries, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_NALU_SLICE_INFO_EXT, true, true, "VUID-VkVideoEncodeH264NaluSliceInfoEXT-sType-sType", "VUID-VkVideoEncodeH264VclFrameInfoEXT-pNaluSliceEntries-parameter", "VUID-VkVideoEncodeH264VclFrameInfoEXT-naluSliceEntryCount-arraylength");

                if (structure->pNaluSliceEntries != nullptr)
                {
                    for (uint32_t naluSliceEntryIndex = 0; naluSliceEntryIndex < structure->naluSliceEntryCount; ++naluSliceEntryIndex)
                    {
                        skip |= ValidateStructType("VkVideoEncodeH264VclFrameInfoEXT", ParameterName("pNaluSliceEntries[%i].pReferenceFinalLists", ParameterName::IndexVector{ naluSliceEntryIndex }), "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_REFERENCE_LISTS_INFO_EXT", structure->pNaluSliceEntries[naluSliceEntryIndex].pReferenceFinalLists, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_REFERENCE_LISTS_INFO_EXT, false, "VUID-VkVideoEncodeH264NaluSliceInfoEXT-pReferenceFinalLists-parameter", "VUID-VkVideoEncodeH264ReferenceListsInfoEXT-sType-sType");

                        if (structure->pNaluSliceEntries[naluSliceEntryIndex].pReferenceFinalLists != nullptr)
                        {
                            skip |= ValidateStructTypeArray("VkVideoEncodeH264VclFrameInfoEXT", ParameterName("pNaluSliceEntries[%i].pReferenceFinalLists->referenceList0EntryCount", ParameterName::IndexVector{ naluSliceEntryIndex }), ParameterName("pNaluSliceEntries[%i].pReferenceFinalLists->pReferenceList0Entries", ParameterName::IndexVector{ naluSliceEntryIndex }), "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_EXT", structure->pNaluSliceEntries[naluSliceEntryIndex].pReferenceFinalLists->referenceList0EntryCount, structure->pNaluSliceEntries[naluSliceEntryIndex].pReferenceFinalLists->pReferenceList0Entries, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_EXT, false, true, "VUID-VkVideoEncodeH264DpbSlotInfoEXT-sType-sType", "VUID-VkVideoEncodeH264ReferenceListsInfoEXT-pReferenceList0Entries-parameter", kVUIDUndefined);

                            if (structure->pNaluSliceEntries[naluSliceEntryIndex].pReferenceFinalLists->pReferenceList0Entries != nullptr)
                            {
                                for (uint32_t referenceList0EntryIndex = 0; referenceList0EntryIndex < structure->pNaluSliceEntries[naluSliceEntryIndex].pReferenceFinalLists->referenceList0EntryCount; ++referenceList0EntryIndex)
                                {
                                    skip |= ValidateRequiredPointer("VkVideoEncodeH264VclFrameInfoEXT", ParameterName("pNaluSliceEntries[%i].pReferenceFinalLists->pReferenceList0Entries[%i].pStdReferenceInfo", ParameterName::IndexVector{ naluSliceEntryIndex, referenceList0EntryIndex }), structure->pNaluSliceEntries[naluSliceEntryIndex].pReferenceFinalLists->pReferenceList0Entries[referenceList0EntryIndex].pStdReferenceInfo, "VUID-VkVideoEncodeH264DpbSlotInfoEXT-pStdReferenceInfo-parameter");
                                }
                            }

                            skip |= ValidateStructTypeArray("VkVideoEncodeH264VclFrameInfoEXT", ParameterName("pNaluSliceEntries[%i].pReferenceFinalLists->referenceList1EntryCount", ParameterName::IndexVector{ naluSliceEntryIndex }), ParameterName("pNaluSliceEntries[%i].pReferenceFinalLists->pReferenceList1Entries", ParameterName::IndexVector{ naluSliceEntryIndex }), "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_EXT", structure->pNaluSliceEntries[naluSliceEntryIndex].pReferenceFinalLists->referenceList1EntryCount, structure->pNaluSliceEntries[naluSliceEntryIndex].pReferenceFinalLists->pReferenceList1Entries, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_EXT, false, true, "VUID-VkVideoEncodeH264DpbSlotInfoEXT-sType-sType", "VUID-VkVideoEncodeH264ReferenceListsInfoEXT-pReferenceList1Entries-parameter", kVUIDUndefined);

                            if (structure->pNaluSliceEntries[naluSliceEntryIndex].pReferenceFinalLists->pReferenceList1Entries != nullptr)
                            {
                                for (uint32_t referenceList1EntryIndex = 0; referenceList1EntryIndex < structure->pNaluSliceEntries[naluSliceEntryIndex].pReferenceFinalLists->referenceList1EntryCount; ++referenceList1EntryIndex)
                                {
                                    skip |= ValidateRequiredPointer("VkVideoEncodeH264VclFrameInfoEXT", ParameterName("pNaluSliceEntries[%i].pReferenceFinalLists->pReferenceList1Entries[%i].pStdReferenceInfo", ParameterName::IndexVector{ naluSliceEntryIndex, referenceList1EntryIndex }), structure->pNaluSliceEntries[naluSliceEntryIndex].pReferenceFinalLists->pReferenceList1Entries[referenceList1EntryIndex].pStdReferenceInfo, "VUID-VkVideoEncodeH264DpbSlotInfoEXT-pStdReferenceInfo-parameter");
                                }
                            }

                            skip |= ValidateRequiredPointer("VkVideoEncodeH264VclFrameInfoEXT", ParameterName("pNaluSliceEntries[%i].pReferenceFinalLists->pMemMgmtCtrlOperations", ParameterName::IndexVector{ naluSliceEntryIndex }), structure->pNaluSliceEntries[naluSliceEntryIndex].pReferenceFinalLists->pMemMgmtCtrlOperations, "VUID-VkVideoEncodeH264ReferenceListsInfoEXT-pMemMgmtCtrlOperations-parameter");
                        }

                        skip |= ValidateRequiredPointer("VkVideoEncodeH264VclFrameInfoEXT", ParameterName("pNaluSliceEntries[%i].pSliceHeaderStd", ParameterName::IndexVector{ naluSliceEntryIndex }), structure->pNaluSliceEntries[naluSliceEntryIndex].pSliceHeaderStd, "VUID-VkVideoEncodeH264NaluSliceInfoEXT-pSliceHeaderStd-parameter");
                    }
                }

                skip |= ValidateRequiredPointer("VkVideoEncodeH264VclFrameInfoEXT", "pCurrentPictureInfo", structure->pCurrentPictureInfo, "VUID-VkVideoEncodeH264VclFrameInfoEXT-pCurrentPictureInfo-parameter");
            }
        } break;
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
        // Validation code for VkVideoEncodeH264EmitPictureParametersInfoEXT structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_EMIT_PICTURE_PARAMETERS_INFO_EXT: { // Covers VUID-VkVideoEncodeH264EmitPictureParametersInfoEXT-sType-sType
            if (is_const_param) {
                VkVideoEncodeH264EmitPictureParametersInfoEXT *structure = (VkVideoEncodeH264EmitPictureParametersInfoEXT *) header;
                skip |= ValidateBool32("VkVideoEncodeH264EmitPictureParametersInfoEXT", "emitSpsEnable", structure->emitSpsEnable);

                skip |= ValidateArray("VkVideoEncodeH264EmitPictureParametersInfoEXT", "ppsIdEntryCount", "ppsIdEntries", structure->ppsIdEntryCount, &structure->ppsIdEntries, true, true, "VUID-VkVideoEncodeH264EmitPictureParametersInfoEXT-ppsIdEntryCount-arraylength", "VUID-VkVideoEncodeH264EmitPictureParametersInfoEXT-ppsIdEntries-parameter");
            }
        } break;
#endif // VK_ENABLE_BETA_EXTENSIONS

        // No Validation code for VkVideoEncodeH264ProfileInfoEXT structure members  -- Covers VUID-VkVideoEncodeH264ProfileInfoEXT-sType-sType

#ifdef VK_ENABLE_BETA_EXTENSIONS
        // Validation code for VkVideoEncodeH264RateControlInfoEXT structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_INFO_EXT: { // Covers VUID-VkVideoEncodeH264RateControlInfoEXT-sType-sType
            if (is_const_param) {
                VkVideoEncodeH264RateControlInfoEXT *structure = (VkVideoEncodeH264RateControlInfoEXT *) header;
                skip |= ValidateRangedEnum("VkVideoEncodeH264RateControlInfoEXT", "rateControlStructure", "VkVideoEncodeH264RateControlStructureEXT", AllVkVideoEncodeH264RateControlStructureEXTEnums, structure->rateControlStructure, "VUID-VkVideoEncodeH264RateControlInfoEXT-rateControlStructure-parameter");
            }
        } break;
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
        // Validation code for VkVideoEncodeH264RateControlLayerInfoEXT structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_LAYER_INFO_EXT: { // Covers VUID-VkVideoEncodeH264RateControlLayerInfoEXT-sType-sType
            if (is_const_param) {
                VkVideoEncodeH264RateControlLayerInfoEXT *structure = (VkVideoEncodeH264RateControlLayerInfoEXT *) header;
                skip |= ValidateBool32("VkVideoEncodeH264RateControlLayerInfoEXT", "useInitialRcQp", structure->useInitialRcQp);

                skip |= ValidateBool32("VkVideoEncodeH264RateControlLayerInfoEXT", "useMinQp", structure->useMinQp);

                skip |= ValidateBool32("VkVideoEncodeH264RateControlLayerInfoEXT", "useMaxQp", structure->useMaxQp);

                skip |= ValidateBool32("VkVideoEncodeH264RateControlLayerInfoEXT", "useMaxFrameSize", structure->useMaxFrameSize);

            }
        } break;
#endif // VK_ENABLE_BETA_EXTENSIONS

        // No Validation code for VkVideoEncodeH265CapabilitiesEXT structure members  -- Covers VUID-VkVideoEncodeH265CapabilitiesEXT-sType-sType

#ifdef VK_ENABLE_BETA_EXTENSIONS
        // Validation code for VkVideoEncodeH265SessionParametersAddInfoEXT structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_ADD_INFO_EXT: { // Covers VUID-VkVideoEncodeH265SessionParametersAddInfoEXT-sType-sType
            if (is_const_param) {
                VkVideoEncodeH265SessionParametersAddInfoEXT *structure = (VkVideoEncodeH265SessionParametersAddInfoEXT *) header;
                skip |= ValidateArray("VkVideoEncodeH265SessionParametersAddInfoEXT", "stdVPSCount", "pStdVPSs", structure->stdVPSCount, &structure->pStdVPSs, true, false, "VUID-VkVideoEncodeH265SessionParametersAddInfoEXT-stdVPSCount-arraylength", "VUID-VkVideoEncodeH265SessionParametersAddInfoEXT-pStdVPSs-parameter");

                skip |= ValidateArray("VkVideoEncodeH265SessionParametersAddInfoEXT", "stdSPSCount", "pStdSPSs", structure->stdSPSCount, &structure->pStdSPSs, true, false, "VUID-VkVideoEncodeH265SessionParametersAddInfoEXT-stdSPSCount-arraylength", "VUID-VkVideoEncodeH265SessionParametersAddInfoEXT-pStdSPSs-parameter");

                skip |= ValidateArray("VkVideoEncodeH265SessionParametersAddInfoEXT", "stdPPSCount", "pStdPPSs", structure->stdPPSCount, &structure->pStdPPSs, true, false, "VUID-VkVideoEncodeH265SessionParametersAddInfoEXT-stdPPSCount-arraylength", "VUID-VkVideoEncodeH265SessionParametersAddInfoEXT-pStdPPSs-parameter");
            }
        } break;
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
        // Validation code for VkVideoEncodeH265SessionParametersCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_CREATE_INFO_EXT: { // Covers VUID-VkVideoEncodeH265SessionParametersCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkVideoEncodeH265SessionParametersCreateInfoEXT *structure = (VkVideoEncodeH265SessionParametersCreateInfoEXT *) header;
                skip |= ValidateStructType("VkVideoEncodeH265SessionParametersCreateInfoEXT", "pParametersAddInfo", "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_ADD_INFO_EXT", structure->pParametersAddInfo, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_ADD_INFO_EXT, false, "VUID-VkVideoEncodeH265SessionParametersCreateInfoEXT-pParametersAddInfo-parameter", "VUID-VkVideoEncodeH265SessionParametersAddInfoEXT-sType-sType");

                if (structure->pParametersAddInfo != nullptr)
                {
                    skip |= ValidateArray("VkVideoEncodeH265SessionParametersCreateInfoEXT", "pParametersAddInfo->stdVPSCount", "pParametersAddInfo->pStdVPSs", structure->pParametersAddInfo->stdVPSCount, &structure->pParametersAddInfo->pStdVPSs, true, false, "VUID-VkVideoEncodeH265SessionParametersAddInfoEXT-stdVPSCount-arraylength", "VUID-VkVideoEncodeH265SessionParametersAddInfoEXT-pStdVPSs-parameter");

                    skip |= ValidateArray("VkVideoEncodeH265SessionParametersCreateInfoEXT", "pParametersAddInfo->stdSPSCount", "pParametersAddInfo->pStdSPSs", structure->pParametersAddInfo->stdSPSCount, &structure->pParametersAddInfo->pStdSPSs, true, false, "VUID-VkVideoEncodeH265SessionParametersAddInfoEXT-stdSPSCount-arraylength", "VUID-VkVideoEncodeH265SessionParametersAddInfoEXT-pStdSPSs-parameter");

                    skip |= ValidateArray("VkVideoEncodeH265SessionParametersCreateInfoEXT", "pParametersAddInfo->stdPPSCount", "pParametersAddInfo->pStdPPSs", structure->pParametersAddInfo->stdPPSCount, &structure->pParametersAddInfo->pStdPPSs, true, false, "VUID-VkVideoEncodeH265SessionParametersAddInfoEXT-stdPPSCount-arraylength", "VUID-VkVideoEncodeH265SessionParametersAddInfoEXT-pStdPPSs-parameter");
                }
            }
        } break;
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
        // Validation code for VkVideoEncodeH265VclFrameInfoEXT structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_VCL_FRAME_INFO_EXT: { // Covers VUID-VkVideoEncodeH265VclFrameInfoEXT-sType-sType
            if (is_const_param) {
                VkVideoEncodeH265VclFrameInfoEXT *structure = (VkVideoEncodeH265VclFrameInfoEXT *) header;
                skip |= ValidateStructType("VkVideoEncodeH265VclFrameInfoEXT", "pReferenceFinalLists", "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_REFERENCE_LISTS_INFO_EXT", structure->pReferenceFinalLists, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_REFERENCE_LISTS_INFO_EXT, false, "VUID-VkVideoEncodeH265VclFrameInfoEXT-pReferenceFinalLists-parameter", "VUID-VkVideoEncodeH265ReferenceListsInfoEXT-sType-sType");

                if (structure->pReferenceFinalLists != nullptr)
                {
                    skip |= ValidateStructTypeArray("VkVideoEncodeH265VclFrameInfoEXT", "pReferenceFinalLists->referenceList0EntryCount", "pReferenceFinalLists->pReferenceList0Entries", "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_EXT", structure->pReferenceFinalLists->referenceList0EntryCount, structure->pReferenceFinalLists->pReferenceList0Entries, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_EXT, false, true, "VUID-VkVideoEncodeH265DpbSlotInfoEXT-sType-sType", "VUID-VkVideoEncodeH265ReferenceListsInfoEXT-pReferenceList0Entries-parameter", kVUIDUndefined);

                    if (structure->pReferenceFinalLists->pReferenceList0Entries != nullptr)
                    {
                        for (uint32_t referenceList0EntryIndex = 0; referenceList0EntryIndex < structure->pReferenceFinalLists->referenceList0EntryCount; ++referenceList0EntryIndex)
                        {
                            skip |= ValidateRequiredPointer("VkVideoEncodeH265VclFrameInfoEXT", ParameterName("pReferenceFinalLists->pReferenceList0Entries[%i].pStdReferenceInfo", ParameterName::IndexVector{ referenceList0EntryIndex }), structure->pReferenceFinalLists->pReferenceList0Entries[referenceList0EntryIndex].pStdReferenceInfo, "VUID-VkVideoEncodeH265DpbSlotInfoEXT-pStdReferenceInfo-parameter");
                        }
                    }

                    skip |= ValidateStructTypeArray("VkVideoEncodeH265VclFrameInfoEXT", "pReferenceFinalLists->referenceList1EntryCount", "pReferenceFinalLists->pReferenceList1Entries", "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_EXT", structure->pReferenceFinalLists->referenceList1EntryCount, structure->pReferenceFinalLists->pReferenceList1Entries, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_EXT, false, true, "VUID-VkVideoEncodeH265DpbSlotInfoEXT-sType-sType", "VUID-VkVideoEncodeH265ReferenceListsInfoEXT-pReferenceList1Entries-parameter", kVUIDUndefined);

                    if (structure->pReferenceFinalLists->pReferenceList1Entries != nullptr)
                    {
                        for (uint32_t referenceList1EntryIndex = 0; referenceList1EntryIndex < structure->pReferenceFinalLists->referenceList1EntryCount; ++referenceList1EntryIndex)
                        {
                            skip |= ValidateRequiredPointer("VkVideoEncodeH265VclFrameInfoEXT", ParameterName("pReferenceFinalLists->pReferenceList1Entries[%i].pStdReferenceInfo", ParameterName::IndexVector{ referenceList1EntryIndex }), structure->pReferenceFinalLists->pReferenceList1Entries[referenceList1EntryIndex].pStdReferenceInfo, "VUID-VkVideoEncodeH265DpbSlotInfoEXT-pStdReferenceInfo-parameter");
                        }
                    }

                    skip |= ValidateRequiredPointer("VkVideoEncodeH265VclFrameInfoEXT", "pReferenceFinalLists->pReferenceModifications", structure->pReferenceFinalLists->pReferenceModifications, "VUID-VkVideoEncodeH265ReferenceListsInfoEXT-pReferenceModifications-parameter");
                }

                skip |= ValidateStructTypeArray("VkVideoEncodeH265VclFrameInfoEXT", "naluSliceSegmentEntryCount", "pNaluSliceSegmentEntries", "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_NALU_SLICE_SEGMENT_INFO_EXT", structure->naluSliceSegmentEntryCount, structure->pNaluSliceSegmentEntries, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_NALU_SLICE_SEGMENT_INFO_EXT, true, true, "VUID-VkVideoEncodeH265NaluSliceSegmentInfoEXT-sType-sType", "VUID-VkVideoEncodeH265VclFrameInfoEXT-pNaluSliceSegmentEntries-parameter", "VUID-VkVideoEncodeH265VclFrameInfoEXT-naluSliceSegmentEntryCount-arraylength");

                if (structure->pNaluSliceSegmentEntries != nullptr)
                {
                    for (uint32_t naluSliceSegmentEntryIndex = 0; naluSliceSegmentEntryIndex < structure->naluSliceSegmentEntryCount; ++naluSliceSegmentEntryIndex)
                    {
                        skip |= ValidateStructType("VkVideoEncodeH265VclFrameInfoEXT", ParameterName("pNaluSliceSegmentEntries[%i].pReferenceFinalLists", ParameterName::IndexVector{ naluSliceSegmentEntryIndex }), "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_REFERENCE_LISTS_INFO_EXT", structure->pNaluSliceSegmentEntries[naluSliceSegmentEntryIndex].pReferenceFinalLists, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_REFERENCE_LISTS_INFO_EXT, false, "VUID-VkVideoEncodeH265NaluSliceSegmentInfoEXT-pReferenceFinalLists-parameter", "VUID-VkVideoEncodeH265ReferenceListsInfoEXT-sType-sType");

                        if (structure->pNaluSliceSegmentEntries[naluSliceSegmentEntryIndex].pReferenceFinalLists != nullptr)
                        {
                            skip |= ValidateStructTypeArray("VkVideoEncodeH265VclFrameInfoEXT", ParameterName("pNaluSliceSegmentEntries[%i].pReferenceFinalLists->referenceList0EntryCount", ParameterName::IndexVector{ naluSliceSegmentEntryIndex }), ParameterName("pNaluSliceSegmentEntries[%i].pReferenceFinalLists->pReferenceList0Entries", ParameterName::IndexVector{ naluSliceSegmentEntryIndex }), "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_EXT", structure->pNaluSliceSegmentEntries[naluSliceSegmentEntryIndex].pReferenceFinalLists->referenceList0EntryCount, structure->pNaluSliceSegmentEntries[naluSliceSegmentEntryIndex].pReferenceFinalLists->pReferenceList0Entries, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_EXT, false, true, "VUID-VkVideoEncodeH265DpbSlotInfoEXT-sType-sType", "VUID-VkVideoEncodeH265ReferenceListsInfoEXT-pReferenceList0Entries-parameter", kVUIDUndefined);

                            if (structure->pNaluSliceSegmentEntries[naluSliceSegmentEntryIndex].pReferenceFinalLists->pReferenceList0Entries != nullptr)
                            {
                                for (uint32_t referenceList0EntryIndex = 0; referenceList0EntryIndex < structure->pNaluSliceSegmentEntries[naluSliceSegmentEntryIndex].pReferenceFinalLists->referenceList0EntryCount; ++referenceList0EntryIndex)
                                {
                                    skip |= ValidateRequiredPointer("VkVideoEncodeH265VclFrameInfoEXT", ParameterName("pNaluSliceSegmentEntries[%i].pReferenceFinalLists->pReferenceList0Entries[%i].pStdReferenceInfo", ParameterName::IndexVector{ naluSliceSegmentEntryIndex, referenceList0EntryIndex }), structure->pNaluSliceSegmentEntries[naluSliceSegmentEntryIndex].pReferenceFinalLists->pReferenceList0Entries[referenceList0EntryIndex].pStdReferenceInfo, "VUID-VkVideoEncodeH265DpbSlotInfoEXT-pStdReferenceInfo-parameter");
                                }
                            }

                            skip |= ValidateStructTypeArray("VkVideoEncodeH265VclFrameInfoEXT", ParameterName("pNaluSliceSegmentEntries[%i].pReferenceFinalLists->referenceList1EntryCount", ParameterName::IndexVector{ naluSliceSegmentEntryIndex }), ParameterName("pNaluSliceSegmentEntries[%i].pReferenceFinalLists->pReferenceList1Entries", ParameterName::IndexVector{ naluSliceSegmentEntryIndex }), "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_EXT", structure->pNaluSliceSegmentEntries[naluSliceSegmentEntryIndex].pReferenceFinalLists->referenceList1EntryCount, structure->pNaluSliceSegmentEntries[naluSliceSegmentEntryIndex].pReferenceFinalLists->pReferenceList1Entries, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_EXT, false, true, "VUID-VkVideoEncodeH265DpbSlotInfoEXT-sType-sType", "VUID-VkVideoEncodeH265ReferenceListsInfoEXT-pReferenceList1Entries-parameter", kVUIDUndefined);

                            if (structure->pNaluSliceSegmentEntries[naluSliceSegmentEntryIndex].pReferenceFinalLists->pReferenceList1Entries != nullptr)
                            {
                                for (uint32_t referenceList1EntryIndex = 0; referenceList1EntryIndex < structure->pNaluSliceSegmentEntries[naluSliceSegmentEntryIndex].pReferenceFinalLists->referenceList1EntryCount; ++referenceList1EntryIndex)
                                {
                                    skip |= ValidateRequiredPointer("VkVideoEncodeH265VclFrameInfoEXT", ParameterName("pNaluSliceSegmentEntries[%i].pReferenceFinalLists->pReferenceList1Entries[%i].pStdReferenceInfo", ParameterName::IndexVector{ naluSliceSegmentEntryIndex, referenceList1EntryIndex }), structure->pNaluSliceSegmentEntries[naluSliceSegmentEntryIndex].pReferenceFinalLists->pReferenceList1Entries[referenceList1EntryIndex].pStdReferenceInfo, "VUID-VkVideoEncodeH265DpbSlotInfoEXT-pStdReferenceInfo-parameter");
                                }
                            }

                            skip |= ValidateRequiredPointer("VkVideoEncodeH265VclFrameInfoEXT", ParameterName("pNaluSliceSegmentEntries[%i].pReferenceFinalLists->pReferenceModifications", ParameterName::IndexVector{ naluSliceSegmentEntryIndex }), structure->pNaluSliceSegmentEntries[naluSliceSegmentEntryIndex].pReferenceFinalLists->pReferenceModifications, "VUID-VkVideoEncodeH265ReferenceListsInfoEXT-pReferenceModifications-parameter");
                        }

                        skip |= ValidateRequiredPointer("VkVideoEncodeH265VclFrameInfoEXT", ParameterName("pNaluSliceSegmentEntries[%i].pSliceSegmentHeaderStd", ParameterName::IndexVector{ naluSliceSegmentEntryIndex }), structure->pNaluSliceSegmentEntries[naluSliceSegmentEntryIndex].pSliceSegmentHeaderStd, "VUID-VkVideoEncodeH265NaluSliceSegmentInfoEXT-pSliceSegmentHeaderStd-parameter");
                    }
                }

                skip |= ValidateRequiredPointer("VkVideoEncodeH265VclFrameInfoEXT", "pCurrentPictureInfo", structure->pCurrentPictureInfo, "VUID-VkVideoEncodeH265VclFrameInfoEXT-pCurrentPictureInfo-parameter");
            }
        } break;
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
        // Validation code for VkVideoEncodeH265EmitPictureParametersInfoEXT structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_EMIT_PICTURE_PARAMETERS_INFO_EXT: { // Covers VUID-VkVideoEncodeH265EmitPictureParametersInfoEXT-sType-sType
            if (is_const_param) {
                VkVideoEncodeH265EmitPictureParametersInfoEXT *structure = (VkVideoEncodeH265EmitPictureParametersInfoEXT *) header;
                skip |= ValidateBool32("VkVideoEncodeH265EmitPictureParametersInfoEXT", "emitVpsEnable", structure->emitVpsEnable);

                skip |= ValidateBool32("VkVideoEncodeH265EmitPictureParametersInfoEXT", "emitSpsEnable", structure->emitSpsEnable);

                skip |= ValidateArray("VkVideoEncodeH265EmitPictureParametersInfoEXT", "ppsIdEntryCount", "ppsIdEntries", structure->ppsIdEntryCount, &structure->ppsIdEntries, false, true, kVUIDUndefined, "VUID-VkVideoEncodeH265EmitPictureParametersInfoEXT-ppsIdEntries-parameter");
            }
        } break;
#endif // VK_ENABLE_BETA_EXTENSIONS

        // No Validation code for VkVideoEncodeH265ProfileInfoEXT structure members  -- Covers VUID-VkVideoEncodeH265ProfileInfoEXT-sType-sType

#ifdef VK_ENABLE_BETA_EXTENSIONS
        // Validation code for VkVideoEncodeH265RateControlInfoEXT structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_INFO_EXT: { // Covers VUID-VkVideoEncodeH265RateControlInfoEXT-sType-sType
            if (is_const_param) {
                VkVideoEncodeH265RateControlInfoEXT *structure = (VkVideoEncodeH265RateControlInfoEXT *) header;
                skip |= ValidateRangedEnum("VkVideoEncodeH265RateControlInfoEXT", "rateControlStructure", "VkVideoEncodeH265RateControlStructureEXT", AllVkVideoEncodeH265RateControlStructureEXTEnums, structure->rateControlStructure, "VUID-VkVideoEncodeH265RateControlInfoEXT-rateControlStructure-parameter");
            }
        } break;
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
        // Validation code for VkVideoEncodeH265RateControlLayerInfoEXT structure members
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_LAYER_INFO_EXT: { // Covers VUID-VkVideoEncodeH265RateControlLayerInfoEXT-sType-sType
            if (is_const_param) {
                VkVideoEncodeH265RateControlLayerInfoEXT *structure = (VkVideoEncodeH265RateControlLayerInfoEXT *) header;
                skip |= ValidateBool32("VkVideoEncodeH265RateControlLayerInfoEXT", "useInitialRcQp", structure->useInitialRcQp);

                skip |= ValidateBool32("VkVideoEncodeH265RateControlLayerInfoEXT", "useMinQp", structure->useMinQp);

                skip |= ValidateBool32("VkVideoEncodeH265RateControlLayerInfoEXT", "useMaxQp", structure->useMaxQp);

                skip |= ValidateBool32("VkVideoEncodeH265RateControlLayerInfoEXT", "useMaxFrameSize", structure->useMaxFrameSize);

            }
        } break;
#endif // VK_ENABLE_BETA_EXTENSIONS

        // No Validation code for VkTextureLODGatherFormatPropertiesAMD structure members  -- Covers VUID-VkTextureLODGatherFormatPropertiesAMD-sType-sType

        // Validation code for VkPhysicalDeviceCornerSampledImageFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceCornerSampledImageFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceCornerSampledImageFeaturesNV *structure = (VkPhysicalDeviceCornerSampledImageFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceCornerSampledImageFeaturesNV", "cornerSampledImage", structure->cornerSampledImage);
            }
        } break;

        // Validation code for VkExternalMemoryImageCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV: { // Covers VUID-VkExternalMemoryImageCreateInfoNV-sType-sType
            if (is_const_param) {
                VkExternalMemoryImageCreateInfoNV *structure = (VkExternalMemoryImageCreateInfoNV *) header;
                skip |= ValidateFlags("VkExternalMemoryImageCreateInfoNV", "handleTypes", "VkExternalMemoryHandleTypeFlagBitsNV", AllVkExternalMemoryHandleTypeFlagBitsNV, structure->handleTypes, kOptionalFlags, "VUID-VkExternalMemoryImageCreateInfoNV-handleTypes-parameter");
            }
        } break;

        // Validation code for VkExportMemoryAllocateInfoNV structure members
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV: { // Covers VUID-VkExportMemoryAllocateInfoNV-sType-sType
            if (is_const_param) {
                VkExportMemoryAllocateInfoNV *structure = (VkExportMemoryAllocateInfoNV *) header;
                skip |= ValidateFlags("VkExportMemoryAllocateInfoNV", "handleTypes", "VkExternalMemoryHandleTypeFlagBitsNV", AllVkExternalMemoryHandleTypeFlagBitsNV, structure->handleTypes, kOptionalFlags, "VUID-VkExportMemoryAllocateInfoNV-handleTypes-parameter");
            }
        } break;

#ifdef VK_USE_PLATFORM_WIN32_KHR
        // Validation code for VkImportMemoryWin32HandleInfoNV structure members
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV: { // Covers VUID-VkImportMemoryWin32HandleInfoNV-sType-sType
            if (is_const_param) {
                VkImportMemoryWin32HandleInfoNV *structure = (VkImportMemoryWin32HandleInfoNV *) header;
                skip |= ValidateFlags("VkImportMemoryWin32HandleInfoNV", "handleType", "VkExternalMemoryHandleTypeFlagBitsNV", AllVkExternalMemoryHandleTypeFlagBitsNV, structure->handleType, kOptionalFlags, "VUID-VkImportMemoryWin32HandleInfoNV-handleType-parameter");
            }
        } break;
#endif // VK_USE_PLATFORM_WIN32_KHR

        // No Validation code for VkExportMemoryWin32HandleInfoNV structure members  -- Covers VUID-VkExportMemoryWin32HandleInfoNV-sType-sType

#ifdef VK_USE_PLATFORM_WIN32_KHR
        // Validation code for VkWin32KeyedMutexAcquireReleaseInfoNV structure members
        case VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV: { // Covers VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-sType-sType
            if (is_const_param) {
                VkWin32KeyedMutexAcquireReleaseInfoNV *structure = (VkWin32KeyedMutexAcquireReleaseInfoNV *) header;
                skip |= ValidateArray("VkWin32KeyedMutexAcquireReleaseInfoNV", "acquireCount", "pAcquireSyncs", structure->acquireCount, &structure->pAcquireSyncs, false, true, kVUIDUndefined, "VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pAcquireSyncs-parameter");

                skip |= ValidateArray("VkWin32KeyedMutexAcquireReleaseInfoNV", "acquireCount", "pAcquireKeys", structure->acquireCount, &structure->pAcquireKeys, false, true, kVUIDUndefined, "VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pAcquireKeys-parameter");

                skip |= ValidateArray("VkWin32KeyedMutexAcquireReleaseInfoNV", "acquireCount", "pAcquireTimeoutMilliseconds", structure->acquireCount, &structure->pAcquireTimeoutMilliseconds, false, true, kVUIDUndefined, "VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pAcquireTimeoutMilliseconds-parameter");

                skip |= ValidateArray("VkWin32KeyedMutexAcquireReleaseInfoNV", "releaseCount", "pReleaseSyncs", structure->releaseCount, &structure->pReleaseSyncs, false, true, kVUIDUndefined, "VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pReleaseSyncs-parameter");

                skip |= ValidateArray("VkWin32KeyedMutexAcquireReleaseInfoNV", "releaseCount", "pReleaseKeys", structure->releaseCount, &structure->pReleaseKeys, false, true, kVUIDUndefined, "VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pReleaseKeys-parameter");
            }
        } break;
#endif // VK_USE_PLATFORM_WIN32_KHR

        // Validation code for VkValidationFlagsEXT structure members
        case VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT: { // Covers VUID-VkValidationFlagsEXT-sType-sType
            if (is_const_param) {
                VkValidationFlagsEXT *structure = (VkValidationFlagsEXT *) header;
                skip |= ValidateRangedEnumArray("VkValidationFlagsEXT", "disabledValidationCheckCount", "pDisabledValidationChecks", "VkValidationCheckEXT", AllVkValidationCheckEXTEnums, structure->disabledValidationCheckCount, structure->pDisabledValidationChecks, true, true);
            }
        } break;

        // Validation code for VkImageViewASTCDecodeModeEXT structure members
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT: { // Covers VUID-VkImageViewASTCDecodeModeEXT-sType-sType
            if (is_const_param) {
                VkImageViewASTCDecodeModeEXT *structure = (VkImageViewASTCDecodeModeEXT *) header;
                skip |= ValidateRangedEnum("VkImageViewASTCDecodeModeEXT", "decodeMode", "VkFormat", AllVkFormatEnums, structure->decodeMode, "VUID-VkImageViewASTCDecodeModeEXT-decodeMode-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceASTCDecodeFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceASTCDecodeFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceASTCDecodeFeaturesEXT *structure = (VkPhysicalDeviceASTCDecodeFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceASTCDecodeFeaturesEXT", "decodeModeSharedExponent", structure->decodeModeSharedExponent);
            }
        } break;

        // Validation code for VkPhysicalDevicePipelineRobustnessFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES_EXT: { // Covers VUID-VkPhysicalDevicePipelineRobustnessFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDevicePipelineRobustnessFeaturesEXT *structure = (VkPhysicalDevicePipelineRobustnessFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDevicePipelineRobustnessFeaturesEXT", "pipelineRobustness", structure->pipelineRobustness);
            }
        } break;

        // No Validation code for VkPhysicalDevicePipelineRobustnessPropertiesEXT structure members  -- Covers VUID-VkPhysicalDevicePipelineRobustnessPropertiesEXT-sType-sType

        // Validation code for VkPipelineRobustnessCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO_EXT: { // Covers VUID-VkPipelineRobustnessCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkPipelineRobustnessCreateInfoEXT *structure = (VkPipelineRobustnessCreateInfoEXT *) header;
                skip |= ValidateRangedEnum("VkPipelineRobustnessCreateInfoEXT", "storageBuffers", "VkPipelineRobustnessBufferBehaviorEXT", AllVkPipelineRobustnessBufferBehaviorEXTEnums, structure->storageBuffers, "VUID-VkPipelineRobustnessCreateInfoEXT-storageBuffers-parameter");

                skip |= ValidateRangedEnum("VkPipelineRobustnessCreateInfoEXT", "uniformBuffers", "VkPipelineRobustnessBufferBehaviorEXT", AllVkPipelineRobustnessBufferBehaviorEXTEnums, structure->uniformBuffers, "VUID-VkPipelineRobustnessCreateInfoEXT-uniformBuffers-parameter");

                skip |= ValidateRangedEnum("VkPipelineRobustnessCreateInfoEXT", "vertexInputs", "VkPipelineRobustnessBufferBehaviorEXT", AllVkPipelineRobustnessBufferBehaviorEXTEnums, structure->vertexInputs, "VUID-VkPipelineRobustnessCreateInfoEXT-vertexInputs-parameter");

                skip |= ValidateRangedEnum("VkPipelineRobustnessCreateInfoEXT", "images", "VkPipelineRobustnessImageBehaviorEXT", AllVkPipelineRobustnessImageBehaviorEXTEnums, structure->images, "VUID-VkPipelineRobustnessCreateInfoEXT-images-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceConditionalRenderingFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceConditionalRenderingFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceConditionalRenderingFeaturesEXT *structure = (VkPhysicalDeviceConditionalRenderingFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceConditionalRenderingFeaturesEXT", "conditionalRendering", structure->conditionalRendering);

                skip |= ValidateBool32("VkPhysicalDeviceConditionalRenderingFeaturesEXT", "inheritedConditionalRendering", structure->inheritedConditionalRendering);
            }
        } break;

        // Validation code for VkCommandBufferInheritanceConditionalRenderingInfoEXT structure members
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT: { // Covers VUID-VkCommandBufferInheritanceConditionalRenderingInfoEXT-sType-sType
            if (is_const_param) {
                VkCommandBufferInheritanceConditionalRenderingInfoEXT *structure = (VkCommandBufferInheritanceConditionalRenderingInfoEXT *) header;
                skip |= ValidateBool32("VkCommandBufferInheritanceConditionalRenderingInfoEXT", "conditionalRenderingEnable", structure->conditionalRenderingEnable);
            }
        } break;

        // Validation code for VkPipelineViewportWScalingStateCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV: { // Covers VUID-VkPipelineViewportWScalingStateCreateInfoNV-sType-sType
            if (is_const_param) {
                VkPipelineViewportWScalingStateCreateInfoNV *structure = (VkPipelineViewportWScalingStateCreateInfoNV *) header;
                skip |= ValidateBool32("VkPipelineViewportWScalingStateCreateInfoNV", "viewportWScalingEnable", structure->viewportWScalingEnable);

                skip |= ValidateArray("VkPipelineViewportWScalingStateCreateInfoNV", "viewportCount", "", structure->viewportCount, &structure->pViewportWScalings, true, false, "VUID-VkPipelineViewportWScalingStateCreateInfoNV-viewportCount-arraylength", kVUIDUndefined);
            }
        } break;

        // Validation code for VkSwapchainCounterCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT: { // Covers VUID-VkSwapchainCounterCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkSwapchainCounterCreateInfoEXT *structure = (VkSwapchainCounterCreateInfoEXT *) header;
                skip |= ValidateFlags("VkSwapchainCounterCreateInfoEXT", "surfaceCounters", "VkSurfaceCounterFlagBitsEXT", AllVkSurfaceCounterFlagBitsEXT, structure->surfaceCounters, kOptionalFlags, "VUID-VkSwapchainCounterCreateInfoEXT-surfaceCounters-parameter");
            }
        } break;

        // Validation code for VkPresentTimesInfoGOOGLE structure members
        case VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE: { // Covers VUID-VkPresentTimesInfoGOOGLE-sType-sType
            if (is_const_param) {
                VkPresentTimesInfoGOOGLE *structure = (VkPresentTimesInfoGOOGLE *) header;
                skip |= ValidateArray("VkPresentTimesInfoGOOGLE", "swapchainCount", "pTimes", structure->swapchainCount, &structure->pTimes, true, false, "VUID-VkPresentTimesInfoGOOGLE-swapchainCount-arraylength", "VUID-VkPresentTimesInfoGOOGLE-pTimes-parameter");

                if (structure->pTimes != nullptr)
                {
                    for (uint32_t swapchainIndex = 0; swapchainIndex < structure->swapchainCount; ++swapchainIndex)
                    {
                    }
                }
            }
        } break;

        // No Validation code for VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX structure members  -- Covers VUID-VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX-sType-sType

        // Validation code for VkPipelineViewportSwizzleStateCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV: { // Covers VUID-VkPipelineViewportSwizzleStateCreateInfoNV-sType-sType
            if (is_const_param) {
                VkPipelineViewportSwizzleStateCreateInfoNV *structure = (VkPipelineViewportSwizzleStateCreateInfoNV *) header;
                skip |= ValidateReservedFlags("VkPipelineViewportSwizzleStateCreateInfoNV", "flags", structure->flags, "VUID-VkPipelineViewportSwizzleStateCreateInfoNV-flags-zerobitmask");

                skip |= ValidateArray("VkPipelineViewportSwizzleStateCreateInfoNV", "viewportCount", "pViewportSwizzles", structure->viewportCount, &structure->pViewportSwizzles, true, true, "VUID-VkPipelineViewportSwizzleStateCreateInfoNV-viewportCount-arraylength", "VUID-VkPipelineViewportSwizzleStateCreateInfoNV-pViewportSwizzles-parameter");

                if (structure->pViewportSwizzles != nullptr)
                {
                    for (uint32_t viewportIndex = 0; viewportIndex < structure->viewportCount; ++viewportIndex)
                    {
                        skip |= ValidateRangedEnum("VkPipelineViewportSwizzleStateCreateInfoNV", ParameterName("pViewportSwizzles[%i].x", ParameterName::IndexVector{ viewportIndex }), "VkViewportCoordinateSwizzleNV", AllVkViewportCoordinateSwizzleNVEnums, structure->pViewportSwizzles[viewportIndex].x, "VUID-VkViewportSwizzleNV-x-parameter");

                        skip |= ValidateRangedEnum("VkPipelineViewportSwizzleStateCreateInfoNV", ParameterName("pViewportSwizzles[%i].y", ParameterName::IndexVector{ viewportIndex }), "VkViewportCoordinateSwizzleNV", AllVkViewportCoordinateSwizzleNVEnums, structure->pViewportSwizzles[viewportIndex].y, "VUID-VkViewportSwizzleNV-y-parameter");

                        skip |= ValidateRangedEnum("VkPipelineViewportSwizzleStateCreateInfoNV", ParameterName("pViewportSwizzles[%i].z", ParameterName::IndexVector{ viewportIndex }), "VkViewportCoordinateSwizzleNV", AllVkViewportCoordinateSwizzleNVEnums, structure->pViewportSwizzles[viewportIndex].z, "VUID-VkViewportSwizzleNV-z-parameter");

                        skip |= ValidateRangedEnum("VkPipelineViewportSwizzleStateCreateInfoNV", ParameterName("pViewportSwizzles[%i].w", ParameterName::IndexVector{ viewportIndex }), "VkViewportCoordinateSwizzleNV", AllVkViewportCoordinateSwizzleNVEnums, structure->pViewportSwizzles[viewportIndex].w, "VUID-VkViewportSwizzleNV-w-parameter");
                    }
                }
            }
        } break;

        // No Validation code for VkPhysicalDeviceDiscardRectanglePropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceDiscardRectanglePropertiesEXT-sType-sType

        // Validation code for VkPipelineDiscardRectangleStateCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT: { // Covers VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkPipelineDiscardRectangleStateCreateInfoEXT *structure = (VkPipelineDiscardRectangleStateCreateInfoEXT *) header;
                skip |= ValidateReservedFlags("VkPipelineDiscardRectangleStateCreateInfoEXT", "flags", structure->flags, "VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-flags-zerobitmask");

                skip |= ValidateRangedEnum("VkPipelineDiscardRectangleStateCreateInfoEXT", "discardRectangleMode", "VkDiscardRectangleModeEXT", AllVkDiscardRectangleModeEXTEnums, structure->discardRectangleMode, "VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-discardRectangleMode-parameter");
            }
        } break;

        // No Validation code for VkPhysicalDeviceConservativeRasterizationPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceConservativeRasterizationPropertiesEXT-sType-sType

        // Validation code for VkPipelineRasterizationConservativeStateCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT: { // Covers VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkPipelineRasterizationConservativeStateCreateInfoEXT *structure = (VkPipelineRasterizationConservativeStateCreateInfoEXT *) header;
                skip |= ValidateReservedFlags("VkPipelineRasterizationConservativeStateCreateInfoEXT", "flags", structure->flags, "VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-flags-zerobitmask");

                skip |= ValidateRangedEnum("VkPipelineRasterizationConservativeStateCreateInfoEXT", "conservativeRasterizationMode", "VkConservativeRasterizationModeEXT", AllVkConservativeRasterizationModeEXTEnums, structure->conservativeRasterizationMode, "VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-conservativeRasterizationMode-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceDepthClipEnableFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceDepthClipEnableFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceDepthClipEnableFeaturesEXT *structure = (VkPhysicalDeviceDepthClipEnableFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceDepthClipEnableFeaturesEXT", "depthClipEnable", structure->depthClipEnable);
            }
        } break;

        // Validation code for VkPipelineRasterizationDepthClipStateCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT: { // Covers VUID-VkPipelineRasterizationDepthClipStateCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkPipelineRasterizationDepthClipStateCreateInfoEXT *structure = (VkPipelineRasterizationDepthClipStateCreateInfoEXT *) header;
                skip |= ValidateReservedFlags("VkPipelineRasterizationDepthClipStateCreateInfoEXT", "flags", structure->flags, "VUID-VkPipelineRasterizationDepthClipStateCreateInfoEXT-flags-zerobitmask");

                skip |= ValidateBool32("VkPipelineRasterizationDepthClipStateCreateInfoEXT", "depthClipEnable", structure->depthClipEnable);
            }
        } break;

        // Validation code for VkDebugUtilsObjectNameInfoEXT structure members
        case VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT: { // Covers VUID-VkDebugUtilsObjectNameInfoEXT-sType-sType
            if (is_const_param) {
                VkDebugUtilsObjectNameInfoEXT *structure = (VkDebugUtilsObjectNameInfoEXT *) header;
                skip |= ValidateRangedEnum("VkDebugUtilsObjectNameInfoEXT", "objectType", "VkObjectType", AllVkObjectTypeEnums, structure->objectType, "VUID-VkDebugUtilsObjectNameInfoEXT-objectType-parameter");
            }
        } break;

        // Validation code for VkDebugUtilsMessengerCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT: { // Covers VUID-VkDebugUtilsMessengerCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkDebugUtilsMessengerCreateInfoEXT *structure = (VkDebugUtilsMessengerCreateInfoEXT *) header;
                skip |= ValidateReservedFlags("VkDebugUtilsMessengerCreateInfoEXT", "flags", structure->flags, "VUID-VkDebugUtilsMessengerCreateInfoEXT-flags-zerobitmask");

                skip |= ValidateFlags("VkDebugUtilsMessengerCreateInfoEXT", "messageSeverity", "VkDebugUtilsMessageSeverityFlagBitsEXT", AllVkDebugUtilsMessageSeverityFlagBitsEXT, structure->messageSeverity, kRequiredFlags, "VUID-VkDebugUtilsMessengerCreateInfoEXT-messageSeverity-parameter", "VUID-VkDebugUtilsMessengerCreateInfoEXT-messageSeverity-requiredbitmask");

                skip |= ValidateFlags("VkDebugUtilsMessengerCreateInfoEXT", "messageType", "VkDebugUtilsMessageTypeFlagBitsEXT", AllVkDebugUtilsMessageTypeFlagBitsEXT, structure->messageType, kRequiredFlags, "VUID-VkDebugUtilsMessengerCreateInfoEXT-messageType-parameter", "VUID-VkDebugUtilsMessengerCreateInfoEXT-messageType-requiredbitmask");

                skip |= ValidateRequiredPointer("VkDebugUtilsMessengerCreateInfoEXT", "pfnUserCallback", reinterpret_cast<const void*>(structure->pfnUserCallback), "VUID-VkDebugUtilsMessengerCreateInfoEXT-pfnUserCallback-parameter");
            }
        } break;

        // No Validation code for VkAndroidHardwareBufferUsageANDROID structure members  -- Covers VUID-VkAndroidHardwareBufferUsageANDROID-sType-sType

        // No Validation code for VkAndroidHardwareBufferFormatPropertiesANDROID structure members  -- Covers VUID-VkAndroidHardwareBufferFormatPropertiesANDROID-sType-sType

#ifdef VK_USE_PLATFORM_ANDROID_KHR
        // Validation code for VkImportAndroidHardwareBufferInfoANDROID structure members
        case VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID: { // Covers VUID-VkImportAndroidHardwareBufferInfoANDROID-sType-sType
            if (is_const_param) {
                VkImportAndroidHardwareBufferInfoANDROID *structure = (VkImportAndroidHardwareBufferInfoANDROID *) header;
                skip |= ValidateRequiredPointer("VkImportAndroidHardwareBufferInfoANDROID", "buffer", structure->buffer, "VUID-VkImportAndroidHardwareBufferInfoANDROID-buffer-parameter");
            }
        } break;
#endif // VK_USE_PLATFORM_ANDROID_KHR

        // No Validation code for VkExternalFormatANDROID structure members  -- Covers VUID-VkExternalFormatANDROID-sType-sType

        // No Validation code for VkAndroidHardwareBufferFormatProperties2ANDROID structure members  -- Covers VUID-VkAndroidHardwareBufferFormatProperties2ANDROID-sType-sType

        // Validation code for VkSampleLocationsInfoEXT structure members
        case VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT: { // Covers VUID-VkSampleLocationsInfoEXT-sType-sType
            if (is_const_param) {
                VkSampleLocationsInfoEXT *structure = (VkSampleLocationsInfoEXT *) header;
                skip |= ValidateArray("VkSampleLocationsInfoEXT", "sampleLocationsCount", "pSampleLocations", structure->sampleLocationsCount, &structure->pSampleLocations, false, true, kVUIDUndefined, "VUID-VkSampleLocationsInfoEXT-pSampleLocations-parameter");

                if (structure->pSampleLocations != nullptr)
                {
                    for (uint32_t sampleLocationsIndex = 0; sampleLocationsIndex < structure->sampleLocationsCount; ++sampleLocationsIndex)
                    {
                    }
                }
            }
        } break;

        // Validation code for VkRenderPassSampleLocationsBeginInfoEXT structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT: { // Covers VUID-VkRenderPassSampleLocationsBeginInfoEXT-sType-sType
            if (is_const_param) {
                VkRenderPassSampleLocationsBeginInfoEXT *structure = (VkRenderPassSampleLocationsBeginInfoEXT *) header;
                skip |= ValidateArray("VkRenderPassSampleLocationsBeginInfoEXT", "attachmentInitialSampleLocationsCount", "pAttachmentInitialSampleLocations", structure->attachmentInitialSampleLocationsCount, &structure->pAttachmentInitialSampleLocations, false, true, kVUIDUndefined, "VUID-VkRenderPassSampleLocationsBeginInfoEXT-pAttachmentInitialSampleLocations-parameter");

                if (structure->pAttachmentInitialSampleLocations != nullptr)
                {
                    for (uint32_t attachmentInitialSampleLocationsIndex = 0; attachmentInitialSampleLocationsIndex < structure->attachmentInitialSampleLocationsCount; ++attachmentInitialSampleLocationsIndex)
                    {
                        skip |= ValidateStructType("VkRenderPassSampleLocationsBeginInfoEXT", ParameterName("pAttachmentInitialSampleLocations[%i].sampleLocationsInfo", ParameterName::IndexVector{ attachmentInitialSampleLocationsIndex }), "VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT", &(structure->pAttachmentInitialSampleLocations[attachmentInitialSampleLocationsIndex].sampleLocationsInfo), VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT, false, kVUIDUndefined, "VUID-VkSampleLocationsInfoEXT-sType-sType");

                        skip |= ValidateArray("VkRenderPassSampleLocationsBeginInfoEXT", ParameterName("pAttachmentInitialSampleLocations[%i].sampleLocationsInfo.sampleLocationsCount", ParameterName::IndexVector{ attachmentInitialSampleLocationsIndex }), ParameterName("pAttachmentInitialSampleLocations[%i].sampleLocationsInfo.pSampleLocations", ParameterName::IndexVector{ attachmentInitialSampleLocationsIndex }), structure->pAttachmentInitialSampleLocations[attachmentInitialSampleLocationsIndex].sampleLocationsInfo.sampleLocationsCount, &structure->pAttachmentInitialSampleLocations[attachmentInitialSampleLocationsIndex].sampleLocationsInfo.pSampleLocations, false, true, kVUIDUndefined, "VUID-VkSampleLocationsInfoEXT-pSampleLocations-parameter");

                        if (structure->pAttachmentInitialSampleLocations[attachmentInitialSampleLocationsIndex].sampleLocationsInfo.pSampleLocations != nullptr)
                        {
                            for (uint32_t sampleLocationsIndex = 0; sampleLocationsIndex < structure->pAttachmentInitialSampleLocations[attachmentInitialSampleLocationsIndex].sampleLocationsInfo.sampleLocationsCount; ++sampleLocationsIndex)
                            {
                            }
                        }
                    }
                }

                skip |= ValidateArray("VkRenderPassSampleLocationsBeginInfoEXT", "postSubpassSampleLocationsCount", "pPostSubpassSampleLocations", structure->postSubpassSampleLocationsCount, &structure->pPostSubpassSampleLocations, false, true, kVUIDUndefined, "VUID-VkRenderPassSampleLocationsBeginInfoEXT-pPostSubpassSampleLocations-parameter");

                if (structure->pPostSubpassSampleLocations != nullptr)
                {
                    for (uint32_t postSubpassSampleLocationsIndex = 0; postSubpassSampleLocationsIndex < structure->postSubpassSampleLocationsCount; ++postSubpassSampleLocationsIndex)
                    {
                        skip |= ValidateStructType("VkRenderPassSampleLocationsBeginInfoEXT", ParameterName("pPostSubpassSampleLocations[%i].sampleLocationsInfo", ParameterName::IndexVector{ postSubpassSampleLocationsIndex }), "VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT", &(structure->pPostSubpassSampleLocations[postSubpassSampleLocationsIndex].sampleLocationsInfo), VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT, false, kVUIDUndefined, "VUID-VkSampleLocationsInfoEXT-sType-sType");

                        skip |= ValidateArray("VkRenderPassSampleLocationsBeginInfoEXT", ParameterName("pPostSubpassSampleLocations[%i].sampleLocationsInfo.sampleLocationsCount", ParameterName::IndexVector{ postSubpassSampleLocationsIndex }), ParameterName("pPostSubpassSampleLocations[%i].sampleLocationsInfo.pSampleLocations", ParameterName::IndexVector{ postSubpassSampleLocationsIndex }), structure->pPostSubpassSampleLocations[postSubpassSampleLocationsIndex].sampleLocationsInfo.sampleLocationsCount, &structure->pPostSubpassSampleLocations[postSubpassSampleLocationsIndex].sampleLocationsInfo.pSampleLocations, false, true, kVUIDUndefined, "VUID-VkSampleLocationsInfoEXT-pSampleLocations-parameter");

                        if (structure->pPostSubpassSampleLocations[postSubpassSampleLocationsIndex].sampleLocationsInfo.pSampleLocations != nullptr)
                        {
                            for (uint32_t sampleLocationsIndex = 0; sampleLocationsIndex < structure->pPostSubpassSampleLocations[postSubpassSampleLocationsIndex].sampleLocationsInfo.sampleLocationsCount; ++sampleLocationsIndex)
                            {
                            }
                        }
                    }
                }
            }
        } break;

        // Validation code for VkPipelineSampleLocationsStateCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT: { // Covers VUID-VkPipelineSampleLocationsStateCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkPipelineSampleLocationsStateCreateInfoEXT *structure = (VkPipelineSampleLocationsStateCreateInfoEXT *) header;
                skip |= ValidateBool32("VkPipelineSampleLocationsStateCreateInfoEXT", "sampleLocationsEnable", structure->sampleLocationsEnable);

                skip |= ValidateStructType("VkPipelineSampleLocationsStateCreateInfoEXT", "sampleLocationsInfo", "VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT", &(structure->sampleLocationsInfo), VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT, false, kVUIDUndefined, "VUID-VkSampleLocationsInfoEXT-sType-sType");

                skip |= ValidateArray("VkPipelineSampleLocationsStateCreateInfoEXT", "sampleLocationsInfo.sampleLocationsCount", "sampleLocationsInfo.pSampleLocations", structure->sampleLocationsInfo.sampleLocationsCount, &structure->sampleLocationsInfo.pSampleLocations, false, true, kVUIDUndefined, "VUID-VkSampleLocationsInfoEXT-pSampleLocations-parameter");

                if (structure->sampleLocationsInfo.pSampleLocations != nullptr)
                {
                    for (uint32_t sampleLocationsIndex = 0; sampleLocationsIndex < structure->sampleLocationsInfo.sampleLocationsCount; ++sampleLocationsIndex)
                    {
                    }
                }
            }
        } break;

        // No Validation code for VkPhysicalDeviceSampleLocationsPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceSampleLocationsPropertiesEXT-sType-sType

        // Validation code for VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *structure = (VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT", "advancedBlendCoherentOperations", structure->advancedBlendCoherentOperations);
            }
        } break;

        // No Validation code for VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT-sType-sType

        // Validation code for VkPipelineColorBlendAdvancedStateCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT: { // Covers VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkPipelineColorBlendAdvancedStateCreateInfoEXT *structure = (VkPipelineColorBlendAdvancedStateCreateInfoEXT *) header;
                skip |= ValidateBool32("VkPipelineColorBlendAdvancedStateCreateInfoEXT", "srcPremultiplied", structure->srcPremultiplied);

                skip |= ValidateBool32("VkPipelineColorBlendAdvancedStateCreateInfoEXT", "dstPremultiplied", structure->dstPremultiplied);

                skip |= ValidateRangedEnum("VkPipelineColorBlendAdvancedStateCreateInfoEXT", "blendOverlap", "VkBlendOverlapEXT", AllVkBlendOverlapEXTEnums, structure->blendOverlap, "VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-blendOverlap-parameter");
            }
        } break;

        // Validation code for VkPipelineCoverageToColorStateCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV: { // Covers VUID-VkPipelineCoverageToColorStateCreateInfoNV-sType-sType
            if (is_const_param) {
                VkPipelineCoverageToColorStateCreateInfoNV *structure = (VkPipelineCoverageToColorStateCreateInfoNV *) header;
                skip |= ValidateReservedFlags("VkPipelineCoverageToColorStateCreateInfoNV", "flags", structure->flags, "VUID-VkPipelineCoverageToColorStateCreateInfoNV-flags-zerobitmask");

                skip |= ValidateBool32("VkPipelineCoverageToColorStateCreateInfoNV", "coverageToColorEnable", structure->coverageToColorEnable);
            }
        } break;

        // Validation code for VkPipelineCoverageModulationStateCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV: { // Covers VUID-VkPipelineCoverageModulationStateCreateInfoNV-sType-sType
            if (is_const_param) {
                VkPipelineCoverageModulationStateCreateInfoNV *structure = (VkPipelineCoverageModulationStateCreateInfoNV *) header;
                skip |= ValidateReservedFlags("VkPipelineCoverageModulationStateCreateInfoNV", "flags", structure->flags, "VUID-VkPipelineCoverageModulationStateCreateInfoNV-flags-zerobitmask");

                skip |= ValidateRangedEnum("VkPipelineCoverageModulationStateCreateInfoNV", "coverageModulationMode", "VkCoverageModulationModeNV", AllVkCoverageModulationModeNVEnums, structure->coverageModulationMode, "VUID-VkPipelineCoverageModulationStateCreateInfoNV-coverageModulationMode-parameter");

                skip |= ValidateBool32("VkPipelineCoverageModulationStateCreateInfoNV", "coverageModulationTableEnable", structure->coverageModulationTableEnable);
            }
        } break;

        // No Validation code for VkPhysicalDeviceShaderSMBuiltinsPropertiesNV structure members  -- Covers VUID-VkPhysicalDeviceShaderSMBuiltinsPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceShaderSMBuiltinsFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceShaderSMBuiltinsFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceShaderSMBuiltinsFeaturesNV *structure = (VkPhysicalDeviceShaderSMBuiltinsFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShaderSMBuiltinsFeaturesNV", "shaderSMBuiltins", structure->shaderSMBuiltins);
            }
        } break;

        // No Validation code for VkDrmFormatModifierPropertiesListEXT structure members  -- Covers VUID-VkDrmFormatModifierPropertiesListEXT-sType-sType

        // Validation code for VkPhysicalDeviceImageDrmFormatModifierInfoEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT: { // Covers VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceImageDrmFormatModifierInfoEXT *structure = (VkPhysicalDeviceImageDrmFormatModifierInfoEXT *) header;
                skip |= ValidateRangedEnum("VkPhysicalDeviceImageDrmFormatModifierInfoEXT", "sharingMode", "VkSharingMode", AllVkSharingModeEnums, structure->sharingMode, "VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sharingMode-parameter");
            }
        } break;

        // Validation code for VkImageDrmFormatModifierListCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT: { // Covers VUID-VkImageDrmFormatModifierListCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkImageDrmFormatModifierListCreateInfoEXT *structure = (VkImageDrmFormatModifierListCreateInfoEXT *) header;
                skip |= ValidateArray("VkImageDrmFormatModifierListCreateInfoEXT", "drmFormatModifierCount", "pDrmFormatModifiers", structure->drmFormatModifierCount, &structure->pDrmFormatModifiers, true, true, "VUID-VkImageDrmFormatModifierListCreateInfoEXT-drmFormatModifierCount-arraylength", "VUID-VkImageDrmFormatModifierListCreateInfoEXT-pDrmFormatModifiers-parameter");
            }
        } break;

        // Validation code for VkImageDrmFormatModifierExplicitCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT: { // Covers VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkImageDrmFormatModifierExplicitCreateInfoEXT *structure = (VkImageDrmFormatModifierExplicitCreateInfoEXT *) header;
                skip |= ValidateArray("VkImageDrmFormatModifierExplicitCreateInfoEXT", "drmFormatModifierPlaneCount", "pPlaneLayouts", structure->drmFormatModifierPlaneCount, &structure->pPlaneLayouts, true, true, kVUIDUndefined, "VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-pPlaneLayouts-parameter");

                if (structure->pPlaneLayouts != nullptr)
                {
                    for (uint32_t drmFormatModifierPlaneIndex = 0; drmFormatModifierPlaneIndex < structure->drmFormatModifierPlaneCount; ++drmFormatModifierPlaneIndex)
                    {
                    }
                }
            }
        } break;

        // No Validation code for VkDrmFormatModifierPropertiesList2EXT structure members  -- Covers VUID-VkDrmFormatModifierPropertiesList2EXT-sType-sType

        // Validation code for VkShaderModuleValidationCacheCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT: { // Covers VUID-VkShaderModuleValidationCacheCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkShaderModuleValidationCacheCreateInfoEXT *structure = (VkShaderModuleValidationCacheCreateInfoEXT *) header;
                skip |= ValidateRequiredHandle("VkShaderModuleValidationCacheCreateInfoEXT", "validationCache", structure->validationCache);
            }
        } break;

        // Validation code for VkPipelineViewportShadingRateImageStateCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV: { // Covers VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-sType-sType
            if (is_const_param) {
                VkPipelineViewportShadingRateImageStateCreateInfoNV *structure = (VkPipelineViewportShadingRateImageStateCreateInfoNV *) header;
                skip |= ValidateBool32("VkPipelineViewportShadingRateImageStateCreateInfoNV", "shadingRateImageEnable", structure->shadingRateImageEnable);
            }
        } break;

        // Validation code for VkPhysicalDeviceShadingRateImageFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceShadingRateImageFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceShadingRateImageFeaturesNV *structure = (VkPhysicalDeviceShadingRateImageFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShadingRateImageFeaturesNV", "shadingRateImage", structure->shadingRateImage);

                skip |= ValidateBool32("VkPhysicalDeviceShadingRateImageFeaturesNV", "shadingRateCoarseSampleOrder", structure->shadingRateCoarseSampleOrder);
            }
        } break;

        // No Validation code for VkPhysicalDeviceShadingRateImagePropertiesNV structure members  -- Covers VUID-VkPhysicalDeviceShadingRateImagePropertiesNV-sType-sType

        // Validation code for VkPipelineViewportCoarseSampleOrderStateCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV: { // Covers VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-sType-sType
            if (is_const_param) {
                VkPipelineViewportCoarseSampleOrderStateCreateInfoNV *structure = (VkPipelineViewportCoarseSampleOrderStateCreateInfoNV *) header;
                skip |= ValidateRangedEnum("VkPipelineViewportCoarseSampleOrderStateCreateInfoNV", "sampleOrderType", "VkCoarseSampleOrderTypeNV", AllVkCoarseSampleOrderTypeNVEnums, structure->sampleOrderType, "VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-sampleOrderType-parameter");

                skip |= ValidateArray("VkPipelineViewportCoarseSampleOrderStateCreateInfoNV", "customSampleOrderCount", "pCustomSampleOrders", structure->customSampleOrderCount, &structure->pCustomSampleOrders, false, true, kVUIDUndefined, "VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-pCustomSampleOrders-parameter");

                if (structure->pCustomSampleOrders != nullptr)
                {
                    for (uint32_t customSampleOrderIndex = 0; customSampleOrderIndex < structure->customSampleOrderCount; ++customSampleOrderIndex)
                    {
                        skip |= ValidateRangedEnum("VkPipelineViewportCoarseSampleOrderStateCreateInfoNV", ParameterName("pCustomSampleOrders[%i].shadingRate", ParameterName::IndexVector{ customSampleOrderIndex }), "VkShadingRatePaletteEntryNV", AllVkShadingRatePaletteEntryNVEnums, structure->pCustomSampleOrders[customSampleOrderIndex].shadingRate, "VUID-VkCoarseSampleOrderCustomNV-shadingRate-parameter");

                        skip |= ValidateArray("VkPipelineViewportCoarseSampleOrderStateCreateInfoNV", ParameterName("pCustomSampleOrders[%i].sampleLocationCount", ParameterName::IndexVector{ customSampleOrderIndex }), ParameterName("pCustomSampleOrders[%i].pSampleLocations", ParameterName::IndexVector{ customSampleOrderIndex }), structure->pCustomSampleOrders[customSampleOrderIndex].sampleLocationCount, &structure->pCustomSampleOrders[customSampleOrderIndex].pSampleLocations, true, true, "VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-arraylength", "VUID-VkCoarseSampleOrderCustomNV-pSampleLocations-parameter");

                        if (structure->pCustomSampleOrders[customSampleOrderIndex].pSampleLocations != nullptr)
                        {
                            for (uint32_t sampleLocationIndex = 0; sampleLocationIndex < structure->pCustomSampleOrders[customSampleOrderIndex].sampleLocationCount; ++sampleLocationIndex)
                            {
                            }
                        }
                    }
                }
            }
        } break;

        // Validation code for VkWriteDescriptorSetAccelerationStructureNV structure members
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV: { // Covers VUID-VkWriteDescriptorSetAccelerationStructureNV-sType-sType
            if (is_const_param) {
                VkWriteDescriptorSetAccelerationStructureNV *structure = (VkWriteDescriptorSetAccelerationStructureNV *) header;
                skip |= ValidateArray("VkWriteDescriptorSetAccelerationStructureNV", "accelerationStructureCount", "pAccelerationStructures", structure->accelerationStructureCount, &structure->pAccelerationStructures, true, false, "VUID-VkWriteDescriptorSetAccelerationStructureNV-accelerationStructureCount-arraylength", "VUID-VkWriteDescriptorSetAccelerationStructureNV-pAccelerationStructures-parameter");
            }
        } break;

        // No Validation code for VkPhysicalDeviceRayTracingPropertiesNV structure members  -- Covers VUID-VkPhysicalDeviceRayTracingPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV *structure = (VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV", "representativeFragmentTest", structure->representativeFragmentTest);
            }
        } break;

        // Validation code for VkPipelineRepresentativeFragmentTestStateCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV: { // Covers VUID-VkPipelineRepresentativeFragmentTestStateCreateInfoNV-sType-sType
            if (is_const_param) {
                VkPipelineRepresentativeFragmentTestStateCreateInfoNV *structure = (VkPipelineRepresentativeFragmentTestStateCreateInfoNV *) header;
                skip |= ValidateBool32("VkPipelineRepresentativeFragmentTestStateCreateInfoNV", "representativeFragmentTestEnable", structure->representativeFragmentTestEnable);
            }
        } break;

        // Validation code for VkPhysicalDeviceImageViewImageFormatInfoEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT: { // Covers VUID-VkPhysicalDeviceImageViewImageFormatInfoEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceImageViewImageFormatInfoEXT *structure = (VkPhysicalDeviceImageViewImageFormatInfoEXT *) header;
                skip |= ValidateRangedEnum("VkPhysicalDeviceImageViewImageFormatInfoEXT", "imageViewType", "VkImageViewType", AllVkImageViewTypeEnums, structure->imageViewType, "VUID-VkPhysicalDeviceImageViewImageFormatInfoEXT-imageViewType-parameter");
            }
        } break;

        // No Validation code for VkFilterCubicImageViewImageFormatPropertiesEXT structure members  -- Covers VUID-VkFilterCubicImageViewImageFormatPropertiesEXT-sType-sType

        // Validation code for VkImportMemoryHostPointerInfoEXT structure members
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT: { // Covers VUID-VkImportMemoryHostPointerInfoEXT-sType-sType
            if (is_const_param) {
                VkImportMemoryHostPointerInfoEXT *structure = (VkImportMemoryHostPointerInfoEXT *) header;
                skip |= ValidateFlags("VkImportMemoryHostPointerInfoEXT", "handleType", "VkExternalMemoryHandleTypeFlagBits", AllVkExternalMemoryHandleTypeFlagBits, structure->handleType, kRequiredSingleBit, "VUID-VkImportMemoryHostPointerInfoEXT-handleType-parameter", "VUID-VkImportMemoryHostPointerInfoEXT-handleType-parameter");

                skip |= ValidateRequiredPointer("VkImportMemoryHostPointerInfoEXT", "pHostPointer", structure->pHostPointer, kVUIDUndefined);
            }
        } break;

        // No Validation code for VkPhysicalDeviceExternalMemoryHostPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceExternalMemoryHostPropertiesEXT-sType-sType

        // Validation code for VkPipelineCompilerControlCreateInfoAMD structure members
        case VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD: { // Covers VUID-VkPipelineCompilerControlCreateInfoAMD-sType-sType
            if (is_const_param) {
                VkPipelineCompilerControlCreateInfoAMD *structure = (VkPipelineCompilerControlCreateInfoAMD *) header;
                skip |= ValidateReservedFlags("VkPipelineCompilerControlCreateInfoAMD", "compilerControlFlags", structure->compilerControlFlags, "VUID-VkPipelineCompilerControlCreateInfoAMD-compilerControlFlags-zerobitmask");
            }
        } break;

        // No Validation code for VkPhysicalDeviceShaderCorePropertiesAMD structure members  -- Covers VUID-VkPhysicalDeviceShaderCorePropertiesAMD-sType-sType

        // Validation code for VkDeviceMemoryOverallocationCreateInfoAMD structure members
        case VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD: { // Covers VUID-VkDeviceMemoryOverallocationCreateInfoAMD-sType-sType
            if (is_const_param) {
                VkDeviceMemoryOverallocationCreateInfoAMD *structure = (VkDeviceMemoryOverallocationCreateInfoAMD *) header;
                skip |= ValidateRangedEnum("VkDeviceMemoryOverallocationCreateInfoAMD", "overallocationBehavior", "VkMemoryOverallocationBehaviorAMD", AllVkMemoryOverallocationBehaviorAMDEnums, structure->overallocationBehavior, "VUID-VkDeviceMemoryOverallocationCreateInfoAMD-overallocationBehavior-parameter");
            }
        } break;

        // No Validation code for VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT-sType-sType

        // Validation code for VkPipelineVertexInputDivisorStateCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT: { // Covers VUID-VkPipelineVertexInputDivisorStateCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkPipelineVertexInputDivisorStateCreateInfoEXT *structure = (VkPipelineVertexInputDivisorStateCreateInfoEXT *) header;
                skip |= ValidateArray("VkPipelineVertexInputDivisorStateCreateInfoEXT", "vertexBindingDivisorCount", "pVertexBindingDivisors", structure->vertexBindingDivisorCount, &structure->pVertexBindingDivisors, true, true, "VUID-VkPipelineVertexInputDivisorStateCreateInfoEXT-vertexBindingDivisorCount-arraylength", "VUID-VkPipelineVertexInputDivisorStateCreateInfoEXT-pVertexBindingDivisors-parameter");

                if (structure->pVertexBindingDivisors != nullptr)
                {
                    for (uint32_t vertexBindingDivisorIndex = 0; vertexBindingDivisorIndex < structure->vertexBindingDivisorCount; ++vertexBindingDivisorIndex)
                    {
                    }
                }
            }
        } break;

        // Validation code for VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *structure = (VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT", "vertexAttributeInstanceRateDivisor", structure->vertexAttributeInstanceRateDivisor);

                skip |= ValidateBool32("VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT", "vertexAttributeInstanceRateZeroDivisor", structure->vertexAttributeInstanceRateZeroDivisor);
            }
        } break;

        // No Validation code for VkPresentFrameTokenGGP structure members  -- Covers VUID-VkPresentFrameTokenGGP-sType-sType

        // Validation code for VkPhysicalDeviceComputeShaderDerivativesFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceComputeShaderDerivativesFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceComputeShaderDerivativesFeaturesNV *structure = (VkPhysicalDeviceComputeShaderDerivativesFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceComputeShaderDerivativesFeaturesNV", "computeDerivativeGroupQuads", structure->computeDerivativeGroupQuads);

                skip |= ValidateBool32("VkPhysicalDeviceComputeShaderDerivativesFeaturesNV", "computeDerivativeGroupLinear", structure->computeDerivativeGroupLinear);
            }
        } break;

        // Validation code for VkPhysicalDeviceMeshShaderFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceMeshShaderFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceMeshShaderFeaturesNV *structure = (VkPhysicalDeviceMeshShaderFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceMeshShaderFeaturesNV", "taskShader", structure->taskShader);

                skip |= ValidateBool32("VkPhysicalDeviceMeshShaderFeaturesNV", "meshShader", structure->meshShader);
            }
        } break;

        // No Validation code for VkPhysicalDeviceMeshShaderPropertiesNV structure members  -- Covers VUID-VkPhysicalDeviceMeshShaderPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceShaderImageFootprintFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceShaderImageFootprintFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceShaderImageFootprintFeaturesNV *structure = (VkPhysicalDeviceShaderImageFootprintFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShaderImageFootprintFeaturesNV", "imageFootprint", structure->imageFootprint);
            }
        } break;

        // No Validation code for VkPipelineViewportExclusiveScissorStateCreateInfoNV structure members  -- Covers VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-sType-sType

        // Validation code for VkPhysicalDeviceExclusiveScissorFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceExclusiveScissorFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceExclusiveScissorFeaturesNV *structure = (VkPhysicalDeviceExclusiveScissorFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceExclusiveScissorFeaturesNV", "exclusiveScissor", structure->exclusiveScissor);
            }
        } break;

        // No Validation code for VkQueueFamilyCheckpointPropertiesNV structure members  -- Covers VUID-VkQueueFamilyCheckpointPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL: { // Covers VUID-VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL *structure = (VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL", "shaderIntegerFunctions2", structure->shaderIntegerFunctions2);
            }
        } break;

        // Validation code for VkQueryPoolPerformanceQueryCreateInfoINTEL structure members
        case VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL: { // Covers VUID-VkQueryPoolPerformanceQueryCreateInfoINTEL-sType-sType
            if (is_const_param) {
                VkQueryPoolPerformanceQueryCreateInfoINTEL *structure = (VkQueryPoolPerformanceQueryCreateInfoINTEL *) header;
                skip |= ValidateRangedEnum("VkQueryPoolPerformanceQueryCreateInfoINTEL", "performanceCountersSampling", "VkQueryPoolSamplingModeINTEL", AllVkQueryPoolSamplingModeINTELEnums, structure->performanceCountersSampling, "VUID-VkQueryPoolPerformanceQueryCreateInfoINTEL-performanceCountersSampling-parameter");
            }
        } break;

        // No Validation code for VkPhysicalDevicePCIBusInfoPropertiesEXT structure members  -- Covers VUID-VkPhysicalDevicePCIBusInfoPropertiesEXT-sType-sType

        // No Validation code for VkDisplayNativeHdrSurfaceCapabilitiesAMD structure members  -- Covers VUID-VkDisplayNativeHdrSurfaceCapabilitiesAMD-sType-sType

        // Validation code for VkSwapchainDisplayNativeHdrCreateInfoAMD structure members
        case VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD: { // Covers VUID-VkSwapchainDisplayNativeHdrCreateInfoAMD-sType-sType
            if (is_const_param) {
                VkSwapchainDisplayNativeHdrCreateInfoAMD *structure = (VkSwapchainDisplayNativeHdrCreateInfoAMD *) header;
                skip |= ValidateBool32("VkSwapchainDisplayNativeHdrCreateInfoAMD", "localDimmingEnable", structure->localDimmingEnable);
            }
        } break;

        // Validation code for VkPhysicalDeviceFragmentDensityMapFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceFragmentDensityMapFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceFragmentDensityMapFeaturesEXT *structure = (VkPhysicalDeviceFragmentDensityMapFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceFragmentDensityMapFeaturesEXT", "fragmentDensityMap", structure->fragmentDensityMap);

                skip |= ValidateBool32("VkPhysicalDeviceFragmentDensityMapFeaturesEXT", "fragmentDensityMapDynamic", structure->fragmentDensityMapDynamic);

                skip |= ValidateBool32("VkPhysicalDeviceFragmentDensityMapFeaturesEXT", "fragmentDensityMapNonSubsampledImages", structure->fragmentDensityMapNonSubsampledImages);
            }
        } break;

        // No Validation code for VkPhysicalDeviceFragmentDensityMapPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceFragmentDensityMapPropertiesEXT-sType-sType

        // Validation code for VkRenderPassFragmentDensityMapCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT: { // Covers VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkRenderPassFragmentDensityMapCreateInfoEXT *structure = (VkRenderPassFragmentDensityMapCreateInfoEXT *) header;
                skip |= ValidateRangedEnum("VkRenderPassFragmentDensityMapCreateInfoEXT", "fragmentDensityMapAttachment.layout", "VkImageLayout", AllVkImageLayoutEnums, structure->fragmentDensityMapAttachment.layout, "VUID-VkAttachmentReference-layout-parameter");
            }
        } break;

        // No Validation code for VkPhysicalDeviceShaderCoreProperties2AMD structure members  -- Covers VUID-VkPhysicalDeviceShaderCoreProperties2AMD-sType-sType

        // Validation code for VkPhysicalDeviceCoherentMemoryFeaturesAMD structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD: { // Covers VUID-VkPhysicalDeviceCoherentMemoryFeaturesAMD-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceCoherentMemoryFeaturesAMD *structure = (VkPhysicalDeviceCoherentMemoryFeaturesAMD *) header;
                skip |= ValidateBool32("VkPhysicalDeviceCoherentMemoryFeaturesAMD", "deviceCoherentMemory", structure->deviceCoherentMemory);
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *structure = (VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT", "shaderImageInt64Atomics", structure->shaderImageInt64Atomics);

                skip |= ValidateBool32("VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT", "sparseImageInt64Atomics", structure->sparseImageInt64Atomics);
            }
        } break;

        // No Validation code for VkPhysicalDeviceMemoryBudgetPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceMemoryBudgetPropertiesEXT-sType-sType

        // Validation code for VkPhysicalDeviceMemoryPriorityFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceMemoryPriorityFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceMemoryPriorityFeaturesEXT *structure = (VkPhysicalDeviceMemoryPriorityFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceMemoryPriorityFeaturesEXT", "memoryPriority", structure->memoryPriority);
            }
        } break;

        // No Validation code for VkMemoryPriorityAllocateInfoEXT structure members  -- Covers VUID-VkMemoryPriorityAllocateInfoEXT-sType-sType

        // Validation code for VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV *structure = (VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV", "dedicatedAllocationImageAliasing", structure->dedicatedAllocationImageAliasing);
            }
        } break;

        // Validation code for VkPhysicalDeviceBufferDeviceAddressFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceBufferDeviceAddressFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *structure = (VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceBufferDeviceAddressFeaturesEXT", "bufferDeviceAddress", structure->bufferDeviceAddress);

                skip |= ValidateBool32("VkPhysicalDeviceBufferDeviceAddressFeaturesEXT", "bufferDeviceAddressCaptureReplay", structure->bufferDeviceAddressCaptureReplay);

                skip |= ValidateBool32("VkPhysicalDeviceBufferDeviceAddressFeaturesEXT", "bufferDeviceAddressMultiDevice", structure->bufferDeviceAddressMultiDevice);
            }
        } break;

        // No Validation code for VkBufferDeviceAddressCreateInfoEXT structure members  -- Covers VUID-VkBufferDeviceAddressCreateInfoEXT-sType-sType

        // Validation code for VkValidationFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT: { // Covers VUID-VkValidationFeaturesEXT-sType-sType
            if (is_const_param) {
                VkValidationFeaturesEXT *structure = (VkValidationFeaturesEXT *) header;
                skip |= ValidateRangedEnumArray("VkValidationFeaturesEXT", "enabledValidationFeatureCount", "pEnabledValidationFeatures", "VkValidationFeatureEnableEXT", AllVkValidationFeatureEnableEXTEnums, structure->enabledValidationFeatureCount, structure->pEnabledValidationFeatures, false, true);

                skip |= ValidateRangedEnumArray("VkValidationFeaturesEXT", "disabledValidationFeatureCount", "pDisabledValidationFeatures", "VkValidationFeatureDisableEXT", AllVkValidationFeatureDisableEXTEnums, structure->disabledValidationFeatureCount, structure->pDisabledValidationFeatures, false, true);
            }
        } break;

        // Validation code for VkPhysicalDeviceCooperativeMatrixFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceCooperativeMatrixFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceCooperativeMatrixFeaturesNV *structure = (VkPhysicalDeviceCooperativeMatrixFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceCooperativeMatrixFeaturesNV", "cooperativeMatrix", structure->cooperativeMatrix);

                skip |= ValidateBool32("VkPhysicalDeviceCooperativeMatrixFeaturesNV", "cooperativeMatrixRobustBufferAccess", structure->cooperativeMatrixRobustBufferAccess);
            }
        } break;

        // No Validation code for VkPhysicalDeviceCooperativeMatrixPropertiesNV structure members  -- Covers VUID-VkPhysicalDeviceCooperativeMatrixPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceCoverageReductionModeFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceCoverageReductionModeFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceCoverageReductionModeFeaturesNV *structure = (VkPhysicalDeviceCoverageReductionModeFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceCoverageReductionModeFeaturesNV", "coverageReductionMode", structure->coverageReductionMode);
            }
        } break;

        // Validation code for VkPipelineCoverageReductionStateCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV: { // Covers VUID-VkPipelineCoverageReductionStateCreateInfoNV-sType-sType
            if (is_const_param) {
                VkPipelineCoverageReductionStateCreateInfoNV *structure = (VkPipelineCoverageReductionStateCreateInfoNV *) header;
                skip |= ValidateReservedFlags("VkPipelineCoverageReductionStateCreateInfoNV", "flags", structure->flags, "VUID-VkPipelineCoverageReductionStateCreateInfoNV-flags-zerobitmask");

                skip |= ValidateRangedEnum("VkPipelineCoverageReductionStateCreateInfoNV", "coverageReductionMode", "VkCoverageReductionModeNV", AllVkCoverageReductionModeNVEnums, structure->coverageReductionMode, "VUID-VkPipelineCoverageReductionStateCreateInfoNV-coverageReductionMode-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *structure = (VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT", "fragmentShaderSampleInterlock", structure->fragmentShaderSampleInterlock);

                skip |= ValidateBool32("VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT", "fragmentShaderPixelInterlock", structure->fragmentShaderPixelInterlock);

                skip |= ValidateBool32("VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT", "fragmentShaderShadingRateInterlock", structure->fragmentShaderShadingRateInterlock);
            }
        } break;

        // Validation code for VkPhysicalDeviceYcbcrImageArraysFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceYcbcrImageArraysFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *structure = (VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceYcbcrImageArraysFeaturesEXT", "ycbcrImageArrays", structure->ycbcrImageArrays);
            }
        } break;

        // Validation code for VkPhysicalDeviceProvokingVertexFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceProvokingVertexFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceProvokingVertexFeaturesEXT *structure = (VkPhysicalDeviceProvokingVertexFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceProvokingVertexFeaturesEXT", "provokingVertexLast", structure->provokingVertexLast);

                skip |= ValidateBool32("VkPhysicalDeviceProvokingVertexFeaturesEXT", "transformFeedbackPreservesProvokingVertex", structure->transformFeedbackPreservesProvokingVertex);
            }
        } break;

        // No Validation code for VkPhysicalDeviceProvokingVertexPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceProvokingVertexPropertiesEXT-sType-sType

        // Validation code for VkPipelineRasterizationProvokingVertexStateCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT: { // Covers VUID-VkPipelineRasterizationProvokingVertexStateCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkPipelineRasterizationProvokingVertexStateCreateInfoEXT *structure = (VkPipelineRasterizationProvokingVertexStateCreateInfoEXT *) header;
                skip |= ValidateRangedEnum("VkPipelineRasterizationProvokingVertexStateCreateInfoEXT", "provokingVertexMode", "VkProvokingVertexModeEXT", AllVkProvokingVertexModeEXTEnums, structure->provokingVertexMode, "VUID-VkPipelineRasterizationProvokingVertexStateCreateInfoEXT-provokingVertexMode-parameter");
            }
        } break;

#ifdef VK_USE_PLATFORM_WIN32_KHR
        // Validation code for VkSurfaceFullScreenExclusiveInfoEXT structure members
        case VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT: { // Covers VUID-VkSurfaceFullScreenExclusiveInfoEXT-sType-sType
            if (is_const_param) {
                VkSurfaceFullScreenExclusiveInfoEXT *structure = (VkSurfaceFullScreenExclusiveInfoEXT *) header;
                skip |= ValidateRangedEnum("VkSurfaceFullScreenExclusiveInfoEXT", "fullScreenExclusive", "VkFullScreenExclusiveEXT", AllVkFullScreenExclusiveEXTEnums, structure->fullScreenExclusive, "VUID-VkSurfaceFullScreenExclusiveInfoEXT-fullScreenExclusive-parameter");
            }
        } break;
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR
        // Validation code for VkSurfaceCapabilitiesFullScreenExclusiveEXT structure members
        case VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT: { // Covers VUID-VkSurfaceCapabilitiesFullScreenExclusiveEXT-sType-sType
            if (is_const_param) {
                VkSurfaceCapabilitiesFullScreenExclusiveEXT *structure = (VkSurfaceCapabilitiesFullScreenExclusiveEXT *) header;
                skip |= ValidateBool32("VkSurfaceCapabilitiesFullScreenExclusiveEXT", "fullScreenExclusiveSupported", structure->fullScreenExclusiveSupported);
            }
        } break;
#endif // VK_USE_PLATFORM_WIN32_KHR

        // No Validation code for VkSurfaceFullScreenExclusiveWin32InfoEXT structure members  -- Covers VUID-VkSurfaceFullScreenExclusiveWin32InfoEXT-sType-sType

        // Validation code for VkPhysicalDeviceLineRasterizationFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceLineRasterizationFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceLineRasterizationFeaturesEXT *structure = (VkPhysicalDeviceLineRasterizationFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceLineRasterizationFeaturesEXT", "rectangularLines", structure->rectangularLines);

                skip |= ValidateBool32("VkPhysicalDeviceLineRasterizationFeaturesEXT", "bresenhamLines", structure->bresenhamLines);

                skip |= ValidateBool32("VkPhysicalDeviceLineRasterizationFeaturesEXT", "smoothLines", structure->smoothLines);

                skip |= ValidateBool32("VkPhysicalDeviceLineRasterizationFeaturesEXT", "stippledRectangularLines", structure->stippledRectangularLines);

                skip |= ValidateBool32("VkPhysicalDeviceLineRasterizationFeaturesEXT", "stippledBresenhamLines", structure->stippledBresenhamLines);

                skip |= ValidateBool32("VkPhysicalDeviceLineRasterizationFeaturesEXT", "stippledSmoothLines", structure->stippledSmoothLines);
            }
        } break;

        // No Validation code for VkPhysicalDeviceLineRasterizationPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceLineRasterizationPropertiesEXT-sType-sType

        // Validation code for VkPipelineRasterizationLineStateCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT: { // Covers VUID-VkPipelineRasterizationLineStateCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkPipelineRasterizationLineStateCreateInfoEXT *structure = (VkPipelineRasterizationLineStateCreateInfoEXT *) header;
                skip |= ValidateRangedEnum("VkPipelineRasterizationLineStateCreateInfoEXT", "lineRasterizationMode", "VkLineRasterizationModeEXT", AllVkLineRasterizationModeEXTEnums, structure->lineRasterizationMode, "VUID-VkPipelineRasterizationLineStateCreateInfoEXT-lineRasterizationMode-parameter");

                skip |= ValidateBool32("VkPipelineRasterizationLineStateCreateInfoEXT", "stippledLineEnable", structure->stippledLineEnable);
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderAtomicFloatFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceShaderAtomicFloatFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *structure = (VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloatFeaturesEXT", "shaderBufferFloat32Atomics", structure->shaderBufferFloat32Atomics);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloatFeaturesEXT", "shaderBufferFloat32AtomicAdd", structure->shaderBufferFloat32AtomicAdd);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloatFeaturesEXT", "shaderBufferFloat64Atomics", structure->shaderBufferFloat64Atomics);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloatFeaturesEXT", "shaderBufferFloat64AtomicAdd", structure->shaderBufferFloat64AtomicAdd);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloatFeaturesEXT", "shaderSharedFloat32Atomics", structure->shaderSharedFloat32Atomics);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloatFeaturesEXT", "shaderSharedFloat32AtomicAdd", structure->shaderSharedFloat32AtomicAdd);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloatFeaturesEXT", "shaderSharedFloat64Atomics", structure->shaderSharedFloat64Atomics);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloatFeaturesEXT", "shaderSharedFloat64AtomicAdd", structure->shaderSharedFloat64AtomicAdd);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloatFeaturesEXT", "shaderImageFloat32Atomics", structure->shaderImageFloat32Atomics);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloatFeaturesEXT", "shaderImageFloat32AtomicAdd", structure->shaderImageFloat32AtomicAdd);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloatFeaturesEXT", "sparseImageFloat32Atomics", structure->sparseImageFloat32Atomics);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloatFeaturesEXT", "sparseImageFloat32AtomicAdd", structure->sparseImageFloat32AtomicAdd);
            }
        } break;

        // Validation code for VkPhysicalDeviceIndexTypeUint8FeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceIndexTypeUint8FeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceIndexTypeUint8FeaturesEXT *structure = (VkPhysicalDeviceIndexTypeUint8FeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceIndexTypeUint8FeaturesEXT", "indexTypeUint8", structure->indexTypeUint8);
            }
        } break;

        // Validation code for VkPhysicalDeviceExtendedDynamicStateFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceExtendedDynamicStateFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *structure = (VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicStateFeaturesEXT", "extendedDynamicState", structure->extendedDynamicState);
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *structure = (VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT", "shaderBufferFloat16Atomics", structure->shaderBufferFloat16Atomics);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT", "shaderBufferFloat16AtomicAdd", structure->shaderBufferFloat16AtomicAdd);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT", "shaderBufferFloat16AtomicMinMax", structure->shaderBufferFloat16AtomicMinMax);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT", "shaderBufferFloat32AtomicMinMax", structure->shaderBufferFloat32AtomicMinMax);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT", "shaderBufferFloat64AtomicMinMax", structure->shaderBufferFloat64AtomicMinMax);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT", "shaderSharedFloat16Atomics", structure->shaderSharedFloat16Atomics);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT", "shaderSharedFloat16AtomicAdd", structure->shaderSharedFloat16AtomicAdd);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT", "shaderSharedFloat16AtomicMinMax", structure->shaderSharedFloat16AtomicMinMax);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT", "shaderSharedFloat32AtomicMinMax", structure->shaderSharedFloat32AtomicMinMax);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT", "shaderSharedFloat64AtomicMinMax", structure->shaderSharedFloat64AtomicMinMax);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT", "shaderImageFloat32AtomicMinMax", structure->shaderImageFloat32AtomicMinMax);

                skip |= ValidateBool32("VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT", "sparseImageFloat32AtomicMinMax", structure->sparseImageFloat32AtomicMinMax);
            }
        } break;

        // Validation code for VkSurfacePresentModeEXT structure members
        case VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_EXT: { // Covers VUID-VkSurfacePresentModeEXT-sType-sType
            if (is_const_param) {
                VkSurfacePresentModeEXT *structure = (VkSurfacePresentModeEXT *) header;
                skip |= ValidateRangedEnum("VkSurfacePresentModeEXT", "presentMode", "VkPresentModeKHR", AllVkPresentModeKHREnums, structure->presentMode, "VUID-VkSurfacePresentModeEXT-presentMode-parameter");
            }
        } break;

        // Validation code for VkSurfacePresentScalingCapabilitiesEXT structure members
        case VK_STRUCTURE_TYPE_SURFACE_PRESENT_SCALING_CAPABILITIES_EXT: { // Covers VUID-VkSurfacePresentScalingCapabilitiesEXT-sType-sType
            if (is_const_param) {
                VkSurfacePresentScalingCapabilitiesEXT *structure = (VkSurfacePresentScalingCapabilitiesEXT *) header;
                skip |= ValidateFlags("VkSurfacePresentScalingCapabilitiesEXT", "supportedPresentScaling", "VkPresentScalingFlagBitsEXT", AllVkPresentScalingFlagBitsEXT, structure->supportedPresentScaling, kOptionalFlags, "VUID-VkSurfacePresentScalingCapabilitiesEXT-supportedPresentScaling-parameter");

                skip |= ValidateFlags("VkSurfacePresentScalingCapabilitiesEXT", "supportedPresentGravityX", "VkPresentGravityFlagBitsEXT", AllVkPresentGravityFlagBitsEXT, structure->supportedPresentGravityX, kOptionalFlags, "VUID-VkSurfacePresentScalingCapabilitiesEXT-supportedPresentGravityX-parameter");

                skip |= ValidateFlags("VkSurfacePresentScalingCapabilitiesEXT", "supportedPresentGravityY", "VkPresentGravityFlagBitsEXT", AllVkPresentGravityFlagBitsEXT, structure->supportedPresentGravityY, kOptionalFlags, "VUID-VkSurfacePresentScalingCapabilitiesEXT-supportedPresentGravityY-parameter");

            }
        } break;

        // No Validation code for VkSurfacePresentModeCompatibilityEXT structure members  -- Covers VUID-VkSurfacePresentModeCompatibilityEXT-sType-sType

        // Validation code for VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT *structure = (VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT", "swapchainMaintenance1", structure->swapchainMaintenance1);
            }
        } break;

        // Validation code for VkSwapchainPresentFenceInfoEXT structure members
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_FENCE_INFO_EXT: { // Covers VUID-VkSwapchainPresentFenceInfoEXT-sType-sType
            if (is_const_param) {
                VkSwapchainPresentFenceInfoEXT *structure = (VkSwapchainPresentFenceInfoEXT *) header;
                skip |= ValidateHandleArray("VkSwapchainPresentFenceInfoEXT", "swapchainCount", "pFences", structure->swapchainCount, structure->pFences, true, true, kVUIDUndefined);
            }
        } break;

        // Validation code for VkSwapchainPresentModesCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_EXT: { // Covers VUID-VkSwapchainPresentModesCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkSwapchainPresentModesCreateInfoEXT *structure = (VkSwapchainPresentModesCreateInfoEXT *) header;
                skip |= ValidateRangedEnumArray("VkSwapchainPresentModesCreateInfoEXT", "presentModeCount", "pPresentModes", "VkPresentModeKHR", AllVkPresentModeKHREnums, structure->presentModeCount, structure->pPresentModes, true, true);
            }
        } break;

        // Validation code for VkSwapchainPresentModeInfoEXT structure members
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODE_INFO_EXT: { // Covers VUID-VkSwapchainPresentModeInfoEXT-sType-sType
            if (is_const_param) {
                VkSwapchainPresentModeInfoEXT *structure = (VkSwapchainPresentModeInfoEXT *) header;
                skip |= ValidateRangedEnumArray("VkSwapchainPresentModeInfoEXT", "swapchainCount", "pPresentModes", "VkPresentModeKHR", AllVkPresentModeKHREnums, structure->swapchainCount, structure->pPresentModes, true, true);
            }
        } break;

        // Validation code for VkSwapchainPresentScalingCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_EXT: { // Covers VUID-VkSwapchainPresentScalingCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkSwapchainPresentScalingCreateInfoEXT *structure = (VkSwapchainPresentScalingCreateInfoEXT *) header;
                skip |= ValidateFlags("VkSwapchainPresentScalingCreateInfoEXT", "scalingBehavior", "VkPresentScalingFlagBitsEXT", AllVkPresentScalingFlagBitsEXT, structure->scalingBehavior, kOptionalFlags, "VUID-VkSwapchainPresentScalingCreateInfoEXT-scalingBehavior-parameter");

                skip |= ValidateFlags("VkSwapchainPresentScalingCreateInfoEXT", "presentGravityX", "VkPresentGravityFlagBitsEXT", AllVkPresentGravityFlagBitsEXT, structure->presentGravityX, kOptionalFlags, "VUID-VkSwapchainPresentScalingCreateInfoEXT-presentGravityX-parameter");

                skip |= ValidateFlags("VkSwapchainPresentScalingCreateInfoEXT", "presentGravityY", "VkPresentGravityFlagBitsEXT", AllVkPresentGravityFlagBitsEXT, structure->presentGravityY, kOptionalFlags, "VUID-VkSwapchainPresentScalingCreateInfoEXT-presentGravityY-parameter");
            }
        } break;

        // No Validation code for VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV structure members  -- Covers VUID-VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV *structure = (VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV", "deviceGeneratedCommands", structure->deviceGeneratedCommands);
            }
        } break;

        // Validation code for VkGraphicsPipelineShaderGroupsCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV: { // Covers VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-sType-sType
            if (is_const_param) {
                VkGraphicsPipelineShaderGroupsCreateInfoNV *structure = (VkGraphicsPipelineShaderGroupsCreateInfoNV *) header;
                skip |= ValidateStructTypeArray("VkGraphicsPipelineShaderGroupsCreateInfoNV", "groupCount", "pGroups", "VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV", structure->groupCount, structure->pGroups, VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV, false, true, "VUID-VkGraphicsShaderGroupCreateInfoNV-sType-sType", "VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-parameter", kVUIDUndefined);

                if (structure->pGroups != nullptr)
                {
                    for (uint32_t groupIndex = 0; groupIndex < structure->groupCount; ++groupIndex)
                    {
                        skip |= ValidateStructTypeArray("VkGraphicsPipelineShaderGroupsCreateInfoNV", ParameterName("pGroups[%i].stageCount", ParameterName::IndexVector{ groupIndex }), ParameterName("pGroups[%i].pStages", ParameterName::IndexVector{ groupIndex }), "VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO", structure->pGroups[groupIndex].stageCount, structure->pGroups[groupIndex].pStages, VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO, true, true, "VUID-VkPipelineShaderStageCreateInfo-sType-sType", "VUID-VkGraphicsShaderGroupCreateInfoNV-pStages-parameter", "VUID-VkGraphicsShaderGroupCreateInfoNV-stageCount-arraylength");

                        if (structure->pGroups[groupIndex].pStages != nullptr)
                        {
                            for (uint32_t stageIndex = 0; stageIndex < structure->pGroups[groupIndex].stageCount; ++stageIndex)
                            {
                                skip |= ValidateFlags("VkGraphicsPipelineShaderGroupsCreateInfoNV", ParameterName("pGroups[%i].pStages[%i].flags", ParameterName::IndexVector{ groupIndex, stageIndex }), "VkPipelineShaderStageCreateFlagBits", AllVkPipelineShaderStageCreateFlagBits, structure->pGroups[groupIndex].pStages[stageIndex].flags, kOptionalFlags, "VUID-VkPipelineShaderStageCreateInfo-flags-parameter");

                                skip |= ValidateFlags("VkGraphicsPipelineShaderGroupsCreateInfoNV", ParameterName("pGroups[%i].pStages[%i].stage", ParameterName::IndexVector{ groupIndex, stageIndex }), "VkShaderStageFlagBits", AllVkShaderStageFlagBits, structure->pGroups[groupIndex].pStages[stageIndex].stage, kRequiredSingleBit, "VUID-VkPipelineShaderStageCreateInfo-stage-parameter", "VUID-VkPipelineShaderStageCreateInfo-stage-parameter");

                                skip |= ValidateRequiredPointer("VkGraphicsPipelineShaderGroupsCreateInfoNV", ParameterName("pGroups[%i].pStages[%i].pName", ParameterName::IndexVector{ groupIndex, stageIndex }), structure->pGroups[groupIndex].pStages[stageIndex].pName, "VUID-VkPipelineShaderStageCreateInfo-pName-parameter");

                                if (structure->pGroups[groupIndex].pStages[stageIndex].pSpecializationInfo != nullptr)
                                {
                                    skip |= ValidateArray("VkGraphicsPipelineShaderGroupsCreateInfoNV", ParameterName("pGroups[%i].pStages[%i].pSpecializationInfo->mapEntryCount", ParameterName::IndexVector{ groupIndex, stageIndex }), ParameterName("pGroups[%i].pStages[%i].pSpecializationInfo->pMapEntries", ParameterName::IndexVector{ groupIndex, stageIndex }), structure->pGroups[groupIndex].pStages[stageIndex].pSpecializationInfo->mapEntryCount, &structure->pGroups[groupIndex].pStages[stageIndex].pSpecializationInfo->pMapEntries, false, true, kVUIDUndefined, "VUID-VkSpecializationInfo-pMapEntries-parameter");

                                    if (structure->pGroups[groupIndex].pStages[stageIndex].pSpecializationInfo->pMapEntries != nullptr)
                                    {
                                        for (uint32_t mapEntryIndex = 0; mapEntryIndex < structure->pGroups[groupIndex].pStages[stageIndex].pSpecializationInfo->mapEntryCount; ++mapEntryIndex)
                                        {
                                        }
                                    }

                                    skip |= ValidateArray("VkGraphicsPipelineShaderGroupsCreateInfoNV", ParameterName("pGroups[%i].pStages[%i].pSpecializationInfo->dataSize", ParameterName::IndexVector{ groupIndex, stageIndex }), ParameterName("pGroups[%i].pStages[%i].pSpecializationInfo->pData", ParameterName::IndexVector{ groupIndex, stageIndex }), structure->pGroups[groupIndex].pStages[stageIndex].pSpecializationInfo->dataSize, &structure->pGroups[groupIndex].pStages[stageIndex].pSpecializationInfo->pData, false, true, kVUIDUndefined, "VUID-VkSpecializationInfo-pData-parameter");
                                }
                            }
                        }
                    }
                }

                skip |= ValidateArray("VkGraphicsPipelineShaderGroupsCreateInfoNV", "pipelineCount", "pPipelines", structure->pipelineCount, &structure->pPipelines, false, true, kVUIDUndefined, "VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pPipelines-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceInheritedViewportScissorFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceInheritedViewportScissorFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceInheritedViewportScissorFeaturesNV *structure = (VkPhysicalDeviceInheritedViewportScissorFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceInheritedViewportScissorFeaturesNV", "inheritedViewportScissor2D", structure->inheritedViewportScissor2D);
            }
        } break;

        // Validation code for VkCommandBufferInheritanceViewportScissorInfoNV structure members
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV: { // Covers VUID-VkCommandBufferInheritanceViewportScissorInfoNV-sType-sType
            if (is_const_param) {
                VkCommandBufferInheritanceViewportScissorInfoNV *structure = (VkCommandBufferInheritanceViewportScissorInfoNV *) header;
                skip |= ValidateBool32("VkCommandBufferInheritanceViewportScissorInfoNV", "viewportScissor2D", structure->viewportScissor2D);
            }
        } break;

        // Validation code for VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *structure = (VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT", "texelBufferAlignment", structure->texelBufferAlignment);
            }
        } break;

        // No Validation code for VkRenderPassTransformBeginInfoQCOM structure members  -- Covers VUID-VkRenderPassTransformBeginInfoQCOM-sType-sType

        // No Validation code for VkCommandBufferInheritanceRenderPassTransformInfoQCOM structure members  -- Covers VUID-VkCommandBufferInheritanceRenderPassTransformInfoQCOM-sType-sType

        // Validation code for VkPhysicalDeviceDeviceMemoryReportFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceDeviceMemoryReportFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceDeviceMemoryReportFeaturesEXT *structure = (VkPhysicalDeviceDeviceMemoryReportFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceDeviceMemoryReportFeaturesEXT", "deviceMemoryReport", structure->deviceMemoryReport);
            }
        } break;

        // Validation code for VkDeviceDeviceMemoryReportCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT: { // Covers VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkDeviceDeviceMemoryReportCreateInfoEXT *structure = (VkDeviceDeviceMemoryReportCreateInfoEXT *) header;
                skip |= ValidateReservedFlags("VkDeviceDeviceMemoryReportCreateInfoEXT", "flags", structure->flags, "VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-flags-zerobitmask");

                skip |= ValidateRequiredPointer("VkDeviceDeviceMemoryReportCreateInfoEXT", "pfnUserCallback", reinterpret_cast<const void*>(structure->pfnUserCallback), "VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-pfnUserCallback-parameter");

                skip |= ValidateRequiredPointer("VkDeviceDeviceMemoryReportCreateInfoEXT", "pUserData", structure->pUserData, "VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-pUserData-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceRobustness2FeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceRobustness2FeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceRobustness2FeaturesEXT *structure = (VkPhysicalDeviceRobustness2FeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceRobustness2FeaturesEXT", "robustBufferAccess2", structure->robustBufferAccess2);

                skip |= ValidateBool32("VkPhysicalDeviceRobustness2FeaturesEXT", "robustImageAccess2", structure->robustImageAccess2);

                skip |= ValidateBool32("VkPhysicalDeviceRobustness2FeaturesEXT", "nullDescriptor", structure->nullDescriptor);
            }
        } break;

        // No Validation code for VkPhysicalDeviceRobustness2PropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceRobustness2PropertiesEXT-sType-sType

        // Validation code for VkSamplerCustomBorderColorCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT: { // Covers VUID-VkSamplerCustomBorderColorCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkSamplerCustomBorderColorCreateInfoEXT *structure = (VkSamplerCustomBorderColorCreateInfoEXT *) header;
                skip |= ValidateRangedEnum("VkSamplerCustomBorderColorCreateInfoEXT", "format", "VkFormat", AllVkFormatEnums, structure->format, "VUID-VkSamplerCustomBorderColorCreateInfoEXT-format-parameter");
            }
        } break;

        // No Validation code for VkPhysicalDeviceCustomBorderColorPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceCustomBorderColorPropertiesEXT-sType-sType

        // Validation code for VkPhysicalDeviceCustomBorderColorFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceCustomBorderColorFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceCustomBorderColorFeaturesEXT *structure = (VkPhysicalDeviceCustomBorderColorFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceCustomBorderColorFeaturesEXT", "customBorderColors", structure->customBorderColors);

                skip |= ValidateBool32("VkPhysicalDeviceCustomBorderColorFeaturesEXT", "customBorderColorWithoutFormat", structure->customBorderColorWithoutFormat);
            }
        } break;

        // Validation code for VkPhysicalDevicePresentBarrierFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_BARRIER_FEATURES_NV: { // Covers VUID-VkPhysicalDevicePresentBarrierFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDevicePresentBarrierFeaturesNV *structure = (VkPhysicalDevicePresentBarrierFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDevicePresentBarrierFeaturesNV", "presentBarrier", structure->presentBarrier);
            }
        } break;

        // Validation code for VkSurfaceCapabilitiesPresentBarrierNV structure members
        case VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_PRESENT_BARRIER_NV: { // Covers VUID-VkSurfaceCapabilitiesPresentBarrierNV-sType-sType
            if (is_const_param) {
                VkSurfaceCapabilitiesPresentBarrierNV *structure = (VkSurfaceCapabilitiesPresentBarrierNV *) header;
                skip |= ValidateBool32("VkSurfaceCapabilitiesPresentBarrierNV", "presentBarrierSupported", structure->presentBarrierSupported);
            }
        } break;

        // Validation code for VkSwapchainPresentBarrierCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_BARRIER_CREATE_INFO_NV: { // Covers VUID-VkSwapchainPresentBarrierCreateInfoNV-sType-sType
            if (is_const_param) {
                VkSwapchainPresentBarrierCreateInfoNV *structure = (VkSwapchainPresentBarrierCreateInfoNV *) header;
                skip |= ValidateBool32("VkSwapchainPresentBarrierCreateInfoNV", "presentBarrierEnable", structure->presentBarrierEnable);
            }
        } break;

        // Validation code for VkPhysicalDeviceDiagnosticsConfigFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceDiagnosticsConfigFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceDiagnosticsConfigFeaturesNV *structure = (VkPhysicalDeviceDiagnosticsConfigFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceDiagnosticsConfigFeaturesNV", "diagnosticsConfig", structure->diagnosticsConfig);
            }
        } break;

        // Validation code for VkDeviceDiagnosticsConfigCreateInfoNV structure members
        case VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV: { // Covers VUID-VkDeviceDiagnosticsConfigCreateInfoNV-sType-sType
            if (is_const_param) {
                VkDeviceDiagnosticsConfigCreateInfoNV *structure = (VkDeviceDiagnosticsConfigCreateInfoNV *) header;
                skip |= ValidateFlags("VkDeviceDiagnosticsConfigCreateInfoNV", "flags", "VkDeviceDiagnosticsConfigFlagBitsNV", AllVkDeviceDiagnosticsConfigFlagBitsNV, structure->flags, kOptionalFlags, "VUID-VkDeviceDiagnosticsConfigCreateInfoNV-flags-parameter");
            }
        } break;

#ifdef VK_USE_PLATFORM_METAL_EXT
        // Validation code for VkExportMetalObjectCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT: { // Covers VUID-VkExportMetalObjectCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkExportMetalObjectCreateInfoEXT *structure = (VkExportMetalObjectCreateInfoEXT *) header;
                skip |= ValidateFlags("VkExportMetalObjectCreateInfoEXT", "exportObjectType", "VkExportMetalObjectTypeFlagBitsEXT", AllVkExportMetalObjectTypeFlagBitsEXT, structure->exportObjectType, kOptionalSingleBit, "VUID-VkExportMetalObjectCreateInfoEXT-exportObjectType-parameter");
            }
        } break;
#endif // VK_USE_PLATFORM_METAL_EXT

        // No Validation code for VkExportMetalDeviceInfoEXT structure members  -- Covers VUID-VkExportMetalDeviceInfoEXT-sType-sType

#ifdef VK_USE_PLATFORM_METAL_EXT
        // Validation code for VkExportMetalCommandQueueInfoEXT structure members
        case VK_STRUCTURE_TYPE_EXPORT_METAL_COMMAND_QUEUE_INFO_EXT: { // Covers VUID-VkExportMetalCommandQueueInfoEXT-sType-sType
            if (is_const_param) {
                VkExportMetalCommandQueueInfoEXT *structure = (VkExportMetalCommandQueueInfoEXT *) header;
                skip |= ValidateRequiredHandle("VkExportMetalCommandQueueInfoEXT", "queue", structure->queue);
            }
        } break;
#endif // VK_USE_PLATFORM_METAL_EXT

#ifdef VK_USE_PLATFORM_METAL_EXT
        // Validation code for VkExportMetalBufferInfoEXT structure members
        case VK_STRUCTURE_TYPE_EXPORT_METAL_BUFFER_INFO_EXT: { // Covers VUID-VkExportMetalBufferInfoEXT-sType-sType
            if (is_const_param) {
                VkExportMetalBufferInfoEXT *structure = (VkExportMetalBufferInfoEXT *) header;
                skip |= ValidateRequiredHandle("VkExportMetalBufferInfoEXT", "memory", structure->memory);
            }
        } break;
#endif // VK_USE_PLATFORM_METAL_EXT

        // No Validation code for VkImportMetalBufferInfoEXT structure members  -- Covers VUID-VkImportMetalBufferInfoEXT-sType-sType

#ifdef VK_USE_PLATFORM_METAL_EXT
        // Validation code for VkExportMetalTextureInfoEXT structure members
        case VK_STRUCTURE_TYPE_EXPORT_METAL_TEXTURE_INFO_EXT: { // Covers VUID-VkExportMetalTextureInfoEXT-sType-sType
            if (is_const_param) {
                VkExportMetalTextureInfoEXT *structure = (VkExportMetalTextureInfoEXT *) header;
                skip |= ValidateFlags("VkExportMetalTextureInfoEXT", "plane", "VkImageAspectFlagBits", AllVkImageAspectFlagBits, structure->plane, kRequiredSingleBit, "VUID-VkExportMetalTextureInfoEXT-plane-parameter", "VUID-VkExportMetalTextureInfoEXT-plane-parameter");
            }
        } break;
#endif // VK_USE_PLATFORM_METAL_EXT

#ifdef VK_USE_PLATFORM_METAL_EXT
        // Validation code for VkImportMetalTextureInfoEXT structure members
        case VK_STRUCTURE_TYPE_IMPORT_METAL_TEXTURE_INFO_EXT: { // Covers VUID-VkImportMetalTextureInfoEXT-sType-sType
            if (is_const_param) {
                VkImportMetalTextureInfoEXT *structure = (VkImportMetalTextureInfoEXT *) header;
                skip |= ValidateFlags("VkImportMetalTextureInfoEXT", "plane", "VkImageAspectFlagBits", AllVkImageAspectFlagBits, structure->plane, kRequiredSingleBit, "VUID-VkImportMetalTextureInfoEXT-plane-parameter", "VUID-VkImportMetalTextureInfoEXT-plane-parameter");
            }
        } break;
#endif // VK_USE_PLATFORM_METAL_EXT

#ifdef VK_USE_PLATFORM_METAL_EXT
        // Validation code for VkExportMetalIOSurfaceInfoEXT structure members
        case VK_STRUCTURE_TYPE_EXPORT_METAL_IO_SURFACE_INFO_EXT: { // Covers VUID-VkExportMetalIOSurfaceInfoEXT-sType-sType
            if (is_const_param) {
                VkExportMetalIOSurfaceInfoEXT *structure = (VkExportMetalIOSurfaceInfoEXT *) header;
                skip |= ValidateRequiredHandle("VkExportMetalIOSurfaceInfoEXT", "image", structure->image);
            }
        } break;
#endif // VK_USE_PLATFORM_METAL_EXT

        // No Validation code for VkImportMetalIOSurfaceInfoEXT structure members  -- Covers VUID-VkImportMetalIOSurfaceInfoEXT-sType-sType

        // No Validation code for VkExportMetalSharedEventInfoEXT structure members  -- Covers VUID-VkExportMetalSharedEventInfoEXT-sType-sType

        // No Validation code for VkImportMetalSharedEventInfoEXT structure members  -- Covers VUID-VkImportMetalSharedEventInfoEXT-sType-sType

        // No Validation code for VkPhysicalDeviceDescriptorBufferPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceDescriptorBufferPropertiesEXT-sType-sType

        // No Validation code for VkPhysicalDeviceDescriptorBufferDensityMapPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceDescriptorBufferDensityMapPropertiesEXT-sType-sType

        // Validation code for VkPhysicalDeviceDescriptorBufferFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceDescriptorBufferFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceDescriptorBufferFeaturesEXT *structure = (VkPhysicalDeviceDescriptorBufferFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceDescriptorBufferFeaturesEXT", "descriptorBuffer", structure->descriptorBuffer);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorBufferFeaturesEXT", "descriptorBufferCaptureReplay", structure->descriptorBufferCaptureReplay);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorBufferFeaturesEXT", "descriptorBufferImageLayoutIgnored", structure->descriptorBufferImageLayoutIgnored);

                skip |= ValidateBool32("VkPhysicalDeviceDescriptorBufferFeaturesEXT", "descriptorBufferPushDescriptors", structure->descriptorBufferPushDescriptors);
            }
        } break;

        // Validation code for VkDescriptorBufferBindingPushDescriptorBufferHandleEXT structure members
        case VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_PUSH_DESCRIPTOR_BUFFER_HANDLE_EXT: { // Covers VUID-VkDescriptorBufferBindingPushDescriptorBufferHandleEXT-sType-sType
            if (is_const_param) {
                VkDescriptorBufferBindingPushDescriptorBufferHandleEXT *structure = (VkDescriptorBufferBindingPushDescriptorBufferHandleEXT *) header;
                skip |= ValidateRequiredHandle("VkDescriptorBufferBindingPushDescriptorBufferHandleEXT", "buffer", structure->buffer);
            }
        } break;

        // Validation code for VkOpaqueCaptureDescriptorDataCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT: { // Covers VUID-VkOpaqueCaptureDescriptorDataCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkOpaqueCaptureDescriptorDataCreateInfoEXT *structure = (VkOpaqueCaptureDescriptorDataCreateInfoEXT *) header;
                skip |= ValidateRequiredPointer("VkOpaqueCaptureDescriptorDataCreateInfoEXT", "opaqueCaptureDescriptorData", structure->opaqueCaptureDescriptorData, "VUID-VkOpaqueCaptureDescriptorDataCreateInfoEXT-opaqueCaptureDescriptorData-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *structure = (VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT", "graphicsPipelineLibrary", structure->graphicsPipelineLibrary);
            }
        } break;

        // Validation code for VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT: { // Covers VUID-VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *structure = (VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT", "graphicsPipelineLibraryFastLinking", structure->graphicsPipelineLibraryFastLinking);

                skip |= ValidateBool32("VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT", "graphicsPipelineLibraryIndependentInterpolationDecoration", structure->graphicsPipelineLibraryIndependentInterpolationDecoration);
            }
        } break;

        // Validation code for VkGraphicsPipelineLibraryCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT: { // Covers VUID-VkGraphicsPipelineLibraryCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkGraphicsPipelineLibraryCreateInfoEXT *structure = (VkGraphicsPipelineLibraryCreateInfoEXT *) header;
                skip |= ValidateFlags("VkGraphicsPipelineLibraryCreateInfoEXT", "flags", "VkGraphicsPipelineLibraryFlagBitsEXT", AllVkGraphicsPipelineLibraryFlagBitsEXT, structure->flags, kRequiredFlags, "VUID-VkGraphicsPipelineLibraryCreateInfoEXT-flags-parameter", "VUID-VkGraphicsPipelineLibraryCreateInfoEXT-flags-requiredbitmask");
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EARLY_AND_LATE_FRAGMENT_TESTS_FEATURES_AMD: { // Covers VUID-VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD *structure = (VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD", "shaderEarlyAndLateFragmentTests", structure->shaderEarlyAndLateFragmentTests);
            }
        } break;

        // Validation code for VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV *structure = (VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV", "fragmentShadingRateEnums", structure->fragmentShadingRateEnums);

                skip |= ValidateBool32("VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV", "supersampleFragmentShadingRates", structure->supersampleFragmentShadingRates);

                skip |= ValidateBool32("VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV", "noInvocationFragmentShadingRates", structure->noInvocationFragmentShadingRates);
            }
        } break;

        // Validation code for VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV: { // Covers VUID-VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV *structure = (VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV *) header;
                skip |= ValidateFlags("VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV", "maxFragmentShadingRateInvocationCount", "VkSampleCountFlagBits", AllVkSampleCountFlagBits, structure->maxFragmentShadingRateInvocationCount, kRequiredSingleBit, "VUID-VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV-maxFragmentShadingRateInvocationCount-parameter", "VUID-VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV-maxFragmentShadingRateInvocationCount-parameter");
            }
        } break;

        // No Validation code for VkPipelineFragmentShadingRateEnumStateCreateInfoNV structure members  -- Covers VUID-VkPipelineFragmentShadingRateEnumStateCreateInfoNV-sType-sType

        // No Validation code for VkAccelerationStructureGeometryMotionTrianglesDataNV structure members  -- Covers VUID-VkAccelerationStructureGeometryMotionTrianglesDataNV-sType-sType

        // Validation code for VkAccelerationStructureMotionInfoNV structure members
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV: { // Covers VUID-VkAccelerationStructureMotionInfoNV-sType-sType
            if (is_const_param) {
                VkAccelerationStructureMotionInfoNV *structure = (VkAccelerationStructureMotionInfoNV *) header;
                skip |= ValidateReservedFlags("VkAccelerationStructureMotionInfoNV", "flags", structure->flags, "VUID-VkAccelerationStructureMotionInfoNV-flags-zerobitmask");
            }
        } break;

        // Validation code for VkPhysicalDeviceRayTracingMotionBlurFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceRayTracingMotionBlurFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceRayTracingMotionBlurFeaturesNV *structure = (VkPhysicalDeviceRayTracingMotionBlurFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceRayTracingMotionBlurFeaturesNV", "rayTracingMotionBlur", structure->rayTracingMotionBlur);

                skip |= ValidateBool32("VkPhysicalDeviceRayTracingMotionBlurFeaturesNV", "rayTracingMotionBlurPipelineTraceRaysIndirect", structure->rayTracingMotionBlurPipelineTraceRaysIndirect);
            }
        } break;

        // Validation code for VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *structure = (VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT", "ycbcr2plane444Formats", structure->ycbcr2plane444Formats);
            }
        } break;

        // Validation code for VkPhysicalDeviceFragmentDensityMap2FeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceFragmentDensityMap2FeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceFragmentDensityMap2FeaturesEXT *structure = (VkPhysicalDeviceFragmentDensityMap2FeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceFragmentDensityMap2FeaturesEXT", "fragmentDensityMapDeferred", structure->fragmentDensityMapDeferred);
            }
        } break;

        // No Validation code for VkPhysicalDeviceFragmentDensityMap2PropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceFragmentDensityMap2PropertiesEXT-sType-sType

        // No Validation code for VkCopyCommandTransformInfoQCOM structure members  -- Covers VUID-VkCopyCommandTransformInfoQCOM-sType-sType

        // Validation code for VkPhysicalDeviceImageCompressionControlFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceImageCompressionControlFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceImageCompressionControlFeaturesEXT *structure = (VkPhysicalDeviceImageCompressionControlFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceImageCompressionControlFeaturesEXT", "imageCompressionControl", structure->imageCompressionControl);
            }
        } break;

        // No Validation code for VkImageCompressionControlEXT structure members  -- Covers VUID-VkImageCompressionControlEXT-sType-sType

        // No Validation code for VkImageCompressionPropertiesEXT structure members  -- Covers VUID-VkImageCompressionPropertiesEXT-sType-sType

        // Validation code for VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *structure = (VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT", "attachmentFeedbackLoopLayout", structure->attachmentFeedbackLoopLayout);
            }
        } break;

        // Validation code for VkPhysicalDevice4444FormatsFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT: { // Covers VUID-VkPhysicalDevice4444FormatsFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDevice4444FormatsFeaturesEXT *structure = (VkPhysicalDevice4444FormatsFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDevice4444FormatsFeaturesEXT", "formatA4R4G4B4", structure->formatA4R4G4B4);

                skip |= ValidateBool32("VkPhysicalDevice4444FormatsFeaturesEXT", "formatA4B4G4R4", structure->formatA4B4G4R4);
            }
        } break;

        // Validation code for VkPhysicalDeviceFaultFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FAULT_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceFaultFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceFaultFeaturesEXT *structure = (VkPhysicalDeviceFaultFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceFaultFeaturesEXT", "deviceFault", structure->deviceFault);

                skip |= ValidateBool32("VkPhysicalDeviceFaultFeaturesEXT", "deviceFaultVendorBinary", structure->deviceFaultVendorBinary);
            }
        } break;

        // Validation code for VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *structure = (VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT", "rasterizationOrderColorAttachmentAccess", structure->rasterizationOrderColorAttachmentAccess);

                skip |= ValidateBool32("VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT", "rasterizationOrderDepthAttachmentAccess", structure->rasterizationOrderDepthAttachmentAccess);

                skip |= ValidateBool32("VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT", "rasterizationOrderStencilAttachmentAccess", structure->rasterizationOrderStencilAttachmentAccess);
            }
        } break;

        // Validation code for VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT *structure = (VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT", "formatRgba10x6WithoutYCbCrSampler", structure->formatRgba10x6WithoutYCbCrSampler);
            }
        } break;

        // Validation code for VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *structure = (VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT", "mutableDescriptorType", structure->mutableDescriptorType);
            }
        } break;

        // Validation code for VkMutableDescriptorTypeCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT: { // Covers VUID-VkMutableDescriptorTypeCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkMutableDescriptorTypeCreateInfoEXT *structure = (VkMutableDescriptorTypeCreateInfoEXT *) header;
                skip |= ValidateArray("VkMutableDescriptorTypeCreateInfoEXT", "mutableDescriptorTypeListCount", "pMutableDescriptorTypeLists", structure->mutableDescriptorTypeListCount, &structure->pMutableDescriptorTypeLists, false, true, kVUIDUndefined, "VUID-VkMutableDescriptorTypeCreateInfoEXT-pMutableDescriptorTypeLists-parameter");

                if (structure->pMutableDescriptorTypeLists != nullptr)
                {
                    for (uint32_t mutableDescriptorTypeListIndex = 0; mutableDescriptorTypeListIndex < structure->mutableDescriptorTypeListCount; ++mutableDescriptorTypeListIndex)
                    {
                        skip |= ValidateRangedEnumArray("VkMutableDescriptorTypeCreateInfoEXT", ParameterName("pMutableDescriptorTypeLists[%i].descriptorTypeCount", ParameterName::IndexVector{ mutableDescriptorTypeListIndex }), ParameterName("pMutableDescriptorTypeLists[%i].pDescriptorTypes", ParameterName::IndexVector{ mutableDescriptorTypeListIndex }), "VkDescriptorType", AllVkDescriptorTypeEnums, structure->pMutableDescriptorTypeLists[mutableDescriptorTypeListIndex].descriptorTypeCount, structure->pMutableDescriptorTypeLists[mutableDescriptorTypeListIndex].pDescriptorTypes, false, true);
                    }
                }
            }
        } break;

        // Validation code for VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *structure = (VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT", "vertexInputDynamicState", structure->vertexInputDynamicState);
            }
        } break;

        // No Validation code for VkPhysicalDeviceDrmPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceDrmPropertiesEXT-sType-sType

        // Validation code for VkPhysicalDeviceAddressBindingReportFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ADDRESS_BINDING_REPORT_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceAddressBindingReportFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceAddressBindingReportFeaturesEXT *structure = (VkPhysicalDeviceAddressBindingReportFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceAddressBindingReportFeaturesEXT", "reportAddressBinding", structure->reportAddressBinding);
            }
        } break;

        // Validation code for VkDeviceAddressBindingCallbackDataEXT structure members
        case VK_STRUCTURE_TYPE_DEVICE_ADDRESS_BINDING_CALLBACK_DATA_EXT: { // Covers VUID-VkDeviceAddressBindingCallbackDataEXT-sType-sType
            if (is_const_param) {
                VkDeviceAddressBindingCallbackDataEXT *structure = (VkDeviceAddressBindingCallbackDataEXT *) header;
                skip |= ValidateFlags("VkDeviceAddressBindingCallbackDataEXT", "flags", "VkDeviceAddressBindingFlagBitsEXT", AllVkDeviceAddressBindingFlagBitsEXT, structure->flags, kOptionalFlags, "VUID-VkDeviceAddressBindingCallbackDataEXT-flags-parameter");

                skip |= ValidateRangedEnum("VkDeviceAddressBindingCallbackDataEXT", "bindingType", "VkDeviceAddressBindingTypeEXT", AllVkDeviceAddressBindingTypeEXTEnums, structure->bindingType, "VUID-VkDeviceAddressBindingCallbackDataEXT-bindingType-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceDepthClipControlFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceDepthClipControlFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceDepthClipControlFeaturesEXT *structure = (VkPhysicalDeviceDepthClipControlFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceDepthClipControlFeaturesEXT", "depthClipControl", structure->depthClipControl);
            }
        } break;

        // Validation code for VkPipelineViewportDepthClipControlCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT: { // Covers VUID-VkPipelineViewportDepthClipControlCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkPipelineViewportDepthClipControlCreateInfoEXT *structure = (VkPipelineViewportDepthClipControlCreateInfoEXT *) header;
                skip |= ValidateBool32("VkPipelineViewportDepthClipControlCreateInfoEXT", "negativeOneToOne", structure->negativeOneToOne);
            }
        } break;

        // Validation code for VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT: { // Covers VUID-VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *structure = (VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT", "primitiveTopologyListRestart", structure->primitiveTopologyListRestart);

                skip |= ValidateBool32("VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT", "primitiveTopologyPatchListRestart", structure->primitiveTopologyPatchListRestart);
            }
        } break;

#ifdef VK_USE_PLATFORM_FUCHSIA
        // Validation code for VkImportMemoryZirconHandleInfoFUCHSIA structure members
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA: { // Covers VUID-VkImportMemoryZirconHandleInfoFUCHSIA-sType-sType
            if (is_const_param) {
                VkImportMemoryZirconHandleInfoFUCHSIA *structure = (VkImportMemoryZirconHandleInfoFUCHSIA *) header;
                skip |= ValidateFlags("VkImportMemoryZirconHandleInfoFUCHSIA", "handleType", "VkExternalMemoryHandleTypeFlagBits", AllVkExternalMemoryHandleTypeFlagBits, structure->handleType, kOptionalSingleBit, "VUID-VkImportMemoryZirconHandleInfoFUCHSIA-handleType-parameter");
            }
        } break;
#endif // VK_USE_PLATFORM_FUCHSIA

#ifdef VK_USE_PLATFORM_FUCHSIA
        // Validation code for VkImportMemoryBufferCollectionFUCHSIA structure members
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA: { // Covers VUID-VkImportMemoryBufferCollectionFUCHSIA-sType-sType
            if (is_const_param) {
                VkImportMemoryBufferCollectionFUCHSIA *structure = (VkImportMemoryBufferCollectionFUCHSIA *) header;
                skip |= ValidateRequiredHandle("VkImportMemoryBufferCollectionFUCHSIA", "collection", structure->collection);
            }
        } break;
#endif // VK_USE_PLATFORM_FUCHSIA

#ifdef VK_USE_PLATFORM_FUCHSIA
        // Validation code for VkBufferCollectionImageCreateInfoFUCHSIA structure members
        case VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA: { // Covers VUID-VkBufferCollectionImageCreateInfoFUCHSIA-sType-sType
            if (is_const_param) {
                VkBufferCollectionImageCreateInfoFUCHSIA *structure = (VkBufferCollectionImageCreateInfoFUCHSIA *) header;
                skip |= ValidateRequiredHandle("VkBufferCollectionImageCreateInfoFUCHSIA", "collection", structure->collection);
            }
        } break;
#endif // VK_USE_PLATFORM_FUCHSIA

#ifdef VK_USE_PLATFORM_FUCHSIA
        // Validation code for VkBufferCollectionBufferCreateInfoFUCHSIA structure members
        case VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA: { // Covers VUID-VkBufferCollectionBufferCreateInfoFUCHSIA-sType-sType
            if (is_const_param) {
                VkBufferCollectionBufferCreateInfoFUCHSIA *structure = (VkBufferCollectionBufferCreateInfoFUCHSIA *) header;
                skip |= ValidateRequiredHandle("VkBufferCollectionBufferCreateInfoFUCHSIA", "collection", structure->collection);
            }
        } break;
#endif // VK_USE_PLATFORM_FUCHSIA

        // No Validation code for VkSubpassShadingPipelineCreateInfoHUAWEI structure members  -- Covers VUID-VkSubpassShadingPipelineCreateInfoHUAWEI-sType-sType

        // Validation code for VkPhysicalDeviceSubpassShadingFeaturesHUAWEI structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI: { // Covers VUID-VkPhysicalDeviceSubpassShadingFeaturesHUAWEI-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceSubpassShadingFeaturesHUAWEI *structure = (VkPhysicalDeviceSubpassShadingFeaturesHUAWEI *) header;
                skip |= ValidateBool32("VkPhysicalDeviceSubpassShadingFeaturesHUAWEI", "subpassShading", structure->subpassShading);
            }
        } break;

        // No Validation code for VkPhysicalDeviceSubpassShadingPropertiesHUAWEI structure members  -- Covers VUID-VkPhysicalDeviceSubpassShadingPropertiesHUAWEI-sType-sType

        // Validation code for VkPhysicalDeviceInvocationMaskFeaturesHUAWEI structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI: { // Covers VUID-VkPhysicalDeviceInvocationMaskFeaturesHUAWEI-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceInvocationMaskFeaturesHUAWEI *structure = (VkPhysicalDeviceInvocationMaskFeaturesHUAWEI *) header;
                skip |= ValidateBool32("VkPhysicalDeviceInvocationMaskFeaturesHUAWEI", "invocationMask", structure->invocationMask);
            }
        } break;

        // Validation code for VkPhysicalDeviceExternalMemoryRDMAFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceExternalMemoryRDMAFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceExternalMemoryRDMAFeaturesNV *structure = (VkPhysicalDeviceExternalMemoryRDMAFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceExternalMemoryRDMAFeaturesNV", "externalMemoryRDMA", structure->externalMemoryRDMA);
            }
        } break;

        // Validation code for VkPhysicalDevicePipelinePropertiesFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROPERTIES_FEATURES_EXT: { // Covers VUID-VkPhysicalDevicePipelinePropertiesFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDevicePipelinePropertiesFeaturesEXT *structure = (VkPhysicalDevicePipelinePropertiesFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDevicePipelinePropertiesFeaturesEXT", "pipelinePropertiesIdentifier", structure->pipelinePropertiesIdentifier);
            }
        } break;

        // Validation code for VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *structure = (VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT", "multisampledRenderToSingleSampled", structure->multisampledRenderToSingleSampled);
            }
        } break;

        // No Validation code for VkSubpassResolvePerformanceQueryEXT structure members  -- Covers VUID-VkSubpassResolvePerformanceQueryEXT-sType-sType

        // Validation code for VkMultisampledRenderToSingleSampledInfoEXT structure members
        case VK_STRUCTURE_TYPE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_INFO_EXT: { // Covers VUID-VkMultisampledRenderToSingleSampledInfoEXT-sType-sType
            if (is_const_param) {
                VkMultisampledRenderToSingleSampledInfoEXT *structure = (VkMultisampledRenderToSingleSampledInfoEXT *) header;
                skip |= ValidateBool32("VkMultisampledRenderToSingleSampledInfoEXT", "multisampledRenderToSingleSampledEnable", structure->multisampledRenderToSingleSampledEnable);

                skip |= ValidateFlags("VkMultisampledRenderToSingleSampledInfoEXT", "rasterizationSamples", "VkSampleCountFlagBits", AllVkSampleCountFlagBits, structure->rasterizationSamples, kRequiredSingleBit, "VUID-VkMultisampledRenderToSingleSampledInfoEXT-rasterizationSamples-parameter", "VUID-VkMultisampledRenderToSingleSampledInfoEXT-rasterizationSamples-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceExtendedDynamicState2FeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceExtendedDynamicState2FeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *structure = (VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState2FeaturesEXT", "extendedDynamicState2", structure->extendedDynamicState2);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState2FeaturesEXT", "extendedDynamicState2LogicOp", structure->extendedDynamicState2LogicOp);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState2FeaturesEXT", "extendedDynamicState2PatchControlPoints", structure->extendedDynamicState2PatchControlPoints);
            }
        } break;

        // Validation code for VkPhysicalDeviceColorWriteEnableFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceColorWriteEnableFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceColorWriteEnableFeaturesEXT *structure = (VkPhysicalDeviceColorWriteEnableFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceColorWriteEnableFeaturesEXT", "colorWriteEnable", structure->colorWriteEnable);
            }
        } break;

        // Validation code for VkPipelineColorWriteCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT: { // Covers VUID-VkPipelineColorWriteCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkPipelineColorWriteCreateInfoEXT *structure = (VkPipelineColorWriteCreateInfoEXT *) header;
                skip |= ValidateBool32Array("VkPipelineColorWriteCreateInfoEXT", "attachmentCount", "pColorWriteEnables", structure->attachmentCount, structure->pColorWriteEnables, false, true);
            }
        } break;

        // Validation code for VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT: { // Covers VUID-VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *structure = (VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT", "primitivesGeneratedQuery", structure->primitivesGeneratedQuery);

                skip |= ValidateBool32("VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT", "primitivesGeneratedQueryWithRasterizerDiscard", structure->primitivesGeneratedQueryWithRasterizerDiscard);

                skip |= ValidateBool32("VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT", "primitivesGeneratedQueryWithNonZeroStreams", structure->primitivesGeneratedQueryWithNonZeroStreams);
            }
        } break;

        // Validation code for VkPhysicalDeviceImageViewMinLodFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceImageViewMinLodFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceImageViewMinLodFeaturesEXT *structure = (VkPhysicalDeviceImageViewMinLodFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceImageViewMinLodFeaturesEXT", "minLod", structure->minLod);
            }
        } break;

        // No Validation code for VkImageViewMinLodCreateInfoEXT structure members  -- Covers VUID-VkImageViewMinLodCreateInfoEXT-sType-sType

        // Validation code for VkPhysicalDeviceMultiDrawFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceMultiDrawFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceMultiDrawFeaturesEXT *structure = (VkPhysicalDeviceMultiDrawFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceMultiDrawFeaturesEXT", "multiDraw", structure->multiDraw);
            }
        } break;

        // No Validation code for VkPhysicalDeviceMultiDrawPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceMultiDrawPropertiesEXT-sType-sType

        // Validation code for VkPhysicalDeviceImage2DViewOf3DFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceImage2DViewOf3DFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *structure = (VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceImage2DViewOf3DFeaturesEXT", "image2DViewOf3D", structure->image2DViewOf3D);

                skip |= ValidateBool32("VkPhysicalDeviceImage2DViewOf3DFeaturesEXT", "sampler2DViewOf3D", structure->sampler2DViewOf3D);
            }
        } break;

        // Validation code for VkPhysicalDeviceOpacityMicromapFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceOpacityMicromapFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceOpacityMicromapFeaturesEXT *structure = (VkPhysicalDeviceOpacityMicromapFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceOpacityMicromapFeaturesEXT", "micromap", structure->micromap);

                skip |= ValidateBool32("VkPhysicalDeviceOpacityMicromapFeaturesEXT", "micromapCaptureReplay", structure->micromapCaptureReplay);

                skip |= ValidateBool32("VkPhysicalDeviceOpacityMicromapFeaturesEXT", "micromapHostCommands", structure->micromapHostCommands);
            }
        } break;

        // No Validation code for VkPhysicalDeviceOpacityMicromapPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceOpacityMicromapPropertiesEXT-sType-sType

        // Validation code for VkAccelerationStructureTrianglesOpacityMicromapEXT structure members
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_OPACITY_MICROMAP_EXT: { // Covers VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-sType-sType
            if (is_const_param) {
                VkAccelerationStructureTrianglesOpacityMicromapEXT *structure = (VkAccelerationStructureTrianglesOpacityMicromapEXT *) header;
                skip |= ValidateRangedEnum("VkAccelerationStructureTrianglesOpacityMicromapEXT", "indexType", "VkIndexType", AllVkIndexTypeEnums, structure->indexType, "VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-indexType-parameter");

                if (structure->pUsageCounts != nullptr)
                {
                    for (uint32_t usageIndexsIndex = 0; usageIndexsIndex < structure->usageCountsCount; ++usageIndexsIndex)
                    {
                    }
                }

                if (structure->ppUsageCounts != nullptr)
                {
                    for (uint32_t usageIndexsIndex = 0; usageIndexsIndex < structure->usageCountsCount; ++usageIndexsIndex)
                    {
                    }
                }

                skip |= ValidateRequiredHandle("VkAccelerationStructureTrianglesOpacityMicromapEXT", "micromap", structure->micromap);
            }
        } break;

        // Validation code for VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_FEATURES_HUAWEI: { // Covers VUID-VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI *structure = (VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI *) header;
                skip |= ValidateBool32("VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI", "clustercullingShader", structure->clustercullingShader);

                skip |= ValidateBool32("VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI", "multiviewClusterCullingShader", structure->multiviewClusterCullingShader);
            }
        } break;

        // No Validation code for VkPhysicalDeviceClusterCullingShaderPropertiesHUAWEI structure members  -- Covers VUID-VkPhysicalDeviceClusterCullingShaderPropertiesHUAWEI-sType-sType

        // Validation code for VkPhysicalDeviceBorderColorSwizzleFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceBorderColorSwizzleFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *structure = (VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceBorderColorSwizzleFeaturesEXT", "borderColorSwizzle", structure->borderColorSwizzle);

                skip |= ValidateBool32("VkPhysicalDeviceBorderColorSwizzleFeaturesEXT", "borderColorSwizzleFromImage", structure->borderColorSwizzleFromImage);
            }
        } break;

        // Validation code for VkSamplerBorderColorComponentMappingCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT: { // Covers VUID-VkSamplerBorderColorComponentMappingCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkSamplerBorderColorComponentMappingCreateInfoEXT *structure = (VkSamplerBorderColorComponentMappingCreateInfoEXT *) header;
                skip |= ValidateRangedEnum("VkSamplerBorderColorComponentMappingCreateInfoEXT", "components.r", "VkComponentSwizzle", AllVkComponentSwizzleEnums, structure->components.r, "VUID-VkComponentMapping-r-parameter");

                skip |= ValidateRangedEnum("VkSamplerBorderColorComponentMappingCreateInfoEXT", "components.g", "VkComponentSwizzle", AllVkComponentSwizzleEnums, structure->components.g, "VUID-VkComponentMapping-g-parameter");

                skip |= ValidateRangedEnum("VkSamplerBorderColorComponentMappingCreateInfoEXT", "components.b", "VkComponentSwizzle", AllVkComponentSwizzleEnums, structure->components.b, "VUID-VkComponentMapping-b-parameter");

                skip |= ValidateRangedEnum("VkSamplerBorderColorComponentMappingCreateInfoEXT", "components.a", "VkComponentSwizzle", AllVkComponentSwizzleEnums, structure->components.a, "VUID-VkComponentMapping-a-parameter");

                skip |= ValidateBool32("VkSamplerBorderColorComponentMappingCreateInfoEXT", "srgb", structure->srgb);
            }
        } break;

        // Validation code for VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT: { // Covers VUID-VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT *structure = (VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT", "pageableDeviceLocalMemory", structure->pageableDeviceLocalMemory);
            }
        } break;

        // Validation code for VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_SET_HOST_MAPPING_FEATURES_VALVE: { // Covers VUID-VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE *structure = (VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE *) header;
                skip |= ValidateBool32("VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE", "descriptorSetHostMapping", structure->descriptorSetHostMapping);
            }
        } break;

        // Validation code for VkPhysicalDeviceDepthClampZeroOneFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceDepthClampZeroOneFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceDepthClampZeroOneFeaturesEXT *structure = (VkPhysicalDeviceDepthClampZeroOneFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceDepthClampZeroOneFeaturesEXT", "depthClampZeroOne", structure->depthClampZeroOne);
            }
        } break;

        // Validation code for VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *structure = (VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT", "nonSeamlessCubeMap", structure->nonSeamlessCubeMap);
            }
        } break;

        // Validation code for VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_QCOM: { // Covers VUID-VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM *structure = (VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM *) header;
                skip |= ValidateBool32("VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM", "fragmentDensityMapOffset", structure->fragmentDensityMapOffset);
            }
        } break;

        // No Validation code for VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM structure members  -- Covers VUID-VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM-sType-sType

        // Validation code for VkSubpassFragmentDensityMapOffsetEndInfoQCOM structure members
        case VK_STRUCTURE_TYPE_SUBPASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_QCOM: { // Covers VUID-VkSubpassFragmentDensityMapOffsetEndInfoQCOM-sType-sType
            if (is_const_param) {
                VkSubpassFragmentDensityMapOffsetEndInfoQCOM *structure = (VkSubpassFragmentDensityMapOffsetEndInfoQCOM *) header;
                skip |= ValidateArray("VkSubpassFragmentDensityMapOffsetEndInfoQCOM", "fragmentDensityOffsetCount", "pFragmentDensityOffsets", structure->fragmentDensityOffsetCount, &structure->pFragmentDensityOffsets, false, true, kVUIDUndefined, "VUID-VkSubpassFragmentDensityMapOffsetEndInfoQCOM-pFragmentDensityOffsets-parameter");

                if (structure->pFragmentDensityOffsets != nullptr)
                {
                    for (uint32_t fragmentDensityOffsetIndex = 0; fragmentDensityOffsetIndex < structure->fragmentDensityOffsetCount; ++fragmentDensityOffsetIndex)
                    {
                    }
                }
            }
        } break;

        // Validation code for VkPhysicalDeviceCopyMemoryIndirectFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceCopyMemoryIndirectFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceCopyMemoryIndirectFeaturesNV *structure = (VkPhysicalDeviceCopyMemoryIndirectFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceCopyMemoryIndirectFeaturesNV", "indirectCopy", structure->indirectCopy);
            }
        } break;

        // No Validation code for VkPhysicalDeviceCopyMemoryIndirectPropertiesNV structure members  -- Covers VUID-VkPhysicalDeviceCopyMemoryIndirectPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceMemoryDecompressionFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceMemoryDecompressionFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceMemoryDecompressionFeaturesNV *structure = (VkPhysicalDeviceMemoryDecompressionFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceMemoryDecompressionFeaturesNV", "memoryDecompression", structure->memoryDecompression);
            }
        } break;

        // No Validation code for VkPhysicalDeviceMemoryDecompressionPropertiesNV structure members  -- Covers VUID-VkPhysicalDeviceMemoryDecompressionPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceLinearColorAttachmentFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceLinearColorAttachmentFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceLinearColorAttachmentFeaturesNV *structure = (VkPhysicalDeviceLinearColorAttachmentFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceLinearColorAttachmentFeaturesNV", "linearColorAttachment", structure->linearColorAttachment);
            }
        } break;

        // Validation code for VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT *structure = (VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT", "imageCompressionControlSwapchain", structure->imageCompressionControlSwapchain);
            }
        } break;

        // No Validation code for VkImageViewSampleWeightCreateInfoQCOM structure members  -- Covers VUID-VkImageViewSampleWeightCreateInfoQCOM-sType-sType

        // Validation code for VkPhysicalDeviceImageProcessingFeaturesQCOM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_FEATURES_QCOM: { // Covers VUID-VkPhysicalDeviceImageProcessingFeaturesQCOM-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceImageProcessingFeaturesQCOM *structure = (VkPhysicalDeviceImageProcessingFeaturesQCOM *) header;
                skip |= ValidateBool32("VkPhysicalDeviceImageProcessingFeaturesQCOM", "textureSampleWeighted", structure->textureSampleWeighted);

                skip |= ValidateBool32("VkPhysicalDeviceImageProcessingFeaturesQCOM", "textureBoxFilter", structure->textureBoxFilter);

                skip |= ValidateBool32("VkPhysicalDeviceImageProcessingFeaturesQCOM", "textureBlockMatch", structure->textureBlockMatch);
            }
        } break;

        // No Validation code for VkPhysicalDeviceImageProcessingPropertiesQCOM structure members  -- Covers VUID-VkPhysicalDeviceImageProcessingPropertiesQCOM-sType-sType

        // Validation code for VkPhysicalDeviceExtendedDynamicState3FeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceExtendedDynamicState3FeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *structure = (VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3TessellationDomainOrigin", structure->extendedDynamicState3TessellationDomainOrigin);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3DepthClampEnable", structure->extendedDynamicState3DepthClampEnable);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3PolygonMode", structure->extendedDynamicState3PolygonMode);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3RasterizationSamples", structure->extendedDynamicState3RasterizationSamples);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3SampleMask", structure->extendedDynamicState3SampleMask);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3AlphaToCoverageEnable", structure->extendedDynamicState3AlphaToCoverageEnable);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3AlphaToOneEnable", structure->extendedDynamicState3AlphaToOneEnable);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3LogicOpEnable", structure->extendedDynamicState3LogicOpEnable);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3ColorBlendEnable", structure->extendedDynamicState3ColorBlendEnable);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3ColorBlendEquation", structure->extendedDynamicState3ColorBlendEquation);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3ColorWriteMask", structure->extendedDynamicState3ColorWriteMask);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3RasterizationStream", structure->extendedDynamicState3RasterizationStream);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3ConservativeRasterizationMode", structure->extendedDynamicState3ConservativeRasterizationMode);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3ExtraPrimitiveOverestimationSize", structure->extendedDynamicState3ExtraPrimitiveOverestimationSize);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3DepthClipEnable", structure->extendedDynamicState3DepthClipEnable);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3SampleLocationsEnable", structure->extendedDynamicState3SampleLocationsEnable);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3ColorBlendAdvanced", structure->extendedDynamicState3ColorBlendAdvanced);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3ProvokingVertexMode", structure->extendedDynamicState3ProvokingVertexMode);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3LineRasterizationMode", structure->extendedDynamicState3LineRasterizationMode);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3LineStippleEnable", structure->extendedDynamicState3LineStippleEnable);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3DepthClipNegativeOneToOne", structure->extendedDynamicState3DepthClipNegativeOneToOne);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3ViewportWScalingEnable", structure->extendedDynamicState3ViewportWScalingEnable);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3ViewportSwizzle", structure->extendedDynamicState3ViewportSwizzle);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3CoverageToColorEnable", structure->extendedDynamicState3CoverageToColorEnable);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3CoverageToColorLocation", structure->extendedDynamicState3CoverageToColorLocation);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3CoverageModulationMode", structure->extendedDynamicState3CoverageModulationMode);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3CoverageModulationTableEnable", structure->extendedDynamicState3CoverageModulationTableEnable);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3CoverageModulationTable", structure->extendedDynamicState3CoverageModulationTable);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3CoverageReductionMode", structure->extendedDynamicState3CoverageReductionMode);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3RepresentativeFragmentTestEnable", structure->extendedDynamicState3RepresentativeFragmentTestEnable);

                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3FeaturesEXT", "extendedDynamicState3ShadingRateImageEnable", structure->extendedDynamicState3ShadingRateImageEnable);
            }
        } break;

        // Validation code for VkPhysicalDeviceExtendedDynamicState3PropertiesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT: { // Covers VUID-VkPhysicalDeviceExtendedDynamicState3PropertiesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *structure = (VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceExtendedDynamicState3PropertiesEXT", "dynamicPrimitiveTopologyUnrestricted", structure->dynamicPrimitiveTopologyUnrestricted);
            }
        } break;

        // Validation code for VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_MERGE_FEEDBACK_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT *structure = (VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT", "subpassMergeFeedback", structure->subpassMergeFeedback);
            }
        } break;

        // Validation code for VkRenderPassCreationControlEXT structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_CONTROL_EXT: { // Covers VUID-VkRenderPassCreationControlEXT-sType-sType
            if (is_const_param) {
                VkRenderPassCreationControlEXT *structure = (VkRenderPassCreationControlEXT *) header;
                skip |= ValidateBool32("VkRenderPassCreationControlEXT", "disallowMerging", structure->disallowMerging);
            }
        } break;

        // Validation code for VkRenderPassCreationFeedbackCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_FEEDBACK_CREATE_INFO_EXT: { // Covers VUID-VkRenderPassCreationFeedbackCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkRenderPassCreationFeedbackCreateInfoEXT *structure = (VkRenderPassCreationFeedbackCreateInfoEXT *) header;
                skip |= ValidateRequiredPointer("VkRenderPassCreationFeedbackCreateInfoEXT", "pRenderPassFeedback", structure->pRenderPassFeedback, "VUID-VkRenderPassCreationFeedbackCreateInfoEXT-pRenderPassFeedback-parameter");

                if (structure->pRenderPassFeedback != nullptr)
                {
                }
            }
        } break;

        // Validation code for VkRenderPassSubpassFeedbackCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_RENDER_PASS_SUBPASS_FEEDBACK_CREATE_INFO_EXT: { // Covers VUID-VkRenderPassSubpassFeedbackCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkRenderPassSubpassFeedbackCreateInfoEXT *structure = (VkRenderPassSubpassFeedbackCreateInfoEXT *) header;
                skip |= ValidateRequiredPointer("VkRenderPassSubpassFeedbackCreateInfoEXT", "pSubpassFeedback", structure->pSubpassFeedback, "VUID-VkRenderPassSubpassFeedbackCreateInfoEXT-pSubpassFeedback-parameter");

                if (structure->pSubpassFeedback != nullptr)
                {
                }
            }
        } break;

        // Validation code for VkDirectDriverLoadingListLUNARG structure members
        case VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_LIST_LUNARG: { // Covers VUID-VkDirectDriverLoadingListLUNARG-sType-sType
            if (is_const_param) {
                VkDirectDriverLoadingListLUNARG *structure = (VkDirectDriverLoadingListLUNARG *) header;
                skip |= ValidateRangedEnum("VkDirectDriverLoadingListLUNARG", "mode", "VkDirectDriverLoadingModeLUNARG", AllVkDirectDriverLoadingModeLUNARGEnums, structure->mode, "VUID-VkDirectDriverLoadingListLUNARG-mode-parameter");

                skip |= ValidateStructTypeArray("VkDirectDriverLoadingListLUNARG", "driverCount", "pDrivers", "VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_INFO_LUNARG", structure->driverCount, structure->pDrivers, VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_INFO_LUNARG, true, true, "VUID-VkDirectDriverLoadingInfoLUNARG-sType-sType", "VUID-VkDirectDriverLoadingListLUNARG-pDrivers-parameter", "VUID-VkDirectDriverLoadingListLUNARG-driverCount-arraylength");

                if (structure->pDrivers != nullptr)
                {
                    for (uint32_t driverIndex = 0; driverIndex < structure->driverCount; ++driverIndex)
                    {
                        skip |= ValidateReservedFlags("VkDirectDriverLoadingListLUNARG", ParameterName("pDrivers[%i].flags", ParameterName::IndexVector{ driverIndex }), structure->pDrivers[driverIndex].flags, "VUID-VkDirectDriverLoadingInfoLUNARG-flags-zerobitmask");
                    }
                }
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT *structure = (VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT", "shaderModuleIdentifier", structure->shaderModuleIdentifier);
            }
        } break;

        // No Validation code for VkPhysicalDeviceShaderModuleIdentifierPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceShaderModuleIdentifierPropertiesEXT-sType-sType

        // Validation code for VkPipelineShaderStageModuleIdentifierCreateInfoEXT structure members
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_MODULE_IDENTIFIER_CREATE_INFO_EXT: { // Covers VUID-VkPipelineShaderStageModuleIdentifierCreateInfoEXT-sType-sType
            if (is_const_param) {
                VkPipelineShaderStageModuleIdentifierCreateInfoEXT *structure = (VkPipelineShaderStageModuleIdentifierCreateInfoEXT *) header;
                skip |= ValidateArray("VkPipelineShaderStageModuleIdentifierCreateInfoEXT", "identifierSize", "pIdentifier", structure->identifierSize, &structure->pIdentifier, false, true, kVUIDUndefined, "VUID-VkPipelineShaderStageModuleIdentifierCreateInfoEXT-pIdentifier-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceOpticalFlowFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceOpticalFlowFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceOpticalFlowFeaturesNV *structure = (VkPhysicalDeviceOpticalFlowFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceOpticalFlowFeaturesNV", "opticalFlow", structure->opticalFlow);
            }
        } break;

        // No Validation code for VkPhysicalDeviceOpticalFlowPropertiesNV structure members  -- Covers VUID-VkPhysicalDeviceOpticalFlowPropertiesNV-sType-sType

        // Validation code for VkOpticalFlowImageFormatInfoNV structure members
        case VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_INFO_NV: { // Covers VUID-VkOpticalFlowImageFormatInfoNV-sType-sType
            if (is_const_param) {
                VkOpticalFlowImageFormatInfoNV *structure = (VkOpticalFlowImageFormatInfoNV *) header;
                skip |= ValidateFlags("VkOpticalFlowImageFormatInfoNV", "usage", "VkOpticalFlowUsageFlagBitsNV", AllVkOpticalFlowUsageFlagBitsNV, structure->usage, kRequiredFlags, "VUID-VkOpticalFlowImageFormatInfoNV-usage-parameter", "VUID-VkOpticalFlowImageFormatInfoNV-usage-requiredbitmask");
            }
        } break;

        // Validation code for VkOpticalFlowSessionCreatePrivateDataInfoNV structure members
        case VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_PRIVATE_DATA_INFO_NV: { // Covers VUID-VkOpticalFlowSessionCreatePrivateDataInfoNV-sType-sType
            if (is_const_param) {
                VkOpticalFlowSessionCreatePrivateDataInfoNV *structure = (VkOpticalFlowSessionCreatePrivateDataInfoNV *) header;
                skip |= ValidateRequiredPointer("VkOpticalFlowSessionCreatePrivateDataInfoNV", "pPrivateData", structure->pPrivateData, "VUID-VkOpticalFlowSessionCreatePrivateDataInfoNV-pPrivateData-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceLegacyDitheringFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceLegacyDitheringFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceLegacyDitheringFeaturesEXT *structure = (VkPhysicalDeviceLegacyDitheringFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceLegacyDitheringFeaturesEXT", "legacyDithering", structure->legacyDithering);
            }
        } break;

        // Validation code for VkPhysicalDevicePipelineProtectedAccessFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES_EXT: { // Covers VUID-VkPhysicalDevicePipelineProtectedAccessFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDevicePipelineProtectedAccessFeaturesEXT *structure = (VkPhysicalDevicePipelineProtectedAccessFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDevicePipelineProtectedAccessFeaturesEXT", "pipelineProtectedAccess", structure->pipelineProtectedAccess);
            }
        } break;

        // Validation code for VkPhysicalDeviceTilePropertiesFeaturesQCOM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_PROPERTIES_FEATURES_QCOM: { // Covers VUID-VkPhysicalDeviceTilePropertiesFeaturesQCOM-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceTilePropertiesFeaturesQCOM *structure = (VkPhysicalDeviceTilePropertiesFeaturesQCOM *) header;
                skip |= ValidateBool32("VkPhysicalDeviceTilePropertiesFeaturesQCOM", "tileProperties", structure->tileProperties);
            }
        } break;

        // Validation code for VkPhysicalDeviceAmigoProfilingFeaturesSEC structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_AMIGO_PROFILING_FEATURES_SEC: { // Covers VUID-VkPhysicalDeviceAmigoProfilingFeaturesSEC-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceAmigoProfilingFeaturesSEC *structure = (VkPhysicalDeviceAmigoProfilingFeaturesSEC *) header;
                skip |= ValidateBool32("VkPhysicalDeviceAmigoProfilingFeaturesSEC", "amigoProfiling", structure->amigoProfiling);
            }
        } break;

        // No Validation code for VkAmigoProfilingSubmitInfoSEC structure members  -- Covers VUID-VkAmigoProfilingSubmitInfoSEC-sType-sType

        // Validation code for VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_VIEWPORTS_FEATURES_QCOM: { // Covers VUID-VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM *structure = (VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM *) header;
                skip |= ValidateBool32("VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM", "multiviewPerViewViewports", structure->multiviewPerViewViewports);
            }
        } break;

        // No Validation code for VkPhysicalDeviceRayTracingInvocationReorderPropertiesNV structure members  -- Covers VUID-VkPhysicalDeviceRayTracingInvocationReorderPropertiesNV-sType-sType

        // Validation code for VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_FEATURES_NV: { // Covers VUID-VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV *structure = (VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV *) header;
                skip |= ValidateBool32("VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV", "rayTracingInvocationReorder", structure->rayTracingInvocationReorder);
            }
        } break;

        // Validation code for VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_FEATURES_ARM: { // Covers VUID-VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM *structure = (VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM *) header;
                skip |= ValidateBool32("VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM", "shaderCoreBuiltins", structure->shaderCoreBuiltins);
            }
        } break;

        // No Validation code for VkPhysicalDeviceShaderCoreBuiltinsPropertiesARM structure members  -- Covers VUID-VkPhysicalDeviceShaderCoreBuiltinsPropertiesARM-sType-sType

        // Validation code for VkWriteDescriptorSetAccelerationStructureKHR structure members
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR: { // Covers VUID-VkWriteDescriptorSetAccelerationStructureKHR-sType-sType
            if (is_const_param) {
                VkWriteDescriptorSetAccelerationStructureKHR *structure = (VkWriteDescriptorSetAccelerationStructureKHR *) header;
                skip |= ValidateArray("VkWriteDescriptorSetAccelerationStructureKHR", "accelerationStructureCount", "pAccelerationStructures", structure->accelerationStructureCount, &structure->pAccelerationStructures, true, false, "VUID-VkWriteDescriptorSetAccelerationStructureKHR-accelerationStructureCount-arraylength", "VUID-VkWriteDescriptorSetAccelerationStructureKHR-pAccelerationStructures-parameter");
            }
        } break;

        // Validation code for VkPhysicalDeviceAccelerationStructureFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR: { // Covers VUID-VkPhysicalDeviceAccelerationStructureFeaturesKHR-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceAccelerationStructureFeaturesKHR *structure = (VkPhysicalDeviceAccelerationStructureFeaturesKHR *) header;
                skip |= ValidateBool32("VkPhysicalDeviceAccelerationStructureFeaturesKHR", "accelerationStructure", structure->accelerationStructure);

                skip |= ValidateBool32("VkPhysicalDeviceAccelerationStructureFeaturesKHR", "accelerationStructureCaptureReplay", structure->accelerationStructureCaptureReplay);

                skip |= ValidateBool32("VkPhysicalDeviceAccelerationStructureFeaturesKHR", "accelerationStructureIndirectBuild", structure->accelerationStructureIndirectBuild);

                skip |= ValidateBool32("VkPhysicalDeviceAccelerationStructureFeaturesKHR", "accelerationStructureHostCommands", structure->accelerationStructureHostCommands);

                skip |= ValidateBool32("VkPhysicalDeviceAccelerationStructureFeaturesKHR", "descriptorBindingAccelerationStructureUpdateAfterBind", structure->descriptorBindingAccelerationStructureUpdateAfterBind);
            }
        } break;

        // No Validation code for VkPhysicalDeviceAccelerationStructurePropertiesKHR structure members  -- Covers VUID-VkPhysicalDeviceAccelerationStructurePropertiesKHR-sType-sType

        // Validation code for VkPhysicalDeviceRayTracingPipelineFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR: { // Covers VUID-VkPhysicalDeviceRayTracingPipelineFeaturesKHR-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceRayTracingPipelineFeaturesKHR *structure = (VkPhysicalDeviceRayTracingPipelineFeaturesKHR *) header;
                skip |= ValidateBool32("VkPhysicalDeviceRayTracingPipelineFeaturesKHR", "rayTracingPipeline", structure->rayTracingPipeline);

                skip |= ValidateBool32("VkPhysicalDeviceRayTracingPipelineFeaturesKHR", "rayTracingPipelineShaderGroupHandleCaptureReplay", structure->rayTracingPipelineShaderGroupHandleCaptureReplay);

                skip |= ValidateBool32("VkPhysicalDeviceRayTracingPipelineFeaturesKHR", "rayTracingPipelineShaderGroupHandleCaptureReplayMixed", structure->rayTracingPipelineShaderGroupHandleCaptureReplayMixed);

                skip |= ValidateBool32("VkPhysicalDeviceRayTracingPipelineFeaturesKHR", "rayTracingPipelineTraceRaysIndirect", structure->rayTracingPipelineTraceRaysIndirect);

                skip |= ValidateBool32("VkPhysicalDeviceRayTracingPipelineFeaturesKHR", "rayTraversalPrimitiveCulling", structure->rayTraversalPrimitiveCulling);
            }
        } break;

        // No Validation code for VkPhysicalDeviceRayTracingPipelinePropertiesKHR structure members  -- Covers VUID-VkPhysicalDeviceRayTracingPipelinePropertiesKHR-sType-sType

        // Validation code for VkPhysicalDeviceRayQueryFeaturesKHR structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR: { // Covers VUID-VkPhysicalDeviceRayQueryFeaturesKHR-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceRayQueryFeaturesKHR *structure = (VkPhysicalDeviceRayQueryFeaturesKHR *) header;
                skip |= ValidateBool32("VkPhysicalDeviceRayQueryFeaturesKHR", "rayQuery", structure->rayQuery);
            }
        } break;

        // Validation code for VkPhysicalDeviceMeshShaderFeaturesEXT structure members
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT: { // Covers VUID-VkPhysicalDeviceMeshShaderFeaturesEXT-sType-sType
            if (is_const_param) {
                VkPhysicalDeviceMeshShaderFeaturesEXT *structure = (VkPhysicalDeviceMeshShaderFeaturesEXT *) header;
                skip |= ValidateBool32("VkPhysicalDeviceMeshShaderFeaturesEXT", "taskShader", structure->taskShader);

                skip |= ValidateBool32("VkPhysicalDeviceMeshShaderFeaturesEXT", "meshShader", structure->meshShader);

                skip |= ValidateBool32("VkPhysicalDeviceMeshShaderFeaturesEXT", "multiviewMeshShader", structure->multiviewMeshShader);

                skip |= ValidateBool32("VkPhysicalDeviceMeshShaderFeaturesEXT", "primitiveFragmentShadingRateMeshShader", structure->primitiveFragmentShadingRateMeshShader);

                skip |= ValidateBool32("VkPhysicalDeviceMeshShaderFeaturesEXT", "meshShaderQueries", structure->meshShaderQueries);
            }
        } break;

        // No Validation code for VkPhysicalDeviceMeshShaderPropertiesEXT structure members  -- Covers VUID-VkPhysicalDeviceMeshShaderPropertiesEXT-sType-sType
        default:
            skip = false;
    }
    return skip;
}


bool StatelessValidation::OutputExtensionError(const std::string &api_name, const std::string &extension_name) const {
    return LogError(instance,
                    kVUID_PVError_ExtensionNotEnabled, "Attempted to call %s() but its required extension %s has not been enabled\n",
                    api_name.c_str(), extension_name.c_str());
}


bool StatelessValidation::PreCallValidateCreateInstance(
    const VkInstanceCreateInfo*                 pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkInstance*                                 pInstance) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateInstance", "pCreateInfo", "VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO, true, "VUID-vkCreateInstance-pCreateInfo-parameter", "VUID-VkInstanceCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkInstanceCreateInfo = { VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_LIST_LUNARG, VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT, VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT, VK_STRUCTURE_TYPE_INSTANCE_LAYER_SETTINGS_EXT };

        skip |= ValidateStructPnext("vkCreateInstance", "pCreateInfo->pNext", "VkDebugReportCallbackCreateInfoEXT, VkDebugUtilsMessengerCreateInfoEXT, VkDirectDriverLoadingListLUNARG, VkExportMetalObjectCreateInfoEXT, VkValidationFeaturesEXT, VkValidationFlagsEXT, VkInstanceLayerSettingsEXT", pCreateInfo->pNext, allowed_structs_VkInstanceCreateInfo.size(), allowed_structs_VkInstanceCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkInstanceCreateInfo-pNext-pNext", "VUID-VkInstanceCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags("vkCreateInstance", "pCreateInfo->flags", "VkInstanceCreateFlagBits", AllVkInstanceCreateFlagBits, pCreateInfo->flags, kOptionalFlags, "VUID-VkInstanceCreateInfo-flags-parameter");

        skip |= ValidateStructType("vkCreateInstance", "pCreateInfo->pApplicationInfo", "VK_STRUCTURE_TYPE_APPLICATION_INFO", pCreateInfo->pApplicationInfo, VK_STRUCTURE_TYPE_APPLICATION_INFO, false, "VUID-VkInstanceCreateInfo-pApplicationInfo-parameter", "VUID-VkApplicationInfo-sType-sType");

        if (pCreateInfo->pApplicationInfo != nullptr)
        {
            skip |= ValidateStructPnext("vkCreateInstance", "pCreateInfo->pApplicationInfo->pNext", nullptr, pCreateInfo->pApplicationInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkApplicationInfo-pNext-pNext", kVUIDUndefined, false, true);
        }

        skip |= ValidateStringArray("vkCreateInstance", "pCreateInfo->enabledLayerCount", "pCreateInfo->ppEnabledLayerNames", pCreateInfo->enabledLayerCount, pCreateInfo->ppEnabledLayerNames, false, true, kVUIDUndefined, "VUID-VkInstanceCreateInfo-ppEnabledLayerNames-parameter");

        skip |= ValidateStringArray("vkCreateInstance", "pCreateInfo->enabledExtensionCount", "pCreateInfo->ppEnabledExtensionNames", pCreateInfo->enabledExtensionCount, pCreateInfo->ppEnabledExtensionNames, false, true, kVUIDUndefined, "VUID-VkInstanceCreateInfo-ppEnabledExtensionNames-parameter");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateInstance", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateInstance", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateInstance", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateInstance", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateInstance", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateInstance", "pInstance", pInstance, "VUID-vkCreateInstance-pInstance-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateInstance(pCreateInfo, pAllocator, pInstance);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyInstance(
    VkInstance                                  instance,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyInstance", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyInstance", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyInstance", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyInstance", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyInstance", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateEnumeratePhysicalDevices(
    VkInstance                                  instance,
    uint32_t*                                   pPhysicalDeviceCount,
    VkPhysicalDevice*                           pPhysicalDevices) const {
    bool skip = false;
    skip |= ValidateArray("vkEnumeratePhysicalDevices", "pPhysicalDeviceCount", "pPhysicalDevices", pPhysicalDeviceCount, &pPhysicalDevices, true, false, false, kVUIDUndefined, "VUID-vkEnumeratePhysicalDevices-pPhysicalDevices-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceFeatures(
    VkPhysicalDevice                            physicalDevice,
    VkPhysicalDeviceFeatures*                   pFeatures) const {
    bool skip = false;
    skip |= ValidateRequiredPointer("vkGetPhysicalDeviceFeatures", "pFeatures", pFeatures, "VUID-vkGetPhysicalDeviceFeatures-pFeatures-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceFormatProperties(
    VkPhysicalDevice                            physicalDevice,
    VkFormat                                    format,
    VkFormatProperties*                         pFormatProperties) const {
    bool skip = false;
    skip |= ValidateRangedEnum("vkGetPhysicalDeviceFormatProperties", "format", "VkFormat", AllVkFormatEnums, format, "VUID-vkGetPhysicalDeviceFormatProperties-format-parameter");
    skip |= ValidateRequiredPointer("vkGetPhysicalDeviceFormatProperties", "pFormatProperties", pFormatProperties, "VUID-vkGetPhysicalDeviceFormatProperties-pFormatProperties-parameter");
    if (pFormatProperties != nullptr)
    {
        // No xml-driven validation
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceImageFormatProperties(
    VkPhysicalDevice                            physicalDevice,
    VkFormat                                    format,
    VkImageType                                 type,
    VkImageTiling                               tiling,
    VkImageUsageFlags                           usage,
    VkImageCreateFlags                          flags,
    VkImageFormatProperties*                    pImageFormatProperties) const {
    bool skip = false;
    skip |= ValidateRangedEnum("vkGetPhysicalDeviceImageFormatProperties", "format", "VkFormat", AllVkFormatEnums, format, "VUID-vkGetPhysicalDeviceImageFormatProperties-format-parameter");
    skip |= ValidateRangedEnum("vkGetPhysicalDeviceImageFormatProperties", "type", "VkImageType", AllVkImageTypeEnums, type, "VUID-vkGetPhysicalDeviceImageFormatProperties-type-parameter");
    skip |= ValidateRangedEnum("vkGetPhysicalDeviceImageFormatProperties", "tiling", "VkImageTiling", AllVkImageTilingEnums, tiling, "VUID-vkGetPhysicalDeviceImageFormatProperties-tiling-parameter");
    skip |= ValidateFlags("vkGetPhysicalDeviceImageFormatProperties", "usage", "VkImageUsageFlagBits", AllVkImageUsageFlagBits, usage, kRequiredFlags, "VUID-vkGetPhysicalDeviceImageFormatProperties-usage-parameter", "VUID-vkGetPhysicalDeviceImageFormatProperties-usage-requiredbitmask");
    skip |= ValidateFlags("vkGetPhysicalDeviceImageFormatProperties", "flags", "VkImageCreateFlagBits", AllVkImageCreateFlagBits, flags, kOptionalFlags, "VUID-vkGetPhysicalDeviceImageFormatProperties-flags-parameter");
    skip |= ValidateRequiredPointer("vkGetPhysicalDeviceImageFormatProperties", "pImageFormatProperties", pImageFormatProperties, "VUID-vkGetPhysicalDeviceImageFormatProperties-pImageFormatProperties-parameter");
    if (pImageFormatProperties != nullptr)
    {
        // No xml-driven validation
    }
    if (!skip) skip |= manual_PreCallValidateGetPhysicalDeviceImageFormatProperties(physicalDevice, format, type, tiling, usage, flags, pImageFormatProperties);
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceProperties(
    VkPhysicalDevice                            physicalDevice,
    VkPhysicalDeviceProperties*                 pProperties) const {
    bool skip = false;
    skip |= ValidateRequiredPointer("vkGetPhysicalDeviceProperties", "pProperties", pProperties, "VUID-vkGetPhysicalDeviceProperties-pProperties-parameter");
    if (pProperties != nullptr)
    {
        // No xml-driven validation
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceQueueFamilyProperties(
    VkPhysicalDevice                            physicalDevice,
    uint32_t*                                   pQueueFamilyPropertyCount,
    VkQueueFamilyProperties*                    pQueueFamilyProperties) const {
    bool skip = false;
    skip |= ValidateArray("vkGetPhysicalDeviceQueueFamilyProperties", "pQueueFamilyPropertyCount", "pQueueFamilyProperties", pQueueFamilyPropertyCount, &pQueueFamilyProperties, true, false, false, kVUIDUndefined, "VUID-vkGetPhysicalDeviceQueueFamilyProperties-pQueueFamilyProperties-parameter");
    if (pQueueFamilyProperties != nullptr)
    {
        for (uint32_t pQueueFamilyPropertyIndex = 0; pQueueFamilyPropertyIndex < *pQueueFamilyPropertyCount; ++pQueueFamilyPropertyIndex)
        {
            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceMemoryProperties(
    VkPhysicalDevice                            physicalDevice,
    VkPhysicalDeviceMemoryProperties*           pMemoryProperties) const {
    bool skip = false;
    skip |= ValidateRequiredPointer("vkGetPhysicalDeviceMemoryProperties", "pMemoryProperties", pMemoryProperties, "VUID-vkGetPhysicalDeviceMemoryProperties-pMemoryProperties-parameter");
    if (pMemoryProperties != nullptr)
    {
        // No xml-driven validation
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateDevice(
    VkPhysicalDevice                            physicalDevice,
    const VkDeviceCreateInfo*                   pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkDevice*                                   pDevice) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateDevice", "pCreateInfo", "VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO, true, "VUID-vkCreateDevice-pCreateInfo-parameter", "VUID-VkDeviceCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkDeviceCreateInfo = { VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV, VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO, VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD, VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ADDRESS_BINDING_REPORT_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_AMIGO_PROFILING_FEATURES_SEC, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_FEATURES_HUAWEI, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_SET_HOST_MAPPING_FEATURES_VALVE, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FAULT_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_QCOM, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_FEATURES_QCOM, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_VIEWPORTS_FEATURES_QCOM, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROPERTIES_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_BARRIER_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_FEATURES_ARM, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EARLY_AND_LATE_FRAGMENT_TESTS_FEATURES_AMD, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_MERGE_FEEDBACK_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_PROPERTIES_FEATURES_QCOM, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES };

        skip |= ValidateStructPnext("vkCreateDevice", "pCreateInfo->pNext", "VkDeviceDeviceMemoryReportCreateInfoEXT, VkDeviceDiagnosticsConfigCreateInfoNV, VkDeviceGroupDeviceCreateInfo, VkDeviceMemoryOverallocationCreateInfoAMD, VkDevicePrivateDataCreateInfo, VkPhysicalDevice16BitStorageFeatures, VkPhysicalDevice4444FormatsFeaturesEXT, VkPhysicalDevice8BitStorageFeatures, VkPhysicalDeviceASTCDecodeFeaturesEXT, VkPhysicalDeviceAccelerationStructureFeaturesKHR, VkPhysicalDeviceAddressBindingReportFeaturesEXT, VkPhysicalDeviceAmigoProfilingFeaturesSEC, VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT, VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, VkPhysicalDeviceBorderColorSwizzleFeaturesEXT, VkPhysicalDeviceBufferDeviceAddressFeatures, VkPhysicalDeviceBufferDeviceAddressFeaturesEXT, VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI, VkPhysicalDeviceCoherentMemoryFeaturesAMD, VkPhysicalDeviceColorWriteEnableFeaturesEXT, VkPhysicalDeviceComputeShaderDerivativesFeaturesNV, VkPhysicalDeviceConditionalRenderingFeaturesEXT, VkPhysicalDeviceCooperativeMatrixFeaturesNV, VkPhysicalDeviceCopyMemoryIndirectFeaturesNV, VkPhysicalDeviceCornerSampledImageFeaturesNV, VkPhysicalDeviceCoverageReductionModeFeaturesNV, VkPhysicalDeviceCustomBorderColorFeaturesEXT, VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV, VkPhysicalDeviceDepthClampZeroOneFeaturesEXT, VkPhysicalDeviceDepthClipControlFeaturesEXT, VkPhysicalDeviceDepthClipEnableFeaturesEXT, VkPhysicalDeviceDescriptorBufferFeaturesEXT, VkPhysicalDeviceDescriptorIndexingFeatures, VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE, VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV, VkPhysicalDeviceDeviceMemoryReportFeaturesEXT, VkPhysicalDeviceDiagnosticsConfigFeaturesNV, VkPhysicalDeviceDynamicRenderingFeatures, VkPhysicalDeviceExclusiveScissorFeaturesNV, VkPhysicalDeviceExtendedDynamicState2FeaturesEXT, VkPhysicalDeviceExtendedDynamicState3FeaturesEXT, VkPhysicalDeviceExtendedDynamicStateFeaturesEXT, VkPhysicalDeviceExternalMemoryRDMAFeaturesNV, VkPhysicalDeviceFaultFeaturesEXT, VkPhysicalDeviceFeatures2, VkPhysicalDeviceFragmentDensityMap2FeaturesEXT, VkPhysicalDeviceFragmentDensityMapFeaturesEXT, VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM, VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR, VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT, VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV, VkPhysicalDeviceFragmentShadingRateFeaturesKHR, VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR, VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT, VkPhysicalDeviceHostQueryResetFeatures, VkPhysicalDeviceImage2DViewOf3DFeaturesEXT, VkPhysicalDeviceImageCompressionControlFeaturesEXT, VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT, VkPhysicalDeviceImageProcessingFeaturesQCOM, VkPhysicalDeviceImageRobustnessFeatures, VkPhysicalDeviceImageViewMinLodFeaturesEXT, VkPhysicalDeviceImagelessFramebufferFeatures, VkPhysicalDeviceIndexTypeUint8FeaturesEXT, VkPhysicalDeviceInheritedViewportScissorFeaturesNV, VkPhysicalDeviceInlineUniformBlockFeatures, VkPhysicalDeviceInvocationMaskFeaturesHUAWEI, VkPhysicalDeviceLegacyDitheringFeaturesEXT, VkPhysicalDeviceLineRasterizationFeaturesEXT, VkPhysicalDeviceLinearColorAttachmentFeaturesNV, VkPhysicalDeviceMaintenance4Features, VkPhysicalDeviceMemoryDecompressionFeaturesNV, VkPhysicalDeviceMemoryPriorityFeaturesEXT, VkPhysicalDeviceMeshShaderFeaturesEXT, VkPhysicalDeviceMeshShaderFeaturesNV, VkPhysicalDeviceMultiDrawFeaturesEXT, VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT, VkPhysicalDeviceMultiviewFeatures, VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM, VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT, VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT, VkPhysicalDeviceOpacityMicromapFeaturesEXT, VkPhysicalDeviceOpticalFlowFeaturesNV, VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT, VkPhysicalDevicePerformanceQueryFeaturesKHR, VkPhysicalDevicePipelineCreationCacheControlFeatures, VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR, VkPhysicalDevicePipelinePropertiesFeaturesEXT, VkPhysicalDevicePipelineProtectedAccessFeaturesEXT, VkPhysicalDevicePipelineRobustnessFeaturesEXT, VkPhysicalDevicePortabilitySubsetFeaturesKHR, VkPhysicalDevicePresentBarrierFeaturesNV, VkPhysicalDevicePresentIdFeaturesKHR, VkPhysicalDevicePresentWaitFeaturesKHR, VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT, VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT, VkPhysicalDevicePrivateDataFeatures, VkPhysicalDeviceProtectedMemoryFeatures, VkPhysicalDeviceProvokingVertexFeaturesEXT, VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT, VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT, VkPhysicalDeviceRayQueryFeaturesKHR, VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV, VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR, VkPhysicalDeviceRayTracingMotionBlurFeaturesNV, VkPhysicalDeviceRayTracingPipelineFeaturesKHR, VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV, VkPhysicalDeviceRobustness2FeaturesEXT, VkPhysicalDeviceSamplerYcbcrConversionFeatures, VkPhysicalDeviceScalarBlockLayoutFeatures, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures, VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT, VkPhysicalDeviceShaderAtomicFloatFeaturesEXT, VkPhysicalDeviceShaderAtomicInt64Features, VkPhysicalDeviceShaderClockFeaturesKHR, VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM, VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures, VkPhysicalDeviceShaderDrawParametersFeatures, VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD, VkPhysicalDeviceShaderFloat16Int8Features, VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT, VkPhysicalDeviceShaderImageFootprintFeaturesNV, VkPhysicalDeviceShaderIntegerDotProductFeatures, VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL, VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT, VkPhysicalDeviceShaderSMBuiltinsFeaturesNV, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR, VkPhysicalDeviceShaderTerminateInvocationFeatures, VkPhysicalDeviceShadingRateImageFeaturesNV, VkPhysicalDeviceSubgroupSizeControlFeatures, VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT, VkPhysicalDeviceSubpassShadingFeaturesHUAWEI, VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT, VkPhysicalDeviceSynchronization2Features, VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT, VkPhysicalDeviceTextureCompressionASTCHDRFeatures, VkPhysicalDeviceTilePropertiesFeaturesQCOM, VkPhysicalDeviceTimelineSemaphoreFeatures, VkPhysicalDeviceTransformFeedbackFeaturesEXT, VkPhysicalDeviceUniformBufferStandardLayoutFeatures, VkPhysicalDeviceVariablePointersFeatures, VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT, VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT, VkPhysicalDeviceVulkan11Features, VkPhysicalDeviceVulkan12Features, VkPhysicalDeviceVulkan13Features, VkPhysicalDeviceVulkanMemoryModelFeatures, VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR, VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT, VkPhysicalDeviceYcbcrImageArraysFeaturesEXT, VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures", pCreateInfo->pNext, allowed_structs_VkDeviceCreateInfo.size(), allowed_structs_VkDeviceCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkDeviceCreateInfo-pNext-pNext", "VUID-VkDeviceCreateInfo-sType-unique", true, true);

        skip |= ValidateReservedFlags("vkCreateDevice", "pCreateInfo->flags", pCreateInfo->flags, "VUID-VkDeviceCreateInfo-flags-zerobitmask");

        skip |= ValidateStructTypeArray("vkCreateDevice", "pCreateInfo->queueCreateInfoCount", "pCreateInfo->pQueueCreateInfos", "VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO", pCreateInfo->queueCreateInfoCount, pCreateInfo->pQueueCreateInfos, VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO, true, true, "VUID-VkDeviceQueueCreateInfo-sType-sType", "VUID-VkDeviceCreateInfo-pQueueCreateInfos-parameter", "VUID-VkDeviceCreateInfo-queueCreateInfoCount-arraylength");

        if (pCreateInfo->pQueueCreateInfos != nullptr)
        {
            for (uint32_t queueCreateInfoIndex = 0; queueCreateInfoIndex < pCreateInfo->queueCreateInfoCount; ++queueCreateInfoIndex)
            {
                constexpr std::array allowed_structs_VkDeviceQueueCreateInfo = { VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_KHR };

                skip |= ValidateStructPnext("vkCreateDevice", ParameterName("pCreateInfo->pQueueCreateInfos[%i].pNext", ParameterName::IndexVector{ queueCreateInfoIndex }), "VkDeviceQueueGlobalPriorityCreateInfoKHR", pCreateInfo->pQueueCreateInfos[queueCreateInfoIndex].pNext, allowed_structs_VkDeviceQueueCreateInfo.size(), allowed_structs_VkDeviceQueueCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkDeviceQueueCreateInfo-pNext-pNext", "VUID-VkDeviceQueueCreateInfo-sType-unique", true, true);

                skip |= ValidateFlags("vkCreateDevice", ParameterName("pCreateInfo->pQueueCreateInfos[%i].flags", ParameterName::IndexVector{ queueCreateInfoIndex }), "VkDeviceQueueCreateFlagBits", AllVkDeviceQueueCreateFlagBits, pCreateInfo->pQueueCreateInfos[queueCreateInfoIndex].flags, kOptionalFlags, "VUID-VkDeviceQueueCreateInfo-flags-parameter");

                skip |= ValidateArray("vkCreateDevice", ParameterName("pCreateInfo->pQueueCreateInfos[%i].queueCount", ParameterName::IndexVector{ queueCreateInfoIndex }), ParameterName("pCreateInfo->pQueueCreateInfos[%i].pQueuePriorities", ParameterName::IndexVector{ queueCreateInfoIndex }), pCreateInfo->pQueueCreateInfos[queueCreateInfoIndex].queueCount, &pCreateInfo->pQueueCreateInfos[queueCreateInfoIndex].pQueuePriorities, true, true, "VUID-VkDeviceQueueCreateInfo-queueCount-arraylength", "VUID-VkDeviceQueueCreateInfo-pQueuePriorities-parameter");
            }
        }

        skip |= ValidateStringArray("vkCreateDevice", "pCreateInfo->enabledLayerCount", "pCreateInfo->ppEnabledLayerNames", pCreateInfo->enabledLayerCount, pCreateInfo->ppEnabledLayerNames, false, true, kVUIDUndefined, "VUID-VkDeviceCreateInfo-ppEnabledLayerNames-parameter");

        skip |= ValidateStringArray("vkCreateDevice", "pCreateInfo->enabledExtensionCount", "pCreateInfo->ppEnabledExtensionNames", pCreateInfo->enabledExtensionCount, pCreateInfo->ppEnabledExtensionNames, false, true, kVUIDUndefined, "VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-parameter");

        if (pCreateInfo->pEnabledFeatures != nullptr)
        {
            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->robustBufferAccess", pCreateInfo->pEnabledFeatures->robustBufferAccess);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->fullDrawIndexUint32", pCreateInfo->pEnabledFeatures->fullDrawIndexUint32);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->imageCubeArray", pCreateInfo->pEnabledFeatures->imageCubeArray);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->independentBlend", pCreateInfo->pEnabledFeatures->independentBlend);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->geometryShader", pCreateInfo->pEnabledFeatures->geometryShader);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->tessellationShader", pCreateInfo->pEnabledFeatures->tessellationShader);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->sampleRateShading", pCreateInfo->pEnabledFeatures->sampleRateShading);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->dualSrcBlend", pCreateInfo->pEnabledFeatures->dualSrcBlend);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->logicOp", pCreateInfo->pEnabledFeatures->logicOp);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->multiDrawIndirect", pCreateInfo->pEnabledFeatures->multiDrawIndirect);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->drawIndirectFirstInstance", pCreateInfo->pEnabledFeatures->drawIndirectFirstInstance);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->depthClamp", pCreateInfo->pEnabledFeatures->depthClamp);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->depthBiasClamp", pCreateInfo->pEnabledFeatures->depthBiasClamp);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->fillModeNonSolid", pCreateInfo->pEnabledFeatures->fillModeNonSolid);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->depthBounds", pCreateInfo->pEnabledFeatures->depthBounds);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->wideLines", pCreateInfo->pEnabledFeatures->wideLines);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->largePoints", pCreateInfo->pEnabledFeatures->largePoints);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->alphaToOne", pCreateInfo->pEnabledFeatures->alphaToOne);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->multiViewport", pCreateInfo->pEnabledFeatures->multiViewport);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->samplerAnisotropy", pCreateInfo->pEnabledFeatures->samplerAnisotropy);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->textureCompressionETC2", pCreateInfo->pEnabledFeatures->textureCompressionETC2);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->textureCompressionASTC_LDR", pCreateInfo->pEnabledFeatures->textureCompressionASTC_LDR);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->textureCompressionBC", pCreateInfo->pEnabledFeatures->textureCompressionBC);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->occlusionQueryPrecise", pCreateInfo->pEnabledFeatures->occlusionQueryPrecise);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->pipelineStatisticsQuery", pCreateInfo->pEnabledFeatures->pipelineStatisticsQuery);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->vertexPipelineStoresAndAtomics", pCreateInfo->pEnabledFeatures->vertexPipelineStoresAndAtomics);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->fragmentStoresAndAtomics", pCreateInfo->pEnabledFeatures->fragmentStoresAndAtomics);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->shaderTessellationAndGeometryPointSize", pCreateInfo->pEnabledFeatures->shaderTessellationAndGeometryPointSize);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->shaderImageGatherExtended", pCreateInfo->pEnabledFeatures->shaderImageGatherExtended);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->shaderStorageImageExtendedFormats", pCreateInfo->pEnabledFeatures->shaderStorageImageExtendedFormats);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->shaderStorageImageMultisample", pCreateInfo->pEnabledFeatures->shaderStorageImageMultisample);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->shaderStorageImageReadWithoutFormat", pCreateInfo->pEnabledFeatures->shaderStorageImageReadWithoutFormat);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->shaderStorageImageWriteWithoutFormat", pCreateInfo->pEnabledFeatures->shaderStorageImageWriteWithoutFormat);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->shaderUniformBufferArrayDynamicIndexing", pCreateInfo->pEnabledFeatures->shaderUniformBufferArrayDynamicIndexing);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->shaderSampledImageArrayDynamicIndexing", pCreateInfo->pEnabledFeatures->shaderSampledImageArrayDynamicIndexing);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->shaderStorageBufferArrayDynamicIndexing", pCreateInfo->pEnabledFeatures->shaderStorageBufferArrayDynamicIndexing);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->shaderStorageImageArrayDynamicIndexing", pCreateInfo->pEnabledFeatures->shaderStorageImageArrayDynamicIndexing);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->shaderClipDistance", pCreateInfo->pEnabledFeatures->shaderClipDistance);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->shaderCullDistance", pCreateInfo->pEnabledFeatures->shaderCullDistance);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->shaderFloat64", pCreateInfo->pEnabledFeatures->shaderFloat64);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->shaderInt64", pCreateInfo->pEnabledFeatures->shaderInt64);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->shaderInt16", pCreateInfo->pEnabledFeatures->shaderInt16);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->shaderResourceResidency", pCreateInfo->pEnabledFeatures->shaderResourceResidency);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->shaderResourceMinLod", pCreateInfo->pEnabledFeatures->shaderResourceMinLod);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->sparseBinding", pCreateInfo->pEnabledFeatures->sparseBinding);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->sparseResidencyBuffer", pCreateInfo->pEnabledFeatures->sparseResidencyBuffer);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->sparseResidencyImage2D", pCreateInfo->pEnabledFeatures->sparseResidencyImage2D);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->sparseResidencyImage3D", pCreateInfo->pEnabledFeatures->sparseResidencyImage3D);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->sparseResidency2Samples", pCreateInfo->pEnabledFeatures->sparseResidency2Samples);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->sparseResidency4Samples", pCreateInfo->pEnabledFeatures->sparseResidency4Samples);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->sparseResidency8Samples", pCreateInfo->pEnabledFeatures->sparseResidency8Samples);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->sparseResidency16Samples", pCreateInfo->pEnabledFeatures->sparseResidency16Samples);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->sparseResidencyAliased", pCreateInfo->pEnabledFeatures->sparseResidencyAliased);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->variableMultisampleRate", pCreateInfo->pEnabledFeatures->variableMultisampleRate);

            skip |= ValidateBool32("vkCreateDevice", "pCreateInfo->pEnabledFeatures->inheritedQueries", pCreateInfo->pEnabledFeatures->inheritedQueries);
        }
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateDevice", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateDevice", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateDevice", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateDevice", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateDevice", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateDevice", "pDevice", pDevice, "VUID-vkCreateDevice-pDevice-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateDevice(physicalDevice, pCreateInfo, pAllocator, pDevice);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyDevice(
    VkDevice                                    device,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyDevice", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyDevice", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyDevice", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyDevice", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyDevice", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetDeviceQueue(
    VkDevice                                    device,
    uint32_t                                    queueFamilyIndex,
    uint32_t                                    queueIndex,
    VkQueue*                                    pQueue) const {
    bool skip = false;
    skip |= ValidateRequiredPointer("vkGetDeviceQueue", "pQueue", pQueue, "VUID-vkGetDeviceQueue-pQueue-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateQueueSubmit(
    VkQueue                                     queue,
    uint32_t                                    submitCount,
    const VkSubmitInfo*                         pSubmits,
    VkFence                                     fence) const {
    bool skip = false;
    skip |= ValidateStructTypeArray("vkQueueSubmit", "submitCount", "pSubmits", "VK_STRUCTURE_TYPE_SUBMIT_INFO", submitCount, pSubmits, VK_STRUCTURE_TYPE_SUBMIT_INFO, false, true, "VUID-VkSubmitInfo-sType-sType", "VUID-vkQueueSubmit-pSubmits-parameter", kVUIDUndefined);
    if (pSubmits != nullptr)
    {
        for (uint32_t submitIndex = 0; submitIndex < submitCount; ++submitIndex)
        {
            constexpr std::array allowed_structs_VkSubmitInfo = { VK_STRUCTURE_TYPE_AMIGO_PROFILING_SUBMIT_INFO_SEC, VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR, VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO, VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR, VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO, VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO, VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR, VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV };

            skip |= ValidateStructPnext("vkQueueSubmit", ParameterName("pSubmits[%i].pNext", ParameterName::IndexVector{ submitIndex }), "VkAmigoProfilingSubmitInfoSEC, VkD3D12FenceSubmitInfoKHR, VkDeviceGroupSubmitInfo, VkPerformanceQuerySubmitInfoKHR, VkProtectedSubmitInfo, VkTimelineSemaphoreSubmitInfo, VkWin32KeyedMutexAcquireReleaseInfoKHR, VkWin32KeyedMutexAcquireReleaseInfoNV", pSubmits[submitIndex].pNext, allowed_structs_VkSubmitInfo.size(), allowed_structs_VkSubmitInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkSubmitInfo-pNext-pNext", "VUID-VkSubmitInfo-sType-unique", false, true);

            skip |= ValidateArray("vkQueueSubmit", ParameterName("pSubmits[%i].waitSemaphoreCount", ParameterName::IndexVector{ submitIndex }), ParameterName("pSubmits[%i].pWaitSemaphores", ParameterName::IndexVector{ submitIndex }), pSubmits[submitIndex].waitSemaphoreCount, &pSubmits[submitIndex].pWaitSemaphores, false, true, kVUIDUndefined, "VUID-VkSubmitInfo-pWaitSemaphores-parameter");

            skip |= ValidateFlagsArray("vkQueueSubmit", ParameterName("pSubmits[%i].waitSemaphoreCount", ParameterName::IndexVector{ submitIndex }), ParameterName("pSubmits[%i].pWaitDstStageMask", ParameterName::IndexVector{ submitIndex }), "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, pSubmits[submitIndex].waitSemaphoreCount, pSubmits[submitIndex].pWaitDstStageMask, false, false);

            skip |= ValidateArray("vkQueueSubmit", ParameterName("pSubmits[%i].commandBufferCount", ParameterName::IndexVector{ submitIndex }), ParameterName("pSubmits[%i].pCommandBuffers", ParameterName::IndexVector{ submitIndex }), pSubmits[submitIndex].commandBufferCount, &pSubmits[submitIndex].pCommandBuffers, false, true, kVUIDUndefined, "VUID-VkSubmitInfo-pCommandBuffers-parameter");

            skip |= ValidateArray("vkQueueSubmit", ParameterName("pSubmits[%i].signalSemaphoreCount", ParameterName::IndexVector{ submitIndex }), ParameterName("pSubmits[%i].pSignalSemaphores", ParameterName::IndexVector{ submitIndex }), pSubmits[submitIndex].signalSemaphoreCount, &pSubmits[submitIndex].pSignalSemaphores, false, true, kVUIDUndefined, "VUID-VkSubmitInfo-pSignalSemaphores-parameter");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateQueueWaitIdle(
    VkQueue                                     queue) const {
    bool skip = false;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateDeviceWaitIdle(
    VkDevice                                    device) const {
    bool skip = false;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateAllocateMemory(
    VkDevice                                    device,
    const VkMemoryAllocateInfo*                 pAllocateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkDeviceMemory*                             pMemory) const {
    bool skip = false;
    skip |= ValidateStructType("vkAllocateMemory", "pAllocateInfo", "VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO", pAllocateInfo, VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO, true, "VUID-vkAllocateMemory-pAllocateInfo-parameter", "VUID-VkMemoryAllocateInfo-sType-sType");
    if (pAllocateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkMemoryAllocateInfo = { VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV, VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO, VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV, VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR, VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV, VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID, VK_STRUCTURE_TYPE_IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA, VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR, VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT, VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR, VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV, VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA, VK_STRUCTURE_TYPE_IMPORT_METAL_BUFFER_INFO_EXT, VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO, VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO, VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO, VK_STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT };

        skip |= ValidateStructPnext("vkAllocateMemory", "pAllocateInfo->pNext", "VkDedicatedAllocationMemoryAllocateInfoNV, VkExportMemoryAllocateInfo, VkExportMemoryAllocateInfoNV, VkExportMemoryWin32HandleInfoKHR, VkExportMemoryWin32HandleInfoNV, VkExportMetalObjectCreateInfoEXT, VkImportAndroidHardwareBufferInfoANDROID, VkImportMemoryBufferCollectionFUCHSIA, VkImportMemoryFdInfoKHR, VkImportMemoryHostPointerInfoEXT, VkImportMemoryWin32HandleInfoKHR, VkImportMemoryWin32HandleInfoNV, VkImportMemoryZirconHandleInfoFUCHSIA, VkImportMetalBufferInfoEXT, VkMemoryAllocateFlagsInfo, VkMemoryDedicatedAllocateInfo, VkMemoryOpaqueCaptureAddressAllocateInfo, VkMemoryPriorityAllocateInfoEXT", pAllocateInfo->pNext, allowed_structs_VkMemoryAllocateInfo.size(), allowed_structs_VkMemoryAllocateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkMemoryAllocateInfo-pNext-pNext", "VUID-VkMemoryAllocateInfo-sType-unique", false, true);
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkAllocateMemory", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkAllocateMemory", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkAllocateMemory", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkAllocateMemory", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkAllocateMemory", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkAllocateMemory", "pMemory", pMemory, "VUID-vkAllocateMemory-pMemory-parameter");
    if (!skip) skip |= manual_PreCallValidateAllocateMemory(device, pAllocateInfo, pAllocator, pMemory);
    return skip;
}

bool StatelessValidation::PreCallValidateFreeMemory(
    VkDevice                                    device,
    VkDeviceMemory                              memory,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkFreeMemory", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkFreeMemory", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkFreeMemory", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkFreeMemory", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkFreeMemory", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateMapMemory(
    VkDevice                                    device,
    VkDeviceMemory                              memory,
    VkDeviceSize                                offset,
    VkDeviceSize                                size,
    VkMemoryMapFlags                            flags,
    void**                                      ppData) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkMapMemory", "memory", memory);
    skip |= ValidateReservedFlags("vkMapMemory", "flags", flags, "VUID-vkMapMemory-flags-zerobitmask");
    return skip;
}

bool StatelessValidation::PreCallValidateUnmapMemory(
    VkDevice                                    device,
    VkDeviceMemory                              memory) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkUnmapMemory", "memory", memory);
    return skip;
}

bool StatelessValidation::PreCallValidateFlushMappedMemoryRanges(
    VkDevice                                    device,
    uint32_t                                    memoryRangeCount,
    const VkMappedMemoryRange*                  pMemoryRanges) const {
    bool skip = false;
    skip |= ValidateStructTypeArray("vkFlushMappedMemoryRanges", "memoryRangeCount", "pMemoryRanges", "VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE", memoryRangeCount, pMemoryRanges, VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE, true, true, "VUID-VkMappedMemoryRange-sType-sType", "VUID-vkFlushMappedMemoryRanges-pMemoryRanges-parameter", "VUID-vkFlushMappedMemoryRanges-memoryRangeCount-arraylength");
    if (pMemoryRanges != nullptr)
    {
        for (uint32_t memoryRangeIndex = 0; memoryRangeIndex < memoryRangeCount; ++memoryRangeIndex)
        {
            skip |= ValidateStructPnext("vkFlushMappedMemoryRanges", ParameterName("pMemoryRanges[%i].pNext", ParameterName::IndexVector{ memoryRangeIndex }), nullptr, pMemoryRanges[memoryRangeIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkMappedMemoryRange-pNext-pNext", kVUIDUndefined, false, true);

            skip |= ValidateRequiredHandle("vkFlushMappedMemoryRanges", ParameterName("pMemoryRanges[%i].memory", ParameterName::IndexVector{ memoryRangeIndex }), pMemoryRanges[memoryRangeIndex].memory);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateInvalidateMappedMemoryRanges(
    VkDevice                                    device,
    uint32_t                                    memoryRangeCount,
    const VkMappedMemoryRange*                  pMemoryRanges) const {
    bool skip = false;
    skip |= ValidateStructTypeArray("vkInvalidateMappedMemoryRanges", "memoryRangeCount", "pMemoryRanges", "VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE", memoryRangeCount, pMemoryRanges, VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE, true, true, "VUID-VkMappedMemoryRange-sType-sType", "VUID-vkInvalidateMappedMemoryRanges-pMemoryRanges-parameter", "VUID-vkInvalidateMappedMemoryRanges-memoryRangeCount-arraylength");
    if (pMemoryRanges != nullptr)
    {
        for (uint32_t memoryRangeIndex = 0; memoryRangeIndex < memoryRangeCount; ++memoryRangeIndex)
        {
            skip |= ValidateStructPnext("vkInvalidateMappedMemoryRanges", ParameterName("pMemoryRanges[%i].pNext", ParameterName::IndexVector{ memoryRangeIndex }), nullptr, pMemoryRanges[memoryRangeIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkMappedMemoryRange-pNext-pNext", kVUIDUndefined, false, true);

            skip |= ValidateRequiredHandle("vkInvalidateMappedMemoryRanges", ParameterName("pMemoryRanges[%i].memory", ParameterName::IndexVector{ memoryRangeIndex }), pMemoryRanges[memoryRangeIndex].memory);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetDeviceMemoryCommitment(
    VkDevice                                    device,
    VkDeviceMemory                              memory,
    VkDeviceSize*                               pCommittedMemoryInBytes) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkGetDeviceMemoryCommitment", "memory", memory);
    skip |= ValidateRequiredPointer("vkGetDeviceMemoryCommitment", "pCommittedMemoryInBytes", pCommittedMemoryInBytes, "VUID-vkGetDeviceMemoryCommitment-pCommittedMemoryInBytes-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateBindBufferMemory(
    VkDevice                                    device,
    VkBuffer                                    buffer,
    VkDeviceMemory                              memory,
    VkDeviceSize                                memoryOffset) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkBindBufferMemory", "buffer", buffer);
    skip |= ValidateRequiredHandle("vkBindBufferMemory", "memory", memory);
    return skip;
}

bool StatelessValidation::PreCallValidateBindImageMemory(
    VkDevice                                    device,
    VkImage                                     image,
    VkDeviceMemory                              memory,
    VkDeviceSize                                memoryOffset) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkBindImageMemory", "image", image);
    skip |= ValidateRequiredHandle("vkBindImageMemory", "memory", memory);
    return skip;
}

bool StatelessValidation::PreCallValidateGetBufferMemoryRequirements(
    VkDevice                                    device,
    VkBuffer                                    buffer,
    VkMemoryRequirements*                       pMemoryRequirements) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkGetBufferMemoryRequirements", "buffer", buffer);
    skip |= ValidateRequiredPointer("vkGetBufferMemoryRequirements", "pMemoryRequirements", pMemoryRequirements, "VUID-vkGetBufferMemoryRequirements-pMemoryRequirements-parameter");
    if (pMemoryRequirements != nullptr)
    {
        // No xml-driven validation
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetImageMemoryRequirements(
    VkDevice                                    device,
    VkImage                                     image,
    VkMemoryRequirements*                       pMemoryRequirements) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkGetImageMemoryRequirements", "image", image);
    skip |= ValidateRequiredPointer("vkGetImageMemoryRequirements", "pMemoryRequirements", pMemoryRequirements, "VUID-vkGetImageMemoryRequirements-pMemoryRequirements-parameter");
    if (pMemoryRequirements != nullptr)
    {
        // No xml-driven validation
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetImageSparseMemoryRequirements(
    VkDevice                                    device,
    VkImage                                     image,
    uint32_t*                                   pSparseMemoryRequirementCount,
    VkSparseImageMemoryRequirements*            pSparseMemoryRequirements) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkGetImageSparseMemoryRequirements", "image", image);
    skip |= ValidateArray("vkGetImageSparseMemoryRequirements", "pSparseMemoryRequirementCount", "pSparseMemoryRequirements", pSparseMemoryRequirementCount, &pSparseMemoryRequirements, true, false, false, kVUIDUndefined, "VUID-vkGetImageSparseMemoryRequirements-pSparseMemoryRequirements-parameter");
    if (pSparseMemoryRequirements != nullptr)
    {
        for (uint32_t pSparseMemoryRequirementIndex = 0; pSparseMemoryRequirementIndex < *pSparseMemoryRequirementCount; ++pSparseMemoryRequirementIndex)
        {
            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceSparseImageFormatProperties(
    VkPhysicalDevice                            physicalDevice,
    VkFormat                                    format,
    VkImageType                                 type,
    VkSampleCountFlagBits                       samples,
    VkImageUsageFlags                           usage,
    VkImageTiling                               tiling,
    uint32_t*                                   pPropertyCount,
    VkSparseImageFormatProperties*              pProperties) const {
    bool skip = false;
    skip |= ValidateRangedEnum("vkGetPhysicalDeviceSparseImageFormatProperties", "format", "VkFormat", AllVkFormatEnums, format, "VUID-vkGetPhysicalDeviceSparseImageFormatProperties-format-parameter");
    skip |= ValidateRangedEnum("vkGetPhysicalDeviceSparseImageFormatProperties", "type", "VkImageType", AllVkImageTypeEnums, type, "VUID-vkGetPhysicalDeviceSparseImageFormatProperties-type-parameter");
    skip |= ValidateFlags("vkGetPhysicalDeviceSparseImageFormatProperties", "samples", "VkSampleCountFlagBits", AllVkSampleCountFlagBits, samples, kRequiredSingleBit, "VUID-vkGetPhysicalDeviceSparseImageFormatProperties-samples-parameter", "VUID-vkGetPhysicalDeviceSparseImageFormatProperties-samples-parameter");
    skip |= ValidateFlags("vkGetPhysicalDeviceSparseImageFormatProperties", "usage", "VkImageUsageFlagBits", AllVkImageUsageFlagBits, usage, kRequiredFlags, "VUID-vkGetPhysicalDeviceSparseImageFormatProperties-usage-parameter", "VUID-vkGetPhysicalDeviceSparseImageFormatProperties-usage-requiredbitmask");
    skip |= ValidateRangedEnum("vkGetPhysicalDeviceSparseImageFormatProperties", "tiling", "VkImageTiling", AllVkImageTilingEnums, tiling, "VUID-vkGetPhysicalDeviceSparseImageFormatProperties-tiling-parameter");
    skip |= ValidateArray("vkGetPhysicalDeviceSparseImageFormatProperties", "pPropertyCount", "pProperties", pPropertyCount, &pProperties, true, false, false, kVUIDUndefined, "VUID-vkGetPhysicalDeviceSparseImageFormatProperties-pProperties-parameter");
    if (pProperties != nullptr)
    {
        for (uint32_t pPropertyIndex = 0; pPropertyIndex < *pPropertyCount; ++pPropertyIndex)
        {
            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateQueueBindSparse(
    VkQueue                                     queue,
    uint32_t                                    bindInfoCount,
    const VkBindSparseInfo*                     pBindInfo,
    VkFence                                     fence) const {
    bool skip = false;
    skip |= ValidateStructTypeArray("vkQueueBindSparse", "bindInfoCount", "pBindInfo", "VK_STRUCTURE_TYPE_BIND_SPARSE_INFO", bindInfoCount, pBindInfo, VK_STRUCTURE_TYPE_BIND_SPARSE_INFO, false, true, "VUID-VkBindSparseInfo-sType-sType", "VUID-vkQueueBindSparse-pBindInfo-parameter", kVUIDUndefined);
    if (pBindInfo != nullptr)
    {
        for (uint32_t bindInfoIndex = 0; bindInfoIndex < bindInfoCount; ++bindInfoIndex)
        {
            constexpr std::array allowed_structs_VkBindSparseInfo = { VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO, VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO };

            skip |= ValidateStructPnext("vkQueueBindSparse", ParameterName("pBindInfo[%i].pNext", ParameterName::IndexVector{ bindInfoIndex }), "VkDeviceGroupBindSparseInfo, VkTimelineSemaphoreSubmitInfo", pBindInfo[bindInfoIndex].pNext, allowed_structs_VkBindSparseInfo.size(), allowed_structs_VkBindSparseInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkBindSparseInfo-pNext-pNext", "VUID-VkBindSparseInfo-sType-unique", false, true);

            skip |= ValidateArray("vkQueueBindSparse", ParameterName("pBindInfo[%i].waitSemaphoreCount", ParameterName::IndexVector{ bindInfoIndex }), ParameterName("pBindInfo[%i].pWaitSemaphores", ParameterName::IndexVector{ bindInfoIndex }), pBindInfo[bindInfoIndex].waitSemaphoreCount, &pBindInfo[bindInfoIndex].pWaitSemaphores, false, true, kVUIDUndefined, "VUID-VkBindSparseInfo-pWaitSemaphores-parameter");

            skip |= ValidateArray("vkQueueBindSparse", ParameterName("pBindInfo[%i].bufferBindCount", ParameterName::IndexVector{ bindInfoIndex }), ParameterName("pBindInfo[%i].pBufferBinds", ParameterName::IndexVector{ bindInfoIndex }), pBindInfo[bindInfoIndex].bufferBindCount, &pBindInfo[bindInfoIndex].pBufferBinds, false, true, kVUIDUndefined, "VUID-VkBindSparseInfo-pBufferBinds-parameter");

            if (pBindInfo[bindInfoIndex].pBufferBinds != nullptr)
            {
                for (uint32_t bufferBindIndex = 0; bufferBindIndex < pBindInfo[bindInfoIndex].bufferBindCount; ++bufferBindIndex)
                {
                    skip |= ValidateRequiredHandle("vkQueueBindSparse", ParameterName("pBindInfo[%i].pBufferBinds[%i].buffer", ParameterName::IndexVector{ bindInfoIndex, bufferBindIndex }), pBindInfo[bindInfoIndex].pBufferBinds[bufferBindIndex].buffer);

                    skip |= ValidateArray("vkQueueBindSparse", ParameterName("pBindInfo[%i].pBufferBinds[%i].bindCount", ParameterName::IndexVector{ bindInfoIndex, bufferBindIndex }), ParameterName("pBindInfo[%i].pBufferBinds[%i].pBinds", ParameterName::IndexVector{ bindInfoIndex, bufferBindIndex }), pBindInfo[bindInfoIndex].pBufferBinds[bufferBindIndex].bindCount, &pBindInfo[bindInfoIndex].pBufferBinds[bufferBindIndex].pBinds, true, true, "VUID-VkSparseBufferMemoryBindInfo-bindCount-arraylength", "VUID-VkSparseBufferMemoryBindInfo-pBinds-parameter");

                    if (pBindInfo[bindInfoIndex].pBufferBinds[bufferBindIndex].pBinds != nullptr)
                    {
                        for (uint32_t bindIndex = 0; bindIndex < pBindInfo[bindInfoIndex].pBufferBinds[bufferBindIndex].bindCount; ++bindIndex)
                        {
                            skip |= ValidateFlags("vkQueueBindSparse", ParameterName("pBindInfo[%i].pBufferBinds[%i].pBinds[%i].flags", ParameterName::IndexVector{ bindInfoIndex, bufferBindIndex, bindIndex }), "VkSparseMemoryBindFlagBits", AllVkSparseMemoryBindFlagBits, pBindInfo[bindInfoIndex].pBufferBinds[bufferBindIndex].pBinds[bindIndex].flags, kOptionalFlags, "VUID-VkSparseMemoryBind-flags-parameter");
                        }
                    }
                }
            }

            skip |= ValidateArray("vkQueueBindSparse", ParameterName("pBindInfo[%i].imageOpaqueBindCount", ParameterName::IndexVector{ bindInfoIndex }), ParameterName("pBindInfo[%i].pImageOpaqueBinds", ParameterName::IndexVector{ bindInfoIndex }), pBindInfo[bindInfoIndex].imageOpaqueBindCount, &pBindInfo[bindInfoIndex].pImageOpaqueBinds, false, true, kVUIDUndefined, "VUID-VkBindSparseInfo-pImageOpaqueBinds-parameter");

            if (pBindInfo[bindInfoIndex].pImageOpaqueBinds != nullptr)
            {
                for (uint32_t imageOpaqueBindIndex = 0; imageOpaqueBindIndex < pBindInfo[bindInfoIndex].imageOpaqueBindCount; ++imageOpaqueBindIndex)
                {
                    skip |= ValidateRequiredHandle("vkQueueBindSparse", ParameterName("pBindInfo[%i].pImageOpaqueBinds[%i].image", ParameterName::IndexVector{ bindInfoIndex, imageOpaqueBindIndex }), pBindInfo[bindInfoIndex].pImageOpaqueBinds[imageOpaqueBindIndex].image);

                    skip |= ValidateArray("vkQueueBindSparse", ParameterName("pBindInfo[%i].pImageOpaqueBinds[%i].bindCount", ParameterName::IndexVector{ bindInfoIndex, imageOpaqueBindIndex }), ParameterName("pBindInfo[%i].pImageOpaqueBinds[%i].pBinds", ParameterName::IndexVector{ bindInfoIndex, imageOpaqueBindIndex }), pBindInfo[bindInfoIndex].pImageOpaqueBinds[imageOpaqueBindIndex].bindCount, &pBindInfo[bindInfoIndex].pImageOpaqueBinds[imageOpaqueBindIndex].pBinds, true, true, "VUID-VkSparseImageOpaqueMemoryBindInfo-bindCount-arraylength", "VUID-VkSparseImageOpaqueMemoryBindInfo-pBinds-parameter");

                    if (pBindInfo[bindInfoIndex].pImageOpaqueBinds[imageOpaqueBindIndex].pBinds != nullptr)
                    {
                        for (uint32_t bindIndex = 0; bindIndex < pBindInfo[bindInfoIndex].pImageOpaqueBinds[imageOpaqueBindIndex].bindCount; ++bindIndex)
                        {
                            skip |= ValidateFlags("vkQueueBindSparse", ParameterName("pBindInfo[%i].pImageOpaqueBinds[%i].pBinds[%i].flags", ParameterName::IndexVector{ bindInfoIndex, imageOpaqueBindIndex, bindIndex }), "VkSparseMemoryBindFlagBits", AllVkSparseMemoryBindFlagBits, pBindInfo[bindInfoIndex].pImageOpaqueBinds[imageOpaqueBindIndex].pBinds[bindIndex].flags, kOptionalFlags, "VUID-VkSparseMemoryBind-flags-parameter");
                        }
                    }
                }
            }

            skip |= ValidateArray("vkQueueBindSparse", ParameterName("pBindInfo[%i].imageBindCount", ParameterName::IndexVector{ bindInfoIndex }), ParameterName("pBindInfo[%i].pImageBinds", ParameterName::IndexVector{ bindInfoIndex }), pBindInfo[bindInfoIndex].imageBindCount, &pBindInfo[bindInfoIndex].pImageBinds, false, true, kVUIDUndefined, "VUID-VkBindSparseInfo-pImageBinds-parameter");

            if (pBindInfo[bindInfoIndex].pImageBinds != nullptr)
            {
                for (uint32_t imageBindIndex = 0; imageBindIndex < pBindInfo[bindInfoIndex].imageBindCount; ++imageBindIndex)
                {
                    skip |= ValidateRequiredHandle("vkQueueBindSparse", ParameterName("pBindInfo[%i].pImageBinds[%i].image", ParameterName::IndexVector{ bindInfoIndex, imageBindIndex }), pBindInfo[bindInfoIndex].pImageBinds[imageBindIndex].image);

                    skip |= ValidateArray("vkQueueBindSparse", ParameterName("pBindInfo[%i].pImageBinds[%i].bindCount", ParameterName::IndexVector{ bindInfoIndex, imageBindIndex }), ParameterName("pBindInfo[%i].pImageBinds[%i].pBinds", ParameterName::IndexVector{ bindInfoIndex, imageBindIndex }), pBindInfo[bindInfoIndex].pImageBinds[imageBindIndex].bindCount, &pBindInfo[bindInfoIndex].pImageBinds[imageBindIndex].pBinds, true, true, "VUID-VkSparseImageMemoryBindInfo-bindCount-arraylength", "VUID-VkSparseImageMemoryBindInfo-pBinds-parameter");

                    if (pBindInfo[bindInfoIndex].pImageBinds[imageBindIndex].pBinds != nullptr)
                    {
                        for (uint32_t bindIndex = 0; bindIndex < pBindInfo[bindInfoIndex].pImageBinds[imageBindIndex].bindCount; ++bindIndex)
                        {
                            skip |= ValidateFlags("vkQueueBindSparse", ParameterName("pBindInfo[%i].pImageBinds[%i].pBinds[%i].subresource.aspectMask", ParameterName::IndexVector{ bindInfoIndex, imageBindIndex, bindIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pBindInfo[bindInfoIndex].pImageBinds[imageBindIndex].pBinds[bindIndex].subresource.aspectMask, kRequiredFlags, "VUID-VkImageSubresource-aspectMask-parameter", "VUID-VkImageSubresource-aspectMask-requiredbitmask");

                            // No xml-driven validation

                            // No xml-driven validation

                            skip |= ValidateFlags("vkQueueBindSparse", ParameterName("pBindInfo[%i].pImageBinds[%i].pBinds[%i].flags", ParameterName::IndexVector{ bindInfoIndex, imageBindIndex, bindIndex }), "VkSparseMemoryBindFlagBits", AllVkSparseMemoryBindFlagBits, pBindInfo[bindInfoIndex].pImageBinds[imageBindIndex].pBinds[bindIndex].flags, kOptionalFlags, "VUID-VkSparseImageMemoryBind-flags-parameter");
                        }
                    }
                }
            }

            skip |= ValidateArray("vkQueueBindSparse", ParameterName("pBindInfo[%i].signalSemaphoreCount", ParameterName::IndexVector{ bindInfoIndex }), ParameterName("pBindInfo[%i].pSignalSemaphores", ParameterName::IndexVector{ bindInfoIndex }), pBindInfo[bindInfoIndex].signalSemaphoreCount, &pBindInfo[bindInfoIndex].pSignalSemaphores, false, true, kVUIDUndefined, "VUID-VkBindSparseInfo-pSignalSemaphores-parameter");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateFence(
    VkDevice                                    device,
    const VkFenceCreateInfo*                    pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkFence*                                    pFence) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateFence", "pCreateInfo", "VK_STRUCTURE_TYPE_FENCE_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_FENCE_CREATE_INFO, true, "VUID-vkCreateFence-pCreateInfo-parameter", "VUID-VkFenceCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkFenceCreateInfo = { VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO, VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR };

        skip |= ValidateStructPnext("vkCreateFence", "pCreateInfo->pNext", "VkExportFenceCreateInfo, VkExportFenceWin32HandleInfoKHR", pCreateInfo->pNext, allowed_structs_VkFenceCreateInfo.size(), allowed_structs_VkFenceCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkFenceCreateInfo-pNext-pNext", "VUID-VkFenceCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags("vkCreateFence", "pCreateInfo->flags", "VkFenceCreateFlagBits", AllVkFenceCreateFlagBits, pCreateInfo->flags, kOptionalFlags, "VUID-VkFenceCreateInfo-flags-parameter");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateFence", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateFence", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateFence", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateFence", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateFence", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateFence", "pFence", pFence, "VUID-vkCreateFence-pFence-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyFence(
    VkDevice                                    device,
    VkFence                                     fence,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyFence", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyFence", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyFence", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyFence", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyFence", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateResetFences(
    VkDevice                                    device,
    uint32_t                                    fenceCount,
    const VkFence*                              pFences) const {
    bool skip = false;
    skip |= ValidateHandleArray("vkResetFences", "fenceCount", "pFences", fenceCount, pFences, true, true, "VUID-vkResetFences-fenceCount-arraylength");
    return skip;
}

bool StatelessValidation::PreCallValidateGetFenceStatus(
    VkDevice                                    device,
    VkFence                                     fence) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkGetFenceStatus", "fence", fence);
    return skip;
}

bool StatelessValidation::PreCallValidateWaitForFences(
    VkDevice                                    device,
    uint32_t                                    fenceCount,
    const VkFence*                              pFences,
    VkBool32                                    waitAll,
    uint64_t                                    timeout) const {
    bool skip = false;
    skip |= ValidateHandleArray("vkWaitForFences", "fenceCount", "pFences", fenceCount, pFences, true, true, "VUID-vkWaitForFences-fenceCount-arraylength");
    skip |= ValidateBool32("vkWaitForFences", "waitAll", waitAll);
    return skip;
}

bool StatelessValidation::PreCallValidateCreateSemaphore(
    VkDevice                                    device,
    const VkSemaphoreCreateInfo*                pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkSemaphore*                                pSemaphore) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateSemaphore", "pCreateInfo", "VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO, true, "VUID-vkCreateSemaphore-pCreateInfo-parameter", "VUID-VkSemaphoreCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkSemaphoreCreateInfo = { VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO, VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR, VK_STRUCTURE_TYPE_IMPORT_METAL_SHARED_EVENT_INFO_EXT, VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO };

        skip |= ValidateStructPnext("vkCreateSemaphore", "pCreateInfo->pNext", "VkExportMetalObjectCreateInfoEXT, VkExportSemaphoreCreateInfo, VkExportSemaphoreWin32HandleInfoKHR, VkImportMetalSharedEventInfoEXT, VkSemaphoreTypeCreateInfo", pCreateInfo->pNext, allowed_structs_VkSemaphoreCreateInfo.size(), allowed_structs_VkSemaphoreCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkSemaphoreCreateInfo-pNext-pNext", "VUID-VkSemaphoreCreateInfo-sType-unique", false, true);

        skip |= ValidateReservedFlags("vkCreateSemaphore", "pCreateInfo->flags", pCreateInfo->flags, "VUID-VkSemaphoreCreateInfo-flags-zerobitmask");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateSemaphore", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateSemaphore", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateSemaphore", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateSemaphore", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateSemaphore", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateSemaphore", "pSemaphore", pSemaphore, "VUID-vkCreateSemaphore-pSemaphore-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateSemaphore(device, pCreateInfo, pAllocator, pSemaphore);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroySemaphore(
    VkDevice                                    device,
    VkSemaphore                                 semaphore,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroySemaphore", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroySemaphore", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroySemaphore", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroySemaphore", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroySemaphore", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateEvent(
    VkDevice                                    device,
    const VkEventCreateInfo*                    pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkEvent*                                    pEvent) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateEvent", "pCreateInfo", "VK_STRUCTURE_TYPE_EVENT_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_EVENT_CREATE_INFO, true, "VUID-vkCreateEvent-pCreateInfo-parameter", "VUID-VkEventCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkEventCreateInfo = { VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_IMPORT_METAL_SHARED_EVENT_INFO_EXT };

        skip |= ValidateStructPnext("vkCreateEvent", "pCreateInfo->pNext", "VkExportMetalObjectCreateInfoEXT, VkImportMetalSharedEventInfoEXT", pCreateInfo->pNext, allowed_structs_VkEventCreateInfo.size(), allowed_structs_VkEventCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkEventCreateInfo-pNext-pNext", "VUID-VkEventCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags("vkCreateEvent", "pCreateInfo->flags", "VkEventCreateFlagBits", AllVkEventCreateFlagBits, pCreateInfo->flags, kOptionalFlags, "VUID-VkEventCreateInfo-flags-parameter");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateEvent", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateEvent", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateEvent", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateEvent", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateEvent", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateEvent", "pEvent", pEvent, "VUID-vkCreateEvent-pEvent-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateEvent(device, pCreateInfo, pAllocator, pEvent);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyEvent(
    VkDevice                                    device,
    VkEvent                                     event,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyEvent", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyEvent", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyEvent", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyEvent", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyEvent", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetEventStatus(
    VkDevice                                    device,
    VkEvent                                     event) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkGetEventStatus", "event", event);
    return skip;
}

bool StatelessValidation::PreCallValidateSetEvent(
    VkDevice                                    device,
    VkEvent                                     event) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkSetEvent", "event", event);
    return skip;
}

bool StatelessValidation::PreCallValidateResetEvent(
    VkDevice                                    device,
    VkEvent                                     event) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkResetEvent", "event", event);
    return skip;
}

bool StatelessValidation::PreCallValidateCreateQueryPool(
    VkDevice                                    device,
    const VkQueryPoolCreateInfo*                pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkQueryPool*                                pQueryPool) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateQueryPool", "pCreateInfo", "VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO, true, "VUID-vkCreateQueryPool-pCreateInfo-parameter", "VUID-VkQueryPoolCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkQueryPoolCreateInfo = { VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR, VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL, VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PROFILE_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_DECODE_USAGE_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PROFILE_INFO_EXT, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PROFILE_INFO_EXT, VK_STRUCTURE_TYPE_VIDEO_ENCODE_USAGE_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR };

        skip |= ValidateStructPnext("vkCreateQueryPool", "pCreateInfo->pNext", "VkQueryPoolPerformanceCreateInfoKHR, VkQueryPoolPerformanceQueryCreateInfoINTEL, VkVideoDecodeH264ProfileInfoKHR, VkVideoDecodeH265ProfileInfoKHR, VkVideoDecodeUsageInfoKHR, VkVideoEncodeH264ProfileInfoEXT, VkVideoEncodeH265ProfileInfoEXT, VkVideoEncodeUsageInfoKHR, VkVideoProfileInfoKHR", pCreateInfo->pNext, allowed_structs_VkQueryPoolCreateInfo.size(), allowed_structs_VkQueryPoolCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkQueryPoolCreateInfo-pNext-pNext", "VUID-VkQueryPoolCreateInfo-sType-unique", false, true);

        skip |= ValidateReservedFlags("vkCreateQueryPool", "pCreateInfo->flags", pCreateInfo->flags, "VUID-VkQueryPoolCreateInfo-flags-zerobitmask");

        skip |= ValidateRangedEnum("vkCreateQueryPool", "pCreateInfo->queryType", "VkQueryType", AllVkQueryTypeEnums, pCreateInfo->queryType, "VUID-VkQueryPoolCreateInfo-queryType-parameter");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateQueryPool", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateQueryPool", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateQueryPool", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateQueryPool", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateQueryPool", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateQueryPool", "pQueryPool", pQueryPool, "VUID-vkCreateQueryPool-pQueryPool-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateQueryPool(device, pCreateInfo, pAllocator, pQueryPool);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyQueryPool(
    VkDevice                                    device,
    VkQueryPool                                 queryPool,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyQueryPool", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyQueryPool", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyQueryPool", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyQueryPool", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyQueryPool", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetQueryPoolResults(
    VkDevice                                    device,
    VkQueryPool                                 queryPool,
    uint32_t                                    firstQuery,
    uint32_t                                    queryCount,
    size_t                                      dataSize,
    void*                                       pData,
    VkDeviceSize                                stride,
    VkQueryResultFlags                          flags) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkGetQueryPoolResults", "queryPool", queryPool);
    skip |= ValidateArray("vkGetQueryPoolResults", "dataSize", "pData", dataSize, &pData, true, true, "VUID-vkGetQueryPoolResults-dataSize-arraylength", "VUID-vkGetQueryPoolResults-pData-parameter");
    skip |= ValidateFlags("vkGetQueryPoolResults", "flags", "VkQueryResultFlagBits", AllVkQueryResultFlagBits, flags, kOptionalFlags, "VUID-vkGetQueryPoolResults-flags-parameter");
    if (!skip) skip |= manual_PreCallValidateGetQueryPoolResults(device, queryPool, firstQuery, queryCount, dataSize, pData, stride, flags);
    return skip;
}

bool StatelessValidation::PreCallValidateCreateBuffer(
    VkDevice                                    device,
    const VkBufferCreateInfo*                   pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkBuffer*                                   pBuffer) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateBuffer", "pCreateInfo", "VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO, true, "VUID-vkCreateBuffer-pCreateInfo-parameter", "VUID-VkBufferCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkBufferCreateInfo = { VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA, VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO, VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV, VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO, VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR };

        skip |= ValidateStructPnext("vkCreateBuffer", "pCreateInfo->pNext", "VkBufferCollectionBufferCreateInfoFUCHSIA, VkBufferDeviceAddressCreateInfoEXT, VkBufferOpaqueCaptureAddressCreateInfo, VkDedicatedAllocationBufferCreateInfoNV, VkExternalMemoryBufferCreateInfo, VkOpaqueCaptureDescriptorDataCreateInfoEXT, VkVideoProfileListInfoKHR", pCreateInfo->pNext, allowed_structs_VkBufferCreateInfo.size(), allowed_structs_VkBufferCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkBufferCreateInfo-pNext-pNext", "VUID-VkBufferCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags("vkCreateBuffer", "pCreateInfo->flags", "VkBufferCreateFlagBits", AllVkBufferCreateFlagBits, pCreateInfo->flags, kOptionalFlags, "VUID-VkBufferCreateInfo-flags-parameter");

        skip |= ValidateFlags("vkCreateBuffer", "pCreateInfo->usage", "VkBufferUsageFlagBits", AllVkBufferUsageFlagBits, pCreateInfo->usage, kRequiredFlags, "VUID-VkBufferCreateInfo-usage-parameter", "VUID-VkBufferCreateInfo-usage-requiredbitmask");

        skip |= ValidateRangedEnum("vkCreateBuffer", "pCreateInfo->sharingMode", "VkSharingMode", AllVkSharingModeEnums, pCreateInfo->sharingMode, "VUID-VkBufferCreateInfo-sharingMode-parameter");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateBuffer", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateBuffer", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateBuffer", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateBuffer", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateBuffer", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateBuffer", "pBuffer", pBuffer, "VUID-vkCreateBuffer-pBuffer-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateBuffer(device, pCreateInfo, pAllocator, pBuffer);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyBuffer(
    VkDevice                                    device,
    VkBuffer                                    buffer,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyBuffer", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyBuffer", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyBuffer", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyBuffer", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyBuffer", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateBufferView(
    VkDevice                                    device,
    const VkBufferViewCreateInfo*               pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkBufferView*                               pView) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateBufferView", "pCreateInfo", "VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO, true, "VUID-vkCreateBufferView-pCreateInfo-parameter", "VUID-VkBufferViewCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkBufferViewCreateInfo = { VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT };

        skip |= ValidateStructPnext("vkCreateBufferView", "pCreateInfo->pNext", "VkExportMetalObjectCreateInfoEXT", pCreateInfo->pNext, allowed_structs_VkBufferViewCreateInfo.size(), allowed_structs_VkBufferViewCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkBufferViewCreateInfo-pNext-pNext", "VUID-VkBufferViewCreateInfo-sType-unique", false, true);

        skip |= ValidateReservedFlags("vkCreateBufferView", "pCreateInfo->flags", pCreateInfo->flags, "VUID-VkBufferViewCreateInfo-flags-zerobitmask");

        skip |= ValidateRequiredHandle("vkCreateBufferView", "pCreateInfo->buffer", pCreateInfo->buffer);

        skip |= ValidateRangedEnum("vkCreateBufferView", "pCreateInfo->format", "VkFormat", AllVkFormatEnums, pCreateInfo->format, "VUID-VkBufferViewCreateInfo-format-parameter");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateBufferView", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateBufferView", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateBufferView", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateBufferView", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateBufferView", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateBufferView", "pView", pView, "VUID-vkCreateBufferView-pView-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateBufferView(device, pCreateInfo, pAllocator, pView);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyBufferView(
    VkDevice                                    device,
    VkBufferView                                bufferView,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyBufferView", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyBufferView", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyBufferView", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyBufferView", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyBufferView", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateImage(
    VkDevice                                    device,
    const VkImageCreateInfo*                    pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkImage*                                    pImage) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateImage", "pCreateInfo", "VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO, true, "VUID-vkCreateImage-pCreateInfo-parameter", "VUID-VkImageCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkImageCreateInfo = { VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA, VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV, VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID, VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO, VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV, VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT, VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO, VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO, VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR, VK_STRUCTURE_TYPE_IMPORT_METAL_IO_SURFACE_INFO_EXT, VK_STRUCTURE_TYPE_IMPORT_METAL_TEXTURE_INFO_EXT, VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_INFO_NV, VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR };

        skip |= ValidateStructPnext("vkCreateImage", "pCreateInfo->pNext", "VkBufferCollectionImageCreateInfoFUCHSIA, VkDedicatedAllocationImageCreateInfoNV, VkExportMetalObjectCreateInfoEXT, VkExternalFormatANDROID, VkExternalMemoryImageCreateInfo, VkExternalMemoryImageCreateInfoNV, VkImageCompressionControlEXT, VkImageDrmFormatModifierExplicitCreateInfoEXT, VkImageDrmFormatModifierListCreateInfoEXT, VkImageFormatListCreateInfo, VkImageStencilUsageCreateInfo, VkImageSwapchainCreateInfoKHR, VkImportMetalIOSurfaceInfoEXT, VkImportMetalTextureInfoEXT, VkOpaqueCaptureDescriptorDataCreateInfoEXT, VkOpticalFlowImageFormatInfoNV, VkVideoProfileListInfoKHR", pCreateInfo->pNext, allowed_structs_VkImageCreateInfo.size(), allowed_structs_VkImageCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkImageCreateInfo-pNext-pNext", "VUID-VkImageCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags("vkCreateImage", "pCreateInfo->flags", "VkImageCreateFlagBits", AllVkImageCreateFlagBits, pCreateInfo->flags, kOptionalFlags, "VUID-VkImageCreateInfo-flags-parameter");

        skip |= ValidateRangedEnum("vkCreateImage", "pCreateInfo->imageType", "VkImageType", AllVkImageTypeEnums, pCreateInfo->imageType, "VUID-VkImageCreateInfo-imageType-parameter");

        skip |= ValidateRangedEnum("vkCreateImage", "pCreateInfo->format", "VkFormat", AllVkFormatEnums, pCreateInfo->format, "VUID-VkImageCreateInfo-format-parameter");

        // No xml-driven validation

        skip |= ValidateFlags("vkCreateImage", "pCreateInfo->samples", "VkSampleCountFlagBits", AllVkSampleCountFlagBits, pCreateInfo->samples, kRequiredSingleBit, "VUID-VkImageCreateInfo-samples-parameter", "VUID-VkImageCreateInfo-samples-parameter");

        skip |= ValidateRangedEnum("vkCreateImage", "pCreateInfo->tiling", "VkImageTiling", AllVkImageTilingEnums, pCreateInfo->tiling, "VUID-VkImageCreateInfo-tiling-parameter");

        skip |= ValidateFlags("vkCreateImage", "pCreateInfo->usage", "VkImageUsageFlagBits", AllVkImageUsageFlagBits, pCreateInfo->usage, kRequiredFlags, "VUID-VkImageCreateInfo-usage-parameter", "VUID-VkImageCreateInfo-usage-requiredbitmask");

        skip |= ValidateRangedEnum("vkCreateImage", "pCreateInfo->sharingMode", "VkSharingMode", AllVkSharingModeEnums, pCreateInfo->sharingMode, "VUID-VkImageCreateInfo-sharingMode-parameter");

        skip |= ValidateRangedEnum("vkCreateImage", "pCreateInfo->initialLayout", "VkImageLayout", AllVkImageLayoutEnums, pCreateInfo->initialLayout, "VUID-VkImageCreateInfo-initialLayout-parameter");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateImage", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateImage", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateImage", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateImage", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateImage", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateImage", "pImage", pImage, "VUID-vkCreateImage-pImage-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateImage(device, pCreateInfo, pAllocator, pImage);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyImage(
    VkDevice                                    device,
    VkImage                                     image,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyImage", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyImage", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyImage", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyImage", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyImage", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetImageSubresourceLayout(
    VkDevice                                    device,
    VkImage                                     image,
    const VkImageSubresource*                   pSubresource,
    VkSubresourceLayout*                        pLayout) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkGetImageSubresourceLayout", "image", image);
    skip |= ValidateRequiredPointer("vkGetImageSubresourceLayout", "pSubresource", pSubresource, "VUID-vkGetImageSubresourceLayout-pSubresource-parameter");
    if (pSubresource != nullptr)
    {
        skip |= ValidateFlags("vkGetImageSubresourceLayout", "pSubresource->aspectMask", "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pSubresource->aspectMask, kRequiredFlags, "VUID-VkImageSubresource-aspectMask-parameter", "VUID-VkImageSubresource-aspectMask-requiredbitmask");
    }
    skip |= ValidateRequiredPointer("vkGetImageSubresourceLayout", "pLayout", pLayout, "VUID-vkGetImageSubresourceLayout-pLayout-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCreateImageView(
    VkDevice                                    device,
    const VkImageViewCreateInfo*                pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkImageView*                                pView) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateImageView", "pCreateInfo", "VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO, true, "VUID-vkCreateImageView-pCreateInfo-parameter", "VUID-VkImageViewCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkImageViewCreateInfo = { VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT, VK_STRUCTURE_TYPE_IMAGE_VIEW_MIN_LOD_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_IMAGE_VIEW_SAMPLE_WEIGHT_CREATE_INFO_QCOM, VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO, VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO };

        skip |= ValidateStructPnext("vkCreateImageView", "pCreateInfo->pNext", "VkExportMetalObjectCreateInfoEXT, VkImageViewASTCDecodeModeEXT, VkImageViewMinLodCreateInfoEXT, VkImageViewSampleWeightCreateInfoQCOM, VkImageViewUsageCreateInfo, VkOpaqueCaptureDescriptorDataCreateInfoEXT, VkSamplerYcbcrConversionInfo", pCreateInfo->pNext, allowed_structs_VkImageViewCreateInfo.size(), allowed_structs_VkImageViewCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkImageViewCreateInfo-pNext-pNext", "VUID-VkImageViewCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags("vkCreateImageView", "pCreateInfo->flags", "VkImageViewCreateFlagBits", AllVkImageViewCreateFlagBits, pCreateInfo->flags, kOptionalFlags, "VUID-VkImageViewCreateInfo-flags-parameter");

        skip |= ValidateRequiredHandle("vkCreateImageView", "pCreateInfo->image", pCreateInfo->image);

        skip |= ValidateRangedEnum("vkCreateImageView", "pCreateInfo->viewType", "VkImageViewType", AllVkImageViewTypeEnums, pCreateInfo->viewType, "VUID-VkImageViewCreateInfo-viewType-parameter");

        skip |= ValidateRangedEnum("vkCreateImageView", "pCreateInfo->format", "VkFormat", AllVkFormatEnums, pCreateInfo->format, "VUID-VkImageViewCreateInfo-format-parameter");

        skip |= ValidateRangedEnum("vkCreateImageView", "pCreateInfo->components.r", "VkComponentSwizzle", AllVkComponentSwizzleEnums, pCreateInfo->components.r, "VUID-VkComponentMapping-r-parameter");

        skip |= ValidateRangedEnum("vkCreateImageView", "pCreateInfo->components.g", "VkComponentSwizzle", AllVkComponentSwizzleEnums, pCreateInfo->components.g, "VUID-VkComponentMapping-g-parameter");

        skip |= ValidateRangedEnum("vkCreateImageView", "pCreateInfo->components.b", "VkComponentSwizzle", AllVkComponentSwizzleEnums, pCreateInfo->components.b, "VUID-VkComponentMapping-b-parameter");

        skip |= ValidateRangedEnum("vkCreateImageView", "pCreateInfo->components.a", "VkComponentSwizzle", AllVkComponentSwizzleEnums, pCreateInfo->components.a, "VUID-VkComponentMapping-a-parameter");

        skip |= ValidateFlags("vkCreateImageView", "pCreateInfo->subresourceRange.aspectMask", "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pCreateInfo->subresourceRange.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceRange-aspectMask-parameter", "VUID-VkImageSubresourceRange-aspectMask-requiredbitmask");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateImageView", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateImageView", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateImageView", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateImageView", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateImageView", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateImageView", "pView", pView, "VUID-vkCreateImageView-pView-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateImageView(device, pCreateInfo, pAllocator, pView);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyImageView(
    VkDevice                                    device,
    VkImageView                                 imageView,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyImageView", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyImageView", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyImageView", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyImageView", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyImageView", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateShaderModule(
    VkDevice                                    device,
    const VkShaderModuleCreateInfo*             pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkShaderModule*                             pShaderModule) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateShaderModule", "pCreateInfo", "VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO, true, "VUID-vkCreateShaderModule-pCreateInfo-parameter", "VUID-VkShaderModuleCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        skip |= ValidateReservedFlags("vkCreateShaderModule", "pCreateInfo->flags", pCreateInfo->flags, "VUID-VkShaderModuleCreateInfo-flags-zerobitmask");

        skip |= ValidateArray("vkCreateShaderModule", "pCreateInfo->codeSize / 4", "pCreateInfo->pCode", pCreateInfo->codeSize / 4, &pCreateInfo->pCode, true, true, kVUIDUndefined, "VUID-VkShaderModuleCreateInfo-pCode-parameter");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateShaderModule", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateShaderModule", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateShaderModule", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateShaderModule", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateShaderModule", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateShaderModule", "pShaderModule", pShaderModule, "VUID-vkCreateShaderModule-pShaderModule-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyShaderModule(
    VkDevice                                    device,
    VkShaderModule                              shaderModule,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyShaderModule", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyShaderModule", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyShaderModule", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyShaderModule", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyShaderModule", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreatePipelineCache(
    VkDevice                                    device,
    const VkPipelineCacheCreateInfo*            pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkPipelineCache*                            pPipelineCache) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreatePipelineCache", "pCreateInfo", "VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO, true, "VUID-vkCreatePipelineCache-pCreateInfo-parameter", "VUID-VkPipelineCacheCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCreatePipelineCache", "pCreateInfo->pNext", nullptr, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkPipelineCacheCreateInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateFlags("vkCreatePipelineCache", "pCreateInfo->flags", "VkPipelineCacheCreateFlagBits", AllVkPipelineCacheCreateFlagBits, pCreateInfo->flags, kOptionalFlags, "VUID-VkPipelineCacheCreateInfo-flags-parameter");

        skip |= ValidateArray("vkCreatePipelineCache", "pCreateInfo->initialDataSize", "pCreateInfo->pInitialData", pCreateInfo->initialDataSize, &pCreateInfo->pInitialData, false, true, kVUIDUndefined, "VUID-VkPipelineCacheCreateInfo-pInitialData-parameter");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreatePipelineCache", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreatePipelineCache", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreatePipelineCache", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreatePipelineCache", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreatePipelineCache", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreatePipelineCache", "pPipelineCache", pPipelineCache, "VUID-vkCreatePipelineCache-pPipelineCache-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyPipelineCache(
    VkDevice                                    device,
    VkPipelineCache                             pipelineCache,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyPipelineCache", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyPipelineCache", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyPipelineCache", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyPipelineCache", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyPipelineCache", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPipelineCacheData(
    VkDevice                                    device,
    VkPipelineCache                             pipelineCache,
    size_t*                                     pDataSize,
    void*                                       pData) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkGetPipelineCacheData", "pipelineCache", pipelineCache);
    skip |= ValidateArray("vkGetPipelineCacheData", "pDataSize", "pData", pDataSize, &pData, true, false, false, kVUIDUndefined, "VUID-vkGetPipelineCacheData-pData-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateMergePipelineCaches(
    VkDevice                                    device,
    VkPipelineCache                             dstCache,
    uint32_t                                    srcCacheCount,
    const VkPipelineCache*                      pSrcCaches) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkMergePipelineCaches", "dstCache", dstCache);
    skip |= ValidateHandleArray("vkMergePipelineCaches", "srcCacheCount", "pSrcCaches", srcCacheCount, pSrcCaches, true, true, "VUID-vkMergePipelineCaches-srcCacheCount-arraylength");
    if (!skip) skip |= manual_PreCallValidateMergePipelineCaches(device, dstCache, srcCacheCount, pSrcCaches);
    return skip;
}

bool StatelessValidation::PreCallValidateCreateGraphicsPipelines(
    VkDevice                                    device,
    VkPipelineCache                             pipelineCache,
    uint32_t                                    createInfoCount,
    const VkGraphicsPipelineCreateInfo*         pCreateInfos,
    const VkAllocationCallbacks*                pAllocator,
    VkPipeline*                                 pPipelines) const {
    bool skip = false;
    skip |= ValidateStructTypeArray("vkCreateGraphicsPipelines", "createInfoCount", "pCreateInfos", "VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO", createInfoCount, pCreateInfos, VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO, true, true, "VUID-VkGraphicsPipelineCreateInfo-sType-sType", "VUID-vkCreateGraphicsPipelines-pCreateInfos-parameter", "VUID-vkCreateGraphicsPipelines-createInfoCount-arraylength");
    if (pCreateInfos != nullptr)
    {
        for (uint32_t createInfoIndex = 0; createInfoIndex < createInfoCount; ++createInfoIndex)
        {
            constexpr std::array allowed_structs_VkGraphicsPipelineCreateInfo = { VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD, VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV, VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX, VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD, VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO, VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV, VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR, VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR, VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO, VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV, VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO_EXT };

            skip |= ValidateStructPnext("vkCreateGraphicsPipelines", ParameterName("pCreateInfos[%i].pNext", ParameterName::IndexVector{ createInfoIndex }), "VkAttachmentSampleCountInfoAMD, VkGraphicsPipelineLibraryCreateInfoEXT, VkGraphicsPipelineShaderGroupsCreateInfoNV, VkMultiviewPerViewAttributesInfoNVX, VkPipelineCompilerControlCreateInfoAMD, VkPipelineCreationFeedbackCreateInfo, VkPipelineDiscardRectangleStateCreateInfoEXT, VkPipelineFragmentShadingRateEnumStateCreateInfoNV, VkPipelineFragmentShadingRateStateCreateInfoKHR, VkPipelineLibraryCreateInfoKHR, VkPipelineRenderingCreateInfo, VkPipelineRepresentativeFragmentTestStateCreateInfoNV, VkPipelineRobustnessCreateInfoEXT", pCreateInfos[createInfoIndex].pNext, allowed_structs_VkGraphicsPipelineCreateInfo.size(), allowed_structs_VkGraphicsPipelineCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkGraphicsPipelineCreateInfo-pNext-pNext", "VUID-VkGraphicsPipelineCreateInfo-sType-unique", false, true);

            skip |= ValidateFlags("vkCreateGraphicsPipelines", ParameterName("pCreateInfos[%i].flags", ParameterName::IndexVector{ createInfoIndex }), "VkPipelineCreateFlagBits", AllVkPipelineCreateFlagBits, pCreateInfos[createInfoIndex].flags, kOptionalFlags, "VUID-VkGraphicsPipelineCreateInfo-flags-parameter");

            skip |= ValidateStructType("vkCreateGraphicsPipelines", ParameterName("pCreateInfos[%i].pDynamicState", ParameterName::IndexVector{ createInfoIndex }), "VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO", pCreateInfos[createInfoIndex].pDynamicState, VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO, false, "VUID-VkGraphicsPipelineCreateInfo-pDynamicState-parameter", "VUID-VkPipelineDynamicStateCreateInfo-sType-sType");

            if (pCreateInfos[createInfoIndex].pDynamicState != nullptr)
            {
                skip |= ValidateStructPnext("vkCreateGraphicsPipelines", ParameterName("pCreateInfos[%i].pDynamicState->pNext", ParameterName::IndexVector{ createInfoIndex }), nullptr, pCreateInfos[createInfoIndex].pDynamicState->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkPipelineDynamicStateCreateInfo-pNext-pNext", kVUIDUndefined, false, true);

                skip |= ValidateReservedFlags("vkCreateGraphicsPipelines", ParameterName("pCreateInfos[%i].pDynamicState->flags", ParameterName::IndexVector{ createInfoIndex }), pCreateInfos[createInfoIndex].pDynamicState->flags, "VUID-VkPipelineDynamicStateCreateInfo-flags-zerobitmask");

                skip |= ValidateRangedEnumArray("vkCreateGraphicsPipelines", ParameterName("pCreateInfos[%i].pDynamicState->dynamicStateCount", ParameterName::IndexVector{ createInfoIndex }), ParameterName("pCreateInfos[%i].pDynamicState->pDynamicStates", ParameterName::IndexVector{ createInfoIndex }), "VkDynamicState", AllVkDynamicStateEnums, pCreateInfos[createInfoIndex].pDynamicState->dynamicStateCount, pCreateInfos[createInfoIndex].pDynamicState->pDynamicStates, false, true);
            }
        }
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateGraphicsPipelines", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateGraphicsPipelines", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateGraphicsPipelines", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateGraphicsPipelines", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateGraphicsPipelines", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateArray("vkCreateGraphicsPipelines", "createInfoCount", "pPipelines", createInfoCount, &pPipelines, true, true, "VUID-vkCreateGraphicsPipelines-createInfoCount-arraylength", "VUID-vkCreateGraphicsPipelines-pPipelines-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateGraphicsPipelines(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
    return skip;
}

bool StatelessValidation::PreCallValidateCreateComputePipelines(
    VkDevice                                    device,
    VkPipelineCache                             pipelineCache,
    uint32_t                                    createInfoCount,
    const VkComputePipelineCreateInfo*          pCreateInfos,
    const VkAllocationCallbacks*                pAllocator,
    VkPipeline*                                 pPipelines) const {
    bool skip = false;
    skip |= ValidateStructTypeArray("vkCreateComputePipelines", "createInfoCount", "pCreateInfos", "VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO", createInfoCount, pCreateInfos, VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO, true, true, "VUID-VkComputePipelineCreateInfo-sType-sType", "VUID-vkCreateComputePipelines-pCreateInfos-parameter", "VUID-vkCreateComputePipelines-createInfoCount-arraylength");
    if (pCreateInfos != nullptr)
    {
        for (uint32_t createInfoIndex = 0; createInfoIndex < createInfoCount; ++createInfoIndex)
        {
            constexpr std::array allowed_structs_VkComputePipelineCreateInfo = { VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD, VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO, VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_SUBPASS_SHADING_PIPELINE_CREATE_INFO_HUAWEI };

            skip |= ValidateStructPnext("vkCreateComputePipelines", ParameterName("pCreateInfos[%i].pNext", ParameterName::IndexVector{ createInfoIndex }), "VkPipelineCompilerControlCreateInfoAMD, VkPipelineCreationFeedbackCreateInfo, VkPipelineRobustnessCreateInfoEXT, VkSubpassShadingPipelineCreateInfoHUAWEI", pCreateInfos[createInfoIndex].pNext, allowed_structs_VkComputePipelineCreateInfo.size(), allowed_structs_VkComputePipelineCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkComputePipelineCreateInfo-pNext-pNext", "VUID-VkComputePipelineCreateInfo-sType-unique", false, true);

            skip |= ValidateFlags("vkCreateComputePipelines", ParameterName("pCreateInfos[%i].flags", ParameterName::IndexVector{ createInfoIndex }), "VkPipelineCreateFlagBits", AllVkPipelineCreateFlagBits, pCreateInfos[createInfoIndex].flags, kOptionalFlags, "VUID-VkComputePipelineCreateInfo-flags-parameter");

            skip |= ValidateStructType("vkCreateComputePipelines", ParameterName("pCreateInfos[%i].stage", ParameterName::IndexVector{ createInfoIndex }), "VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO", &(pCreateInfos[createInfoIndex].stage), VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO, false, kVUIDUndefined, "VUID-VkPipelineShaderStageCreateInfo-sType-sType");

            constexpr std::array allowed_structs_VkPipelineShaderStageCreateInfo = { VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT, VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_MODULE_IDENTIFIER_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO, VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO, VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT };

            skip |= ValidateStructPnext("vkCreateComputePipelines", ParameterName("pCreateInfos[%i].stage.pNext", ParameterName::IndexVector{ createInfoIndex }), "VkDebugUtilsObjectNameInfoEXT, VkPipelineRobustnessCreateInfoEXT, VkPipelineShaderStageModuleIdentifierCreateInfoEXT, VkPipelineShaderStageRequiredSubgroupSizeCreateInfo, VkShaderModuleCreateInfo, VkShaderModuleValidationCacheCreateInfoEXT", pCreateInfos[createInfoIndex].stage.pNext, allowed_structs_VkPipelineShaderStageCreateInfo.size(), allowed_structs_VkPipelineShaderStageCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkPipelineShaderStageCreateInfo-pNext-pNext", "VUID-VkPipelineShaderStageCreateInfo-sType-unique", false, true);

            skip |= ValidateFlags("vkCreateComputePipelines", ParameterName("pCreateInfos[%i].stage.flags", ParameterName::IndexVector{ createInfoIndex }), "VkPipelineShaderStageCreateFlagBits", AllVkPipelineShaderStageCreateFlagBits, pCreateInfos[createInfoIndex].stage.flags, kOptionalFlags, "VUID-VkPipelineShaderStageCreateInfo-flags-parameter");

            skip |= ValidateFlags("vkCreateComputePipelines", ParameterName("pCreateInfos[%i].stage.stage", ParameterName::IndexVector{ createInfoIndex }), "VkShaderStageFlagBits", AllVkShaderStageFlagBits, pCreateInfos[createInfoIndex].stage.stage, kRequiredSingleBit, "VUID-VkPipelineShaderStageCreateInfo-stage-parameter", "VUID-VkPipelineShaderStageCreateInfo-stage-parameter");

            skip |= ValidateRequiredPointer("vkCreateComputePipelines", ParameterName("pCreateInfos[%i].stage.pName", ParameterName::IndexVector{ createInfoIndex }), pCreateInfos[createInfoIndex].stage.pName, "VUID-VkPipelineShaderStageCreateInfo-pName-parameter");

            if (pCreateInfos[createInfoIndex].stage.pSpecializationInfo != nullptr)
            {
                skip |= ValidateArray("vkCreateComputePipelines", ParameterName("pCreateInfos[%i].stage.pSpecializationInfo->mapEntryCount", ParameterName::IndexVector{ createInfoIndex }), ParameterName("pCreateInfos[%i].stage.pSpecializationInfo->pMapEntries", ParameterName::IndexVector{ createInfoIndex }), pCreateInfos[createInfoIndex].stage.pSpecializationInfo->mapEntryCount, &pCreateInfos[createInfoIndex].stage.pSpecializationInfo->pMapEntries, false, true, kVUIDUndefined, "VUID-VkSpecializationInfo-pMapEntries-parameter");

                if (pCreateInfos[createInfoIndex].stage.pSpecializationInfo->pMapEntries != nullptr)
                {
                    for (uint32_t mapEntryIndex = 0; mapEntryIndex < pCreateInfos[createInfoIndex].stage.pSpecializationInfo->mapEntryCount; ++mapEntryIndex)
                    {
                        // No xml-driven validation
                    }
                }

                skip |= ValidateArray("vkCreateComputePipelines", ParameterName("pCreateInfos[%i].stage.pSpecializationInfo->dataSize", ParameterName::IndexVector{ createInfoIndex }), ParameterName("pCreateInfos[%i].stage.pSpecializationInfo->pData", ParameterName::IndexVector{ createInfoIndex }), pCreateInfos[createInfoIndex].stage.pSpecializationInfo->dataSize, &pCreateInfos[createInfoIndex].stage.pSpecializationInfo->pData, false, true, kVUIDUndefined, "VUID-VkSpecializationInfo-pData-parameter");
            }

            skip |= ValidateRequiredHandle("vkCreateComputePipelines", ParameterName("pCreateInfos[%i].layout", ParameterName::IndexVector{ createInfoIndex }), pCreateInfos[createInfoIndex].layout);
        }
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateComputePipelines", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateComputePipelines", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateComputePipelines", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateComputePipelines", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateComputePipelines", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateArray("vkCreateComputePipelines", "createInfoCount", "pPipelines", createInfoCount, &pPipelines, true, true, "VUID-vkCreateComputePipelines-createInfoCount-arraylength", "VUID-vkCreateComputePipelines-pPipelines-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateComputePipelines(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyPipeline(
    VkDevice                                    device,
    VkPipeline                                  pipeline,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyPipeline", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyPipeline", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyPipeline", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyPipeline", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyPipeline", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreatePipelineLayout(
    VkDevice                                    device,
    const VkPipelineLayoutCreateInfo*           pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkPipelineLayout*                           pPipelineLayout) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreatePipelineLayout", "pCreateInfo", "VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO, true, "VUID-vkCreatePipelineLayout-pCreateInfo-parameter", "VUID-VkPipelineLayoutCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCreatePipelineLayout", "pCreateInfo->pNext", nullptr, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkPipelineLayoutCreateInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateFlags("vkCreatePipelineLayout", "pCreateInfo->flags", "VkPipelineLayoutCreateFlagBits", AllVkPipelineLayoutCreateFlagBits, pCreateInfo->flags, kOptionalFlags, "VUID-VkPipelineLayoutCreateInfo-flags-parameter");

        skip |= ValidateArray("vkCreatePipelineLayout", "pCreateInfo->pushConstantRangeCount", "pCreateInfo->pPushConstantRanges", pCreateInfo->pushConstantRangeCount, &pCreateInfo->pPushConstantRanges, false, true, kVUIDUndefined, "VUID-VkPipelineLayoutCreateInfo-pPushConstantRanges-parameter");

        if (pCreateInfo->pPushConstantRanges != nullptr)
        {
            for (uint32_t pushConstantRangeIndex = 0; pushConstantRangeIndex < pCreateInfo->pushConstantRangeCount; ++pushConstantRangeIndex)
            {
                skip |= ValidateFlags("vkCreatePipelineLayout", ParameterName("pCreateInfo->pPushConstantRanges[%i].stageFlags", ParameterName::IndexVector{ pushConstantRangeIndex }), "VkShaderStageFlagBits", AllVkShaderStageFlagBits, pCreateInfo->pPushConstantRanges[pushConstantRangeIndex].stageFlags, kRequiredFlags, "VUID-VkPushConstantRange-stageFlags-parameter", "VUID-VkPushConstantRange-stageFlags-requiredbitmask");
            }
        }
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreatePipelineLayout", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreatePipelineLayout", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreatePipelineLayout", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreatePipelineLayout", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreatePipelineLayout", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreatePipelineLayout", "pPipelineLayout", pPipelineLayout, "VUID-vkCreatePipelineLayout-pPipelineLayout-parameter");
    if (!skip) skip |= manual_PreCallValidateCreatePipelineLayout(device, pCreateInfo, pAllocator, pPipelineLayout);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyPipelineLayout(
    VkDevice                                    device,
    VkPipelineLayout                            pipelineLayout,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyPipelineLayout", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyPipelineLayout", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyPipelineLayout", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyPipelineLayout", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyPipelineLayout", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateSampler(
    VkDevice                                    device,
    const VkSamplerCreateInfo*                  pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkSampler*                                  pSampler) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateSampler", "pCreateInfo", "VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO, true, "VUID-vkCreateSampler-pCreateInfo-parameter", "VUID-VkSamplerCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkSamplerCreateInfo = { VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO, VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO };

        skip |= ValidateStructPnext("vkCreateSampler", "pCreateInfo->pNext", "VkOpaqueCaptureDescriptorDataCreateInfoEXT, VkSamplerBorderColorComponentMappingCreateInfoEXT, VkSamplerCustomBorderColorCreateInfoEXT, VkSamplerReductionModeCreateInfo, VkSamplerYcbcrConversionInfo", pCreateInfo->pNext, allowed_structs_VkSamplerCreateInfo.size(), allowed_structs_VkSamplerCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkSamplerCreateInfo-pNext-pNext", "VUID-VkSamplerCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags("vkCreateSampler", "pCreateInfo->flags", "VkSamplerCreateFlagBits", AllVkSamplerCreateFlagBits, pCreateInfo->flags, kOptionalFlags, "VUID-VkSamplerCreateInfo-flags-parameter");

        skip |= ValidateRangedEnum("vkCreateSampler", "pCreateInfo->magFilter", "VkFilter", AllVkFilterEnums, pCreateInfo->magFilter, "VUID-VkSamplerCreateInfo-magFilter-parameter");

        skip |= ValidateRangedEnum("vkCreateSampler", "pCreateInfo->minFilter", "VkFilter", AllVkFilterEnums, pCreateInfo->minFilter, "VUID-VkSamplerCreateInfo-minFilter-parameter");

        skip |= ValidateRangedEnum("vkCreateSampler", "pCreateInfo->mipmapMode", "VkSamplerMipmapMode", AllVkSamplerMipmapModeEnums, pCreateInfo->mipmapMode, "VUID-VkSamplerCreateInfo-mipmapMode-parameter");

        skip |= ValidateRangedEnum("vkCreateSampler", "pCreateInfo->addressModeU", "VkSamplerAddressMode", AllVkSamplerAddressModeEnums, pCreateInfo->addressModeU, "VUID-VkSamplerCreateInfo-addressModeU-parameter");

        skip |= ValidateRangedEnum("vkCreateSampler", "pCreateInfo->addressModeV", "VkSamplerAddressMode", AllVkSamplerAddressModeEnums, pCreateInfo->addressModeV, "VUID-VkSamplerCreateInfo-addressModeV-parameter");

        skip |= ValidateRangedEnum("vkCreateSampler", "pCreateInfo->addressModeW", "VkSamplerAddressMode", AllVkSamplerAddressModeEnums, pCreateInfo->addressModeW, "VUID-VkSamplerCreateInfo-addressModeW-parameter");

        skip |= ValidateBool32("vkCreateSampler", "pCreateInfo->anisotropyEnable", pCreateInfo->anisotropyEnable);

        skip |= ValidateBool32("vkCreateSampler", "pCreateInfo->compareEnable", pCreateInfo->compareEnable);

        skip |= ValidateBool32("vkCreateSampler", "pCreateInfo->unnormalizedCoordinates", pCreateInfo->unnormalizedCoordinates);
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateSampler", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateSampler", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateSampler", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateSampler", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateSampler", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateSampler", "pSampler", pSampler, "VUID-vkCreateSampler-pSampler-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateSampler(device, pCreateInfo, pAllocator, pSampler);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroySampler(
    VkDevice                                    device,
    VkSampler                                   sampler,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroySampler", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroySampler", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroySampler", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroySampler", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroySampler", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateDescriptorSetLayout(
    VkDevice                                    device,
    const VkDescriptorSetLayoutCreateInfo*      pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkDescriptorSetLayout*                      pSetLayout) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateDescriptorSetLayout", "pCreateInfo", "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO, true, "VUID-vkCreateDescriptorSetLayout-pCreateInfo-parameter", "VUID-VkDescriptorSetLayoutCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkDescriptorSetLayoutCreateInfo = { VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO, VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT };

        skip |= ValidateStructPnext("vkCreateDescriptorSetLayout", "pCreateInfo->pNext", "VkDescriptorSetLayoutBindingFlagsCreateInfo, VkMutableDescriptorTypeCreateInfoEXT", pCreateInfo->pNext, allowed_structs_VkDescriptorSetLayoutCreateInfo.size(), allowed_structs_VkDescriptorSetLayoutCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkDescriptorSetLayoutCreateInfo-pNext-pNext", "VUID-VkDescriptorSetLayoutCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags("vkCreateDescriptorSetLayout", "pCreateInfo->flags", "VkDescriptorSetLayoutCreateFlagBits", AllVkDescriptorSetLayoutCreateFlagBits, pCreateInfo->flags, kOptionalFlags, "VUID-VkDescriptorSetLayoutCreateInfo-flags-parameter");

        skip |= ValidateArray("vkCreateDescriptorSetLayout", "pCreateInfo->bindingCount", "pCreateInfo->pBindings", pCreateInfo->bindingCount, &pCreateInfo->pBindings, false, true, kVUIDUndefined, "VUID-VkDescriptorSetLayoutCreateInfo-pBindings-parameter");

        if (pCreateInfo->pBindings != nullptr)
        {
            for (uint32_t bindingIndex = 0; bindingIndex < pCreateInfo->bindingCount; ++bindingIndex)
            {
                skip |= ValidateRangedEnum("vkCreateDescriptorSetLayout", ParameterName("pCreateInfo->pBindings[%i].descriptorType", ParameterName::IndexVector{ bindingIndex }), "VkDescriptorType", AllVkDescriptorTypeEnums, pCreateInfo->pBindings[bindingIndex].descriptorType, "VUID-VkDescriptorSetLayoutBinding-descriptorType-parameter");
            }
        }
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateDescriptorSetLayout", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateDescriptorSetLayout", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateDescriptorSetLayout", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateDescriptorSetLayout", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateDescriptorSetLayout", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateDescriptorSetLayout", "pSetLayout", pSetLayout, "VUID-vkCreateDescriptorSetLayout-pSetLayout-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateDescriptorSetLayout(device, pCreateInfo, pAllocator, pSetLayout);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyDescriptorSetLayout(
    VkDevice                                    device,
    VkDescriptorSetLayout                       descriptorSetLayout,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyDescriptorSetLayout", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyDescriptorSetLayout", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyDescriptorSetLayout", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyDescriptorSetLayout", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyDescriptorSetLayout", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateDescriptorPool(
    VkDevice                                    device,
    const VkDescriptorPoolCreateInfo*           pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkDescriptorPool*                           pDescriptorPool) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateDescriptorPool", "pCreateInfo", "VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO, true, "VUID-vkCreateDescriptorPool-pCreateInfo-parameter", "VUID-VkDescriptorPoolCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkDescriptorPoolCreateInfo = { VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO, VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT };

        skip |= ValidateStructPnext("vkCreateDescriptorPool", "pCreateInfo->pNext", "VkDescriptorPoolInlineUniformBlockCreateInfo, VkMutableDescriptorTypeCreateInfoEXT", pCreateInfo->pNext, allowed_structs_VkDescriptorPoolCreateInfo.size(), allowed_structs_VkDescriptorPoolCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkDescriptorPoolCreateInfo-pNext-pNext", "VUID-VkDescriptorPoolCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags("vkCreateDescriptorPool", "pCreateInfo->flags", "VkDescriptorPoolCreateFlagBits", AllVkDescriptorPoolCreateFlagBits, pCreateInfo->flags, kOptionalFlags, "VUID-VkDescriptorPoolCreateInfo-flags-parameter");

        skip |= ValidateArray("vkCreateDescriptorPool", "pCreateInfo->poolSizeCount", "pCreateInfo->pPoolSizes", pCreateInfo->poolSizeCount, &pCreateInfo->pPoolSizes, false, true, kVUIDUndefined, "VUID-VkDescriptorPoolCreateInfo-pPoolSizes-parameter");

        if (pCreateInfo->pPoolSizes != nullptr)
        {
            for (uint32_t poolSizeIndex = 0; poolSizeIndex < pCreateInfo->poolSizeCount; ++poolSizeIndex)
            {
                skip |= ValidateRangedEnum("vkCreateDescriptorPool", ParameterName("pCreateInfo->pPoolSizes[%i].type", ParameterName::IndexVector{ poolSizeIndex }), "VkDescriptorType", AllVkDescriptorTypeEnums, pCreateInfo->pPoolSizes[poolSizeIndex].type, "VUID-VkDescriptorPoolSize-type-parameter");
            }
        }
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateDescriptorPool", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateDescriptorPool", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateDescriptorPool", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateDescriptorPool", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateDescriptorPool", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateDescriptorPool", "pDescriptorPool", pDescriptorPool, "VUID-vkCreateDescriptorPool-pDescriptorPool-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateDescriptorPool(device, pCreateInfo, pAllocator, pDescriptorPool);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyDescriptorPool(
    VkDevice                                    device,
    VkDescriptorPool                            descriptorPool,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyDescriptorPool", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyDescriptorPool", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyDescriptorPool", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyDescriptorPool", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyDescriptorPool", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateResetDescriptorPool(
    VkDevice                                    device,
    VkDescriptorPool                            descriptorPool,
    VkDescriptorPoolResetFlags                  flags) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkResetDescriptorPool", "descriptorPool", descriptorPool);
    skip |= ValidateReservedFlags("vkResetDescriptorPool", "flags", flags, "VUID-vkResetDescriptorPool-flags-zerobitmask");
    return skip;
}

bool StatelessValidation::PreCallValidateAllocateDescriptorSets(
    VkDevice                                    device,
    const VkDescriptorSetAllocateInfo*          pAllocateInfo,
    VkDescriptorSet*                            pDescriptorSets) const {
    bool skip = false;
    skip |= ValidateStructType("vkAllocateDescriptorSets", "pAllocateInfo", "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO", pAllocateInfo, VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO, true, "VUID-vkAllocateDescriptorSets-pAllocateInfo-parameter", "VUID-VkDescriptorSetAllocateInfo-sType-sType");
    if (pAllocateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkDescriptorSetAllocateInfo = { VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO };

        skip |= ValidateStructPnext("vkAllocateDescriptorSets", "pAllocateInfo->pNext", "VkDescriptorSetVariableDescriptorCountAllocateInfo", pAllocateInfo->pNext, allowed_structs_VkDescriptorSetAllocateInfo.size(), allowed_structs_VkDescriptorSetAllocateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkDescriptorSetAllocateInfo-pNext-pNext", "VUID-VkDescriptorSetAllocateInfo-sType-unique", false, true);

        skip |= ValidateRequiredHandle("vkAllocateDescriptorSets", "pAllocateInfo->descriptorPool", pAllocateInfo->descriptorPool);

        skip |= ValidateHandleArray("vkAllocateDescriptorSets", "pAllocateInfo->descriptorSetCount", "pAllocateInfo->pSetLayouts", pAllocateInfo->descriptorSetCount, pAllocateInfo->pSetLayouts, true, true, kVUIDUndefined);
    }
    if (pAllocateInfo != nullptr) {
        skip |= ValidateArray("vkAllocateDescriptorSets", "pAllocateInfo->descriptorSetCount", "pDescriptorSets", pAllocateInfo->descriptorSetCount, &pDescriptorSets, true, true, "VUID-vkAllocateDescriptorSets-pAllocateInfo::descriptorSetCount-arraylength", "VUID-vkAllocateDescriptorSets-pDescriptorSets-parameter");
    }
    return skip;
}

bool StatelessValidation::PreCallValidateFreeDescriptorSets(
    VkDevice                                    device,
    VkDescriptorPool                            descriptorPool,
    uint32_t                                    descriptorSetCount,
    const VkDescriptorSet*                      pDescriptorSets) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkFreeDescriptorSets", "descriptorPool", descriptorPool);
    skip |= ValidateArray("vkFreeDescriptorSets", "descriptorSetCount", "", descriptorSetCount, &pDescriptorSets, true, false, "VUID-vkFreeDescriptorSets-descriptorSetCount-arraylength", kVUIDUndefined);
    if (!skip) skip |= manual_PreCallValidateFreeDescriptorSets(device, descriptorPool, descriptorSetCount, pDescriptorSets);
    return skip;
}

bool StatelessValidation::PreCallValidateUpdateDescriptorSets(
    VkDevice                                    device,
    uint32_t                                    descriptorWriteCount,
    const VkWriteDescriptorSet*                 pDescriptorWrites,
    uint32_t                                    descriptorCopyCount,
    const VkCopyDescriptorSet*                  pDescriptorCopies) const {
    bool skip = false;
    skip |= ValidateStructTypeArray("vkUpdateDescriptorSets", "descriptorWriteCount", "pDescriptorWrites", "VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET", descriptorWriteCount, pDescriptorWrites, VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET, false, true, "VUID-VkWriteDescriptorSet-sType-sType", "VUID-vkUpdateDescriptorSets-pDescriptorWrites-parameter", kVUIDUndefined);
    if (pDescriptorWrites != nullptr)
    {
        for (uint32_t descriptorWriteIndex = 0; descriptorWriteIndex < descriptorWriteCount; ++descriptorWriteIndex)
        {
            constexpr std::array allowed_structs_VkWriteDescriptorSet = { VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR, VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV, VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK };

            skip |= ValidateStructPnext("vkUpdateDescriptorSets", ParameterName("pDescriptorWrites[%i].pNext", ParameterName::IndexVector{ descriptorWriteIndex }), "VkWriteDescriptorSetAccelerationStructureKHR, VkWriteDescriptorSetAccelerationStructureNV, VkWriteDescriptorSetInlineUniformBlock", pDescriptorWrites[descriptorWriteIndex].pNext, allowed_structs_VkWriteDescriptorSet.size(), allowed_structs_VkWriteDescriptorSet.data(), GeneratedVulkanHeaderVersion, "VUID-VkWriteDescriptorSet-pNext-pNext", "VUID-VkWriteDescriptorSet-sType-unique", false, true);

            skip |= ValidateRangedEnum("vkUpdateDescriptorSets", ParameterName("pDescriptorWrites[%i].descriptorType", ParameterName::IndexVector{ descriptorWriteIndex }), "VkDescriptorType", AllVkDescriptorTypeEnums, pDescriptorWrites[descriptorWriteIndex].descriptorType, "VUID-VkWriteDescriptorSet-descriptorType-parameter");

            skip |= ValidateArray("vkUpdateDescriptorSets", ParameterName("pDescriptorWrites[%i].descriptorCount", ParameterName::IndexVector{ descriptorWriteIndex }), "", pDescriptorWrites[descriptorWriteIndex].descriptorCount, &pDescriptorWrites[descriptorWriteIndex].pImageInfo, true, false, "VUID-VkWriteDescriptorSet-descriptorCount-arraylength", kVUIDUndefined);
        }
    }
    skip |= ValidateStructTypeArray("vkUpdateDescriptorSets", "descriptorCopyCount", "pDescriptorCopies", "VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET", descriptorCopyCount, pDescriptorCopies, VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET, false, true, "VUID-VkCopyDescriptorSet-sType-sType", "VUID-vkUpdateDescriptorSets-pDescriptorCopies-parameter", kVUIDUndefined);
    if (pDescriptorCopies != nullptr)
    {
        for (uint32_t descriptorCopyIndex = 0; descriptorCopyIndex < descriptorCopyCount; ++descriptorCopyIndex)
        {
            skip |= ValidateStructPnext("vkUpdateDescriptorSets", ParameterName("pDescriptorCopies[%i].pNext", ParameterName::IndexVector{ descriptorCopyIndex }), nullptr, pDescriptorCopies[descriptorCopyIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkCopyDescriptorSet-pNext-pNext", kVUIDUndefined, false, true);

            skip |= ValidateRequiredHandle("vkUpdateDescriptorSets", ParameterName("pDescriptorCopies[%i].srcSet", ParameterName::IndexVector{ descriptorCopyIndex }), pDescriptorCopies[descriptorCopyIndex].srcSet);

            skip |= ValidateRequiredHandle("vkUpdateDescriptorSets", ParameterName("pDescriptorCopies[%i].dstSet", ParameterName::IndexVector{ descriptorCopyIndex }), pDescriptorCopies[descriptorCopyIndex].dstSet);
        }
    }
    if (!skip) skip |= manual_PreCallValidateUpdateDescriptorSets(device, descriptorWriteCount, pDescriptorWrites, descriptorCopyCount, pDescriptorCopies);
    return skip;
}

bool StatelessValidation::PreCallValidateCreateFramebuffer(
    VkDevice                                    device,
    const VkFramebufferCreateInfo*              pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkFramebuffer*                              pFramebuffer) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateFramebuffer", "pCreateInfo", "VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO, true, "VUID-vkCreateFramebuffer-pCreateInfo-parameter", "VUID-VkFramebufferCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkFramebufferCreateInfo = { VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO };

        skip |= ValidateStructPnext("vkCreateFramebuffer", "pCreateInfo->pNext", "VkFramebufferAttachmentsCreateInfo", pCreateInfo->pNext, allowed_structs_VkFramebufferCreateInfo.size(), allowed_structs_VkFramebufferCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkFramebufferCreateInfo-pNext-pNext", "VUID-VkFramebufferCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags("vkCreateFramebuffer", "pCreateInfo->flags", "VkFramebufferCreateFlagBits", AllVkFramebufferCreateFlagBits, pCreateInfo->flags, kOptionalFlags, "VUID-VkFramebufferCreateInfo-flags-parameter");

        skip |= ValidateRequiredHandle("vkCreateFramebuffer", "pCreateInfo->renderPass", pCreateInfo->renderPass);
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateFramebuffer", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateFramebuffer", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateFramebuffer", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateFramebuffer", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateFramebuffer", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateFramebuffer", "pFramebuffer", pFramebuffer, "VUID-vkCreateFramebuffer-pFramebuffer-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateFramebuffer(device, pCreateInfo, pAllocator, pFramebuffer);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyFramebuffer(
    VkDevice                                    device,
    VkFramebuffer                               framebuffer,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyFramebuffer", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyFramebuffer", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyFramebuffer", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyFramebuffer", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyFramebuffer", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateRenderPass(
    VkDevice                                    device,
    const VkRenderPassCreateInfo*               pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkRenderPass*                               pRenderPass) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateRenderPass", "pCreateInfo", "VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO, true, "VUID-vkCreateRenderPass-pCreateInfo-parameter", "VUID-VkRenderPassCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkRenderPassCreateInfo = { VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO, VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO };

        skip |= ValidateStructPnext("vkCreateRenderPass", "pCreateInfo->pNext", "VkRenderPassFragmentDensityMapCreateInfoEXT, VkRenderPassInputAttachmentAspectCreateInfo, VkRenderPassMultiviewCreateInfo", pCreateInfo->pNext, allowed_structs_VkRenderPassCreateInfo.size(), allowed_structs_VkRenderPassCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkRenderPassCreateInfo-pNext-pNext", "VUID-VkRenderPassCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags("vkCreateRenderPass", "pCreateInfo->flags", "VkRenderPassCreateFlagBits", AllVkRenderPassCreateFlagBits, pCreateInfo->flags, kOptionalFlags, "VUID-VkRenderPassCreateInfo-flags-parameter");

        skip |= ValidateArray("vkCreateRenderPass", "pCreateInfo->attachmentCount", "pCreateInfo->pAttachments", pCreateInfo->attachmentCount, &pCreateInfo->pAttachments, false, true, kVUIDUndefined, "VUID-VkRenderPassCreateInfo-pAttachments-parameter");

        if (pCreateInfo->pAttachments != nullptr)
        {
            for (uint32_t attachmentIndex = 0; attachmentIndex < pCreateInfo->attachmentCount; ++attachmentIndex)
            {
                skip |= ValidateFlags("vkCreateRenderPass", ParameterName("pCreateInfo->pAttachments[%i].flags", ParameterName::IndexVector{ attachmentIndex }), "VkAttachmentDescriptionFlagBits", AllVkAttachmentDescriptionFlagBits, pCreateInfo->pAttachments[attachmentIndex].flags, kOptionalFlags, "VUID-VkAttachmentDescription-flags-parameter");

                skip |= ValidateRangedEnum("vkCreateRenderPass", ParameterName("pCreateInfo->pAttachments[%i].format", ParameterName::IndexVector{ attachmentIndex }), "VkFormat", AllVkFormatEnums, pCreateInfo->pAttachments[attachmentIndex].format, "VUID-VkAttachmentDescription-format-parameter");

                skip |= ValidateFlags("vkCreateRenderPass", ParameterName("pCreateInfo->pAttachments[%i].samples", ParameterName::IndexVector{ attachmentIndex }), "VkSampleCountFlagBits", AllVkSampleCountFlagBits, pCreateInfo->pAttachments[attachmentIndex].samples, kRequiredSingleBit, "VUID-VkAttachmentDescription-samples-parameter", "VUID-VkAttachmentDescription-samples-parameter");

                skip |= ValidateRangedEnum("vkCreateRenderPass", ParameterName("pCreateInfo->pAttachments[%i].loadOp", ParameterName::IndexVector{ attachmentIndex }), "VkAttachmentLoadOp", AllVkAttachmentLoadOpEnums, pCreateInfo->pAttachments[attachmentIndex].loadOp, "VUID-VkAttachmentDescription-loadOp-parameter");

                skip |= ValidateRangedEnum("vkCreateRenderPass", ParameterName("pCreateInfo->pAttachments[%i].storeOp", ParameterName::IndexVector{ attachmentIndex }), "VkAttachmentStoreOp", AllVkAttachmentStoreOpEnums, pCreateInfo->pAttachments[attachmentIndex].storeOp, "VUID-VkAttachmentDescription-storeOp-parameter");

                skip |= ValidateRangedEnum("vkCreateRenderPass", ParameterName("pCreateInfo->pAttachments[%i].stencilLoadOp", ParameterName::IndexVector{ attachmentIndex }), "VkAttachmentLoadOp", AllVkAttachmentLoadOpEnums, pCreateInfo->pAttachments[attachmentIndex].stencilLoadOp, "VUID-VkAttachmentDescription-stencilLoadOp-parameter");

                skip |= ValidateRangedEnum("vkCreateRenderPass", ParameterName("pCreateInfo->pAttachments[%i].stencilStoreOp", ParameterName::IndexVector{ attachmentIndex }), "VkAttachmentStoreOp", AllVkAttachmentStoreOpEnums, pCreateInfo->pAttachments[attachmentIndex].stencilStoreOp, "VUID-VkAttachmentDescription-stencilStoreOp-parameter");

                skip |= ValidateRangedEnum("vkCreateRenderPass", ParameterName("pCreateInfo->pAttachments[%i].initialLayout", ParameterName::IndexVector{ attachmentIndex }), "VkImageLayout", AllVkImageLayoutEnums, pCreateInfo->pAttachments[attachmentIndex].initialLayout, "VUID-VkAttachmentDescription-initialLayout-parameter");

                skip |= ValidateRangedEnum("vkCreateRenderPass", ParameterName("pCreateInfo->pAttachments[%i].finalLayout", ParameterName::IndexVector{ attachmentIndex }), "VkImageLayout", AllVkImageLayoutEnums, pCreateInfo->pAttachments[attachmentIndex].finalLayout, "VUID-VkAttachmentDescription-finalLayout-parameter");
            }
        }

        skip |= ValidateArray("vkCreateRenderPass", "pCreateInfo->subpassCount", "pCreateInfo->pSubpasses", pCreateInfo->subpassCount, &pCreateInfo->pSubpasses, true, true, "VUID-VkRenderPassCreateInfo-subpassCount-arraylength", "VUID-VkRenderPassCreateInfo-pSubpasses-parameter");

        if (pCreateInfo->pSubpasses != nullptr)
        {
            for (uint32_t subpassIndex = 0; subpassIndex < pCreateInfo->subpassCount; ++subpassIndex)
            {
                skip |= ValidateFlags("vkCreateRenderPass", ParameterName("pCreateInfo->pSubpasses[%i].flags", ParameterName::IndexVector{ subpassIndex }), "VkSubpassDescriptionFlagBits", AllVkSubpassDescriptionFlagBits, pCreateInfo->pSubpasses[subpassIndex].flags, kOptionalFlags, "VUID-VkSubpassDescription-flags-parameter");

                skip |= ValidateRangedEnum("vkCreateRenderPass", ParameterName("pCreateInfo->pSubpasses[%i].pipelineBindPoint", ParameterName::IndexVector{ subpassIndex }), "VkPipelineBindPoint", AllVkPipelineBindPointEnums, pCreateInfo->pSubpasses[subpassIndex].pipelineBindPoint, "VUID-VkSubpassDescription-pipelineBindPoint-parameter");

                skip |= ValidateArray("vkCreateRenderPass", ParameterName("pCreateInfo->pSubpasses[%i].inputAttachmentCount", ParameterName::IndexVector{ subpassIndex }), ParameterName("pCreateInfo->pSubpasses[%i].pInputAttachments", ParameterName::IndexVector{ subpassIndex }), pCreateInfo->pSubpasses[subpassIndex].inputAttachmentCount, &pCreateInfo->pSubpasses[subpassIndex].pInputAttachments, false, true, kVUIDUndefined, "VUID-VkSubpassDescription-pInputAttachments-parameter");

                if (pCreateInfo->pSubpasses[subpassIndex].pInputAttachments != nullptr)
                {
                    for (uint32_t inputAttachmentIndex = 0; inputAttachmentIndex < pCreateInfo->pSubpasses[subpassIndex].inputAttachmentCount; ++inputAttachmentIndex)
                    {
                        skip |= ValidateRangedEnum("vkCreateRenderPass", ParameterName("pCreateInfo->pSubpasses[%i].pInputAttachments[%i].layout", ParameterName::IndexVector{ subpassIndex, inputAttachmentIndex }), "VkImageLayout", AllVkImageLayoutEnums, pCreateInfo->pSubpasses[subpassIndex].pInputAttachments[inputAttachmentIndex].layout, "VUID-VkAttachmentReference-layout-parameter");
                    }
                }

                skip |= ValidateArray("vkCreateRenderPass", ParameterName("pCreateInfo->pSubpasses[%i].colorAttachmentCount", ParameterName::IndexVector{ subpassIndex }), ParameterName("pCreateInfo->pSubpasses[%i].pColorAttachments", ParameterName::IndexVector{ subpassIndex }), pCreateInfo->pSubpasses[subpassIndex].colorAttachmentCount, &pCreateInfo->pSubpasses[subpassIndex].pColorAttachments, false, true, kVUIDUndefined, "VUID-VkSubpassDescription-pColorAttachments-parameter");

                if (pCreateInfo->pSubpasses[subpassIndex].pColorAttachments != nullptr)
                {
                    for (uint32_t colorAttachmentIndex = 0; colorAttachmentIndex < pCreateInfo->pSubpasses[subpassIndex].colorAttachmentCount; ++colorAttachmentIndex)
                    {
                        skip |= ValidateRangedEnum("vkCreateRenderPass", ParameterName("pCreateInfo->pSubpasses[%i].pColorAttachments[%i].layout", ParameterName::IndexVector{ subpassIndex, colorAttachmentIndex }), "VkImageLayout", AllVkImageLayoutEnums, pCreateInfo->pSubpasses[subpassIndex].pColorAttachments[colorAttachmentIndex].layout, "VUID-VkAttachmentReference-layout-parameter");
                    }
                }

                if (pCreateInfo->pSubpasses[subpassIndex].pResolveAttachments != nullptr)
                {
                    for (uint32_t colorAttachmentIndex = 0; colorAttachmentIndex < pCreateInfo->pSubpasses[subpassIndex].colorAttachmentCount; ++colorAttachmentIndex)
                    {
                        skip |= ValidateRangedEnum("vkCreateRenderPass", ParameterName("pCreateInfo->pSubpasses[%i].pResolveAttachments[%i].layout", ParameterName::IndexVector{ subpassIndex, colorAttachmentIndex }), "VkImageLayout", AllVkImageLayoutEnums, pCreateInfo->pSubpasses[subpassIndex].pResolveAttachments[colorAttachmentIndex].layout, "VUID-VkAttachmentReference-layout-parameter");
                    }
                }

                if (pCreateInfo->pSubpasses[subpassIndex].pDepthStencilAttachment != nullptr)
                {
                    skip |= ValidateRangedEnum("vkCreateRenderPass", ParameterName("pCreateInfo->pSubpasses[%i].pDepthStencilAttachment->layout", ParameterName::IndexVector{ subpassIndex }), "VkImageLayout", AllVkImageLayoutEnums, pCreateInfo->pSubpasses[subpassIndex].pDepthStencilAttachment->layout, "VUID-VkAttachmentReference-layout-parameter");
                }

                skip |= ValidateArray("vkCreateRenderPass", ParameterName("pCreateInfo->pSubpasses[%i].preserveAttachmentCount", ParameterName::IndexVector{ subpassIndex }), ParameterName("pCreateInfo->pSubpasses[%i].pPreserveAttachments", ParameterName::IndexVector{ subpassIndex }), pCreateInfo->pSubpasses[subpassIndex].preserveAttachmentCount, &pCreateInfo->pSubpasses[subpassIndex].pPreserveAttachments, false, true, kVUIDUndefined, "VUID-VkSubpassDescription-pPreserveAttachments-parameter");
            }
        }

        skip |= ValidateArray("vkCreateRenderPass", "pCreateInfo->dependencyCount", "pCreateInfo->pDependencies", pCreateInfo->dependencyCount, &pCreateInfo->pDependencies, false, true, kVUIDUndefined, "VUID-VkRenderPassCreateInfo-pDependencies-parameter");

        if (pCreateInfo->pDependencies != nullptr)
        {
            for (uint32_t dependencyIndex = 0; dependencyIndex < pCreateInfo->dependencyCount; ++dependencyIndex)
            {
                skip |= ValidateFlags("vkCreateRenderPass", ParameterName("pCreateInfo->pDependencies[%i].srcStageMask", ParameterName::IndexVector{ dependencyIndex }), "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, pCreateInfo->pDependencies[dependencyIndex].srcStageMask, kOptionalFlags, "VUID-VkSubpassDependency-srcStageMask-parameter");

                skip |= ValidateFlags("vkCreateRenderPass", ParameterName("pCreateInfo->pDependencies[%i].dstStageMask", ParameterName::IndexVector{ dependencyIndex }), "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, pCreateInfo->pDependencies[dependencyIndex].dstStageMask, kOptionalFlags, "VUID-VkSubpassDependency-dstStageMask-parameter");

                skip |= ValidateFlags("vkCreateRenderPass", ParameterName("pCreateInfo->pDependencies[%i].srcAccessMask", ParameterName::IndexVector{ dependencyIndex }), "VkAccessFlagBits", AllVkAccessFlagBits, pCreateInfo->pDependencies[dependencyIndex].srcAccessMask, kOptionalFlags, "VUID-VkSubpassDependency-srcAccessMask-parameter");

                skip |= ValidateFlags("vkCreateRenderPass", ParameterName("pCreateInfo->pDependencies[%i].dstAccessMask", ParameterName::IndexVector{ dependencyIndex }), "VkAccessFlagBits", AllVkAccessFlagBits, pCreateInfo->pDependencies[dependencyIndex].dstAccessMask, kOptionalFlags, "VUID-VkSubpassDependency-dstAccessMask-parameter");

                skip |= ValidateFlags("vkCreateRenderPass", ParameterName("pCreateInfo->pDependencies[%i].dependencyFlags", ParameterName::IndexVector{ dependencyIndex }), "VkDependencyFlagBits", AllVkDependencyFlagBits, pCreateInfo->pDependencies[dependencyIndex].dependencyFlags, kOptionalFlags, "VUID-VkSubpassDependency-dependencyFlags-parameter");
            }
        }
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateRenderPass", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateRenderPass", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateRenderPass", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateRenderPass", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateRenderPass", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateRenderPass", "pRenderPass", pRenderPass, "VUID-vkCreateRenderPass-pRenderPass-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateRenderPass(device, pCreateInfo, pAllocator, pRenderPass);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyRenderPass(
    VkDevice                                    device,
    VkRenderPass                                renderPass,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyRenderPass", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyRenderPass", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyRenderPass", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyRenderPass", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyRenderPass", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetRenderAreaGranularity(
    VkDevice                                    device,
    VkRenderPass                                renderPass,
    VkExtent2D*                                 pGranularity) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkGetRenderAreaGranularity", "renderPass", renderPass);
    skip |= ValidateRequiredPointer("vkGetRenderAreaGranularity", "pGranularity", pGranularity, "VUID-vkGetRenderAreaGranularity-pGranularity-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCreateCommandPool(
    VkDevice                                    device,
    const VkCommandPoolCreateInfo*              pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkCommandPool*                              pCommandPool) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateCommandPool", "pCreateInfo", "VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO, true, "VUID-vkCreateCommandPool-pCreateInfo-parameter", "VUID-VkCommandPoolCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCreateCommandPool", "pCreateInfo->pNext", nullptr, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkCommandPoolCreateInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateFlags("vkCreateCommandPool", "pCreateInfo->flags", "VkCommandPoolCreateFlagBits", AllVkCommandPoolCreateFlagBits, pCreateInfo->flags, kOptionalFlags, "VUID-VkCommandPoolCreateInfo-flags-parameter");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateCommandPool", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateCommandPool", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateCommandPool", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateCommandPool", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateCommandPool", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateCommandPool", "pCommandPool", pCommandPool, "VUID-vkCreateCommandPool-pCommandPool-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyCommandPool(
    VkDevice                                    device,
    VkCommandPool                               commandPool,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyCommandPool", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyCommandPool", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyCommandPool", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyCommandPool", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyCommandPool", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateResetCommandPool(
    VkDevice                                    device,
    VkCommandPool                               commandPool,
    VkCommandPoolResetFlags                     flags) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkResetCommandPool", "commandPool", commandPool);
    skip |= ValidateFlags("vkResetCommandPool", "flags", "VkCommandPoolResetFlagBits", AllVkCommandPoolResetFlagBits, flags, kOptionalFlags, "VUID-vkResetCommandPool-flags-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateAllocateCommandBuffers(
    VkDevice                                    device,
    const VkCommandBufferAllocateInfo*          pAllocateInfo,
    VkCommandBuffer*                            pCommandBuffers) const {
    bool skip = false;
    skip |= ValidateStructType("vkAllocateCommandBuffers", "pAllocateInfo", "VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO", pAllocateInfo, VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO, true, "VUID-vkAllocateCommandBuffers-pAllocateInfo-parameter", "VUID-VkCommandBufferAllocateInfo-sType-sType");
    if (pAllocateInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkAllocateCommandBuffers", "pAllocateInfo->pNext", nullptr, pAllocateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkCommandBufferAllocateInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle("vkAllocateCommandBuffers", "pAllocateInfo->commandPool", pAllocateInfo->commandPool);

        skip |= ValidateRangedEnum("vkAllocateCommandBuffers", "pAllocateInfo->level", "VkCommandBufferLevel", AllVkCommandBufferLevelEnums, pAllocateInfo->level, "VUID-VkCommandBufferAllocateInfo-level-parameter");
    }
    if (pAllocateInfo != nullptr) {
        skip |= ValidateArray("vkAllocateCommandBuffers", "pAllocateInfo->commandBufferCount", "pCommandBuffers", pAllocateInfo->commandBufferCount, &pCommandBuffers, true, true, "VUID-vkAllocateCommandBuffers-pAllocateInfo::commandBufferCount-arraylength", "VUID-vkAllocateCommandBuffers-pCommandBuffers-parameter");
    }
    return skip;
}

bool StatelessValidation::PreCallValidateFreeCommandBuffers(
    VkDevice                                    device,
    VkCommandPool                               commandPool,
    uint32_t                                    commandBufferCount,
    const VkCommandBuffer*                      pCommandBuffers) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkFreeCommandBuffers", "commandPool", commandPool);
    skip |= ValidateArray("vkFreeCommandBuffers", "commandBufferCount", "", commandBufferCount, &pCommandBuffers, true, false, "VUID-vkFreeCommandBuffers-commandBufferCount-arraylength", kVUIDUndefined);
    return skip;
}

bool StatelessValidation::PreCallValidateBeginCommandBuffer(
    VkCommandBuffer                             commandBuffer,
    const VkCommandBufferBeginInfo*             pBeginInfo) const {
    bool skip = false;
    skip |= ValidateStructType("vkBeginCommandBuffer", "pBeginInfo", "VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO", pBeginInfo, VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO, true, "VUID-vkBeginCommandBuffer-pBeginInfo-parameter", "VUID-VkCommandBufferBeginInfo-sType-sType");
    if (pBeginInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkCommandBufferBeginInfo = { VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO };

        skip |= ValidateStructPnext("vkBeginCommandBuffer", "pBeginInfo->pNext", "VkDeviceGroupCommandBufferBeginInfo", pBeginInfo->pNext, allowed_structs_VkCommandBufferBeginInfo.size(), allowed_structs_VkCommandBufferBeginInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkCommandBufferBeginInfo-pNext-pNext", "VUID-VkCommandBufferBeginInfo-sType-unique", false, true);

        skip |= ValidateFlags("vkBeginCommandBuffer", "pBeginInfo->flags", "VkCommandBufferUsageFlagBits", AllVkCommandBufferUsageFlagBits, pBeginInfo->flags, kOptionalFlags, "VUID-VkCommandBufferBeginInfo-flags-parameter");
    }
    if (!skip) skip |= manual_PreCallValidateBeginCommandBuffer(commandBuffer, pBeginInfo);
    return skip;
}

bool StatelessValidation::PreCallValidateEndCommandBuffer(
    VkCommandBuffer                             commandBuffer) const {
    bool skip = false;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateResetCommandBuffer(
    VkCommandBuffer                             commandBuffer,
    VkCommandBufferResetFlags                   flags) const {
    bool skip = false;
    skip |= ValidateFlags("vkResetCommandBuffer", "flags", "VkCommandBufferResetFlagBits", AllVkCommandBufferResetFlagBits, flags, kOptionalFlags, "VUID-vkResetCommandBuffer-flags-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBindPipeline(
    VkCommandBuffer                             commandBuffer,
    VkPipelineBindPoint                         pipelineBindPoint,
    VkPipeline                                  pipeline) const {
    bool skip = false;
    skip |= ValidateRangedEnum("vkCmdBindPipeline", "pipelineBindPoint", "VkPipelineBindPoint", AllVkPipelineBindPointEnums, pipelineBindPoint, "VUID-vkCmdBindPipeline-pipelineBindPoint-parameter");
    skip |= ValidateRequiredHandle("vkCmdBindPipeline", "pipeline", pipeline);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetViewport(
    VkCommandBuffer                             commandBuffer,
    uint32_t                                    firstViewport,
    uint32_t                                    viewportCount,
    const VkViewport*                           pViewports) const {
    bool skip = false;
    skip |= ValidateArray("vkCmdSetViewport", "viewportCount", "pViewports", viewportCount, &pViewports, true, true, "VUID-vkCmdSetViewport-viewportCount-arraylength", "VUID-vkCmdSetViewport-pViewports-parameter");
    if (pViewports != nullptr)
    {
        for (uint32_t viewportIndex = 0; viewportIndex < viewportCount; ++viewportIndex)
        {
            // No xml-driven validation
        }
    }
    if (!skip) skip |= manual_PreCallValidateCmdSetViewport(commandBuffer, firstViewport, viewportCount, pViewports);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetScissor(
    VkCommandBuffer                             commandBuffer,
    uint32_t                                    firstScissor,
    uint32_t                                    scissorCount,
    const VkRect2D*                             pScissors) const {
    bool skip = false;
    skip |= ValidateArray("vkCmdSetScissor", "scissorCount", "pScissors", scissorCount, &pScissors, true, true, "VUID-vkCmdSetScissor-scissorCount-arraylength", "VUID-vkCmdSetScissor-pScissors-parameter");
    if (pScissors != nullptr)
    {
        for (uint32_t scissorIndex = 0; scissorIndex < scissorCount; ++scissorIndex)
        {
            // No xml-driven validation

            // No xml-driven validation
        }
    }
    if (!skip) skip |= manual_PreCallValidateCmdSetScissor(commandBuffer, firstScissor, scissorCount, pScissors);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetLineWidth(
    VkCommandBuffer                             commandBuffer,
    float                                       lineWidth) const {
    bool skip = false;
    // No xml-driven validation
    if (!skip) skip |= manual_PreCallValidateCmdSetLineWidth(commandBuffer, lineWidth);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetDepthBias(
    VkCommandBuffer                             commandBuffer,
    float                                       depthBiasConstantFactor,
    float                                       depthBiasClamp,
    float                                       depthBiasSlopeFactor) const {
    bool skip = false;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetBlendConstants(
    VkCommandBuffer                             commandBuffer,
    const float                                 blendConstants[4]) const {
    bool skip = false;
    skip |= ValidateRequiredPointer("vkCmdSetBlendConstants", "blendConstants", blendConstants, kVUIDUndefined);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetDepthBounds(
    VkCommandBuffer                             commandBuffer,
    float                                       minDepthBounds,
    float                                       maxDepthBounds) const {
    bool skip = false;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetStencilCompareMask(
    VkCommandBuffer                             commandBuffer,
    VkStencilFaceFlags                          faceMask,
    uint32_t                                    compareMask) const {
    bool skip = false;
    skip |= ValidateFlags("vkCmdSetStencilCompareMask", "faceMask", "VkStencilFaceFlagBits", AllVkStencilFaceFlagBits, faceMask, kRequiredFlags, "VUID-vkCmdSetStencilCompareMask-faceMask-parameter", "VUID-vkCmdSetStencilCompareMask-faceMask-requiredbitmask");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetStencilWriteMask(
    VkCommandBuffer                             commandBuffer,
    VkStencilFaceFlags                          faceMask,
    uint32_t                                    writeMask) const {
    bool skip = false;
    skip |= ValidateFlags("vkCmdSetStencilWriteMask", "faceMask", "VkStencilFaceFlagBits", AllVkStencilFaceFlagBits, faceMask, kRequiredFlags, "VUID-vkCmdSetStencilWriteMask-faceMask-parameter", "VUID-vkCmdSetStencilWriteMask-faceMask-requiredbitmask");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetStencilReference(
    VkCommandBuffer                             commandBuffer,
    VkStencilFaceFlags                          faceMask,
    uint32_t                                    reference) const {
    bool skip = false;
    skip |= ValidateFlags("vkCmdSetStencilReference", "faceMask", "VkStencilFaceFlagBits", AllVkStencilFaceFlagBits, faceMask, kRequiredFlags, "VUID-vkCmdSetStencilReference-faceMask-parameter", "VUID-vkCmdSetStencilReference-faceMask-requiredbitmask");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBindDescriptorSets(
    VkCommandBuffer                             commandBuffer,
    VkPipelineBindPoint                         pipelineBindPoint,
    VkPipelineLayout                            layout,
    uint32_t                                    firstSet,
    uint32_t                                    descriptorSetCount,
    const VkDescriptorSet*                      pDescriptorSets,
    uint32_t                                    dynamicOffsetCount,
    const uint32_t*                             pDynamicOffsets) const {
    bool skip = false;
    skip |= ValidateRangedEnum("vkCmdBindDescriptorSets", "pipelineBindPoint", "VkPipelineBindPoint", AllVkPipelineBindPointEnums, pipelineBindPoint, "VUID-vkCmdBindDescriptorSets-pipelineBindPoint-parameter");
    skip |= ValidateRequiredHandle("vkCmdBindDescriptorSets", "layout", layout);
    skip |= ValidateArray("vkCmdBindDescriptorSets", "descriptorSetCount", "pDescriptorSets", descriptorSetCount, &pDescriptorSets, true, false, "VUID-vkCmdBindDescriptorSets-descriptorSetCount-arraylength", "VUID-vkCmdBindDescriptorSets-pDescriptorSets-parameter");
    skip |= ValidateArray("vkCmdBindDescriptorSets", "dynamicOffsetCount", "pDynamicOffsets", dynamicOffsetCount, &pDynamicOffsets, false, true, kVUIDUndefined, "VUID-vkCmdBindDescriptorSets-pDynamicOffsets-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBindIndexBuffer(
    VkCommandBuffer                             commandBuffer,
    VkBuffer                                    buffer,
    VkDeviceSize                                offset,
    VkIndexType                                 indexType) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdBindIndexBuffer", "buffer", buffer);
    skip |= ValidateRangedEnum("vkCmdBindIndexBuffer", "indexType", "VkIndexType", AllVkIndexTypeEnums, indexType, "VUID-vkCmdBindIndexBuffer-indexType-parameter");
    if (!skip) skip |= manual_PreCallValidateCmdBindIndexBuffer(commandBuffer, buffer, offset, indexType);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBindVertexBuffers(
    VkCommandBuffer                             commandBuffer,
    uint32_t                                    firstBinding,
    uint32_t                                    bindingCount,
    const VkBuffer*                             pBuffers,
    const VkDeviceSize*                         pOffsets) const {
    bool skip = false;
    skip |= ValidateArray("vkCmdBindVertexBuffers", "bindingCount", "pBuffers", bindingCount, &pBuffers, true, false, "VUID-vkCmdBindVertexBuffers-bindingCount-arraylength", "VUID-vkCmdBindVertexBuffers-pBuffers-parameter");
    skip |= ValidateArray("vkCmdBindVertexBuffers", "bindingCount", "pOffsets", bindingCount, &pOffsets, true, true, "VUID-vkCmdBindVertexBuffers-bindingCount-arraylength", "VUID-vkCmdBindVertexBuffers-pOffsets-parameter");
    if (!skip) skip |= manual_PreCallValidateCmdBindVertexBuffers(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdDraw(
    VkCommandBuffer                             commandBuffer,
    uint32_t                                    vertexCount,
    uint32_t                                    instanceCount,
    uint32_t                                    firstVertex,
    uint32_t                                    firstInstance) const {
    bool skip = false;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateCmdDrawIndexed(
    VkCommandBuffer                             commandBuffer,
    uint32_t                                    indexCount,
    uint32_t                                    instanceCount,
    uint32_t                                    firstIndex,
    int32_t                                     vertexOffset,
    uint32_t                                    firstInstance) const {
    bool skip = false;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateCmdDrawIndirect(
    VkCommandBuffer                             commandBuffer,
    VkBuffer                                    buffer,
    VkDeviceSize                                offset,
    uint32_t                                    drawCount,
    uint32_t                                    stride) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdDrawIndirect", "buffer", buffer);
    if (!skip) skip |= manual_PreCallValidateCmdDrawIndirect(commandBuffer, buffer, offset, drawCount, stride);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdDrawIndexedIndirect(
    VkCommandBuffer                             commandBuffer,
    VkBuffer                                    buffer,
    VkDeviceSize                                offset,
    uint32_t                                    drawCount,
    uint32_t                                    stride) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdDrawIndexedIndirect", "buffer", buffer);
    if (!skip) skip |= manual_PreCallValidateCmdDrawIndexedIndirect(commandBuffer, buffer, offset, drawCount, stride);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdDispatch(
    VkCommandBuffer                             commandBuffer,
    uint32_t                                    groupCountX,
    uint32_t                                    groupCountY,
    uint32_t                                    groupCountZ) const {
    bool skip = false;
    // No xml-driven validation
    if (!skip) skip |= manual_PreCallValidateCmdDispatch(commandBuffer, groupCountX, groupCountY, groupCountZ);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdDispatchIndirect(
    VkCommandBuffer                             commandBuffer,
    VkBuffer                                    buffer,
    VkDeviceSize                                offset) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdDispatchIndirect", "buffer", buffer);
    if (!skip) skip |= manual_PreCallValidateCmdDispatchIndirect(commandBuffer, buffer, offset);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyBuffer(
    VkCommandBuffer                             commandBuffer,
    VkBuffer                                    srcBuffer,
    VkBuffer                                    dstBuffer,
    uint32_t                                    regionCount,
    const VkBufferCopy*                         pRegions) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdCopyBuffer", "srcBuffer", srcBuffer);
    skip |= ValidateRequiredHandle("vkCmdCopyBuffer", "dstBuffer", dstBuffer);
    skip |= ValidateArray("vkCmdCopyBuffer", "regionCount", "pRegions", regionCount, &pRegions, true, true, "VUID-vkCmdCopyBuffer-regionCount-arraylength", "VUID-vkCmdCopyBuffer-pRegions-parameter");
    if (pRegions != nullptr)
    {
        for (uint32_t regionIndex = 0; regionIndex < regionCount; ++regionIndex)
        {
            // No xml-driven validation
        }
    }
    if (!skip) skip |= manual_PreCallValidateCmdCopyBuffer(commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyImage(
    VkCommandBuffer                             commandBuffer,
    VkImage                                     srcImage,
    VkImageLayout                               srcImageLayout,
    VkImage                                     dstImage,
    VkImageLayout                               dstImageLayout,
    uint32_t                                    regionCount,
    const VkImageCopy*                          pRegions) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdCopyImage", "srcImage", srcImage);
    skip |= ValidateRangedEnum("vkCmdCopyImage", "srcImageLayout", "VkImageLayout", AllVkImageLayoutEnums, srcImageLayout, "VUID-vkCmdCopyImage-srcImageLayout-parameter");
    skip |= ValidateRequiredHandle("vkCmdCopyImage", "dstImage", dstImage);
    skip |= ValidateRangedEnum("vkCmdCopyImage", "dstImageLayout", "VkImageLayout", AllVkImageLayoutEnums, dstImageLayout, "VUID-vkCmdCopyImage-dstImageLayout-parameter");
    skip |= ValidateArray("vkCmdCopyImage", "regionCount", "pRegions", regionCount, &pRegions, true, true, "VUID-vkCmdCopyImage-regionCount-arraylength", "VUID-vkCmdCopyImage-pRegions-parameter");
    if (pRegions != nullptr)
    {
        for (uint32_t regionIndex = 0; regionIndex < regionCount; ++regionIndex)
        {
            skip |= ValidateFlags("vkCmdCopyImage", ParameterName("pRegions[%i].srcSubresource.aspectMask", ParameterName::IndexVector{ regionIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pRegions[regionIndex].srcSubresource.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceLayers-aspectMask-parameter", "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

            // No xml-driven validation

            skip |= ValidateFlags("vkCmdCopyImage", ParameterName("pRegions[%i].dstSubresource.aspectMask", ParameterName::IndexVector{ regionIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pRegions[regionIndex].dstSubresource.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceLayers-aspectMask-parameter", "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

            // No xml-driven validation

            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBlitImage(
    VkCommandBuffer                             commandBuffer,
    VkImage                                     srcImage,
    VkImageLayout                               srcImageLayout,
    VkImage                                     dstImage,
    VkImageLayout                               dstImageLayout,
    uint32_t                                    regionCount,
    const VkImageBlit*                          pRegions,
    VkFilter                                    filter) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdBlitImage", "srcImage", srcImage);
    skip |= ValidateRangedEnum("vkCmdBlitImage", "srcImageLayout", "VkImageLayout", AllVkImageLayoutEnums, srcImageLayout, "VUID-vkCmdBlitImage-srcImageLayout-parameter");
    skip |= ValidateRequiredHandle("vkCmdBlitImage", "dstImage", dstImage);
    skip |= ValidateRangedEnum("vkCmdBlitImage", "dstImageLayout", "VkImageLayout", AllVkImageLayoutEnums, dstImageLayout, "VUID-vkCmdBlitImage-dstImageLayout-parameter");
    skip |= ValidateArray("vkCmdBlitImage", "regionCount", "pRegions", regionCount, &pRegions, true, true, "VUID-vkCmdBlitImage-regionCount-arraylength", "VUID-vkCmdBlitImage-pRegions-parameter");
    if (pRegions != nullptr)
    {
        for (uint32_t regionIndex = 0; regionIndex < regionCount; ++regionIndex)
        {
            skip |= ValidateFlags("vkCmdBlitImage", ParameterName("pRegions[%i].srcSubresource.aspectMask", ParameterName::IndexVector{ regionIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pRegions[regionIndex].srcSubresource.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceLayers-aspectMask-parameter", "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

            skip |= ValidateFlags("vkCmdBlitImage", ParameterName("pRegions[%i].dstSubresource.aspectMask", ParameterName::IndexVector{ regionIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pRegions[regionIndex].dstSubresource.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceLayers-aspectMask-parameter", "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");
        }
    }
    skip |= ValidateRangedEnum("vkCmdBlitImage", "filter", "VkFilter", AllVkFilterEnums, filter, "VUID-vkCmdBlitImage-filter-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyBufferToImage(
    VkCommandBuffer                             commandBuffer,
    VkBuffer                                    srcBuffer,
    VkImage                                     dstImage,
    VkImageLayout                               dstImageLayout,
    uint32_t                                    regionCount,
    const VkBufferImageCopy*                    pRegions) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdCopyBufferToImage", "srcBuffer", srcBuffer);
    skip |= ValidateRequiredHandle("vkCmdCopyBufferToImage", "dstImage", dstImage);
    skip |= ValidateRangedEnum("vkCmdCopyBufferToImage", "dstImageLayout", "VkImageLayout", AllVkImageLayoutEnums, dstImageLayout, "VUID-vkCmdCopyBufferToImage-dstImageLayout-parameter");
    skip |= ValidateArray("vkCmdCopyBufferToImage", "regionCount", "pRegions", regionCount, &pRegions, true, true, "VUID-vkCmdCopyBufferToImage-regionCount-arraylength", "VUID-vkCmdCopyBufferToImage-pRegions-parameter");
    if (pRegions != nullptr)
    {
        for (uint32_t regionIndex = 0; regionIndex < regionCount; ++regionIndex)
        {
            skip |= ValidateFlags("vkCmdCopyBufferToImage", ParameterName("pRegions[%i].imageSubresource.aspectMask", ParameterName::IndexVector{ regionIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pRegions[regionIndex].imageSubresource.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceLayers-aspectMask-parameter", "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

            // No xml-driven validation

            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyImageToBuffer(
    VkCommandBuffer                             commandBuffer,
    VkImage                                     srcImage,
    VkImageLayout                               srcImageLayout,
    VkBuffer                                    dstBuffer,
    uint32_t                                    regionCount,
    const VkBufferImageCopy*                    pRegions) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdCopyImageToBuffer", "srcImage", srcImage);
    skip |= ValidateRangedEnum("vkCmdCopyImageToBuffer", "srcImageLayout", "VkImageLayout", AllVkImageLayoutEnums, srcImageLayout, "VUID-vkCmdCopyImageToBuffer-srcImageLayout-parameter");
    skip |= ValidateRequiredHandle("vkCmdCopyImageToBuffer", "dstBuffer", dstBuffer);
    skip |= ValidateArray("vkCmdCopyImageToBuffer", "regionCount", "pRegions", regionCount, &pRegions, true, true, "VUID-vkCmdCopyImageToBuffer-regionCount-arraylength", "VUID-vkCmdCopyImageToBuffer-pRegions-parameter");
    if (pRegions != nullptr)
    {
        for (uint32_t regionIndex = 0; regionIndex < regionCount; ++regionIndex)
        {
            skip |= ValidateFlags("vkCmdCopyImageToBuffer", ParameterName("pRegions[%i].imageSubresource.aspectMask", ParameterName::IndexVector{ regionIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pRegions[regionIndex].imageSubresource.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceLayers-aspectMask-parameter", "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

            // No xml-driven validation

            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdUpdateBuffer(
    VkCommandBuffer                             commandBuffer,
    VkBuffer                                    dstBuffer,
    VkDeviceSize                                dstOffset,
    VkDeviceSize                                dataSize,
    const void*                                 pData) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdUpdateBuffer", "dstBuffer", dstBuffer);
    skip |= ValidateArray("vkCmdUpdateBuffer", "dataSize", "pData", dataSize, &pData, true, true, "VUID-vkCmdUpdateBuffer-dataSize-arraylength", "VUID-vkCmdUpdateBuffer-pData-parameter");
    if (!skip) skip |= manual_PreCallValidateCmdUpdateBuffer(commandBuffer, dstBuffer, dstOffset, dataSize, pData);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdFillBuffer(
    VkCommandBuffer                             commandBuffer,
    VkBuffer                                    dstBuffer,
    VkDeviceSize                                dstOffset,
    VkDeviceSize                                size,
    uint32_t                                    data) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdFillBuffer", "dstBuffer", dstBuffer);
    if (!skip) skip |= manual_PreCallValidateCmdFillBuffer(commandBuffer, dstBuffer, dstOffset, size, data);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdClearColorImage(
    VkCommandBuffer                             commandBuffer,
    VkImage                                     image,
    VkImageLayout                               imageLayout,
    const VkClearColorValue*                    pColor,
    uint32_t                                    rangeCount,
    const VkImageSubresourceRange*              pRanges) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdClearColorImage", "image", image);
    skip |= ValidateRangedEnum("vkCmdClearColorImage", "imageLayout", "VkImageLayout", AllVkImageLayoutEnums, imageLayout, "VUID-vkCmdClearColorImage-imageLayout-parameter");
    skip |= ValidateArray("vkCmdClearColorImage", "rangeCount", "pRanges", rangeCount, &pRanges, true, true, "VUID-vkCmdClearColorImage-rangeCount-arraylength", "VUID-vkCmdClearColorImage-pRanges-parameter");
    if (pRanges != nullptr)
    {
        for (uint32_t rangeIndex = 0; rangeIndex < rangeCount; ++rangeIndex)
        {
            skip |= ValidateFlags("vkCmdClearColorImage", ParameterName("pRanges[%i].aspectMask", ParameterName::IndexVector{ rangeIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pRanges[rangeIndex].aspectMask, kRequiredFlags, "VUID-VkImageSubresourceRange-aspectMask-parameter", "VUID-VkImageSubresourceRange-aspectMask-requiredbitmask");
        }
    }
    if (!skip) skip |= manual_PreCallValidateCmdClearColorImage(commandBuffer, image, imageLayout, pColor, rangeCount, pRanges);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdClearDepthStencilImage(
    VkCommandBuffer                             commandBuffer,
    VkImage                                     image,
    VkImageLayout                               imageLayout,
    const VkClearDepthStencilValue*             pDepthStencil,
    uint32_t                                    rangeCount,
    const VkImageSubresourceRange*              pRanges) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdClearDepthStencilImage", "image", image);
    skip |= ValidateRangedEnum("vkCmdClearDepthStencilImage", "imageLayout", "VkImageLayout", AllVkImageLayoutEnums, imageLayout, "VUID-vkCmdClearDepthStencilImage-imageLayout-parameter");
    skip |= ValidateRequiredPointer("vkCmdClearDepthStencilImage", "pDepthStencil", pDepthStencil, "VUID-vkCmdClearDepthStencilImage-pDepthStencil-parameter");
    if (pDepthStencil != nullptr)
    {
        // No xml-driven validation
    }
    skip |= ValidateArray("vkCmdClearDepthStencilImage", "rangeCount", "pRanges", rangeCount, &pRanges, true, true, "VUID-vkCmdClearDepthStencilImage-rangeCount-arraylength", "VUID-vkCmdClearDepthStencilImage-pRanges-parameter");
    if (pRanges != nullptr)
    {
        for (uint32_t rangeIndex = 0; rangeIndex < rangeCount; ++rangeIndex)
        {
            skip |= ValidateFlags("vkCmdClearDepthStencilImage", ParameterName("pRanges[%i].aspectMask", ParameterName::IndexVector{ rangeIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pRanges[rangeIndex].aspectMask, kRequiredFlags, "VUID-VkImageSubresourceRange-aspectMask-parameter", "VUID-VkImageSubresourceRange-aspectMask-requiredbitmask");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdClearAttachments(
    VkCommandBuffer                             commandBuffer,
    uint32_t                                    attachmentCount,
    const VkClearAttachment*                    pAttachments,
    uint32_t                                    rectCount,
    const VkClearRect*                          pRects) const {
    bool skip = false;
    skip |= ValidateArray("vkCmdClearAttachments", "attachmentCount", "pAttachments", attachmentCount, &pAttachments, true, true, "VUID-vkCmdClearAttachments-attachmentCount-arraylength", "VUID-vkCmdClearAttachments-pAttachments-parameter");
    if (pAttachments != nullptr)
    {
        for (uint32_t attachmentIndex = 0; attachmentIndex < attachmentCount; ++attachmentIndex)
        {
            skip |= ValidateFlags("vkCmdClearAttachments", ParameterName("pAttachments[%i].aspectMask", ParameterName::IndexVector{ attachmentIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pAttachments[attachmentIndex].aspectMask, kRequiredFlags, "VUID-VkClearAttachment-aspectMask-parameter", "VUID-VkClearAttachment-aspectMask-requiredbitmask");
        }
    }
    skip |= ValidateArray("vkCmdClearAttachments", "rectCount", "pRects", rectCount, &pRects, true, true, "VUID-vkCmdClearAttachments-rectCount-arraylength", "VUID-vkCmdClearAttachments-pRects-parameter");
    if (pRects != nullptr)
    {
        for (uint32_t rectIndex = 0; rectIndex < rectCount; ++rectIndex)
        {
            // No xml-driven validation

            // No xml-driven validation
        }
    }
    if (!skip) skip |= manual_PreCallValidateCmdClearAttachments(commandBuffer, attachmentCount, pAttachments, rectCount, pRects);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdResolveImage(
    VkCommandBuffer                             commandBuffer,
    VkImage                                     srcImage,
    VkImageLayout                               srcImageLayout,
    VkImage                                     dstImage,
    VkImageLayout                               dstImageLayout,
    uint32_t                                    regionCount,
    const VkImageResolve*                       pRegions) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdResolveImage", "srcImage", srcImage);
    skip |= ValidateRangedEnum("vkCmdResolveImage", "srcImageLayout", "VkImageLayout", AllVkImageLayoutEnums, srcImageLayout, "VUID-vkCmdResolveImage-srcImageLayout-parameter");
    skip |= ValidateRequiredHandle("vkCmdResolveImage", "dstImage", dstImage);
    skip |= ValidateRangedEnum("vkCmdResolveImage", "dstImageLayout", "VkImageLayout", AllVkImageLayoutEnums, dstImageLayout, "VUID-vkCmdResolveImage-dstImageLayout-parameter");
    skip |= ValidateArray("vkCmdResolveImage", "regionCount", "pRegions", regionCount, &pRegions, true, true, "VUID-vkCmdResolveImage-regionCount-arraylength", "VUID-vkCmdResolveImage-pRegions-parameter");
    if (pRegions != nullptr)
    {
        for (uint32_t regionIndex = 0; regionIndex < regionCount; ++regionIndex)
        {
            skip |= ValidateFlags("vkCmdResolveImage", ParameterName("pRegions[%i].srcSubresource.aspectMask", ParameterName::IndexVector{ regionIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pRegions[regionIndex].srcSubresource.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceLayers-aspectMask-parameter", "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

            // No xml-driven validation

            skip |= ValidateFlags("vkCmdResolveImage", ParameterName("pRegions[%i].dstSubresource.aspectMask", ParameterName::IndexVector{ regionIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pRegions[regionIndex].dstSubresource.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceLayers-aspectMask-parameter", "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

            // No xml-driven validation

            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetEvent(
    VkCommandBuffer                             commandBuffer,
    VkEvent                                     event,
    VkPipelineStageFlags                        stageMask) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdSetEvent", "event", event);
    skip |= ValidateFlags("vkCmdSetEvent", "stageMask", "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, stageMask, kOptionalFlags, "VUID-vkCmdSetEvent-stageMask-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdResetEvent(
    VkCommandBuffer                             commandBuffer,
    VkEvent                                     event,
    VkPipelineStageFlags                        stageMask) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdResetEvent", "event", event);
    skip |= ValidateFlags("vkCmdResetEvent", "stageMask", "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, stageMask, kOptionalFlags, "VUID-vkCmdResetEvent-stageMask-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdWaitEvents(
    VkCommandBuffer                             commandBuffer,
    uint32_t                                    eventCount,
    const VkEvent*                              pEvents,
    VkPipelineStageFlags                        srcStageMask,
    VkPipelineStageFlags                        dstStageMask,
    uint32_t                                    memoryBarrierCount,
    const VkMemoryBarrier*                      pMemoryBarriers,
    uint32_t                                    bufferMemoryBarrierCount,
    const VkBufferMemoryBarrier*                pBufferMemoryBarriers,
    uint32_t                                    imageMemoryBarrierCount,
    const VkImageMemoryBarrier*                 pImageMemoryBarriers) const {
    bool skip = false;
    skip |= ValidateHandleArray("vkCmdWaitEvents", "eventCount", "pEvents", eventCount, pEvents, true, true, "VUID-vkCmdWaitEvents-eventCount-arraylength");
    skip |= ValidateFlags("vkCmdWaitEvents", "srcStageMask", "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, srcStageMask, kOptionalFlags, "VUID-vkCmdWaitEvents-srcStageMask-parameter");
    skip |= ValidateFlags("vkCmdWaitEvents", "dstStageMask", "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, dstStageMask, kOptionalFlags, "VUID-vkCmdWaitEvents-dstStageMask-parameter");
    skip |= ValidateStructTypeArray("vkCmdWaitEvents", "memoryBarrierCount", "pMemoryBarriers", "VK_STRUCTURE_TYPE_MEMORY_BARRIER", memoryBarrierCount, pMemoryBarriers, VK_STRUCTURE_TYPE_MEMORY_BARRIER, false, true, "VUID-VkMemoryBarrier-sType-sType", "VUID-vkCmdWaitEvents-pMemoryBarriers-parameter", kVUIDUndefined);
    if (pMemoryBarriers != nullptr)
    {
        for (uint32_t memoryBarrierIndex = 0; memoryBarrierIndex < memoryBarrierCount; ++memoryBarrierIndex)
        {
            skip |= ValidateStructPnext("vkCmdWaitEvents", ParameterName("pMemoryBarriers[%i].pNext", ParameterName::IndexVector{ memoryBarrierIndex }), nullptr, pMemoryBarriers[memoryBarrierIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkMemoryBarrier-pNext-pNext", kVUIDUndefined, false, true);

            skip |= ValidateFlags("vkCmdWaitEvents", ParameterName("pMemoryBarriers[%i].srcAccessMask", ParameterName::IndexVector{ memoryBarrierIndex }), "VkAccessFlagBits", AllVkAccessFlagBits, pMemoryBarriers[memoryBarrierIndex].srcAccessMask, kOptionalFlags, "VUID-VkMemoryBarrier-srcAccessMask-parameter");

            skip |= ValidateFlags("vkCmdWaitEvents", ParameterName("pMemoryBarriers[%i].dstAccessMask", ParameterName::IndexVector{ memoryBarrierIndex }), "VkAccessFlagBits", AllVkAccessFlagBits, pMemoryBarriers[memoryBarrierIndex].dstAccessMask, kOptionalFlags, "VUID-VkMemoryBarrier-dstAccessMask-parameter");
        }
    }
    skip |= ValidateStructTypeArray("vkCmdWaitEvents", "bufferMemoryBarrierCount", "pBufferMemoryBarriers", "VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER", bufferMemoryBarrierCount, pBufferMemoryBarriers, VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER, false, true, "VUID-VkBufferMemoryBarrier-sType-sType", "VUID-vkCmdWaitEvents-pBufferMemoryBarriers-parameter", kVUIDUndefined);
    if (pBufferMemoryBarriers != nullptr)
    {
        for (uint32_t bufferMemoryBarrierIndex = 0; bufferMemoryBarrierIndex < bufferMemoryBarrierCount; ++bufferMemoryBarrierIndex)
        {
            skip |= ValidateStructPnext("vkCmdWaitEvents", ParameterName("pBufferMemoryBarriers[%i].pNext", ParameterName::IndexVector{ bufferMemoryBarrierIndex }), nullptr, pBufferMemoryBarriers[bufferMemoryBarrierIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkBufferMemoryBarrier-pNext-pNext", kVUIDUndefined, false, true);

            skip |= ValidateRequiredHandle("vkCmdWaitEvents", ParameterName("pBufferMemoryBarriers[%i].buffer", ParameterName::IndexVector{ bufferMemoryBarrierIndex }), pBufferMemoryBarriers[bufferMemoryBarrierIndex].buffer);
        }
    }
    skip |= ValidateStructTypeArray("vkCmdWaitEvents", "imageMemoryBarrierCount", "pImageMemoryBarriers", "VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER", imageMemoryBarrierCount, pImageMemoryBarriers, VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER, false, true, "VUID-VkImageMemoryBarrier-sType-sType", "VUID-vkCmdWaitEvents-pImageMemoryBarriers-parameter", kVUIDUndefined);
    if (pImageMemoryBarriers != nullptr)
    {
        for (uint32_t imageMemoryBarrierIndex = 0; imageMemoryBarrierIndex < imageMemoryBarrierCount; ++imageMemoryBarrierIndex)
        {
            constexpr std::array allowed_structs_VkImageMemoryBarrier = { VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT };

            skip |= ValidateStructPnext("vkCmdWaitEvents", ParameterName("pImageMemoryBarriers[%i].pNext", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkSampleLocationsInfoEXT", pImageMemoryBarriers[imageMemoryBarrierIndex].pNext, allowed_structs_VkImageMemoryBarrier.size(), allowed_structs_VkImageMemoryBarrier.data(), GeneratedVulkanHeaderVersion, "VUID-VkImageMemoryBarrier-pNext-pNext", "VUID-VkImageMemoryBarrier-sType-unique", false, true);

            skip |= ValidateRangedEnum("vkCmdWaitEvents", ParameterName("pImageMemoryBarriers[%i].oldLayout", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkImageLayout", AllVkImageLayoutEnums, pImageMemoryBarriers[imageMemoryBarrierIndex].oldLayout, "VUID-VkImageMemoryBarrier-oldLayout-parameter");

            skip |= ValidateRangedEnum("vkCmdWaitEvents", ParameterName("pImageMemoryBarriers[%i].newLayout", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkImageLayout", AllVkImageLayoutEnums, pImageMemoryBarriers[imageMemoryBarrierIndex].newLayout, "VUID-VkImageMemoryBarrier-newLayout-parameter");

            skip |= ValidateRequiredHandle("vkCmdWaitEvents", ParameterName("pImageMemoryBarriers[%i].image", ParameterName::IndexVector{ imageMemoryBarrierIndex }), pImageMemoryBarriers[imageMemoryBarrierIndex].image);

            skip |= ValidateFlags("vkCmdWaitEvents", ParameterName("pImageMemoryBarriers[%i].subresourceRange.aspectMask", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pImageMemoryBarriers[imageMemoryBarrierIndex].subresourceRange.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceRange-aspectMask-parameter", "VUID-VkImageSubresourceRange-aspectMask-requiredbitmask");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdPipelineBarrier(
    VkCommandBuffer                             commandBuffer,
    VkPipelineStageFlags                        srcStageMask,
    VkPipelineStageFlags                        dstStageMask,
    VkDependencyFlags                           dependencyFlags,
    uint32_t                                    memoryBarrierCount,
    const VkMemoryBarrier*                      pMemoryBarriers,
    uint32_t                                    bufferMemoryBarrierCount,
    const VkBufferMemoryBarrier*                pBufferMemoryBarriers,
    uint32_t                                    imageMemoryBarrierCount,
    const VkImageMemoryBarrier*                 pImageMemoryBarriers) const {
    bool skip = false;
    skip |= ValidateFlags("vkCmdPipelineBarrier", "srcStageMask", "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, srcStageMask, kOptionalFlags, "VUID-vkCmdPipelineBarrier-srcStageMask-parameter");
    skip |= ValidateFlags("vkCmdPipelineBarrier", "dstStageMask", "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, dstStageMask, kOptionalFlags, "VUID-vkCmdPipelineBarrier-dstStageMask-parameter");
    skip |= ValidateFlags("vkCmdPipelineBarrier", "dependencyFlags", "VkDependencyFlagBits", AllVkDependencyFlagBits, dependencyFlags, kOptionalFlags, "VUID-vkCmdPipelineBarrier-dependencyFlags-parameter");
    skip |= ValidateStructTypeArray("vkCmdPipelineBarrier", "memoryBarrierCount", "pMemoryBarriers", "VK_STRUCTURE_TYPE_MEMORY_BARRIER", memoryBarrierCount, pMemoryBarriers, VK_STRUCTURE_TYPE_MEMORY_BARRIER, false, true, "VUID-VkMemoryBarrier-sType-sType", "VUID-vkCmdPipelineBarrier-pMemoryBarriers-parameter", kVUIDUndefined);
    if (pMemoryBarriers != nullptr)
    {
        for (uint32_t memoryBarrierIndex = 0; memoryBarrierIndex < memoryBarrierCount; ++memoryBarrierIndex)
        {
            skip |= ValidateStructPnext("vkCmdPipelineBarrier", ParameterName("pMemoryBarriers[%i].pNext", ParameterName::IndexVector{ memoryBarrierIndex }), nullptr, pMemoryBarriers[memoryBarrierIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkMemoryBarrier-pNext-pNext", kVUIDUndefined, false, true);

            skip |= ValidateFlags("vkCmdPipelineBarrier", ParameterName("pMemoryBarriers[%i].srcAccessMask", ParameterName::IndexVector{ memoryBarrierIndex }), "VkAccessFlagBits", AllVkAccessFlagBits, pMemoryBarriers[memoryBarrierIndex].srcAccessMask, kOptionalFlags, "VUID-VkMemoryBarrier-srcAccessMask-parameter");

            skip |= ValidateFlags("vkCmdPipelineBarrier", ParameterName("pMemoryBarriers[%i].dstAccessMask", ParameterName::IndexVector{ memoryBarrierIndex }), "VkAccessFlagBits", AllVkAccessFlagBits, pMemoryBarriers[memoryBarrierIndex].dstAccessMask, kOptionalFlags, "VUID-VkMemoryBarrier-dstAccessMask-parameter");
        }
    }
    skip |= ValidateStructTypeArray("vkCmdPipelineBarrier", "bufferMemoryBarrierCount", "pBufferMemoryBarriers", "VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER", bufferMemoryBarrierCount, pBufferMemoryBarriers, VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER, false, true, "VUID-VkBufferMemoryBarrier-sType-sType", "VUID-vkCmdPipelineBarrier-pBufferMemoryBarriers-parameter", kVUIDUndefined);
    if (pBufferMemoryBarriers != nullptr)
    {
        for (uint32_t bufferMemoryBarrierIndex = 0; bufferMemoryBarrierIndex < bufferMemoryBarrierCount; ++bufferMemoryBarrierIndex)
        {
            skip |= ValidateStructPnext("vkCmdPipelineBarrier", ParameterName("pBufferMemoryBarriers[%i].pNext", ParameterName::IndexVector{ bufferMemoryBarrierIndex }), nullptr, pBufferMemoryBarriers[bufferMemoryBarrierIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkBufferMemoryBarrier-pNext-pNext", kVUIDUndefined, false, true);

            skip |= ValidateRequiredHandle("vkCmdPipelineBarrier", ParameterName("pBufferMemoryBarriers[%i].buffer", ParameterName::IndexVector{ bufferMemoryBarrierIndex }), pBufferMemoryBarriers[bufferMemoryBarrierIndex].buffer);
        }
    }
    skip |= ValidateStructTypeArray("vkCmdPipelineBarrier", "imageMemoryBarrierCount", "pImageMemoryBarriers", "VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER", imageMemoryBarrierCount, pImageMemoryBarriers, VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER, false, true, "VUID-VkImageMemoryBarrier-sType-sType", "VUID-vkCmdPipelineBarrier-pImageMemoryBarriers-parameter", kVUIDUndefined);
    if (pImageMemoryBarriers != nullptr)
    {
        for (uint32_t imageMemoryBarrierIndex = 0; imageMemoryBarrierIndex < imageMemoryBarrierCount; ++imageMemoryBarrierIndex)
        {
            constexpr std::array allowed_structs_VkImageMemoryBarrier = { VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT };

            skip |= ValidateStructPnext("vkCmdPipelineBarrier", ParameterName("pImageMemoryBarriers[%i].pNext", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkSampleLocationsInfoEXT", pImageMemoryBarriers[imageMemoryBarrierIndex].pNext, allowed_structs_VkImageMemoryBarrier.size(), allowed_structs_VkImageMemoryBarrier.data(), GeneratedVulkanHeaderVersion, "VUID-VkImageMemoryBarrier-pNext-pNext", "VUID-VkImageMemoryBarrier-sType-unique", false, true);

            skip |= ValidateRangedEnum("vkCmdPipelineBarrier", ParameterName("pImageMemoryBarriers[%i].oldLayout", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkImageLayout", AllVkImageLayoutEnums, pImageMemoryBarriers[imageMemoryBarrierIndex].oldLayout, "VUID-VkImageMemoryBarrier-oldLayout-parameter");

            skip |= ValidateRangedEnum("vkCmdPipelineBarrier", ParameterName("pImageMemoryBarriers[%i].newLayout", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkImageLayout", AllVkImageLayoutEnums, pImageMemoryBarriers[imageMemoryBarrierIndex].newLayout, "VUID-VkImageMemoryBarrier-newLayout-parameter");

            skip |= ValidateRequiredHandle("vkCmdPipelineBarrier", ParameterName("pImageMemoryBarriers[%i].image", ParameterName::IndexVector{ imageMemoryBarrierIndex }), pImageMemoryBarriers[imageMemoryBarrierIndex].image);

            skip |= ValidateFlags("vkCmdPipelineBarrier", ParameterName("pImageMemoryBarriers[%i].subresourceRange.aspectMask", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pImageMemoryBarriers[imageMemoryBarrierIndex].subresourceRange.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceRange-aspectMask-parameter", "VUID-VkImageSubresourceRange-aspectMask-requiredbitmask");
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBeginQuery(
    VkCommandBuffer                             commandBuffer,
    VkQueryPool                                 queryPool,
    uint32_t                                    query,
    VkQueryControlFlags                         flags) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdBeginQuery", "queryPool", queryPool);
    skip |= ValidateFlags("vkCmdBeginQuery", "flags", "VkQueryControlFlagBits", AllVkQueryControlFlagBits, flags, kOptionalFlags, "VUID-vkCmdBeginQuery-flags-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdEndQuery(
    VkCommandBuffer                             commandBuffer,
    VkQueryPool                                 queryPool,
    uint32_t                                    query) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdEndQuery", "queryPool", queryPool);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdResetQueryPool(
    VkCommandBuffer                             commandBuffer,
    VkQueryPool                                 queryPool,
    uint32_t                                    firstQuery,
    uint32_t                                    queryCount) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdResetQueryPool", "queryPool", queryPool);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdWriteTimestamp(
    VkCommandBuffer                             commandBuffer,
    VkPipelineStageFlagBits                     pipelineStage,
    VkQueryPool                                 queryPool,
    uint32_t                                    query) const {
    bool skip = false;
    skip |= ValidateFlags("vkCmdWriteTimestamp", "pipelineStage", "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, pipelineStage, kRequiredSingleBit, "VUID-vkCmdWriteTimestamp-pipelineStage-parameter", "VUID-vkCmdWriteTimestamp-pipelineStage-parameter");
    skip |= ValidateRequiredHandle("vkCmdWriteTimestamp", "queryPool", queryPool);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyQueryPoolResults(
    VkCommandBuffer                             commandBuffer,
    VkQueryPool                                 queryPool,
    uint32_t                                    firstQuery,
    uint32_t                                    queryCount,
    VkBuffer                                    dstBuffer,
    VkDeviceSize                                dstOffset,
    VkDeviceSize                                stride,
    VkQueryResultFlags                          flags) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdCopyQueryPoolResults", "queryPool", queryPool);
    skip |= ValidateRequiredHandle("vkCmdCopyQueryPoolResults", "dstBuffer", dstBuffer);
    skip |= ValidateFlags("vkCmdCopyQueryPoolResults", "flags", "VkQueryResultFlagBits", AllVkQueryResultFlagBits, flags, kOptionalFlags, "VUID-vkCmdCopyQueryPoolResults-flags-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdPushConstants(
    VkCommandBuffer                             commandBuffer,
    VkPipelineLayout                            layout,
    VkShaderStageFlags                          stageFlags,
    uint32_t                                    offset,
    uint32_t                                    size,
    const void*                                 pValues) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdPushConstants", "layout", layout);
    skip |= ValidateFlags("vkCmdPushConstants", "stageFlags", "VkShaderStageFlagBits", AllVkShaderStageFlagBits, stageFlags, kRequiredFlags, "VUID-vkCmdPushConstants-stageFlags-parameter", "VUID-vkCmdPushConstants-stageFlags-requiredbitmask");
    skip |= ValidateArray("vkCmdPushConstants", "size", "pValues", size, &pValues, true, true, "VUID-vkCmdPushConstants-size-arraylength", "VUID-vkCmdPushConstants-pValues-parameter");
    if (!skip) skip |= manual_PreCallValidateCmdPushConstants(commandBuffer, layout, stageFlags, offset, size, pValues);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBeginRenderPass(
    VkCommandBuffer                             commandBuffer,
    const VkRenderPassBeginInfo*                pRenderPassBegin,
    VkSubpassContents                           contents) const {
    bool skip = false;
    skip |= ValidateStructType("vkCmdBeginRenderPass", "pRenderPassBegin", "VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO", pRenderPassBegin, VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO, true, "VUID-vkCmdBeginRenderPass-pRenderPassBegin-parameter", "VUID-VkRenderPassBeginInfo-sType-sType");
    if (pRenderPassBegin != nullptr)
    {
        constexpr std::array allowed_structs_VkRenderPassBeginInfo = { VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO, VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO, VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT, VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM };

        skip |= ValidateStructPnext("vkCmdBeginRenderPass", "pRenderPassBegin->pNext", "VkDeviceGroupRenderPassBeginInfo, VkRenderPassAttachmentBeginInfo, VkRenderPassSampleLocationsBeginInfoEXT, VkRenderPassTransformBeginInfoQCOM", pRenderPassBegin->pNext, allowed_structs_VkRenderPassBeginInfo.size(), allowed_structs_VkRenderPassBeginInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkRenderPassBeginInfo-pNext-pNext", "VUID-VkRenderPassBeginInfo-sType-unique", false, true);

        skip |= ValidateRequiredHandle("vkCmdBeginRenderPass", "pRenderPassBegin->renderPass", pRenderPassBegin->renderPass);

        skip |= ValidateRequiredHandle("vkCmdBeginRenderPass", "pRenderPassBegin->framebuffer", pRenderPassBegin->framebuffer);

        // No xml-driven validation

        // No xml-driven validation
    }
    skip |= ValidateRangedEnum("vkCmdBeginRenderPass", "contents", "VkSubpassContents", AllVkSubpassContentsEnums, contents, "VUID-vkCmdBeginRenderPass-contents-parameter");
    if (!skip) skip |= manual_PreCallValidateCmdBeginRenderPass(commandBuffer, pRenderPassBegin, contents);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdNextSubpass(
    VkCommandBuffer                             commandBuffer,
    VkSubpassContents                           contents) const {
    bool skip = false;
    skip |= ValidateRangedEnum("vkCmdNextSubpass", "contents", "VkSubpassContents", AllVkSubpassContentsEnums, contents, "VUID-vkCmdNextSubpass-contents-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdEndRenderPass(
    VkCommandBuffer                             commandBuffer) const {
    bool skip = false;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateCmdExecuteCommands(
    VkCommandBuffer                             commandBuffer,
    uint32_t                                    commandBufferCount,
    const VkCommandBuffer*                      pCommandBuffers) const {
    bool skip = false;
    skip |= ValidateHandleArray("vkCmdExecuteCommands", "commandBufferCount", "pCommandBuffers", commandBufferCount, pCommandBuffers, true, true, "VUID-vkCmdExecuteCommands-commandBufferCount-arraylength");
    return skip;
}



bool StatelessValidation::PreCallValidateBindBufferMemory2(
    VkDevice                                    device,
    uint32_t                                    bindInfoCount,
    const VkBindBufferMemoryInfo*               pBindInfos) const {
    bool skip = false;
    skip |= ValidateStructTypeArray("vkBindBufferMemory2", "bindInfoCount", "pBindInfos", "VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO", bindInfoCount, pBindInfos, VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO, true, true, "VUID-VkBindBufferMemoryInfo-sType-sType", "VUID-vkBindBufferMemory2-pBindInfos-parameter", "VUID-vkBindBufferMemory2-bindInfoCount-arraylength");
    if (pBindInfos != nullptr)
    {
        for (uint32_t bindInfoIndex = 0; bindInfoIndex < bindInfoCount; ++bindInfoIndex)
        {
            constexpr std::array allowed_structs_VkBindBufferMemoryInfo = { VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO };

            skip |= ValidateStructPnext("vkBindBufferMemory2", ParameterName("pBindInfos[%i].pNext", ParameterName::IndexVector{ bindInfoIndex }), "VkBindBufferMemoryDeviceGroupInfo", pBindInfos[bindInfoIndex].pNext, allowed_structs_VkBindBufferMemoryInfo.size(), allowed_structs_VkBindBufferMemoryInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkBindBufferMemoryInfo-pNext-pNext", "VUID-VkBindBufferMemoryInfo-sType-unique", false, true);

            skip |= ValidateRequiredHandle("vkBindBufferMemory2", ParameterName("pBindInfos[%i].buffer", ParameterName::IndexVector{ bindInfoIndex }), pBindInfos[bindInfoIndex].buffer);

            skip |= ValidateRequiredHandle("vkBindBufferMemory2", ParameterName("pBindInfos[%i].memory", ParameterName::IndexVector{ bindInfoIndex }), pBindInfos[bindInfoIndex].memory);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateBindImageMemory2(
    VkDevice                                    device,
    uint32_t                                    bindInfoCount,
    const VkBindImageMemoryInfo*                pBindInfos) const {
    bool skip = false;
    skip |= ValidateStructTypeArray("vkBindImageMemory2", "bindInfoCount", "pBindInfos", "VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO", bindInfoCount, pBindInfos, VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO, true, true, "VUID-VkBindImageMemoryInfo-sType-sType", "VUID-vkBindImageMemory2-pBindInfos-parameter", "VUID-vkBindImageMemory2-bindInfoCount-arraylength");
    if (pBindInfos != nullptr)
    {
        for (uint32_t bindInfoIndex = 0; bindInfoIndex < bindInfoCount; ++bindInfoIndex)
        {
            constexpr std::array allowed_structs_VkBindImageMemoryInfo = { VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO, VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR, VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO };

            skip |= ValidateStructPnext("vkBindImageMemory2", ParameterName("pBindInfos[%i].pNext", ParameterName::IndexVector{ bindInfoIndex }), "VkBindImageMemoryDeviceGroupInfo, VkBindImageMemorySwapchainInfoKHR, VkBindImagePlaneMemoryInfo", pBindInfos[bindInfoIndex].pNext, allowed_structs_VkBindImageMemoryInfo.size(), allowed_structs_VkBindImageMemoryInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkBindImageMemoryInfo-pNext-pNext", "VUID-VkBindImageMemoryInfo-sType-unique", false, true);

            skip |= ValidateRequiredHandle("vkBindImageMemory2", ParameterName("pBindInfos[%i].image", ParameterName::IndexVector{ bindInfoIndex }), pBindInfos[bindInfoIndex].image);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetDeviceGroupPeerMemoryFeatures(
    VkDevice                                    device,
    uint32_t                                    heapIndex,
    uint32_t                                    localDeviceIndex,
    uint32_t                                    remoteDeviceIndex,
    VkPeerMemoryFeatureFlags*                   pPeerMemoryFeatures) const {
    bool skip = false;
    skip |= ValidateRequiredPointer("vkGetDeviceGroupPeerMemoryFeatures", "pPeerMemoryFeatures", pPeerMemoryFeatures, "VUID-vkGetDeviceGroupPeerMemoryFeatures-pPeerMemoryFeatures-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetDeviceMask(
    VkCommandBuffer                             commandBuffer,
    uint32_t                                    deviceMask) const {
    bool skip = false;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateCmdDispatchBase(
    VkCommandBuffer                             commandBuffer,
    uint32_t                                    baseGroupX,
    uint32_t                                    baseGroupY,
    uint32_t                                    baseGroupZ,
    uint32_t                                    groupCountX,
    uint32_t                                    groupCountY,
    uint32_t                                    groupCountZ) const {
    bool skip = false;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateEnumeratePhysicalDeviceGroups(
    VkInstance                                  instance,
    uint32_t*                                   pPhysicalDeviceGroupCount,
    VkPhysicalDeviceGroupProperties*            pPhysicalDeviceGroupProperties) const {
    bool skip = false;
     if (CheckPromotedApiAgainstVulkanVersion(instance, "vkEnumeratePhysicalDeviceGroups", VK_API_VERSION_1_1)) return true;
    skip |= ValidateStructTypeArray("vkEnumeratePhysicalDeviceGroups", "pPhysicalDeviceGroupCount", "pPhysicalDeviceGroupProperties", "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES", pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES, true, false, false, "VUID-VkPhysicalDeviceGroupProperties-sType-sType", "VUID-vkEnumeratePhysicalDeviceGroups-pPhysicalDeviceGroupProperties-parameter", kVUIDUndefined);
    if (pPhysicalDeviceGroupProperties != nullptr)
    {
        for (uint32_t pPhysicalDeviceGroupIndex = 0; pPhysicalDeviceGroupIndex < *pPhysicalDeviceGroupCount; ++pPhysicalDeviceGroupIndex)
        {
            skip |= ValidateStructPnext("vkEnumeratePhysicalDeviceGroups", ParameterName("pPhysicalDeviceGroupProperties[%i].pNext", ParameterName::IndexVector{ pPhysicalDeviceGroupIndex }), nullptr, pPhysicalDeviceGroupProperties[pPhysicalDeviceGroupIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkPhysicalDeviceGroupProperties-pNext-pNext", kVUIDUndefined, false, false);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetImageMemoryRequirements2(
    VkDevice                                    device,
    const VkImageMemoryRequirementsInfo2*       pInfo,
    VkMemoryRequirements2*                      pMemoryRequirements) const {
    bool skip = false;
    skip |= ValidateStructType("vkGetImageMemoryRequirements2", "pInfo", "VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2", pInfo, VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2, true, "VUID-vkGetImageMemoryRequirements2-pInfo-parameter", "VUID-VkImageMemoryRequirementsInfo2-sType-sType");
    if (pInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkImageMemoryRequirementsInfo2 = { VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO };

        skip |= ValidateStructPnext("vkGetImageMemoryRequirements2", "pInfo->pNext", "VkImagePlaneMemoryRequirementsInfo", pInfo->pNext, allowed_structs_VkImageMemoryRequirementsInfo2.size(), allowed_structs_VkImageMemoryRequirementsInfo2.data(), GeneratedVulkanHeaderVersion, "VUID-VkImageMemoryRequirementsInfo2-pNext-pNext", "VUID-VkImageMemoryRequirementsInfo2-sType-unique", false, true);

        skip |= ValidateRequiredHandle("vkGetImageMemoryRequirements2", "pInfo->image", pInfo->image);
    }
    skip |= ValidateStructType("vkGetImageMemoryRequirements2", "pMemoryRequirements", "VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2", pMemoryRequirements, VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2, true, "VUID-vkGetImageMemoryRequirements2-pMemoryRequirements-parameter", "VUID-VkMemoryRequirements2-sType-sType");
    if (pMemoryRequirements != nullptr)
    {
        constexpr std::array allowed_structs_VkMemoryRequirements2 = { VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS };

        skip |= ValidateStructPnext("vkGetImageMemoryRequirements2", "pMemoryRequirements->pNext", "VkMemoryDedicatedRequirements", pMemoryRequirements->pNext, allowed_structs_VkMemoryRequirements2.size(), allowed_structs_VkMemoryRequirements2.data(), GeneratedVulkanHeaderVersion, "VUID-VkMemoryRequirements2-pNext-pNext", "VUID-VkMemoryRequirements2-sType-unique", false, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetBufferMemoryRequirements2(
    VkDevice                                    device,
    const VkBufferMemoryRequirementsInfo2*      pInfo,
    VkMemoryRequirements2*                      pMemoryRequirements) const {
    bool skip = false;
    skip |= ValidateStructType("vkGetBufferMemoryRequirements2", "pInfo", "VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2", pInfo, VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2, true, "VUID-vkGetBufferMemoryRequirements2-pInfo-parameter", "VUID-VkBufferMemoryRequirementsInfo2-sType-sType");
    if (pInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkGetBufferMemoryRequirements2", "pInfo->pNext", nullptr, pInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkBufferMemoryRequirementsInfo2-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle("vkGetBufferMemoryRequirements2", "pInfo->buffer", pInfo->buffer);
    }
    skip |= ValidateStructType("vkGetBufferMemoryRequirements2", "pMemoryRequirements", "VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2", pMemoryRequirements, VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2, true, "VUID-vkGetBufferMemoryRequirements2-pMemoryRequirements-parameter", "VUID-VkMemoryRequirements2-sType-sType");
    if (pMemoryRequirements != nullptr)
    {
        constexpr std::array allowed_structs_VkMemoryRequirements2 = { VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS };

        skip |= ValidateStructPnext("vkGetBufferMemoryRequirements2", "pMemoryRequirements->pNext", "VkMemoryDedicatedRequirements", pMemoryRequirements->pNext, allowed_structs_VkMemoryRequirements2.size(), allowed_structs_VkMemoryRequirements2.data(), GeneratedVulkanHeaderVersion, "VUID-VkMemoryRequirements2-pNext-pNext", "VUID-VkMemoryRequirements2-sType-unique", false, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetImageSparseMemoryRequirements2(
    VkDevice                                    device,
    const VkImageSparseMemoryRequirementsInfo2* pInfo,
    uint32_t*                                   pSparseMemoryRequirementCount,
    VkSparseImageMemoryRequirements2*           pSparseMemoryRequirements) const {
    bool skip = false;
    skip |= ValidateStructType("vkGetImageSparseMemoryRequirements2", "pInfo", "VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2", pInfo, VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2, true, "VUID-vkGetImageSparseMemoryRequirements2-pInfo-parameter", "VUID-VkImageSparseMemoryRequirementsInfo2-sType-sType");
    if (pInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkGetImageSparseMemoryRequirements2", "pInfo->pNext", nullptr, pInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkImageSparseMemoryRequirementsInfo2-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle("vkGetImageSparseMemoryRequirements2", "pInfo->image", pInfo->image);
    }
    skip |= ValidateStructTypeArray("vkGetImageSparseMemoryRequirements2", "pSparseMemoryRequirementCount", "pSparseMemoryRequirements", "VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2", pSparseMemoryRequirementCount, pSparseMemoryRequirements, VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2, true, false, false, "VUID-VkSparseImageMemoryRequirements2-sType-sType", "VUID-vkGetImageSparseMemoryRequirements2-pSparseMemoryRequirements-parameter", kVUIDUndefined);
    if (pSparseMemoryRequirements != nullptr)
    {
        for (uint32_t pSparseMemoryRequirementIndex = 0; pSparseMemoryRequirementIndex < *pSparseMemoryRequirementCount; ++pSparseMemoryRequirementIndex)
        {
            skip |= ValidateStructPnext("vkGetImageSparseMemoryRequirements2", ParameterName("pSparseMemoryRequirements[%i].pNext", ParameterName::IndexVector{ pSparseMemoryRequirementIndex }), nullptr, pSparseMemoryRequirements[pSparseMemoryRequirementIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkSparseImageMemoryRequirements2-pNext-pNext", kVUIDUndefined, false, false);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceFeatures2(
    VkPhysicalDevice                            physicalDevice,
    VkPhysicalDeviceFeatures2*                  pFeatures) const {
    bool skip = false;
     if (CheckPromotedApiAgainstVulkanVersion(physicalDevice, "vkGetPhysicalDeviceFeatures2", VK_API_VERSION_1_1)) return true;
    skip |= ValidateStructType("vkGetPhysicalDeviceFeatures2", "pFeatures", "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2", pFeatures, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2, true, "VUID-vkGetPhysicalDeviceFeatures2-pFeatures-parameter", "VUID-VkPhysicalDeviceFeatures2-sType-sType");
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceProperties2(
    VkPhysicalDevice                            physicalDevice,
    VkPhysicalDeviceProperties2*                pProperties) const {
    bool skip = false;
     if (CheckPromotedApiAgainstVulkanVersion(physicalDevice, "vkGetPhysicalDeviceProperties2", VK_API_VERSION_1_1)) return true;
    skip |= ValidateStructType("vkGetPhysicalDeviceProperties2", "pProperties", "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2", pProperties, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2, true, "VUID-vkGetPhysicalDeviceProperties2-pProperties-parameter", "VUID-VkPhysicalDeviceProperties2-sType-sType");
    if (pProperties != nullptr)
    {
        constexpr std::array allowed_structs_VkPhysicalDeviceProperties2 = { VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_PROPERTIES_HUAWEI, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_DENSITY_MAP_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRM_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_PROPERTIES_QCOM, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_PROPERTIES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_PROPERTIES_QCOM, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_PROPERTIES_ARM, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES };

        skip |= ValidateStructPnext("vkGetPhysicalDeviceProperties2", "pProperties->pNext", "VkPhysicalDeviceAccelerationStructurePropertiesKHR, VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, VkPhysicalDeviceClusterCullingShaderPropertiesHUAWEI, VkPhysicalDeviceConservativeRasterizationPropertiesEXT, VkPhysicalDeviceCooperativeMatrixPropertiesNV, VkPhysicalDeviceCopyMemoryIndirectPropertiesNV, VkPhysicalDeviceCustomBorderColorPropertiesEXT, VkPhysicalDeviceDepthStencilResolveProperties, VkPhysicalDeviceDescriptorBufferDensityMapPropertiesEXT, VkPhysicalDeviceDescriptorBufferPropertiesEXT, VkPhysicalDeviceDescriptorIndexingProperties, VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV, VkPhysicalDeviceDiscardRectanglePropertiesEXT, VkPhysicalDeviceDriverProperties, VkPhysicalDeviceDrmPropertiesEXT, VkPhysicalDeviceExtendedDynamicState3PropertiesEXT, VkPhysicalDeviceExternalMemoryHostPropertiesEXT, VkPhysicalDeviceFloatControlsProperties, VkPhysicalDeviceFragmentDensityMap2PropertiesEXT, VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM, VkPhysicalDeviceFragmentDensityMapPropertiesEXT, VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR, VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV, VkPhysicalDeviceFragmentShadingRatePropertiesKHR, VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT, VkPhysicalDeviceIDProperties, VkPhysicalDeviceImageProcessingPropertiesQCOM, VkPhysicalDeviceInlineUniformBlockProperties, VkPhysicalDeviceLineRasterizationPropertiesEXT, VkPhysicalDeviceMaintenance3Properties, VkPhysicalDeviceMaintenance4Properties, VkPhysicalDeviceMemoryDecompressionPropertiesNV, VkPhysicalDeviceMeshShaderPropertiesEXT, VkPhysicalDeviceMeshShaderPropertiesNV, VkPhysicalDeviceMultiDrawPropertiesEXT, VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX, VkPhysicalDeviceMultiviewProperties, VkPhysicalDeviceOpacityMicromapPropertiesEXT, VkPhysicalDeviceOpticalFlowPropertiesNV, VkPhysicalDevicePCIBusInfoPropertiesEXT, VkPhysicalDevicePerformanceQueryPropertiesKHR, VkPhysicalDevicePipelineRobustnessPropertiesEXT, VkPhysicalDevicePointClippingProperties, VkPhysicalDevicePortabilitySubsetPropertiesKHR, VkPhysicalDeviceProtectedMemoryProperties, VkPhysicalDeviceProvokingVertexPropertiesEXT, VkPhysicalDevicePushDescriptorPropertiesKHR, VkPhysicalDeviceRayTracingInvocationReorderPropertiesNV, VkPhysicalDeviceRayTracingPipelinePropertiesKHR, VkPhysicalDeviceRayTracingPropertiesNV, VkPhysicalDeviceRobustness2PropertiesEXT, VkPhysicalDeviceSampleLocationsPropertiesEXT, VkPhysicalDeviceSamplerFilterMinmaxProperties, VkPhysicalDeviceShaderCoreBuiltinsPropertiesARM, VkPhysicalDeviceShaderCoreProperties2AMD, VkPhysicalDeviceShaderCorePropertiesAMD, VkPhysicalDeviceShaderIntegerDotProductProperties, VkPhysicalDeviceShaderModuleIdentifierPropertiesEXT, VkPhysicalDeviceShaderSMBuiltinsPropertiesNV, VkPhysicalDeviceShadingRateImagePropertiesNV, VkPhysicalDeviceSubgroupProperties, VkPhysicalDeviceSubgroupSizeControlProperties, VkPhysicalDeviceSubpassShadingPropertiesHUAWEI, VkPhysicalDeviceTexelBufferAlignmentProperties, VkPhysicalDeviceTimelineSemaphoreProperties, VkPhysicalDeviceTransformFeedbackPropertiesEXT, VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT, VkPhysicalDeviceVulkan11Properties, VkPhysicalDeviceVulkan12Properties, VkPhysicalDeviceVulkan13Properties", pProperties->pNext, allowed_structs_VkPhysicalDeviceProperties2.size(), allowed_structs_VkPhysicalDeviceProperties2.data(), GeneratedVulkanHeaderVersion, "VUID-VkPhysicalDeviceProperties2-pNext-pNext", "VUID-VkPhysicalDeviceProperties2-sType-unique", true, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceFormatProperties2(
    VkPhysicalDevice                            physicalDevice,
    VkFormat                                    format,
    VkFormatProperties2*                        pFormatProperties) const {
    bool skip = false;
     if (CheckPromotedApiAgainstVulkanVersion(physicalDevice, "vkGetPhysicalDeviceFormatProperties2", VK_API_VERSION_1_1)) return true;
    skip |= ValidateRangedEnum("vkGetPhysicalDeviceFormatProperties2", "format", "VkFormat", AllVkFormatEnums, format, "VUID-vkGetPhysicalDeviceFormatProperties2-format-parameter");
    skip |= ValidateStructType("vkGetPhysicalDeviceFormatProperties2", "pFormatProperties", "VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2", pFormatProperties, VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2, true, "VUID-vkGetPhysicalDeviceFormatProperties2-pFormatProperties-parameter", "VUID-VkFormatProperties2-sType-sType");
    if (pFormatProperties != nullptr)
    {
        constexpr std::array allowed_structs_VkFormatProperties2 = { VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT, VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT, VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3, VK_STRUCTURE_TYPE_SUBPASS_RESOLVE_PERFORMANCE_QUERY_EXT };

        skip |= ValidateStructPnext("vkGetPhysicalDeviceFormatProperties2", "pFormatProperties->pNext", "VkDrmFormatModifierPropertiesList2EXT, VkDrmFormatModifierPropertiesListEXT, VkFormatProperties3, VkSubpassResolvePerformanceQueryEXT", pFormatProperties->pNext, allowed_structs_VkFormatProperties2.size(), allowed_structs_VkFormatProperties2.data(), GeneratedVulkanHeaderVersion, "VUID-VkFormatProperties2-pNext-pNext", "VUID-VkFormatProperties2-sType-unique", true, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceImageFormatProperties2(
    VkPhysicalDevice                            physicalDevice,
    const VkPhysicalDeviceImageFormatInfo2*     pImageFormatInfo,
    VkImageFormatProperties2*                   pImageFormatProperties) const {
    bool skip = false;
     if (CheckPromotedApiAgainstVulkanVersion(physicalDevice, "vkGetPhysicalDeviceImageFormatProperties2", VK_API_VERSION_1_1)) return true;
    skip |= ValidateStructType("vkGetPhysicalDeviceImageFormatProperties2", "pImageFormatInfo", "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2", pImageFormatInfo, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2, true, "VUID-vkGetPhysicalDeviceImageFormatProperties2-pImageFormatInfo-parameter", "VUID-VkPhysicalDeviceImageFormatInfo2-sType-sType");
    if (pImageFormatInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkPhysicalDeviceImageFormatInfo2 = { VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT, VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO, VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO, VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_INFO_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT, VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR };

        skip |= ValidateStructPnext("vkGetPhysicalDeviceImageFormatProperties2", "pImageFormatInfo->pNext", "VkImageCompressionControlEXT, VkImageFormatListCreateInfo, VkImageStencilUsageCreateInfo, VkOpticalFlowImageFormatInfoNV, VkPhysicalDeviceExternalImageFormatInfo, VkPhysicalDeviceImageDrmFormatModifierInfoEXT, VkPhysicalDeviceImageViewImageFormatInfoEXT, VkVideoProfileListInfoKHR", pImageFormatInfo->pNext, allowed_structs_VkPhysicalDeviceImageFormatInfo2.size(), allowed_structs_VkPhysicalDeviceImageFormatInfo2.data(), GeneratedVulkanHeaderVersion, "VUID-VkPhysicalDeviceImageFormatInfo2-pNext-pNext", "VUID-VkPhysicalDeviceImageFormatInfo2-sType-unique", true, true);

        skip |= ValidateRangedEnum("vkGetPhysicalDeviceImageFormatProperties2", "pImageFormatInfo->format", "VkFormat", AllVkFormatEnums, pImageFormatInfo->format, "VUID-VkPhysicalDeviceImageFormatInfo2-format-parameter");

        skip |= ValidateRangedEnum("vkGetPhysicalDeviceImageFormatProperties2", "pImageFormatInfo->type", "VkImageType", AllVkImageTypeEnums, pImageFormatInfo->type, "VUID-VkPhysicalDeviceImageFormatInfo2-type-parameter");

        skip |= ValidateRangedEnum("vkGetPhysicalDeviceImageFormatProperties2", "pImageFormatInfo->tiling", "VkImageTiling", AllVkImageTilingEnums, pImageFormatInfo->tiling, "VUID-VkPhysicalDeviceImageFormatInfo2-tiling-parameter");

        skip |= ValidateFlags("vkGetPhysicalDeviceImageFormatProperties2", "pImageFormatInfo->usage", "VkImageUsageFlagBits", AllVkImageUsageFlagBits, pImageFormatInfo->usage, kRequiredFlags, "VUID-VkPhysicalDeviceImageFormatInfo2-usage-parameter", "VUID-VkPhysicalDeviceImageFormatInfo2-usage-requiredbitmask");

        skip |= ValidateFlags("vkGetPhysicalDeviceImageFormatProperties2", "pImageFormatInfo->flags", "VkImageCreateFlagBits", AllVkImageCreateFlagBits, pImageFormatInfo->flags, kOptionalFlags, "VUID-VkPhysicalDeviceImageFormatInfo2-flags-parameter");
    }
    skip |= ValidateStructType("vkGetPhysicalDeviceImageFormatProperties2", "pImageFormatProperties", "VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2", pImageFormatProperties, VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2, true, "VUID-vkGetPhysicalDeviceImageFormatProperties2-pImageFormatProperties-parameter", "VUID-VkImageFormatProperties2-sType-sType");
    if (pImageFormatProperties != nullptr)
    {
        constexpr std::array allowed_structs_VkImageFormatProperties2 = { VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID, VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES, VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT, VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT, VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES, VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD };

        skip |= ValidateStructPnext("vkGetPhysicalDeviceImageFormatProperties2", "pImageFormatProperties->pNext", "VkAndroidHardwareBufferUsageANDROID, VkExternalImageFormatProperties, VkFilterCubicImageViewImageFormatPropertiesEXT, VkImageCompressionPropertiesEXT, VkSamplerYcbcrConversionImageFormatProperties, VkTextureLODGatherFormatPropertiesAMD", pImageFormatProperties->pNext, allowed_structs_VkImageFormatProperties2.size(), allowed_structs_VkImageFormatProperties2.data(), GeneratedVulkanHeaderVersion, "VUID-VkImageFormatProperties2-pNext-pNext", "VUID-VkImageFormatProperties2-sType-unique", true, false);
    }
    if (!skip) skip |= manual_PreCallValidateGetPhysicalDeviceImageFormatProperties2(physicalDevice, pImageFormatInfo, pImageFormatProperties);
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceQueueFamilyProperties2(
    VkPhysicalDevice                            physicalDevice,
    uint32_t*                                   pQueueFamilyPropertyCount,
    VkQueueFamilyProperties2*                   pQueueFamilyProperties) const {
    bool skip = false;
     if (CheckPromotedApiAgainstVulkanVersion(physicalDevice, "vkGetPhysicalDeviceQueueFamilyProperties2", VK_API_VERSION_1_1)) return true;
    skip |= ValidateStructTypeArray("vkGetPhysicalDeviceQueueFamilyProperties2", "pQueueFamilyPropertyCount", "pQueueFamilyProperties", "VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2", pQueueFamilyPropertyCount, pQueueFamilyProperties, VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2, true, false, false, "VUID-VkQueueFamilyProperties2-sType-sType", "VUID-vkGetPhysicalDeviceQueueFamilyProperties2-pQueueFamilyProperties-parameter", kVUIDUndefined);
    if (pQueueFamilyProperties != nullptr)
    {
        for (uint32_t pQueueFamilyPropertyIndex = 0; pQueueFamilyPropertyIndex < *pQueueFamilyPropertyCount; ++pQueueFamilyPropertyIndex)
        {
            constexpr std::array allowed_structs_VkQueueFamilyProperties2 = { VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV, VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV, VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_KHR, VK_STRUCTURE_TYPE_QUEUE_FAMILY_QUERY_RESULT_STATUS_PROPERTIES_KHR, VK_STRUCTURE_TYPE_QUEUE_FAMILY_VIDEO_PROPERTIES_KHR };

            skip |= ValidateStructPnext("vkGetPhysicalDeviceQueueFamilyProperties2", ParameterName("pQueueFamilyProperties[%i].pNext", ParameterName::IndexVector{ pQueueFamilyPropertyIndex }), "VkQueueFamilyCheckpointProperties2NV, VkQueueFamilyCheckpointPropertiesNV, VkQueueFamilyGlobalPriorityPropertiesKHR, VkQueueFamilyQueryResultStatusPropertiesKHR, VkQueueFamilyVideoPropertiesKHR", pQueueFamilyProperties[pQueueFamilyPropertyIndex].pNext, allowed_structs_VkQueueFamilyProperties2.size(), allowed_structs_VkQueueFamilyProperties2.data(), GeneratedVulkanHeaderVersion, "VUID-VkQueueFamilyProperties2-pNext-pNext", "VUID-VkQueueFamilyProperties2-sType-unique", true, false);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceMemoryProperties2(
    VkPhysicalDevice                            physicalDevice,
    VkPhysicalDeviceMemoryProperties2*          pMemoryProperties) const {
    bool skip = false;
     if (CheckPromotedApiAgainstVulkanVersion(physicalDevice, "vkGetPhysicalDeviceMemoryProperties2", VK_API_VERSION_1_1)) return true;
    skip |= ValidateStructType("vkGetPhysicalDeviceMemoryProperties2", "pMemoryProperties", "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2", pMemoryProperties, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2, true, "VUID-vkGetPhysicalDeviceMemoryProperties2-pMemoryProperties-parameter", "VUID-VkPhysicalDeviceMemoryProperties2-sType-sType");
    if (pMemoryProperties != nullptr)
    {
        constexpr std::array allowed_structs_VkPhysicalDeviceMemoryProperties2 = { VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT };

        skip |= ValidateStructPnext("vkGetPhysicalDeviceMemoryProperties2", "pMemoryProperties->pNext", "VkPhysicalDeviceMemoryBudgetPropertiesEXT", pMemoryProperties->pNext, allowed_structs_VkPhysicalDeviceMemoryProperties2.size(), allowed_structs_VkPhysicalDeviceMemoryProperties2.data(), GeneratedVulkanHeaderVersion, "VUID-VkPhysicalDeviceMemoryProperties2-pNext-pNext", "VUID-VkPhysicalDeviceMemoryProperties2-sType-unique", true, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceSparseImageFormatProperties2(
    VkPhysicalDevice                            physicalDevice,
    const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo,
    uint32_t*                                   pPropertyCount,
    VkSparseImageFormatProperties2*             pProperties) const {
    bool skip = false;
     if (CheckPromotedApiAgainstVulkanVersion(physicalDevice, "vkGetPhysicalDeviceSparseImageFormatProperties2", VK_API_VERSION_1_1)) return true;
    skip |= ValidateStructType("vkGetPhysicalDeviceSparseImageFormatProperties2", "pFormatInfo", "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2", pFormatInfo, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2, true, "VUID-vkGetPhysicalDeviceSparseImageFormatProperties2-pFormatInfo-parameter", "VUID-VkPhysicalDeviceSparseImageFormatInfo2-sType-sType");
    if (pFormatInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkGetPhysicalDeviceSparseImageFormatProperties2", "pFormatInfo->pNext", nullptr, pFormatInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkPhysicalDeviceSparseImageFormatInfo2-pNext-pNext", kVUIDUndefined, true, true);

        skip |= ValidateRangedEnum("vkGetPhysicalDeviceSparseImageFormatProperties2", "pFormatInfo->format", "VkFormat", AllVkFormatEnums, pFormatInfo->format, "VUID-VkPhysicalDeviceSparseImageFormatInfo2-format-parameter");

        skip |= ValidateRangedEnum("vkGetPhysicalDeviceSparseImageFormatProperties2", "pFormatInfo->type", "VkImageType", AllVkImageTypeEnums, pFormatInfo->type, "VUID-VkPhysicalDeviceSparseImageFormatInfo2-type-parameter");

        skip |= ValidateFlags("vkGetPhysicalDeviceSparseImageFormatProperties2", "pFormatInfo->samples", "VkSampleCountFlagBits", AllVkSampleCountFlagBits, pFormatInfo->samples, kRequiredSingleBit, "VUID-VkPhysicalDeviceSparseImageFormatInfo2-samples-parameter", "VUID-VkPhysicalDeviceSparseImageFormatInfo2-samples-parameter");

        skip |= ValidateFlags("vkGetPhysicalDeviceSparseImageFormatProperties2", "pFormatInfo->usage", "VkImageUsageFlagBits", AllVkImageUsageFlagBits, pFormatInfo->usage, kRequiredFlags, "VUID-VkPhysicalDeviceSparseImageFormatInfo2-usage-parameter", "VUID-VkPhysicalDeviceSparseImageFormatInfo2-usage-requiredbitmask");

        skip |= ValidateRangedEnum("vkGetPhysicalDeviceSparseImageFormatProperties2", "pFormatInfo->tiling", "VkImageTiling", AllVkImageTilingEnums, pFormatInfo->tiling, "VUID-VkPhysicalDeviceSparseImageFormatInfo2-tiling-parameter");
    }
    skip |= ValidateStructTypeArray("vkGetPhysicalDeviceSparseImageFormatProperties2", "pPropertyCount", "pProperties", "VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2", pPropertyCount, pProperties, VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2, true, false, false, "VUID-VkSparseImageFormatProperties2-sType-sType", "VUID-vkGetPhysicalDeviceSparseImageFormatProperties2-pProperties-parameter", kVUIDUndefined);
    if (pProperties != nullptr)
    {
        for (uint32_t pPropertyIndex = 0; pPropertyIndex < *pPropertyCount; ++pPropertyIndex)
        {
            skip |= ValidateStructPnext("vkGetPhysicalDeviceSparseImageFormatProperties2", ParameterName("pProperties[%i].pNext", ParameterName::IndexVector{ pPropertyIndex }), nullptr, pProperties[pPropertyIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkSparseImageFormatProperties2-pNext-pNext", kVUIDUndefined, true, false);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateTrimCommandPool(
    VkDevice                                    device,
    VkCommandPool                               commandPool,
    VkCommandPoolTrimFlags                      flags) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkTrimCommandPool", "commandPool", commandPool);
    skip |= ValidateReservedFlags("vkTrimCommandPool", "flags", flags, "VUID-vkTrimCommandPool-flags-zerobitmask");
    return skip;
}

bool StatelessValidation::PreCallValidateGetDeviceQueue2(
    VkDevice                                    device,
    const VkDeviceQueueInfo2*                   pQueueInfo,
    VkQueue*                                    pQueue) const {
    bool skip = false;
    skip |= ValidateStructType("vkGetDeviceQueue2", "pQueueInfo", "VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2", pQueueInfo, VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2, true, "VUID-vkGetDeviceQueue2-pQueueInfo-parameter", "VUID-VkDeviceQueueInfo2-sType-sType");
    if (pQueueInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkGetDeviceQueue2", "pQueueInfo->pNext", nullptr, pQueueInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkDeviceQueueInfo2-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateFlags("vkGetDeviceQueue2", "pQueueInfo->flags", "VkDeviceQueueCreateFlagBits", AllVkDeviceQueueCreateFlagBits, pQueueInfo->flags, kOptionalFlags, "VUID-VkDeviceQueueInfo2-flags-parameter");
    }
    skip |= ValidateRequiredPointer("vkGetDeviceQueue2", "pQueue", pQueue, "VUID-vkGetDeviceQueue2-pQueue-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCreateSamplerYcbcrConversion(
    VkDevice                                    device,
    const VkSamplerYcbcrConversionCreateInfo*   pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkSamplerYcbcrConversion*                   pYcbcrConversion) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateSamplerYcbcrConversion", "pCreateInfo", "VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO, true, "VUID-vkCreateSamplerYcbcrConversion-pCreateInfo-parameter", "VUID-VkSamplerYcbcrConversionCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkSamplerYcbcrConversionCreateInfo = { VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID };

        skip |= ValidateStructPnext("vkCreateSamplerYcbcrConversion", "pCreateInfo->pNext", "VkExternalFormatANDROID", pCreateInfo->pNext, allowed_structs_VkSamplerYcbcrConversionCreateInfo.size(), allowed_structs_VkSamplerYcbcrConversionCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkSamplerYcbcrConversionCreateInfo-pNext-pNext", "VUID-VkSamplerYcbcrConversionCreateInfo-sType-unique", false, true);

        skip |= ValidateRangedEnum("vkCreateSamplerYcbcrConversion", "pCreateInfo->format", "VkFormat", AllVkFormatEnums, pCreateInfo->format, "VUID-VkSamplerYcbcrConversionCreateInfo-format-parameter");

        skip |= ValidateRangedEnum("vkCreateSamplerYcbcrConversion", "pCreateInfo->ycbcrModel", "VkSamplerYcbcrModelConversion", AllVkSamplerYcbcrModelConversionEnums, pCreateInfo->ycbcrModel, "VUID-VkSamplerYcbcrConversionCreateInfo-ycbcrModel-parameter");

        skip |= ValidateRangedEnum("vkCreateSamplerYcbcrConversion", "pCreateInfo->ycbcrRange", "VkSamplerYcbcrRange", AllVkSamplerYcbcrRangeEnums, pCreateInfo->ycbcrRange, "VUID-VkSamplerYcbcrConversionCreateInfo-ycbcrRange-parameter");

        skip |= ValidateRangedEnum("vkCreateSamplerYcbcrConversion", "pCreateInfo->components.r", "VkComponentSwizzle", AllVkComponentSwizzleEnums, pCreateInfo->components.r, "VUID-VkComponentMapping-r-parameter");

        skip |= ValidateRangedEnum("vkCreateSamplerYcbcrConversion", "pCreateInfo->components.g", "VkComponentSwizzle", AllVkComponentSwizzleEnums, pCreateInfo->components.g, "VUID-VkComponentMapping-g-parameter");

        skip |= ValidateRangedEnum("vkCreateSamplerYcbcrConversion", "pCreateInfo->components.b", "VkComponentSwizzle", AllVkComponentSwizzleEnums, pCreateInfo->components.b, "VUID-VkComponentMapping-b-parameter");

        skip |= ValidateRangedEnum("vkCreateSamplerYcbcrConversion", "pCreateInfo->components.a", "VkComponentSwizzle", AllVkComponentSwizzleEnums, pCreateInfo->components.a, "VUID-VkComponentMapping-a-parameter");

        skip |= ValidateRangedEnum("vkCreateSamplerYcbcrConversion", "pCreateInfo->xChromaOffset", "VkChromaLocation", AllVkChromaLocationEnums, pCreateInfo->xChromaOffset, "VUID-VkSamplerYcbcrConversionCreateInfo-xChromaOffset-parameter");

        skip |= ValidateRangedEnum("vkCreateSamplerYcbcrConversion", "pCreateInfo->yChromaOffset", "VkChromaLocation", AllVkChromaLocationEnums, pCreateInfo->yChromaOffset, "VUID-VkSamplerYcbcrConversionCreateInfo-yChromaOffset-parameter");

        skip |= ValidateRangedEnum("vkCreateSamplerYcbcrConversion", "pCreateInfo->chromaFilter", "VkFilter", AllVkFilterEnums, pCreateInfo->chromaFilter, "VUID-VkSamplerYcbcrConversionCreateInfo-chromaFilter-parameter");

        skip |= ValidateBool32("vkCreateSamplerYcbcrConversion", "pCreateInfo->forceExplicitReconstruction", pCreateInfo->forceExplicitReconstruction);
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateSamplerYcbcrConversion", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateSamplerYcbcrConversion", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateSamplerYcbcrConversion", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateSamplerYcbcrConversion", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateSamplerYcbcrConversion", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateSamplerYcbcrConversion", "pYcbcrConversion", pYcbcrConversion, "VUID-vkCreateSamplerYcbcrConversion-pYcbcrConversion-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateSamplerYcbcrConversion(device, pCreateInfo, pAllocator, pYcbcrConversion);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroySamplerYcbcrConversion(
    VkDevice                                    device,
    VkSamplerYcbcrConversion                    ycbcrConversion,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroySamplerYcbcrConversion", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroySamplerYcbcrConversion", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroySamplerYcbcrConversion", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroySamplerYcbcrConversion", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroySamplerYcbcrConversion", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateDescriptorUpdateTemplate(
    VkDevice                                    device,
    const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkDescriptorUpdateTemplate*                 pDescriptorUpdateTemplate) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateDescriptorUpdateTemplate", "pCreateInfo", "VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO, true, "VUID-vkCreateDescriptorUpdateTemplate-pCreateInfo-parameter", "VUID-VkDescriptorUpdateTemplateCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCreateDescriptorUpdateTemplate", "pCreateInfo->pNext", nullptr, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkDescriptorUpdateTemplateCreateInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateReservedFlags("vkCreateDescriptorUpdateTemplate", "pCreateInfo->flags", pCreateInfo->flags, "VUID-VkDescriptorUpdateTemplateCreateInfo-flags-zerobitmask");

        skip |= ValidateArray("vkCreateDescriptorUpdateTemplate", "pCreateInfo->descriptorUpdateEntryCount", "pCreateInfo->pDescriptorUpdateEntries", pCreateInfo->descriptorUpdateEntryCount, &pCreateInfo->pDescriptorUpdateEntries, true, true, "VUID-VkDescriptorUpdateTemplateCreateInfo-descriptorUpdateEntryCount-arraylength", "VUID-VkDescriptorUpdateTemplateCreateInfo-pDescriptorUpdateEntries-parameter");

        if (pCreateInfo->pDescriptorUpdateEntries != nullptr)
        {
            for (uint32_t descriptorUpdateEntryIndex = 0; descriptorUpdateEntryIndex < pCreateInfo->descriptorUpdateEntryCount; ++descriptorUpdateEntryIndex)
            {
                skip |= ValidateRangedEnum("vkCreateDescriptorUpdateTemplate", ParameterName("pCreateInfo->pDescriptorUpdateEntries[%i].descriptorType", ParameterName::IndexVector{ descriptorUpdateEntryIndex }), "VkDescriptorType", AllVkDescriptorTypeEnums, pCreateInfo->pDescriptorUpdateEntries[descriptorUpdateEntryIndex].descriptorType, "VUID-VkDescriptorUpdateTemplateEntry-descriptorType-parameter");
            }
        }

        skip |= ValidateRangedEnum("vkCreateDescriptorUpdateTemplate", "pCreateInfo->templateType", "VkDescriptorUpdateTemplateType", AllVkDescriptorUpdateTemplateTypeEnums, pCreateInfo->templateType, "VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-parameter");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateDescriptorUpdateTemplate", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateDescriptorUpdateTemplate", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateDescriptorUpdateTemplate", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateDescriptorUpdateTemplate", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateDescriptorUpdateTemplate", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateDescriptorUpdateTemplate", "pDescriptorUpdateTemplate", pDescriptorUpdateTemplate, "VUID-vkCreateDescriptorUpdateTemplate-pDescriptorUpdateTemplate-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyDescriptorUpdateTemplate(
    VkDevice                                    device,
    VkDescriptorUpdateTemplate                  descriptorUpdateTemplate,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyDescriptorUpdateTemplate", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyDescriptorUpdateTemplate", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyDescriptorUpdateTemplate", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyDescriptorUpdateTemplate", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyDescriptorUpdateTemplate", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateUpdateDescriptorSetWithTemplate(
    VkDevice                                    device,
    VkDescriptorSet                             descriptorSet,
    VkDescriptorUpdateTemplate                  descriptorUpdateTemplate,
    const void*                                 pData) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkUpdateDescriptorSetWithTemplate", "descriptorSet", descriptorSet);
    skip |= ValidateRequiredHandle("vkUpdateDescriptorSetWithTemplate", "descriptorUpdateTemplate", descriptorUpdateTemplate);
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceExternalBufferProperties(
    VkPhysicalDevice                            physicalDevice,
    const VkPhysicalDeviceExternalBufferInfo*   pExternalBufferInfo,
    VkExternalBufferProperties*                 pExternalBufferProperties) const {
    bool skip = false;
     if (CheckPromotedApiAgainstVulkanVersion(physicalDevice, "vkGetPhysicalDeviceExternalBufferProperties", VK_API_VERSION_1_1)) return true;
    skip |= ValidateStructType("vkGetPhysicalDeviceExternalBufferProperties", "pExternalBufferInfo", "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO", pExternalBufferInfo, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO, true, "VUID-vkGetPhysicalDeviceExternalBufferProperties-pExternalBufferInfo-parameter", "VUID-VkPhysicalDeviceExternalBufferInfo-sType-sType");
    if (pExternalBufferInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkGetPhysicalDeviceExternalBufferProperties", "pExternalBufferInfo->pNext", nullptr, pExternalBufferInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkPhysicalDeviceExternalBufferInfo-pNext-pNext", kVUIDUndefined, true, true);

        skip |= ValidateFlags("vkGetPhysicalDeviceExternalBufferProperties", "pExternalBufferInfo->flags", "VkBufferCreateFlagBits", AllVkBufferCreateFlagBits, pExternalBufferInfo->flags, kOptionalFlags, "VUID-VkPhysicalDeviceExternalBufferInfo-flags-parameter");

        skip |= ValidateFlags("vkGetPhysicalDeviceExternalBufferProperties", "pExternalBufferInfo->usage", "VkBufferUsageFlagBits", AllVkBufferUsageFlagBits, pExternalBufferInfo->usage, kRequiredFlags, "VUID-VkPhysicalDeviceExternalBufferInfo-usage-parameter", "VUID-VkPhysicalDeviceExternalBufferInfo-usage-requiredbitmask");

        skip |= ValidateFlags("vkGetPhysicalDeviceExternalBufferProperties", "pExternalBufferInfo->handleType", "VkExternalMemoryHandleTypeFlagBits", AllVkExternalMemoryHandleTypeFlagBits, pExternalBufferInfo->handleType, kRequiredSingleBit, "VUID-VkPhysicalDeviceExternalBufferInfo-handleType-parameter", "VUID-VkPhysicalDeviceExternalBufferInfo-handleType-parameter");
    }
    skip |= ValidateStructType("vkGetPhysicalDeviceExternalBufferProperties", "pExternalBufferProperties", "VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES", pExternalBufferProperties, VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES, true, "VUID-vkGetPhysicalDeviceExternalBufferProperties-pExternalBufferProperties-parameter", "VUID-VkExternalBufferProperties-sType-sType");
    if (pExternalBufferProperties != nullptr)
    {
        skip |= ValidateStructPnext("vkGetPhysicalDeviceExternalBufferProperties", "pExternalBufferProperties->pNext", nullptr, pExternalBufferProperties->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkExternalBufferProperties-pNext-pNext", kVUIDUndefined, true, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceExternalFenceProperties(
    VkPhysicalDevice                            physicalDevice,
    const VkPhysicalDeviceExternalFenceInfo*    pExternalFenceInfo,
    VkExternalFenceProperties*                  pExternalFenceProperties) const {
    bool skip = false;
     if (CheckPromotedApiAgainstVulkanVersion(physicalDevice, "vkGetPhysicalDeviceExternalFenceProperties", VK_API_VERSION_1_1)) return true;
    skip |= ValidateStructType("vkGetPhysicalDeviceExternalFenceProperties", "pExternalFenceInfo", "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO", pExternalFenceInfo, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO, true, "VUID-vkGetPhysicalDeviceExternalFenceProperties-pExternalFenceInfo-parameter", "VUID-VkPhysicalDeviceExternalFenceInfo-sType-sType");
    if (pExternalFenceInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkGetPhysicalDeviceExternalFenceProperties", "pExternalFenceInfo->pNext", nullptr, pExternalFenceInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkPhysicalDeviceExternalFenceInfo-pNext-pNext", kVUIDUndefined, true, true);

        skip |= ValidateFlags("vkGetPhysicalDeviceExternalFenceProperties", "pExternalFenceInfo->handleType", "VkExternalFenceHandleTypeFlagBits", AllVkExternalFenceHandleTypeFlagBits, pExternalFenceInfo->handleType, kRequiredSingleBit, "VUID-VkPhysicalDeviceExternalFenceInfo-handleType-parameter", "VUID-VkPhysicalDeviceExternalFenceInfo-handleType-parameter");
    }
    skip |= ValidateStructType("vkGetPhysicalDeviceExternalFenceProperties", "pExternalFenceProperties", "VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES", pExternalFenceProperties, VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES, true, "VUID-vkGetPhysicalDeviceExternalFenceProperties-pExternalFenceProperties-parameter", "VUID-VkExternalFenceProperties-sType-sType");
    if (pExternalFenceProperties != nullptr)
    {
        skip |= ValidateStructPnext("vkGetPhysicalDeviceExternalFenceProperties", "pExternalFenceProperties->pNext", nullptr, pExternalFenceProperties->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkExternalFenceProperties-pNext-pNext", kVUIDUndefined, true, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceExternalSemaphoreProperties(
    VkPhysicalDevice                            physicalDevice,
    const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo,
    VkExternalSemaphoreProperties*              pExternalSemaphoreProperties) const {
    bool skip = false;
     if (CheckPromotedApiAgainstVulkanVersion(physicalDevice, "vkGetPhysicalDeviceExternalSemaphoreProperties", VK_API_VERSION_1_1)) return true;
    skip |= ValidateStructType("vkGetPhysicalDeviceExternalSemaphoreProperties", "pExternalSemaphoreInfo", "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO", pExternalSemaphoreInfo, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO, true, "VUID-vkGetPhysicalDeviceExternalSemaphoreProperties-pExternalSemaphoreInfo-parameter", "VUID-VkPhysicalDeviceExternalSemaphoreInfo-sType-sType");
    if (pExternalSemaphoreInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkPhysicalDeviceExternalSemaphoreInfo = { VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO };

        skip |= ValidateStructPnext("vkGetPhysicalDeviceExternalSemaphoreProperties", "pExternalSemaphoreInfo->pNext", "VkSemaphoreTypeCreateInfo", pExternalSemaphoreInfo->pNext, allowed_structs_VkPhysicalDeviceExternalSemaphoreInfo.size(), allowed_structs_VkPhysicalDeviceExternalSemaphoreInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkPhysicalDeviceExternalSemaphoreInfo-pNext-pNext", "VUID-VkPhysicalDeviceExternalSemaphoreInfo-sType-unique", true, true);

        skip |= ValidateFlags("vkGetPhysicalDeviceExternalSemaphoreProperties", "pExternalSemaphoreInfo->handleType", "VkExternalSemaphoreHandleTypeFlagBits", AllVkExternalSemaphoreHandleTypeFlagBits, pExternalSemaphoreInfo->handleType, kRequiredSingleBit, "VUID-VkPhysicalDeviceExternalSemaphoreInfo-handleType-parameter", "VUID-VkPhysicalDeviceExternalSemaphoreInfo-handleType-parameter");
    }
    skip |= ValidateStructType("vkGetPhysicalDeviceExternalSemaphoreProperties", "pExternalSemaphoreProperties", "VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES", pExternalSemaphoreProperties, VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES, true, "VUID-vkGetPhysicalDeviceExternalSemaphoreProperties-pExternalSemaphoreProperties-parameter", "VUID-VkExternalSemaphoreProperties-sType-sType");
    if (pExternalSemaphoreProperties != nullptr)
    {
        skip |= ValidateStructPnext("vkGetPhysicalDeviceExternalSemaphoreProperties", "pExternalSemaphoreProperties->pNext", nullptr, pExternalSemaphoreProperties->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkExternalSemaphoreProperties-pNext-pNext", kVUIDUndefined, true, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetDescriptorSetLayoutSupport(
    VkDevice                                    device,
    const VkDescriptorSetLayoutCreateInfo*      pCreateInfo,
    VkDescriptorSetLayoutSupport*               pSupport) const {
    bool skip = false;
    skip |= ValidateStructType("vkGetDescriptorSetLayoutSupport", "pCreateInfo", "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO, true, "VUID-vkGetDescriptorSetLayoutSupport-pCreateInfo-parameter", "VUID-VkDescriptorSetLayoutCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkDescriptorSetLayoutCreateInfo = { VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO, VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT };

        skip |= ValidateStructPnext("vkGetDescriptorSetLayoutSupport", "pCreateInfo->pNext", "VkDescriptorSetLayoutBindingFlagsCreateInfo, VkMutableDescriptorTypeCreateInfoEXT", pCreateInfo->pNext, allowed_structs_VkDescriptorSetLayoutCreateInfo.size(), allowed_structs_VkDescriptorSetLayoutCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkDescriptorSetLayoutCreateInfo-pNext-pNext", "VUID-VkDescriptorSetLayoutCreateInfo-sType-unique", false, true);

        skip |= ValidateFlags("vkGetDescriptorSetLayoutSupport", "pCreateInfo->flags", "VkDescriptorSetLayoutCreateFlagBits", AllVkDescriptorSetLayoutCreateFlagBits, pCreateInfo->flags, kOptionalFlags, "VUID-VkDescriptorSetLayoutCreateInfo-flags-parameter");

        skip |= ValidateArray("vkGetDescriptorSetLayoutSupport", "pCreateInfo->bindingCount", "pCreateInfo->pBindings", pCreateInfo->bindingCount, &pCreateInfo->pBindings, false, true, kVUIDUndefined, "VUID-VkDescriptorSetLayoutCreateInfo-pBindings-parameter");

        if (pCreateInfo->pBindings != nullptr)
        {
            for (uint32_t bindingIndex = 0; bindingIndex < pCreateInfo->bindingCount; ++bindingIndex)
            {
                skip |= ValidateRangedEnum("vkGetDescriptorSetLayoutSupport", ParameterName("pCreateInfo->pBindings[%i].descriptorType", ParameterName::IndexVector{ bindingIndex }), "VkDescriptorType", AllVkDescriptorTypeEnums, pCreateInfo->pBindings[bindingIndex].descriptorType, "VUID-VkDescriptorSetLayoutBinding-descriptorType-parameter");
            }
        }
    }
    skip |= ValidateStructType("vkGetDescriptorSetLayoutSupport", "pSupport", "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT", pSupport, VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT, true, "VUID-vkGetDescriptorSetLayoutSupport-pSupport-parameter", "VUID-VkDescriptorSetLayoutSupport-sType-sType");
    if (pSupport != nullptr)
    {
        constexpr std::array allowed_structs_VkDescriptorSetLayoutSupport = { VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT };

        skip |= ValidateStructPnext("vkGetDescriptorSetLayoutSupport", "pSupport->pNext", "VkDescriptorSetVariableDescriptorCountLayoutSupport", pSupport->pNext, allowed_structs_VkDescriptorSetLayoutSupport.size(), allowed_structs_VkDescriptorSetLayoutSupport.data(), GeneratedVulkanHeaderVersion, "VUID-VkDescriptorSetLayoutSupport-pNext-pNext", "VUID-VkDescriptorSetLayoutSupport-sType-unique", false, false);
    }
    return skip;
}



bool StatelessValidation::PreCallValidateCmdDrawIndirectCount(
    VkCommandBuffer                             commandBuffer,
    VkBuffer                                    buffer,
    VkDeviceSize                                offset,
    VkBuffer                                    countBuffer,
    VkDeviceSize                                countBufferOffset,
    uint32_t                                    maxDrawCount,
    uint32_t                                    stride) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdDrawIndirectCount", "buffer", buffer);
    skip |= ValidateRequiredHandle("vkCmdDrawIndirectCount", "countBuffer", countBuffer);
    if (!skip) skip |= manual_PreCallValidateCmdDrawIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdDrawIndexedIndirectCount(
    VkCommandBuffer                             commandBuffer,
    VkBuffer                                    buffer,
    VkDeviceSize                                offset,
    VkBuffer                                    countBuffer,
    VkDeviceSize                                countBufferOffset,
    uint32_t                                    maxDrawCount,
    uint32_t                                    stride) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdDrawIndexedIndirectCount", "buffer", buffer);
    skip |= ValidateRequiredHandle("vkCmdDrawIndexedIndirectCount", "countBuffer", countBuffer);
    if (!skip) skip |= manual_PreCallValidateCmdDrawIndexedIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    return skip;
}

bool StatelessValidation::PreCallValidateCreateRenderPass2(
    VkDevice                                    device,
    const VkRenderPassCreateInfo2*              pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkRenderPass*                               pRenderPass) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreateRenderPass2", "pCreateInfo", "VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2", pCreateInfo, VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2, true, "VUID-vkCreateRenderPass2-pCreateInfo-parameter", "VUID-VkRenderPassCreateInfo2-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkRenderPassCreateInfo2 = { VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_CONTROL_EXT, VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_FEEDBACK_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT };

        skip |= ValidateStructPnext("vkCreateRenderPass2", "pCreateInfo->pNext", "VkRenderPassCreationControlEXT, VkRenderPassCreationFeedbackCreateInfoEXT, VkRenderPassFragmentDensityMapCreateInfoEXT", pCreateInfo->pNext, allowed_structs_VkRenderPassCreateInfo2.size(), allowed_structs_VkRenderPassCreateInfo2.data(), GeneratedVulkanHeaderVersion, "VUID-VkRenderPassCreateInfo2-pNext-pNext", "VUID-VkRenderPassCreateInfo2-sType-unique", false, true);

        skip |= ValidateFlags("vkCreateRenderPass2", "pCreateInfo->flags", "VkRenderPassCreateFlagBits", AllVkRenderPassCreateFlagBits, pCreateInfo->flags, kOptionalFlags, "VUID-VkRenderPassCreateInfo2-flags-parameter");

        skip |= ValidateStructTypeArray("vkCreateRenderPass2", "pCreateInfo->attachmentCount", "pCreateInfo->pAttachments", "VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2", pCreateInfo->attachmentCount, pCreateInfo->pAttachments, VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2, false, true, "VUID-VkAttachmentDescription2-sType-sType", "VUID-VkRenderPassCreateInfo2-pAttachments-parameter", kVUIDUndefined);

        if (pCreateInfo->pAttachments != nullptr)
        {
            for (uint32_t attachmentIndex = 0; attachmentIndex < pCreateInfo->attachmentCount; ++attachmentIndex)
            {
                constexpr std::array allowed_structs_VkAttachmentDescription2 = { VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT };

                skip |= ValidateStructPnext("vkCreateRenderPass2", ParameterName("pCreateInfo->pAttachments[%i].pNext", ParameterName::IndexVector{ attachmentIndex }), "VkAttachmentDescriptionStencilLayout", pCreateInfo->pAttachments[attachmentIndex].pNext, allowed_structs_VkAttachmentDescription2.size(), allowed_structs_VkAttachmentDescription2.data(), GeneratedVulkanHeaderVersion, "VUID-VkAttachmentDescription2-pNext-pNext", "VUID-VkAttachmentDescription2-sType-unique", false, true);

                skip |= ValidateFlags("vkCreateRenderPass2", ParameterName("pCreateInfo->pAttachments[%i].flags", ParameterName::IndexVector{ attachmentIndex }), "VkAttachmentDescriptionFlagBits", AllVkAttachmentDescriptionFlagBits, pCreateInfo->pAttachments[attachmentIndex].flags, kOptionalFlags, "VUID-VkAttachmentDescription2-flags-parameter");

                skip |= ValidateRangedEnum("vkCreateRenderPass2", ParameterName("pCreateInfo->pAttachments[%i].format", ParameterName::IndexVector{ attachmentIndex }), "VkFormat", AllVkFormatEnums, pCreateInfo->pAttachments[attachmentIndex].format, "VUID-VkAttachmentDescription2-format-parameter");

                skip |= ValidateFlags("vkCreateRenderPass2", ParameterName("pCreateInfo->pAttachments[%i].samples", ParameterName::IndexVector{ attachmentIndex }), "VkSampleCountFlagBits", AllVkSampleCountFlagBits, pCreateInfo->pAttachments[attachmentIndex].samples, kRequiredSingleBit, "VUID-VkAttachmentDescription2-samples-parameter", "VUID-VkAttachmentDescription2-samples-parameter");

                skip |= ValidateRangedEnum("vkCreateRenderPass2", ParameterName("pCreateInfo->pAttachments[%i].loadOp", ParameterName::IndexVector{ attachmentIndex }), "VkAttachmentLoadOp", AllVkAttachmentLoadOpEnums, pCreateInfo->pAttachments[attachmentIndex].loadOp, "VUID-VkAttachmentDescription2-loadOp-parameter");

                skip |= ValidateRangedEnum("vkCreateRenderPass2", ParameterName("pCreateInfo->pAttachments[%i].storeOp", ParameterName::IndexVector{ attachmentIndex }), "VkAttachmentStoreOp", AllVkAttachmentStoreOpEnums, pCreateInfo->pAttachments[attachmentIndex].storeOp, "VUID-VkAttachmentDescription2-storeOp-parameter");

                skip |= ValidateRangedEnum("vkCreateRenderPass2", ParameterName("pCreateInfo->pAttachments[%i].stencilLoadOp", ParameterName::IndexVector{ attachmentIndex }), "VkAttachmentLoadOp", AllVkAttachmentLoadOpEnums, pCreateInfo->pAttachments[attachmentIndex].stencilLoadOp, "VUID-VkAttachmentDescription2-stencilLoadOp-parameter");

                skip |= ValidateRangedEnum("vkCreateRenderPass2", ParameterName("pCreateInfo->pAttachments[%i].stencilStoreOp", ParameterName::IndexVector{ attachmentIndex }), "VkAttachmentStoreOp", AllVkAttachmentStoreOpEnums, pCreateInfo->pAttachments[attachmentIndex].stencilStoreOp, "VUID-VkAttachmentDescription2-stencilStoreOp-parameter");

                skip |= ValidateRangedEnum("vkCreateRenderPass2", ParameterName("pCreateInfo->pAttachments[%i].initialLayout", ParameterName::IndexVector{ attachmentIndex }), "VkImageLayout", AllVkImageLayoutEnums, pCreateInfo->pAttachments[attachmentIndex].initialLayout, "VUID-VkAttachmentDescription2-initialLayout-parameter");

                skip |= ValidateRangedEnum("vkCreateRenderPass2", ParameterName("pCreateInfo->pAttachments[%i].finalLayout", ParameterName::IndexVector{ attachmentIndex }), "VkImageLayout", AllVkImageLayoutEnums, pCreateInfo->pAttachments[attachmentIndex].finalLayout, "VUID-VkAttachmentDescription2-finalLayout-parameter");
            }
        }

        skip |= ValidateStructTypeArray("vkCreateRenderPass2", "pCreateInfo->subpassCount", "pCreateInfo->pSubpasses", "VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2", pCreateInfo->subpassCount, pCreateInfo->pSubpasses, VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2, true, true, "VUID-VkSubpassDescription2-sType-sType", "VUID-VkRenderPassCreateInfo2-pSubpasses-parameter", "VUID-VkRenderPassCreateInfo2-subpassCount-arraylength");

        if (pCreateInfo->pSubpasses != nullptr)
        {
            for (uint32_t subpassIndex = 0; subpassIndex < pCreateInfo->subpassCount; ++subpassIndex)
            {
                constexpr std::array allowed_structs_VkSubpassDescription2 = { VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR, VK_STRUCTURE_TYPE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_INFO_EXT, VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_CONTROL_EXT, VK_STRUCTURE_TYPE_RENDER_PASS_SUBPASS_FEEDBACK_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE };

                skip |= ValidateStructPnext("vkCreateRenderPass2", ParameterName("pCreateInfo->pSubpasses[%i].pNext", ParameterName::IndexVector{ subpassIndex }), "VkFragmentShadingRateAttachmentInfoKHR, VkMultisampledRenderToSingleSampledInfoEXT, VkRenderPassCreationControlEXT, VkRenderPassSubpassFeedbackCreateInfoEXT, VkSubpassDescriptionDepthStencilResolve", pCreateInfo->pSubpasses[subpassIndex].pNext, allowed_structs_VkSubpassDescription2.size(), allowed_structs_VkSubpassDescription2.data(), GeneratedVulkanHeaderVersion, "VUID-VkSubpassDescription2-pNext-pNext", "VUID-VkSubpassDescription2-sType-unique", false, true);

                skip |= ValidateFlags("vkCreateRenderPass2", ParameterName("pCreateInfo->pSubpasses[%i].flags", ParameterName::IndexVector{ subpassIndex }), "VkSubpassDescriptionFlagBits", AllVkSubpassDescriptionFlagBits, pCreateInfo->pSubpasses[subpassIndex].flags, kOptionalFlags, "VUID-VkSubpassDescription2-flags-parameter");

                skip |= ValidateRangedEnum("vkCreateRenderPass2", ParameterName("pCreateInfo->pSubpasses[%i].pipelineBindPoint", ParameterName::IndexVector{ subpassIndex }), "VkPipelineBindPoint", AllVkPipelineBindPointEnums, pCreateInfo->pSubpasses[subpassIndex].pipelineBindPoint, "VUID-VkSubpassDescription2-pipelineBindPoint-parameter");

                skip |= ValidateStructTypeArray("vkCreateRenderPass2", ParameterName("pCreateInfo->pSubpasses[%i].inputAttachmentCount", ParameterName::IndexVector{ subpassIndex }), ParameterName("pCreateInfo->pSubpasses[%i].pInputAttachments", ParameterName::IndexVector{ subpassIndex }), "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2", pCreateInfo->pSubpasses[subpassIndex].inputAttachmentCount, pCreateInfo->pSubpasses[subpassIndex].pInputAttachments, VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2, false, true, "VUID-VkAttachmentReference2-sType-sType", "VUID-VkSubpassDescription2-pInputAttachments-parameter", kVUIDUndefined);

                if (pCreateInfo->pSubpasses[subpassIndex].pInputAttachments != nullptr)
                {
                    for (uint32_t inputAttachmentIndex = 0; inputAttachmentIndex < pCreateInfo->pSubpasses[subpassIndex].inputAttachmentCount; ++inputAttachmentIndex)
                    {
                        constexpr std::array allowed_structs_VkAttachmentReference2 = { VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT };

                        skip |= ValidateStructPnext("vkCreateRenderPass2", ParameterName("pCreateInfo->pSubpasses[%i].pInputAttachments[%i].pNext", ParameterName::IndexVector{ subpassIndex, inputAttachmentIndex }), "VkAttachmentReferenceStencilLayout", pCreateInfo->pSubpasses[subpassIndex].pInputAttachments[inputAttachmentIndex].pNext, allowed_structs_VkAttachmentReference2.size(), allowed_structs_VkAttachmentReference2.data(), GeneratedVulkanHeaderVersion, "VUID-VkAttachmentReference2-pNext-pNext", "VUID-VkAttachmentReference2-sType-unique", false, true);

                        skip |= ValidateRangedEnum("vkCreateRenderPass2", ParameterName("pCreateInfo->pSubpasses[%i].pInputAttachments[%i].layout", ParameterName::IndexVector{ subpassIndex, inputAttachmentIndex }), "VkImageLayout", AllVkImageLayoutEnums, pCreateInfo->pSubpasses[subpassIndex].pInputAttachments[inputAttachmentIndex].layout, "VUID-VkAttachmentReference2-layout-parameter");
                    }
                }

                skip |= ValidateStructTypeArray("vkCreateRenderPass2", ParameterName("pCreateInfo->pSubpasses[%i].colorAttachmentCount", ParameterName::IndexVector{ subpassIndex }), ParameterName("pCreateInfo->pSubpasses[%i].pColorAttachments", ParameterName::IndexVector{ subpassIndex }), "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2", pCreateInfo->pSubpasses[subpassIndex].colorAttachmentCount, pCreateInfo->pSubpasses[subpassIndex].pColorAttachments, VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2, false, true, "VUID-VkAttachmentReference2-sType-sType", "VUID-VkSubpassDescription2-pColorAttachments-parameter", kVUIDUndefined);

                if (pCreateInfo->pSubpasses[subpassIndex].pColorAttachments != nullptr)
                {
                    for (uint32_t colorAttachmentIndex = 0; colorAttachmentIndex < pCreateInfo->pSubpasses[subpassIndex].colorAttachmentCount; ++colorAttachmentIndex)
                    {
                        constexpr std::array allowed_structs_VkAttachmentReference2 = { VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT };

                        skip |= ValidateStructPnext("vkCreateRenderPass2", ParameterName("pCreateInfo->pSubpasses[%i].pColorAttachments[%i].pNext", ParameterName::IndexVector{ subpassIndex, colorAttachmentIndex }), "VkAttachmentReferenceStencilLayout", pCreateInfo->pSubpasses[subpassIndex].pColorAttachments[colorAttachmentIndex].pNext, allowed_structs_VkAttachmentReference2.size(), allowed_structs_VkAttachmentReference2.data(), GeneratedVulkanHeaderVersion, "VUID-VkAttachmentReference2-pNext-pNext", "VUID-VkAttachmentReference2-sType-unique", false, true);

                        skip |= ValidateRangedEnum("vkCreateRenderPass2", ParameterName("pCreateInfo->pSubpasses[%i].pColorAttachments[%i].layout", ParameterName::IndexVector{ subpassIndex, colorAttachmentIndex }), "VkImageLayout", AllVkImageLayoutEnums, pCreateInfo->pSubpasses[subpassIndex].pColorAttachments[colorAttachmentIndex].layout, "VUID-VkAttachmentReference2-layout-parameter");
                    }
                }

                skip |= ValidateStructTypeArray("vkCreateRenderPass2", ParameterName("pCreateInfo->pSubpasses[%i].colorAttachmentCount", ParameterName::IndexVector{ subpassIndex }), ParameterName("pCreateInfo->pSubpasses[%i].pResolveAttachments", ParameterName::IndexVector{ subpassIndex }), "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2", pCreateInfo->pSubpasses[subpassIndex].colorAttachmentCount, pCreateInfo->pSubpasses[subpassIndex].pResolveAttachments, VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2, false, false, "VUID-VkAttachmentReference2-sType-sType", "VUID-VkSubpassDescription2-pResolveAttachments-parameter", kVUIDUndefined);

                if (pCreateInfo->pSubpasses[subpassIndex].pResolveAttachments != nullptr)
                {
                    for (uint32_t colorAttachmentIndex = 0; colorAttachmentIndex < pCreateInfo->pSubpasses[subpassIndex].colorAttachmentCount; ++colorAttachmentIndex)
                    {
                        constexpr std::array allowed_structs_VkAttachmentReference2 = { VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT };

                        skip |= ValidateStructPnext("vkCreateRenderPass2", ParameterName("pCreateInfo->pSubpasses[%i].pResolveAttachments[%i].pNext", ParameterName::IndexVector{ subpassIndex, colorAttachmentIndex }), "VkAttachmentReferenceStencilLayout", pCreateInfo->pSubpasses[subpassIndex].pResolveAttachments[colorAttachmentIndex].pNext, allowed_structs_VkAttachmentReference2.size(), allowed_structs_VkAttachmentReference2.data(), GeneratedVulkanHeaderVersion, "VUID-VkAttachmentReference2-pNext-pNext", "VUID-VkAttachmentReference2-sType-unique", false, true);

                        skip |= ValidateRangedEnum("vkCreateRenderPass2", ParameterName("pCreateInfo->pSubpasses[%i].pResolveAttachments[%i].layout", ParameterName::IndexVector{ subpassIndex, colorAttachmentIndex }), "VkImageLayout", AllVkImageLayoutEnums, pCreateInfo->pSubpasses[subpassIndex].pResolveAttachments[colorAttachmentIndex].layout, "VUID-VkAttachmentReference2-layout-parameter");
                    }
                }

                skip |= ValidateStructType("vkCreateRenderPass2", ParameterName("pCreateInfo->pSubpasses[%i].pDepthStencilAttachment", ParameterName::IndexVector{ subpassIndex }), "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2", pCreateInfo->pSubpasses[subpassIndex].pDepthStencilAttachment, VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2, false, "VUID-VkSubpassDescription2-pDepthStencilAttachment-parameter", "VUID-VkAttachmentReference2-sType-sType");

                if (pCreateInfo->pSubpasses[subpassIndex].pDepthStencilAttachment != nullptr)
                {
                    constexpr std::array allowed_structs_VkAttachmentReference2 = { VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT };

                    skip |= ValidateStructPnext("vkCreateRenderPass2", ParameterName("pCreateInfo->pSubpasses[%i].pDepthStencilAttachment->pNext", ParameterName::IndexVector{ subpassIndex }), "VkAttachmentReferenceStencilLayout", pCreateInfo->pSubpasses[subpassIndex].pDepthStencilAttachment->pNext, allowed_structs_VkAttachmentReference2.size(), allowed_structs_VkAttachmentReference2.data(), GeneratedVulkanHeaderVersion, "VUID-VkAttachmentReference2-pNext-pNext", "VUID-VkAttachmentReference2-sType-unique", false, true);

                    skip |= ValidateRangedEnum("vkCreateRenderPass2", ParameterName("pCreateInfo->pSubpasses[%i].pDepthStencilAttachment->layout", ParameterName::IndexVector{ subpassIndex }), "VkImageLayout", AllVkImageLayoutEnums, pCreateInfo->pSubpasses[subpassIndex].pDepthStencilAttachment->layout, "VUID-VkAttachmentReference2-layout-parameter");
                }

                skip |= ValidateArray("vkCreateRenderPass2", ParameterName("pCreateInfo->pSubpasses[%i].preserveAttachmentCount", ParameterName::IndexVector{ subpassIndex }), ParameterName("pCreateInfo->pSubpasses[%i].pPreserveAttachments", ParameterName::IndexVector{ subpassIndex }), pCreateInfo->pSubpasses[subpassIndex].preserveAttachmentCount, &pCreateInfo->pSubpasses[subpassIndex].pPreserveAttachments, false, true, kVUIDUndefined, "VUID-VkSubpassDescription2-pPreserveAttachments-parameter");
            }
        }

        skip |= ValidateStructTypeArray("vkCreateRenderPass2", "pCreateInfo->dependencyCount", "pCreateInfo->pDependencies", "VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2", pCreateInfo->dependencyCount, pCreateInfo->pDependencies, VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2, false, true, "VUID-VkSubpassDependency2-sType-sType", "VUID-VkRenderPassCreateInfo2-pDependencies-parameter", kVUIDUndefined);

        if (pCreateInfo->pDependencies != nullptr)
        {
            for (uint32_t dependencyIndex = 0; dependencyIndex < pCreateInfo->dependencyCount; ++dependencyIndex)
            {
                constexpr std::array allowed_structs_VkSubpassDependency2 = { VK_STRUCTURE_TYPE_MEMORY_BARRIER_2 };

                skip |= ValidateStructPnext("vkCreateRenderPass2", ParameterName("pCreateInfo->pDependencies[%i].pNext", ParameterName::IndexVector{ dependencyIndex }), "VkMemoryBarrier2", pCreateInfo->pDependencies[dependencyIndex].pNext, allowed_structs_VkSubpassDependency2.size(), allowed_structs_VkSubpassDependency2.data(), GeneratedVulkanHeaderVersion, "VUID-VkSubpassDependency2-pNext-pNext", "VUID-VkSubpassDependency2-sType-unique", false, true);

                skip |= ValidateFlags("vkCreateRenderPass2", ParameterName("pCreateInfo->pDependencies[%i].srcStageMask", ParameterName::IndexVector{ dependencyIndex }), "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, pCreateInfo->pDependencies[dependencyIndex].srcStageMask, kOptionalFlags, "VUID-VkSubpassDependency2-srcStageMask-parameter");

                skip |= ValidateFlags("vkCreateRenderPass2", ParameterName("pCreateInfo->pDependencies[%i].dstStageMask", ParameterName::IndexVector{ dependencyIndex }), "VkPipelineStageFlagBits", AllVkPipelineStageFlagBits, pCreateInfo->pDependencies[dependencyIndex].dstStageMask, kOptionalFlags, "VUID-VkSubpassDependency2-dstStageMask-parameter");

                skip |= ValidateFlags("vkCreateRenderPass2", ParameterName("pCreateInfo->pDependencies[%i].srcAccessMask", ParameterName::IndexVector{ dependencyIndex }), "VkAccessFlagBits", AllVkAccessFlagBits, pCreateInfo->pDependencies[dependencyIndex].srcAccessMask, kOptionalFlags, "VUID-VkSubpassDependency2-srcAccessMask-parameter");

                skip |= ValidateFlags("vkCreateRenderPass2", ParameterName("pCreateInfo->pDependencies[%i].dstAccessMask", ParameterName::IndexVector{ dependencyIndex }), "VkAccessFlagBits", AllVkAccessFlagBits, pCreateInfo->pDependencies[dependencyIndex].dstAccessMask, kOptionalFlags, "VUID-VkSubpassDependency2-dstAccessMask-parameter");

                skip |= ValidateFlags("vkCreateRenderPass2", ParameterName("pCreateInfo->pDependencies[%i].dependencyFlags", ParameterName::IndexVector{ dependencyIndex }), "VkDependencyFlagBits", AllVkDependencyFlagBits, pCreateInfo->pDependencies[dependencyIndex].dependencyFlags, kOptionalFlags, "VUID-VkSubpassDependency2-dependencyFlags-parameter");
            }
        }

        skip |= ValidateArray("vkCreateRenderPass2", "pCreateInfo->correlatedViewMaskCount", "pCreateInfo->pCorrelatedViewMasks", pCreateInfo->correlatedViewMaskCount, &pCreateInfo->pCorrelatedViewMasks, false, true, kVUIDUndefined, "VUID-VkRenderPassCreateInfo2-pCorrelatedViewMasks-parameter");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateRenderPass2", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateRenderPass2", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateRenderPass2", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateRenderPass2", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateRenderPass2", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateRenderPass2", "pRenderPass", pRenderPass, "VUID-vkCreateRenderPass2-pRenderPass-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateRenderPass2(device, pCreateInfo, pAllocator, pRenderPass);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBeginRenderPass2(
    VkCommandBuffer                             commandBuffer,
    const VkRenderPassBeginInfo*                pRenderPassBegin,
    const VkSubpassBeginInfo*                   pSubpassBeginInfo) const {
    bool skip = false;
    skip |= ValidateStructType("vkCmdBeginRenderPass2", "pRenderPassBegin", "VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO", pRenderPassBegin, VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO, true, "VUID-vkCmdBeginRenderPass2-pRenderPassBegin-parameter", "VUID-VkRenderPassBeginInfo-sType-sType");
    if (pRenderPassBegin != nullptr)
    {
        constexpr std::array allowed_structs_VkRenderPassBeginInfo = { VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO, VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO, VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT, VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM };

        skip |= ValidateStructPnext("vkCmdBeginRenderPass2", "pRenderPassBegin->pNext", "VkDeviceGroupRenderPassBeginInfo, VkRenderPassAttachmentBeginInfo, VkRenderPassSampleLocationsBeginInfoEXT, VkRenderPassTransformBeginInfoQCOM", pRenderPassBegin->pNext, allowed_structs_VkRenderPassBeginInfo.size(), allowed_structs_VkRenderPassBeginInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkRenderPassBeginInfo-pNext-pNext", "VUID-VkRenderPassBeginInfo-sType-unique", false, true);

        skip |= ValidateRequiredHandle("vkCmdBeginRenderPass2", "pRenderPassBegin->renderPass", pRenderPassBegin->renderPass);

        skip |= ValidateRequiredHandle("vkCmdBeginRenderPass2", "pRenderPassBegin->framebuffer", pRenderPassBegin->framebuffer);

        // No xml-driven validation

        // No xml-driven validation
    }
    skip |= ValidateStructType("vkCmdBeginRenderPass2", "pSubpassBeginInfo", "VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO", pSubpassBeginInfo, VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO, true, "VUID-vkCmdBeginRenderPass2-pSubpassBeginInfo-parameter", "VUID-VkSubpassBeginInfo-sType-sType");
    if (pSubpassBeginInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCmdBeginRenderPass2", "pSubpassBeginInfo->pNext", nullptr, pSubpassBeginInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkSubpassBeginInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRangedEnum("vkCmdBeginRenderPass2", "pSubpassBeginInfo->contents", "VkSubpassContents", AllVkSubpassContentsEnums, pSubpassBeginInfo->contents, "VUID-VkSubpassBeginInfo-contents-parameter");
    }
    if (!skip) skip |= manual_PreCallValidateCmdBeginRenderPass2(commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdNextSubpass2(
    VkCommandBuffer                             commandBuffer,
    const VkSubpassBeginInfo*                   pSubpassBeginInfo,
    const VkSubpassEndInfo*                     pSubpassEndInfo) const {
    bool skip = false;
    skip |= ValidateStructType("vkCmdNextSubpass2", "pSubpassBeginInfo", "VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO", pSubpassBeginInfo, VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO, true, "VUID-vkCmdNextSubpass2-pSubpassBeginInfo-parameter", "VUID-VkSubpassBeginInfo-sType-sType");
    if (pSubpassBeginInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCmdNextSubpass2", "pSubpassBeginInfo->pNext", nullptr, pSubpassBeginInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkSubpassBeginInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRangedEnum("vkCmdNextSubpass2", "pSubpassBeginInfo->contents", "VkSubpassContents", AllVkSubpassContentsEnums, pSubpassBeginInfo->contents, "VUID-VkSubpassBeginInfo-contents-parameter");
    }
    skip |= ValidateStructType("vkCmdNextSubpass2", "pSubpassEndInfo", "VK_STRUCTURE_TYPE_SUBPASS_END_INFO", pSubpassEndInfo, VK_STRUCTURE_TYPE_SUBPASS_END_INFO, true, "VUID-vkCmdNextSubpass2-pSubpassEndInfo-parameter", "VUID-VkSubpassEndInfo-sType-sType");
    if (pSubpassEndInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkSubpassEndInfo = { VK_STRUCTURE_TYPE_SUBPASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_QCOM };

        skip |= ValidateStructPnext("vkCmdNextSubpass2", "pSubpassEndInfo->pNext", "VkSubpassFragmentDensityMapOffsetEndInfoQCOM", pSubpassEndInfo->pNext, allowed_structs_VkSubpassEndInfo.size(), allowed_structs_VkSubpassEndInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkSubpassEndInfo-pNext-pNext", "VUID-VkSubpassEndInfo-sType-unique", false, true);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdEndRenderPass2(
    VkCommandBuffer                             commandBuffer,
    const VkSubpassEndInfo*                     pSubpassEndInfo) const {
    bool skip = false;
    skip |= ValidateStructType("vkCmdEndRenderPass2", "pSubpassEndInfo", "VK_STRUCTURE_TYPE_SUBPASS_END_INFO", pSubpassEndInfo, VK_STRUCTURE_TYPE_SUBPASS_END_INFO, true, "VUID-vkCmdEndRenderPass2-pSubpassEndInfo-parameter", "VUID-VkSubpassEndInfo-sType-sType");
    if (pSubpassEndInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkSubpassEndInfo = { VK_STRUCTURE_TYPE_SUBPASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_QCOM };

        skip |= ValidateStructPnext("vkCmdEndRenderPass2", "pSubpassEndInfo->pNext", "VkSubpassFragmentDensityMapOffsetEndInfoQCOM", pSubpassEndInfo->pNext, allowed_structs_VkSubpassEndInfo.size(), allowed_structs_VkSubpassEndInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkSubpassEndInfo-pNext-pNext", "VUID-VkSubpassEndInfo-sType-unique", false, true);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateResetQueryPool(
    VkDevice                                    device,
    VkQueryPool                                 queryPool,
    uint32_t                                    firstQuery,
    uint32_t                                    queryCount) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkResetQueryPool", "queryPool", queryPool);
    return skip;
}

bool StatelessValidation::PreCallValidateGetSemaphoreCounterValue(
    VkDevice                                    device,
    VkSemaphore                                 semaphore,
    uint64_t*                                   pValue) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkGetSemaphoreCounterValue", "semaphore", semaphore);
    skip |= ValidateRequiredPointer("vkGetSemaphoreCounterValue", "pValue", pValue, "VUID-vkGetSemaphoreCounterValue-pValue-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateWaitSemaphores(
    VkDevice                                    device,
    const VkSemaphoreWaitInfo*                  pWaitInfo,
    uint64_t                                    timeout) const {
    bool skip = false;
    skip |= ValidateStructType("vkWaitSemaphores", "pWaitInfo", "VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO", pWaitInfo, VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO, true, "VUID-vkWaitSemaphores-pWaitInfo-parameter", "VUID-VkSemaphoreWaitInfo-sType-sType");
    if (pWaitInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkWaitSemaphores", "pWaitInfo->pNext", nullptr, pWaitInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkSemaphoreWaitInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateFlags("vkWaitSemaphores", "pWaitInfo->flags", "VkSemaphoreWaitFlagBits", AllVkSemaphoreWaitFlagBits, pWaitInfo->flags, kOptionalFlags, "VUID-VkSemaphoreWaitInfo-flags-parameter");

        skip |= ValidateHandleArray("vkWaitSemaphores", "pWaitInfo->semaphoreCount", "pWaitInfo->pSemaphores", pWaitInfo->semaphoreCount, pWaitInfo->pSemaphores, true, true, kVUIDUndefined);

        skip |= ValidateArray("vkWaitSemaphores", "pWaitInfo->semaphoreCount", "pWaitInfo->pValues", pWaitInfo->semaphoreCount, &pWaitInfo->pValues, true, true, "VUID-VkSemaphoreWaitInfo-semaphoreCount-arraylength", "VUID-VkSemaphoreWaitInfo-pValues-parameter");
    }
    return skip;
}

bool StatelessValidation::PreCallValidateSignalSemaphore(
    VkDevice                                    device,
    const VkSemaphoreSignalInfo*                pSignalInfo) const {
    bool skip = false;
    skip |= ValidateStructType("vkSignalSemaphore", "pSignalInfo", "VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO", pSignalInfo, VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO, true, "VUID-vkSignalSemaphore-pSignalInfo-parameter", "VUID-VkSemaphoreSignalInfo-sType-sType");
    if (pSignalInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkSignalSemaphore", "pSignalInfo->pNext", nullptr, pSignalInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkSemaphoreSignalInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle("vkSignalSemaphore", "pSignalInfo->semaphore", pSignalInfo->semaphore);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetBufferDeviceAddress(
    VkDevice                                    device,
    const VkBufferDeviceAddressInfo*            pInfo) const {
    bool skip = false;
    skip |= ValidateStructType("vkGetBufferDeviceAddress", "pInfo", "VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO", pInfo, VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO, true, "VUID-vkGetBufferDeviceAddress-pInfo-parameter", "VUID-VkBufferDeviceAddressInfo-sType-sType");
    if (pInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkGetBufferDeviceAddress", "pInfo->pNext", nullptr, pInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkBufferDeviceAddressInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle("vkGetBufferDeviceAddress", "pInfo->buffer", pInfo->buffer);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetBufferOpaqueCaptureAddress(
    VkDevice                                    device,
    const VkBufferDeviceAddressInfo*            pInfo) const {
    bool skip = false;
    skip |= ValidateStructType("vkGetBufferOpaqueCaptureAddress", "pInfo", "VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO", pInfo, VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO, true, "VUID-vkGetBufferOpaqueCaptureAddress-pInfo-parameter", "VUID-VkBufferDeviceAddressInfo-sType-sType");
    if (pInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkGetBufferOpaqueCaptureAddress", "pInfo->pNext", nullptr, pInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkBufferDeviceAddressInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle("vkGetBufferOpaqueCaptureAddress", "pInfo->buffer", pInfo->buffer);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetDeviceMemoryOpaqueCaptureAddress(
    VkDevice                                    device,
    const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) const {
    bool skip = false;
    skip |= ValidateStructType("vkGetDeviceMemoryOpaqueCaptureAddress", "pInfo", "VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO", pInfo, VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO, true, "VUID-vkGetDeviceMemoryOpaqueCaptureAddress-pInfo-parameter", "VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-sType-sType");
    if (pInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkGetDeviceMemoryOpaqueCaptureAddress", "pInfo->pNext", nullptr, pInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle("vkGetDeviceMemoryOpaqueCaptureAddress", "pInfo->memory", pInfo->memory);
    }
    return skip;
}



bool StatelessValidation::PreCallValidateGetPhysicalDeviceToolProperties(
    VkPhysicalDevice                            physicalDevice,
    uint32_t*                                   pToolCount,
    VkPhysicalDeviceToolProperties*             pToolProperties) const {
    bool skip = false;
     if (CheckPromotedApiAgainstVulkanVersion(physicalDevice, "vkGetPhysicalDeviceToolProperties", VK_API_VERSION_1_3)) return true;
    skip |= ValidateStructTypeArray("vkGetPhysicalDeviceToolProperties", "pToolCount", "pToolProperties", "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES", pToolCount, pToolProperties, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES, true, false, false, "VUID-VkPhysicalDeviceToolProperties-sType-sType", "VUID-vkGetPhysicalDeviceToolProperties-pToolProperties-parameter", kVUIDUndefined);
    if (pToolProperties != nullptr)
    {
        for (uint32_t pToolIndex = 0; pToolIndex < *pToolCount; ++pToolIndex)
        {
            skip |= ValidateStructPnext("vkGetPhysicalDeviceToolProperties", ParameterName("pToolProperties[%i].pNext", ParameterName::IndexVector{ pToolIndex }), nullptr, pToolProperties[pToolIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkPhysicalDeviceToolProperties-pNext-pNext", kVUIDUndefined, true, false);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreatePrivateDataSlot(
    VkDevice                                    device,
    const VkPrivateDataSlotCreateInfo*          pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkPrivateDataSlot*                          pPrivateDataSlot) const {
    bool skip = false;
    skip |= ValidateStructType("vkCreatePrivateDataSlot", "pCreateInfo", "VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO", pCreateInfo, VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO, true, "VUID-vkCreatePrivateDataSlot-pCreateInfo-parameter", "VUID-VkPrivateDataSlotCreateInfo-sType-sType");
    if (pCreateInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCreatePrivateDataSlot", "pCreateInfo->pNext", nullptr, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkPrivateDataSlotCreateInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateReservedFlags("vkCreatePrivateDataSlot", "pCreateInfo->flags", pCreateInfo->flags, "VUID-VkPrivateDataSlotCreateInfo-flags-zerobitmask");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreatePrivateDataSlot", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreatePrivateDataSlot", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreatePrivateDataSlot", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreatePrivateDataSlot", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreatePrivateDataSlot", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreatePrivateDataSlot", "pPrivateDataSlot", pPrivateDataSlot, "VUID-vkCreatePrivateDataSlot-pPrivateDataSlot-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyPrivateDataSlot(
    VkDevice                                    device,
    VkPrivateDataSlot                           privateDataSlot,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyPrivateDataSlot", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyPrivateDataSlot", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyPrivateDataSlot", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyPrivateDataSlot", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyPrivateDataSlot", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateSetPrivateData(
    VkDevice                                    device,
    VkObjectType                                objectType,
    uint64_t                                    objectHandle,
    VkPrivateDataSlot                           privateDataSlot,
    uint64_t                                    data) const {
    bool skip = false;
    skip |= ValidateRangedEnum("vkSetPrivateData", "objectType", "VkObjectType", AllVkObjectTypeEnums, objectType, "VUID-vkSetPrivateData-objectType-parameter");
    skip |= ValidateRequiredHandle("vkSetPrivateData", "privateDataSlot", privateDataSlot);
    return skip;
}

bool StatelessValidation::PreCallValidateGetPrivateData(
    VkDevice                                    device,
    VkObjectType                                objectType,
    uint64_t                                    objectHandle,
    VkPrivateDataSlot                           privateDataSlot,
    uint64_t*                                   pData) const {
    bool skip = false;
    skip |= ValidateRangedEnum("vkGetPrivateData", "objectType", "VkObjectType", AllVkObjectTypeEnums, objectType, "VUID-vkGetPrivateData-objectType-parameter");
    skip |= ValidateRequiredHandle("vkGetPrivateData", "privateDataSlot", privateDataSlot);
    skip |= ValidateRequiredPointer("vkGetPrivateData", "pData", pData, "VUID-vkGetPrivateData-pData-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetEvent2(
    VkCommandBuffer                             commandBuffer,
    VkEvent                                     event,
    const VkDependencyInfo*                     pDependencyInfo) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdSetEvent2", "event", event);
    skip |= ValidateStructType("vkCmdSetEvent2", "pDependencyInfo", "VK_STRUCTURE_TYPE_DEPENDENCY_INFO", pDependencyInfo, VK_STRUCTURE_TYPE_DEPENDENCY_INFO, true, "VUID-vkCmdSetEvent2-pDependencyInfo-parameter", "VUID-VkDependencyInfo-sType-sType");
    if (pDependencyInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCmdSetEvent2", "pDependencyInfo->pNext", nullptr, pDependencyInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkDependencyInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateFlags("vkCmdSetEvent2", "pDependencyInfo->dependencyFlags", "VkDependencyFlagBits", AllVkDependencyFlagBits, pDependencyInfo->dependencyFlags, kOptionalFlags, "VUID-VkDependencyInfo-dependencyFlags-parameter");

        skip |= ValidateStructTypeArray("vkCmdSetEvent2", "pDependencyInfo->memoryBarrierCount", "pDependencyInfo->pMemoryBarriers", "VK_STRUCTURE_TYPE_MEMORY_BARRIER_2", pDependencyInfo->memoryBarrierCount, pDependencyInfo->pMemoryBarriers, VK_STRUCTURE_TYPE_MEMORY_BARRIER_2, false, true, "VUID-VkMemoryBarrier2-sType-sType", "VUID-VkDependencyInfo-pMemoryBarriers-parameter", kVUIDUndefined);

        if (pDependencyInfo->pMemoryBarriers != nullptr)
        {
            for (uint32_t memoryBarrierIndex = 0; memoryBarrierIndex < pDependencyInfo->memoryBarrierCount; ++memoryBarrierIndex)
            {
                skip |= ValidateStructPnext("vkCmdSetEvent2", ParameterName("pDependencyInfo->pMemoryBarriers[%i].pNext", ParameterName::IndexVector{ memoryBarrierIndex }), nullptr, pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, kVUIDUndefined, kVUIDUndefined, false, true);

                skip |= ValidateFlags("vkCmdSetEvent2", ParameterName("pDependencyInfo->pMemoryBarriers[%i].srcStageMask", ParameterName::IndexVector{ memoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].srcStageMask, kOptionalFlags, "VUID-VkMemoryBarrier2-srcStageMask-parameter");

                skip |= ValidateFlags("vkCmdSetEvent2", ParameterName("pDependencyInfo->pMemoryBarriers[%i].srcAccessMask", ParameterName::IndexVector{ memoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].srcAccessMask, kOptionalFlags, "VUID-VkMemoryBarrier2-srcAccessMask-parameter");

                skip |= ValidateFlags("vkCmdSetEvent2", ParameterName("pDependencyInfo->pMemoryBarriers[%i].dstStageMask", ParameterName::IndexVector{ memoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].dstStageMask, kOptionalFlags, "VUID-VkMemoryBarrier2-dstStageMask-parameter");

                skip |= ValidateFlags("vkCmdSetEvent2", ParameterName("pDependencyInfo->pMemoryBarriers[%i].dstAccessMask", ParameterName::IndexVector{ memoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].dstAccessMask, kOptionalFlags, "VUID-VkMemoryBarrier2-dstAccessMask-parameter");
            }
        }

        skip |= ValidateStructTypeArray("vkCmdSetEvent2", "pDependencyInfo->bufferMemoryBarrierCount", "pDependencyInfo->pBufferMemoryBarriers", "VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2", pDependencyInfo->bufferMemoryBarrierCount, pDependencyInfo->pBufferMemoryBarriers, VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2, false, true, "VUID-VkBufferMemoryBarrier2-sType-sType", "VUID-VkDependencyInfo-pBufferMemoryBarriers-parameter", kVUIDUndefined);

        if (pDependencyInfo->pBufferMemoryBarriers != nullptr)
        {
            for (uint32_t bufferMemoryBarrierIndex = 0; bufferMemoryBarrierIndex < pDependencyInfo->bufferMemoryBarrierCount; ++bufferMemoryBarrierIndex)
            {
                skip |= ValidateStructPnext("vkCmdSetEvent2", ParameterName("pDependencyInfo->pBufferMemoryBarriers[%i].pNext", ParameterName::IndexVector{ bufferMemoryBarrierIndex }), nullptr, pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkBufferMemoryBarrier2-pNext-pNext", kVUIDUndefined, false, true);

                skip |= ValidateFlags("vkCmdSetEvent2", ParameterName("pDependencyInfo->pBufferMemoryBarriers[%i].srcStageMask", ParameterName::IndexVector{ bufferMemoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].srcStageMask, kOptionalFlags, "VUID-VkBufferMemoryBarrier2-srcStageMask-parameter");

                skip |= ValidateFlags("vkCmdSetEvent2", ParameterName("pDependencyInfo->pBufferMemoryBarriers[%i].srcAccessMask", ParameterName::IndexVector{ bufferMemoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].srcAccessMask, kOptionalFlags, "VUID-VkBufferMemoryBarrier2-srcAccessMask-parameter");

                skip |= ValidateFlags("vkCmdSetEvent2", ParameterName("pDependencyInfo->pBufferMemoryBarriers[%i].dstStageMask", ParameterName::IndexVector{ bufferMemoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].dstStageMask, kOptionalFlags, "VUID-VkBufferMemoryBarrier2-dstStageMask-parameter");

                skip |= ValidateFlags("vkCmdSetEvent2", ParameterName("pDependencyInfo->pBufferMemoryBarriers[%i].dstAccessMask", ParameterName::IndexVector{ bufferMemoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].dstAccessMask, kOptionalFlags, "VUID-VkBufferMemoryBarrier2-dstAccessMask-parameter");

                skip |= ValidateRequiredHandle("vkCmdSetEvent2", ParameterName("pDependencyInfo->pBufferMemoryBarriers[%i].buffer", ParameterName::IndexVector{ bufferMemoryBarrierIndex }), pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].buffer);
            }
        }

        skip |= ValidateStructTypeArray("vkCmdSetEvent2", "pDependencyInfo->imageMemoryBarrierCount", "pDependencyInfo->pImageMemoryBarriers", "VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2", pDependencyInfo->imageMemoryBarrierCount, pDependencyInfo->pImageMemoryBarriers, VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2, false, true, "VUID-VkImageMemoryBarrier2-sType-sType", "VUID-VkDependencyInfo-pImageMemoryBarriers-parameter", kVUIDUndefined);

        if (pDependencyInfo->pImageMemoryBarriers != nullptr)
        {
            for (uint32_t imageMemoryBarrierIndex = 0; imageMemoryBarrierIndex < pDependencyInfo->imageMemoryBarrierCount; ++imageMemoryBarrierIndex)
            {
                constexpr std::array allowed_structs_VkImageMemoryBarrier2 = { VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT };

                skip |= ValidateStructPnext("vkCmdSetEvent2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].pNext", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkSampleLocationsInfoEXT", pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].pNext, allowed_structs_VkImageMemoryBarrier2.size(), allowed_structs_VkImageMemoryBarrier2.data(), GeneratedVulkanHeaderVersion, "VUID-VkImageMemoryBarrier2-pNext-pNext", "VUID-VkImageMemoryBarrier2-sType-unique", false, true);

                skip |= ValidateFlags("vkCmdSetEvent2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].srcStageMask", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].srcStageMask, kOptionalFlags, "VUID-VkImageMemoryBarrier2-srcStageMask-parameter");

                skip |= ValidateFlags("vkCmdSetEvent2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].srcAccessMask", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].srcAccessMask, kOptionalFlags, "VUID-VkImageMemoryBarrier2-srcAccessMask-parameter");

                skip |= ValidateFlags("vkCmdSetEvent2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].dstStageMask", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].dstStageMask, kOptionalFlags, "VUID-VkImageMemoryBarrier2-dstStageMask-parameter");

                skip |= ValidateFlags("vkCmdSetEvent2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].dstAccessMask", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].dstAccessMask, kOptionalFlags, "VUID-VkImageMemoryBarrier2-dstAccessMask-parameter");

                skip |= ValidateRangedEnum("vkCmdSetEvent2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].oldLayout", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkImageLayout", AllVkImageLayoutEnums, pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].oldLayout, "VUID-VkImageMemoryBarrier2-oldLayout-parameter");

                skip |= ValidateRangedEnum("vkCmdSetEvent2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].newLayout", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkImageLayout", AllVkImageLayoutEnums, pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].newLayout, "VUID-VkImageMemoryBarrier2-newLayout-parameter");

                skip |= ValidateRequiredHandle("vkCmdSetEvent2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].image", ParameterName::IndexVector{ imageMemoryBarrierIndex }), pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].image);

                skip |= ValidateFlags("vkCmdSetEvent2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].subresourceRange.aspectMask", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].subresourceRange.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceRange-aspectMask-parameter", "VUID-VkImageSubresourceRange-aspectMask-requiredbitmask");
            }
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdResetEvent2(
    VkCommandBuffer                             commandBuffer,
    VkEvent                                     event,
    VkPipelineStageFlags2                       stageMask) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkCmdResetEvent2", "event", event);
    skip |= ValidateFlags("vkCmdResetEvent2", "stageMask", "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, stageMask, kOptionalFlags, "VUID-vkCmdResetEvent2-stageMask-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdWaitEvents2(
    VkCommandBuffer                             commandBuffer,
    uint32_t                                    eventCount,
    const VkEvent*                              pEvents,
    const VkDependencyInfo*                     pDependencyInfos) const {
    bool skip = false;
    skip |= ValidateHandleArray("vkCmdWaitEvents2", "eventCount", "pEvents", eventCount, pEvents, true, true, "VUID-vkCmdWaitEvents2-eventCount-arraylength");
    skip |= ValidateStructTypeArray("vkCmdWaitEvents2", "eventCount", "pDependencyInfos", "VK_STRUCTURE_TYPE_DEPENDENCY_INFO", eventCount, pDependencyInfos, VK_STRUCTURE_TYPE_DEPENDENCY_INFO, true, true, "VUID-VkDependencyInfo-sType-sType", "VUID-vkCmdWaitEvents2-pDependencyInfos-parameter", "VUID-vkCmdWaitEvents2-eventCount-arraylength");
    if (pDependencyInfos != nullptr)
    {
        for (uint32_t eventIndex = 0; eventIndex < eventCount; ++eventIndex)
        {
            skip |= ValidateStructPnext("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pNext", ParameterName::IndexVector{ eventIndex }), nullptr, pDependencyInfos[eventIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkDependencyInfo-pNext-pNext", kVUIDUndefined, false, true);

            skip |= ValidateFlags("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].dependencyFlags", ParameterName::IndexVector{ eventIndex }), "VkDependencyFlagBits", AllVkDependencyFlagBits, pDependencyInfos[eventIndex].dependencyFlags, kOptionalFlags, "VUID-VkDependencyInfo-dependencyFlags-parameter");

            skip |= ValidateStructTypeArray("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].memoryBarrierCount", ParameterName::IndexVector{ eventIndex }), ParameterName("pDependencyInfos[%i].pMemoryBarriers", ParameterName::IndexVector{ eventIndex }), "VK_STRUCTURE_TYPE_MEMORY_BARRIER_2", pDependencyInfos[eventIndex].memoryBarrierCount, pDependencyInfos[eventIndex].pMemoryBarriers, VK_STRUCTURE_TYPE_MEMORY_BARRIER_2, false, true, "VUID-VkMemoryBarrier2-sType-sType", "VUID-VkDependencyInfo-pMemoryBarriers-parameter", kVUIDUndefined);

            if (pDependencyInfos[eventIndex].pMemoryBarriers != nullptr)
            {
                for (uint32_t memoryBarrierIndex = 0; memoryBarrierIndex < pDependencyInfos[eventIndex].memoryBarrierCount; ++memoryBarrierIndex)
                {
                    skip |= ValidateStructPnext("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pMemoryBarriers[%i].pNext", ParameterName::IndexVector{ eventIndex, memoryBarrierIndex }), nullptr, pDependencyInfos[eventIndex].pMemoryBarriers[memoryBarrierIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, kVUIDUndefined, kVUIDUndefined, false, true);

                    skip |= ValidateFlags("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pMemoryBarriers[%i].srcStageMask", ParameterName::IndexVector{ eventIndex, memoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfos[eventIndex].pMemoryBarriers[memoryBarrierIndex].srcStageMask, kOptionalFlags, "VUID-VkMemoryBarrier2-srcStageMask-parameter");

                    skip |= ValidateFlags("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pMemoryBarriers[%i].srcAccessMask", ParameterName::IndexVector{ eventIndex, memoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfos[eventIndex].pMemoryBarriers[memoryBarrierIndex].srcAccessMask, kOptionalFlags, "VUID-VkMemoryBarrier2-srcAccessMask-parameter");

                    skip |= ValidateFlags("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pMemoryBarriers[%i].dstStageMask", ParameterName::IndexVector{ eventIndex, memoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfos[eventIndex].pMemoryBarriers[memoryBarrierIndex].dstStageMask, kOptionalFlags, "VUID-VkMemoryBarrier2-dstStageMask-parameter");

                    skip |= ValidateFlags("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pMemoryBarriers[%i].dstAccessMask", ParameterName::IndexVector{ eventIndex, memoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfos[eventIndex].pMemoryBarriers[memoryBarrierIndex].dstAccessMask, kOptionalFlags, "VUID-VkMemoryBarrier2-dstAccessMask-parameter");
                }
            }

            skip |= ValidateStructTypeArray("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].bufferMemoryBarrierCount", ParameterName::IndexVector{ eventIndex }), ParameterName("pDependencyInfos[%i].pBufferMemoryBarriers", ParameterName::IndexVector{ eventIndex }), "VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2", pDependencyInfos[eventIndex].bufferMemoryBarrierCount, pDependencyInfos[eventIndex].pBufferMemoryBarriers, VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2, false, true, "VUID-VkBufferMemoryBarrier2-sType-sType", "VUID-VkDependencyInfo-pBufferMemoryBarriers-parameter", kVUIDUndefined);

            if (pDependencyInfos[eventIndex].pBufferMemoryBarriers != nullptr)
            {
                for (uint32_t bufferMemoryBarrierIndex = 0; bufferMemoryBarrierIndex < pDependencyInfos[eventIndex].bufferMemoryBarrierCount; ++bufferMemoryBarrierIndex)
                {
                    skip |= ValidateStructPnext("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pBufferMemoryBarriers[%i].pNext", ParameterName::IndexVector{ eventIndex, bufferMemoryBarrierIndex }), nullptr, pDependencyInfos[eventIndex].pBufferMemoryBarriers[bufferMemoryBarrierIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkBufferMemoryBarrier2-pNext-pNext", kVUIDUndefined, false, true);

                    skip |= ValidateFlags("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pBufferMemoryBarriers[%i].srcStageMask", ParameterName::IndexVector{ eventIndex, bufferMemoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfos[eventIndex].pBufferMemoryBarriers[bufferMemoryBarrierIndex].srcStageMask, kOptionalFlags, "VUID-VkBufferMemoryBarrier2-srcStageMask-parameter");

                    skip |= ValidateFlags("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pBufferMemoryBarriers[%i].srcAccessMask", ParameterName::IndexVector{ eventIndex, bufferMemoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfos[eventIndex].pBufferMemoryBarriers[bufferMemoryBarrierIndex].srcAccessMask, kOptionalFlags, "VUID-VkBufferMemoryBarrier2-srcAccessMask-parameter");

                    skip |= ValidateFlags("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pBufferMemoryBarriers[%i].dstStageMask", ParameterName::IndexVector{ eventIndex, bufferMemoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfos[eventIndex].pBufferMemoryBarriers[bufferMemoryBarrierIndex].dstStageMask, kOptionalFlags, "VUID-VkBufferMemoryBarrier2-dstStageMask-parameter");

                    skip |= ValidateFlags("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pBufferMemoryBarriers[%i].dstAccessMask", ParameterName::IndexVector{ eventIndex, bufferMemoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfos[eventIndex].pBufferMemoryBarriers[bufferMemoryBarrierIndex].dstAccessMask, kOptionalFlags, "VUID-VkBufferMemoryBarrier2-dstAccessMask-parameter");

                    skip |= ValidateRequiredHandle("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pBufferMemoryBarriers[%i].buffer", ParameterName::IndexVector{ eventIndex, bufferMemoryBarrierIndex }), pDependencyInfos[eventIndex].pBufferMemoryBarriers[bufferMemoryBarrierIndex].buffer);
                }
            }

            skip |= ValidateStructTypeArray("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].imageMemoryBarrierCount", ParameterName::IndexVector{ eventIndex }), ParameterName("pDependencyInfos[%i].pImageMemoryBarriers", ParameterName::IndexVector{ eventIndex }), "VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2", pDependencyInfos[eventIndex].imageMemoryBarrierCount, pDependencyInfos[eventIndex].pImageMemoryBarriers, VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2, false, true, "VUID-VkImageMemoryBarrier2-sType-sType", "VUID-VkDependencyInfo-pImageMemoryBarriers-parameter", kVUIDUndefined);

            if (pDependencyInfos[eventIndex].pImageMemoryBarriers != nullptr)
            {
                for (uint32_t imageMemoryBarrierIndex = 0; imageMemoryBarrierIndex < pDependencyInfos[eventIndex].imageMemoryBarrierCount; ++imageMemoryBarrierIndex)
                {
                    constexpr std::array allowed_structs_VkImageMemoryBarrier2 = { VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT };

                    skip |= ValidateStructPnext("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pImageMemoryBarriers[%i].pNext", ParameterName::IndexVector{ eventIndex, imageMemoryBarrierIndex }), "VkSampleLocationsInfoEXT", pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].pNext, allowed_structs_VkImageMemoryBarrier2.size(), allowed_structs_VkImageMemoryBarrier2.data(), GeneratedVulkanHeaderVersion, "VUID-VkImageMemoryBarrier2-pNext-pNext", "VUID-VkImageMemoryBarrier2-sType-unique", false, true);

                    skip |= ValidateFlags("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pImageMemoryBarriers[%i].srcStageMask", ParameterName::IndexVector{ eventIndex, imageMemoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].srcStageMask, kOptionalFlags, "VUID-VkImageMemoryBarrier2-srcStageMask-parameter");

                    skip |= ValidateFlags("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pImageMemoryBarriers[%i].srcAccessMask", ParameterName::IndexVector{ eventIndex, imageMemoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].srcAccessMask, kOptionalFlags, "VUID-VkImageMemoryBarrier2-srcAccessMask-parameter");

                    skip |= ValidateFlags("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pImageMemoryBarriers[%i].dstStageMask", ParameterName::IndexVector{ eventIndex, imageMemoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].dstStageMask, kOptionalFlags, "VUID-VkImageMemoryBarrier2-dstStageMask-parameter");

                    skip |= ValidateFlags("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pImageMemoryBarriers[%i].dstAccessMask", ParameterName::IndexVector{ eventIndex, imageMemoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].dstAccessMask, kOptionalFlags, "VUID-VkImageMemoryBarrier2-dstAccessMask-parameter");

                    skip |= ValidateRangedEnum("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pImageMemoryBarriers[%i].oldLayout", ParameterName::IndexVector{ eventIndex, imageMemoryBarrierIndex }), "VkImageLayout", AllVkImageLayoutEnums, pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].oldLayout, "VUID-VkImageMemoryBarrier2-oldLayout-parameter");

                    skip |= ValidateRangedEnum("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pImageMemoryBarriers[%i].newLayout", ParameterName::IndexVector{ eventIndex, imageMemoryBarrierIndex }), "VkImageLayout", AllVkImageLayoutEnums, pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].newLayout, "VUID-VkImageMemoryBarrier2-newLayout-parameter");

                    skip |= ValidateRequiredHandle("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pImageMemoryBarriers[%i].image", ParameterName::IndexVector{ eventIndex, imageMemoryBarrierIndex }), pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].image);

                    skip |= ValidateFlags("vkCmdWaitEvents2", ParameterName("pDependencyInfos[%i].pImageMemoryBarriers[%i].subresourceRange.aspectMask", ParameterName::IndexVector{ eventIndex, imageMemoryBarrierIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pDependencyInfos[eventIndex].pImageMemoryBarriers[imageMemoryBarrierIndex].subresourceRange.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceRange-aspectMask-parameter", "VUID-VkImageSubresourceRange-aspectMask-requiredbitmask");
                }
            }
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdPipelineBarrier2(
    VkCommandBuffer                             commandBuffer,
    const VkDependencyInfo*                     pDependencyInfo) const {
    bool skip = false;
    skip |= ValidateStructType("vkCmdPipelineBarrier2", "pDependencyInfo", "VK_STRUCTURE_TYPE_DEPENDENCY_INFO", pDependencyInfo, VK_STRUCTURE_TYPE_DEPENDENCY_INFO, true, "VUID-vkCmdPipelineBarrier2-pDependencyInfo-parameter", "VUID-VkDependencyInfo-sType-sType");
    if (pDependencyInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCmdPipelineBarrier2", "pDependencyInfo->pNext", nullptr, pDependencyInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkDependencyInfo-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateFlags("vkCmdPipelineBarrier2", "pDependencyInfo->dependencyFlags", "VkDependencyFlagBits", AllVkDependencyFlagBits, pDependencyInfo->dependencyFlags, kOptionalFlags, "VUID-VkDependencyInfo-dependencyFlags-parameter");

        skip |= ValidateStructTypeArray("vkCmdPipelineBarrier2", "pDependencyInfo->memoryBarrierCount", "pDependencyInfo->pMemoryBarriers", "VK_STRUCTURE_TYPE_MEMORY_BARRIER_2", pDependencyInfo->memoryBarrierCount, pDependencyInfo->pMemoryBarriers, VK_STRUCTURE_TYPE_MEMORY_BARRIER_2, false, true, "VUID-VkMemoryBarrier2-sType-sType", "VUID-VkDependencyInfo-pMemoryBarriers-parameter", kVUIDUndefined);

        if (pDependencyInfo->pMemoryBarriers != nullptr)
        {
            for (uint32_t memoryBarrierIndex = 0; memoryBarrierIndex < pDependencyInfo->memoryBarrierCount; ++memoryBarrierIndex)
            {
                skip |= ValidateStructPnext("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pMemoryBarriers[%i].pNext", ParameterName::IndexVector{ memoryBarrierIndex }), nullptr, pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, kVUIDUndefined, kVUIDUndefined, false, true);

                skip |= ValidateFlags("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pMemoryBarriers[%i].srcStageMask", ParameterName::IndexVector{ memoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].srcStageMask, kOptionalFlags, "VUID-VkMemoryBarrier2-srcStageMask-parameter");

                skip |= ValidateFlags("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pMemoryBarriers[%i].srcAccessMask", ParameterName::IndexVector{ memoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].srcAccessMask, kOptionalFlags, "VUID-VkMemoryBarrier2-srcAccessMask-parameter");

                skip |= ValidateFlags("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pMemoryBarriers[%i].dstStageMask", ParameterName::IndexVector{ memoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].dstStageMask, kOptionalFlags, "VUID-VkMemoryBarrier2-dstStageMask-parameter");

                skip |= ValidateFlags("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pMemoryBarriers[%i].dstAccessMask", ParameterName::IndexVector{ memoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfo->pMemoryBarriers[memoryBarrierIndex].dstAccessMask, kOptionalFlags, "VUID-VkMemoryBarrier2-dstAccessMask-parameter");
            }
        }

        skip |= ValidateStructTypeArray("vkCmdPipelineBarrier2", "pDependencyInfo->bufferMemoryBarrierCount", "pDependencyInfo->pBufferMemoryBarriers", "VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2", pDependencyInfo->bufferMemoryBarrierCount, pDependencyInfo->pBufferMemoryBarriers, VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2, false, true, "VUID-VkBufferMemoryBarrier2-sType-sType", "VUID-VkDependencyInfo-pBufferMemoryBarriers-parameter", kVUIDUndefined);

        if (pDependencyInfo->pBufferMemoryBarriers != nullptr)
        {
            for (uint32_t bufferMemoryBarrierIndex = 0; bufferMemoryBarrierIndex < pDependencyInfo->bufferMemoryBarrierCount; ++bufferMemoryBarrierIndex)
            {
                skip |= ValidateStructPnext("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pBufferMemoryBarriers[%i].pNext", ParameterName::IndexVector{ bufferMemoryBarrierIndex }), nullptr, pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkBufferMemoryBarrier2-pNext-pNext", kVUIDUndefined, false, true);

                skip |= ValidateFlags("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pBufferMemoryBarriers[%i].srcStageMask", ParameterName::IndexVector{ bufferMemoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].srcStageMask, kOptionalFlags, "VUID-VkBufferMemoryBarrier2-srcStageMask-parameter");

                skip |= ValidateFlags("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pBufferMemoryBarriers[%i].srcAccessMask", ParameterName::IndexVector{ bufferMemoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].srcAccessMask, kOptionalFlags, "VUID-VkBufferMemoryBarrier2-srcAccessMask-parameter");

                skip |= ValidateFlags("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pBufferMemoryBarriers[%i].dstStageMask", ParameterName::IndexVector{ bufferMemoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].dstStageMask, kOptionalFlags, "VUID-VkBufferMemoryBarrier2-dstStageMask-parameter");

                skip |= ValidateFlags("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pBufferMemoryBarriers[%i].dstAccessMask", ParameterName::IndexVector{ bufferMemoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].dstAccessMask, kOptionalFlags, "VUID-VkBufferMemoryBarrier2-dstAccessMask-parameter");

                skip |= ValidateRequiredHandle("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pBufferMemoryBarriers[%i].buffer", ParameterName::IndexVector{ bufferMemoryBarrierIndex }), pDependencyInfo->pBufferMemoryBarriers[bufferMemoryBarrierIndex].buffer);
            }
        }

        skip |= ValidateStructTypeArray("vkCmdPipelineBarrier2", "pDependencyInfo->imageMemoryBarrierCount", "pDependencyInfo->pImageMemoryBarriers", "VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2", pDependencyInfo->imageMemoryBarrierCount, pDependencyInfo->pImageMemoryBarriers, VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2, false, true, "VUID-VkImageMemoryBarrier2-sType-sType", "VUID-VkDependencyInfo-pImageMemoryBarriers-parameter", kVUIDUndefined);

        if (pDependencyInfo->pImageMemoryBarriers != nullptr)
        {
            for (uint32_t imageMemoryBarrierIndex = 0; imageMemoryBarrierIndex < pDependencyInfo->imageMemoryBarrierCount; ++imageMemoryBarrierIndex)
            {
                constexpr std::array allowed_structs_VkImageMemoryBarrier2 = { VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT };

                skip |= ValidateStructPnext("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].pNext", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkSampleLocationsInfoEXT", pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].pNext, allowed_structs_VkImageMemoryBarrier2.size(), allowed_structs_VkImageMemoryBarrier2.data(), GeneratedVulkanHeaderVersion, "VUID-VkImageMemoryBarrier2-pNext-pNext", "VUID-VkImageMemoryBarrier2-sType-unique", false, true);

                skip |= ValidateFlags("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].srcStageMask", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].srcStageMask, kOptionalFlags, "VUID-VkImageMemoryBarrier2-srcStageMask-parameter");

                skip |= ValidateFlags("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].srcAccessMask", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].srcAccessMask, kOptionalFlags, "VUID-VkImageMemoryBarrier2-srcAccessMask-parameter");

                skip |= ValidateFlags("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].dstStageMask", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].dstStageMask, kOptionalFlags, "VUID-VkImageMemoryBarrier2-dstStageMask-parameter");

                skip |= ValidateFlags("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].dstAccessMask", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkAccessFlagBits2", AllVkAccessFlagBits2, pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].dstAccessMask, kOptionalFlags, "VUID-VkImageMemoryBarrier2-dstAccessMask-parameter");

                skip |= ValidateRangedEnum("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].oldLayout", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkImageLayout", AllVkImageLayoutEnums, pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].oldLayout, "VUID-VkImageMemoryBarrier2-oldLayout-parameter");

                skip |= ValidateRangedEnum("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].newLayout", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkImageLayout", AllVkImageLayoutEnums, pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].newLayout, "VUID-VkImageMemoryBarrier2-newLayout-parameter");

                skip |= ValidateRequiredHandle("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].image", ParameterName::IndexVector{ imageMemoryBarrierIndex }), pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].image);

                skip |= ValidateFlags("vkCmdPipelineBarrier2", ParameterName("pDependencyInfo->pImageMemoryBarriers[%i].subresourceRange.aspectMask", ParameterName::IndexVector{ imageMemoryBarrierIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pDependencyInfo->pImageMemoryBarriers[imageMemoryBarrierIndex].subresourceRange.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceRange-aspectMask-parameter", "VUID-VkImageSubresourceRange-aspectMask-requiredbitmask");
            }
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdWriteTimestamp2(
    VkCommandBuffer                             commandBuffer,
    VkPipelineStageFlags2                       stage,
    VkQueryPool                                 queryPool,
    uint32_t                                    query) const {
    bool skip = false;
    skip |= ValidateFlags("vkCmdWriteTimestamp2", "stage", "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, stage, kOptionalFlags, "VUID-vkCmdWriteTimestamp2-stage-parameter");
    skip |= ValidateRequiredHandle("vkCmdWriteTimestamp2", "queryPool", queryPool);
    return skip;
}

bool StatelessValidation::PreCallValidateQueueSubmit2(
    VkQueue                                     queue,
    uint32_t                                    submitCount,
    const VkSubmitInfo2*                        pSubmits,
    VkFence                                     fence) const {
    bool skip = false;
    skip |= ValidateStructTypeArray("vkQueueSubmit2", "submitCount", "pSubmits", "VK_STRUCTURE_TYPE_SUBMIT_INFO_2", submitCount, pSubmits, VK_STRUCTURE_TYPE_SUBMIT_INFO_2, false, true, "VUID-VkSubmitInfo2-sType-sType", "VUID-vkQueueSubmit2-pSubmits-parameter", kVUIDUndefined);
    if (pSubmits != nullptr)
    {
        for (uint32_t submitIndex = 0; submitIndex < submitCount; ++submitIndex)
        {
            constexpr std::array allowed_structs_VkSubmitInfo2 = { VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR, VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR, VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV };

            skip |= ValidateStructPnext("vkQueueSubmit2", ParameterName("pSubmits[%i].pNext", ParameterName::IndexVector{ submitIndex }), "VkPerformanceQuerySubmitInfoKHR, VkWin32KeyedMutexAcquireReleaseInfoKHR, VkWin32KeyedMutexAcquireReleaseInfoNV", pSubmits[submitIndex].pNext, allowed_structs_VkSubmitInfo2.size(), allowed_structs_VkSubmitInfo2.data(), GeneratedVulkanHeaderVersion, "VUID-VkSubmitInfo2-pNext-pNext", "VUID-VkSubmitInfo2-sType-unique", false, true);

            skip |= ValidateFlags("vkQueueSubmit2", ParameterName("pSubmits[%i].flags", ParameterName::IndexVector{ submitIndex }), "VkSubmitFlagBits", AllVkSubmitFlagBits, pSubmits[submitIndex].flags, kOptionalFlags, "VUID-VkSubmitInfo2-flags-parameter");

            skip |= ValidateStructTypeArray("vkQueueSubmit2", ParameterName("pSubmits[%i].waitSemaphoreInfoCount", ParameterName::IndexVector{ submitIndex }), ParameterName("pSubmits[%i].pWaitSemaphoreInfos", ParameterName::IndexVector{ submitIndex }), "VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO", pSubmits[submitIndex].waitSemaphoreInfoCount, pSubmits[submitIndex].pWaitSemaphoreInfos, VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO, false, true, "VUID-VkSemaphoreSubmitInfo-sType-sType", "VUID-VkSubmitInfo2-pWaitSemaphoreInfos-parameter", kVUIDUndefined);

            if (pSubmits[submitIndex].pWaitSemaphoreInfos != nullptr)
            {
                for (uint32_t waitSemaphoreInfoIndex = 0; waitSemaphoreInfoIndex < pSubmits[submitIndex].waitSemaphoreInfoCount; ++waitSemaphoreInfoIndex)
                {
                    skip |= ValidateStructPnext("vkQueueSubmit2", ParameterName("pSubmits[%i].pWaitSemaphoreInfos[%i].pNext", ParameterName::IndexVector{ submitIndex, waitSemaphoreInfoIndex }), nullptr, pSubmits[submitIndex].pWaitSemaphoreInfos[waitSemaphoreInfoIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkSemaphoreSubmitInfo-pNext-pNext", kVUIDUndefined, false, true);

                    skip |= ValidateRequiredHandle("vkQueueSubmit2", ParameterName("pSubmits[%i].pWaitSemaphoreInfos[%i].semaphore", ParameterName::IndexVector{ submitIndex, waitSemaphoreInfoIndex }), pSubmits[submitIndex].pWaitSemaphoreInfos[waitSemaphoreInfoIndex].semaphore);

                    skip |= ValidateFlags("vkQueueSubmit2", ParameterName("pSubmits[%i].pWaitSemaphoreInfos[%i].stageMask", ParameterName::IndexVector{ submitIndex, waitSemaphoreInfoIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pSubmits[submitIndex].pWaitSemaphoreInfos[waitSemaphoreInfoIndex].stageMask, kOptionalFlags, "VUID-VkSemaphoreSubmitInfo-stageMask-parameter");
                }
            }

            skip |= ValidateStructTypeArray("vkQueueSubmit2", ParameterName("pSubmits[%i].commandBufferInfoCount", ParameterName::IndexVector{ submitIndex }), ParameterName("pSubmits[%i].pCommandBufferInfos", ParameterName::IndexVector{ submitIndex }), "VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO", pSubmits[submitIndex].commandBufferInfoCount, pSubmits[submitIndex].pCommandBufferInfos, VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO, false, true, "VUID-VkCommandBufferSubmitInfo-sType-sType", "VUID-VkSubmitInfo2-pCommandBufferInfos-parameter", kVUIDUndefined);

            if (pSubmits[submitIndex].pCommandBufferInfos != nullptr)
            {
                for (uint32_t commandBufferInfoIndex = 0; commandBufferInfoIndex < pSubmits[submitIndex].commandBufferInfoCount; ++commandBufferInfoIndex)
                {
                    skip |= ValidateStructPnext("vkQueueSubmit2", ParameterName("pSubmits[%i].pCommandBufferInfos[%i].pNext", ParameterName::IndexVector{ submitIndex, commandBufferInfoIndex }), nullptr, pSubmits[submitIndex].pCommandBufferInfos[commandBufferInfoIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkCommandBufferSubmitInfo-pNext-pNext", kVUIDUndefined, false, true);

                    skip |= ValidateRequiredHandle("vkQueueSubmit2", ParameterName("pSubmits[%i].pCommandBufferInfos[%i].commandBuffer", ParameterName::IndexVector{ submitIndex, commandBufferInfoIndex }), pSubmits[submitIndex].pCommandBufferInfos[commandBufferInfoIndex].commandBuffer);
                }
            }

            skip |= ValidateStructTypeArray("vkQueueSubmit2", ParameterName("pSubmits[%i].signalSemaphoreInfoCount", ParameterName::IndexVector{ submitIndex }), ParameterName("pSubmits[%i].pSignalSemaphoreInfos", ParameterName::IndexVector{ submitIndex }), "VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO", pSubmits[submitIndex].signalSemaphoreInfoCount, pSubmits[submitIndex].pSignalSemaphoreInfos, VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO, false, true, "VUID-VkSemaphoreSubmitInfo-sType-sType", "VUID-VkSubmitInfo2-pSignalSemaphoreInfos-parameter", kVUIDUndefined);

            if (pSubmits[submitIndex].pSignalSemaphoreInfos != nullptr)
            {
                for (uint32_t signalSemaphoreInfoIndex = 0; signalSemaphoreInfoIndex < pSubmits[submitIndex].signalSemaphoreInfoCount; ++signalSemaphoreInfoIndex)
                {
                    skip |= ValidateStructPnext("vkQueueSubmit2", ParameterName("pSubmits[%i].pSignalSemaphoreInfos[%i].pNext", ParameterName::IndexVector{ submitIndex, signalSemaphoreInfoIndex }), nullptr, pSubmits[submitIndex].pSignalSemaphoreInfos[signalSemaphoreInfoIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkSemaphoreSubmitInfo-pNext-pNext", kVUIDUndefined, false, true);

                    skip |= ValidateRequiredHandle("vkQueueSubmit2", ParameterName("pSubmits[%i].pSignalSemaphoreInfos[%i].semaphore", ParameterName::IndexVector{ submitIndex, signalSemaphoreInfoIndex }), pSubmits[submitIndex].pSignalSemaphoreInfos[signalSemaphoreInfoIndex].semaphore);

                    skip |= ValidateFlags("vkQueueSubmit2", ParameterName("pSubmits[%i].pSignalSemaphoreInfos[%i].stageMask", ParameterName::IndexVector{ submitIndex, signalSemaphoreInfoIndex }), "VkPipelineStageFlagBits2", AllVkPipelineStageFlagBits2, pSubmits[submitIndex].pSignalSemaphoreInfos[signalSemaphoreInfoIndex].stageMask, kOptionalFlags, "VUID-VkSemaphoreSubmitInfo-stageMask-parameter");
                }
            }
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyBuffer2(
    VkCommandBuffer                             commandBuffer,
    const VkCopyBufferInfo2*                    pCopyBufferInfo) const {
    bool skip = false;
    skip |= ValidateStructType("vkCmdCopyBuffer2", "pCopyBufferInfo", "VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2", pCopyBufferInfo, VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2, true, "VUID-vkCmdCopyBuffer2-pCopyBufferInfo-parameter", "VUID-VkCopyBufferInfo2-sType-sType");
    if (pCopyBufferInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCmdCopyBuffer2", "pCopyBufferInfo->pNext", nullptr, pCopyBufferInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkCopyBufferInfo2-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle("vkCmdCopyBuffer2", "pCopyBufferInfo->srcBuffer", pCopyBufferInfo->srcBuffer);

        skip |= ValidateRequiredHandle("vkCmdCopyBuffer2", "pCopyBufferInfo->dstBuffer", pCopyBufferInfo->dstBuffer);

        skip |= ValidateStructTypeArray("vkCmdCopyBuffer2", "pCopyBufferInfo->regionCount", "pCopyBufferInfo->pRegions", "VK_STRUCTURE_TYPE_BUFFER_COPY_2", pCopyBufferInfo->regionCount, pCopyBufferInfo->pRegions, VK_STRUCTURE_TYPE_BUFFER_COPY_2, true, true, "VUID-VkBufferCopy2-sType-sType", "VUID-VkCopyBufferInfo2-pRegions-parameter", "VUID-VkCopyBufferInfo2-regionCount-arraylength");

        if (pCopyBufferInfo->pRegions != nullptr)
        {
            for (uint32_t regionIndex = 0; regionIndex < pCopyBufferInfo->regionCount; ++regionIndex)
            {
                skip |= ValidateStructPnext("vkCmdCopyBuffer2", ParameterName("pCopyBufferInfo->pRegions[%i].pNext", ParameterName::IndexVector{ regionIndex }), nullptr, pCopyBufferInfo->pRegions[regionIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkBufferCopy2-pNext-pNext", kVUIDUndefined, false, true);
            }
        }
    }
    if (!skip) skip |= manual_PreCallValidateCmdCopyBuffer2(commandBuffer, pCopyBufferInfo);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyImage2(
    VkCommandBuffer                             commandBuffer,
    const VkCopyImageInfo2*                     pCopyImageInfo) const {
    bool skip = false;
    skip |= ValidateStructType("vkCmdCopyImage2", "pCopyImageInfo", "VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2", pCopyImageInfo, VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2, true, "VUID-vkCmdCopyImage2-pCopyImageInfo-parameter", "VUID-VkCopyImageInfo2-sType-sType");
    if (pCopyImageInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCmdCopyImage2", "pCopyImageInfo->pNext", nullptr, pCopyImageInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkCopyImageInfo2-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle("vkCmdCopyImage2", "pCopyImageInfo->srcImage", pCopyImageInfo->srcImage);

        skip |= ValidateRangedEnum("vkCmdCopyImage2", "pCopyImageInfo->srcImageLayout", "VkImageLayout", AllVkImageLayoutEnums, pCopyImageInfo->srcImageLayout, "VUID-VkCopyImageInfo2-srcImageLayout-parameter");

        skip |= ValidateRequiredHandle("vkCmdCopyImage2", "pCopyImageInfo->dstImage", pCopyImageInfo->dstImage);

        skip |= ValidateRangedEnum("vkCmdCopyImage2", "pCopyImageInfo->dstImageLayout", "VkImageLayout", AllVkImageLayoutEnums, pCopyImageInfo->dstImageLayout, "VUID-VkCopyImageInfo2-dstImageLayout-parameter");

        skip |= ValidateStructTypeArray("vkCmdCopyImage2", "pCopyImageInfo->regionCount", "pCopyImageInfo->pRegions", "VK_STRUCTURE_TYPE_IMAGE_COPY_2", pCopyImageInfo->regionCount, pCopyImageInfo->pRegions, VK_STRUCTURE_TYPE_IMAGE_COPY_2, true, true, "VUID-VkImageCopy2-sType-sType", "VUID-VkCopyImageInfo2-pRegions-parameter", "VUID-VkCopyImageInfo2-regionCount-arraylength");

        if (pCopyImageInfo->pRegions != nullptr)
        {
            for (uint32_t regionIndex = 0; regionIndex < pCopyImageInfo->regionCount; ++regionIndex)
            {
                skip |= ValidateStructPnext("vkCmdCopyImage2", ParameterName("pCopyImageInfo->pRegions[%i].pNext", ParameterName::IndexVector{ regionIndex }), nullptr, pCopyImageInfo->pRegions[regionIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkImageCopy2-pNext-pNext", kVUIDUndefined, false, true);

                skip |= ValidateFlags("vkCmdCopyImage2", ParameterName("pCopyImageInfo->pRegions[%i].srcSubresource.aspectMask", ParameterName::IndexVector{ regionIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pCopyImageInfo->pRegions[regionIndex].srcSubresource.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceLayers-aspectMask-parameter", "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

                // No xml-driven validation

                skip |= ValidateFlags("vkCmdCopyImage2", ParameterName("pCopyImageInfo->pRegions[%i].dstSubresource.aspectMask", ParameterName::IndexVector{ regionIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pCopyImageInfo->pRegions[regionIndex].dstSubresource.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceLayers-aspectMask-parameter", "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

                // No xml-driven validation

                // No xml-driven validation
            }
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyBufferToImage2(
    VkCommandBuffer                             commandBuffer,
    const VkCopyBufferToImageInfo2*             pCopyBufferToImageInfo) const {
    bool skip = false;
    skip |= ValidateStructType("vkCmdCopyBufferToImage2", "pCopyBufferToImageInfo", "VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2", pCopyBufferToImageInfo, VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2, true, "VUID-vkCmdCopyBufferToImage2-pCopyBufferToImageInfo-parameter", "VUID-VkCopyBufferToImageInfo2-sType-sType");
    if (pCopyBufferToImageInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCmdCopyBufferToImage2", "pCopyBufferToImageInfo->pNext", nullptr, pCopyBufferToImageInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkCopyBufferToImageInfo2-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle("vkCmdCopyBufferToImage2", "pCopyBufferToImageInfo->srcBuffer", pCopyBufferToImageInfo->srcBuffer);

        skip |= ValidateRequiredHandle("vkCmdCopyBufferToImage2", "pCopyBufferToImageInfo->dstImage", pCopyBufferToImageInfo->dstImage);

        skip |= ValidateRangedEnum("vkCmdCopyBufferToImage2", "pCopyBufferToImageInfo->dstImageLayout", "VkImageLayout", AllVkImageLayoutEnums, pCopyBufferToImageInfo->dstImageLayout, "VUID-VkCopyBufferToImageInfo2-dstImageLayout-parameter");

        skip |= ValidateStructTypeArray("vkCmdCopyBufferToImage2", "pCopyBufferToImageInfo->regionCount", "pCopyBufferToImageInfo->pRegions", "VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2", pCopyBufferToImageInfo->regionCount, pCopyBufferToImageInfo->pRegions, VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2, true, true, "VUID-VkBufferImageCopy2-sType-sType", "VUID-VkCopyBufferToImageInfo2-pRegions-parameter", "VUID-VkCopyBufferToImageInfo2-regionCount-arraylength");

        if (pCopyBufferToImageInfo->pRegions != nullptr)
        {
            for (uint32_t regionIndex = 0; regionIndex < pCopyBufferToImageInfo->regionCount; ++regionIndex)
            {
                constexpr std::array allowed_structs_VkBufferImageCopy2 = { VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM };

                skip |= ValidateStructPnext("vkCmdCopyBufferToImage2", ParameterName("pCopyBufferToImageInfo->pRegions[%i].pNext", ParameterName::IndexVector{ regionIndex }), "VkCopyCommandTransformInfoQCOM", pCopyBufferToImageInfo->pRegions[regionIndex].pNext, allowed_structs_VkBufferImageCopy2.size(), allowed_structs_VkBufferImageCopy2.data(), GeneratedVulkanHeaderVersion, "VUID-VkBufferImageCopy2-pNext-pNext", "VUID-VkBufferImageCopy2-sType-unique", false, true);

                skip |= ValidateFlags("vkCmdCopyBufferToImage2", ParameterName("pCopyBufferToImageInfo->pRegions[%i].imageSubresource.aspectMask", ParameterName::IndexVector{ regionIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pCopyBufferToImageInfo->pRegions[regionIndex].imageSubresource.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceLayers-aspectMask-parameter", "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

                // No xml-driven validation

                // No xml-driven validation
            }
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdCopyImageToBuffer2(
    VkCommandBuffer                             commandBuffer,
    const VkCopyImageToBufferInfo2*             pCopyImageToBufferInfo) const {
    bool skip = false;
    skip |= ValidateStructType("vkCmdCopyImageToBuffer2", "pCopyImageToBufferInfo", "VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2", pCopyImageToBufferInfo, VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2, true, "VUID-vkCmdCopyImageToBuffer2-pCopyImageToBufferInfo-parameter", "VUID-VkCopyImageToBufferInfo2-sType-sType");
    if (pCopyImageToBufferInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCmdCopyImageToBuffer2", "pCopyImageToBufferInfo->pNext", nullptr, pCopyImageToBufferInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkCopyImageToBufferInfo2-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle("vkCmdCopyImageToBuffer2", "pCopyImageToBufferInfo->srcImage", pCopyImageToBufferInfo->srcImage);

        skip |= ValidateRangedEnum("vkCmdCopyImageToBuffer2", "pCopyImageToBufferInfo->srcImageLayout", "VkImageLayout", AllVkImageLayoutEnums, pCopyImageToBufferInfo->srcImageLayout, "VUID-VkCopyImageToBufferInfo2-srcImageLayout-parameter");

        skip |= ValidateRequiredHandle("vkCmdCopyImageToBuffer2", "pCopyImageToBufferInfo->dstBuffer", pCopyImageToBufferInfo->dstBuffer);

        skip |= ValidateStructTypeArray("vkCmdCopyImageToBuffer2", "pCopyImageToBufferInfo->regionCount", "pCopyImageToBufferInfo->pRegions", "VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2", pCopyImageToBufferInfo->regionCount, pCopyImageToBufferInfo->pRegions, VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2, true, true, "VUID-VkBufferImageCopy2-sType-sType", "VUID-VkCopyImageToBufferInfo2-pRegions-parameter", "VUID-VkCopyImageToBufferInfo2-regionCount-arraylength");

        if (pCopyImageToBufferInfo->pRegions != nullptr)
        {
            for (uint32_t regionIndex = 0; regionIndex < pCopyImageToBufferInfo->regionCount; ++regionIndex)
            {
                constexpr std::array allowed_structs_VkBufferImageCopy2 = { VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM };

                skip |= ValidateStructPnext("vkCmdCopyImageToBuffer2", ParameterName("pCopyImageToBufferInfo->pRegions[%i].pNext", ParameterName::IndexVector{ regionIndex }), "VkCopyCommandTransformInfoQCOM", pCopyImageToBufferInfo->pRegions[regionIndex].pNext, allowed_structs_VkBufferImageCopy2.size(), allowed_structs_VkBufferImageCopy2.data(), GeneratedVulkanHeaderVersion, "VUID-VkBufferImageCopy2-pNext-pNext", "VUID-VkBufferImageCopy2-sType-unique", false, true);

                skip |= ValidateFlags("vkCmdCopyImageToBuffer2", ParameterName("pCopyImageToBufferInfo->pRegions[%i].imageSubresource.aspectMask", ParameterName::IndexVector{ regionIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pCopyImageToBufferInfo->pRegions[regionIndex].imageSubresource.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceLayers-aspectMask-parameter", "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

                // No xml-driven validation

                // No xml-driven validation
            }
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBlitImage2(
    VkCommandBuffer                             commandBuffer,
    const VkBlitImageInfo2*                     pBlitImageInfo) const {
    bool skip = false;
    skip |= ValidateStructType("vkCmdBlitImage2", "pBlitImageInfo", "VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2", pBlitImageInfo, VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2, true, "VUID-vkCmdBlitImage2-pBlitImageInfo-parameter", "VUID-VkBlitImageInfo2-sType-sType");
    if (pBlitImageInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCmdBlitImage2", "pBlitImageInfo->pNext", nullptr, pBlitImageInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkBlitImageInfo2-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle("vkCmdBlitImage2", "pBlitImageInfo->srcImage", pBlitImageInfo->srcImage);

        skip |= ValidateRangedEnum("vkCmdBlitImage2", "pBlitImageInfo->srcImageLayout", "VkImageLayout", AllVkImageLayoutEnums, pBlitImageInfo->srcImageLayout, "VUID-VkBlitImageInfo2-srcImageLayout-parameter");

        skip |= ValidateRequiredHandle("vkCmdBlitImage2", "pBlitImageInfo->dstImage", pBlitImageInfo->dstImage);

        skip |= ValidateRangedEnum("vkCmdBlitImage2", "pBlitImageInfo->dstImageLayout", "VkImageLayout", AllVkImageLayoutEnums, pBlitImageInfo->dstImageLayout, "VUID-VkBlitImageInfo2-dstImageLayout-parameter");

        skip |= ValidateStructTypeArray("vkCmdBlitImage2", "pBlitImageInfo->regionCount", "pBlitImageInfo->pRegions", "VK_STRUCTURE_TYPE_IMAGE_BLIT_2", pBlitImageInfo->regionCount, pBlitImageInfo->pRegions, VK_STRUCTURE_TYPE_IMAGE_BLIT_2, true, true, "VUID-VkImageBlit2-sType-sType", "VUID-VkBlitImageInfo2-pRegions-parameter", "VUID-VkBlitImageInfo2-regionCount-arraylength");

        if (pBlitImageInfo->pRegions != nullptr)
        {
            for (uint32_t regionIndex = 0; regionIndex < pBlitImageInfo->regionCount; ++regionIndex)
            {
                constexpr std::array allowed_structs_VkImageBlit2 = { VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM };

                skip |= ValidateStructPnext("vkCmdBlitImage2", ParameterName("pBlitImageInfo->pRegions[%i].pNext", ParameterName::IndexVector{ regionIndex }), "VkCopyCommandTransformInfoQCOM", pBlitImageInfo->pRegions[regionIndex].pNext, allowed_structs_VkImageBlit2.size(), allowed_structs_VkImageBlit2.data(), GeneratedVulkanHeaderVersion, "VUID-VkImageBlit2-pNext-pNext", "VUID-VkImageBlit2-sType-unique", false, true);

                skip |= ValidateFlags("vkCmdBlitImage2", ParameterName("pBlitImageInfo->pRegions[%i].srcSubresource.aspectMask", ParameterName::IndexVector{ regionIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pBlitImageInfo->pRegions[regionIndex].srcSubresource.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceLayers-aspectMask-parameter", "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

                skip |= ValidateFlags("vkCmdBlitImage2", ParameterName("pBlitImageInfo->pRegions[%i].dstSubresource.aspectMask", ParameterName::IndexVector{ regionIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pBlitImageInfo->pRegions[regionIndex].dstSubresource.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceLayers-aspectMask-parameter", "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");
            }
        }

        skip |= ValidateRangedEnum("vkCmdBlitImage2", "pBlitImageInfo->filter", "VkFilter", AllVkFilterEnums, pBlitImageInfo->filter, "VUID-VkBlitImageInfo2-filter-parameter");
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdResolveImage2(
    VkCommandBuffer                             commandBuffer,
    const VkResolveImageInfo2*                  pResolveImageInfo) const {
    bool skip = false;
    skip |= ValidateStructType("vkCmdResolveImage2", "pResolveImageInfo", "VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2", pResolveImageInfo, VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2, true, "VUID-vkCmdResolveImage2-pResolveImageInfo-parameter", "VUID-VkResolveImageInfo2-sType-sType");
    if (pResolveImageInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCmdResolveImage2", "pResolveImageInfo->pNext", nullptr, pResolveImageInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkResolveImageInfo2-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle("vkCmdResolveImage2", "pResolveImageInfo->srcImage", pResolveImageInfo->srcImage);

        skip |= ValidateRangedEnum("vkCmdResolveImage2", "pResolveImageInfo->srcImageLayout", "VkImageLayout", AllVkImageLayoutEnums, pResolveImageInfo->srcImageLayout, "VUID-VkResolveImageInfo2-srcImageLayout-parameter");

        skip |= ValidateRequiredHandle("vkCmdResolveImage2", "pResolveImageInfo->dstImage", pResolveImageInfo->dstImage);

        skip |= ValidateRangedEnum("vkCmdResolveImage2", "pResolveImageInfo->dstImageLayout", "VkImageLayout", AllVkImageLayoutEnums, pResolveImageInfo->dstImageLayout, "VUID-VkResolveImageInfo2-dstImageLayout-parameter");

        skip |= ValidateStructTypeArray("vkCmdResolveImage2", "pResolveImageInfo->regionCount", "pResolveImageInfo->pRegions", "VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2", pResolveImageInfo->regionCount, pResolveImageInfo->pRegions, VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2, true, true, "VUID-VkImageResolve2-sType-sType", "VUID-VkResolveImageInfo2-pRegions-parameter", "VUID-VkResolveImageInfo2-regionCount-arraylength");

        if (pResolveImageInfo->pRegions != nullptr)
        {
            for (uint32_t regionIndex = 0; regionIndex < pResolveImageInfo->regionCount; ++regionIndex)
            {
                skip |= ValidateStructPnext("vkCmdResolveImage2", ParameterName("pResolveImageInfo->pRegions[%i].pNext", ParameterName::IndexVector{ regionIndex }), nullptr, pResolveImageInfo->pRegions[regionIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkImageResolve2-pNext-pNext", kVUIDUndefined, false, true);

                skip |= ValidateFlags("vkCmdResolveImage2", ParameterName("pResolveImageInfo->pRegions[%i].srcSubresource.aspectMask", ParameterName::IndexVector{ regionIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pResolveImageInfo->pRegions[regionIndex].srcSubresource.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceLayers-aspectMask-parameter", "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

                // No xml-driven validation

                skip |= ValidateFlags("vkCmdResolveImage2", ParameterName("pResolveImageInfo->pRegions[%i].dstSubresource.aspectMask", ParameterName::IndexVector{ regionIndex }), "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pResolveImageInfo->pRegions[regionIndex].dstSubresource.aspectMask, kRequiredFlags, "VUID-VkImageSubresourceLayers-aspectMask-parameter", "VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask");

                // No xml-driven validation

                // No xml-driven validation
            }
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBeginRendering(
    VkCommandBuffer                             commandBuffer,
    const VkRenderingInfo*                      pRenderingInfo) const {
    bool skip = false;
    skip |= ValidateStructType("vkCmdBeginRendering", "pRenderingInfo", "VK_STRUCTURE_TYPE_RENDERING_INFO", pRenderingInfo, VK_STRUCTURE_TYPE_RENDERING_INFO, true, "VUID-vkCmdBeginRendering-pRenderingInfo-parameter", "VUID-VkRenderingInfo-sType-sType");
    if (pRenderingInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkRenderingInfo = { VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO, VK_STRUCTURE_TYPE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_INFO_EXT, VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX, VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT, VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR };

        skip |= ValidateStructPnext("vkCmdBeginRendering", "pRenderingInfo->pNext", "VkDeviceGroupRenderPassBeginInfo, VkMultisampledRenderToSingleSampledInfoEXT, VkMultiviewPerViewAttributesInfoNVX, VkRenderingFragmentDensityMapAttachmentInfoEXT, VkRenderingFragmentShadingRateAttachmentInfoKHR", pRenderingInfo->pNext, allowed_structs_VkRenderingInfo.size(), allowed_structs_VkRenderingInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkRenderingInfo-pNext-pNext", "VUID-VkRenderingInfo-sType-unique", false, true);

        skip |= ValidateFlags("vkCmdBeginRendering", "pRenderingInfo->flags", "VkRenderingFlagBits", AllVkRenderingFlagBits, pRenderingInfo->flags, kOptionalFlags, "VUID-VkRenderingInfo-flags-parameter");

        // No xml-driven validation

        // No xml-driven validation

        skip |= ValidateStructTypeArray("vkCmdBeginRendering", "pRenderingInfo->colorAttachmentCount", "pRenderingInfo->pColorAttachments", "VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO", pRenderingInfo->colorAttachmentCount, pRenderingInfo->pColorAttachments, VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO, false, true, "VUID-VkRenderingAttachmentInfo-sType-sType", "VUID-VkRenderingInfo-pColorAttachments-parameter", kVUIDUndefined);

        if (pRenderingInfo->pColorAttachments != nullptr)
        {
            for (uint32_t colorAttachmentIndex = 0; colorAttachmentIndex < pRenderingInfo->colorAttachmentCount; ++colorAttachmentIndex)
            {
                skip |= ValidateStructPnext("vkCmdBeginRendering", ParameterName("pRenderingInfo->pColorAttachments[%i].pNext", ParameterName::IndexVector{ colorAttachmentIndex }), nullptr, pRenderingInfo->pColorAttachments[colorAttachmentIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkRenderingAttachmentInfo-pNext-pNext", kVUIDUndefined, false, true);

                skip |= ValidateRangedEnum("vkCmdBeginRendering", ParameterName("pRenderingInfo->pColorAttachments[%i].imageLayout", ParameterName::IndexVector{ colorAttachmentIndex }), "VkImageLayout", AllVkImageLayoutEnums, pRenderingInfo->pColorAttachments[colorAttachmentIndex].imageLayout, "VUID-VkRenderingAttachmentInfo-imageLayout-parameter");

                skip |= ValidateFlags("vkCmdBeginRendering", ParameterName("pRenderingInfo->pColorAttachments[%i].resolveMode", ParameterName::IndexVector{ colorAttachmentIndex }), "VkResolveModeFlagBits", AllVkResolveModeFlagBits, pRenderingInfo->pColorAttachments[colorAttachmentIndex].resolveMode, kOptionalSingleBit, "VUID-VkRenderingAttachmentInfo-resolveMode-parameter");

                skip |= ValidateRangedEnum("vkCmdBeginRendering", ParameterName("pRenderingInfo->pColorAttachments[%i].resolveImageLayout", ParameterName::IndexVector{ colorAttachmentIndex }), "VkImageLayout", AllVkImageLayoutEnums, pRenderingInfo->pColorAttachments[colorAttachmentIndex].resolveImageLayout, "VUID-VkRenderingAttachmentInfo-resolveImageLayout-parameter");

                skip |= ValidateRangedEnum("vkCmdBeginRendering", ParameterName("pRenderingInfo->pColorAttachments[%i].loadOp", ParameterName::IndexVector{ colorAttachmentIndex }), "VkAttachmentLoadOp", AllVkAttachmentLoadOpEnums, pRenderingInfo->pColorAttachments[colorAttachmentIndex].loadOp, "VUID-VkRenderingAttachmentInfo-loadOp-parameter");

                skip |= ValidateRangedEnum("vkCmdBeginRendering", ParameterName("pRenderingInfo->pColorAttachments[%i].storeOp", ParameterName::IndexVector{ colorAttachmentIndex }), "VkAttachmentStoreOp", AllVkAttachmentStoreOpEnums, pRenderingInfo->pColorAttachments[colorAttachmentIndex].storeOp, "VUID-VkRenderingAttachmentInfo-storeOp-parameter");

                // No xml-driven validation
            }
        }

        skip |= ValidateStructType("vkCmdBeginRendering", "pRenderingInfo->pDepthAttachment", "VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO", pRenderingInfo->pDepthAttachment, VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO, false, "VUID-VkRenderingInfo-pDepthAttachment-parameter", "VUID-VkRenderingAttachmentInfo-sType-sType");

        if (pRenderingInfo->pDepthAttachment != nullptr)
        {
            skip |= ValidateStructPnext("vkCmdBeginRendering", "pRenderingInfo->pDepthAttachment->pNext", nullptr, pRenderingInfo->pDepthAttachment->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkRenderingAttachmentInfo-pNext-pNext", kVUIDUndefined, false, true);

            skip |= ValidateRangedEnum("vkCmdBeginRendering", "pRenderingInfo->pDepthAttachment->imageLayout", "VkImageLayout", AllVkImageLayoutEnums, pRenderingInfo->pDepthAttachment->imageLayout, "VUID-VkRenderingAttachmentInfo-imageLayout-parameter");

            skip |= ValidateFlags("vkCmdBeginRendering", "pRenderingInfo->pDepthAttachment->resolveMode", "VkResolveModeFlagBits", AllVkResolveModeFlagBits, pRenderingInfo->pDepthAttachment->resolveMode, kOptionalSingleBit, "VUID-VkRenderingAttachmentInfo-resolveMode-parameter");

            skip |= ValidateRangedEnum("vkCmdBeginRendering", "pRenderingInfo->pDepthAttachment->resolveImageLayout", "VkImageLayout", AllVkImageLayoutEnums, pRenderingInfo->pDepthAttachment->resolveImageLayout, "VUID-VkRenderingAttachmentInfo-resolveImageLayout-parameter");

            skip |= ValidateRangedEnum("vkCmdBeginRendering", "pRenderingInfo->pDepthAttachment->loadOp", "VkAttachmentLoadOp", AllVkAttachmentLoadOpEnums, pRenderingInfo->pDepthAttachment->loadOp, "VUID-VkRenderingAttachmentInfo-loadOp-parameter");

            skip |= ValidateRangedEnum("vkCmdBeginRendering", "pRenderingInfo->pDepthAttachment->storeOp", "VkAttachmentStoreOp", AllVkAttachmentStoreOpEnums, pRenderingInfo->pDepthAttachment->storeOp, "VUID-VkRenderingAttachmentInfo-storeOp-parameter");

            // No xml-driven validation
        }

        skip |= ValidateStructType("vkCmdBeginRendering", "pRenderingInfo->pStencilAttachment", "VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO", pRenderingInfo->pStencilAttachment, VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO, false, "VUID-VkRenderingInfo-pStencilAttachment-parameter", "VUID-VkRenderingAttachmentInfo-sType-sType");

        if (pRenderingInfo->pStencilAttachment != nullptr)
        {
            skip |= ValidateStructPnext("vkCmdBeginRendering", "pRenderingInfo->pStencilAttachment->pNext", nullptr, pRenderingInfo->pStencilAttachment->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkRenderingAttachmentInfo-pNext-pNext", kVUIDUndefined, false, true);

            skip |= ValidateRangedEnum("vkCmdBeginRendering", "pRenderingInfo->pStencilAttachment->imageLayout", "VkImageLayout", AllVkImageLayoutEnums, pRenderingInfo->pStencilAttachment->imageLayout, "VUID-VkRenderingAttachmentInfo-imageLayout-parameter");

            skip |= ValidateFlags("vkCmdBeginRendering", "pRenderingInfo->pStencilAttachment->resolveMode", "VkResolveModeFlagBits", AllVkResolveModeFlagBits, pRenderingInfo->pStencilAttachment->resolveMode, kOptionalSingleBit, "VUID-VkRenderingAttachmentInfo-resolveMode-parameter");

            skip |= ValidateRangedEnum("vkCmdBeginRendering", "pRenderingInfo->pStencilAttachment->resolveImageLayout", "VkImageLayout", AllVkImageLayoutEnums, pRenderingInfo->pStencilAttachment->resolveImageLayout, "VUID-VkRenderingAttachmentInfo-resolveImageLayout-parameter");

            skip |= ValidateRangedEnum("vkCmdBeginRendering", "pRenderingInfo->pStencilAttachment->loadOp", "VkAttachmentLoadOp", AllVkAttachmentLoadOpEnums, pRenderingInfo->pStencilAttachment->loadOp, "VUID-VkRenderingAttachmentInfo-loadOp-parameter");

            skip |= ValidateRangedEnum("vkCmdBeginRendering", "pRenderingInfo->pStencilAttachment->storeOp", "VkAttachmentStoreOp", AllVkAttachmentStoreOpEnums, pRenderingInfo->pStencilAttachment->storeOp, "VUID-VkRenderingAttachmentInfo-storeOp-parameter");

            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdEndRendering(
    VkCommandBuffer                             commandBuffer) const {
    bool skip = false;
    // No xml-driven validation
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetCullMode(
    VkCommandBuffer                             commandBuffer,
    VkCullModeFlags                             cullMode) const {
    bool skip = false;
    skip |= ValidateFlags("vkCmdSetCullMode", "cullMode", "VkCullModeFlagBits", AllVkCullModeFlagBits, cullMode, kOptionalFlags, "VUID-vkCmdSetCullMode-cullMode-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetFrontFace(
    VkCommandBuffer                             commandBuffer,
    VkFrontFace                                 frontFace) const {
    bool skip = false;
    skip |= ValidateRangedEnum("vkCmdSetFrontFace", "frontFace", "VkFrontFace", AllVkFrontFaceEnums, frontFace, "VUID-vkCmdSetFrontFace-frontFace-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetPrimitiveTopology(
    VkCommandBuffer                             commandBuffer,
    VkPrimitiveTopology                         primitiveTopology) const {
    bool skip = false;
    skip |= ValidateRangedEnum("vkCmdSetPrimitiveTopology", "primitiveTopology", "VkPrimitiveTopology", AllVkPrimitiveTopologyEnums, primitiveTopology, "VUID-vkCmdSetPrimitiveTopology-primitiveTopology-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetViewportWithCount(
    VkCommandBuffer                             commandBuffer,
    uint32_t                                    viewportCount,
    const VkViewport*                           pViewports) const {
    bool skip = false;
    skip |= ValidateArray("vkCmdSetViewportWithCount", "viewportCount", "pViewports", viewportCount, &pViewports, true, true, "VUID-vkCmdSetViewportWithCount-viewportCount-arraylength", "VUID-vkCmdSetViewportWithCount-pViewports-parameter");
    if (pViewports != nullptr)
    {
        for (uint32_t viewportIndex = 0; viewportIndex < viewportCount; ++viewportIndex)
        {
            // No xml-driven validation
        }
    }
    if (!skip) skip |= manual_PreCallValidateCmdSetViewportWithCount(commandBuffer, viewportCount, pViewports);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetScissorWithCount(
    VkCommandBuffer                             commandBuffer,
    uint32_t                                    scissorCount,
    const VkRect2D*                             pScissors) const {
    bool skip = false;
    skip |= ValidateArray("vkCmdSetScissorWithCount", "scissorCount", "pScissors", scissorCount, &pScissors, true, true, "VUID-vkCmdSetScissorWithCount-scissorCount-arraylength", "VUID-vkCmdSetScissorWithCount-pScissors-parameter");
    if (pScissors != nullptr)
    {
        for (uint32_t scissorIndex = 0; scissorIndex < scissorCount; ++scissorIndex)
        {
            // No xml-driven validation

            // No xml-driven validation
        }
    }
    if (!skip) skip |= manual_PreCallValidateCmdSetScissorWithCount(commandBuffer, scissorCount, pScissors);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBindVertexBuffers2(
    VkCommandBuffer                             commandBuffer,
    uint32_t                                    firstBinding,
    uint32_t                                    bindingCount,
    const VkBuffer*                             pBuffers,
    const VkDeviceSize*                         pOffsets,
    const VkDeviceSize*                         pSizes,
    const VkDeviceSize*                         pStrides) const {
    bool skip = false;
    // No xml-driven validation
    if (!skip) skip |= manual_PreCallValidateCmdBindVertexBuffers2(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetDepthTestEnable(
    VkCommandBuffer                             commandBuffer,
    VkBool32                                    depthTestEnable) const {
    bool skip = false;
    skip |= ValidateBool32("vkCmdSetDepthTestEnable", "depthTestEnable", depthTestEnable);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetDepthWriteEnable(
    VkCommandBuffer                             commandBuffer,
    VkBool32                                    depthWriteEnable) const {
    bool skip = false;
    skip |= ValidateBool32("vkCmdSetDepthWriteEnable", "depthWriteEnable", depthWriteEnable);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetDepthCompareOp(
    VkCommandBuffer                             commandBuffer,
    VkCompareOp                                 depthCompareOp) const {
    bool skip = false;
    skip |= ValidateRangedEnum("vkCmdSetDepthCompareOp", "depthCompareOp", "VkCompareOp", AllVkCompareOpEnums, depthCompareOp, "VUID-vkCmdSetDepthCompareOp-depthCompareOp-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetDepthBoundsTestEnable(
    VkCommandBuffer                             commandBuffer,
    VkBool32                                    depthBoundsTestEnable) const {
    bool skip = false;
    skip |= ValidateBool32("vkCmdSetDepthBoundsTestEnable", "depthBoundsTestEnable", depthBoundsTestEnable);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetStencilTestEnable(
    VkCommandBuffer                             commandBuffer,
    VkBool32                                    stencilTestEnable) const {
    bool skip = false;
    skip |= ValidateBool32("vkCmdSetStencilTestEnable", "stencilTestEnable", stencilTestEnable);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetStencilOp(
    VkCommandBuffer                             commandBuffer,
    VkStencilFaceFlags                          faceMask,
    VkStencilOp                                 failOp,
    VkStencilOp                                 passOp,
    VkStencilOp                                 depthFailOp,
    VkCompareOp                                 compareOp) const {
    bool skip = false;
    skip |= ValidateFlags("vkCmdSetStencilOp", "faceMask", "VkStencilFaceFlagBits", AllVkStencilFaceFlagBits, faceMask, kRequiredFlags, "VUID-vkCmdSetStencilOp-faceMask-parameter", "VUID-vkCmdSetStencilOp-faceMask-requiredbitmask");
    skip |= ValidateRangedEnum("vkCmdSetStencilOp", "failOp", "VkStencilOp", AllVkStencilOpEnums, failOp, "VUID-vkCmdSetStencilOp-failOp-parameter");
    skip |= ValidateRangedEnum("vkCmdSetStencilOp", "passOp", "VkStencilOp", AllVkStencilOpEnums, passOp, "VUID-vkCmdSetStencilOp-passOp-parameter");
    skip |= ValidateRangedEnum("vkCmdSetStencilOp", "depthFailOp", "VkStencilOp", AllVkStencilOpEnums, depthFailOp, "VUID-vkCmdSetStencilOp-depthFailOp-parameter");
    skip |= ValidateRangedEnum("vkCmdSetStencilOp", "compareOp", "VkCompareOp", AllVkCompareOpEnums, compareOp, "VUID-vkCmdSetStencilOp-compareOp-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetRasterizerDiscardEnable(
    VkCommandBuffer                             commandBuffer,
    VkBool32                                    rasterizerDiscardEnable) const {
    bool skip = false;
    skip |= ValidateBool32("vkCmdSetRasterizerDiscardEnable", "rasterizerDiscardEnable", rasterizerDiscardEnable);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetDepthBiasEnable(
    VkCommandBuffer                             commandBuffer,
    VkBool32                                    depthBiasEnable) const {
    bool skip = false;
    skip |= ValidateBool32("vkCmdSetDepthBiasEnable", "depthBiasEnable", depthBiasEnable);
    return skip;
}

bool StatelessValidation::PreCallValidateCmdSetPrimitiveRestartEnable(
    VkCommandBuffer                             commandBuffer,
    VkBool32                                    primitiveRestartEnable) const {
    bool skip = false;
    skip |= ValidateBool32("vkCmdSetPrimitiveRestartEnable", "primitiveRestartEnable", primitiveRestartEnable);
    return skip;
}

bool StatelessValidation::PreCallValidateGetDeviceBufferMemoryRequirements(
    VkDevice                                    device,
    const VkDeviceBufferMemoryRequirements*     pInfo,
    VkMemoryRequirements2*                      pMemoryRequirements) const {
    bool skip = false;
    skip |= ValidateStructType("vkGetDeviceBufferMemoryRequirements", "pInfo", "VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS", pInfo, VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS, true, "VUID-vkGetDeviceBufferMemoryRequirements-pInfo-parameter", "VUID-VkDeviceBufferMemoryRequirements-sType-sType");
    if (pInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkGetDeviceBufferMemoryRequirements", "pInfo->pNext", nullptr, pInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkDeviceBufferMemoryRequirements-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateStructType("vkGetDeviceBufferMemoryRequirements", "pInfo->pCreateInfo", "VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO", pInfo->pCreateInfo, VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO, true, "VUID-VkDeviceBufferMemoryRequirements-pCreateInfo-parameter", "VUID-VkBufferCreateInfo-sType-sType");

        if (pInfo->pCreateInfo != nullptr)
        {
            constexpr std::array allowed_structs_VkBufferCreateInfo = { VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA, VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO, VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV, VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO, VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR };

            skip |= ValidateStructPnext("vkGetDeviceBufferMemoryRequirements", "pInfo->pCreateInfo->pNext", "VkBufferCollectionBufferCreateInfoFUCHSIA, VkBufferDeviceAddressCreateInfoEXT, VkBufferOpaqueCaptureAddressCreateInfo, VkDedicatedAllocationBufferCreateInfoNV, VkExternalMemoryBufferCreateInfo, VkOpaqueCaptureDescriptorDataCreateInfoEXT, VkVideoProfileListInfoKHR", pInfo->pCreateInfo->pNext, allowed_structs_VkBufferCreateInfo.size(), allowed_structs_VkBufferCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkBufferCreateInfo-pNext-pNext", "VUID-VkBufferCreateInfo-sType-unique", false, true);

            skip |= ValidateFlags("vkGetDeviceBufferMemoryRequirements", "pInfo->pCreateInfo->flags", "VkBufferCreateFlagBits", AllVkBufferCreateFlagBits, pInfo->pCreateInfo->flags, kOptionalFlags, "VUID-VkBufferCreateInfo-flags-parameter");

            skip |= ValidateFlags("vkGetDeviceBufferMemoryRequirements", "pInfo->pCreateInfo->usage", "VkBufferUsageFlagBits", AllVkBufferUsageFlagBits, pInfo->pCreateInfo->usage, kRequiredFlags, "VUID-VkBufferCreateInfo-usage-parameter", "VUID-VkBufferCreateInfo-usage-requiredbitmask");

            skip |= ValidateRangedEnum("vkGetDeviceBufferMemoryRequirements", "pInfo->pCreateInfo->sharingMode", "VkSharingMode", AllVkSharingModeEnums, pInfo->pCreateInfo->sharingMode, "VUID-VkBufferCreateInfo-sharingMode-parameter");
        }
    }
    skip |= ValidateStructType("vkGetDeviceBufferMemoryRequirements", "pMemoryRequirements", "VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2", pMemoryRequirements, VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2, true, "VUID-vkGetDeviceBufferMemoryRequirements-pMemoryRequirements-parameter", "VUID-VkMemoryRequirements2-sType-sType");
    if (pMemoryRequirements != nullptr)
    {
        constexpr std::array allowed_structs_VkMemoryRequirements2 = { VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS };

        skip |= ValidateStructPnext("vkGetDeviceBufferMemoryRequirements", "pMemoryRequirements->pNext", "VkMemoryDedicatedRequirements", pMemoryRequirements->pNext, allowed_structs_VkMemoryRequirements2.size(), allowed_structs_VkMemoryRequirements2.data(), GeneratedVulkanHeaderVersion, "VUID-VkMemoryRequirements2-pNext-pNext", "VUID-VkMemoryRequirements2-sType-unique", false, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetDeviceImageMemoryRequirements(
    VkDevice                                    device,
    const VkDeviceImageMemoryRequirements*      pInfo,
    VkMemoryRequirements2*                      pMemoryRequirements) const {
    bool skip = false;
    skip |= ValidateStructType("vkGetDeviceImageMemoryRequirements", "pInfo", "VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS", pInfo, VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS, true, "VUID-vkGetDeviceImageMemoryRequirements-pInfo-parameter", "VUID-VkDeviceImageMemoryRequirements-sType-sType");
    if (pInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkGetDeviceImageMemoryRequirements", "pInfo->pNext", nullptr, pInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkDeviceImageMemoryRequirements-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateStructType("vkGetDeviceImageMemoryRequirements", "pInfo->pCreateInfo", "VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO", pInfo->pCreateInfo, VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO, true, "VUID-VkDeviceImageMemoryRequirements-pCreateInfo-parameter", "VUID-VkImageCreateInfo-sType-sType");

        if (pInfo->pCreateInfo != nullptr)
        {
            constexpr std::array allowed_structs_VkImageCreateInfo = { VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA, VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV, VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID, VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO, VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV, VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT, VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO, VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO, VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR, VK_STRUCTURE_TYPE_IMPORT_METAL_IO_SURFACE_INFO_EXT, VK_STRUCTURE_TYPE_IMPORT_METAL_TEXTURE_INFO_EXT, VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_INFO_NV, VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR };

            skip |= ValidateStructPnext("vkGetDeviceImageMemoryRequirements", "pInfo->pCreateInfo->pNext", "VkBufferCollectionImageCreateInfoFUCHSIA, VkDedicatedAllocationImageCreateInfoNV, VkExportMetalObjectCreateInfoEXT, VkExternalFormatANDROID, VkExternalMemoryImageCreateInfo, VkExternalMemoryImageCreateInfoNV, VkImageCompressionControlEXT, VkImageDrmFormatModifierExplicitCreateInfoEXT, VkImageDrmFormatModifierListCreateInfoEXT, VkImageFormatListCreateInfo, VkImageStencilUsageCreateInfo, VkImageSwapchainCreateInfoKHR, VkImportMetalIOSurfaceInfoEXT, VkImportMetalTextureInfoEXT, VkOpaqueCaptureDescriptorDataCreateInfoEXT, VkOpticalFlowImageFormatInfoNV, VkVideoProfileListInfoKHR", pInfo->pCreateInfo->pNext, allowed_structs_VkImageCreateInfo.size(), allowed_structs_VkImageCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkImageCreateInfo-pNext-pNext", "VUID-VkImageCreateInfo-sType-unique", false, true);

            skip |= ValidateFlags("vkGetDeviceImageMemoryRequirements", "pInfo->pCreateInfo->flags", "VkImageCreateFlagBits", AllVkImageCreateFlagBits, pInfo->pCreateInfo->flags, kOptionalFlags, "VUID-VkImageCreateInfo-flags-parameter");

            skip |= ValidateRangedEnum("vkGetDeviceImageMemoryRequirements", "pInfo->pCreateInfo->imageType", "VkImageType", AllVkImageTypeEnums, pInfo->pCreateInfo->imageType, "VUID-VkImageCreateInfo-imageType-parameter");

            skip |= ValidateRangedEnum("vkGetDeviceImageMemoryRequirements", "pInfo->pCreateInfo->format", "VkFormat", AllVkFormatEnums, pInfo->pCreateInfo->format, "VUID-VkImageCreateInfo-format-parameter");

            // No xml-driven validation

            skip |= ValidateFlags("vkGetDeviceImageMemoryRequirements", "pInfo->pCreateInfo->samples", "VkSampleCountFlagBits", AllVkSampleCountFlagBits, pInfo->pCreateInfo->samples, kRequiredSingleBit, "VUID-VkImageCreateInfo-samples-parameter", "VUID-VkImageCreateInfo-samples-parameter");

            skip |= ValidateRangedEnum("vkGetDeviceImageMemoryRequirements", "pInfo->pCreateInfo->tiling", "VkImageTiling", AllVkImageTilingEnums, pInfo->pCreateInfo->tiling, "VUID-VkImageCreateInfo-tiling-parameter");

            skip |= ValidateFlags("vkGetDeviceImageMemoryRequirements", "pInfo->pCreateInfo->usage", "VkImageUsageFlagBits", AllVkImageUsageFlagBits, pInfo->pCreateInfo->usage, kRequiredFlags, "VUID-VkImageCreateInfo-usage-parameter", "VUID-VkImageCreateInfo-usage-requiredbitmask");

            skip |= ValidateRangedEnum("vkGetDeviceImageMemoryRequirements", "pInfo->pCreateInfo->sharingMode", "VkSharingMode", AllVkSharingModeEnums, pInfo->pCreateInfo->sharingMode, "VUID-VkImageCreateInfo-sharingMode-parameter");

            skip |= ValidateRangedEnum("vkGetDeviceImageMemoryRequirements", "pInfo->pCreateInfo->initialLayout", "VkImageLayout", AllVkImageLayoutEnums, pInfo->pCreateInfo->initialLayout, "VUID-VkImageCreateInfo-initialLayout-parameter");
        }

        skip |= ValidateFlags("vkGetDeviceImageMemoryRequirements", "pInfo->planeAspect", "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pInfo->planeAspect, kOptionalSingleBit, "VUID-VkDeviceImageMemoryRequirements-planeAspect-parameter");
    }
    skip |= ValidateStructType("vkGetDeviceImageMemoryRequirements", "pMemoryRequirements", "VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2", pMemoryRequirements, VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2, true, "VUID-vkGetDeviceImageMemoryRequirements-pMemoryRequirements-parameter", "VUID-VkMemoryRequirements2-sType-sType");
    if (pMemoryRequirements != nullptr)
    {
        constexpr std::array allowed_structs_VkMemoryRequirements2 = { VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS };

        skip |= ValidateStructPnext("vkGetDeviceImageMemoryRequirements", "pMemoryRequirements->pNext", "VkMemoryDedicatedRequirements", pMemoryRequirements->pNext, allowed_structs_VkMemoryRequirements2.size(), allowed_structs_VkMemoryRequirements2.data(), GeneratedVulkanHeaderVersion, "VUID-VkMemoryRequirements2-pNext-pNext", "VUID-VkMemoryRequirements2-sType-unique", false, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetDeviceImageSparseMemoryRequirements(
    VkDevice                                    device,
    const VkDeviceImageMemoryRequirements*      pInfo,
    uint32_t*                                   pSparseMemoryRequirementCount,
    VkSparseImageMemoryRequirements2*           pSparseMemoryRequirements) const {
    bool skip = false;
    skip |= ValidateStructType("vkGetDeviceImageSparseMemoryRequirements", "pInfo", "VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS", pInfo, VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS, true, "VUID-vkGetDeviceImageSparseMemoryRequirements-pInfo-parameter", "VUID-VkDeviceImageMemoryRequirements-sType-sType");
    if (pInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkGetDeviceImageSparseMemoryRequirements", "pInfo->pNext", nullptr, pInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkDeviceImageMemoryRequirements-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateStructType("vkGetDeviceImageSparseMemoryRequirements", "pInfo->pCreateInfo", "VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO", pInfo->pCreateInfo, VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO, true, "VUID-VkDeviceImageMemoryRequirements-pCreateInfo-parameter", "VUID-VkImageCreateInfo-sType-sType");

        if (pInfo->pCreateInfo != nullptr)
        {
            constexpr std::array allowed_structs_VkImageCreateInfo = { VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA, VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV, VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID, VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO, VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV, VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT, VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO, VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO, VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR, VK_STRUCTURE_TYPE_IMPORT_METAL_IO_SURFACE_INFO_EXT, VK_STRUCTURE_TYPE_IMPORT_METAL_TEXTURE_INFO_EXT, VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_INFO_NV, VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR };

            skip |= ValidateStructPnext("vkGetDeviceImageSparseMemoryRequirements", "pInfo->pCreateInfo->pNext", "VkBufferCollectionImageCreateInfoFUCHSIA, VkDedicatedAllocationImageCreateInfoNV, VkExportMetalObjectCreateInfoEXT, VkExternalFormatANDROID, VkExternalMemoryImageCreateInfo, VkExternalMemoryImageCreateInfoNV, VkImageCompressionControlEXT, VkImageDrmFormatModifierExplicitCreateInfoEXT, VkImageDrmFormatModifierListCreateInfoEXT, VkImageFormatListCreateInfo, VkImageStencilUsageCreateInfo, VkImageSwapchainCreateInfoKHR, VkImportMetalIOSurfaceInfoEXT, VkImportMetalTextureInfoEXT, VkOpaqueCaptureDescriptorDataCreateInfoEXT, VkOpticalFlowImageFormatInfoNV, VkVideoProfileListInfoKHR", pInfo->pCreateInfo->pNext, allowed_structs_VkImageCreateInfo.size(), allowed_structs_VkImageCreateInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkImageCreateInfo-pNext-pNext", "VUID-VkImageCreateInfo-sType-unique", false, true);

            skip |= ValidateFlags("vkGetDeviceImageSparseMemoryRequirements", "pInfo->pCreateInfo->flags", "VkImageCreateFlagBits", AllVkImageCreateFlagBits, pInfo->pCreateInfo->flags, kOptionalFlags, "VUID-VkImageCreateInfo-flags-parameter");

            skip |= ValidateRangedEnum("vkGetDeviceImageSparseMemoryRequirements", "pInfo->pCreateInfo->imageType", "VkImageType", AllVkImageTypeEnums, pInfo->pCreateInfo->imageType, "VUID-VkImageCreateInfo-imageType-parameter");

            skip |= ValidateRangedEnum("vkGetDeviceImageSparseMemoryRequirements", "pInfo->pCreateInfo->format", "VkFormat", AllVkFormatEnums, pInfo->pCreateInfo->format, "VUID-VkImageCreateInfo-format-parameter");

            // No xml-driven validation

            skip |= ValidateFlags("vkGetDeviceImageSparseMemoryRequirements", "pInfo->pCreateInfo->samples", "VkSampleCountFlagBits", AllVkSampleCountFlagBits, pInfo->pCreateInfo->samples, kRequiredSingleBit, "VUID-VkImageCreateInfo-samples-parameter", "VUID-VkImageCreateInfo-samples-parameter");

            skip |= ValidateRangedEnum("vkGetDeviceImageSparseMemoryRequirements", "pInfo->pCreateInfo->tiling", "VkImageTiling", AllVkImageTilingEnums, pInfo->pCreateInfo->tiling, "VUID-VkImageCreateInfo-tiling-parameter");

            skip |= ValidateFlags("vkGetDeviceImageSparseMemoryRequirements", "pInfo->pCreateInfo->usage", "VkImageUsageFlagBits", AllVkImageUsageFlagBits, pInfo->pCreateInfo->usage, kRequiredFlags, "VUID-VkImageCreateInfo-usage-parameter", "VUID-VkImageCreateInfo-usage-requiredbitmask");

            skip |= ValidateRangedEnum("vkGetDeviceImageSparseMemoryRequirements", "pInfo->pCreateInfo->sharingMode", "VkSharingMode", AllVkSharingModeEnums, pInfo->pCreateInfo->sharingMode, "VUID-VkImageCreateInfo-sharingMode-parameter");

            skip |= ValidateRangedEnum("vkGetDeviceImageSparseMemoryRequirements", "pInfo->pCreateInfo->initialLayout", "VkImageLayout", AllVkImageLayoutEnums, pInfo->pCreateInfo->initialLayout, "VUID-VkImageCreateInfo-initialLayout-parameter");
        }

        skip |= ValidateFlags("vkGetDeviceImageSparseMemoryRequirements", "pInfo->planeAspect", "VkImageAspectFlagBits", AllVkImageAspectFlagBits, pInfo->planeAspect, kOptionalSingleBit, "VUID-VkDeviceImageMemoryRequirements-planeAspect-parameter");
    }
    skip |= ValidateStructTypeArray("vkGetDeviceImageSparseMemoryRequirements", "pSparseMemoryRequirementCount", "pSparseMemoryRequirements", "VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2", pSparseMemoryRequirementCount, pSparseMemoryRequirements, VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2, true, false, false, "VUID-VkSparseImageMemoryRequirements2-sType-sType", "VUID-vkGetDeviceImageSparseMemoryRequirements-pSparseMemoryRequirements-parameter", kVUIDUndefined);
    if (pSparseMemoryRequirements != nullptr)
    {
        for (uint32_t pSparseMemoryRequirementIndex = 0; pSparseMemoryRequirementIndex < *pSparseMemoryRequirementCount; ++pSparseMemoryRequirementIndex)
        {
            skip |= ValidateStructPnext("vkGetDeviceImageSparseMemoryRequirements", ParameterName("pSparseMemoryRequirements[%i].pNext", ParameterName::IndexVector{ pSparseMemoryRequirementIndex }), nullptr, pSparseMemoryRequirements[pSparseMemoryRequirementIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkSparseImageMemoryRequirements2-pNext-pNext", kVUIDUndefined, false, false);
        }
    }
    return skip;
}



bool StatelessValidation::PreCallValidateDestroySurfaceKHR(
    VkInstance                                  instance,
    VkSurfaceKHR                                surface,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkDestroySurfaceKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroySurfaceKHR", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroySurfaceKHR", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroySurfaceKHR", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroySurfaceKHR", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroySurfaceKHR", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceSurfaceSupportKHR(
    VkPhysicalDevice                            physicalDevice,
    uint32_t                                    queueFamilyIndex,
    VkSurfaceKHR                                surface,
    VkBool32*                                   pSupported) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkGetPhysicalDeviceSurfaceSupportKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    skip |= ValidateRequiredHandle("vkGetPhysicalDeviceSurfaceSupportKHR", "surface", surface);
    skip |= ValidateRequiredPointer("vkGetPhysicalDeviceSurfaceSupportKHR", "pSupported", pSupported, "VUID-vkGetPhysicalDeviceSurfaceSupportKHR-pSupported-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceSurfaceCapabilitiesKHR(
    VkPhysicalDevice                            physicalDevice,
    VkSurfaceKHR                                surface,
    VkSurfaceCapabilitiesKHR*                   pSurfaceCapabilities) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkGetPhysicalDeviceSurfaceCapabilitiesKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    skip |= ValidateRequiredHandle("vkGetPhysicalDeviceSurfaceCapabilitiesKHR", "surface", surface);
    skip |= ValidateRequiredPointer("vkGetPhysicalDeviceSurfaceCapabilitiesKHR", "pSurfaceCapabilities", pSurfaceCapabilities, "VUID-vkGetPhysicalDeviceSurfaceCapabilitiesKHR-pSurfaceCapabilities-parameter");
    if (pSurfaceCapabilities != nullptr)
    {
        // No xml-driven validation
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceSurfaceFormatsKHR(
    VkPhysicalDevice                            physicalDevice,
    VkSurfaceKHR                                surface,
    uint32_t*                                   pSurfaceFormatCount,
    VkSurfaceFormatKHR*                         pSurfaceFormats) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkGetPhysicalDeviceSurfaceFormatsKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    skip |= ValidateArray("vkGetPhysicalDeviceSurfaceFormatsKHR", "pSurfaceFormatCount", "pSurfaceFormats", pSurfaceFormatCount, &pSurfaceFormats, true, false, false, kVUIDUndefined, "VUID-vkGetPhysicalDeviceSurfaceFormatsKHR-pSurfaceFormats-parameter");
    if (pSurfaceFormats != nullptr)
    {
        for (uint32_t pSurfaceFormatIndex = 0; pSurfaceFormatIndex < *pSurfaceFormatCount; ++pSurfaceFormatIndex)
        {
            // No xml-driven validation
        }
    }
    if (!skip) skip |= manual_PreCallValidateGetPhysicalDeviceSurfaceFormatsKHR(physicalDevice, surface, pSurfaceFormatCount, pSurfaceFormats);
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceSurfacePresentModesKHR(
    VkPhysicalDevice                            physicalDevice,
    VkSurfaceKHR                                surface,
    uint32_t*                                   pPresentModeCount,
    VkPresentModeKHR*                           pPresentModes) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkGetPhysicalDeviceSurfacePresentModesKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    skip |= ValidateArray("vkGetPhysicalDeviceSurfacePresentModesKHR", "pPresentModeCount", "pPresentModes", pPresentModeCount, &pPresentModes, true, false, false, kVUIDUndefined, "VUID-vkGetPhysicalDeviceSurfacePresentModesKHR-pPresentModes-parameter");
    if (!skip) skip |= manual_PreCallValidateGetPhysicalDeviceSurfacePresentModesKHR(physicalDevice, surface, pPresentModeCount, pPresentModes);
    return skip;
}



bool StatelessValidation::PreCallValidateCreateSwapchainKHR(
    VkDevice                                    device,
    const VkSwapchainCreateInfoKHR*             pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkSwapchainKHR*                             pSwapchain) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_surface)) skip |= OutputExtensionError("vkCreateSwapchainKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_swapchain)) skip |= OutputExtensionError("vkCreateSwapchainKHR", VK_KHR_SWAPCHAIN_EXTENSION_NAME);
    skip |= ValidateStructType("vkCreateSwapchainKHR", "pCreateInfo", "VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR", pCreateInfo, VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR, true, "VUID-vkCreateSwapchainKHR-pCreateInfo-parameter", "VUID-VkSwapchainCreateInfoKHR-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkSwapchainCreateInfoKHR = { VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR, VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT, VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO, VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT, VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT, VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD, VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_BARRIER_CREATE_INFO_NV, VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_EXT };

        skip |= ValidateStructPnext("vkCreateSwapchainKHR", "pCreateInfo->pNext", "VkDeviceGroupSwapchainCreateInfoKHR, VkImageCompressionControlEXT, VkImageFormatListCreateInfo, VkSurfaceFullScreenExclusiveInfoEXT, VkSurfaceFullScreenExclusiveWin32InfoEXT, VkSwapchainCounterCreateInfoEXT, VkSwapchainDisplayNativeHdrCreateInfoAMD, VkSwapchainPresentBarrierCreateInfoNV, VkSwapchainPresentModesCreateInfoEXT, VkSwapchainPresentScalingCreateInfoEXT", pCreateInfo->pNext, allowed_structs_VkSwapchainCreateInfoKHR.size(), allowed_structs_VkSwapchainCreateInfoKHR.data(), GeneratedVulkanHeaderVersion, "VUID-VkSwapchainCreateInfoKHR-pNext-pNext", "VUID-VkSwapchainCreateInfoKHR-sType-unique", false, true);

        skip |= ValidateFlags("vkCreateSwapchainKHR", "pCreateInfo->flags", "VkSwapchainCreateFlagBitsKHR", AllVkSwapchainCreateFlagBitsKHR, pCreateInfo->flags, kOptionalFlags, "VUID-VkSwapchainCreateInfoKHR-flags-parameter");

        skip |= ValidateRequiredHandle("vkCreateSwapchainKHR", "pCreateInfo->surface", pCreateInfo->surface);

        skip |= ValidateRangedEnum("vkCreateSwapchainKHR", "pCreateInfo->imageFormat", "VkFormat", AllVkFormatEnums, pCreateInfo->imageFormat, "VUID-VkSwapchainCreateInfoKHR-imageFormat-parameter");

        skip |= ValidateRangedEnum("vkCreateSwapchainKHR", "pCreateInfo->imageColorSpace", "VkColorSpaceKHR", AllVkColorSpaceKHREnums, pCreateInfo->imageColorSpace, "VUID-VkSwapchainCreateInfoKHR-imageColorSpace-parameter");

        // No xml-driven validation

        skip |= ValidateFlags("vkCreateSwapchainKHR", "pCreateInfo->imageUsage", "VkImageUsageFlagBits", AllVkImageUsageFlagBits, pCreateInfo->imageUsage, kRequiredFlags, "VUID-VkSwapchainCreateInfoKHR-imageUsage-parameter", "VUID-VkSwapchainCreateInfoKHR-imageUsage-requiredbitmask");

        skip |= ValidateRangedEnum("vkCreateSwapchainKHR", "pCreateInfo->imageSharingMode", "VkSharingMode", AllVkSharingModeEnums, pCreateInfo->imageSharingMode, "VUID-VkSwapchainCreateInfoKHR-imageSharingMode-parameter");

        skip |= ValidateFlags("vkCreateSwapchainKHR", "pCreateInfo->preTransform", "VkSurfaceTransformFlagBitsKHR", AllVkSurfaceTransformFlagBitsKHR, pCreateInfo->preTransform, kRequiredSingleBit, "VUID-VkSwapchainCreateInfoKHR-preTransform-parameter", "VUID-VkSwapchainCreateInfoKHR-preTransform-parameter");

        skip |= ValidateFlags("vkCreateSwapchainKHR", "pCreateInfo->compositeAlpha", "VkCompositeAlphaFlagBitsKHR", AllVkCompositeAlphaFlagBitsKHR, pCreateInfo->compositeAlpha, kRequiredSingleBit, "VUID-VkSwapchainCreateInfoKHR-compositeAlpha-parameter", "VUID-VkSwapchainCreateInfoKHR-compositeAlpha-parameter");

        skip |= ValidateRangedEnum("vkCreateSwapchainKHR", "pCreateInfo->presentMode", "VkPresentModeKHR", AllVkPresentModeKHREnums, pCreateInfo->presentMode, "VUID-VkSwapchainCreateInfoKHR-presentMode-parameter");

        skip |= ValidateBool32("vkCreateSwapchainKHR", "pCreateInfo->clipped", pCreateInfo->clipped);
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateSwapchainKHR", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateSwapchainKHR", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateSwapchainKHR", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateSwapchainKHR", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateSwapchainKHR", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateSwapchainKHR", "pSwapchain", pSwapchain, "VUID-vkCreateSwapchainKHR-pSwapchain-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateSwapchainKHR(device, pCreateInfo, pAllocator, pSwapchain);
    return skip;
}

bool StatelessValidation::PreCallValidateDestroySwapchainKHR(
    VkDevice                                    device,
    VkSwapchainKHR                              swapchain,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_surface)) skip |= OutputExtensionError("vkDestroySwapchainKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_swapchain)) skip |= OutputExtensionError("vkDestroySwapchainKHR", VK_KHR_SWAPCHAIN_EXTENSION_NAME);
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroySwapchainKHR", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroySwapchainKHR", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroySwapchainKHR", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroySwapchainKHR", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroySwapchainKHR", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetSwapchainImagesKHR(
    VkDevice                                    device,
    VkSwapchainKHR                              swapchain,
    uint32_t*                                   pSwapchainImageCount,
    VkImage*                                    pSwapchainImages) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_surface)) skip |= OutputExtensionError("vkGetSwapchainImagesKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_swapchain)) skip |= OutputExtensionError("vkGetSwapchainImagesKHR", VK_KHR_SWAPCHAIN_EXTENSION_NAME);
    skip |= ValidateRequiredHandle("vkGetSwapchainImagesKHR", "swapchain", swapchain);
    skip |= ValidateArray("vkGetSwapchainImagesKHR", "pSwapchainImageCount", "pSwapchainImages", pSwapchainImageCount, &pSwapchainImages, true, false, false, kVUIDUndefined, "VUID-vkGetSwapchainImagesKHR-pSwapchainImages-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateAcquireNextImageKHR(
    VkDevice                                    device,
    VkSwapchainKHR                              swapchain,
    uint64_t                                    timeout,
    VkSemaphore                                 semaphore,
    VkFence                                     fence,
    uint32_t*                                   pImageIndex) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_surface)) skip |= OutputExtensionError("vkAcquireNextImageKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_swapchain)) skip |= OutputExtensionError("vkAcquireNextImageKHR", VK_KHR_SWAPCHAIN_EXTENSION_NAME);
    skip |= ValidateRequiredHandle("vkAcquireNextImageKHR", "swapchain", swapchain);
    skip |= ValidateRequiredPointer("vkAcquireNextImageKHR", "pImageIndex", pImageIndex, "VUID-vkAcquireNextImageKHR-pImageIndex-parameter");
    if (!skip) skip |= manual_PreCallValidateAcquireNextImageKHR(device, swapchain, timeout, semaphore, fence, pImageIndex);
    return skip;
}

bool StatelessValidation::PreCallValidateQueuePresentKHR(
    VkQueue                                     queue,
    const VkPresentInfoKHR*                     pPresentInfo) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_surface)) skip |= OutputExtensionError("vkQueuePresentKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_swapchain)) skip |= OutputExtensionError("vkQueuePresentKHR", VK_KHR_SWAPCHAIN_EXTENSION_NAME);
    skip |= ValidateStructType("vkQueuePresentKHR", "pPresentInfo", "VK_STRUCTURE_TYPE_PRESENT_INFO_KHR", pPresentInfo, VK_STRUCTURE_TYPE_PRESENT_INFO_KHR, true, "VUID-vkQueuePresentKHR-pPresentInfo-parameter", "VUID-VkPresentInfoKHR-sType-sType");
    if (pPresentInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkPresentInfoKHR = { VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR, VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR, VK_STRUCTURE_TYPE_PRESENT_FRAME_TOKEN_GGP, VK_STRUCTURE_TYPE_PRESENT_ID_KHR, VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR, VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE, VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_FENCE_INFO_EXT, VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODE_INFO_EXT };

        skip |= ValidateStructPnext("vkQueuePresentKHR", "pPresentInfo->pNext", "VkDeviceGroupPresentInfoKHR, VkDisplayPresentInfoKHR, VkPresentFrameTokenGGP, VkPresentIdKHR, VkPresentRegionsKHR, VkPresentTimesInfoGOOGLE, VkSwapchainPresentFenceInfoEXT, VkSwapchainPresentModeInfoEXT", pPresentInfo->pNext, allowed_structs_VkPresentInfoKHR.size(), allowed_structs_VkPresentInfoKHR.data(), GeneratedVulkanHeaderVersion, "VUID-VkPresentInfoKHR-pNext-pNext", "VUID-VkPresentInfoKHR-sType-unique", false, true);

        skip |= ValidateArray("vkQueuePresentKHR", "pPresentInfo->waitSemaphoreCount", "pPresentInfo->pWaitSemaphores", pPresentInfo->waitSemaphoreCount, &pPresentInfo->pWaitSemaphores, false, true, kVUIDUndefined, "VUID-VkPresentInfoKHR-pWaitSemaphores-parameter");

        skip |= ValidateHandleArray("vkQueuePresentKHR", "pPresentInfo->swapchainCount", "pPresentInfo->pSwapchains", pPresentInfo->swapchainCount, pPresentInfo->pSwapchains, true, true, kVUIDUndefined);

        skip |= ValidateArray("vkQueuePresentKHR", "pPresentInfo->swapchainCount", "pPresentInfo->pImageIndices", pPresentInfo->swapchainCount, &pPresentInfo->pImageIndices, true, true, "VUID-VkPresentInfoKHR-swapchainCount-arraylength", "VUID-VkPresentInfoKHR-pImageIndices-parameter");

        skip |= ValidateArray("vkQueuePresentKHR", "pPresentInfo->swapchainCount", "pPresentInfo->pResults", pPresentInfo->swapchainCount, &pPresentInfo->pResults, true, false, "VUID-VkPresentInfoKHR-swapchainCount-arraylength", "VUID-VkPresentInfoKHR-pResults-parameter");
    }
    if (!skip) skip |= manual_PreCallValidateQueuePresentKHR(queue, pPresentInfo);
    return skip;
}

bool StatelessValidation::PreCallValidateGetDeviceGroupPresentCapabilitiesKHR(
    VkDevice                                    device,
    VkDeviceGroupPresentCapabilitiesKHR*        pDeviceGroupPresentCapabilities) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_surface)) skip |= OutputExtensionError("vkGetDeviceGroupPresentCapabilitiesKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_swapchain)) skip |= OutputExtensionError("vkGetDeviceGroupPresentCapabilitiesKHR", VK_KHR_SWAPCHAIN_EXTENSION_NAME);
    skip |= ValidateStructType("vkGetDeviceGroupPresentCapabilitiesKHR", "pDeviceGroupPresentCapabilities", "VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR", pDeviceGroupPresentCapabilities, VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR, true, "VUID-vkGetDeviceGroupPresentCapabilitiesKHR-pDeviceGroupPresentCapabilities-parameter", "VUID-VkDeviceGroupPresentCapabilitiesKHR-sType-sType");
    if (pDeviceGroupPresentCapabilities != nullptr)
    {
        skip |= ValidateStructPnext("vkGetDeviceGroupPresentCapabilitiesKHR", "pDeviceGroupPresentCapabilities->pNext", nullptr, pDeviceGroupPresentCapabilities->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkDeviceGroupPresentCapabilitiesKHR-pNext-pNext", kVUIDUndefined, false, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetDeviceGroupSurfacePresentModesKHR(
    VkDevice                                    device,
    VkSurfaceKHR                                surface,
    VkDeviceGroupPresentModeFlagsKHR*           pModes) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_surface)) skip |= OutputExtensionError("vkGetDeviceGroupSurfacePresentModesKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_swapchain)) skip |= OutputExtensionError("vkGetDeviceGroupSurfacePresentModesKHR", VK_KHR_SWAPCHAIN_EXTENSION_NAME);
    skip |= ValidateRequiredHandle("vkGetDeviceGroupSurfacePresentModesKHR", "surface", surface);
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDevicePresentRectanglesKHR(
    VkPhysicalDevice                            physicalDevice,
    VkSurfaceKHR                                surface,
    uint32_t*                                   pRectCount,
    VkRect2D*                                   pRects) const {
    bool skip = false;
    skip |= ValidateRequiredHandle("vkGetPhysicalDevicePresentRectanglesKHR", "surface", surface);
    skip |= ValidateArray("vkGetPhysicalDevicePresentRectanglesKHR", "pRectCount", "pRects", pRectCount, &pRects, true, false, false, kVUIDUndefined, "VUID-vkGetPhysicalDevicePresentRectanglesKHR-pRects-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateAcquireNextImage2KHR(
    VkDevice                                    device,
    const VkAcquireNextImageInfoKHR*            pAcquireInfo,
    uint32_t*                                   pImageIndex) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_surface)) skip |= OutputExtensionError("vkAcquireNextImage2KHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_swapchain)) skip |= OutputExtensionError("vkAcquireNextImage2KHR", VK_KHR_SWAPCHAIN_EXTENSION_NAME);
    skip |= ValidateStructType("vkAcquireNextImage2KHR", "pAcquireInfo", "VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR", pAcquireInfo, VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR, true, "VUID-vkAcquireNextImage2KHR-pAcquireInfo-parameter", "VUID-VkAcquireNextImageInfoKHR-sType-sType");
    if (pAcquireInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkAcquireNextImage2KHR", "pAcquireInfo->pNext", nullptr, pAcquireInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkAcquireNextImageInfoKHR-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateRequiredHandle("vkAcquireNextImage2KHR", "pAcquireInfo->swapchain", pAcquireInfo->swapchain);
    }
    skip |= ValidateRequiredPointer("vkAcquireNextImage2KHR", "pImageIndex", pImageIndex, "VUID-vkAcquireNextImage2KHR-pImageIndex-parameter");
    if (!skip) skip |= manual_PreCallValidateAcquireNextImage2KHR(device, pAcquireInfo, pImageIndex);
    return skip;
}



bool StatelessValidation::PreCallValidateGetPhysicalDeviceDisplayPropertiesKHR(
    VkPhysicalDevice                            physicalDevice,
    uint32_t*                                   pPropertyCount,
    VkDisplayPropertiesKHR*                     pProperties) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkGetPhysicalDeviceDisplayPropertiesKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!instance_extensions.vk_khr_display) skip |= OutputExtensionError("vkGetPhysicalDeviceDisplayPropertiesKHR", VK_KHR_DISPLAY_EXTENSION_NAME);
    skip |= ValidateArray("vkGetPhysicalDeviceDisplayPropertiesKHR", "pPropertyCount", "pProperties", pPropertyCount, &pProperties, true, false, false, kVUIDUndefined, "VUID-vkGetPhysicalDeviceDisplayPropertiesKHR-pProperties-parameter");
    if (pProperties != nullptr)
    {
        for (uint32_t pPropertyIndex = 0; pPropertyIndex < *pPropertyCount; ++pPropertyIndex)
        {
            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceDisplayPlanePropertiesKHR(
    VkPhysicalDevice                            physicalDevice,
    uint32_t*                                   pPropertyCount,
    VkDisplayPlanePropertiesKHR*                pProperties) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkGetPhysicalDeviceDisplayPlanePropertiesKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!instance_extensions.vk_khr_display) skip |= OutputExtensionError("vkGetPhysicalDeviceDisplayPlanePropertiesKHR", VK_KHR_DISPLAY_EXTENSION_NAME);
    skip |= ValidateArray("vkGetPhysicalDeviceDisplayPlanePropertiesKHR", "pPropertyCount", "pProperties", pPropertyCount, &pProperties, true, false, false, kVUIDUndefined, "VUID-vkGetPhysicalDeviceDisplayPlanePropertiesKHR-pProperties-parameter");
    if (pProperties != nullptr)
    {
        for (uint32_t pPropertyIndex = 0; pPropertyIndex < *pPropertyCount; ++pPropertyIndex)
        {
            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetDisplayPlaneSupportedDisplaysKHR(
    VkPhysicalDevice                            physicalDevice,
    uint32_t                                    planeIndex,
    uint32_t*                                   pDisplayCount,
    VkDisplayKHR*                               pDisplays) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkGetDisplayPlaneSupportedDisplaysKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!instance_extensions.vk_khr_display) skip |= OutputExtensionError("vkGetDisplayPlaneSupportedDisplaysKHR", VK_KHR_DISPLAY_EXTENSION_NAME);
    skip |= ValidateArray("vkGetDisplayPlaneSupportedDisplaysKHR", "pDisplayCount", "pDisplays", pDisplayCount, &pDisplays, true, false, false, kVUIDUndefined, "VUID-vkGetDisplayPlaneSupportedDisplaysKHR-pDisplays-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateGetDisplayModePropertiesKHR(
    VkPhysicalDevice                            physicalDevice,
    VkDisplayKHR                                display,
    uint32_t*                                   pPropertyCount,
    VkDisplayModePropertiesKHR*                 pProperties) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkGetDisplayModePropertiesKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!instance_extensions.vk_khr_display) skip |= OutputExtensionError("vkGetDisplayModePropertiesKHR", VK_KHR_DISPLAY_EXTENSION_NAME);
    skip |= ValidateRequiredHandle("vkGetDisplayModePropertiesKHR", "display", display);
    skip |= ValidateArray("vkGetDisplayModePropertiesKHR", "pPropertyCount", "pProperties", pPropertyCount, &pProperties, true, false, false, kVUIDUndefined, "VUID-vkGetDisplayModePropertiesKHR-pProperties-parameter");
    if (pProperties != nullptr)
    {
        for (uint32_t pPropertyIndex = 0; pPropertyIndex < *pPropertyCount; ++pPropertyIndex)
        {
            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateDisplayModeKHR(
    VkPhysicalDevice                            physicalDevice,
    VkDisplayKHR                                display,
    const VkDisplayModeCreateInfoKHR*           pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkDisplayModeKHR*                           pMode) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkCreateDisplayModeKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!instance_extensions.vk_khr_display) skip |= OutputExtensionError("vkCreateDisplayModeKHR", VK_KHR_DISPLAY_EXTENSION_NAME);
    skip |= ValidateRequiredHandle("vkCreateDisplayModeKHR", "display", display);
    skip |= ValidateStructType("vkCreateDisplayModeKHR", "pCreateInfo", "VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR", pCreateInfo, VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR, true, "VUID-vkCreateDisplayModeKHR-pCreateInfo-parameter", "VUID-VkDisplayModeCreateInfoKHR-sType-sType");
    if (pCreateInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCreateDisplayModeKHR", "pCreateInfo->pNext", nullptr, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkDisplayModeCreateInfoKHR-pNext-pNext", kVUIDUndefined, true, true);

        skip |= ValidateReservedFlags("vkCreateDisplayModeKHR", "pCreateInfo->flags", pCreateInfo->flags, "VUID-VkDisplayModeCreateInfoKHR-flags-zerobitmask");

        // No xml-driven validation
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateDisplayModeKHR", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateDisplayModeKHR", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateDisplayModeKHR", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateDisplayModeKHR", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateDisplayModeKHR", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateDisplayModeKHR", "pMode", pMode, "VUID-vkCreateDisplayModeKHR-pMode-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateDisplayModeKHR(physicalDevice, display, pCreateInfo, pAllocator, pMode);
    return skip;
}

bool StatelessValidation::PreCallValidateGetDisplayPlaneCapabilitiesKHR(
    VkPhysicalDevice                            physicalDevice,
    VkDisplayModeKHR                            mode,
    uint32_t                                    planeIndex,
    VkDisplayPlaneCapabilitiesKHR*              pCapabilities) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkGetDisplayPlaneCapabilitiesKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!instance_extensions.vk_khr_display) skip |= OutputExtensionError("vkGetDisplayPlaneCapabilitiesKHR", VK_KHR_DISPLAY_EXTENSION_NAME);
    skip |= ValidateRequiredHandle("vkGetDisplayPlaneCapabilitiesKHR", "mode", mode);
    skip |= ValidateRequiredPointer("vkGetDisplayPlaneCapabilitiesKHR", "pCapabilities", pCapabilities, "VUID-vkGetDisplayPlaneCapabilitiesKHR-pCapabilities-parameter");
    if (pCapabilities != nullptr)
    {
        // No xml-driven validation
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateDisplayPlaneSurfaceKHR(
    VkInstance                                  instance,
    const VkDisplaySurfaceCreateInfoKHR*        pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkSurfaceKHR*                               pSurface) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkCreateDisplayPlaneSurfaceKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!instance_extensions.vk_khr_display) skip |= OutputExtensionError("vkCreateDisplayPlaneSurfaceKHR", VK_KHR_DISPLAY_EXTENSION_NAME);
    skip |= ValidateStructType("vkCreateDisplayPlaneSurfaceKHR", "pCreateInfo", "VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR", pCreateInfo, VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR, true, "VUID-vkCreateDisplayPlaneSurfaceKHR-pCreateInfo-parameter", "VUID-VkDisplaySurfaceCreateInfoKHR-sType-sType");
    if (pCreateInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCreateDisplayPlaneSurfaceKHR", "pCreateInfo->pNext", nullptr, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkDisplaySurfaceCreateInfoKHR-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateReservedFlags("vkCreateDisplayPlaneSurfaceKHR", "pCreateInfo->flags", pCreateInfo->flags, "VUID-VkDisplaySurfaceCreateInfoKHR-flags-zerobitmask");

        skip |= ValidateRequiredHandle("vkCreateDisplayPlaneSurfaceKHR", "pCreateInfo->displayMode", pCreateInfo->displayMode);

        skip |= ValidateFlags("vkCreateDisplayPlaneSurfaceKHR", "pCreateInfo->transform", "VkSurfaceTransformFlagBitsKHR", AllVkSurfaceTransformFlagBitsKHR, pCreateInfo->transform, kRequiredSingleBit, "VUID-VkDisplaySurfaceCreateInfoKHR-transform-parameter", "VUID-VkDisplaySurfaceCreateInfoKHR-transform-parameter");

        skip |= ValidateFlags("vkCreateDisplayPlaneSurfaceKHR", "pCreateInfo->alphaMode", "VkDisplayPlaneAlphaFlagBitsKHR", AllVkDisplayPlaneAlphaFlagBitsKHR, pCreateInfo->alphaMode, kRequiredSingleBit, "VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-parameter", "VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-parameter");

        // No xml-driven validation
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateDisplayPlaneSurfaceKHR", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateDisplayPlaneSurfaceKHR", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateDisplayPlaneSurfaceKHR", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateDisplayPlaneSurfaceKHR", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateDisplayPlaneSurfaceKHR", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateDisplayPlaneSurfaceKHR", "pSurface", pSurface, "VUID-vkCreateDisplayPlaneSurfaceKHR-pSurface-parameter");
    return skip;
}



bool StatelessValidation::PreCallValidateCreateSharedSwapchainsKHR(
    VkDevice                                    device,
    uint32_t                                    swapchainCount,
    const VkSwapchainCreateInfoKHR*             pCreateInfos,
    const VkAllocationCallbacks*                pAllocator,
    VkSwapchainKHR*                             pSwapchains) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_display)) skip |= OutputExtensionError("vkCreateSharedSwapchainsKHR", VK_KHR_DISPLAY_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_swapchain)) skip |= OutputExtensionError("vkCreateSharedSwapchainsKHR", VK_KHR_SWAPCHAIN_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_display_swapchain)) skip |= OutputExtensionError("vkCreateSharedSwapchainsKHR", VK_KHR_DISPLAY_SWAPCHAIN_EXTENSION_NAME);
    skip |= ValidateStructTypeArray("vkCreateSharedSwapchainsKHR", "swapchainCount", "pCreateInfos", "VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR", swapchainCount, pCreateInfos, VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR, true, true, "VUID-VkSwapchainCreateInfoKHR-sType-sType", "VUID-vkCreateSharedSwapchainsKHR-pCreateInfos-parameter", "VUID-vkCreateSharedSwapchainsKHR-swapchainCount-arraylength");
    if (pCreateInfos != nullptr)
    {
        for (uint32_t swapchainIndex = 0; swapchainIndex < swapchainCount; ++swapchainIndex)
        {
            constexpr std::array allowed_structs_VkSwapchainCreateInfoKHR = { VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR, VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT, VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO, VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT, VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT, VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD, VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_BARRIER_CREATE_INFO_NV, VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_EXT };

            skip |= ValidateStructPnext("vkCreateSharedSwapchainsKHR", ParameterName("pCreateInfos[%i].pNext", ParameterName::IndexVector{ swapchainIndex }), "VkDeviceGroupSwapchainCreateInfoKHR, VkImageCompressionControlEXT, VkImageFormatListCreateInfo, VkSurfaceFullScreenExclusiveInfoEXT, VkSurfaceFullScreenExclusiveWin32InfoEXT, VkSwapchainCounterCreateInfoEXT, VkSwapchainDisplayNativeHdrCreateInfoAMD, VkSwapchainPresentBarrierCreateInfoNV, VkSwapchainPresentModesCreateInfoEXT, VkSwapchainPresentScalingCreateInfoEXT", pCreateInfos[swapchainIndex].pNext, allowed_structs_VkSwapchainCreateInfoKHR.size(), allowed_structs_VkSwapchainCreateInfoKHR.data(), GeneratedVulkanHeaderVersion, "VUID-VkSwapchainCreateInfoKHR-pNext-pNext", "VUID-VkSwapchainCreateInfoKHR-sType-unique", false, true);

            skip |= ValidateFlags("vkCreateSharedSwapchainsKHR", ParameterName("pCreateInfos[%i].flags", ParameterName::IndexVector{ swapchainIndex }), "VkSwapchainCreateFlagBitsKHR", AllVkSwapchainCreateFlagBitsKHR, pCreateInfos[swapchainIndex].flags, kOptionalFlags, "VUID-VkSwapchainCreateInfoKHR-flags-parameter");

            skip |= ValidateRequiredHandle("vkCreateSharedSwapchainsKHR", ParameterName("pCreateInfos[%i].surface", ParameterName::IndexVector{ swapchainIndex }), pCreateInfos[swapchainIndex].surface);

            skip |= ValidateRangedEnum("vkCreateSharedSwapchainsKHR", ParameterName("pCreateInfos[%i].imageFormat", ParameterName::IndexVector{ swapchainIndex }), "VkFormat", AllVkFormatEnums, pCreateInfos[swapchainIndex].imageFormat, "VUID-VkSwapchainCreateInfoKHR-imageFormat-parameter");

            skip |= ValidateRangedEnum("vkCreateSharedSwapchainsKHR", ParameterName("pCreateInfos[%i].imageColorSpace", ParameterName::IndexVector{ swapchainIndex }), "VkColorSpaceKHR", AllVkColorSpaceKHREnums, pCreateInfos[swapchainIndex].imageColorSpace, "VUID-VkSwapchainCreateInfoKHR-imageColorSpace-parameter");

            // No xml-driven validation

            skip |= ValidateFlags("vkCreateSharedSwapchainsKHR", ParameterName("pCreateInfos[%i].imageUsage", ParameterName::IndexVector{ swapchainIndex }), "VkImageUsageFlagBits", AllVkImageUsageFlagBits, pCreateInfos[swapchainIndex].imageUsage, kRequiredFlags, "VUID-VkSwapchainCreateInfoKHR-imageUsage-parameter", "VUID-VkSwapchainCreateInfoKHR-imageUsage-requiredbitmask");

            skip |= ValidateRangedEnum("vkCreateSharedSwapchainsKHR", ParameterName("pCreateInfos[%i].imageSharingMode", ParameterName::IndexVector{ swapchainIndex }), "VkSharingMode", AllVkSharingModeEnums, pCreateInfos[swapchainIndex].imageSharingMode, "VUID-VkSwapchainCreateInfoKHR-imageSharingMode-parameter");

            skip |= ValidateFlags("vkCreateSharedSwapchainsKHR", ParameterName("pCreateInfos[%i].preTransform", ParameterName::IndexVector{ swapchainIndex }), "VkSurfaceTransformFlagBitsKHR", AllVkSurfaceTransformFlagBitsKHR, pCreateInfos[swapchainIndex].preTransform, kRequiredSingleBit, "VUID-VkSwapchainCreateInfoKHR-preTransform-parameter", "VUID-VkSwapchainCreateInfoKHR-preTransform-parameter");

            skip |= ValidateFlags("vkCreateSharedSwapchainsKHR", ParameterName("pCreateInfos[%i].compositeAlpha", ParameterName::IndexVector{ swapchainIndex }), "VkCompositeAlphaFlagBitsKHR", AllVkCompositeAlphaFlagBitsKHR, pCreateInfos[swapchainIndex].compositeAlpha, kRequiredSingleBit, "VUID-VkSwapchainCreateInfoKHR-compositeAlpha-parameter", "VUID-VkSwapchainCreateInfoKHR-compositeAlpha-parameter");

            skip |= ValidateRangedEnum("vkCreateSharedSwapchainsKHR", ParameterName("pCreateInfos[%i].presentMode", ParameterName::IndexVector{ swapchainIndex }), "VkPresentModeKHR", AllVkPresentModeKHREnums, pCreateInfos[swapchainIndex].presentMode, "VUID-VkSwapchainCreateInfoKHR-presentMode-parameter");

            skip |= ValidateBool32("vkCreateSharedSwapchainsKHR", ParameterName("pCreateInfos[%i].clipped", ParameterName::IndexVector{ swapchainIndex }), pCreateInfos[swapchainIndex].clipped);
        }
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateSharedSwapchainsKHR", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateSharedSwapchainsKHR", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateSharedSwapchainsKHR", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateSharedSwapchainsKHR", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateSharedSwapchainsKHR", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateArray("vkCreateSharedSwapchainsKHR", "swapchainCount", "pSwapchains", swapchainCount, &pSwapchains, true, true, "VUID-vkCreateSharedSwapchainsKHR-swapchainCount-arraylength", "VUID-vkCreateSharedSwapchainsKHR-pSwapchains-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateSharedSwapchainsKHR(device, swapchainCount, pCreateInfos, pAllocator, pSwapchains);
    return skip;
}



#ifdef VK_USE_PLATFORM_XLIB_KHR

bool StatelessValidation::PreCallValidateCreateXlibSurfaceKHR(
    VkInstance                                  instance,
    const VkXlibSurfaceCreateInfoKHR*           pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkSurfaceKHR*                               pSurface) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkCreateXlibSurfaceKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!instance_extensions.vk_khr_xlib_surface) skip |= OutputExtensionError("vkCreateXlibSurfaceKHR", VK_KHR_XLIB_SURFACE_EXTENSION_NAME);
    skip |= ValidateStructType("vkCreateXlibSurfaceKHR", "pCreateInfo", "VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR", pCreateInfo, VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR, true, "VUID-vkCreateXlibSurfaceKHR-pCreateInfo-parameter", "VUID-VkXlibSurfaceCreateInfoKHR-sType-sType");
    if (pCreateInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCreateXlibSurfaceKHR", "pCreateInfo->pNext", nullptr, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkXlibSurfaceCreateInfoKHR-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateReservedFlags("vkCreateXlibSurfaceKHR", "pCreateInfo->flags", pCreateInfo->flags, "VUID-VkXlibSurfaceCreateInfoKHR-flags-zerobitmask");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateXlibSurfaceKHR", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateXlibSurfaceKHR", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateXlibSurfaceKHR", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateXlibSurfaceKHR", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateXlibSurfaceKHR", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateXlibSurfaceKHR", "pSurface", pSurface, "VUID-vkCreateXlibSurfaceKHR-pSurface-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceXlibPresentationSupportKHR(
    VkPhysicalDevice                            physicalDevice,
    uint32_t                                    queueFamilyIndex,
    Display*                                    dpy,
    VisualID                                    visualID) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkGetPhysicalDeviceXlibPresentationSupportKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!instance_extensions.vk_khr_xlib_surface) skip |= OutputExtensionError("vkGetPhysicalDeviceXlibPresentationSupportKHR", VK_KHR_XLIB_SURFACE_EXTENSION_NAME);
    skip |= ValidateRequiredPointer("vkGetPhysicalDeviceXlibPresentationSupportKHR", "dpy", dpy, "VUID-vkGetPhysicalDeviceXlibPresentationSupportKHR-dpy-parameter");
    return skip;
}

#endif // VK_USE_PLATFORM_XLIB_KHR

#ifdef VK_USE_PLATFORM_XCB_KHR

bool StatelessValidation::PreCallValidateCreateXcbSurfaceKHR(
    VkInstance                                  instance,
    const VkXcbSurfaceCreateInfoKHR*            pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkSurfaceKHR*                               pSurface) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkCreateXcbSurfaceKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!instance_extensions.vk_khr_xcb_surface) skip |= OutputExtensionError("vkCreateXcbSurfaceKHR", VK_KHR_XCB_SURFACE_EXTENSION_NAME);
    skip |= ValidateStructType("vkCreateXcbSurfaceKHR", "pCreateInfo", "VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR", pCreateInfo, VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR, true, "VUID-vkCreateXcbSurfaceKHR-pCreateInfo-parameter", "VUID-VkXcbSurfaceCreateInfoKHR-sType-sType");
    if (pCreateInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCreateXcbSurfaceKHR", "pCreateInfo->pNext", nullptr, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkXcbSurfaceCreateInfoKHR-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateReservedFlags("vkCreateXcbSurfaceKHR", "pCreateInfo->flags", pCreateInfo->flags, "VUID-VkXcbSurfaceCreateInfoKHR-flags-zerobitmask");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateXcbSurfaceKHR", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateXcbSurfaceKHR", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateXcbSurfaceKHR", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateXcbSurfaceKHR", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateXcbSurfaceKHR", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateXcbSurfaceKHR", "pSurface", pSurface, "VUID-vkCreateXcbSurfaceKHR-pSurface-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceXcbPresentationSupportKHR(
    VkPhysicalDevice                            physicalDevice,
    uint32_t                                    queueFamilyIndex,
    xcb_connection_t*                           connection,
    xcb_visualid_t                              visual_id) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkGetPhysicalDeviceXcbPresentationSupportKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!instance_extensions.vk_khr_xcb_surface) skip |= OutputExtensionError("vkGetPhysicalDeviceXcbPresentationSupportKHR", VK_KHR_XCB_SURFACE_EXTENSION_NAME);
    skip |= ValidateRequiredPointer("vkGetPhysicalDeviceXcbPresentationSupportKHR", "connection", connection, "VUID-vkGetPhysicalDeviceXcbPresentationSupportKHR-connection-parameter");
    return skip;
}

#endif // VK_USE_PLATFORM_XCB_KHR

#ifdef VK_USE_PLATFORM_WAYLAND_KHR

bool StatelessValidation::PreCallValidateCreateWaylandSurfaceKHR(
    VkInstance                                  instance,
    const VkWaylandSurfaceCreateInfoKHR*        pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkSurfaceKHR*                               pSurface) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkCreateWaylandSurfaceKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!instance_extensions.vk_khr_wayland_surface) skip |= OutputExtensionError("vkCreateWaylandSurfaceKHR", VK_KHR_WAYLAND_SURFACE_EXTENSION_NAME);
    skip |= ValidateStructType("vkCreateWaylandSurfaceKHR", "pCreateInfo", "VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR", pCreateInfo, VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR, true, "VUID-vkCreateWaylandSurfaceKHR-pCreateInfo-parameter", "VUID-VkWaylandSurfaceCreateInfoKHR-sType-sType");
    if (pCreateInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCreateWaylandSurfaceKHR", "pCreateInfo->pNext", nullptr, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkWaylandSurfaceCreateInfoKHR-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateReservedFlags("vkCreateWaylandSurfaceKHR", "pCreateInfo->flags", pCreateInfo->flags, "VUID-VkWaylandSurfaceCreateInfoKHR-flags-zerobitmask");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateWaylandSurfaceKHR", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateWaylandSurfaceKHR", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateWaylandSurfaceKHR", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateWaylandSurfaceKHR", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateWaylandSurfaceKHR", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateWaylandSurfaceKHR", "pSurface", pSurface, "VUID-vkCreateWaylandSurfaceKHR-pSurface-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceWaylandPresentationSupportKHR(
    VkPhysicalDevice                            physicalDevice,
    uint32_t                                    queueFamilyIndex,
    struct wl_display*                          display) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkGetPhysicalDeviceWaylandPresentationSupportKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!instance_extensions.vk_khr_wayland_surface) skip |= OutputExtensionError("vkGetPhysicalDeviceWaylandPresentationSupportKHR", VK_KHR_WAYLAND_SURFACE_EXTENSION_NAME);
    skip |= ValidateRequiredPointer("vkGetPhysicalDeviceWaylandPresentationSupportKHR", "display", display, "VUID-vkGetPhysicalDeviceWaylandPresentationSupportKHR-display-parameter");
    return skip;
}

#endif // VK_USE_PLATFORM_WAYLAND_KHR

#ifdef VK_USE_PLATFORM_ANDROID_KHR

bool StatelessValidation::PreCallValidateCreateAndroidSurfaceKHR(
    VkInstance                                  instance,
    const VkAndroidSurfaceCreateInfoKHR*        pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkSurfaceKHR*                               pSurface) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkCreateAndroidSurfaceKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!instance_extensions.vk_khr_android_surface) skip |= OutputExtensionError("vkCreateAndroidSurfaceKHR", VK_KHR_ANDROID_SURFACE_EXTENSION_NAME);
    skip |= ValidateStructType("vkCreateAndroidSurfaceKHR", "pCreateInfo", "VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR", pCreateInfo, VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR, true, "VUID-vkCreateAndroidSurfaceKHR-pCreateInfo-parameter", "VUID-VkAndroidSurfaceCreateInfoKHR-sType-sType");
    if (pCreateInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCreateAndroidSurfaceKHR", "pCreateInfo->pNext", nullptr, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkAndroidSurfaceCreateInfoKHR-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateReservedFlags("vkCreateAndroidSurfaceKHR", "pCreateInfo->flags", pCreateInfo->flags, "VUID-VkAndroidSurfaceCreateInfoKHR-flags-zerobitmask");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateAndroidSurfaceKHR", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateAndroidSurfaceKHR", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateAndroidSurfaceKHR", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateAndroidSurfaceKHR", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateAndroidSurfaceKHR", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateAndroidSurfaceKHR", "pSurface", pSurface, "VUID-vkCreateAndroidSurfaceKHR-pSurface-parameter");
    return skip;
}

#endif // VK_USE_PLATFORM_ANDROID_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR

bool StatelessValidation::PreCallValidateCreateWin32SurfaceKHR(
    VkInstance                                  instance,
    const VkWin32SurfaceCreateInfoKHR*          pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkSurfaceKHR*                               pSurface) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkCreateWin32SurfaceKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!instance_extensions.vk_khr_win32_surface) skip |= OutputExtensionError("vkCreateWin32SurfaceKHR", VK_KHR_WIN32_SURFACE_EXTENSION_NAME);
    skip |= ValidateStructType("vkCreateWin32SurfaceKHR", "pCreateInfo", "VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR", pCreateInfo, VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR, true, "VUID-vkCreateWin32SurfaceKHR-pCreateInfo-parameter", "VUID-VkWin32SurfaceCreateInfoKHR-sType-sType");
    if (pCreateInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCreateWin32SurfaceKHR", "pCreateInfo->pNext", nullptr, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkWin32SurfaceCreateInfoKHR-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateReservedFlags("vkCreateWin32SurfaceKHR", "pCreateInfo->flags", pCreateInfo->flags, "VUID-VkWin32SurfaceCreateInfoKHR-flags-zerobitmask");
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateWin32SurfaceKHR", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateWin32SurfaceKHR", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateWin32SurfaceKHR", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateWin32SurfaceKHR", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateWin32SurfaceKHR", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateWin32SurfaceKHR", "pSurface", pSurface, "VUID-vkCreateWin32SurfaceKHR-pSurface-parameter");
    if (!skip) skip |= manual_PreCallValidateCreateWin32SurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceWin32PresentationSupportKHR(
    VkPhysicalDevice                            physicalDevice,
    uint32_t                                    queueFamilyIndex) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_surface) skip |= OutputExtensionError("vkGetPhysicalDeviceWin32PresentationSupportKHR", VK_KHR_SURFACE_EXTENSION_NAME);
    if (!instance_extensions.vk_khr_win32_surface) skip |= OutputExtensionError("vkGetPhysicalDeviceWin32PresentationSupportKHR", VK_KHR_WIN32_SURFACE_EXTENSION_NAME);
    // No xml-driven validation
    return skip;
}

#endif // VK_USE_PLATFORM_WIN32_KHR



bool StatelessValidation::PreCallValidateGetPhysicalDeviceVideoCapabilitiesKHR(
    VkPhysicalDevice                            physicalDevice,
    const VkVideoProfileInfoKHR*                pVideoProfile,
    VkVideoCapabilitiesKHR*                     pCapabilities) const {
    bool skip = false;
    skip |= ValidateStructType("vkGetPhysicalDeviceVideoCapabilitiesKHR", "pVideoProfile", "VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR", pVideoProfile, VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR, true, "VUID-vkGetPhysicalDeviceVideoCapabilitiesKHR-pVideoProfile-parameter", "VUID-VkVideoProfileInfoKHR-sType-sType");
    if (pVideoProfile != nullptr)
    {
        constexpr std::array allowed_structs_VkVideoProfileInfoKHR = { VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PROFILE_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_DECODE_USAGE_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PROFILE_INFO_EXT, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PROFILE_INFO_EXT, VK_STRUCTURE_TYPE_VIDEO_ENCODE_USAGE_INFO_KHR };

        skip |= ValidateStructPnext("vkGetPhysicalDeviceVideoCapabilitiesKHR", "pVideoProfile->pNext", "VkVideoDecodeH264ProfileInfoKHR, VkVideoDecodeH265ProfileInfoKHR, VkVideoDecodeUsageInfoKHR, VkVideoEncodeH264ProfileInfoEXT, VkVideoEncodeH265ProfileInfoEXT, VkVideoEncodeUsageInfoKHR", pVideoProfile->pNext, allowed_structs_VkVideoProfileInfoKHR.size(), allowed_structs_VkVideoProfileInfoKHR.data(), GeneratedVulkanHeaderVersion, kVUIDUndefined, kVUIDUndefined, true, true);

        skip |= ValidateFlags("vkGetPhysicalDeviceVideoCapabilitiesKHR", "pVideoProfile->videoCodecOperation", "VkVideoCodecOperationFlagBitsKHR", AllVkVideoCodecOperationFlagBitsKHR, pVideoProfile->videoCodecOperation, kRequiredSingleBit, "VUID-VkVideoProfileInfoKHR-videoCodecOperation-parameter", "VUID-VkVideoProfileInfoKHR-videoCodecOperation-parameter");

        skip |= ValidateFlags("vkGetPhysicalDeviceVideoCapabilitiesKHR", "pVideoProfile->chromaSubsampling", "VkVideoChromaSubsamplingFlagBitsKHR", AllVkVideoChromaSubsamplingFlagBitsKHR, pVideoProfile->chromaSubsampling, kRequiredFlags, "VUID-VkVideoProfileInfoKHR-chromaSubsampling-parameter", "VUID-VkVideoProfileInfoKHR-chromaSubsampling-requiredbitmask");

        skip |= ValidateFlags("vkGetPhysicalDeviceVideoCapabilitiesKHR", "pVideoProfile->lumaBitDepth", "VkVideoComponentBitDepthFlagBitsKHR", AllVkVideoComponentBitDepthFlagBitsKHR, pVideoProfile->lumaBitDepth, kRequiredFlags, "VUID-VkVideoProfileInfoKHR-lumaBitDepth-parameter", "VUID-VkVideoProfileInfoKHR-lumaBitDepth-requiredbitmask");

        skip |= ValidateFlags("vkGetPhysicalDeviceVideoCapabilitiesKHR", "pVideoProfile->chromaBitDepth", "VkVideoComponentBitDepthFlagBitsKHR", AllVkVideoComponentBitDepthFlagBitsKHR, pVideoProfile->chromaBitDepth, kOptionalFlags, "VUID-VkVideoProfileInfoKHR-chromaBitDepth-parameter");
    }
    skip |= ValidateStructType("vkGetPhysicalDeviceVideoCapabilitiesKHR", "pCapabilities", "VK_STRUCTURE_TYPE_VIDEO_CAPABILITIES_KHR", pCapabilities, VK_STRUCTURE_TYPE_VIDEO_CAPABILITIES_KHR, true, "VUID-vkGetPhysicalDeviceVideoCapabilitiesKHR-pCapabilities-parameter", "VUID-VkVideoCapabilitiesKHR-sType-sType");
    if (pCapabilities != nullptr)
    {
        constexpr std::array allowed_structs_VkVideoCapabilitiesKHR = { VK_STRUCTURE_TYPE_VIDEO_DECODE_CAPABILITIES_KHR, VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_CAPABILITIES_KHR, VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_CAPABILITIES_KHR, VK_STRUCTURE_TYPE_VIDEO_ENCODE_CAPABILITIES_KHR, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_CAPABILITIES_EXT, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_CAPABILITIES_EXT };

        skip |= ValidateStructPnext("vkGetPhysicalDeviceVideoCapabilitiesKHR", "pCapabilities->pNext", "VkVideoDecodeCapabilitiesKHR, VkVideoDecodeH264CapabilitiesKHR, VkVideoDecodeH265CapabilitiesKHR, VkVideoEncodeCapabilitiesKHR, VkVideoEncodeH264CapabilitiesEXT, VkVideoEncodeH265CapabilitiesEXT", pCapabilities->pNext, allowed_structs_VkVideoCapabilitiesKHR.size(), allowed_structs_VkVideoCapabilitiesKHR.data(), GeneratedVulkanHeaderVersion, "VUID-VkVideoCapabilitiesKHR-pNext-pNext", "VUID-VkVideoCapabilitiesKHR-sType-unique", true, false);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceVideoFormatPropertiesKHR(
    VkPhysicalDevice                            physicalDevice,
    const VkPhysicalDeviceVideoFormatInfoKHR*   pVideoFormatInfo,
    uint32_t*                                   pVideoFormatPropertyCount,
    VkVideoFormatPropertiesKHR*                 pVideoFormatProperties) const {
    bool skip = false;
    skip |= ValidateStructType("vkGetPhysicalDeviceVideoFormatPropertiesKHR", "pVideoFormatInfo", "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_FORMAT_INFO_KHR", pVideoFormatInfo, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_FORMAT_INFO_KHR, true, "VUID-vkGetPhysicalDeviceVideoFormatPropertiesKHR-pVideoFormatInfo-parameter", "VUID-VkPhysicalDeviceVideoFormatInfoKHR-sType-sType");
    if (pVideoFormatInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkPhysicalDeviceVideoFormatInfoKHR = { VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR };

        skip |= ValidateStructPnext("vkGetPhysicalDeviceVideoFormatPropertiesKHR", "pVideoFormatInfo->pNext", "VkVideoProfileListInfoKHR", pVideoFormatInfo->pNext, allowed_structs_VkPhysicalDeviceVideoFormatInfoKHR.size(), allowed_structs_VkPhysicalDeviceVideoFormatInfoKHR.data(), GeneratedVulkanHeaderVersion, "VUID-VkPhysicalDeviceVideoFormatInfoKHR-pNext-pNext", "VUID-VkPhysicalDeviceVideoFormatInfoKHR-sType-unique", true, true);

        skip |= ValidateFlags("vkGetPhysicalDeviceVideoFormatPropertiesKHR", "pVideoFormatInfo->imageUsage", "VkImageUsageFlagBits", AllVkImageUsageFlagBits, pVideoFormatInfo->imageUsage, kRequiredFlags, "VUID-VkPhysicalDeviceVideoFormatInfoKHR-imageUsage-parameter", "VUID-VkPhysicalDeviceVideoFormatInfoKHR-imageUsage-requiredbitmask");
    }
    skip |= ValidateStructTypeArray("vkGetPhysicalDeviceVideoFormatPropertiesKHR", "pVideoFormatPropertyCount", "pVideoFormatProperties", "VK_STRUCTURE_TYPE_VIDEO_FORMAT_PROPERTIES_KHR", pVideoFormatPropertyCount, pVideoFormatProperties, VK_STRUCTURE_TYPE_VIDEO_FORMAT_PROPERTIES_KHR, true, false, false, "VUID-VkVideoFormatPropertiesKHR-sType-sType", "VUID-vkGetPhysicalDeviceVideoFormatPropertiesKHR-pVideoFormatProperties-parameter", kVUIDUndefined);
    if (pVideoFormatProperties != nullptr)
    {
        for (uint32_t pVideoFormatPropertyIndex = 0; pVideoFormatPropertyIndex < *pVideoFormatPropertyCount; ++pVideoFormatPropertyIndex)
        {
            skip |= ValidateStructPnext("vkGetPhysicalDeviceVideoFormatPropertiesKHR", ParameterName("pVideoFormatProperties[%i].pNext", ParameterName::IndexVector{ pVideoFormatPropertyIndex }), nullptr, pVideoFormatProperties[pVideoFormatPropertyIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkVideoFormatPropertiesKHR-pNext-pNext", kVUIDUndefined, true, false);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateVideoSessionKHR(
    VkDevice                                    device,
    const VkVideoSessionCreateInfoKHR*          pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkVideoSessionKHR*                          pVideoSession) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_synchronization2)) skip |= OutputExtensionError("vkCreateVideoSessionKHR", VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_get_physical_device_properties2)) skip |= OutputExtensionError("vkCreateVideoSessionKHR", VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_video_queue)) skip |= OutputExtensionError("vkCreateVideoSessionKHR", VK_KHR_VIDEO_QUEUE_EXTENSION_NAME);
    skip |= ValidateStructType("vkCreateVideoSessionKHR", "pCreateInfo", "VK_STRUCTURE_TYPE_VIDEO_SESSION_CREATE_INFO_KHR", pCreateInfo, VK_STRUCTURE_TYPE_VIDEO_SESSION_CREATE_INFO_KHR, true, "VUID-vkCreateVideoSessionKHR-pCreateInfo-parameter", "VUID-VkVideoSessionCreateInfoKHR-sType-sType");
    if (pCreateInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCreateVideoSessionKHR", "pCreateInfo->pNext", nullptr, pCreateInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkVideoSessionCreateInfoKHR-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateFlags("vkCreateVideoSessionKHR", "pCreateInfo->flags", "VkVideoSessionCreateFlagBitsKHR", AllVkVideoSessionCreateFlagBitsKHR, pCreateInfo->flags, kOptionalFlags, "VUID-VkVideoSessionCreateInfoKHR-flags-parameter");

        skip |= ValidateStructType("vkCreateVideoSessionKHR", "pCreateInfo->pVideoProfile", "VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR", pCreateInfo->pVideoProfile, VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR, true, "VUID-VkVideoSessionCreateInfoKHR-pVideoProfile-parameter", "VUID-VkVideoProfileInfoKHR-sType-sType");

        if (pCreateInfo->pVideoProfile != nullptr)
        {
            constexpr std::array allowed_structs_VkVideoProfileInfoKHR = { VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PROFILE_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_DECODE_USAGE_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PROFILE_INFO_EXT, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PROFILE_INFO_EXT, VK_STRUCTURE_TYPE_VIDEO_ENCODE_USAGE_INFO_KHR };

            skip |= ValidateStructPnext("vkCreateVideoSessionKHR", "pCreateInfo->pVideoProfile->pNext", "VkVideoDecodeH264ProfileInfoKHR, VkVideoDecodeH265ProfileInfoKHR, VkVideoDecodeUsageInfoKHR, VkVideoEncodeH264ProfileInfoEXT, VkVideoEncodeH265ProfileInfoEXT, VkVideoEncodeUsageInfoKHR", pCreateInfo->pVideoProfile->pNext, allowed_structs_VkVideoProfileInfoKHR.size(), allowed_structs_VkVideoProfileInfoKHR.data(), GeneratedVulkanHeaderVersion, kVUIDUndefined, kVUIDUndefined, false, true);

            skip |= ValidateFlags("vkCreateVideoSessionKHR", "pCreateInfo->pVideoProfile->videoCodecOperation", "VkVideoCodecOperationFlagBitsKHR", AllVkVideoCodecOperationFlagBitsKHR, pCreateInfo->pVideoProfile->videoCodecOperation, kRequiredSingleBit, "VUID-VkVideoProfileInfoKHR-videoCodecOperation-parameter", "VUID-VkVideoProfileInfoKHR-videoCodecOperation-parameter");

            skip |= ValidateFlags("vkCreateVideoSessionKHR", "pCreateInfo->pVideoProfile->chromaSubsampling", "VkVideoChromaSubsamplingFlagBitsKHR", AllVkVideoChromaSubsamplingFlagBitsKHR, pCreateInfo->pVideoProfile->chromaSubsampling, kRequiredFlags, "VUID-VkVideoProfileInfoKHR-chromaSubsampling-parameter", "VUID-VkVideoProfileInfoKHR-chromaSubsampling-requiredbitmask");

            skip |= ValidateFlags("vkCreateVideoSessionKHR", "pCreateInfo->pVideoProfile->lumaBitDepth", "VkVideoComponentBitDepthFlagBitsKHR", AllVkVideoComponentBitDepthFlagBitsKHR, pCreateInfo->pVideoProfile->lumaBitDepth, kRequiredFlags, "VUID-VkVideoProfileInfoKHR-lumaBitDepth-parameter", "VUID-VkVideoProfileInfoKHR-lumaBitDepth-requiredbitmask");

            skip |= ValidateFlags("vkCreateVideoSessionKHR", "pCreateInfo->pVideoProfile->chromaBitDepth", "VkVideoComponentBitDepthFlagBitsKHR", AllVkVideoComponentBitDepthFlagBitsKHR, pCreateInfo->pVideoProfile->chromaBitDepth, kOptionalFlags, "VUID-VkVideoProfileInfoKHR-chromaBitDepth-parameter");
        }

        skip |= ValidateRangedEnum("vkCreateVideoSessionKHR", "pCreateInfo->pictureFormat", "VkFormat", AllVkFormatEnums, pCreateInfo->pictureFormat, "VUID-VkVideoSessionCreateInfoKHR-pictureFormat-parameter");

        // No xml-driven validation

        skip |= ValidateRangedEnum("vkCreateVideoSessionKHR", "pCreateInfo->referencePictureFormat", "VkFormat", AllVkFormatEnums, pCreateInfo->referencePictureFormat, "VUID-VkVideoSessionCreateInfoKHR-referencePictureFormat-parameter");

        skip |= ValidateRequiredPointer("vkCreateVideoSessionKHR", "pCreateInfo->pStdHeaderVersion", pCreateInfo->pStdHeaderVersion, "VUID-VkVideoSessionCreateInfoKHR-pStdHeaderVersion-parameter");

        if (pCreateInfo->pStdHeaderVersion != nullptr)
        {
            // No xml-driven validation
        }
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateVideoSessionKHR", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateVideoSessionKHR", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateVideoSessionKHR", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateVideoSessionKHR", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateVideoSessionKHR", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateVideoSessionKHR", "pVideoSession", pVideoSession, "VUID-vkCreateVideoSessionKHR-pVideoSession-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyVideoSessionKHR(
    VkDevice                                    device,
    VkVideoSessionKHR                           videoSession,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_synchronization2)) skip |= OutputExtensionError("vkDestroyVideoSessionKHR", VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_get_physical_device_properties2)) skip |= OutputExtensionError("vkDestroyVideoSessionKHR", VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_video_queue)) skip |= OutputExtensionError("vkDestroyVideoSessionKHR", VK_KHR_VIDEO_QUEUE_EXTENSION_NAME);
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyVideoSessionKHR", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyVideoSessionKHR", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyVideoSessionKHR", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyVideoSessionKHR", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyVideoSessionKHR", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateGetVideoSessionMemoryRequirementsKHR(
    VkDevice                                    device,
    VkVideoSessionKHR                           videoSession,
    uint32_t*                                   pMemoryRequirementsCount,
    VkVideoSessionMemoryRequirementsKHR*        pMemoryRequirements) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_synchronization2)) skip |= OutputExtensionError("vkGetVideoSessionMemoryRequirementsKHR", VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_get_physical_device_properties2)) skip |= OutputExtensionError("vkGetVideoSessionMemoryRequirementsKHR", VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_video_queue)) skip |= OutputExtensionError("vkGetVideoSessionMemoryRequirementsKHR", VK_KHR_VIDEO_QUEUE_EXTENSION_NAME);
    skip |= ValidateRequiredHandle("vkGetVideoSessionMemoryRequirementsKHR", "videoSession", videoSession);
    skip |= ValidateStructTypeArray("vkGetVideoSessionMemoryRequirementsKHR", "pMemoryRequirementsCount", "pMemoryRequirements", "VK_STRUCTURE_TYPE_VIDEO_SESSION_MEMORY_REQUIREMENTS_KHR", pMemoryRequirementsCount, pMemoryRequirements, VK_STRUCTURE_TYPE_VIDEO_SESSION_MEMORY_REQUIREMENTS_KHR, true, false, false, "VUID-VkVideoSessionMemoryRequirementsKHR-sType-sType", "VUID-vkGetVideoSessionMemoryRequirementsKHR-pMemoryRequirements-parameter", kVUIDUndefined);
    if (pMemoryRequirements != nullptr)
    {
        for (uint32_t pMemoryRequirementsIndex = 0; pMemoryRequirementsIndex < *pMemoryRequirementsCount; ++pMemoryRequirementsIndex)
        {
            skip |= ValidateStructPnext("vkGetVideoSessionMemoryRequirementsKHR", ParameterName("pMemoryRequirements[%i].pNext", ParameterName::IndexVector{ pMemoryRequirementsIndex }), nullptr, pMemoryRequirements[pMemoryRequirementsIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkVideoSessionMemoryRequirementsKHR-pNext-pNext", kVUIDUndefined, false, false);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateBindVideoSessionMemoryKHR(
    VkDevice                                    device,
    VkVideoSessionKHR                           videoSession,
    uint32_t                                    bindSessionMemoryInfoCount,
    const VkBindVideoSessionMemoryInfoKHR*      pBindSessionMemoryInfos) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_synchronization2)) skip |= OutputExtensionError("vkBindVideoSessionMemoryKHR", VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_get_physical_device_properties2)) skip |= OutputExtensionError("vkBindVideoSessionMemoryKHR", VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_video_queue)) skip |= OutputExtensionError("vkBindVideoSessionMemoryKHR", VK_KHR_VIDEO_QUEUE_EXTENSION_NAME);
    skip |= ValidateRequiredHandle("vkBindVideoSessionMemoryKHR", "videoSession", videoSession);
    skip |= ValidateStructTypeArray("vkBindVideoSessionMemoryKHR", "bindSessionMemoryInfoCount", "pBindSessionMemoryInfos", "VK_STRUCTURE_TYPE_BIND_VIDEO_SESSION_MEMORY_INFO_KHR", bindSessionMemoryInfoCount, pBindSessionMemoryInfos, VK_STRUCTURE_TYPE_BIND_VIDEO_SESSION_MEMORY_INFO_KHR, true, true, "VUID-VkBindVideoSessionMemoryInfoKHR-sType-sType", "VUID-vkBindVideoSessionMemoryKHR-pBindSessionMemoryInfos-parameter", "VUID-vkBindVideoSessionMemoryKHR-bindSessionMemoryInfoCount-arraylength");
    if (pBindSessionMemoryInfos != nullptr)
    {
        for (uint32_t bindSessionMemoryInfoIndex = 0; bindSessionMemoryInfoIndex < bindSessionMemoryInfoCount; ++bindSessionMemoryInfoIndex)
        {
            skip |= ValidateStructPnext("vkBindVideoSessionMemoryKHR", ParameterName("pBindSessionMemoryInfos[%i].pNext", ParameterName::IndexVector{ bindSessionMemoryInfoIndex }), nullptr, pBindSessionMemoryInfos[bindSessionMemoryInfoIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkBindVideoSessionMemoryInfoKHR-pNext-pNext", kVUIDUndefined, false, true);

            skip |= ValidateRequiredHandle("vkBindVideoSessionMemoryKHR", ParameterName("pBindSessionMemoryInfos[%i].memory", ParameterName::IndexVector{ bindSessionMemoryInfoIndex }), pBindSessionMemoryInfos[bindSessionMemoryInfoIndex].memory);
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCreateVideoSessionParametersKHR(
    VkDevice                                    device,
    const VkVideoSessionParametersCreateInfoKHR* pCreateInfo,
    const VkAllocationCallbacks*                pAllocator,
    VkVideoSessionParametersKHR*                pVideoSessionParameters) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_synchronization2)) skip |= OutputExtensionError("vkCreateVideoSessionParametersKHR", VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_get_physical_device_properties2)) skip |= OutputExtensionError("vkCreateVideoSessionParametersKHR", VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_video_queue)) skip |= OutputExtensionError("vkCreateVideoSessionParametersKHR", VK_KHR_VIDEO_QUEUE_EXTENSION_NAME);
    skip |= ValidateStructType("vkCreateVideoSessionParametersKHR", "pCreateInfo", "VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_CREATE_INFO_KHR", pCreateInfo, VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_CREATE_INFO_KHR, true, "VUID-vkCreateVideoSessionParametersKHR-pCreateInfo-parameter", "VUID-VkVideoSessionParametersCreateInfoKHR-sType-sType");
    if (pCreateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkVideoSessionParametersCreateInfoKHR = { VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_CREATE_INFO_EXT, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_CREATE_INFO_EXT };

        skip |= ValidateStructPnext("vkCreateVideoSessionParametersKHR", "pCreateInfo->pNext", "VkVideoDecodeH264SessionParametersCreateInfoKHR, VkVideoDecodeH265SessionParametersCreateInfoKHR, VkVideoEncodeH264SessionParametersCreateInfoEXT, VkVideoEncodeH265SessionParametersCreateInfoEXT", pCreateInfo->pNext, allowed_structs_VkVideoSessionParametersCreateInfoKHR.size(), allowed_structs_VkVideoSessionParametersCreateInfoKHR.data(), GeneratedVulkanHeaderVersion, "VUID-VkVideoSessionParametersCreateInfoKHR-pNext-pNext", "VUID-VkVideoSessionParametersCreateInfoKHR-sType-unique", false, true);

        skip |= ValidateReservedFlags("vkCreateVideoSessionParametersKHR", "pCreateInfo->flags", pCreateInfo->flags, "VUID-VkVideoSessionParametersCreateInfoKHR-flags-zerobitmask");

        skip |= ValidateRequiredHandle("vkCreateVideoSessionParametersKHR", "pCreateInfo->videoSession", pCreateInfo->videoSession);
    }
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkCreateVideoSessionParametersKHR", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkCreateVideoSessionParametersKHR", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkCreateVideoSessionParametersKHR", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateVideoSessionParametersKHR", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkCreateVideoSessionParametersKHR", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    skip |= ValidateRequiredPointer("vkCreateVideoSessionParametersKHR", "pVideoSessionParameters", pVideoSessionParameters, "VUID-vkCreateVideoSessionParametersKHR-pVideoSessionParameters-parameter");
    return skip;
}

bool StatelessValidation::PreCallValidateUpdateVideoSessionParametersKHR(
    VkDevice                                    device,
    VkVideoSessionParametersKHR                 videoSessionParameters,
    const VkVideoSessionParametersUpdateInfoKHR* pUpdateInfo) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_synchronization2)) skip |= OutputExtensionError("vkUpdateVideoSessionParametersKHR", VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_get_physical_device_properties2)) skip |= OutputExtensionError("vkUpdateVideoSessionParametersKHR", VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_video_queue)) skip |= OutputExtensionError("vkUpdateVideoSessionParametersKHR", VK_KHR_VIDEO_QUEUE_EXTENSION_NAME);
    skip |= ValidateRequiredHandle("vkUpdateVideoSessionParametersKHR", "videoSessionParameters", videoSessionParameters);
    skip |= ValidateStructType("vkUpdateVideoSessionParametersKHR", "pUpdateInfo", "VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_UPDATE_INFO_KHR", pUpdateInfo, VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_UPDATE_INFO_KHR, true, "VUID-vkUpdateVideoSessionParametersKHR-pUpdateInfo-parameter", "VUID-VkVideoSessionParametersUpdateInfoKHR-sType-sType");
    if (pUpdateInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkVideoSessionParametersUpdateInfoKHR = { VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_EXT, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_ADD_INFO_EXT };

        skip |= ValidateStructPnext("vkUpdateVideoSessionParametersKHR", "pUpdateInfo->pNext", "VkVideoDecodeH264SessionParametersAddInfoKHR, VkVideoDecodeH265SessionParametersAddInfoKHR, VkVideoEncodeH264SessionParametersAddInfoEXT, VkVideoEncodeH265SessionParametersAddInfoEXT", pUpdateInfo->pNext, allowed_structs_VkVideoSessionParametersUpdateInfoKHR.size(), allowed_structs_VkVideoSessionParametersUpdateInfoKHR.data(), GeneratedVulkanHeaderVersion, "VUID-VkVideoSessionParametersUpdateInfoKHR-pNext-pNext", "VUID-VkVideoSessionParametersUpdateInfoKHR-sType-unique", false, true);
    }
    return skip;
}

bool StatelessValidation::PreCallValidateDestroyVideoSessionParametersKHR(
    VkDevice                                    device,
    VkVideoSessionParametersKHR                 videoSessionParameters,
    const VkAllocationCallbacks*                pAllocator) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_synchronization2)) skip |= OutputExtensionError("vkDestroyVideoSessionParametersKHR", VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_get_physical_device_properties2)) skip |= OutputExtensionError("vkDestroyVideoSessionParametersKHR", VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_video_queue)) skip |= OutputExtensionError("vkDestroyVideoSessionParametersKHR", VK_KHR_VIDEO_QUEUE_EXTENSION_NAME);
    if (pAllocator != nullptr)
    {
        skip |= ValidateRequiredPointer("vkDestroyVideoSessionParametersKHR", "pAllocator->pfnAllocation", reinterpret_cast<const void*>(pAllocator->pfnAllocation), "VUID-VkAllocationCallbacks-pfnAllocation-00632");

        skip |= ValidateRequiredPointer("vkDestroyVideoSessionParametersKHR", "pAllocator->pfnReallocation", reinterpret_cast<const void*>(pAllocator->pfnReallocation), "VUID-VkAllocationCallbacks-pfnReallocation-00633");

        skip |= ValidateRequiredPointer("vkDestroyVideoSessionParametersKHR", "pAllocator->pfnFree", reinterpret_cast<const void*>(pAllocator->pfnFree), "VUID-VkAllocationCallbacks-pfnFree-00634");

        if (pAllocator->pfnInternalAllocation != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyVideoSessionParametersKHR", "pAllocator->pfnInternalFree", reinterpret_cast<const void*>(pAllocator->pfnInternalFree), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }

        if (pAllocator->pfnInternalFree != nullptr)
        {
            skip |= ValidateRequiredPointer("vkDestroyVideoSessionParametersKHR", "pAllocator->pfnInternalAllocation", reinterpret_cast<const void*>(pAllocator->pfnInternalAllocation), "VUID-VkAllocationCallbacks-pfnInternalAllocation-00635");

        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdBeginVideoCodingKHR(
    VkCommandBuffer                             commandBuffer,
    const VkVideoBeginCodingInfoKHR*            pBeginInfo) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_synchronization2)) skip |= OutputExtensionError("vkCmdBeginVideoCodingKHR", VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_get_physical_device_properties2)) skip |= OutputExtensionError("vkCmdBeginVideoCodingKHR", VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_video_queue)) skip |= OutputExtensionError("vkCmdBeginVideoCodingKHR", VK_KHR_VIDEO_QUEUE_EXTENSION_NAME);
    skip |= ValidateStructType("vkCmdBeginVideoCodingKHR", "pBeginInfo", "VK_STRUCTURE_TYPE_VIDEO_BEGIN_CODING_INFO_KHR", pBeginInfo, VK_STRUCTURE_TYPE_VIDEO_BEGIN_CODING_INFO_KHR, true, "VUID-vkCmdBeginVideoCodingKHR-pBeginInfo-parameter", "VUID-VkVideoBeginCodingInfoKHR-sType-sType");
    if (pBeginInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCmdBeginVideoCodingKHR", "pBeginInfo->pNext", nullptr, pBeginInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkVideoBeginCodingInfoKHR-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateReservedFlags("vkCmdBeginVideoCodingKHR", "pBeginInfo->flags", pBeginInfo->flags, "VUID-VkVideoBeginCodingInfoKHR-flags-zerobitmask");

        skip |= ValidateRequiredHandle("vkCmdBeginVideoCodingKHR", "pBeginInfo->videoSession", pBeginInfo->videoSession);

        skip |= ValidateStructTypeArray("vkCmdBeginVideoCodingKHR", "pBeginInfo->referenceSlotCount", "pBeginInfo->pReferenceSlots", "VK_STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_INFO_KHR", pBeginInfo->referenceSlotCount, pBeginInfo->pReferenceSlots, VK_STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_INFO_KHR, false, true, "VUID-VkVideoReferenceSlotInfoKHR-sType-sType", "VUID-VkVideoBeginCodingInfoKHR-pReferenceSlots-parameter", kVUIDUndefined);

        if (pBeginInfo->pReferenceSlots != nullptr)
        {
            for (uint32_t referenceSlotIndex = 0; referenceSlotIndex < pBeginInfo->referenceSlotCount; ++referenceSlotIndex)
            {
                constexpr std::array allowed_structs_VkVideoReferenceSlotInfoKHR = { VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_DPB_SLOT_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_DPB_SLOT_INFO_KHR };

                skip |= ValidateStructPnext("vkCmdBeginVideoCodingKHR", ParameterName("pBeginInfo->pReferenceSlots[%i].pNext", ParameterName::IndexVector{ referenceSlotIndex }), "VkVideoDecodeH264DpbSlotInfoKHR, VkVideoDecodeH265DpbSlotInfoKHR", pBeginInfo->pReferenceSlots[referenceSlotIndex].pNext, allowed_structs_VkVideoReferenceSlotInfoKHR.size(), allowed_structs_VkVideoReferenceSlotInfoKHR.data(), GeneratedVulkanHeaderVersion, "VUID-VkVideoReferenceSlotInfoKHR-pNext-pNext", "VUID-VkVideoReferenceSlotInfoKHR-sType-unique", false, true);

                skip |= ValidateStructType("vkCmdBeginVideoCodingKHR", ParameterName("pBeginInfo->pReferenceSlots[%i].pPictureResource", ParameterName::IndexVector{ referenceSlotIndex }), "VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR", pBeginInfo->pReferenceSlots[referenceSlotIndex].pPictureResource, VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR, false, "VUID-VkVideoReferenceSlotInfoKHR-pPictureResource-parameter", "VUID-VkVideoPictureResourceInfoKHR-sType-sType");

                if (pBeginInfo->pReferenceSlots[referenceSlotIndex].pPictureResource != nullptr)
                {
                    skip |= ValidateStructPnext("vkCmdBeginVideoCodingKHR", ParameterName("pBeginInfo->pReferenceSlots[%i].pPictureResource->pNext", ParameterName::IndexVector{ referenceSlotIndex }), nullptr, pBeginInfo->pReferenceSlots[referenceSlotIndex].pPictureResource->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkVideoPictureResourceInfoKHR-pNext-pNext", kVUIDUndefined, false, true);

                    // No xml-driven validation

                    // No xml-driven validation

                    skip |= ValidateRequiredHandle("vkCmdBeginVideoCodingKHR", ParameterName("pBeginInfo->pReferenceSlots[%i].pPictureResource->imageViewBinding", ParameterName::IndexVector{ referenceSlotIndex }), pBeginInfo->pReferenceSlots[referenceSlotIndex].pPictureResource->imageViewBinding);
                }
            }
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdEndVideoCodingKHR(
    VkCommandBuffer                             commandBuffer,
    const VkVideoEndCodingInfoKHR*              pEndCodingInfo) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_synchronization2)) skip |= OutputExtensionError("vkCmdEndVideoCodingKHR", VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_get_physical_device_properties2)) skip |= OutputExtensionError("vkCmdEndVideoCodingKHR", VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_video_queue)) skip |= OutputExtensionError("vkCmdEndVideoCodingKHR", VK_KHR_VIDEO_QUEUE_EXTENSION_NAME);
    skip |= ValidateStructType("vkCmdEndVideoCodingKHR", "pEndCodingInfo", "VK_STRUCTURE_TYPE_VIDEO_END_CODING_INFO_KHR", pEndCodingInfo, VK_STRUCTURE_TYPE_VIDEO_END_CODING_INFO_KHR, true, "VUID-vkCmdEndVideoCodingKHR-pEndCodingInfo-parameter", "VUID-VkVideoEndCodingInfoKHR-sType-sType");
    if (pEndCodingInfo != nullptr)
    {
        skip |= ValidateStructPnext("vkCmdEndVideoCodingKHR", "pEndCodingInfo->pNext", nullptr, pEndCodingInfo->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkVideoEndCodingInfoKHR-pNext-pNext", kVUIDUndefined, false, true);

        skip |= ValidateReservedFlags("vkCmdEndVideoCodingKHR", "pEndCodingInfo->flags", pEndCodingInfo->flags, "VUID-VkVideoEndCodingInfoKHR-flags-zerobitmask");
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdControlVideoCodingKHR(
    VkCommandBuffer                             commandBuffer,
    const VkVideoCodingControlInfoKHR*          pCodingControlInfo) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_synchronization2)) skip |= OutputExtensionError("vkCmdControlVideoCodingKHR", VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_get_physical_device_properties2)) skip |= OutputExtensionError("vkCmdControlVideoCodingKHR", VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_video_queue)) skip |= OutputExtensionError("vkCmdControlVideoCodingKHR", VK_KHR_VIDEO_QUEUE_EXTENSION_NAME);
    skip |= ValidateStructType("vkCmdControlVideoCodingKHR", "pCodingControlInfo", "VK_STRUCTURE_TYPE_VIDEO_CODING_CONTROL_INFO_KHR", pCodingControlInfo, VK_STRUCTURE_TYPE_VIDEO_CODING_CONTROL_INFO_KHR, true, "VUID-vkCmdControlVideoCodingKHR-pCodingControlInfo-parameter", "VUID-VkVideoCodingControlInfoKHR-sType-sType");
    if (pCodingControlInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkVideoCodingControlInfoKHR = { VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_INFO_EXT, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_LAYER_INFO_EXT, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_INFO_EXT, VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_LAYER_INFO_EXT, VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_LAYER_INFO_KHR };

        skip |= ValidateStructPnext("vkCmdControlVideoCodingKHR", "pCodingControlInfo->pNext", "VkVideoEncodeH264RateControlInfoEXT, VkVideoEncodeH264RateControlLayerInfoEXT, VkVideoEncodeH265RateControlInfoEXT, VkVideoEncodeH265RateControlLayerInfoEXT, VkVideoEncodeRateControlInfoKHR, VkVideoEncodeRateControlLayerInfoKHR", pCodingControlInfo->pNext, allowed_structs_VkVideoCodingControlInfoKHR.size(), allowed_structs_VkVideoCodingControlInfoKHR.data(), GeneratedVulkanHeaderVersion, "VUID-VkVideoCodingControlInfoKHR-pNext-pNext", "VUID-VkVideoCodingControlInfoKHR-sType-unique", false, true);

        skip |= ValidateFlags("vkCmdControlVideoCodingKHR", "pCodingControlInfo->flags", "VkVideoCodingControlFlagBitsKHR", AllVkVideoCodingControlFlagBitsKHR, pCodingControlInfo->flags, kRequiredFlags, "VUID-VkVideoCodingControlInfoKHR-flags-parameter", "VUID-VkVideoCodingControlInfoKHR-flags-requiredbitmask");
    }
    return skip;
}



bool StatelessValidation::PreCallValidateCmdDecodeVideoKHR(
    VkCommandBuffer                             commandBuffer,
    const VkVideoDecodeInfoKHR*                 pDecodeInfo) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_synchronization2)) skip |= OutputExtensionError("vkCmdDecodeVideoKHR", VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_video_queue)) skip |= OutputExtensionError("vkCmdDecodeVideoKHR", VK_KHR_VIDEO_QUEUE_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_video_decode_queue)) skip |= OutputExtensionError("vkCmdDecodeVideoKHR", VK_KHR_VIDEO_DECODE_QUEUE_EXTENSION_NAME);
    skip |= ValidateStructType("vkCmdDecodeVideoKHR", "pDecodeInfo", "VK_STRUCTURE_TYPE_VIDEO_DECODE_INFO_KHR", pDecodeInfo, VK_STRUCTURE_TYPE_VIDEO_DECODE_INFO_KHR, true, "VUID-vkCmdDecodeVideoKHR-pDecodeInfo-parameter", "VUID-VkVideoDecodeInfoKHR-sType-sType");
    if (pDecodeInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkVideoDecodeInfoKHR = { VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PICTURE_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PICTURE_INFO_KHR };

        skip |= ValidateStructPnext("vkCmdDecodeVideoKHR", "pDecodeInfo->pNext", "VkVideoDecodeH264PictureInfoKHR, VkVideoDecodeH265PictureInfoKHR", pDecodeInfo->pNext, allowed_structs_VkVideoDecodeInfoKHR.size(), allowed_structs_VkVideoDecodeInfoKHR.data(), GeneratedVulkanHeaderVersion, "VUID-VkVideoDecodeInfoKHR-pNext-pNext", "VUID-VkVideoDecodeInfoKHR-sType-unique", false, true);

        skip |= ValidateReservedFlags("vkCmdDecodeVideoKHR", "pDecodeInfo->flags", pDecodeInfo->flags, "VUID-VkVideoDecodeInfoKHR-flags-zerobitmask");

        skip |= ValidateRequiredHandle("vkCmdDecodeVideoKHR", "pDecodeInfo->srcBuffer", pDecodeInfo->srcBuffer);

        skip |= ValidateStructType("vkCmdDecodeVideoKHR", "pDecodeInfo->dstPictureResource", "VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR", &(pDecodeInfo->dstPictureResource), VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR, false, kVUIDUndefined, "VUID-VkVideoPictureResourceInfoKHR-sType-sType");

        skip |= ValidateStructPnext("vkCmdDecodeVideoKHR", "pDecodeInfo->dstPictureResource.pNext", nullptr, pDecodeInfo->dstPictureResource.pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkVideoPictureResourceInfoKHR-pNext-pNext", kVUIDUndefined, false, true);

        // No xml-driven validation

        // No xml-driven validation

        skip |= ValidateRequiredHandle("vkCmdDecodeVideoKHR", "pDecodeInfo->dstPictureResource.imageViewBinding", pDecodeInfo->dstPictureResource.imageViewBinding);

        skip |= ValidateStructType("vkCmdDecodeVideoKHR", "pDecodeInfo->pSetupReferenceSlot", "VK_STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_INFO_KHR", pDecodeInfo->pSetupReferenceSlot, VK_STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_INFO_KHR, false, "VUID-VkVideoDecodeInfoKHR-pSetupReferenceSlot-parameter", "VUID-VkVideoReferenceSlotInfoKHR-sType-sType");

        if (pDecodeInfo->pSetupReferenceSlot != nullptr)
        {
            constexpr std::array allowed_structs_VkVideoReferenceSlotInfoKHR = { VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_DPB_SLOT_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_DPB_SLOT_INFO_KHR };

            skip |= ValidateStructPnext("vkCmdDecodeVideoKHR", "pDecodeInfo->pSetupReferenceSlot->pNext", "VkVideoDecodeH264DpbSlotInfoKHR, VkVideoDecodeH265DpbSlotInfoKHR", pDecodeInfo->pSetupReferenceSlot->pNext, allowed_structs_VkVideoReferenceSlotInfoKHR.size(), allowed_structs_VkVideoReferenceSlotInfoKHR.data(), GeneratedVulkanHeaderVersion, "VUID-VkVideoReferenceSlotInfoKHR-pNext-pNext", "VUID-VkVideoReferenceSlotInfoKHR-sType-unique", false, true);

            skip |= ValidateStructType("vkCmdDecodeVideoKHR", "pDecodeInfo->pSetupReferenceSlot->pPictureResource", "VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR", pDecodeInfo->pSetupReferenceSlot->pPictureResource, VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR, false, "VUID-VkVideoReferenceSlotInfoKHR-pPictureResource-parameter", "VUID-VkVideoPictureResourceInfoKHR-sType-sType");

            if (pDecodeInfo->pSetupReferenceSlot->pPictureResource != nullptr)
            {
                skip |= ValidateStructPnext("vkCmdDecodeVideoKHR", "pDecodeInfo->pSetupReferenceSlot->pPictureResource->pNext", nullptr, pDecodeInfo->pSetupReferenceSlot->pPictureResource->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkVideoPictureResourceInfoKHR-pNext-pNext", kVUIDUndefined, false, true);

                // No xml-driven validation

                // No xml-driven validation

                skip |= ValidateRequiredHandle("vkCmdDecodeVideoKHR", "pDecodeInfo->pSetupReferenceSlot->pPictureResource->imageViewBinding", pDecodeInfo->pSetupReferenceSlot->pPictureResource->imageViewBinding);
            }
        }

        skip |= ValidateStructTypeArray("vkCmdDecodeVideoKHR", "pDecodeInfo->referenceSlotCount", "pDecodeInfo->pReferenceSlots", "VK_STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_INFO_KHR", pDecodeInfo->referenceSlotCount, pDecodeInfo->pReferenceSlots, VK_STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_INFO_KHR, false, true, "VUID-VkVideoReferenceSlotInfoKHR-sType-sType", "VUID-VkVideoDecodeInfoKHR-pReferenceSlots-parameter", kVUIDUndefined);

        if (pDecodeInfo->pReferenceSlots != nullptr)
        {
            for (uint32_t referenceSlotIndex = 0; referenceSlotIndex < pDecodeInfo->referenceSlotCount; ++referenceSlotIndex)
            {
                constexpr std::array allowed_structs_VkVideoReferenceSlotInfoKHR = { VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_DPB_SLOT_INFO_KHR, VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_DPB_SLOT_INFO_KHR };

                skip |= ValidateStructPnext("vkCmdDecodeVideoKHR", ParameterName("pDecodeInfo->pReferenceSlots[%i].pNext", ParameterName::IndexVector{ referenceSlotIndex }), "VkVideoDecodeH264DpbSlotInfoKHR, VkVideoDecodeH265DpbSlotInfoKHR", pDecodeInfo->pReferenceSlots[referenceSlotIndex].pNext, allowed_structs_VkVideoReferenceSlotInfoKHR.size(), allowed_structs_VkVideoReferenceSlotInfoKHR.data(), GeneratedVulkanHeaderVersion, "VUID-VkVideoReferenceSlotInfoKHR-pNext-pNext", "VUID-VkVideoReferenceSlotInfoKHR-sType-unique", false, true);

                skip |= ValidateStructType("vkCmdDecodeVideoKHR", ParameterName("pDecodeInfo->pReferenceSlots[%i].pPictureResource", ParameterName::IndexVector{ referenceSlotIndex }), "VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR", pDecodeInfo->pReferenceSlots[referenceSlotIndex].pPictureResource, VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR, false, "VUID-VkVideoReferenceSlotInfoKHR-pPictureResource-parameter", "VUID-VkVideoPictureResourceInfoKHR-sType-sType");

                if (pDecodeInfo->pReferenceSlots[referenceSlotIndex].pPictureResource != nullptr)
                {
                    skip |= ValidateStructPnext("vkCmdDecodeVideoKHR", ParameterName("pDecodeInfo->pReferenceSlots[%i].pPictureResource->pNext", ParameterName::IndexVector{ referenceSlotIndex }), nullptr, pDecodeInfo->pReferenceSlots[referenceSlotIndex].pPictureResource->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkVideoPictureResourceInfoKHR-pNext-pNext", kVUIDUndefined, false, true);

                    // No xml-driven validation

                    // No xml-driven validation

                    skip |= ValidateRequiredHandle("vkCmdDecodeVideoKHR", ParameterName("pDecodeInfo->pReferenceSlots[%i].pPictureResource->imageViewBinding", ParameterName::IndexVector{ referenceSlotIndex }), pDecodeInfo->pReferenceSlots[referenceSlotIndex].pPictureResource->imageViewBinding);
                }
            }
        }
    }
    return skip;
}





bool StatelessValidation::PreCallValidateCmdBeginRenderingKHR(
    VkCommandBuffer                             commandBuffer,
    const VkRenderingInfo*                      pRenderingInfo) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_get_physical_device_properties2)) skip |= OutputExtensionError("vkCmdBeginRenderingKHR", VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_depth_stencil_resolve)) skip |= OutputExtensionError("vkCmdBeginRenderingKHR", VK_KHR_DEPTH_STENCIL_RESOLVE_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_dynamic_rendering)) skip |= OutputExtensionError("vkCmdBeginRenderingKHR", VK_KHR_DYNAMIC_RENDERING_EXTENSION_NAME);
    skip |= ValidateStructType("vkCmdBeginRenderingKHR", "pRenderingInfo", "VK_STRUCTURE_TYPE_RENDERING_INFO", pRenderingInfo, VK_STRUCTURE_TYPE_RENDERING_INFO, true, "VUID-vkCmdBeginRendering-pRenderingInfo-parameter", "VUID-VkRenderingInfo-sType-sType");
    if (pRenderingInfo != nullptr)
    {
        constexpr std::array allowed_structs_VkRenderingInfo = { VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO, VK_STRUCTURE_TYPE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_INFO_EXT, VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX, VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT, VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR };

        skip |= ValidateStructPnext("vkCmdBeginRenderingKHR", "pRenderingInfo->pNext", "VkDeviceGroupRenderPassBeginInfo, VkMultisampledRenderToSingleSampledInfoEXT, VkMultiviewPerViewAttributesInfoNVX, VkRenderingFragmentDensityMapAttachmentInfoEXT, VkRenderingFragmentShadingRateAttachmentInfoKHR", pRenderingInfo->pNext, allowed_structs_VkRenderingInfo.size(), allowed_structs_VkRenderingInfo.data(), GeneratedVulkanHeaderVersion, "VUID-VkRenderingInfo-pNext-pNext", "VUID-VkRenderingInfo-sType-unique", false, true);

        skip |= ValidateFlags("vkCmdBeginRenderingKHR", "pRenderingInfo->flags", "VkRenderingFlagBits", AllVkRenderingFlagBits, pRenderingInfo->flags, kOptionalFlags, "VUID-VkRenderingInfo-flags-parameter");

        // No xml-driven validation

        // No xml-driven validation

        skip |= ValidateStructTypeArray("vkCmdBeginRenderingKHR", "pRenderingInfo->colorAttachmentCount", "pRenderingInfo->pColorAttachments", "VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO", pRenderingInfo->colorAttachmentCount, pRenderingInfo->pColorAttachments, VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO, false, true, "VUID-VkRenderingAttachmentInfo-sType-sType", "VUID-VkRenderingInfo-pColorAttachments-parameter", kVUIDUndefined);

        if (pRenderingInfo->pColorAttachments != nullptr)
        {
            for (uint32_t colorAttachmentIndex = 0; colorAttachmentIndex < pRenderingInfo->colorAttachmentCount; ++colorAttachmentIndex)
            {
                skip |= ValidateStructPnext("vkCmdBeginRenderingKHR", ParameterName("pRenderingInfo->pColorAttachments[%i].pNext", ParameterName::IndexVector{ colorAttachmentIndex }), nullptr, pRenderingInfo->pColorAttachments[colorAttachmentIndex].pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkRenderingAttachmentInfo-pNext-pNext", kVUIDUndefined, false, true);

                skip |= ValidateRangedEnum("vkCmdBeginRenderingKHR", ParameterName("pRenderingInfo->pColorAttachments[%i].imageLayout", ParameterName::IndexVector{ colorAttachmentIndex }), "VkImageLayout", AllVkImageLayoutEnums, pRenderingInfo->pColorAttachments[colorAttachmentIndex].imageLayout, "VUID-VkRenderingAttachmentInfo-imageLayout-parameter");

                skip |= ValidateFlags("vkCmdBeginRenderingKHR", ParameterName("pRenderingInfo->pColorAttachments[%i].resolveMode", ParameterName::IndexVector{ colorAttachmentIndex }), "VkResolveModeFlagBits", AllVkResolveModeFlagBits, pRenderingInfo->pColorAttachments[colorAttachmentIndex].resolveMode, kOptionalSingleBit, "VUID-VkRenderingAttachmentInfo-resolveMode-parameter");

                skip |= ValidateRangedEnum("vkCmdBeginRenderingKHR", ParameterName("pRenderingInfo->pColorAttachments[%i].resolveImageLayout", ParameterName::IndexVector{ colorAttachmentIndex }), "VkImageLayout", AllVkImageLayoutEnums, pRenderingInfo->pColorAttachments[colorAttachmentIndex].resolveImageLayout, "VUID-VkRenderingAttachmentInfo-resolveImageLayout-parameter");

                skip |= ValidateRangedEnum("vkCmdBeginRenderingKHR", ParameterName("pRenderingInfo->pColorAttachments[%i].loadOp", ParameterName::IndexVector{ colorAttachmentIndex }), "VkAttachmentLoadOp", AllVkAttachmentLoadOpEnums, pRenderingInfo->pColorAttachments[colorAttachmentIndex].loadOp, "VUID-VkRenderingAttachmentInfo-loadOp-parameter");

                skip |= ValidateRangedEnum("vkCmdBeginRenderingKHR", ParameterName("pRenderingInfo->pColorAttachments[%i].storeOp", ParameterName::IndexVector{ colorAttachmentIndex }), "VkAttachmentStoreOp", AllVkAttachmentStoreOpEnums, pRenderingInfo->pColorAttachments[colorAttachmentIndex].storeOp, "VUID-VkRenderingAttachmentInfo-storeOp-parameter");

                // No xml-driven validation
            }
        }

        skip |= ValidateStructType("vkCmdBeginRenderingKHR", "pRenderingInfo->pDepthAttachment", "VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO", pRenderingInfo->pDepthAttachment, VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO, false, "VUID-VkRenderingInfo-pDepthAttachment-parameter", "VUID-VkRenderingAttachmentInfo-sType-sType");

        if (pRenderingInfo->pDepthAttachment != nullptr)
        {
            skip |= ValidateStructPnext("vkCmdBeginRenderingKHR", "pRenderingInfo->pDepthAttachment->pNext", nullptr, pRenderingInfo->pDepthAttachment->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkRenderingAttachmentInfo-pNext-pNext", kVUIDUndefined, false, true);

            skip |= ValidateRangedEnum("vkCmdBeginRenderingKHR", "pRenderingInfo->pDepthAttachment->imageLayout", "VkImageLayout", AllVkImageLayoutEnums, pRenderingInfo->pDepthAttachment->imageLayout, "VUID-VkRenderingAttachmentInfo-imageLayout-parameter");

            skip |= ValidateFlags("vkCmdBeginRenderingKHR", "pRenderingInfo->pDepthAttachment->resolveMode", "VkResolveModeFlagBits", AllVkResolveModeFlagBits, pRenderingInfo->pDepthAttachment->resolveMode, kOptionalSingleBit, "VUID-VkRenderingAttachmentInfo-resolveMode-parameter");

            skip |= ValidateRangedEnum("vkCmdBeginRenderingKHR", "pRenderingInfo->pDepthAttachment->resolveImageLayout", "VkImageLayout", AllVkImageLayoutEnums, pRenderingInfo->pDepthAttachment->resolveImageLayout, "VUID-VkRenderingAttachmentInfo-resolveImageLayout-parameter");

            skip |= ValidateRangedEnum("vkCmdBeginRenderingKHR", "pRenderingInfo->pDepthAttachment->loadOp", "VkAttachmentLoadOp", AllVkAttachmentLoadOpEnums, pRenderingInfo->pDepthAttachment->loadOp, "VUID-VkRenderingAttachmentInfo-loadOp-parameter");

            skip |= ValidateRangedEnum("vkCmdBeginRenderingKHR", "pRenderingInfo->pDepthAttachment->storeOp", "VkAttachmentStoreOp", AllVkAttachmentStoreOpEnums, pRenderingInfo->pDepthAttachment->storeOp, "VUID-VkRenderingAttachmentInfo-storeOp-parameter");

            // No xml-driven validation
        }

        skip |= ValidateStructType("vkCmdBeginRenderingKHR", "pRenderingInfo->pStencilAttachment", "VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO", pRenderingInfo->pStencilAttachment, VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO, false, "VUID-VkRenderingInfo-pStencilAttachment-parameter", "VUID-VkRenderingAttachmentInfo-sType-sType");

        if (pRenderingInfo->pStencilAttachment != nullptr)
        {
            skip |= ValidateStructPnext("vkCmdBeginRenderingKHR", "pRenderingInfo->pStencilAttachment->pNext", nullptr, pRenderingInfo->pStencilAttachment->pNext, 0, nullptr, GeneratedVulkanHeaderVersion, "VUID-VkRenderingAttachmentInfo-pNext-pNext", kVUIDUndefined, false, true);

            skip |= ValidateRangedEnum("vkCmdBeginRenderingKHR", "pRenderingInfo->pStencilAttachment->imageLayout", "VkImageLayout", AllVkImageLayoutEnums, pRenderingInfo->pStencilAttachment->imageLayout, "VUID-VkRenderingAttachmentInfo-imageLayout-parameter");

            skip |= ValidateFlags("vkCmdBeginRenderingKHR", "pRenderingInfo->pStencilAttachment->resolveMode", "VkResolveModeFlagBits", AllVkResolveModeFlagBits, pRenderingInfo->pStencilAttachment->resolveMode, kOptionalSingleBit, "VUID-VkRenderingAttachmentInfo-resolveMode-parameter");

            skip |= ValidateRangedEnum("vkCmdBeginRenderingKHR", "pRenderingInfo->pStencilAttachment->resolveImageLayout", "VkImageLayout", AllVkImageLayoutEnums, pRenderingInfo->pStencilAttachment->resolveImageLayout, "VUID-VkRenderingAttachmentInfo-resolveImageLayout-parameter");

            skip |= ValidateRangedEnum("vkCmdBeginRenderingKHR", "pRenderingInfo->pStencilAttachment->loadOp", "VkAttachmentLoadOp", AllVkAttachmentLoadOpEnums, pRenderingInfo->pStencilAttachment->loadOp, "VUID-VkRenderingAttachmentInfo-loadOp-parameter");

            skip |= ValidateRangedEnum("vkCmdBeginRenderingKHR", "pRenderingInfo->pStencilAttachment->storeOp", "VkAttachmentStoreOp", AllVkAttachmentStoreOpEnums, pRenderingInfo->pStencilAttachment->storeOp, "VUID-VkRenderingAttachmentInfo-storeOp-parameter");

            // No xml-driven validation
        }
    }
    return skip;
}

bool StatelessValidation::PreCallValidateCmdEndRenderingKHR(
    VkCommandBuffer                             commandBuffer) const {
    bool skip = false;
    if (!IsExtEnabled(device_extensions.vk_khr_get_physical_device_properties2)) skip |= OutputExtensionError("vkCmdEndRenderingKHR", VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_depth_stencil_resolve)) skip |= OutputExtensionError("vkCmdEndRenderingKHR", VK_KHR_DEPTH_STENCIL_RESOLVE_EXTENSION_NAME);
    if (!IsExtEnabled(device_extensions.vk_khr_dynamic_rendering)) skip |= OutputExtensionError("vkCmdEndRenderingKHR", VK_KHR_DYNAMIC_RENDERING_EXTENSION_NAME);
    // No xml-driven validation
    return skip;
}





bool StatelessValidation::PreCallValidateGetPhysicalDeviceFeatures2KHR(
    VkPhysicalDevice                            physicalDevice,
    VkPhysicalDeviceFeatures2*                  pFeatures) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_get_physical_device_properties2) skip |= OutputExtensionError("vkGetPhysicalDeviceFeatures2KHR", VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME);
    skip |= ValidateStructType("vkGetPhysicalDeviceFeatures2KHR", "pFeatures", "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2", pFeatures, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2, true, "VUID-vkGetPhysicalDeviceFeatures2-pFeatures-parameter", "VUID-VkPhysicalDeviceFeatures2-sType-sType");
    return skip;
}

bool StatelessValidation::PreCallValidateGetPhysicalDeviceProperties2KHR(
    VkPhysicalDevice                            physicalDevice,
    VkPhysicalDeviceProperties2*                pProperties) const {
    bool skip = false;
    if (!instance_extensions.vk_khr_get_physical_device_properties2) skip |= OutputExtensionError("vkGetPhysicalDeviceProperties2KHR", VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME);
    skip |= ValidateStructType("vkGetPhysicalDeviceProperties2KHR", "pProperties", "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2", pProperties, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2, true, "VUID-vkGetPhysicalDeviceProperties2-pProperties-parameter", "VUID-VkPhysicalDeviceProperties2-sType-sType");
    if (pProperties != nullptr)
    {
        constexpr std::array allowed_structs_VkPhysicalDeviceProperties2 = { VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_PROPERTIES_HUAWEI, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_DENSITY_MAP_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRM_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_PROPERTIES_QCOM, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_PROPERTIES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_PROPERTIES_QCOM, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_PROPERTIES_ARM, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES };

        skip |= ValidateStructPnext("vkGetPhysicalDeviceProperties2KHR", "pProperties->pNext", "VkPhysicalDeviceAccelerationStructurePropertiesKHR, VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, VkPhysicalDeviceClusterCullingShaderPropertiesHUAWEI, VkPhysicalDeviceConservativeRasterizationPropertiesEXT, VkPhysicalDeviceCooperativeMatrixPropertiesNV, VkPhysicalDeviceCopyMemoryIndirectPropertiesNV, VkPhysicalDeviceCustomBorderColorPropertiesEXT, VkPhysicalDeviceDepthStencilResolveProperties, VkPhysicalDeviceDescriptorBufferDensityMapPropertiesEXT, VkPhysicalDeviceDescriptorBufferPropertiesEXT, VkPhysicalDeviceDescriptorIndexingProperties, VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV, VkPhysicalDeviceDiscardRectanglePropertiesEXT, VkPhysicalDeviceDriverProperties, VkPhysicalDeviceDrmPropertiesEXT, VkPhysicalDeviceExtendedDynamicState3PropertiesEXT, VkPhysicalDeviceExternalMemoryHostPropertiesEXT, VkPhysicalDeviceFloatControlsProperties, VkPhysicalDeviceFragmentDensityMap2PropertiesEXT, VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM, VkPhysicalDeviceFragmentDensityMapPropertiesEXT, VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR, VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV, VkPhysicalDeviceFragmentShadingRatePropertiesKHR, VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT, VkPhysicalDeviceIDProperties, VkPhysicalDeviceImageProcessingPropertiesQCOM, VkPhysicalDeviceInlineUniformBlockProperties, VkPhysicalDeviceLineRasterizationPropertiesEXT, VkPhysicalDeviceMaintenance3Properties, VkPhysicalDeviceMaintenance4Properties, VkPhysicalDeviceMemoryDecompressionPropertiesNV, VkPhysicalDeviceMeshShaderPropertiesEXT, VkPhysicalDeviceMeshShaderPropertiesNV, VkPhysicalDeviceMultiDrawPropertiesEXT, VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX, VkPhysicalDeviceMultiviewProperties, VkPhysicalDeviceOpacityMicromapPropertiesEXT, VkPhysicalDeviceOpticalFlowPropertiesNV, VkPhysicalDevicePCIBusInfoPropertiesEXT, VkPhys