/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.codehaus.plexus.util.interpolation;

import hidden.org.codehaus.plexus.util.interpolation.Interpolator;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class InterpolatorFilterReader
extends FilterReader {
    private Interpolator interpolator;
    private String replaceData = null;
    private int replaceIndex = -1;
    private int previousIndex = -1;
    private static String BEGIN_TOKEN = "${";
    private static String END_TOKEN = "}";

    public InterpolatorFilterReader(Reader in, Interpolator interpolator) {
        super(in);
        this.interpolator = interpolator;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        for (long i = 0L; i < n; ++i) {
            if (this.read() != -1) continue;
            return i;
        }
        return n;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int ch = this.read();
            if (ch == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            cbuf[off + i] = (char)ch;
        }
        return len;
    }

    public int read() throws IOException {
        if (this.replaceIndex != -1 && this.replaceIndex < this.replaceData.length()) {
            char ch = this.replaceData.charAt(this.replaceIndex++);
            if (this.replaceIndex >= this.replaceData.length()) {
                this.replaceIndex = -1;
            }
            return ch;
        }
        int ch = -1;
        ch = this.previousIndex != -1 && this.previousIndex < END_TOKEN.length() ? END_TOKEN.charAt(this.previousIndex++) : this.in.read();
        if (ch == BEGIN_TOKEN.charAt(0)) {
            StringBuffer key = new StringBuffer();
            key.append((char)ch);
            int beginTokenMatchPos = 1;
            while ((ch = this.previousIndex != -1 && this.previousIndex < END_TOKEN.length() ? (int)END_TOKEN.charAt(this.previousIndex++) : this.in.read()) != -1) {
                key.append((char)ch);
                if (beginTokenMatchPos < BEGIN_TOKEN.length() && ch != BEGIN_TOKEN.charAt(beginTokenMatchPos++)) {
                    ch = -1;
                    break;
                }
                if (ch != END_TOKEN.charAt(0)) continue;
            }
            if (ch != -1 && END_TOKEN.length() > 1) {
                int endTokenMatchPos = 1;
                while ((ch = this.previousIndex != -1 && this.previousIndex < END_TOKEN.length() ? (int)END_TOKEN.charAt(this.previousIndex++) : this.in.read()) != -1) {
                    key.append((char)ch);
                    if (ch != END_TOKEN.charAt(endTokenMatchPos++)) {
                        ch = -1;
                        break;
                    }
                    if (endTokenMatchPos < END_TOKEN.length()) continue;
                }
            }
            if (ch == -1) {
                this.replaceData = key.toString();
                this.replaceIndex = 1;
                return this.replaceData.charAt(0);
            }
            String value = this.interpolator.interpolate(key.toString(), "");
            if (value != null) {
                if (value.length() != 0) {
                    this.replaceData = value;
                    this.replaceIndex = 0;
                }
                return this.read();
            }
            this.previousIndex = 0;
            this.replaceData = key.substring(0, key.length() - END_TOKEN.length());
            this.replaceIndex = 0;
            return BEGIN_TOKEN.charAt(0);
        }
        return ch;
    }
}

