% tpm2_loadexternal(1) tpm2-tools | General Commands Manual
%
% SEPTEMBER 2017

# NAME

**tpm2_loadexternal**(1) - load an object that is not a Protected Object into the
TPM.

# SYNOPSIS

**tpm2_loadexternal** [*OPTIONS*]

# DESCRIPTION

**tpm2_loadexternal**(1) - load an object that is not a Protected Object into the
TPM. The command allows loading of a public area or both a public and a
sensitive area.

# OPTIONS

  * **-H**, **--hierarchy**=_HIERARCHY_:
    hierarchy to use for the ticket.
    Supported options are:
      * **o** for **TPM_RH_OWNER**
      * **p** for **TPM_RH_PLATFORM**
      * **e** for **TPM_RH_ENDORSEMENT**
      * **n** for **TPM_RH_NULL**

  * **-u**, **--pubfile**=_PUBLIC\_FILE_:
    The public portion of the object.

  * **-r**, **--privfile**=_PRIVATE\_FILE_:
    The sensitive portion of the object, optional.

  * **-C**, **--context**=_CONTEXT\_FILE_
    The file to save the object context, optional.

[common options](common/options.md)

[common tcti options](common/tcti.md)

# EXAMPLES

Load a public area generated by tpm2_create, tpm2_readpublic or manually

```
tpm2_loadexternal -H <e|o|p|n> -u <pubKeyFileName> -C object.context
```

Load a key with sensitive area. Both the public & the senstive areas shall
be generated externally. *DON'T* use the areas generated by tpm2_create.

```
tpm2_loadexternal -H n -u <pubKeyFileName> -r <privKeyFileName> -C object.context
```

# RETURNS

0 on success or 1 on failure.

# BUGS

[Github Issues](https://github.com/01org/tpm2-tools/issues)

# HELP

See the [Mailing List](https://lists.01.org/mailman/listinfo/tpm2)