
#include <pbs_config.h>   /* the master config generated by configure */

#include <sys/types.h>
#include <stdlib.h>
#include "libpbs.h"
#include "list_link.h"
#include "server_limits.h"
#include "attribute.h"
#include "credential.h"
#include "batch_request.h"
#include "dis.h"
#include "tcp.h" /* tcp_chan */

int decode_DIS_ReturnFiles(
    
  struct tcp_chan *chan,
  struct batch_request *preq)

  {

  struct rq_returnfiles *prfs;
  int   rc;

  prfs = &preq->rq_ind.rq_returnfiles;

  if ((rc = disrfst(chan, PBS_MAXSVRJOBID, prfs->rq_jobid)) != 0)
    return rc;

  prfs->rq_return_stdout = disrsi(chan, &rc);

  if (rc != 0)
    return rc;

  prfs->rq_return_stderr = disrsi(chan, &rc);

  if (rc != 0)
    return rc;

  return 0;
  }


