/*
*         OpenPBS (Portable Batch System) v2.3 Software License
*
* Copyright (c) 1999-2000 Veridian Information Solutions, Inc.
* All rights reserved.
*
* ---------------------------------------------------------------------------
* For a license to use or redistribute the OpenPBS software under conditions
* other than those described below, or to purchase support for this software,
* please contact Veridian Systems, PBS Products Department ("Licensor") at:
*
*    www.OpenPBS.org  +1 650 967-4675                  sales@OpenPBS.org
*                        877 902-4PBS (US toll-free)
* ---------------------------------------------------------------------------
*
* This license covers use of the OpenPBS v2.3 software (the "Software") at
* your site or location, and, for certain users, redistribution of the
* Software to other sites and locations.  Use and redistribution of
* OpenPBS v2.3 in source and binary forms, with or without modification,
* are permitted provided that all of the following conditions are met.
* After December 31, 2001, only conditions 3-6 must be met:
*
* 1. Commercial and/or non-commercial use of the Software is permitted
*    provided a current software registration is on file at www.OpenPBS.org.
*    If use of this software contributes to a publication, product, or
*    service, proper attribution must be given; see www.OpenPBS.org/credit.html
*
* 2. Redistribution in any form is only permitted for non-commercial,
*    non-profit purposes.  There can be no charge for the Software or any
*    software incorporating the Software.  Further, there can be no
*    expectation of revenue generated as a consequence of redistributing
*    the Software.
*
* 3. Any Redistribution of source code must retain the above copyright notice
*    and the acknowledgment contained in paragraph 6, this list of conditions
*    and the disclaimer contained in paragraph 7.
*
* 4. Any Redistribution in binary form must reproduce the above copyright
*    notice and the acknowledgment contained in paragraph 6, this list of
*    conditions and the disclaimer contained in paragraph 7 in the
*    documentation and/or other materials provided with the distribution.
*
* 5. Redistributions in any form must be accompanied by information on how to
*    obtain complete source code for the OpenPBS software and any
*    modifications and/or additions to the OpenPBS software.  The source code
*    must either be included in the distribution or be available for no more
*    than the cost of distribution plus a nominal fee, and all modifications
*    and additions to the Software must be freely redistributable by any party
*    (including Licensor) without restriction.
*
* 6. All advertising materials mentioning features or use of the Software must
*    display the following acknowledgment:
*
*     "This product includes software developed by NASA Ames Research Center,
*     Lawrence Livermore National Laboratory, and Veridian Information
*     Solutions, Inc.
*     Visit www.OpenPBS.org for OpenPBS software support,
*     products, and information."
*
* 7. DISCLAIMER OF WARRANTY
*
* THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND. ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT
* ARE EXPRESSLY DISCLAIMED.
*
* IN NO EVENT SHALL VERIDIAN CORPORATION, ITS AFFILIATED COMPANIES, OR THE
* U.S. GOVERNMENT OR ANY OF ITS AGENCIES BE LIABLE FOR ANY DIRECT OR INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
* EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
#include <pbs_config.h>   /* the master config generated by configure */

#include <string.h>
#include "portability.h"
#include "pbs_error.h"


/*
 * Messages issued by the server.  They are kept here in one place
 * to make translation a bit easier.
 *
 * WARNING - there are places where a message and other info is stuffed
 * into a buffer, keep the messages short!
 *
 * This first set of messages are recorded by the server or mom to the log.
 */

char *msg_abt_err = (char *)"Unable to abort Job %s which was in substate %d";
char *msg_badexit = (char *)"Abnormal exit status 0x%x: ";
char *msg_badwait = (char *)"Invalid time in work task for waiting, job = %s";
char *msg_deletejob = (char *)"Job deleted";
char *msg_delrunjobsig  = (char *)"Job sent signal %s on delete";
char *msg_err_malloc = (char *)"malloc failed";
char *msg_err_noqueue = (char *)"Unable to requeue job, queue is not defined";
char *msg_err_purgejob = (char *)"Unlink of job file failed";
char *msg_err_unlink = (char *)"Unlink of %s file %s failed";
char *msg_illregister = (char *)"Illegal op in register request received for job %s";
char *msg_info_server = (char *)"Torque Server Version = %s, loglevel = %d";
char *msg_info_mom = (char *)"Torque Mom Version = %s, loglevel = %d";
char *msg_init_abt = (char *)"Job aborted on PBS Server initialization";
char *msg_init_baddb = (char *)"Unable to read server database";
char *msg_init_badjob = (char *)"Recover of job %s failed";
char *msg_init_chdir = (char *)"unable to change to directory %s";
char *msg_init_expctq   = (char *)"Expected %d, recovered %d queues";
char *msg_init_exptjobs = (char *)"Expected %d, recovered %d jobs";
char *msg_init_nojobs   = (char *)"No jobs to open";
char *msg_init_noqueues = (char *)"No queues to open";
char *msg_init_norerun = (char *)"Unable to rerun job at Server initialization";
char *msg_init_queued = (char *)"Requeued in queue: ";
char *msg_init_recovque = (char *)"Recovered queue %s";
char *msg_init_substate = (char *)"Requeueing job, substate: %d ";
char *msg_init_unkstate = (char *)"Unable to recover job in strange substate: %d";
char *msg_isodedecode = (char *)"Decode of request failed";
char *msg_issuebad = (char *)"attempt to issue invalid request of type %d";
char *msg_job_abort = (char *)"Aborted by PBS Server ";
char *msg_job_del       = (char *)"job deleted";
char *msg_jobholdset = (char *)"Holds %s set at request of %s@%s";
char *msg_jobholdrel = (char *)"Holds %s released at request of %s@%s";
char *msg_job_end = (char *)"Execution terminated";
char *msg_job_end_stat = (char *)"Exit_status=%d";
char *msg_job_end_sig = (char *)"Terminated on signal %d";
char *msg_jobmod = (char *)"Job Modified";
char *msg_jobnew = (char *)"Job Queued at request of %s@%s, owner = %s, job name = %s, queue = %s";
char *msg_jobrerun = (char *)"Job Rerun";
char *msg_jobrun = (char *)"Job Run";
char *msg_job_start = (char *)"Begun execution";
char *msg_job_stageinfail = (char *)"File stage in failed, see below.\nJob will be retried later, please investigate and correct problem.";
char *msg_job_copychkptfail = (char *)"Checkpoint file copy failed, see below.\nJob will be retried later, please investigate and correct problem.";
char *msg_job_otherfail = (char *)"An error has occurred processing your job, see below.";
char *msg_leftrunning = (char *)"job running on at Server shutdown";
char *msg_manager = (char *)"%s at request of %s@%s";
char *msg_man_cre = (char *)"created";
char *msg_man_del = (char *)"deleted";
char *msg_man_set = (char *)"attributes set: ";
char *msg_man_uns = (char *)"attributes unset: ";
char *msg_messagejob = (char *)"Message request to job status %d";
char *msg_mombadhold = (char *)"MOM rejected hold request: %d";
char *msg_mombadmodify = (char *)"MOM rejected modify request, error: %d";
char *msg_momsetlim = (char *)"Job start failed.  Can't set \"%s\" limit: %s.\n";
char *msg_momnoexec1 = (char *)"Job cannot be executed\nSee Administrator for help";
char *msg_momnoexec2 = (char *)"Job cannot be executed\nSee job standard error file";
char *msg_momjoboverlimit = (char *)"Job exceeded some resource limit (walltime, mem, etc.). Job was aborted\nSee Administrator for help";
const char *msg_momjobovermemlimit = "Job exceeded a memory resource limit (vmem, pvmem, etc.). Job was aborted\nSee Administrator for help";
const char *msg_momjoboverwalltimelimit = "Job exceeded its walltime limit. Job was aborted\nSee Administrator for help";
const char *msg_momjobovercputlimit = "Job exceeded its cpu time limit. Job was aborted\nSee Administrator for help";
char *msg_movejob = (char *)"Job moved to ";
char *msg_norelytomom = (char *)"Server could not connect to MOM";
char *msg_obitnojob  = (char *)"Job Obit notice received from %s has error %d";
char *msg_obitnocpy = (char *)"Post job file processing error; job %s on host %s";
char *msg_obitnodel = (char *)"Unable to delete files for job %s, on host %s";
char *msg_on_shutdown = (char *)" on Server shutdown";
char *msg_orighost  = (char *)"Job missing PBS_O_HOST value";
char *msg_permlog = (char *)"Unauthorized Request, request type: %d, Object: %s, Name: %s, request from: %s@%s";
char *msg_postmomnojob = (char *)"Job not found after hold reply from MOM";
char *msg_request = (char *)"Type %s request received from %s@%s, sock=%d";
char *msg_regrej = (char *)"Dependency request for job rejected by ";
char *msg_registerdel = (char *)"Job deleted as result of dependency on job %s";
char *msg_registerrel = (char *)"Dependency on job %s released.";
char *msg_routexceed = (char *)"Route queue lifetime exceeded";
char *msg_script_open = (char *)"Unable to open script file";
char *msg_script_write = (char *)"Unable to write script file";
char *msg_shutdown_op = (char *)"Shutdown request from %s@%s ";
char *msg_shutdown_start = (char *)"Starting to shutdown the server, type is ";
char *msg_startup1 = (char *)"Server %s started, initialization type = %d";
char *msg_startup2 = (char *)"Server Ready, pid = %d, loglevel=%d";
char *msg_startup3 = (char *)"%s %s: %s mode and %s exist, \ndo you wish to continue y/(n)?";
char *msg_svdbopen = (char *)"Unable to open server data base";
char *msg_svdbnosv = (char *)"Unable to save server data base";
char *msg_svrdown = (char *)"Server shutdown completed";

/* This construct pulls the text parts from the batch types definitions
 *
 * @see pbs_batchreqtype_db.h for more info
 */
#define PbsBatchReqType(id,text) text,
static const char *PBatchReqType[] =
  {
#include "pbs_batchreqtype_db.h"
  NULL
  };
#undef PbsBatchReqType

#define NPBatchReqType (sizeof(PBatchReqType)/sizeof(PBatchReqType[0]))

/* used by server/req_manager.c */
char *msg_attrtype = (char *)"Warning: type of queue %s incompatible with attribute %s";
/* used by server/run_sched.c */
char *msg_sched_called 	= (char *)"Scheduler was sent the command %s";
char *msg_sched_nocall  = (char *)"Could not contact Scheduler";
char *msg_listnr_called = (char *)"Listener %d sent event %s";
char *msg_listnr_nocall  = (char *)"Could not contact Listener";

/* pbs_err_db generators
 *
 * @see pbs_error_db.h
 *
 * @note this constant should be const char*, but the current state of code
 *       doesn't allow this
 */
/* this construct generates array of text representations for error constants */
#define PbsErrClient(id, txt) txt,
static char * pbs_err_client_txt[] =
{
#include "pbs_error_db.h"
(char*)0
};
#undef PbsErrClient

#define PbsErrRm(id, txt) txt,
static char * pbs_err_rm_txt[] =
{
#include "pbs_error_db.h"
(char*)0
};
#undef PbsErrRm

/*END: pbs_err_db generators */

/*
 * pbse_to_txt() - return a text message for an PBS error number
 * if it exists
 */

#ifdef __cplusplus
extern "C"
{
#endif
char *pbse_to_txt(

  int err)  /* I */

  {
  if (err == 0)
	  return pbs_err_client_txt[0];

  if (err > PBSE_FLOOR && err < PBSE_CEILING)
	  return pbs_err_client_txt[err - PBSE_FLOOR];

  if (err > PBSE_RMFLOOR && err < PBSE_RMCEILING)
	  return pbs_err_rm_txt[err - PBSE_RMFLOOR];

  return (char*)0;
  }  /* END pbse_to_txt() */

/*
 * pbs_strerror() - return a pbs text message for an PBS error number
 * if it exists or return strerror results
 */

char *pbs_strerror(

  int err)  /* I */

  {
  if (err > PBSE_)
    {
    return (pbse_to_txt(err));
    }

  return (strerror(err));
  }  /* END pbs_strerror() */

#ifdef __cplusplus
}
#endif

/*
 * rqtype_to_txt() - Return the printable name of a request type
 */

const char *reqtype_to_txt(

  int reqtype)

  {
  if (reqtype >= 0 && reqtype < (int)NPBatchReqType && PBatchReqType[reqtype])
    return(PBatchReqType[reqtype]);
  else
    return("NONE");
  }  /* END reqtype_to_txt() */
