//%LICENSE////////////////////////////////////////////////////////////////
//
// Licensed to The Open Group (TOG) under one or more contributor license
// agreements.  Refer to the OpenPegasusNOTICE.txt file distributed with
// this work for additional information regarding copyright ownership.
// Each contributor licenses this file to you under the OpenPegasus Open
// Source License; you may not use this file except in compliance with the
// License.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
// CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
// TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
// SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
//////////////////////////////////////////////////////////////////////////
//
//%/////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <objbase.h>

PEGASUS_USING_STD;

PEGASUS_NAMESPACE_BEGIN

String Guid::getGuid(const String &prefix)
{
  GUID guid;
  String strUUID;
  HRESULT hres = CoCreateGuid(&guid);

  if (hres == S_OK)
    {
      WCHAR guid_strW[39] = { L"" };
      char guid_str[100];
      ::memset(&guid_str, 0, sizeof(guid_str));
      const Uint32 numChars =  sizeof(guid_strW)/sizeof(guid_strW[0]);
      if (StringFromGUID2(guid, guid_strW, numChars) > 0)
        {
          WideCharToMultiByte(
              CP_ACP,
              0,
              guid_strW,
              numChars,
              guid_str,
              sizeof(guid_str),
              NULL,
              NULL);
          // exclude the first and last chars (i.e., { and })
          for (Uint32 i=1; i<sizeof(guid_str); i++)
            {
              if (guid_str[i] != '}')
                {
                  strUUID.append(Char16(guid_str[i]));
                }
              else
                {
                  break;
                }
            }
        }
      if (prefix == String::EMPTY)
        return strUUID;
      else
        return (prefix + strUUID);
    }
  return (String::EMPTY);
}

PEGASUS_NAMESPACE_END
// END_OF_FILE
