//%LICENSE////////////////////////////////////////////////////////////////
//
// Licensed to The Open Group (TOG) under one or more contributor license
// agreements.  Refer to the OpenPegasusNOTICE.txt file distributed with
// this work for additional information regarding copyright ownership.
// Each contributor licenses this file to you under the OpenPegasus Open
// Source License; you may not use this file except in compliance with the
// License.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
// CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
// TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
// SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
//////////////////////////////////////////////////////////////////////////
//
//%/////////////////////////////////////////////////////////////////////////////

#ifndef Pegasus_DynamicLibrary_h
#define Pegasus_DynamicLibrary_h

#include <Pegasus/Common/Config.h>
#include <Pegasus/Common/Exception.h>
#include <Pegasus/Common/String.h>
#include <Pegasus/Common/Mutex.h>

#include <Pegasus/General/Linkage.h>

#if defined(PEGASUS_OS_TYPE_WINDOWS)
# include <Pegasus/Common/Network.h>
# include <windows.h>
#endif

PEGASUS_NAMESPACE_BEGIN

class PEGASUS_GENERAL_LINKAGE DynamicLibrary
{
public:
#if defined(PEGASUS_OS_TYPE_WINDOWS)
    typedef HMODULE DynamicLibraryHandle;
    typedef FARPROC DynamicSymbolHandle;
#else
    typedef void * DynamicLibraryHandle;
    typedef void * DynamicSymbolHandle;
#endif

public:
    DynamicLibrary();
    DynamicLibrary(const DynamicLibrary & library);
    explicit DynamicLibrary(const String & fileName);
    virtual ~DynamicLibrary();

    DynamicLibrary & operator=(const DynamicLibrary & library);

    Boolean load();
    const String& getLoadErrorMessage() const;
    void unload();

    Boolean isLoaded() const;

    const String& getFileName() const;
    DynamicSymbolHandle getSymbol(const String & symbolName);

private:
    Boolean _load();
    void _unload();

    String _fileName;
    DynamicLibraryHandle _handle;
    String _loadErrorMessage;
    Uint32 _referenceCount;
    Mutex _loadMutex;
};

PEGASUS_NAMESPACE_END

#endif
