/*
 * This software is Copyright (C) 2006-2009
 * Fachhochschule Hannover (University of Applied Sciences and Arts)
 * Use is subject to license conditions.
 *
 * The main licensing options available are:
 *
 * Open Source Licensing. This is the appropriate option if you want to
 * share the source code of your application with everyone you
 * distribute it to, and you also want to give them the right to share
 * who uses it. If you wish to use TNC@FHH under Open Source Licensing,
 * you must contribute all your source code to the open source
 * community in accordance with the GPL Version 2 when your application
 * is distributed. See http://www.gnu.org/licenses/gpl-2.0.html/ or gpl-2.0.txt
 *
 * Commercial Licensing. This is the appropriate option if you are
 * creating proprietary applications and you are not prepared to
 * distribute and share the source code of your application.
 * Contact trust@f4-i.fh-hannover.de for details.
 *
 * http://trust.inform.fh-hannover.de/
 */

#ifndef _HOSTSCANNERIMV_H_
#define _HOSTSCANNERIMV_H_

#include <imunit/imv/AbstractIMV.h>
#include "HostScannerIMVLibrary.h"
#include <string>
#include <vector>
#include <map>

#include <hostscannerimvConfig.h> // generated by cmake

/**
 * Header file for IMV HostScanner. This IMV checks the scan for open ports
 * done by the corresponding IMC on the client.
 *
 * <h3>Changelog:</h3>
 * <ul>
 *   <li>06.05.2008 - create class (Daniel Wuttke)</li>
 *   <li>11.02.2008 - redesign (ib)</li>
 *   <li>09.05.2008 - redesign (mbs)</li>
 *   <li>19.06.2009 - redesign 0.6.0 (ib)</li>
 *   <li>30.07.2009 - update to 0.6.0 (mbs)</li>
 * </ul>
 *
 * @class HostScannerIMV
 * @brief This IMV ckecks a clients' open ports.
 * @date 06.05.2008
 * @author Daniel Wuttke
 * @author Ingo Bente (ib)
 */
class HostScannerIMV : public tncfhh::iml::AbstractIMV
{
    private:
    	/**
    	 * Layer 4 Protocol
    	 */
    	enum Protocol {TCP, UDP};

    	/**
    	 * Status of the port
    	 */
    	enum Status {open, close, whatever};

    	/**
    	 * Triple of protocol, port and status
    	 */
    	class Policy
    	{
    		public:
    			Protocol protocol;
    			unsigned short port;
    			Status status;

    			Policy(Protocol pr, unsigned short po, Status s);
    	};

    	std::vector<Policy> policys;

    	unsigned int count;

        /**
         * Reads one line from file ans writes it into the buffer
         * including '\0' and excluding '\n'.
         *
         * @param in Stream of the file from which shall be read.
         * @param buf Buffer where the read line is saved.
         * @param size Size of the buffer.
         */
    	bool readLine(std::istream &in, char *buf, const int size);

        /**
         * Trims the string according to the specified delimiters.
         *
         * @param source The string that shall be trimmed.
         * @param delims Delimiters specified as separate char's.
         * @return The greatest substring from source that does not contain any character
         *         specified as delimiter.
         */
    	std::string trim(std::string const& source, char const* delims = " \t\r\n");

        /**
         * Reads all properties from the file.
         *
         * @param in Stream of the file from which shall be read.
         * @return A vector of key value pairs.
         */
    	std::vector<std::pair<std::string,std::string> > readAllProperties(std::istream &in);

    public:
    	/**
		 * Ctor
		 */
	    HostScannerIMV(TNC_ConnectionID conID, HostScannerIMVLibrary *pHostScannerIMVLibrary);

	    /**
		 * Dtor
		 */
	    virtual ~HostScannerIMV();

	    /**
	     * receiveMessage
	     */
        virtual TNC_Result receiveMessage(TNC_BufferReference message,
        			                      TNC_UInt32 messageLength,
        			                      TNC_MessageType messageType);

        /**
         * notifyConnectionChange
         */
        virtual TNC_Result notifyConnectionChange();

        /**
         * batchEnding
         */
    	virtual TNC_Result batchEnding();

    	/**
    	 * Sets status of IMV when an IF-M protocol error occurs
    	 */
    	virtual TNC_Result clientError(std::string s);
};

#endif //_HOSTSCANNERIMV_H_
