/*
 * This software is Copyright (C) 2006-2010
 * Fachhochschule Hannover (University of Applied Sciences and Arts)
 * Use is subject to license conditions.
 *
 * The main licensing options available are:
 *
 * Open Source Licensing. This is the appropriate option if you want to
 * share the source code of your application with everyone you
 * distribute it to, and you also want to give them the right to share
 * who uses it. If you wish to use TNC@FHH under Open Source Licensing,
 * you must contribute all your source code to the open source
 * community in accordance with the GPL Version 2 when your application
 * is distributed. See http://www.gnu.org/licenses/gpl-2.0.html/ or gpl-2.0.txt
 *
 * Commercial Licensing. This is the appropriate option if you are
 * creating proprietary applications and you are not prepared to
 * distribute and share the source code of your application.
 * Contact trust@f4-i.fh-hannover.de for details.
 *
 * http://trust.inform.fh-hannover.de/
 */

#ifndef CLAMAVIMV_H_
#define CLAMAVIMV_H_

#include <imunit/imv/AbstractIMV.h>
#include "ClamavIMVLibrary.h"

#include <vector>

// file is generated by calling cmake
#include <clamavimvConfig.h>

/**
 * ClamavIMV.
 *
 * <h3>Changelog:</h3>
 * <ul>
 *   <li>11.01.2010 - create class (ib)</li>
 * </ul>
 *
 * @date 11.01.2010
 * @author Ingo Bente (ib)
 */
class ClamavIMV: public tncfhh::iml::AbstractIMV {
public:
	/**
	 * Ctor.
	 */
	ClamavIMV(TNC_ConnectionID conID, ClamavIMVLibrary *pClamavImvLibrary);

	/**
	 * Dtor.
	 */
	virtual ~ClamavIMV();

	// ===================
	// methods to override
	// ===================

	/**
	 * notifyConnectionChange
	 */
	virtual TNC_Result notifyConnectionChange();

	/**
	 * receiveMessage
	 */
	virtual TNC_Result receiveMessage(TNC_BufferReference message,
			                          TNC_UInt32 messageLength,
			                          TNC_MessageType messageType);

	/**
	 * batchEnding
	 */
	virtual TNC_Result batchEnding();

protected:

	/**
	 * Enum for valid policy keys
	 */
	enum Key{
		OperationalStatus,
		Version,
		Main_Version,
		Daily_Version
	};

	/**
	 * Enum for valid policy operants
	 */
	enum Operant{
		eq,
		gt,
		lt,
		gte,
		lte,
		uneq
	};

	/**
	 * Class wrapping a policy entry. Contains Key, Operant and String value.
	 */
	class PolicyEntry{
	public:
		Key key;
		Operant operant;
		std::string value;

		PolicyEntry(Key key, Operant operant, std::string value);
	};

	class Measurement {
	public:
		Key key;
		std::string keyAsString;
		std::string value;

		Measurement(Key key, std::string keyAsString, std::string value);
	};

	/**
	 * Parses the policy of the ClamavIMV. All specified entries are saved
	 * in the corresponding member variable. The policy parsing takes
	 * place at the beginning of each new handshake.
	 */
	void parsePolicy();

	/**
	 * Saves a policy entry in the corresponding member variable.
	 * Is called by parsePolicy().
	 */
	void savePolicyEntry(std::string key, std::string operant, std::string value);

	/**
	 * Container for all policy entries.
	 */
	std::vector<PolicyEntry> policyEntries;

	private:
	TNC_IMV_Action_Recommendation doLocalEvaluation(std::vector<Measurement>* measurements);
	bool doXACMLEvaluation(std::vector<Measurement>* measurements);
	bool compareVersionStrings(std::string in, std::string policy);
};

#endif /* CLAMAVIMV_H_ */
