#FindImunit.cmake
#
# Created on: 11.07.2009
#     Author: mike
#

FIND_PATH(Imunit_INCLUDE_DIR NAMES imunit PATH_SUFFIXES src)

FIND_LIBRARY(Imunit_LIBRARY imunit)

IF(Imunit_INCLUDE_DIR)
    IF(EXISTS "${Imunit_INCLUDE_DIR}/imunit/version.h")
        FILE(READ "${Imunit_INCLUDE_DIR}/imunit/version.h" _imunit_VERSION_H_CONTENTS)
    
        STRING(REGEX REPLACE ".*#define IMUNIT_VERSION_MAJOR *([0-9]+).*" "\\1" Imunit_VERSION_MAJOR "${_imunit_VERSION_H_CONTENTS}")
        STRING(REGEX REPLACE ".*#define IMUNIT_VERSION_MINOR *([0-9]+).*" "\\1" Imunit_VERSION_MINOR "${_imunit_VERSION_H_CONTENTS}")
        STRING(REGEX REPLACE ".*#define IMUNIT_VERSION_PATCH *([0-9]+).*" "\\1" Imunit_VERSION_PATCH "${_imunit_VERSION_H_CONTENTS}")
        STRING(REGEX REPLACE ".*#define IMUNIT_VERSION_TWEAK *([0-9]+).*" "\\1" Imunit_VERSION_TWEAK "${_imunit_VERSION_H_CONTENTS}")
        STRING(REGEX REPLACE ".*#define IMUNIT_VERSION_SUPPLEMENT *\"([^\"]*)\".*" "\\1" Imunit_VERSION_SUPPLEMENT "${_imunit_VERSION_H_CONTENTS}")
    
        STRING(REGEX REPLACE ".*#define IMUNIT_VERSION \"([^\"]+)\".*" "\\1" Imunit_VERSION "${_imunit_VERSION_H_CONTENTS}")
    ELSE()
        INCLUDE("${Imunit_INCLUDE_DIR}/../imunitVersion.cmake")
        LIST(APPEND Imunit_INCLUDE_DIRS "${Imunit_INCLUDE_DIR}/../include")
        GET_FILENAME_COMPONENT(TMP_Imunit_LIBRARY_DIR "${Imunit_LIBRARY}" PATH)
        LIST(APPEND Imunit_INCLUDE_DIRS "${TMP_Imunit_LIBRARY_DIR}")
        
        SET(Imunit_VERSION "${Imunit_VERSION_MAJOR}.${Imunit_VERSION_MINOR}.${Imunit_VERSION_PATCH}")
        IF (Imunit_VERSION_TWEAK)
            SET(Imunit_VERSION "${Imunit_VERSION}.${Imunit_VERSION_TWEAK}")
        ENDIF (Imunit_VERSION_TWEAK)
        IF (Imunit_VERSION_SUPPLEMENT)
            SET(Imunit_VERSION "${Imunit_VERSION}-${Imunit_VERSION_SUPPLEMENT}")
        ENDIF (Imunit_VERSION_SUPPLEMENT)
    ENDIF()
ENDIF()

IF (Imunit_INCLUDE_DIR AND Imunit_LIBRARY)
   SET(Imunit_FOUND TRUE)
ENDIF (Imunit_INCLUDE_DIR AND Imunit_LIBRARY)

IF(Imunit_FOUND)
    IF(Imunit_FIND_VERSION_MAJOR AND NOT Imunit_FIND_VERSION_MAJOR EQUAL "${Imunit_VERSION_MAJOR}")
        IF(Imunit_FIND_VERSION_EXACT OR Imunit_FIND_VERSION_MAJOR GREATER "${Imunit_VERSION_MAJOR}")
            SET(Imunit_FOUND FALSE)
        ENDIF()
    ELSE()
        IF(Imunit_FIND_VERSION_MINOR AND NOT Imunit_FIND_VERSION_MINOR EQUAL "${Imunit_VERSION_MINOR}")
            IF(Imunit_FIND_VERSION_EXACT OR Imunit_FIND_VERSION_MINOR GREATER "${Imunit_VERSION_MINOR}")
                SET(Imunit_FOUND FALSE)
            ENDIF()
        ELSE()
            IF(Imunit_FIND_VERSION_PATCH AND NOT Imunit_FIND_VERSION_PATCH EQUAL "${Imunit_VERSION_PATCH}")
                IF(Imunit_FIND_VERSION_EXACT OR Imunit_FIND_VERSION_PATCH GREATER "${Imunit_VERSION_PATCH}")
                    SET(Imunit_FOUND FALSE)
                ENDIF()
            ELSE()
                IF(Imunit_FIND_VERSION_TWEAK AND NOT Imunit_FIND_VERSION_TWEAK EQUAL "${Imunit_VERSION_TWEAK}")
                    IF(Imunit_FIND_VERSION_EXACT OR Imunit_FIND_VERSION_TWEAK GREATER "${Imunit_VERSION_TWEAK}")
                        SET(Imunit_FOUND FALSE)
                    ENDIF()
                ENDIF()
            ENDIF()
        ENDIF()
    ENDIF()
ENDIF(Imunit_FOUND)

# log4cxx
FIND_PACKAGE(Log4cxx REQUIRED)
IF (Log4cxx_FOUND)
    LIST(APPEND Imunit_INCLUDE_DIRS "${Log4cxx_INCLUDE_DIR}")
    LIST(APPEND Imunit_LIBRARIES "${Log4cxx_LIBRARY}")
ELSE (Log4cxx_FOUND)
    SET(Imunit_FOUND FALSE)
ENDIF (Log4cxx_FOUND)

IF (Imunit_FOUND)
    LIST(APPEND Imunit_INCLUDE_DIRS "${Imunit_INCLUDE_DIR}")
    LIST(APPEND Imunit_LIBRARIES "${Imunit_LIBRARY}")

   IF (NOT Imunit_FIND_QUIETLY)
      MESSAGE(STATUS "Found imunit: ${Imunit_LIBRARY} (${Imunit_VERSION})")
   ENDIF (NOT Imunit_FIND_QUIETLY)
ELSE (Imunit_FOUND)
   IF (NOT Imunit_INCLUDE_DIR AND NOT Imunit_LIBRARY)
       SET(TMP_REASON "Include and Library not found.")
   ELSEIF(Imunit_INCLUDE_DIR AND NOT Imunit_LIBRARY)
       SET(TMP_REASON "Library not found.")
   ELSEIF(NOT Imunit_INCLUDE_DIR AND Imunit_LIBRARY)
       SET(TMP_REASON "Include not found.")
   ELSEIF(NOT Log4cxx_FOUND)
       SET(TMP_REASON "Log4cxx not found.")
   ELSE (NOT Imunit_INCLUDE_DIR AND NOT Imunit_LIBRARY)
       SET(TMP_REASON "Version ${Imunit_FIND_VERSION} not found.")
   ENDIF(NOT Imunit_INCLUDE_DIR AND NOT Imunit_LIBRARY)

   IF (Imunit_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find imunit. Reason: ${TMP_REASON}")
   ELSE (Imunit_FIND_REQUIRED)
      MESSAGE(STATUS "Could not find imunit. Reason: ${TMP_REASON}")
   ENDIF (Imunit_FIND_REQUIRED)
ENDIF (Imunit_FOUND)
