/*
 * Tlog-rec-session JSON configuration validation.
 *
 * vim:nomodifiable
 * 
 * ************************* WARNING! DO NOT EDIT! *************************
 * This file is automatically generated from conf_validate.c.m4.
 * *************************************************************************
 *
 * Copyright (C) 2016 Red Hat
 *
 * This file is part of tlog.
 *
 * Tlog is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tlog is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with tlog; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <tlog/rec_session_conf_validate.h>
#include <tlog/grc.h>
#include <tlog/rc.h>
#include <tlog/misc.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <inttypes.h>

static tlog_grc
tlog_rec_session_conf_validate_log(struct tlog_errs **perrs,
                                struct json_object *conf,
                                enum tlog_conf_origin origin)
{
    assert(conf != NULL);

    json_object_object_foreach(conf, name, obj) {
        enum json_type type = json_object_get_type(obj);

        if (origin >= TLOG_CONF_ORIGIN_FILE &&
            strcmp(name, "input") == 0) {
            if (type != json_type_boolean) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        if (origin >= TLOG_CONF_ORIGIN_FILE &&
            strcmp(name, "output") == 0) {
            if (type != json_type_boolean) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        if (origin >= TLOG_CONF_ORIGIN_FILE &&
            strcmp(name, "window") == 0) {
            if (type != json_type_boolean) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        tlog_errs_pushf(perrs, "Unexpected node: \"%s\"", name);
        return TLOG_RC_FAILURE;
    }
    return TLOG_RC_OK;
}

static tlog_grc
tlog_rec_session_conf_validate_limit(struct tlog_errs **perrs,
                                struct json_object *conf,
                                enum tlog_conf_origin origin)
{
    assert(conf != NULL);

    json_object_object_foreach(conf, name, obj) {
        enum json_type type = json_object_get_type(obj);

        if (origin >= TLOG_CONF_ORIGIN_FILE &&
            strcmp(name, "rate") == 0) {
            if (type != json_type_int) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            int64_t value = json_object_get_int64(obj);
            if (value < 0) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" value: %" PRId64,
                                name, value);
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        if (origin >= TLOG_CONF_ORIGIN_FILE &&
            strcmp(name, "burst") == 0) {
            if (type != json_type_int) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            int64_t value = json_object_get_int64(obj);
            if (value < 0) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" value: %" PRId64,
                                name, value);
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        if (origin >= TLOG_CONF_ORIGIN_FILE &&
            strcmp(name, "action") == 0) {
            if (type != json_type_string) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            const char *value_list[] = {"pass",
                                        "delay",
                                        "drop"};
            const char *value = json_object_get_string(obj);
            size_t i;
            for (i = 0;
                 i < TLOG_ARRAY_SIZE(value_list) &&
                 strcmp(value, value_list[i]) != 0;
                 i++);
            if (i >= TLOG_ARRAY_SIZE(value_list)) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" value: %s",
                                name, value);
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        tlog_errs_pushf(perrs, "Unexpected node: \"%s\"", name);
        return TLOG_RC_FAILURE;
    }
    return TLOG_RC_OK;
}

static tlog_grc
tlog_rec_session_conf_validate_file(struct tlog_errs **perrs,
                                struct json_object *conf,
                                enum tlog_conf_origin origin)
{
    assert(conf != NULL);

    json_object_object_foreach(conf, name, obj) {
        enum json_type type = json_object_get_type(obj);

        if (origin >= TLOG_CONF_ORIGIN_FILE &&
            strcmp(name, "path") == 0) {
            if (type != json_type_string) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        tlog_errs_pushf(perrs, "Unexpected node: \"%s\"", name);
        return TLOG_RC_FAILURE;
    }
    return TLOG_RC_OK;
}

static tlog_grc
tlog_rec_session_conf_validate_syslog(struct tlog_errs **perrs,
                                struct json_object *conf,
                                enum tlog_conf_origin origin)
{
    assert(conf != NULL);

    json_object_object_foreach(conf, name, obj) {
        enum json_type type = json_object_get_type(obj);

        if (origin >= TLOG_CONF_ORIGIN_FILE &&
            strcmp(name, "facility") == 0) {
            if (type != json_type_string) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            const char *value_list[] = {"auth",
                                        "authpriv",
                                        "cron",
                                        "daemon",
                                        "ftp",
                                        "kern",
                                        "local0",
                                        "local1",
                                        "local2",
                                        "local3",
                                        "local4",
                                        "local5",
                                        "local6",
                                        "local7",
                                        "lpr",
                                        "mail",
                                        "news",
                                        "syslog",
                                        "user",
                                        "uucp"};
            const char *value = json_object_get_string(obj);
            size_t i;
            for (i = 0;
                 i < TLOG_ARRAY_SIZE(value_list) &&
                 strcmp(value, value_list[i]) != 0;
                 i++);
            if (i >= TLOG_ARRAY_SIZE(value_list)) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" value: %s",
                                name, value);
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        if (origin >= TLOG_CONF_ORIGIN_FILE &&
            strcmp(name, "priority") == 0) {
            if (type != json_type_string) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            const char *value_list[] = {"emerg",
                                        "alert",
                                        "crit",
                                        "err",
                                        "warning",
                                        "notice",
                                        "info",
                                        "debug"};
            const char *value = json_object_get_string(obj);
            size_t i;
            for (i = 0;
                 i < TLOG_ARRAY_SIZE(value_list) &&
                 strcmp(value, value_list[i]) != 0;
                 i++);
            if (i >= TLOG_ARRAY_SIZE(value_list)) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" value: %s",
                                name, value);
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        tlog_errs_pushf(perrs, "Unexpected node: \"%s\"", name);
        return TLOG_RC_FAILURE;
    }
    return TLOG_RC_OK;
}

static tlog_grc
tlog_rec_session_conf_validate_journal(struct tlog_errs **perrs,
                                struct json_object *conf,
                                enum tlog_conf_origin origin)
{
    assert(conf != NULL);

    json_object_object_foreach(conf, name, obj) {
        enum json_type type = json_object_get_type(obj);

        if (origin >= TLOG_CONF_ORIGIN_FILE &&
            strcmp(name, "priority") == 0) {
            if (type != json_type_string) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            const char *value_list[] = {"emerg",
                                        "alert",
                                        "crit",
                                        "err",
                                        "warning",
                                        "notice",
                                        "info",
                                        "debug"};
            const char *value = json_object_get_string(obj);
            size_t i;
            for (i = 0;
                 i < TLOG_ARRAY_SIZE(value_list) &&
                 strcmp(value, value_list[i]) != 0;
                 i++);
            if (i >= TLOG_ARRAY_SIZE(value_list)) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" value: %s",
                                name, value);
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        if (origin >= TLOG_CONF_ORIGIN_FILE &&
            strcmp(name, "augment") == 0) {
            if (type != json_type_boolean) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        tlog_errs_pushf(perrs, "Unexpected node: \"%s\"", name);
        return TLOG_RC_FAILURE;
    }
    return TLOG_RC_OK;
}

tlog_grc
tlog_rec_session_conf_validate(struct tlog_errs **perrs,
                                struct json_object *conf,
                                enum tlog_conf_origin origin)
{
    assert(conf != NULL);

    json_object_object_foreach(conf, name, obj) {
        enum json_type type = json_object_get_type(obj);

        if (origin >= TLOG_CONF_ORIGIN_ARGS &&
            strcmp(name, "args") == 0) {
            if (type != json_type_array) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            size_t i;
            for (i = 0; i < (size_t)json_object_array_length(obj); i++) {
                struct json_object *item_obj = json_object_array_get_idx(obj, i);
                enum json_type item_type = json_object_get_type(item_obj);
                if (item_type != json_type_string) {
                    tlog_errs_pushf(perrs, "Invalid \"%s\" item #%zu type: %s",
                                    name, i, json_type_to_name(item_type));
                    return TLOG_RC_FAILURE;
                }
            }
            continue;
        }

        if (origin >= TLOG_CONF_ORIGIN_OPTS &&
            strcmp(name, "help") == 0) {
            if (type != json_type_boolean) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        if (origin >= TLOG_CONF_ORIGIN_OPTS &&
            strcmp(name, "version") == 0) {
            if (type != json_type_boolean) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        if (origin >= TLOG_CONF_ORIGIN_OPTS &&
            strcmp(name, "configuration") == 0) {
            if (type != json_type_boolean) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        if (origin >= TLOG_CONF_ORIGIN_FILE &&
            strcmp(name, "shell") == 0) {
            if (type != json_type_string) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        if (origin >= TLOG_CONF_ORIGIN_NAME &&
            strcmp(name, "login") == 0) {
            if (type != json_type_boolean) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        if (origin >= TLOG_CONF_ORIGIN_OPTS &&
            strcmp(name, "command") == 0) {
            if (type != json_type_boolean) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        if (origin >= TLOG_CONF_ORIGIN_FILE &&
            strcmp(name, "notice") == 0) {
            if (type != json_type_string) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        if (origin >= TLOG_CONF_ORIGIN_FILE &&
            strcmp(name, "latency") == 0) {
            if (type != json_type_int) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            int64_t value = json_object_get_int64(obj);
            if (value < 1) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" value: %" PRId64,
                                name, value);
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        if (origin >= TLOG_CONF_ORIGIN_FILE &&
            strcmp(name, "payload") == 0) {
            if (type != json_type_int) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            int64_t value = json_object_get_int64(obj);
            if (value < 32) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" value: %" PRId64,
                                name, value);
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        if (strcmp(name, "log") == 0) {
            tlog_grc grc;
            if (type != json_type_object) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            grc = tlog_rec_session_conf_validate_log(perrs, obj, origin);
            if (grc != TLOG_RC_OK) {
                tlog_errs_pushf(perrs, "Failed to validate \"%s\" section", name);
                return grc;
            }
            continue;
        }

        if (strcmp(name, "limit") == 0) {
            tlog_grc grc;
            if (type != json_type_object) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            grc = tlog_rec_session_conf_validate_limit(perrs, obj, origin);
            if (grc != TLOG_RC_OK) {
                tlog_errs_pushf(perrs, "Failed to validate \"%s\" section", name);
                return grc;
            }
            continue;
        }

        if (strcmp(name, "file") == 0) {
            tlog_grc grc;
            if (type != json_type_object) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            grc = tlog_rec_session_conf_validate_file(perrs, obj, origin);
            if (grc != TLOG_RC_OK) {
                tlog_errs_pushf(perrs, "Failed to validate \"%s\" section", name);
                return grc;
            }
            continue;
        }

        if (strcmp(name, "syslog") == 0) {
            tlog_grc grc;
            if (type != json_type_object) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            grc = tlog_rec_session_conf_validate_syslog(perrs, obj, origin);
            if (grc != TLOG_RC_OK) {
                tlog_errs_pushf(perrs, "Failed to validate \"%s\" section", name);
                return grc;
            }
            continue;
        }

        if (strcmp(name, "journal") == 0) {
            tlog_grc grc;
            if (type != json_type_object) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            grc = tlog_rec_session_conf_validate_journal(perrs, obj, origin);
            if (grc != TLOG_RC_OK) {
                tlog_errs_pushf(perrs, "Failed to validate \"%s\" section", name);
                return grc;
            }
            continue;
        }

        if (origin >= TLOG_CONF_ORIGIN_FILE &&
            strcmp(name, "writer") == 0) {
            if (type != json_type_string) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" type: %s",
                                name, json_type_to_name(type));
                return TLOG_RC_FAILURE;
            }
            const char *value_list[] = {"journal",
                                        "syslog",
                                        "file"};
            const char *value = json_object_get_string(obj);
            size_t i;
            for (i = 0;
                 i < TLOG_ARRAY_SIZE(value_list) &&
                 strcmp(value, value_list[i]) != 0;
                 i++);
            if (i >= TLOG_ARRAY_SIZE(value_list)) {
                tlog_errs_pushf(perrs, "Invalid \"%s\" value: %s",
                                name, value);
                return TLOG_RC_FAILURE;
            }
            continue;
        }

        tlog_errs_pushf(perrs, "Unexpected node: \"%s\"", name);
        return TLOG_RC_FAILURE;
    }
    return TLOG_RC_OK;
}

