/*
 * Tlog-rec-session command-line parsing.
 *
 * vim:nomodifiable
 * 
 * ************************* WARNING! DO NOT EDIT! *************************
 * This file is automatically generated from rec_session_conf_cmd.c.m4.
 * *************************************************************************
 *
 * Copyright (C) 2016 Red Hat
 *
 * This file is part of tlog.
 *
 * Tlog is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tlog is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with tlog; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <config.h>
#include <tlog/rec_session_conf_validate.h>
#include <tlog/rec_session_conf_cmd.h>
#include <tlog/json_misc.h>
#include <tlog/rc.h>
#include <tlog/misc.h>
#include <libgen.h>
#include <stdio.h>
#include <unistd.h>
#include <getopt.h>
#include <string.h>
#include <inttypes.h>
#include <assert.h>

static const char *tlog_rec_session_conf_cmd_help_fmt =
    "Usage: %1$s [OPTION...] [CMD_FILE [CMD_ARG...]]\n"
    "   or: %1$s -c [OPTION...] CMD_STRING [CMD_NAME [CMD_ARG...]]\n"
    "Start a shell and log terminal I/O.\n"
    "\n"
    "General options:\n"
    "    -h, --help                  Output a command-line usage message and exit\n"
    "    -v, --version               Output version information and exit\n"
    "    --configuration             Output program configuration in JSON and exit\n"
    "    -l, --login                 Make the shell a login shell\n"
    "    -c, --command               Execute shell commands\n"
    "";

static tlog_grc
tlog_rec_session_conf_cmd_load_args(struct tlog_errs **perrs,
                            struct json_object *conf,
                            const char *help,
                            int argc, char **argv)
{
    /* Option codes */
    enum opt {
        OPT_HELP = 'h',
        OPT_VERSION = 'v',
        OPT_LOGIN = 'l',
        OPT_COMMAND = 'c',
        OPT_CONFIGURATION = 0x100,
    };

    /* Description of short options */
    static const char *shortopts = "+:h::v::l::c::";

    /* Description of long options */
    static const struct option longopts[] = {
        {
            .name = "help",
            .val = OPT_HELP,
            .has_arg = optional_argument,
        },
        {
            .name = "version",
            .val = OPT_VERSION,
            .has_arg = optional_argument,
        },
        {
            .name = "configuration",
            .val = OPT_CONFIGURATION,
            .has_arg = optional_argument,
        },
        {
            .name = "login",
            .val = OPT_LOGIN,
            .has_arg = optional_argument,
        },
        {
            .name = "command",
            .val = OPT_COMMAND,
            .has_arg = optional_argument,
        },
        {
            .name = NULL
        }
    };

    tlog_grc grc;
    int opterr_orig;
    int optind_orig;
    int optcode;
    const char *optname;
    const char *optpath;
    int64_t val_int;
    double val_double;
    struct json_object *prev_val;
    struct json_object *val = NULL;
    struct json_object *entry_val = NULL;
    struct json_object *args = NULL;
    int end;
    int i;

    /* May be unused if there are no corresponding parameters */
    (void)val_int;
    (void)val_double;
    (void)end;

    /* Ask getopt_long to not print an error message */
    opterr_orig = opterr;
    opterr = 0;

    /* Ask getopt_long to start from the first argument */
    optind_orig = optind;
    optind = 1;

    /* While there are options */
    while ((optcode = getopt_long(argc, argv, 
                                  shortopts, longopts, NULL)) >= 0) {
        switch (optcode) {
        case OPT_HELP:
            optname = "-h/--help";
            optpath = "help";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_VERSION:
            optname = "-v/--version";
            optpath = "version";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_CONFIGURATION:
            optname = "--configuration";
            optpath = "configuration";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_LOGIN:
            optname = "-l/--login";
            optpath = "login";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case OPT_COMMAND:
            optname = "-c/--command";
            optpath = "command";
            grc = tlog_json_object_object_get_path(conf, optpath, &prev_val, NULL);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc,
                                  "Failed retrieving %s option value", optname);
            }
            if (optarg == NULL ||
                strcasecmp(optarg, "yes") == 0 ||
                strcasecmp(optarg, "on") == 0 ||
                strcasecmp(optarg, "true") == 0) {
                val = json_object_new_boolean(true);
            } else if (strcasecmp(optarg, "no") == 0 ||
                       strcasecmp(optarg, "off") == 0 ||
                       strcasecmp(optarg, "false") == 0) {
                val = json_object_new_boolean(false);
            } else {
                grc = TLOG_RC_FAILURE;
                TLOG_ERRS_RAISEF("Invalid %s option value: %s,\n"
                                 "expecting yes/on/true or no/off/false\n%s",
                                 optname, optarg, help);
            }
            break;

        case ':':
            for (i = 0; i < (int)TLOG_ARRAY_SIZE(longopts); i++) {
                if (longopts[i].val == optopt) {
                    break;
                }
            }
            grc = TLOG_RC_FAILURE;
            if (i < (int)TLOG_ARRAY_SIZE(longopts)) {
                if (longopts[i].val < 0x100) {
                    TLOG_ERRS_RAISEF("Option -%c/--%s argument is missing\n%s",
                                     longopts[i].val, longopts[i].name, help);
                } else {
                    TLOG_ERRS_RAISEF("Option --%s argument is missing\n%s",
                                     longopts[i].name, help);
                }
            } else {
                TLOG_ERRS_RAISEF("Option -%c argument is missing\n%s",
                                 optopt, help);
            }

        case '?':
            grc = TLOG_RC_FAILURE;
            if (optopt == 0) {
                TLOG_ERRS_RAISEF("Unknown option encountered\n%s",
                                 help);
            } else {
                TLOG_ERRS_RAISEF("Unknown option encountered: -%c\n%s",
                                 optopt, help);
            }

        default:
            grc = TLOG_RC_FAILURE;
            TLOG_ERRS_RAISEF("Unknown option code: %d", optcode);
        }

        if (val == NULL) {
            grc = TLOG_GRC_ERRNO;
            TLOG_ERRS_RAISECF(grc, "Failed creating %s option value", optname);
        }
        if (val != prev_val) {
            grc = tlog_json_object_object_add_path(conf, optpath, val);
            if (grc != TLOG_RC_OK) {
                TLOG_ERRS_RAISECF(grc, "Failed storing %s option value", optname);
            }
        }
        val = NULL;
    }

    /* Add other arguments */
    args = json_object_new_array();
    if (args == NULL) {
        grc = TLOG_GRC_ERRNO;
        TLOG_ERRS_RAISECS(grc, "Failed creating positional argument list");
    }
    for (i = 0; optind < argc; i++, optind++) {
        val = json_object_new_string(argv[optind]);
        if (val == NULL) {
            grc = TLOG_GRC_ERRNO;
            TLOG_ERRS_RAISECS(grc, "Failed creating argument value");
        }
        if (json_object_array_put_idx(args, i, val) < 0) {
            grc = TLOG_GRC_ERRNO;
            TLOG_ERRS_RAISECF(grc, "Failed storing argument #%d", i);
        }
        val = NULL;
    }
    grc = tlog_json_object_object_add_path(conf, "args", args);
    if (grc != TLOG_RC_OK) {
        TLOG_ERRS_RAISECS(grc, "Failed storing argument list");
    }
    args = NULL;

    /* Validate the result */
    grc = tlog_rec_session_conf_validate(perrs, conf, TLOG_CONF_ORIGIN_ARGS);
    if (grc != TLOG_RC_OK) {
        TLOG_ERRS_RAISES("Failed to validate loaded configuration");
    }

    grc = TLOG_RC_OK;

cleanup:
    json_object_put(args);
    json_object_put(entry_val);
    json_object_put(val);
    optind = optind_orig;
    opterr = opterr_orig;
    return grc;
}

tlog_grc
tlog_rec_session_conf_cmd_load(struct tlog_errs **perrs,
                               char **phelp, struct json_object **pconf,
                               int argc, char **argv)
{
    tlog_grc grc;
    char *progpath = NULL;
    const char *shell_suffix = "-shell-";
    const char *progname_start;
    const char *progname_end;
    const char *shell_start;
    char *shell = NULL;
    char *src;
    char *dst;
    char *progname = NULL;
    char *help = NULL;
    struct json_object *conf = NULL;
    struct json_object *val = NULL;

    assert(phelp != NULL);
    assert(pconf != NULL);
    assert(argv != NULL);

    /* Create empty configuration */
    conf = json_object_new_object();
    if (conf == NULL) {
        grc = TLOG_GRC_ERRNO;
        TLOG_ERRS_RAISECS(grc, "Failed creating configuration object");
    }

    /* Get program path */
    progpath = strdup(argv[0]);
    if (progpath == NULL) {
        grc = TLOG_GRC_ERRNO;
        TLOG_ERRS_RAISECS(grc, "Failed allocating a copy of program path");
    }

    /* Check for and extract login dash prefix */
    progname_start = basename(progpath);
    if (progname_start[0] == '-') {
        progname_start++;
        val = json_object_new_boolean(true);
        if (val == NULL) {
            grc = TLOG_GRC_ERRNO;
            TLOG_ERRS_RAISECS(grc, "Failed creating login flag");
        }
        grc = tlog_json_object_object_add_path(conf, "login", val);
        if (grc != TLOG_RC_OK) {
            TLOG_ERRS_RAISECS(grc, "Failed storing login flag");
        }
        val = NULL;
    }

    /* Check for the shell suffix and extract the shell */
    progname_end = strstr(progname_start, shell_suffix);
    if (progname_end == NULL) {
        progname_end = progname_start + strlen(progname_start);
    } else {
        /* Copy the encoded shell path */
        assert(strlen(shell_suffix) > 0);
        assert(shell_suffix[strlen(shell_suffix) - 1] == '-');
        shell_start = progname_end + strlen(shell_suffix) - 1;
        shell = strdup(shell_start);
        if (shell == NULL) {
            grc = TLOG_GRC_ERRNO;
            TLOG_ERRS_RAISECS(grc,
                              "Failed allocating a copy of the shell part "
                              "of the program name");
        }
        /* Decode and unescape the shell path */
        for (dst = src = shell; ;) {
            if (*src == '-') {
                *dst = '/';
                continue;
            } else if (*src == '\\') {
                src++;
            }
            if ((*dst++ = *src++) == '\0') {
                break;
            }
        }
        /* Store the shell */
        val = json_object_new_string(shell);
        if (val == NULL) {
            grc = TLOG_GRC_ERRNO;
            TLOG_ERRS_RAISECS(grc, "Failed creating shell path object");
        }
        grc = tlog_json_object_object_add_path(conf, "shell", val);
        if (grc != TLOG_RC_OK) {
            TLOG_ERRS_RAISECS(grc, "Failed storing shell path");
        }
        val = NULL;
    }

    /* Extract the program name */
    progname = strndup(progname_start, progname_end - progname_start);
    if (progname == NULL) {
        grc = TLOG_GRC_ERRNO;
        TLOG_ERRS_RAISECS(grc, "Failed allocating program name");
    }

    /* Extract options and positional arguments */
    if (asprintf(&help, tlog_rec_session_conf_cmd_help_fmt, progname) < 0) {
        grc = TLOG_GRC_ERRNO;
        TLOG_ERRS_RAISECS(grc, "Failed formatting help message");
    }
    grc = tlog_rec_session_conf_cmd_load_args(perrs, conf, help, argc, argv);
    if (grc != TLOG_RC_OK) {
        TLOG_ERRS_RAISES("Failed extracting configuration "
                         "from options and arguments");
    }

    /* Validate the result */
    grc = tlog_rec_session_conf_validate(perrs, conf, TLOG_CONF_ORIGIN_ARGS);
    if (grc != TLOG_RC_OK) {
        TLOG_ERRS_RAISES("Validation of loaded configuration failed");
    }

    *phelp = help;
    help = NULL;
    *pconf = conf;
    conf = NULL;
    grc = TLOG_RC_OK;

cleanup:
    free(help);
    free(progname);
    free(shell);
    free(progpath);
    json_object_put(val);
    json_object_put(conf);
    return grc;
}
