.TH vncpasswd 1 "" "TigerVNC" "Virtual Network Computing"
.SH NAME
vncpasswd \- change the VNC password
.SH SYNOPSIS
\fBvncpasswd\fR [\fIpasswd-file\fR]
.br
\fBvncpasswd\fR \-f
.SH DESCRIPTION
.B vncpasswd
allows you to set the password used to access VNC desktops.  Its default
behavior is to prompt for a VNC password and then store an obfuscated version
of this password to \fIpasswd-file\fR (or to $HOME/.vnc/passwd if no password
file is specified.)  The \fBvncserver\fP script runs \fBvncpasswd\fP the first
time you start a VNC desktop, and it invokes \fBXvnc\fP with the appropriate
\fB\-rfbauth\fP option.  \fBvncviewer\fP can also be given a password file to
use via the \fB\-passwd\fP option.

The password must be at least six characters long (unless the \fB\-f\fR
command-line option is used-- see below), and only the first eight
characters are significant.  Note that the stored password is \fBnot\fP
encrypted securely - anyone who has access to this file can trivially find out
the plain-text password, so \fBvncpasswd\fP always sets appropriate permissions
(read and write only by the owner.)  However, when accessing a VNC desktop, a
challenge-response mechanism is used over the wire making it hard for anyone to
crack the password simply by snooping on the network.

.SH OPTIONS

.TP
.B \-f
Filter mode.  Read a plain-text password from stdin and write an encrypted
version to stdout.  Note that in filter mode, short or even empty passwords
will be silently accepted.

A view-only password must be separated from the normal password by a newline
character.


.SH FILES
.TP
$HOME/.vnc/passwd
Default location of the VNC password file.

.SH SEE ALSO
.BR vncviewer (1),
.BR vncserver (1),
.BR Xvnc (1)
.BR vncconfig (1),
.br
http://www.tigervnc.org

.SH AUTHORS
Tristan Richardson, RealVNC Ltd., Antoine Martin, D. R. Commander and others.

VNC was originally developed by the RealVNC team while at Olivetti
Research Ltd / AT&T Laboratories Cambridge.  TightVNC additions were
implemented by Constantin Kaplinsky. Many other people have since
participated in development, testing and support. This manual is part
of the TigerVNC software suite.
