/*
 * Copyright 2012-2015 Red Hat, Inc.
 *
 * This file is part of Thermostat.
 *
 * Thermostat is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2, or (at your
 * option) any later version.
 *
 * Thermostat is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Thermostat; see the file COPYING.  If not see
 * <http://www.gnu.org/licenses/>.
 *
 * Linking this code with other modules is making a combined work
 * based on this code.  Thus, the terms and conditions of the GNU
 * General Public License cover the whole combination.
 *
 * As a special exception, the copyright holders of this code give
 * you permission to link this code with independent modules to
 * produce an executable, regardless of the license terms of these
 * independent modules, and to copy and distribute the resulting
 * executable under terms of your choice, provided that you also
 * meet, for each linked independent module, the terms and conditions
 * of the license of that module.  An independent module is a module
 * which is not derived from or based on this code.  If you modify
 * this code, you may extend this exception to your version of the
 * library, but you are not obligated to do so.  If you do not wish
 * to do so, delete this exception statement from your version.
 */

package com.redhat.thermostat.schemainfo.command.internal;

import java.util.Collection;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

import com.redhat.thermostat.common.cli.AbstractCommand;
import com.redhat.thermostat.common.cli.CommandContext;
import com.redhat.thermostat.common.cli.CommandException;
import com.redhat.thermostat.schemainfo.command.locale.LocaleResources;
import com.redhat.thermostat.shared.locale.Translate;
import com.redhat.thermostat.storage.dao.SchemaInfoDAO;
import com.redhat.thermostat.storage.model.SchemaInformation;

public class SchemaInfoCommand extends AbstractCommand {

    private static final Translate<LocaleResources> translator = LocaleResources.createLocalizer();
    public static final String commandName = "list-categories";
    
    private BundleContext context;

    public SchemaInfoCommand(BundleContext context) {
        this.context = context;
    }
    
    public void run(CommandContext ctx) throws CommandException {
        ServiceReference<?> schemaInfoDaoRef = context.getServiceReference(SchemaInfoDAO.class.getName());
        requireNonNull(schemaInfoDaoRef, translator.localize(LocaleResources.SCHEMAINFO_SERVICE_UNAVAILABLE));

        SchemaInfoDAO schemaInfoDao = (SchemaInfoDAO) context.getService(schemaInfoDaoRef);
        
        Collection<SchemaInformation> categoriesList = schemaInfoDao.getSchemaInfos();
        
        if(categoriesList.isEmpty()) {
            ctx.getConsole().getOutput().println(translator.localize(LocaleResources.NO_CATEGORIES).getContents());
        } else {
            for (SchemaInformation schemaCategory : categoriesList) {
                ctx.getConsole().getOutput().println(schemaCategory.getCategoryName());
            }
        }
    }
}

