/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.jfree.util.Log;
import org.jfree.xml.attributehandlers.AttributeHandler;
import org.jfree.xml.util.AbstractModelReader;
import org.jfree.xml.util.AttributeDefinition;
import org.jfree.xml.util.ConstructorDefinition;
import org.jfree.xml.util.GenericObjectFactory;
import org.jfree.xml.util.LookupDefinition;
import org.jfree.xml.util.ManualMappingDefinition;
import org.jfree.xml.util.MultiplexMappingDefinition;
import org.jfree.xml.util.MultiplexMappingEntry;
import org.jfree.xml.util.ObjectDescriptionException;
import org.jfree.xml.util.ObjectFactory;
import org.jfree.xml.util.PropertyDefinition;

public class ObjectFactoryLoader
extends AbstractModelReader
implements ObjectFactory {
    private HashMap objectMappings = new HashMap();
    private HashMap manualMappings = new HashMap();
    private HashMap multiplexMappings = new HashMap();
    private Class target;
    private String registerName;
    private ArrayList propertyDefinition;
    private ArrayList attributeDefinition;
    private ArrayList constructorDefinition;
    private ArrayList lookupDefinitions;
    private ArrayList orderedNames;
    private String baseClass;
    private String attributeName;
    private ArrayList multiplexEntries;
    static /* synthetic */ Class class$java$lang$Object;

    public ObjectFactoryLoader(URL resourceName) throws ObjectDescriptionException {
        this.parseXml(resourceName);
        this.rebuildSuperClasses();
    }

    private void rebuildSuperClasses() throws ObjectDescriptionException {
        this.propertyDefinition = new ArrayList();
        this.attributeDefinition = new ArrayList();
        this.constructorDefinition = new ArrayList();
        this.lookupDefinitions = new ArrayList();
        this.orderedNames = new ArrayList();
        HashMap newObjectDescriptions = new HashMap();
        Iterator it = this.objectMappings.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            GenericObjectFactory gef = (GenericObjectFactory)this.objectMappings.get(key);
            this.performSuperClassUpdate(gef);
            PropertyDefinition[] propertyDefs = this.propertyDefinition.toArray(new PropertyDefinition[0]);
            LookupDefinition[] lookupDefs = this.lookupDefinitions.toArray(new LookupDefinition[0]);
            AttributeDefinition[] attribDefs = this.attributeDefinition.toArray(new AttributeDefinition[0]);
            ConstructorDefinition[] constructorDefs = this.constructorDefinition.toArray(new ConstructorDefinition[0]);
            String[] orderedNamesDefs = this.orderedNames.toArray(new String[0]);
            GenericObjectFactory objectFactory = new GenericObjectFactory(gef.getBaseClass(), gef.getRegisterName(), constructorDefs, propertyDefs, lookupDefs, attribDefs, orderedNamesDefs);
            newObjectDescriptions.put(key, objectFactory);
            this.propertyDefinition.clear();
            this.attributeDefinition.clear();
            this.constructorDefinition.clear();
            this.lookupDefinitions.clear();
            this.orderedNames.clear();
        }
        this.objectMappings.clear();
        this.objectMappings = newObjectDescriptions;
        this.propertyDefinition = null;
        this.attributeDefinition = null;
        this.constructorDefinition = null;
        this.lookupDefinitions = null;
        this.orderedNames = null;
    }

    private void performSuperClassUpdate(GenericObjectFactory gef) {
        GenericObjectFactory superGef;
        Class superClass = gef.getBaseClass().getSuperclass();
        if (superClass != null && !superClass.equals(class$java$lang$Object == null ? (class$java$lang$Object = ObjectFactoryLoader.class$("java.lang.Object")) : class$java$lang$Object) && (superGef = (GenericObjectFactory)this.objectMappings.get(superClass)) != null) {
            this.performSuperClassUpdate(superGef);
        }
        this.propertyDefinition.addAll(Arrays.asList(gef.getPropertyDefinitions()));
        this.attributeDefinition.addAll(Arrays.asList(gef.getAttributeDefinitions()));
        this.constructorDefinition.addAll(Arrays.asList(gef.getConstructorDefinitions()));
        this.lookupDefinitions.addAll(Arrays.asList(gef.getLookupDefinitions()));
        this.orderedNames.addAll(Arrays.asList(gef.getOrderedPropertyNames()));
    }

    protected boolean startObjectDefinition(String className, String register, boolean ignore) throws ObjectDescriptionException {
        if (ignore) {
            return false;
        }
        this.target = this.loadClass(className);
        if (this.target == null) {
            Log.warn((Object)new Log.SimpleMessage("Failed to load class ", (Object)className));
            return false;
        }
        this.registerName = register;
        this.propertyDefinition = new ArrayList();
        this.attributeDefinition = new ArrayList();
        this.constructorDefinition = new ArrayList();
        this.lookupDefinitions = new ArrayList();
        this.orderedNames = new ArrayList();
        return true;
    }

    protected void handleAttributeDefinition(String name, String attribName, String handlerClass) throws ObjectDescriptionException {
        AttributeHandler handler = this.loadAttributeHandler(handlerClass);
        this.orderedNames.add(name);
        this.attributeDefinition.add(new AttributeDefinition(name, attribName, handler));
    }

    protected void handleElementDefinition(String name, String element) throws ObjectDescriptionException {
        this.orderedNames.add(name);
        this.propertyDefinition.add(new PropertyDefinition(name, element));
    }

    protected void handleLookupDefinition(String name, String lookupKey) throws ObjectDescriptionException {
        LookupDefinition ldef = new LookupDefinition(name, lookupKey);
        this.orderedNames.add(name);
        this.lookupDefinitions.add(ldef);
    }

    protected void endObjectDefinition() throws ObjectDescriptionException {
        PropertyDefinition[] propertyDefs = this.propertyDefinition.toArray(new PropertyDefinition[0]);
        LookupDefinition[] lookupDefs = this.lookupDefinitions.toArray(new LookupDefinition[0]);
        AttributeDefinition[] attribDefs = this.attributeDefinition.toArray(new AttributeDefinition[0]);
        ConstructorDefinition[] constructorDefs = this.constructorDefinition.toArray(new ConstructorDefinition[0]);
        String[] orderedNamesDefs = this.orderedNames.toArray(new String[0]);
        GenericObjectFactory objectFactory = new GenericObjectFactory(this.target, this.registerName, constructorDefs, propertyDefs, lookupDefs, attribDefs, orderedNamesDefs);
        this.objectMappings.put(this.target, objectFactory);
    }

    protected void handleConstructorDefinition(String propertyName, String parameterClass) {
        Class c = this.loadClass(parameterClass);
        this.orderedNames.add(propertyName);
        this.constructorDefinition.add(new ConstructorDefinition(propertyName, c));
    }

    protected boolean handleManualMapping(String className, String readHandler, String writeHandler) throws ObjectDescriptionException {
        if (!this.manualMappings.containsKey(className)) {
            Class loadedClass = this.loadClass(className);
            this.manualMappings.put(loadedClass, new ManualMappingDefinition(loadedClass, readHandler, writeHandler));
            return true;
        }
        return false;
    }

    protected void startMultiplexMapping(String className, String typeAttr) {
        this.baseClass = className;
        this.attributeName = typeAttr;
        this.multiplexEntries = new ArrayList();
    }

    protected void handleMultiplexMapping(String typeName, String className) throws ObjectDescriptionException {
        this.multiplexEntries.add(new MultiplexMappingEntry(typeName, className));
    }

    protected void endMultiplexMapping() throws ObjectDescriptionException {
        MultiplexMappingEntry[] mappings = this.multiplexEntries.toArray(new MultiplexMappingEntry[0]);
        Class c = this.loadClass(this.baseClass);
        this.multiplexMappings.put(c, new MultiplexMappingDefinition(c, this.attributeName, mappings));
        this.multiplexEntries = null;
    }

    private AttributeHandler loadAttributeHandler(String attribute) throws ObjectDescriptionException {
        Class c = this.loadClass(attribute);
        try {
            return (AttributeHandler)c.newInstance();
        }
        catch (Exception e) {
            throw new ObjectDescriptionException("Invalid attribute handler specified: " + attribute);
        }
    }

    public boolean isGenericHandler(Class c) {
        return this.objectMappings.containsKey(c);
    }

    public GenericObjectFactory getFactoryForClass(Class c) {
        GenericObjectFactory factory = (GenericObjectFactory)this.objectMappings.get(c);
        if (factory == null) {
            return null;
        }
        return factory.getInstance();
    }

    public ManualMappingDefinition getManualMappingDefinition(Class c) {
        return (ManualMappingDefinition)this.manualMappings.get(c);
    }

    public MultiplexMappingDefinition getMultiplexDefinition(Class c) {
        MultiplexMappingDefinition definition = (MultiplexMappingDefinition)this.multiplexMappings.get(c);
        return definition;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

