/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.util.Log;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class ArrayObjectDescription
extends AbstractObjectDescription {
    public ArrayObjectDescription(Class c) {
        super(c);
        if (!c.isArray()) {
            throw new IllegalArgumentException("Need an array class");
        }
    }

    public Object createObject() {
        try {
            Integer size = (Integer)this.getParameter("size");
            if (size == null) {
                Object value;
                ArrayList<Object> l = new ArrayList<Object>();
                int counter = 0;
                while (this.getParameterDefinition(String.valueOf(counter)) != null && (value = this.getParameter(String.valueOf(counter))) != null) {
                    l.add(value);
                    ++counter;
                }
                Object o = Array.newInstance(this.getObjectClass().getComponentType(), l.size());
                for (int i = 0; i < l.size(); ++i) {
                    Array.set(o, i, l.get(i));
                }
                return o;
            }
            Object o = Array.newInstance(this.getObjectClass().getComponentType(), (int)size);
            for (int i = 0; i < size; ++i) {
                Array.set(o, i, this.getParameter(String.valueOf(i)));
            }
            return o;
        }
        catch (Exception ie) {
            Log.warn((Object)"Unable to instantiate Object", (Exception)ie);
            return null;
        }
    }

    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (o == null) {
            throw new ObjectFactoryException("Given object is null.");
        }
        if (!o.getClass().isArray()) {
            throw new ObjectFactoryException("Given object is no array");
        }
        if (!this.getObjectClass().isAssignableFrom(o.getClass())) {
            throw new ObjectFactoryException("Given object is incompatible with base class");
        }
        int size = Array.getLength(o);
        this.setParameter("size", new Integer(size));
        for (int i = 0; i < size; ++i) {
            this.setParameter(String.valueOf(i), Array.get(o, i));
        }
    }

    private int parseParameterName(String name) {
        try {
            return Integer.parseInt(name);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public Class getParameterDefinition(String name) {
        if (name.equals("size")) {
            return Integer.TYPE;
        }
        int par = this.parseParameterName(name);
        if (par < 0) {
            return null;
        }
        return this.getObjectClass().getComponentType();
    }

    public Iterator getParameterNames() {
        Integer size = (Integer)this.getParameter("size");
        if (size == null) {
            return this.getDefinedParameterNames();
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add("size");
        for (int i = 0; i < size; ++i) {
            l.add(String.valueOf(i));
        }
        return l.iterator();
    }

    public ObjectDescription getInstance() {
        return new ArrayObjectDescription(this.getObjectClass());
    }
}

