/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.constraint;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.jini.core.constraint.DelegationAbsoluteTime;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.RelativeTimeConstraint;

public final class DelegationRelativeTime
implements RelativeTimeConstraint,
Serializable {
    private static final long serialVersionUID = 7148935984332761810L;
    private final long minStart;
    private final long maxStart;
    private final long minStop;
    private final long maxStop;

    public DelegationRelativeTime(long minStart, long maxStart, long minStop, long maxStop) {
        if (minStart > maxStart || maxStart > minStop || minStop > maxStop || minStop < 0L) {
            throw new IllegalArgumentException("invalid durations");
        }
        this.minStart = minStart;
        this.maxStart = maxStart;
        this.minStop = minStop;
        this.maxStop = maxStop;
    }

    public long getMinStart() {
        return this.minStart;
    }

    public long getMaxStart() {
        return this.maxStart;
    }

    public long getMinStop() {
        return this.minStop;
    }

    public long getMaxStop() {
        return this.maxStop;
    }

    public InvocationConstraint makeAbsolute(long baseTime) {
        return new DelegationAbsoluteTime(DelegationRelativeTime.add(this.minStart, baseTime), DelegationRelativeTime.add(this.maxStart, baseTime), DelegationRelativeTime.add(this.minStop, baseTime), DelegationRelativeTime.add(this.maxStop, baseTime));
    }

    private static long add(long dur, long time) {
        long ntime = time + dur;
        if (ntime >= 0L && time < 0L && dur < 0L) {
            ntime = Long.MIN_VALUE;
        } else if (ntime < 0L && time > 0L && dur > 0L) {
            ntime = Long.MAX_VALUE;
        }
        return ntime;
    }

    public int hashCode() {
        return (int)((long)DelegationRelativeTime.class.hashCode() + this.minStart + this.maxStart + this.minStop + this.maxStop);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DelegationRelativeTime)) {
            return false;
        }
        DelegationRelativeTime dc = (DelegationRelativeTime)obj;
        return this.minStart == dc.minStart && this.maxStart == dc.maxStart && this.minStop == dc.minStop && this.maxStop == dc.maxStop;
    }

    public String toString() {
        String s = "DelegationRelativeTime[start: ";
        s = this.minStart == this.maxStart ? s + this.minStart + ", stop: " : s + "[" + this.minStart + ", " + this.maxStart + "], stop: ";
        s = this.minStop == this.maxStop ? s + this.minStop + "]" : s + "[" + this.minStop + ", " + this.maxStop + "]]";
        return s;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.minStart > this.maxStart || this.maxStart > this.minStop || this.minStop > this.maxStop || this.minStop < 0L) {
            throw new InvalidObjectException("invalid durations");
        }
    }
}

