/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.mux;

import com.sun.jini.jeri.internal.mux.ConnectionIO;
import com.sun.jini.jeri.internal.mux.IOFuture;
import com.sun.jini.jeri.internal.mux.ProtocolException;
import com.sun.jini.jeri.internal.mux.Session;
import com.sun.jini.jeri.internal.mux.SocketChannelConnectionIO;
import com.sun.jini.jeri.internal.mux.StreamConnectionIO;
import com.sun.jini.jeri.internal.runtime.HexDumpEncoder;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.AccessController;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class Mux {
    static final int CLIENT = 0;
    static final int SERVER = 1;
    static final int MAX_SESSION_ID = 127;
    public static final int MAX_REQUESTS = 128;
    static final int NoOperation = 0;
    static final int Shutdown = 2;
    static final int Ping = 4;
    static final int PingAck = 6;
    static final int Error = 8;
    static final int IncrementRation = 16;
    static final int Abort = 32;
    static final int Close = 48;
    static final int Acknowledgment = 64;
    static final int Data = 128;
    static final int IncrementRation_shift = 14;
    static final int Abort_partial = 2;
    static final int Data_open = 16;
    static final int Data_close = 8;
    static final int Data_eof = 4;
    static final int Data_ackRequired = 2;
    static final int ClientConnectionHeader_negotiate = 1;
    private static final byte[] magic;
    private static final int VERSION = 1;
    private static final Executor systemThreadPool;
    private static final LinkedList sessionShutdownQueue;
    private static final Logger logger;
    final int role;
    final int initialInboundRation;
    final int maxFragmentSize;
    private final ConnectionIO connectionIO;
    private final boolean directBuffersUseful;
    final Object muxLock = new Object();
    int initialOutboundRation;
    private boolean clientConnectionReady = false;
    boolean serverConnectionReady = false;
    boolean muxDown = false;
    String muxDownMessage;
    Throwable muxDownCause;
    final BitSet busySessions = new BitSet();
    final Map sessions = new HashMap(5);
    private int expectedPingCookie = -1;
    private static final int READ_CLIENT_CONNECTION_HEADER = 0;
    private static final int READ_SERVER_CONNECTION_HEADER = 1;
    private static final int READ_MESSAGE_HEADER = 2;
    private static final int READ_MESSAGE_BODY = 3;
    private final Object readStateLock = new Object();
    private int readState;
    private int currentOp;
    private int currentSessionID;
    private int currentLengthRemaining;
    private ByteBuffer currentDataBuffer = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    Mux(OutputStream out, InputStream in, int role, int initialInboundRation, int maxFragmentSize) throws IOException {
        this.role = role;
        if ((initialInboundRation & 0xFF0000FF) != 0) {
            throw new IllegalArgumentException("illegal initial inbound ration: " + Mux.toHexString(initialInboundRation));
        }
        this.initialInboundRation = initialInboundRation;
        this.maxFragmentSize = maxFragmentSize;
        this.connectionIO = new StreamConnectionIO(this, out, in);
        this.directBuffersUseful = false;
    }

    Mux(SocketChannel channel, int role, int initialInboundRation, int maxFragmentSize) throws IOException {
        this.role = role;
        if ((initialInboundRation & 0xFF0000FF) != 0) {
            throw new IllegalArgumentException("illegal initial inbound ration: " + Mux.toHexString(initialInboundRation));
        }
        this.initialInboundRation = initialInboundRation;
        this.maxFragmentSize = maxFragmentSize;
        this.connectionIO = new SocketChannelConnectionIO(this, channel);
        this.directBuffersUseful = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        if (this.role == 0) {
            this.readState = 1;
        } else {
            if (!$assertionsDisabled && this.role != 1) {
                throw new AssertionError();
            }
            this.readState = 0;
        }
        try {
            this.connectionIO.start();
        }
        catch (IOException e) {
            this.setDown("I/O error starting connection", e);
            throw e;
        }
        if (this.role == 0) {
            this.asyncSendClientConnectionHeader();
            Object object = this.muxLock;
            synchronized (object) {
                while (!this.muxDown && !this.clientConnectionReady) {
                    try {
                        this.muxLock.wait();
                    }
                    catch (InterruptedException e) {
                        this.setDown("interrupt waiting for connection header", e);
                    }
                }
                if (this.muxDown) {
                    IOException ioe = new IOException(this.muxDownMessage);
                    ioe.initCause(this.muxDownCause);
                    throw ioe;
                }
            }
        }
    }

    protected void handleDown() {
    }

    void handleOpen(int sessionID) throws ProtocolException {
        throw new ProtocolException("remote endpoint attempted to open session");
    }

    final void addSession(int sessionID, Session session) {
        if (!$assertionsDisabled && !Thread.holdsLock(this.muxLock)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.muxDown) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.busySessions.get(sessionID)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.sessions.get(new Integer(sessionID)) != null) {
            throw new AssertionError();
        }
        this.busySessions.set(sessionID);
        this.sessions.put(new Integer(sessionID), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setDown(String message, Throwable cause) {
        Object object = this.muxLock;
        synchronized (object) {
            if (this.muxDown) {
                return;
            }
            this.muxDown = true;
            this.muxDownMessage = message;
            this.muxDownCause = cause;
            this.muxLock.notifyAll();
        }
        boolean needWorker = false;
        LinkedList linkedList = sessionShutdownQueue;
        synchronized (linkedList) {
            if (!this.sessions.values().isEmpty()) {
                sessionShutdownQueue.add(new SessionShutdownTask(this.sessions.values().toArray(new Session[this.sessions.values().size()]), message, cause));
                needWorker = true;
            } else {
                needWorker = !sessionShutdownQueue.isEmpty();
            }
        }
        if (needWorker) {
            try {
                systemThreadPool.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        while (true) {
                            Runnable task;
                            LinkedList linkedList = sessionShutdownQueue;
                            synchronized (linkedList) {
                                if (sessionShutdownQueue.isEmpty()) {
                                    break;
                                }
                                task = (Runnable)sessionShutdownQueue.removeFirst();
                            }
                            task.run();
                        }
                    }
                }, "mux session shutdown");
            }
            catch (OutOfMemoryError e) {
                try {
                    logger.log(Level.WARNING, "could not create thread for session shutdown", e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        this.handleDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeSession(int sessionID) {
        Object object = this.muxLock;
        synchronized (object) {
            if (this.muxDown) {
                return;
            }
            if (!$assertionsDisabled && !this.busySessions.get(sessionID)) {
                throw new AssertionError();
            }
            this.busySessions.clear(sessionID);
            this.sessions.remove(new Integer(sessionID));
        }
    }

    final boolean directBuffersUseful() {
        return this.directBuffersUseful;
    }

    final void asyncSendClientConnectionHeader() {
        if (!$assertionsDisabled && this.role != 0) {
            throw new AssertionError();
        }
        ByteBuffer header = ByteBuffer.allocate(8);
        header.put(magic).put((byte)1).putShort((short)(this.initialInboundRation >> 8)).put((byte)0).flip();
        this.connectionIO.asyncSend(header);
    }

    final void asyncSendServerConnectionHeader() {
        if (!$assertionsDisabled && this.role != 1) {
            throw new AssertionError();
        }
        ByteBuffer header = ByteBuffer.allocate(8);
        header.put(magic).put((byte)1).putShort((short)(this.initialInboundRation >> 8)).put((byte)0).flip();
        this.connectionIO.asyncSend(header);
    }

    final void asyncSendNoOperation(ByteBuffer buffer) {
        ByteBuffer header = ByteBuffer.allocate(4);
        header.put((byte)0).put((byte)0);
        if (buffer != null) {
            if (!$assertionsDisabled && buffer.remaining() > 65535) {
                throw new AssertionError();
            }
            header.putShort((short)buffer.remaining()).flip();
            this.connectionIO.asyncSend(header, buffer);
        } else {
            header.putShort((short)0).flip();
            this.connectionIO.asyncSend(header);
        }
    }

    final void asyncSendShutdown(String message) {
        ByteBuffer data = message != null ? Mux.getUTF8BufferFromString(message) : null;
        ByteBuffer header = ByteBuffer.allocate(4);
        header.put((byte)2).put((byte)0);
        if (data != null) {
            if (!$assertionsDisabled && data.remaining() > 65535) {
                throw new AssertionError();
            }
            header.putShort((short)data.remaining()).flip();
            this.connectionIO.asyncSend(header, data);
        } else {
            header.putShort((short)0).flip();
            this.connectionIO.asyncSend(header);
        }
    }

    final void asyncSendPing(int cookie) {
        if (!($assertionsDisabled || cookie >= 0 && cookie <= 65535)) {
            throw new AssertionError();
        }
        ByteBuffer header = ByteBuffer.allocate(4);
        header.put((byte)4).put((byte)0).putShort((short)cookie).flip();
        this.connectionIO.asyncSend(header);
    }

    final void asyncSendPingAck(int cookie) {
        if (!($assertionsDisabled || cookie >= 0 && cookie <= 65535)) {
            throw new AssertionError();
        }
        ByteBuffer header = ByteBuffer.allocate(4);
        header.put((byte)6).put((byte)0).putShort((short)cookie).flip();
        this.connectionIO.asyncSend(header);
    }

    final void asyncSendError(String message) {
        ByteBuffer data = message != null ? Mux.getUTF8BufferFromString(message) : null;
        ByteBuffer header = ByteBuffer.allocate(4);
        header.put((byte)8).put((byte)0);
        if (data != null) {
            if (!$assertionsDisabled && data.remaining() > 65535) {
                throw new AssertionError();
            }
            header.putShort((short)data.remaining()).flip();
            this.connectionIO.asyncSend(header, data);
        } else {
            header.putShort((short)0).flip();
            this.connectionIO.asyncSend(header);
        }
    }

    final IOFuture futureSendError(String message) {
        ByteBuffer data = Mux.getUTF8BufferFromString(message);
        ByteBuffer header = ByteBuffer.allocate(4);
        header.put((byte)8).put((byte)0);
        if (!$assertionsDisabled && data.remaining() > 65535) {
            throw new AssertionError();
        }
        header.putShort((short)data.remaining()).flip();
        return this.connectionIO.futureSend(header, data);
    }

    final void asyncSendIncrementRation(int sessionID, int increment) {
        int op = 16;
        if (!($assertionsDisabled || sessionID >= 0 && sessionID <= 127)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || increment >= 0 && increment <= 65535)) {
            throw new AssertionError();
        }
        ByteBuffer header = ByteBuffer.allocate(4);
        header.put((byte)16).put((byte)sessionID).putShort((short)increment).flip();
        this.connectionIO.asyncSend(header);
    }

    final void asyncSendAbort(int op, int sessionID, ByteBuffer data) {
        if (!$assertionsDisabled && (op & 0xFD) != 32) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || sessionID >= 0 && sessionID <= 127)) {
            throw new AssertionError();
        }
        ByteBuffer header = ByteBuffer.allocate(4);
        header.put((byte)op).put((byte)sessionID);
        if (data != null) {
            if (!$assertionsDisabled && data.remaining() > 65535) {
                throw new AssertionError();
            }
            header.putShort((short)data.remaining()).flip();
            this.connectionIO.asyncSend(header, data);
        } else {
            header.putShort((short)0).flip();
            this.connectionIO.asyncSend(header);
        }
    }

    final void asyncSendClose(int sessionID) {
        if (!($assertionsDisabled || sessionID >= 0 && sessionID <= 127)) {
            throw new AssertionError();
        }
        ByteBuffer header = ByteBuffer.allocate(4);
        header.put((byte)48).put((byte)sessionID).putShort((short)0).flip();
        this.connectionIO.asyncSend(header);
    }

    final void asyncSendAcknowledgment(int sessionID) {
        if (!($assertionsDisabled || sessionID >= 0 && sessionID <= 127)) {
            throw new AssertionError();
        }
        ByteBuffer header = ByteBuffer.allocate(4);
        header.put((byte)64).put((byte)sessionID).putShort((short)0).flip();
        this.connectionIO.asyncSend(header);
    }

    final void asyncSendData(int op, int sessionID, ByteBuffer data) {
        if (!$assertionsDisabled && (op & 0xE1) != 128) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (op & 4) == 0 && (op & 8 & 2) != 0) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || sessionID >= 0 && sessionID <= 127)) {
            throw new AssertionError();
        }
        ByteBuffer header = ByteBuffer.allocate(4);
        header.put((byte)op).put((byte)sessionID);
        if (data != null) {
            if (!$assertionsDisabled && data.remaining() > 65535) {
                throw new AssertionError();
            }
            header.putShort((short)data.remaining()).flip();
            this.connectionIO.asyncSend(header, data);
        } else {
            header.putShort((short)0).flip();
            this.connectionIO.asyncSend(header);
        }
    }

    final IOFuture futureSendData(int op, int sessionID, ByteBuffer data) {
        if (!$assertionsDisabled && (op & 0xE1) != 128) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (op & 4) == 0 && (op & 8 & 2) != 0) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || sessionID >= 0 && sessionID <= 127)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && data.remaining() > 65535) {
            throw new AssertionError();
        }
        ByteBuffer header = ByteBuffer.allocate(4);
        header.put((byte)op).put((byte)sessionID).putShort((short)data.remaining()).flip();
        return this.connectionIO.futureSend(header, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processIncomingData(ByteBuffer buffer) throws ProtocolException {
        buffer.flip();
        if (!$assertionsDisabled && !buffer.hasRemaining()) {
            throw new AssertionError();
        }
        Object object = this.readStateLock;
        synchronized (object) {
            block9: do {
                switch (this.readState) {
                    case 0: {
                        if (this.readClientConnectionHeader(buffer)) continue block9;
                        break block9;
                    }
                    case 1: {
                        if (this.readServerConnectionHeader(buffer)) continue block9;
                        break block9;
                    }
                    case 2: {
                        if (this.readMessageHeader(buffer)) continue block9;
                        break block9;
                    }
                    case 3: {
                        if (this.readMessageBody(buffer)) continue block9;
                        break block9;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            } while (buffer.hasRemaining());
        }
        buffer.compact();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readClientConnectionHeader(ByteBuffer buffer) throws ProtocolException {
        if (!$assertionsDisabled && this.role != 1) {
            throw new AssertionError();
        }
        this.validatePartialMagicNumber(buffer);
        if (buffer.remaining() < 8) {
            return false;
        }
        int headerPosition = buffer.position();
        buffer.position(headerPosition + 4);
        int version = buffer.get() & 0xFF;
        int ration = (buffer.getShort() & 0xFFFF) << 8;
        int flags = buffer.get() & 0xFF;
        boolean negotiate = (flags & 1) != 0;
        Object object = this.muxLock;
        synchronized (object) {
            this.initialOutboundRation = ration;
            this.asyncSendServerConnectionHeader();
            if (version == 0) {
                throw new ProtocolException("bad protocol version: " + version);
            }
            if (version > 1 && !negotiate) {
                this.setDown("unsupported protocol version: " + version, null);
                throw new ProtocolException("unsupported protocol version: " + version);
            }
            this.serverConnectionReady = true;
        }
        this.readState = 2;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readServerConnectionHeader(ByteBuffer buffer) throws ProtocolException {
        if (!$assertionsDisabled && this.role != 0) {
            throw new AssertionError();
        }
        this.validatePartialMagicNumber(buffer);
        if (buffer.remaining() < 8) {
            return false;
        }
        int headerPosition = buffer.position();
        buffer.position(headerPosition + 4);
        int version = buffer.get() & 0xFF;
        int ration = (buffer.getShort() & 0xFFFF) << 8;
        int flags = buffer.get() & 0xFF;
        Object object = this.muxLock;
        synchronized (object) {
            this.initialOutboundRation = ration;
            if (version == 0) {
                throw new ProtocolException("bad protocol version: " + version);
            }
            if (version > 1) {
                throw new ProtocolException("unexpected protocol version: " + version);
            }
            this.clientConnectionReady = true;
            this.muxLock.notifyAll();
        }
        this.readState = 2;
        return true;
    }

    private void validatePartialMagicNumber(ByteBuffer buffer) throws ProtocolException {
        if (buffer.remaining() > 0) {
            byte[] temp = new byte[Math.min(buffer.remaining(), magic.length)];
            buffer.mark();
            buffer.get(temp);
            buffer.reset();
            for (int i = 0; i < temp.length; ++i) {
                if (temp[i] == magic[i]) continue;
                this.setDown((this.role == 0 ? "server" : "client") + " sent bad magic number: " + Mux.toHexString(temp), null);
                throw new ProtocolException("bad magic number: " + Mux.toHexString(temp));
            }
        }
    }

    private boolean readMessageHeader(ByteBuffer buffer) throws ProtocolException {
        int op;
        if (buffer.remaining() < 4) {
            return false;
        }
        int headerPosition = buffer.position();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "message header: " + Mux.toHexString(buffer.getInt(headerPosition)));
        }
        if (((op = buffer.get() & 0xFF) & 0xE1) == 128) {
            int sessionID = buffer.get() & 0xFF;
            if (sessionID > 127) {
                throw new ProtocolException("bad message header: " + Mux.toHexString(buffer.getInt(headerPosition)));
            }
            this.currentOp = op;
            this.currentSessionID = sessionID;
            this.currentLengthRemaining = buffer.getShort() & 0xFFFF;
            if (this.currentLengthRemaining > 0) {
                this.currentDataBuffer = ByteBuffer.allocate(this.currentLengthRemaining);
                this.readState = 3;
            } else {
                this.dispatchCurrentMessage();
            }
            return true;
        }
        if ((op & 0xF1) == 16) {
            int sessionID = buffer.get() & 0xFF;
            if (sessionID > 127) {
                throw new ProtocolException("bad message header: " + Mux.toHexString(buffer.getInt(headerPosition)));
            }
            int increment = buffer.getShort() & 0xFFFF;
            int shift = op & 0xE;
            this.handleIncrementRation(sessionID, increment <<= shift);
            return true;
        }
        if ((op & 0xFD) == 32) {
            int sessionID = buffer.get() & 0xFF;
            if (sessionID > 127) {
                throw new ProtocolException("bad message header: " + Mux.toHexString(buffer.getInt(headerPosition)));
            }
            this.currentOp = op;
            this.currentSessionID = sessionID;
            this.currentLengthRemaining = buffer.getShort() & 0xFFFF;
            if (this.currentLengthRemaining > 0) {
                this.currentDataBuffer = ByteBuffer.allocate(this.currentLengthRemaining);
                this.readState = 3;
            } else {
                this.dispatchCurrentMessage();
            }
            return true;
        }
        switch (op) {
            case 0: {
                if (buffer.get() != 0) {
                    throw new ProtocolException("bad message header: " + Mux.toHexString(buffer.getInt(headerPosition)));
                }
                this.currentOp = op;
                this.currentLengthRemaining = buffer.getShort() & 0xFFFF;
                this.currentDataBuffer = null;
                if (this.currentLengthRemaining > 0) {
                    this.readState = 3;
                } else {
                    this.dispatchCurrentMessage();
                }
                return true;
            }
            case 2: {
                if (buffer.get() != 0) {
                    throw new ProtocolException("bad message header: " + Mux.toHexString(buffer.getInt(headerPosition)));
                }
                this.currentOp = op;
                this.currentLengthRemaining = buffer.getShort() & 0xFFFF;
                if (this.currentLengthRemaining > 0) {
                    this.currentDataBuffer = ByteBuffer.allocate(this.currentLengthRemaining);
                    this.readState = 3;
                } else {
                    this.dispatchCurrentMessage();
                }
                return true;
            }
            case 4: {
                if (buffer.get() != 0) {
                    throw new ProtocolException("bad message header: " + Mux.toHexString(buffer.getInt(headerPosition)));
                }
                int cookie = buffer.getShort() & 0xFFFF;
                this.handlePing(cookie);
                return true;
            }
            case 6: {
                if (buffer.get() != 0) {
                    throw new ProtocolException("bad message header: " + Mux.toHexString(buffer.getInt(headerPosition)));
                }
                int cookie = buffer.getShort() & 0xFFFF;
                this.handlePingAck(cookie);
                return true;
            }
            case 8: {
                if (buffer.get() != 0) {
                    throw new ProtocolException("bad message header: " + Mux.toHexString(buffer.getInt(headerPosition)));
                }
                this.currentOp = op;
                this.currentLengthRemaining = buffer.getShort() & 0xFFFF;
                if (this.currentLengthRemaining > 0) {
                    this.currentDataBuffer = ByteBuffer.allocate(this.currentLengthRemaining);
                    this.readState = 3;
                } else {
                    this.dispatchCurrentMessage();
                }
                return true;
            }
            case 48: {
                int sessionID = buffer.get() & 0xFF;
                if (sessionID > 127 || buffer.getShort() != 0) {
                    throw new ProtocolException("bad message header: " + Mux.toHexString(buffer.getInt(headerPosition)));
                }
                this.handleClose(sessionID);
                return true;
            }
            case 64: {
                int sessionID = buffer.get() & 0xFF;
                if (sessionID > 127 || buffer.getShort() != 0) {
                    throw new ProtocolException("bad message header: " + Mux.toHexString(buffer.getInt(headerPosition)));
                }
                this.handleAcknowledgment(sessionID);
                return true;
            }
        }
        throw new ProtocolException("bad message header: " + Mux.toHexString(buffer.getInt(headerPosition)));
    }

    private boolean readMessageBody(ByteBuffer buffer) throws ProtocolException {
        if (!$assertionsDisabled && this.currentLengthRemaining <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.currentDataBuffer != null && this.currentDataBuffer.remaining() != this.currentLengthRemaining) {
            throw new AssertionError();
        }
        if (buffer.remaining() > this.currentLengthRemaining) {
            int origLimit = buffer.limit();
            buffer.limit(buffer.position() + this.currentLengthRemaining);
            if (this.currentDataBuffer != null) {
                this.currentDataBuffer.put(buffer);
            } else {
                buffer.position(buffer.position() + this.currentLengthRemaining);
            }
            this.currentLengthRemaining = 0;
            buffer.limit(origLimit);
        } else {
            this.currentLengthRemaining -= buffer.remaining();
            if (this.currentDataBuffer != null) {
                this.currentDataBuffer.put(buffer);
            } else {
                buffer.position(buffer.limit());
            }
        }
        if (this.currentLengthRemaining > 0) {
            return false;
        }
        this.currentDataBuffer.flip();
        this.dispatchCurrentMessage();
        this.currentDataBuffer = null;
        this.readState = 2;
        return true;
    }

    private void dispatchCurrentMessage() throws ProtocolException {
        if (!$assertionsDisabled && this.currentDataBuffer != null && !this.currentDataBuffer.hasRemaining()) {
            throw new AssertionError();
        }
        int op = this.currentOp;
        if ((op & 0xE1) == 128) {
            boolean open = (op & 0x10) != 0;
            boolean close = (op & 8) != 0;
            boolean eof = (op & 4) != 0;
            boolean ackRequired = (op & 2) != 0;
            this.handleData(this.currentSessionID, open, close, eof, ackRequired, this.currentDataBuffer != null ? this.currentDataBuffer : ByteBuffer.allocate(0));
            return;
        }
        if ((op & 0xFD) == 32) {
            boolean partial = (op & 2) != 0;
            this.handleAbort(this.currentSessionID, partial, this.currentDataBuffer != null ? Mux.getStringFromUTF8Buffer(this.currentDataBuffer) : "");
            return;
        }
        switch (op) {
            case 0: {
                this.handleNoOperation();
                return;
            }
            case 2: {
                this.handleShutdown(this.currentDataBuffer != null ? Mux.getStringFromUTF8Buffer(this.currentDataBuffer) : "");
                return;
            }
            case 8: {
                this.handleError(this.currentDataBuffer != null ? Mux.getStringFromUTF8Buffer(this.currentDataBuffer) : "");
                return;
            }
        }
        throw new AssertionError((Object)Integer.toHexString((byte)op));
    }

    private void handleNoOperation() throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "NoOperation");
        }
    }

    private void handleShutdown(String message) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Shutdown");
        }
        if (this.role != 0) {
            throw new ProtocolException("Shutdown sent by client");
        }
        this.setDown("mux connection shut down gracefully", null);
        throw new ProtocolException("received Shutdown message");
    }

    private void handlePing(int cookie) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Ping: cookie=" + cookie);
        }
        this.asyncSendPingAck(cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePingAck(int cookie) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PingAck: cookie=" + cookie);
        }
        Object object = this.muxLock;
        synchronized (object) {
            if (cookie != this.expectedPingCookie) {
                throw new ProtocolException("unexpected ping cookie: " + cookie);
            }
            this.expectedPingCookie = -1;
        }
    }

    private void handleError(String message) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Error");
        }
        this.setDown((this.role == 0 ? "server" : "client") + " reported protocol error: " + message, null);
        throw new ProtocolException("received Error message");
    }

    private void handleIncrementRation(int sessionID, int increment) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "IncrementRation: sessionID=" + sessionID + ",increment=" + increment);
        }
        this.getSession(sessionID).handleIncrementRation(increment);
    }

    private void handleAbort(int sessionID, boolean partial, String message) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Abort: sessionID=" + sessionID + ",partial=" + partial);
        }
        this.getSession(sessionID).handleAbort(partial);
    }

    private void handleClose(int sessionID) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Close: sessionID=" + sessionID);
        }
        this.getSession(sessionID).handleClose();
    }

    private void handleAcknowledgment(int sessionID) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Acknowledgment: sessionID=" + sessionID);
        }
        this.getSession(sessionID).handleAcknowledgment();
    }

    private void handleData(int sessionID, boolean open, boolean close, boolean eof, boolean ackRequired, ByteBuffer data) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            int length = data.remaining();
            HexDumpEncoder encoder = new HexDumpEncoder();
            byte[] bytes = new byte[data.remaining()];
            data.mark();
            data.get(bytes);
            data.reset();
            logger.log(Level.FINEST, "Data: sessionID=" + sessionID + (open ? ",open" : "") + (close ? ",close" : "") + (eof ? ",eof" : "") + (ackRequired ? ",ackRequired" : "") + ",length=" + length + (length > 0 ? ",data=\n" + encoder.encode(bytes) : ""));
        }
        if (!eof && (close || ackRequired)) {
            throw new ProtocolException("Data: eof=" + eof + ",close=" + close + ",ackRequired=" + ackRequired);
        }
        if (open) {
            this.handleOpen(sessionID);
        }
        this.getSession(sessionID).handleData(data, eof, close, ackRequired);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession(int sessionID) throws ProtocolException {
        Object object = this.muxLock;
        synchronized (object) {
            if (!this.busySessions.get(sessionID)) {
                throw new ProtocolException("inactive sessionID: " + sessionID);
            }
            return (Session)this.sessions.get(new Integer(sessionID));
        }
    }

    private static ByteBuffer getUTF8BufferFromString(String s) {
        CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
        try {
            return encoder.encode(CharBuffer.wrap(s));
        }
        catch (CharacterCodingException e) {
            return null;
        }
    }

    private static String getStringFromUTF8Buffer(ByteBuffer buffer) {
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        try {
            return decoder.decode(buffer).toString();
        }
        catch (CharacterCodingException e) {
            return "(error decoding UTF-8 message: " + e.toString() + ")";
        }
    }

    private static String toHexString(byte x) {
        char[] buf = new char[]{Mux.toHexChar(x >> 4 & 0xF), Mux.toHexChar(x & 0xF)};
        return new String(buf);
    }

    private static String toHexString(int x) {
        char[] buf = new char[8];
        for (int i = 0; i < 8; ++i) {
            buf[i] = Mux.toHexChar(x >> (7 - i) * 4 & 0xF);
        }
        return new String(buf);
    }

    private static String toHexString(byte[] b) {
        char[] buf = new char[b.length * 2];
        int j = 0;
        for (int i = 0; i < b.length; ++i) {
            buf[j++] = Mux.toHexChar(b[i] >> 4 & 0xF);
            buf[j++] = Mux.toHexChar(b[i] & 0xF);
        }
        return new String(buf);
    }

    private static char toHexChar(int x) {
        return x < 10 ? (char)(48 + x) : (char)(55 + x);
    }

    static {
        $assertionsDisabled = !Mux.class.desiredAssertionStatus();
        magic = new byte[]{74, 109, 117, 120};
        systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
        sessionShutdownQueue = new LinkedList();
        logger = Logger.getLogger("net.jini.jeri.connection.mux");
    }

    private static class SessionShutdownTask
    implements Runnable {
        private final Session[] sessions;
        private final String message;
        private final Throwable cause;

        SessionShutdownTask(Session[] sessions, String message, Throwable cause) {
            this.sessions = sessions;
            this.message = message;
            this.cause = cause;
        }

        public void run() {
            for (int i = 0; i < this.sessions.length; ++i) {
                this.sessions[i].setDown(this.message, this.cause);
            }
        }
    }
}

