/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.beans.PropertyEditor;
import javax.servlet.jsp.JspException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.AbstractFormTag;
import org.springframework.web.servlet.tags.form.FormTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public abstract class AbstractDataBoundFormElementTag
extends AbstractFormTag {
    public static final String ID_ATTRIBUTE = "id";
    private BindStatus bindStatus;
    private String id;
    private String path;

    public void setPath(String path) {
        Assert.hasText(path, "'path' must not be empty");
        this.path = path;
    }

    protected final String getPath() throws JspException {
        return (String)this.evaluate("path", this.path);
    }

    public void setId(String id) {
        Assert.notNull(id, "'id' must not be null");
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    protected void writeDefaultAttributes(TagWriter tagWriter) throws JspException {
        String id = this.getId();
        if (StringUtils.hasText(id)) {
            tagWriter.writeAttribute(ID_ATTRIBUTE, ObjectUtils.getDisplayString(this.evaluate(ID_ATTRIBUTE, id)));
        } else {
            this.writeOptionalAttribute(tagWriter, ID_ATTRIBUTE, this.autogenerateId());
        }
        this.writeOptionalAttribute(tagWriter, "name", this.getName());
    }

    protected String autogenerateId() throws JspException {
        return this.getName();
    }

    protected String getName() throws JspException {
        return this.getCompletePath();
    }

    protected final Object getBoundValue() throws JspException {
        return this.getBindStatus().getValue();
    }

    protected PropertyEditor getPropertyEditor() throws JspException {
        return this.getBindStatus().getEditor();
    }

    protected BindStatus getBindStatus() throws JspException {
        if (this.bindStatus == null) {
            String resolvedPropertyPath = this.getPath();
            String bindPath = this.getBindPath(resolvedPropertyPath);
            this.bindStatus = new BindStatus(this.getRequestContext(), bindPath, false);
        }
        return this.bindStatus;
    }

    private String getBindPath(String resolvedSubPath) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getCommandName());
        String nestedPath = this.getNestedPath();
        if (nestedPath != null) {
            sb.append('.').append(nestedPath);
        }
        if (resolvedSubPath != null) {
            if (sb.charAt(sb.length() - 1) != '.') {
                sb.append('.');
            }
            sb.append(resolvedSubPath);
        }
        return sb.toString();
    }

    protected String getNestedPath() {
        return (String)this.pageContext.getAttribute("nestedPath", 2);
    }

    protected String getCompletePath() throws JspException {
        String nestedPath = this.getNestedPath();
        return nestedPath != null ? nestedPath + this.getPath() : this.getPath();
    }

    private String getCommandName() {
        return (String)this.pageContext.getAttribute(FormTag.COMMAND_NAME_VARIABLE_NAME, 2);
    }

    public void doFinally() {
        super.doFinally();
        this.bindStatus = null;
    }
}

