/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;

public abstract class ResourcePatternUtils {
    public static boolean isUrl(String resourceLocation) {
        if (resourceLocation.startsWith("classpath*:")) {
            return true;
        }
        return ResourceUtils.isUrl(resourceLocation);
    }

    public static ResourcePatternResolver getResourcePatternResolver(ResourceLoader resourceLoader) {
        Assert.notNull(resourceLoader, "ResourceLoader must not be null");
        if (resourceLoader instanceof ResourcePatternResolver) {
            return (ResourcePatternResolver)resourceLoader;
        }
        return new PathMatchingResourcePatternResolver(resourceLoader);
    }
}

