/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.adapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ThrowsAdviceInterceptor
implements MethodInterceptor {
    private static final String AFTER_THROWING = "afterThrowing";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$aop$framework$adapter$ThrowsAdviceInterceptor == null ? (class$org$springframework$aop$framework$adapter$ThrowsAdviceInterceptor = ThrowsAdviceInterceptor.class$("org.springframework.aop.framework.adapter.ThrowsAdviceInterceptor")) : class$org$springframework$aop$framework$adapter$ThrowsAdviceInterceptor));
    private final Object throwsAdvice;
    private final Map exceptionHandlerMap = new HashMap();
    static /* synthetic */ Class class$org$springframework$aop$framework$adapter$ThrowsAdviceInterceptor;
    static /* synthetic */ Class class$java$lang$Throwable;

    public ThrowsAdviceInterceptor(Object throwsAdvice) {
        this.throwsAdvice = throwsAdvice;
        Method[] methods = throwsAdvice.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(AFTER_THROWING) || method.getParameterTypes().length != 1 && method.getParameterTypes().length != 4 || !(class$java$lang$Throwable == null ? ThrowsAdviceInterceptor.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(method.getParameterTypes()[method.getParameterTypes().length - 1])) continue;
            this.exceptionHandlerMap.put(method.getParameterTypes()[method.getParameterTypes().length - 1], method);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Found exception handler method: " + method));
        }
        if (this.exceptionHandlerMap.isEmpty()) {
            throw new IllegalArgumentException("At least one handler method must be found in class [" + throwsAdvice.getClass() + "]");
        }
    }

    public int getHandlerMethodCount() {
        return this.exceptionHandlerMap.size();
    }

    private Method getExceptionHandler(Throwable exception) {
        Class<?> exceptionClass = exception.getClass();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Trying to find handler for exception of type [" + exceptionClass.getName() + "]"));
        }
        Method handler = (Method)this.exceptionHandlerMap.get(exceptionClass);
        while (handler == null && !exceptionClass.equals(class$java$lang$Throwable == null ? ThrowsAdviceInterceptor.class$("java.lang.Throwable") : class$java$lang$Throwable)) {
            exceptionClass = exceptionClass.getSuperclass();
            handler = (Method)this.exceptionHandlerMap.get(exceptionClass);
        }
        if (handler != null && logger.isDebugEnabled()) {
            logger.debug((Object)("Found handler for exception of type [" + exceptionClass.getName() + "]: " + handler));
        }
        return handler;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        try {
            return mi.proceed();
        }
        catch (Throwable ex) {
            Method handlerMethod = this.getExceptionHandler(ex);
            if (handlerMethod != null) {
                this.invokeHandlerMethod(mi, ex, handlerMethod);
            }
            throw ex;
        }
    }

    private void invokeHandlerMethod(MethodInvocation mi, Throwable ex, Method method) throws Throwable {
        Object[] handlerArgs = method.getParameterTypes().length == 1 ? new Object[]{ex} : new Object[]{mi.getMethod(), mi.getArguments(), mi.getThis(), ex};
        try {
            method.invoke(this.throwsAdvice, handlerArgs);
        }
        catch (InvocationTargetException targetEx) {
            throw targetEx.getTargetException();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

