/*
 * Decompiled with CFR 0.152.
 */
package org.testng.guice;

import java.lang.annotation.Annotation;
import org.testng.guice.AbstractProcessor;
import org.testng.guice.Scope;
import org.testng.guice.internal.Annotations;
import org.testng.guice.internal.Errors;
import org.testng.guice.internal.Preconditions;
import org.testng.guice.spi.ScopeBinding;

class ScopeBindingProcessor
extends AbstractProcessor {
    ScopeBindingProcessor(Errors errors) {
        super(errors);
    }

    public Boolean visit(ScopeBinding command) {
        Scope existing;
        Scope scope = command.getScope();
        Class<? extends Annotation> annotationType = command.getAnnotationType();
        if (!Annotations.isScopeAnnotation(annotationType)) {
            this.errors.withSource(annotationType).missingScopeAnnotation();
        }
        if (!Annotations.isRetainedAtRuntime(annotationType)) {
            this.errors.withSource(annotationType).missingRuntimeRetention(command.getSource());
        }
        if ((existing = this.injector.state.getScope(Preconditions.checkNotNull(annotationType, "annotation type"))) != null) {
            this.errors.duplicateScopes(existing, annotationType, scope);
        } else {
            this.injector.state.putAnnotation(annotationType, Preconditions.checkNotNull(scope, "scope"));
        }
        return true;
    }
}

