/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.util;

import java.io.File;
import java.text.MessageFormat;
import javax.swing.filechooser.FileFilter;

public final class ExtensionFileFilter
extends FileFilter {
    private String ext = "";
    private String desc = "";

    public ExtensionFileFilter(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("File Extensions Cannont Be null");
        }
        if (string2 == null) {
            throw new NullPointerException("File Description Cannont Be null");
        }
        this.ext = new String(string);
        this.desc = MessageFormat.format("{0} (*.{1})", string2, string);
    }

    public File applyExtension(File file) {
        return new File(file.getParentFile(), file.getName().concat(".".concat(this.ext)));
    }

    public boolean accept(File file) {
        if (file.canRead() || file.canWrite()) {
            return file.getName().endsWith("." + this.ext) || file.isDirectory() || file.isDirectory() && file.isHidden() && file.getName().startsWith(".");
        }
        return false;
    }

    public String getDescription() {
        return this.desc;
    }
}

