/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Utilities;
import javax.swing.undo.UndoManager;
import org.isqlviewer.core.Launcher;
import org.isqlviewer.core.SQLBookmark;
import org.isqlviewer.core.ServiceDefinition;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.swing.JConsole;
import org.isqlviewer.swing.JTextPopup;
import org.isqlviewer.util.ExtensionFileFilter;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public final class BasicUtilities {
    private static Toolkit tk = Toolkit.getDefaultToolkit();
    public static final DataFlavor bookmarkFlavour;
    public static final DataFlavor serviceFlavour;
    public static final DataFlavor BOOKMARK_PARAMETER_FLAVOR;
    public static final String WINDOW_MODIFIED = "windowModified";
    public static final int CMD_MASK;
    public static final Color DND_HAZE;
    private static ResourceBundle res;
    private static final JTextPopup textPopup;
    private static ModifierKeyword[] modifierKeywords;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;
    static /* synthetic */ Class class$org$isqlviewer$core$Launcher;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$org$isqlviewer$core$SQLBookmark$Parameter;
    static /* synthetic */ Class class$org$isqlviewer$core$ServiceDefinition;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$org$isqlviewer$core$SQLBookmark;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;

    private BasicUtilities() {
    }

    public static void setLookAndFeel(String string) {
        SystemConfig systemConfig = SystemConfig.getInstance();
        try {
            Class<?> clazz = Class.forName(string, true, systemConfig.getRuntimeClassLoader());
            LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            }
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, BasicUtilities.getString("LAF_Error", string));
            try {
                string = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(string);
            }
            catch (Throwable throwable2) {
                BasicUtilities.HandleException(throwable2, BasicUtilities.getString("LAF_Error", string));
                System.exit(-1);
            }
        }
    }

    public static KeyStroke getLocalKeyStroke(String string) {
        return BasicUtilities.getLocalKeyStroke(res, string);
    }

    public static String getString(String string, String string2) {
        return BasicUtilities.getString(res, string, string2);
    }

    public static String getString(String string, String[] stringArray) {
        return BasicUtilities.getString(res, string, stringArray);
    }

    public static String getString(String string) {
        return BasicUtilities.getString(res, string);
    }

    public static JLabel createLocalizedLabel(String string, String[] stringArray) {
        JLabel jLabel = new JLabel();
        jLabel.setText(BasicUtilities.getString(string, stringArray));
        return jLabel;
    }

    public static boolean is1dot4Runtime() {
        return System.getProperty("java.specification.version", "").startsWith("1.4");
    }

    public static final URL getResourceURL(String string) {
        Class<?> clazz = class$org$isqlviewer$core$Launcher;
        if (clazz == null) {
            clazz = class$org$isqlviewer$core$Launcher = new Launcher[0].getClass().getComponentType();
        }
        return clazz.getResource("/org/isqlviewer/resource/".concat(string));
    }

    public static final Icon loadToolbarIconResource(String string) {
        UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
        int n2 = userPreferences.getBoolean("general.large-icons") ? 24 : 16;
        return BasicUtilities.loadIconResource(string + n2);
    }

    public static final Icon loadIconResource(String string) {
        try {
            return new ImageIcon(BasicUtilities.getResourceURL("icons/" + string + ".png"));
        }
        catch (Throwable throwable) {
            System.err.println(BasicUtilities.getString("Image_Load_Error", string));
            return UIManager.getIcon("InternalFrame.icon");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void optimizeTableView(JTable jTable) {
        if (jTable == null) {
            return;
        }
        if (!(jTable.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)jTable.getParent();
        TableModel tableModel = jTable.getModel();
        jTable.setAutoResizeMode(0);
        jTable.setModel(tableModel);
        for (int i2 = 0; i2 < jTable.getColumnCount(); ++i2) {
            jTable.getColumnModel().getColumn(i2).sizeWidthToFit();
        }
        JTable jTable2 = jTable;
        synchronized (jTable2) {
            if (jTable.getPreferredSize().getWidth() <= jViewport.getPreferredSize().getWidth()) {
                jTable.setAutoResizeMode(4);
            }
        }
    }

    public static void removeSelectedColumns(JTable jTable) {
        if (jTable != null) {
            EnhancedTableModel enhancedTableModel = (EnhancedTableModel)jTable.getModel();
            int[] nArray = jTable.getSelectedColumns();
            for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                enhancedTableModel.removeColumn(nArray[i2]);
            }
            nArray = null;
            enhancedTableModel = null;
            BasicUtilities.optimizeTableView(jTable);
        }
    }

    public static File saveSystemFile(Component component) {
        return BasicUtilities.saveSystemFile(component, null);
    }

    public static File saveSystemFile(Component component, FileFilter[] fileFilterArray) {
        int n2;
        UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
        JFileChooser jFileChooser = new JFileChooser(userPreferences.get("session.last-location"));
        jFileChooser.setFileHidingEnabled(!userPreferences.getBoolean("general.hiddenfiles-enabled"));
        jFileChooser.setAcceptAllFileFilterUsed(true);
        if (fileFilterArray != null) {
            for (n2 = 0; n2 < fileFilterArray.length; ++n2) {
                jFileChooser.addChoosableFileFilter(fileFilterArray[n2]);
            }
            if (fileFilterArray.length >= 1) {
                jFileChooser.setFileFilter(fileFilterArray[0]);
            }
        }
        n2 = jFileChooser.showSaveDialog(component);
        userPreferences.put("session.last-location", jFileChooser.getCurrentDirectory().getAbsolutePath());
        if (n2 == 0) {
            Object object;
            File file = jFileChooser.getSelectedFile();
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (fileFilter != null && fileFilter instanceof ExtensionFileFilter) {
                object = (ExtensionFileFilter)fileFilter;
                if (!fileFilter.accept(file)) {
                    file = ((ExtensionFileFilter)object).applyExtension(file);
                }
            }
            if (file.exists()) {
                String string;
                object = BasicUtilities.getString("File_Overwrite_Message", file.getName());
                int n3 = JOptionPane.showConfirmDialog(component, object, string = BasicUtilities.getString("Warning"), 0);
                if (n3 == 0) {
                    return file;
                }
            } else {
                try {
                    if (file.createNewFile()) {
                        return file;
                    }
                }
                catch (IOException iOException) {
                    BasicUtilities.HandleException(iOException, "File::createNewFile()");
                }
            }
        }
        return null;
    }

    public static File getSystemFile(Component component, int n2) {
        return BasicUtilities.getSystemFile(component, n2, null);
    }

    public static File getSystemFile(Component component, int n2, FileFilter[] fileFilterArray) {
        int n3;
        UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
        JFileChooser jFileChooser = new JFileChooser(userPreferences.get("session.last-location"));
        jFileChooser.setFileSelectionMode(n2);
        jFileChooser.setFileHidingEnabled(!userPreferences.getBoolean("general.hiddenfiles-enabled"));
        jFileChooser.setAcceptAllFileFilterUsed(true);
        if (fileFilterArray != null) {
            for (n3 = 0; n3 < fileFilterArray.length; ++n3) {
                jFileChooser.addChoosableFileFilter(fileFilterArray[n3]);
            }
            if (fileFilterArray.length >= 1) {
                jFileChooser.setFileFilter(fileFilterArray[0]);
            }
        }
        n3 = jFileChooser.showOpenDialog(component);
        userPreferences.put("session.last-location", jFileChooser.getCurrentDirectory().getAbsolutePath());
        if (n3 == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public static File[] saveSystemFiles(Component component) {
        UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
        JFileChooser jFileChooser = new JFileChooser(userPreferences.get("session.last-location"));
        jFileChooser.setFileHidingEnabled(!userPreferences.getBoolean("general.hiddenfiles-enabled"));
        jFileChooser.setMultiSelectionEnabled(true);
        int n2 = jFileChooser.showSaveDialog(component);
        userPreferences.put("session.last-location", jFileChooser.getCurrentDirectory().getAbsolutePath());
        if (n2 == 0) {
            return jFileChooser.getSelectedFiles();
        }
        return new File[0];
    }

    public static File[] getSystemFiles(Component component, int n2) {
        return BasicUtilities.getSystemFiles(component, n2, null);
    }

    public static File[] getSystemFiles(Component component, int n2, FileFilter[] fileFilterArray) {
        int n3;
        UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
        JFileChooser jFileChooser = new JFileChooser(userPreferences.get("session.last-location"));
        jFileChooser.setFileSelectionMode(n2);
        jFileChooser.setFileHidingEnabled(!userPreferences.getBoolean("general.hiddenfiles-enabled"));
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setAcceptAllFileFilterUsed(true);
        if (fileFilterArray != null) {
            for (n3 = 0; n3 < fileFilterArray.length; ++n3) {
                jFileChooser.addChoosableFileFilter(fileFilterArray[n3]);
            }
            if (fileFilterArray.length >= 1) {
                jFileChooser.setFileFilter(fileFilterArray[0]);
            }
        }
        n3 = jFileChooser.showOpenDialog(component);
        userPreferences.put("session.last-location", jFileChooser.getCurrentDirectory().getAbsolutePath());
        if (n3 == 0) {
            return jFileChooser.getSelectedFiles();
        }
        return new File[0];
    }

    public static void removeSelectedRows(JTable jTable) {
        if (jTable != null) {
            try {
                EnhancedTableModel enhancedTableModel = (EnhancedTableModel)jTable.getModel();
                int[] nArray = jTable.getSelectedRows();
                for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                    enhancedTableModel.removeRow(nArray[i2]);
                }
                nArray = null;
                enhancedTableModel = null;
            }
            catch (Throwable throwable) {
                BasicUtilities.beep();
            }
        }
    }

    public static void showExceptionPopup(Component component, Throwable throwable, String string) {
        ThrowableOptionPane throwableOptionPane = new ThrowableOptionPane(throwable, string);
        JOptionPane.showMessageDialog(component, throwableOptionPane, BasicUtilities.getString("Error"), 0);
    }

    public static KeyStroke createKeyStroke(int n2, int n3) {
        return KeyStroke.getKeyStroke(n2, n3, false);
    }

    public static void copySelectedCellsToClipBoard(JTable jTable) {
        if (jTable != null) {
            try {
                jTable.getCellEditor().cancelCellEditing();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            StringBuffer stringBuffer = new StringBuffer("");
            StringBuffer stringBuffer2 = new StringBuffer("");
            for (int i2 = 0; i2 < jTable.getRowCount(); ++i2) {
                for (int i3 = 0; i3 < jTable.getColumnCount(); ++i3) {
                    if (!jTable.isCellSelected(i2, i3)) continue;
                    stringBuffer2.append(jTable.getValueAt(i2, i3) + "\t");
                }
                if (stringBuffer2.toString().trim().length() >= 1) {
                    stringBuffer.append(stringBuffer2);
                    stringBuffer.append(System.getProperty("line.seperator", "\n"));
                }
                stringBuffer2.setLength(0);
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(stringBuffer.toString().trim());
            clipboard.setContents(stringSelection, stringSelection);
        }
    }

    public static void restoreSystemOut() {
        PrintStream printStream = new PrintStream(new FileOutputStream(FileDescriptor.out));
        System.setOut(printStream);
    }

    public static void restoreSystemErr() {
        PrintStream printStream = new PrintStream(new FileOutputStream(FileDescriptor.err));
        System.setErr(printStream);
    }

    public static String getString(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (Throwable throwable) {
            System.out.println("** Warning ** Resource String [" + string + "] is not available.");
            return string;
        }
    }

    public static boolean isMac() {
        return System.getProperty("mrj.version") != null;
    }

    public static void beep() {
        tk.beep();
    }

    public static String createSafeFilename(String string) {
        string = string.replace(File.pathSeparatorChar, '_');
        string = string.replace(File.separatorChar, '_');
        string = string.replace('*', '_');
        string = string.replace(' ', '_');
        string = string.replace('(', '_');
        string = string.replace(')', '_');
        string = string.replace('\'', '_');
        string = string.replace('|', '_');
        string = string.replace('\"', '_');
        string = string.replace(';', '_');
        string = string.replace(':', '_');
        string = string.replace('>', '_');
        string = string.replace('<', '_');
        string = string.replace('[', '_');
        string = string.replace(']', '_');
        string = string.replace('&', '_');
        string = string.replace('#', '_');
        string = string.replace('@', '_');
        string = string.replace('$', '_');
        string = string.replace('%', '_');
        string = string.replace('^', '_');
        return string;
    }

    public static void lockComponentToPerferredSize(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        jComponent.setPreferredSize(dimension);
        jComponent.setMaximumSize(dimension);
        jComponent.setMinimumSize(dimension);
    }

    public static KeyStroke getLocalKeyStroke(ResourceBundle resourceBundle, String string) {
        try {
            return BasicUtilities.getKeyStroke(resourceBundle.getString(string));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getString(ResourceBundle resourceBundle, String string, String string2) {
        return BasicUtilities.getString(resourceBundle, string, new String[]{string2});
    }

    public static String getString(ResourceBundle resourceBundle, String string, String[] stringArray) {
        return MessageFormat.format(BasicUtilities.getString(resourceBundle, string), stringArray);
    }

    public static void HandleException(Throwable throwable) {
        BasicUtilities.HandleException(throwable, null, Boolean.getBoolean("isql.debug"));
    }

    public static void HandleException(Throwable throwable, String string) {
        BasicUtilities.HandleException(throwable, string, Boolean.getBoolean("isql.debug"));
    }

    public static void HandleException(Throwable throwable, String string, boolean bl2) {
        BasicUtilities.HandleException(throwable, string, bl2, System.err);
    }

    public static void HandleException(Throwable throwable, String string, boolean bl2, PrintStream printStream) {
        BasicUtilities.HandleException(throwable, string, bl2, new PrintWriter(printStream, true));
    }

    public static void HandleException(Throwable throwable, String string, boolean bl2, PrintWriter printWriter) {
        if (printWriter == null) {
            printWriter = new PrintWriter(System.err, true);
        }
        if (string != null) {
            printWriter.println(string);
        }
        if (throwable != null) {
            String string2 = throwable.getClass().getName();
            string2 = string2.substring(string2.lastIndexOf(46) + 1);
            String string3 = "Error";
            if (throwable instanceof Error) {
                string3 = "Error";
            } else {
                if (throwable instanceof SQLException) {
                    SystemConfig systemConfig = SystemConfig.getInstance();
                    UserPreferences userPreferences = systemConfig.getPreferences();
                    SQLException sQLException = (SQLException)throwable;
                    String[] stringArray = new String[]{sQLException.getMessage() != null ? sQLException.getMessage().trim() : "null", Integer.toString(sQLException.getErrorCode()), sQLException.getSQLState() == null ? "null" : sQLException.getSQLState()};
                    printWriter.println(BasicUtilities.getString("SQL_Exception", stringArray));
                    int n2 = userPreferences.getInt("jdbc.max-warnings");
                    sQLException = sQLException.getNextException();
                    for (int n3 = 0; n3 < n2 && sQLException != null; sQLException = sQLException.getNextException(), ++n3) {
                        stringArray = new String[]{Integer.toString(n3), sQLException.getMessage() != null ? sQLException.getMessage().trim() : "null", Integer.toString(sQLException.getErrorCode()), sQLException.getSQLState() == null ? "null" : sQLException.getSQLState()};
                        printWriter.println(BasicUtilities.getString("Chained_SQL_Exception", stringArray));
                    }
                    if (bl2) {
                        throwable.printStackTrace(printWriter);
                    }
                    stringArray = null;
                    return;
                }
                if (throwable instanceof RuntimeException) {
                    string3 = "Runtime Exception";
                } else if (throwable instanceof Exception) {
                    string3 = "Exception";
                }
            }
            String string4 = "{0}::({1})";
            String string5 = throwable.getLocalizedMessage();
            Object[] objectArray = new String[]{string3, string5 == null ? throwable.getMessage() : string5};
            printWriter.println(MessageFormat.format(string4, objectArray));
            if (bl2) {
                throwable.printStackTrace(printWriter);
            }
        }
    }

    public static int getCaretCol(int n2, JTextComponent jTextComponent) throws Exception {
        return Math.abs(Utilities.getRowStart(jTextComponent, n2) - n2);
    }

    public static int getCaretRow(int n2, JTextComponent jTextComponent) throws Exception {
        return BasicUtilities.getLineOfOffset(n2, jTextComponent.getDocument());
    }

    public static String getCurrentWord(Document document, int n2) throws BadLocationException {
        int n3;
        String string = document.getText(0, document.getLength());
        String string2 = "\r\t\n ,=<>?{}[]|`~;&+-/*@%";
        int n4 = Math.max(0, n2 - 1);
        int n5 = string.length();
        int n6 = 0;
        int n7 = -1;
        int n8 = n4;
        char[] cArray = string.toCharArray();
        for (n3 = n6 + (n8 >= n5 ? n5 - 1 : n8); n3 >= n6; --n3) {
            if (string2.indexOf(cArray[n3]) < 0) continue;
            n7 = n3 + 1;
            break;
        }
        n3 = Math.max(0, n7);
        return string.substring(n3, Math.min(n2, document.getLength())).trim();
    }

    public static int getCurrentWordOffset(Document document, int n2) throws BadLocationException {
        String string = document.getText(0, document.getLength());
        String string2 = "\r\t\n ,=<>?{}[]|`~;&+-/*@%";
        int n3 = Math.max(0, n2 - 1);
        int n4 = string.length();
        int n5 = 0;
        int n6 = -1;
        int n7 = n3;
        char[] cArray = string.toCharArray();
        for (int i2 = n5 + (n7 >= n4 ? n4 - 1 : n7); i2 >= n5; --i2) {
            if (string2.indexOf(cArray[i2]) < 0) continue;
            n6 = i2 + 1;
            break;
        }
        return Math.max(0, n6);
    }

    public static void setPreferredGeometry(JFrame jFrame, Dimension dimension, String string) {
        Dimension dimension2 = tk.getScreenSize();
        if (dimension.height > dimension2.height) {
            dimension.height = dimension2.height;
        }
        if (dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        Point point = new Point((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        Rectangle rectangle = new Rectangle(point, dimension);
        UserPreferences userPreferences = SystemConfig.getInstance().getPreferences();
        Rectangle rectangle2 = userPreferences.getRect("session.".concat(string));
        if (rectangle2.width * rectangle2.height >= 1) {
            rectangle.setBounds(rectangle2);
        }
        jFrame.setBounds(rectangle);
    }

    public static Class getClassForPrimative(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                Class<?> clazz2 = class$java$lang$Boolean;
                if (clazz2 == null) {
                    clazz2 = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
                }
                return clazz2;
            }
            if (clazz == Float.TYPE) {
                Class<?> clazz3 = class$java$lang$Float;
                if (clazz3 == null) {
                    clazz3 = class$java$lang$Float = new Float[0].getClass().getComponentType();
                }
                return clazz3;
            }
            if (clazz == Integer.TYPE) {
                Class<?> clazz4 = class$java$lang$Integer;
                if (clazz4 == null) {
                    clazz4 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
                }
                return clazz4;
            }
            if (clazz == Short.TYPE) {
                Class<?> clazz5 = class$java$lang$Short;
                if (clazz5 == null) {
                    clazz5 = class$java$lang$Short = new Short[0].getClass().getComponentType();
                }
                return clazz5;
            }
            if (clazz == Long.TYPE) {
                Class<?> clazz6 = class$java$lang$Long;
                if (clazz6 == null) {
                    clazz6 = class$java$lang$Long = new Long[0].getClass().getComponentType();
                }
                return clazz6;
            }
            if (clazz == Double.TYPE) {
                Class<?> clazz7 = class$java$lang$Double;
                if (clazz7 == null) {
                    clazz7 = class$java$lang$Double = new Double[0].getClass().getComponentType();
                }
                return clazz7;
            }
            if (clazz == Character.TYPE) {
                Class<?> clazz8 = class$java$lang$Character;
                if (clazz8 == null) {
                    clazz8 = class$java$lang$Character = new Character[0].getClass().getComponentType();
                }
                return clazz8;
            }
            if (clazz == Byte.TYPE) {
                Class<?> clazz9 = class$java$lang$Byte;
                if (clazz9 == null) {
                    clazz9 = class$java$lang$Byte = new Byte[0].getClass().getComponentType();
                }
                return clazz9;
            }
            if (clazz == Void.TYPE) {
                Class<?> clazz10 = class$java$lang$Void;
                if (clazz10 == null) {
                    clazz10 = class$java$lang$Void = new Void[0].getClass().getComponentType();
                }
                return clazz10;
            }
        } else {
            Class<?> clazz11 = class$java$lang$String;
            if (clazz11 == null) {
                clazz11 = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            if (clazz == clazz11) {
                Class<?> clazz12 = class$java$lang$String;
                if (clazz12 == null) {
                    clazz12 = class$java$lang$String = new String[0].getClass().getComponentType();
                }
                return clazz12;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        InputStream inputStream2 = inputStream;
        synchronized (inputStream2) {
            OutputStream outputStream2 = outputStream;
            synchronized (outputStream2) {
                int n2;
                byte[] byArray = new byte[256];
                while ((n2 = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyReader(Reader reader, Writer writer) throws IOException {
        Reader reader2 = reader;
        synchronized (reader2) {
            Writer writer2 = writer;
            synchronized (writer2) {
                int n2;
                char[] cArray = new char[256];
                while ((n2 = reader.read(cArray)) != -1) {
                    writer.write(cArray, 0, n2);
                }
            }
        }
    }

    public static int getLineOfOffset(int n2, Document document) throws BadLocationException {
        if (n2 < 0 || document == null) {
            throw new BadLocationException("", -1);
        }
        if (n2 > document.getLength()) {
            throw new BadLocationException("", document.getLength() + 1);
        }
        Element element = document.getDefaultRootElement();
        return element.getElementIndex(n2);
    }

    public static KeyStroke getKeyStroke(String string) {
        String string2;
        if (string == null || string.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while ((string2 = stringTokenizer.nextToken()) != null) {
            int n3;
            int n4 = 0;
            for (int i2 = 0; n4 == 0 && i2 < modifierKeywords.length; ++i2) {
                n4 = modifierKeywords[i2].getModifierMask(string2);
            }
            if (n4 != 0) {
                n2 |= n4;
                continue;
            }
            if (string2.equals("released")) {
                bl2 = true;
                continue;
            }
            if (string2.equals("pressed")) continue;
            if (string2.equals("typed")) {
                bl3 = true;
                continue;
            }
            if (bl3) {
                if (string2.length() != 1) {
                    return null;
                }
                return KeyStroke.getKeyStroke(string2.charAt(0));
            }
            String string3 = "VK_" + string2;
            try {
                Class<?> clazz = class$java$awt$event$KeyEvent;
                if (clazz == null) {
                    clazz = class$java$awt$event$KeyEvent = new KeyEvent[0].getClass().getComponentType();
                }
                Field field = clazz.getField(string3);
                Class<?> clazz2 = class$java$awt$event$KeyEvent;
                if (clazz2 == null) {
                    clazz2 = class$java$awt$event$KeyEvent = new KeyEvent[0].getClass().getComponentType();
                }
                n3 = field.getInt(clazz2);
            }
            catch (Throwable throwable) {
                return null;
            }
            return KeyStroke.getKeyStroke(n3, n2, bl2);
        }
        return null;
    }

    public static void unlocalizeTextComponent(JTextComponent jTextComponent, UndoManager undoManager) {
        textPopup.removeJTextComponent(jTextComponent);
        if (undoManager != null) {
            Keymap keymap = jTextComponent.getKeymap();
            keymap.removeKeyStrokeBinding(BasicUtilities.createKeyStroke(90, CMD_MASK));
            keymap.removeKeyStrokeBinding(BasicUtilities.createKeyStroke(89, CMD_MASK));
        }
    }

    public static void localizeTextComponent(JTextComponent jTextComponent, UndoManager undoManager) {
        ActionMap actionMap = jTextComponent.getActionMap();
        Keymap keymap = jTextComponent.getKeymap();
        Action action = null;
        action = actionMap.get("cut-to-clipboard");
        keymap.addActionForKeyStroke(BasicUtilities.createKeyStroke(88, CMD_MASK), action);
        action = actionMap.get("copy-to-clipboard");
        keymap.addActionForKeyStroke(BasicUtilities.createKeyStroke(67, CMD_MASK), action);
        action = actionMap.get("paste-from-clipboard");
        keymap.addActionForKeyStroke(BasicUtilities.createKeyStroke(86, CMD_MASK), action);
        action = actionMap.get("select-all");
        keymap.addActionForKeyStroke(BasicUtilities.createKeyStroke(65, CMD_MASK), action);
        textPopup.addJTextComponent(jTextComponent, true);
        if (undoManager != null) {
            action = new UndoTextAction(undoManager);
            keymap.addActionForKeyStroke(BasicUtilities.createKeyStroke(90, CMD_MASK), action);
            action = new RedoTextAction(undoManager);
            keymap.addActionForKeyStroke(BasicUtilities.createKeyStroke(89, CMD_MASK), action);
        }
    }

    static {
        Class<?> clazz = class$org$isqlviewer$core$SQLBookmark;
        if (clazz == null) {
            clazz = class$org$isqlviewer$core$SQLBookmark = new SQLBookmark[0].getClass().getComponentType();
        }
        bookmarkFlavour = new DataFlavor(clazz, "SQL-Bookmark");
        Class<?> clazz2 = class$org$isqlviewer$core$ServiceDefinition;
        if (clazz2 == null) {
            clazz2 = class$org$isqlviewer$core$ServiceDefinition = new ServiceDefinition[0].getClass().getComponentType();
        }
        serviceFlavour = new DataFlavor(clazz2, "iSQL-Service");
        Class<?> clazz3 = class$org$isqlviewer$core$SQLBookmark$Parameter;
        if (clazz3 == null) {
            clazz3 = class$org$isqlviewer$core$SQLBookmark$Parameter = new SQLBookmark.Parameter[0].getClass().getComponentType();
        }
        BOOKMARK_PARAMETER_FLAVOR = new DataFlavor(clazz3, "isql.bookmark.parameter");
        CMD_MASK = tk.getMenuShortcutKeyMask();
        DND_HAZE = new Color(255, 255, 255, 112);
        res = ResourceBundle.getBundle("org.isqlviewer.resource.ResourceStrings");
        textPopup = new JTextPopup();
        modifierKeywords = new ModifierKeyword[]{new ModifierKeyword("shift", 1), new ModifierKeyword("control", 2), new ModifierKeyword("ctrl", 2), new ModifierKeyword("meta", CMD_MASK), new ModifierKeyword("alt", 8), new ModifierKeyword("button1", 16), new ModifierKeyword("button2", 8), new ModifierKeyword("button3", 4)};
    }

    public static class RedoTextAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private UndoManager um = null;

        public RedoTextAction(UndoManager undoManager) {
            this.um = undoManager;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.um.redo();
            }
            catch (Throwable throwable) {
                BasicUtilities.beep();
            }
        }
    }

    public static class UndoTextAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private UndoManager um = null;

        public UndoTextAction(UndoManager undoManager) {
            this.um = undoManager;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.um.undo();
            }
            catch (Throwable throwable) {
                BasicUtilities.beep();
            }
        }
    }

    private static class ModifierKeyword {
        public final String keyword;
        public final int mask;

        public ModifierKeyword(String string, int n2) {
            this.keyword = string;
            this.mask = n2;
        }

        public int getModifierMask(String string) {
            return string.equals(this.keyword) ? this.mask : 0;
        }
    }

    private static class ThrowableOptionPane
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private JToggleButton tog = new JToggleButton(BasicUtilities.loadIconResource("StepForward24"));
        private JConsole txt = new JConsole("");

        public ThrowableOptionPane(Throwable throwable, String string) {
            super(new BorderLayout());
            this.txt.setVisible(false);
            this.tog.setText(BasicUtilities.getString("Error_Details"));
            this.tog.setSelectedIcon(BasicUtilities.loadIconResource("Down24"));
            this.tog.setHorizontalTextPosition(2);
            this.tog.addActionListener(this);
            this.txt.configure(SystemConfig.getInstance().getPreferences());
            PrintStream printStream = new PrintStream(this.txt.toOutputStream(), true);
            this.txt.setPreferredSize(new Dimension(400, 300));
            BasicUtilities.HandleException(throwable, string, true, printStream);
            this.add((Component)this.tog, "North");
            string = "<html>".concat(StringUtilities.formatBreak(80, string, " ", true));
            this.add((Component)new JLabel(string), "South");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.txt.setVisible(!this.txt.isVisible());
            Window window = SwingUtilities.getWindowAncestor(this);
            if (!this.txt.isVisible()) {
                this.remove(this.txt);
            } else {
                this.add((Component)this.txt, "Center");
            }
            this.validateTree();
            window.pack();
        }
    }
}

