/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui.prefs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.iSQLTableModel;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.ui.AbstractPropertyPage;
import org.isqlviewer.util.BasicUtilities;

public final class JDBCDriverPropertyPage
extends AbstractPropertyPage
implements TableModelListener,
ActionListener {
    private iSQLTableModel mdlDrivers = null;
    private JCheckBox chkAutoUpdate = new JCheckBox();
    private JButton btnDeleteDrvr = new JButton();
    private JButton btnAddDrvr = new JButton();
    private JButton btnDefaults = new JButton();
    private ITable tabDrivers = new ITable();

    public JDBCDriverPropertyPage() {
        try {
            this.initUI();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "PropertiesDrivers::initUI()");
        }
    }

    public String getPropertyPageName() {
        return BasicUtilities.getString("Drivers_Property_Page");
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Csv16");
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        switch (tableModelEvent.getType()) {
            case -1: 
            case 0: 
            case 1: {
                this.setModified(true);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties() {
        super.saveProperties();
        Properties properties = this.mdlDrivers.getTableAsProperties();
        FileOutputStream fileOutputStream = null;
        File file = new File(SystemConfig.getBaseDirectory(), "driver.properties");
        try {
            fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, "");
        }
        catch (Throwable throwable) {
            String string = BasicUtilities.getString("Error_Writing_File", file.getAbsolutePath());
            BasicUtilities.HandleException(throwable, string);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Throwable throwable) {}
        }
        properties.clear();
        properties = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnAddDrvr) {
            ArrayList<String> arrayList = new ArrayList<String>(2);
            arrayList.add("");
            arrayList.add("");
            this.mdlDrivers.addRow(arrayList);
            return;
        }
        if (object == this.btnDefaults) {
            return;
        }
        if (object == this.btnDeleteDrvr) {
            BasicUtilities.removeSelectedRows(this.tabDrivers);
            return;
        }
    }

    public void initUI() {
        this.setLayout(new GridBagLayout());
        this.chkAutoUpdate.setToolTipText(BasicUtilities.getString("Drivers_AutoUpdate_Tip"));
        this.chkAutoUpdate.setText(BasicUtilities.getString("Drivers_AutoUpdate"));
        this.setPropertyForComponent(this.chkAutoUpdate, "general.driverupdate-enabled");
        this.btnDeleteDrvr.setToolTipText(BasicUtilities.getString("Drivers_Delete_Tip"));
        this.btnDeleteDrvr.setText(BasicUtilities.getString("Drivers_Delete"));
        this.btnAddDrvr.setToolTipText(BasicUtilities.getString("Drivers_Add_New_Tip"));
        this.btnAddDrvr.setText(BasicUtilities.getString("Drivers_Add_New"));
        this.btnDefaults.setToolTipText(BasicUtilities.getString("Drivers_Reset_Tip"));
        this.btnDefaults.setText(BasicUtilities.getString("Drivers_Reset"));
        this.btnDeleteDrvr.addActionListener(this);
        this.btnAddDrvr.addActionListener(this);
        this.btnDefaults.addActionListener(this);
        this.mdlDrivers = new iSQLTableModel(SystemConfig.getInstance().getDriverDefinitions());
        this.mdlDrivers.allowEditing(true);
        this.mdlDrivers.addTableModelListener(this);
        this.tabDrivers.setModel(this.mdlDrivers);
        JScrollPane jScrollPane = new JScrollPane(this.tabDrivers);
        jScrollPane.setPreferredSize(new Dimension(420, this.tabDrivers.getRowHeight() * 14));
        JDBCDriverPropertyPage.constrain(1, 0, 1, 1, 0.0, 0.0, 10, 0);
        this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        JDBCDriverPropertyPage.constrain(0, 0, 1, 6, 0.0, 0.0, 10, 0);
        this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        JDBCDriverPropertyPage.constrain(1, 1, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkAutoUpdate, UI_CONSTRAINT);
        JDBCDriverPropertyPage.constrain(3, 1, 1, 1, 0.0, 0.0, 13, 0);
        this.add((Component)this.btnDefaults, UI_CONSTRAINT);
        JDBCDriverPropertyPage.constrain(1, 2, 3, 1, 0.0, 0.0, 10, 2);
        this.add(JDBCDriverPropertyPage.createHorizSeperator(), UI_CONSTRAINT);
        JDBCDriverPropertyPage.constrain(1, 2, 3, 1, 0.0, 0.0, 10, 0);
        this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        JDBCDriverPropertyPage.constrain(1, 3, 1, 1, 1.0, 0.0, 10, 2);
        this.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
        JDBCDriverPropertyPage.constrain(2, 3, 1, 1, 0.0, 0.0, 13, 0);
        this.add((Component)this.btnDeleteDrvr, UI_CONSTRAINT);
        JDBCDriverPropertyPage.constrain(3, 3, 1, 1, 0.0, 0.0, 13, 0);
        this.add((Component)this.btnAddDrvr, UI_CONSTRAINT);
        JDBCDriverPropertyPage.constrain(1, 4, 3, 1, 0.0, 0.0, 10, 1);
        this.add((Component)jScrollPane, UI_CONSTRAINT);
        JDBCDriverPropertyPage.constrain(1, 5, 3, 1, 0.0, 1.0, 10, 3);
        this.add(Box.createVerticalGlue(), UI_CONSTRAINT);
        JDBCDriverPropertyPage.constrain(4, 0, 1, 6, 1.0, 0.0, 10, 2);
        this.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
    }
}

