/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WizardPanel
extends JPanel {
    private transient Vector changeListeners;

    public WizardPanel() {
        super(new Layout(null));
    }

    public Component getCard(String string) {
        int n2 = this.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = this.getComponent(i2);
            if (!string.equals(component.getName())) continue;
            return component;
        }
        return null;
    }

    public void showCard(Component component) {
        int n2;
        if (component.getParent() != this) {
            this.add(component);
        }
        if ((n2 = this.getVisibleChildIndex()) != -1) {
            this.getComponent(n2).setVisible(false);
        }
        component.setVisible(true);
        this.fireStateChanged(new ChangeEvent(this));
        this.revalidate();
        this.repaint();
    }

    public void showCard(String string) {
        int n2 = this.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = this.getComponent(i2);
            if (!component.getName().equals(string)) continue;
            this.showCard(component);
            break;
        }
    }

    public void showNextCard() {
        if (this.getComponentCount() <= 0) {
            return;
        }
        try {
            String string = this.getCurrentCard();
            int n2 = this.getVisibleChildIndex();
            if (n2 >= this.getComponentCount() - 1) {
                this.showLastCard();
            } else {
                string = this.getComponent(++n2).getName();
                this.showCard(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void showPreviousCard() {
        if (this.getComponentCount() <= 0) {
            return;
        }
        try {
            String string = this.getCurrentCard();
            int n2 = this.getVisibleChildIndex();
            if (n2 >= 1) {
                string = this.getComponent(--n2).getName();
                this.showCard(string);
            } else {
                this.showFirstCard();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getCurrentCard() {
        try {
            return this.getComponent(this.getVisibleChildIndex()).getName();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public Component removeCard(String string) {
        int n2 = this.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = this.getComponent(i2);
            if (!component.getName().equals(string)) continue;
            this.remove(component);
            return component;
        }
        return null;
    }

    public void showFirstCard() {
        if (this.getComponentCount() <= 0) {
            return;
        }
        try {
            String string = this.getComponent(0).getName();
            this.showCard(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void showLastCard() {
        if (this.getComponentCount() <= 0) {
            return;
        }
        try {
            String string = this.getComponent(this.getComponentCount() - 1).getName();
            this.showCard(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners != null && this.changeListeners.contains(changeListener)) {
            Vector vector = (Vector)this.changeListeners.clone();
            vector.removeElement(changeListener);
            this.changeListeners = vector;
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        Vector vector;
        Vector vector2 = vector = this.changeListeners == null ? new Vector(2) : (Vector)this.changeListeners.clone();
        if (!vector.contains(changeListener)) {
            vector.addElement(changeListener);
            this.changeListeners = vector;
        }
    }

    public void fireStateChanged(ChangeEvent changeEvent) {
        if (this.changeListeners != null) {
            Vector vector = this.changeListeners;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((ChangeListener)vector.elementAt(i2)).stateChanged(changeEvent);
            }
        }
    }

    public int getVisibleChildIndex() {
        int n2 = this.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = this.getComponent(i2);
            if (!component.isVisible()) continue;
            return i2;
        }
        return -1;
    }

    public static class 1 {
    }

    private static class Layout
    implements LayoutManager {
        private Layout() {
        }

        public void addLayoutComponent(String string, Component component) {
            if (string != null) {
                component.setName(string);
            }
            component.setVisible(component.getParent().getComponentCount() == 1);
        }

        public void removeLayoutComponent(Component component) {
            Container container;
            if (component.isVisible() && (container = component.getParent()).getComponentCount() > 0) {
                container.getComponent(0).setVisible(true);
                this.layoutContainer(container);
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            int n2 = container.getComponentCount();
            Insets insets = container.getInsets();
            int n3 = insets.left + insets.right;
            int n4 = insets.top + insets.bottom;
            for (int i2 = 0; i2 < n2; ++i2) {
                Dimension dimension = container.getComponent(i2).getPreferredSize();
                if (dimension.width > n3) {
                    n3 = dimension.width;
                }
                if (dimension.height <= n4) continue;
                n4 = dimension.height;
            }
            return new Dimension(n3, n4);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n2 = container.getComponentCount();
            Insets insets = container.getInsets();
            int n3 = insets.left + insets.right;
            int n4 = insets.top + insets.bottom;
            for (int i2 = 0; i2 < n2; ++i2) {
                Dimension dimension = container.getComponent(i2).getMinimumSize();
                if (dimension.width > n3) {
                    n3 = dimension.width;
                }
                if (dimension.height <= n4) continue;
                n4 = dimension.height;
            }
            return new Dimension(n3, n4);
        }

        public void layoutContainer(Container container) {
            int n2 = container.getComponentCount();
            Insets insets = new Insets(10, 10, 10, 10);
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component = container.getComponent(i2);
                if (!component.isVisible()) continue;
                Rectangle rectangle = container.getBounds();
                int n3 = rectangle.width - (insets.left + insets.right);
                int n4 = rectangle.height - (insets.top + insets.bottom);
                component.setBounds(insets.left, insets.top, n3, n4);
                break;
            }
        }

        public /* synthetic */ Layout(1 var1_1) {
            this();
        }
    }
}

