/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.ColumnMetaData;

public class WhereEditor
extends JComponent {
    public static final int ACTION_ADD = 0;
    public static final int ACTION_DELETE = 1;
    public static final int STYLE_EQUAL = 0;
    public static final int STYLE_NOT_EQUAL = 1;
    public static final int STYLE_GREATER_THAN = 2;
    public static final int STYLE_LESS_THAN = 3;
    public static final int STYLE_CONTAINS = 4;
    public static final int STYLE_DOES_NOT_CONTAIN = 5;
    public static final int STYLE_IN_RANGE = 6;
    public static final int STYLE_NOT_IN_RANGE = 7;
    public static final int STYLE_IN_LAST = 8;
    public static final int STYLE_NOT_IN_LAST = 9;
    public static final int STYLE_ENDS_WITH = 10;
    public static final int STYLE_STARTS_WITH = 11;
    private DefaultComboBoxModel mdlColumn = new DefaultComboBoxModel<Object>(new Object[0]);
    private DefaultComboBoxModel mdlStyle = new DefaultComboBoxModel<Object>(new Object[0]);
    private DefaultComboBoxModel mdlDays = new DefaultComboBoxModel<Object>(new Object[]{BasicUtilities.getString("QBuild_Natural_Hours"), BasicUtilities.getString("QBuild_Natural_Days"), BasicUtilities.getString("QBuild_Natural_Weeks"), BasicUtilities.getString("QBuild_Natural_Months"), BasicUtilities.getString("QBuild_Natural_Years")});
    private JComboBox jcbColumn = new JComboBox(this.mdlColumn);
    private JComboBox jcbStyle = new JComboBox(this.mdlStyle);
    private JComboBox jcbDays = new JComboBox(this.mdlDays);
    private SystemConfig sysConfig = SystemConfig.getInstance();
    private SimpleDateFormat sdf = new SimpleDateFormat("");
    private JTextComponent txtValue = new JTextField(8);
    private JTextComponent txtSecondary = new JTextField(8);
    private JButton btnAdd = new JButton(BasicUtilities.getString("QBuild_Natural_Plus"));
    private JButton btnDel = new JButton(BasicUtilities.getString("QBuild_Natural_Minus"));
    private JPanel pnlEditor = new JPanel();
    private JLabel lblTo = new JLabel(BasicUtilities.getString("QBuild_Natural_To"));
    private TreeMap meta = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private ArrayList listenerList = null;
    private ActionHandler actionHandler = new ActionHandler(null);

    public WhereEditor(Map map) {
        this.setLayout(new GridBagLayout());
        this.btnAdd.setMargin(new Insets(0, 0, 0, 0));
        this.btnDel.setMargin(new Insets(0, 0, 0, 0));
        this.btnDel.setPreferredSize(this.btnDel.getMinimumSize());
        this.btnAdd.setPreferredSize(this.btnAdd.getMinimumSize());
        this.pnlEditor.setLayout(new GridBagLayout());
        this.pnlEditor.add(this.txtValue);
        this.add((Component)this.jcbColumn, WhereEditor.constrain(0, 0.0, 17, 0));
        this.add((Component)this.jcbStyle, WhereEditor.constrain(1, 0.0, 17, 0));
        this.add((Component)this.pnlEditor, WhereEditor.constrain(2, 1.0, 17, 2));
        this.add((Component)this.btnDel, WhereEditor.constrain(3, 0.0, 17, 0));
        this.add((Component)this.btnAdd, WhereEditor.constrain(4, 0.0, 17, 0));
        this.jcbColumn.addActionListener(this.actionHandler);
        this.jcbStyle.addActionListener(this.actionHandler);
        this.btnDel.addActionListener(this.actionHandler);
        this.btnAdd.addActionListener(this.actionHandler);
        this.updateMetamap(map);
        this.validateTree();
    }

    public int getSelectedStyle() {
        String string = (String)this.jcbStyle.getSelectedItem();
        String string2 = null;
        String string3 = null;
        string2 = BasicUtilities.getString("QBuild_Natural_Equal");
        if (string2.equalsIgnoreCase(string)) {
            return 0;
        }
        string2 = BasicUtilities.getString("QBuild_Natural_Not_Equal");
        if (string2.equalsIgnoreCase(string)) {
            return 1;
        }
        string2 = BasicUtilities.getString("QBuild_Natural_In_Range");
        if (string2.equalsIgnoreCase(string)) {
            return 6;
        }
        string2 = BasicUtilities.getString("QBuild_Natural_Not_In_Range");
        if (string2.equalsIgnoreCase(string)) {
            return 7;
        }
        string2 = BasicUtilities.getString("QBuild_Natural_In_Last");
        if (string2.equalsIgnoreCase(string)) {
            return 8;
        }
        string2 = BasicUtilities.getString("QBuild_Natural_Not_In_Last");
        if (string2.equalsIgnoreCase(string)) {
            return 9;
        }
        string2 = BasicUtilities.getString("QBuild_Natural_Starts_With");
        if (string2.equalsIgnoreCase(string)) {
            return 11;
        }
        string2 = BasicUtilities.getString("QBuild_Natural_Ends_With");
        if (string2.equalsIgnoreCase(string)) {
            return 10;
        }
        string2 = BasicUtilities.getString("QBuild_Natural_Does_Not_Contain");
        if (string2.equalsIgnoreCase(string)) {
            return 5;
        }
        string2 = BasicUtilities.getString("QBuild_Natural_Contains");
        if (string2.equalsIgnoreCase(string)) {
            return 4;
        }
        string2 = BasicUtilities.getString("QBuild_Natural_After");
        string3 = BasicUtilities.getString("QBuild_Natural_Greater_Than");
        if (string2.equalsIgnoreCase(string) || string3.equalsIgnoreCase(string)) {
            return 2;
        }
        string2 = BasicUtilities.getString("QBuild_Natural_Before");
        string3 = BasicUtilities.getString("QBuild_Natural_Less_Than");
        if (string2.equalsIgnoreCase(string) || string3.equalsIgnoreCase(string)) {
            return 3;
        }
        return -1;
    }

    public ColumnMetaData getSelectedColumn() {
        Object object = this.jcbColumn.getSelectedItem();
        return (ColumnMetaData)this.meta.get(object);
    }

    public Object[] getUserOptions() throws ParseException {
        int n2 = this.getSelectedStyle();
        int n3 = this.getSelectedColumn().getType();
        String string = this.sysConfig.getFormatForSQLType(n3);
        string = string == null ? "" : string;
        this.sdf.applyPattern(string);
        Object object = this.txtValue.getText();
        Object object2 = this.txtSecondary.getText();
        block4 : switch (n3) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                object = JDBCUtilities.convertValue(object, n3, null);
                try {
                    object2 = JDBCUtilities.convertValue(object2, n3, null);
                    break;
                }
                catch (ParseException parseException) {
                    switch (n2) {
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: {
                            break block4;
                        }
                    }
                    throw parseException;
                }
            }
            case 91: {
                switch (n2) {
                    case 8: 
                    case 9: {
                        object = JDBCUtilities.convertValue(object, 4, null);
                        break block4;
                    }
                }
                object = JDBCUtilities.convertValue(object, n3, this.sdf);
                try {
                    object2 = JDBCUtilities.convertValue(object2, n3, this.sdf);
                }
                catch (ParseException parseException) {
                    switch (n2) {
                        case 6: 
                        case 7: {
                            throw parseException;
                        }
                    }
                }
                break;
            }
            case 92: {
                switch (n2) {
                    case 8: 
                    case 9: {
                        object = JDBCUtilities.convertValue(object, 4, null);
                        break block4;
                    }
                }
                object = JDBCUtilities.convertValue(object, n3, this.sdf);
                try {
                    object2 = JDBCUtilities.convertValue(object2, n3, this.sdf);
                }
                catch (ParseException parseException) {
                    switch (n2) {
                        case 6: 
                        case 7: {
                            throw parseException;
                        }
                    }
                }
                break;
            }
            case 93: {
                switch (n2) {
                    case 8: 
                    case 9: {
                        object = JDBCUtilities.convertValue(object, 4, null);
                        break block4;
                    }
                }
                object = JDBCUtilities.convertValue(object, n3, this.sdf);
                try {
                    object = JDBCUtilities.convertValue(object2, n3, this.sdf);
                }
                catch (ParseException parseException) {
                    switch (n2) {
                        case 6: 
                        case 7: {
                            throw parseException;
                        }
                    }
                }
                break;
            }
        }
        switch (n2) {
            case 6: 
            case 7: {
                return new Object[]{object, object2};
            }
            case 8: 
            case 9: {
                return new Object[]{object, Integer.toString(this.jcbDays.getSelectedIndex())};
            }
        }
        return new Object[]{object};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMetamap(Map map) {
        TreeMap treeMap = this.meta;
        synchronized (treeMap) {
            this.meta.clear();
            if (map != null) {
                this.meta.putAll(map);
            }
        }
        this.loadMap();
    }

    public void setAddEnabled(boolean bl2) {
        this.btnAdd.setEnabled(bl2);
    }

    public void setDeleteEnabled(boolean bl2) {
        this.btnDel.setEnabled(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener actionListener) {
        if (this.listenerList != null && this.listenerList.contains(actionListener)) {
            ArrayList arrayList = this.listenerList;
            synchronized (arrayList) {
                this.listenerList.remove(actionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener actionListener) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList(1);
        }
        if (!this.listenerList.contains(actionListener)) {
            ArrayList arrayList = this.listenerList;
            synchronized (arrayList) {
                this.listenerList.add(actionListener);
            }
        }
    }

    private void loadMap() {
        Iterator iterator = this.meta.keySet().iterator();
        this.mdlColumn.removeAllElements();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.mdlColumn.addElement(string);
        }
    }

    private void loadSytle(ColumnMetaData columnMetaData) {
        this.mdlStyle.removeAllElements();
        if (columnMetaData == null) {
            return;
        }
        Object[] objectArray = null;
        int n2 = columnMetaData.getType();
        String string = this.sysConfig.getFormatForSQLType(n2);
        string = string == null ? "" : string;
        this.sdf.applyPattern(string);
        switch (columnMetaData.getType()) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = WhereEditor.getNumberStyles();
                this.txtValue.setText("0");
                this.txtSecondary.setText("1");
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                objectArray = WhereEditor.getStringStyles();
                break;
            }
            case 91: {
                objectArray = WhereEditor.getDateStyles();
                this.txtValue.setText(this.sdf.format(new Date()));
                this.txtSecondary.setText(this.sdf.format(new Date()));
                break;
            }
            case 92: {
                objectArray = WhereEditor.getDateStyles();
                this.txtValue.setText(this.sdf.format(new Date()));
                this.txtSecondary.setText(this.sdf.format(new Date()));
                break;
            }
            case 93: {
                objectArray = WhereEditor.getDateStyles();
                this.txtValue.setText(this.sdf.format(new Date()));
                this.txtSecondary.setText(this.sdf.format(new Date()));
                break;
            }
            default: {
                objectArray = WhereEditor.getUnknownStyles();
                this.txtValue.setText("");
                this.txtSecondary.setText("");
            }
        }
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                this.mdlStyle.addElement(objectArray[i2]);
            }
            this.mdlStyle.setSelectedItem(objectArray[0]);
        }
    }

    private void updateEditor() {
        String string = (String)this.mdlStyle.getSelectedItem();
        String string2 = (String)this.mdlColumn.getSelectedItem();
        ColumnMetaData columnMetaData = (ColumnMetaData)this.meta.get(string2);
        if (columnMetaData == null) {
            return;
        }
        String string3 = null;
        String string4 = null;
        this.pnlEditor.removeAll();
        if (JDBCUtilities.isDateType(columnMetaData.getType())) {
            string3 = BasicUtilities.getString("QBuild_Natural_In_Last");
            string4 = BasicUtilities.getString("QBuild_Natural_Not_In_Last");
            if (string3.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
                this.pnlEditor.add((Component)this.txtValue, WhereEditor.constrain(0, 0.5, 17, 2));
                this.pnlEditor.add((Component)this.jcbDays, WhereEditor.constrain(1, 0.5, 17, 0));
                this.txtValue.setText("1");
                this.pnlEditor.invalidate();
                this.validateTree();
                return;
            }
        }
        string3 = BasicUtilities.getString("QBuild_Natural_In_Range");
        string4 = BasicUtilities.getString("QBuild_Natural_Not_In_Range");
        if (string3.equalsIgnoreCase(string) || string4.equalsIgnoreCase(string)) {
            this.pnlEditor.add((Component)this.txtValue, WhereEditor.constrain(0, 0.5, 17, 2));
            this.pnlEditor.add((Component)this.lblTo, WhereEditor.constrain(1, 0.0, 17, 0));
            this.pnlEditor.add((Component)this.txtSecondary, WhereEditor.constrain(2, 0.5, 17, 2));
        } else {
            this.pnlEditor.add((Component)this.txtValue, WhereEditor.constrain(0, 1.0, 17, 2));
        }
        this.pnlEditor.invalidate();
        this.validateTree();
    }

    private static Object constrain(int n2, double d2, int n3, int n4) {
        Insets insets = new Insets(1, 1, 1, 1);
        return new GridBagConstraints(n2, 0, 1, 1, d2, 0.0, n3, n4, insets, 1, 1);
    }

    private static Object[] getNumberStyles() {
        Object[] objectArray = new String[]{BasicUtilities.getString("QBuild_Natural_Equal"), BasicUtilities.getString("QBuild_Natural_Not_Equal"), BasicUtilities.getString("QBuild_Natural_Greater_Than"), BasicUtilities.getString("QBuild_Natural_Less_Than"), BasicUtilities.getString("QBuild_Natural_In_Range"), BasicUtilities.getString("QBuild_Natural_Not_In_Range")};
        return objectArray;
    }

    private static Object[] getUnknownStyles() {
        Object[] objectArray = new String[]{BasicUtilities.getString("QBuild_Natural_Equal"), BasicUtilities.getString("QBuild_Natural_Not_Equal")};
        return objectArray;
    }

    private static Object[] getDateStyles() {
        Object[] objectArray = new String[]{BasicUtilities.getString("QBuild_Natural_Equal"), BasicUtilities.getString("QBuild_Natural_Not_Equal"), BasicUtilities.getString("QBuild_Natural_Before"), BasicUtilities.getString("QBuild_Natural_After"), BasicUtilities.getString("QBuild_Natural_In_Last"), BasicUtilities.getString("QBuild_Natural_Not_In_Last"), BasicUtilities.getString("QBuild_Natural_In_Range"), BasicUtilities.getString("QBuild_Natural_Not_In_Range")};
        return objectArray;
    }

    private static Object[] getStringStyles() {
        Object[] objectArray = new String[]{BasicUtilities.getString("QBuild_Natural_Equal"), BasicUtilities.getString("QBuild_Natural_Not_Equal"), BasicUtilities.getString("QBuild_Natural_Starts_With"), BasicUtilities.getString("QBuild_Natural_Ends_With"), BasicUtilities.getString("QBuild_Natural_Contains"), BasicUtilities.getString("QBuild_Natural_Does_Not_Contain")};
        return objectArray;
    }

    public void forwardEvent(ActionEvent actionEvent) {
        if (this.listenerList != null) {
            Iterator iterator = this.listenerList.iterator();
            Object object = actionEvent.getSource();
            int n2 = object == this.btnAdd ? 0 : 1;
            ActionEvent actionEvent2 = new ActionEvent(this, n2, actionEvent.getActionCommand(), actionEvent.getModifiers());
            while (iterator.hasNext()) {
                ActionListener actionListener = (ActionListener)iterator.next();
                try {
                    actionListener.actionPerformed(actionEvent2);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void setEnabled(boolean bl2) {
        this.jcbColumn.setEnabled(bl2);
        this.jcbDays.setEnabled(bl2);
        this.jcbStyle.setEnabled(bl2);
        this.txtSecondary.setEnabled(bl2);
        this.txtValue.setEnabled(bl2);
        this.btnAdd.setEnabled(bl2);
        this.btnDel.setEnabled(bl2);
    }

    public static class 1 {
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == WhereEditor.this.jcbColumn) {
                try {
                    String string = (String)WhereEditor.this.mdlColumn.getSelectedItem();
                    ColumnMetaData columnMetaData = (ColumnMetaData)WhereEditor.this.meta.get(string);
                    WhereEditor.this.loadSytle(columnMetaData);
                    WhereEditor.this.updateEditor();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            if (object == WhereEditor.this.jcbStyle) {
                WhereEditor.this.updateEditor();
                return;
            }
            if (object == WhereEditor.this.btnAdd || object == WhereEditor.this.btnDel) {
                WhereEditor.this.forwardEvent(actionEvent);
            }
        }

        public /* synthetic */ ActionHandler(1 var2_2) {
            this();
        }
    }
}

