/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.event.ProgressEvent;
import org.isqlviewer.event.ProgressListener;
import org.isqlviewer.swing.JConsole;
import org.isqlviewer.util.BasicUtilities;

public class ProgressPanel
extends JPanel
implements ProgressListener,
ActionListener {
    private JConsole console = new JConsole("");
    public final Insets insDefault = new Insets(1, 2, 2, 1);
    private NumberFormat pf = NumberFormat.getPercentInstance();
    private JLabel lblProgressNote = new JLabel();
    private JButton btnCancel = new JButton();
    private JProgressBar jpbProgressMeter = new JProgressBar(0);
    private PrintStream filterOut = null;
    private PrintStream filterErr = null;
    private final ActionEvent EVENT = new ActionEvent(this, 0, null);
    private transient ArrayList listeners = null;

    public ProgressPanel() {
        try {
            this.initUI();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "ProgressPanel::initUI()", true);
        }
    }

    public PrintStream getOutStream() {
        return this.filterOut;
    }

    public PrintStream getErrStream() {
        return this.filterErr;
    }

    public void progressUpdated(ProgressEvent progressEvent) {
        this.jpbProgressMeter.setMaximum(progressEvent.getMaximum());
        if (progressEvent.getProgress() < 0) {
            this.jpbProgressMeter.setIndeterminate(true);
        } else {
            this.jpbProgressMeter.setIndeterminate(false);
            this.jpbProgressMeter.setValue(progressEvent.getProgress());
        }
        if (progressEvent.getNote() == null || progressEvent.getNote().trim().length() == 0) {
            String string = this.pf.format((double)progressEvent.getProgress() / (double)progressEvent.getMaximum());
            this.lblProgressNote.setText(BasicUtilities.getString("Percent_Complete", string));
        } else {
            this.lblProgressNote.setText(progressEvent.getNote());
        }
    }

    public void setCompleted() {
        this.progressUpdated(new ProgressEvent(this, this.jpbProgressMeter.getMaximum(), this.jpbProgressMeter.getMaximum()));
    }

    public void reset() {
        this.jpbProgressMeter.setMaximum(100);
        this.jpbProgressMeter.setValue(0);
        String string = this.pf.format(0.0);
        this.lblProgressNote.setText(BasicUtilities.getString("Percent_Complete", string));
        this.console.setText("");
    }

    private void initUI() {
        this.console.configure(SystemConfig.getInstance().getPreferences());
        JScrollPane jScrollPane = new JScrollPane(this.console);
        this.filterOut = new PrintStream(this.console.createFilteredStream("system"), true);
        this.filterErr = new PrintStream(this.console.createFilteredStream("err"), true);
        this.setLayout(new GridBagLayout());
        this.btnCancel.addActionListener(this);
        this.lblProgressNote.setHorizontalAlignment(0);
        this.lblProgressNote.setText(BasicUtilities.getString("Percent_Complete", this.pf.format(0.0)));
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BasicUtilities.getString("Progress_Console_Text")));
        this.console.setToolTipText(BasicUtilities.getString("Progress_Console_Tip"));
        this.btnCancel.setText(BasicUtilities.getString("Cancel"));
        this.btnCancel.setToolTipText(BasicUtilities.getString("Progress_Cancel_Tip"));
        this.add((Component)this.lblProgressNote, this.createGridBag(1, 1, 1, 1, 1.0, 0.0, 10, 2));
        this.add((Component)this.jpbProgressMeter, this.createGridBag(1, 2, 1, 1, 1.0, 0.0, 10, 2));
        this.add((Component)this.btnCancel, this.createGridBag(1, 3, 1, 1, 1.0, 0.0, 13, 0));
        this.add((Component)jScrollPane, this.createGridBag(1, 4, 1, 1, 1.0, 1.0, 10, 1));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.fireActionPerformed(this.EVENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this.listeners != null && this.listeners.contains(actionListener)) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.remove(actionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addActionListener(ActionListener actionListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        if (!this.listeners.contains(actionListener)) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.add(actionListener);
            }
        }
    }

    public void fireActionPerformed(ActionEvent actionEvent) {
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ActionListener actionListener = (ActionListener)iterator.next();
                try {
                    actionListener.actionPerformed(actionEvent);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public GridBagConstraints createGridBag(int n2, int n3, int n4, int n5, double d2, double d3, int n6, int n7) {
        return new GridBagConstraints(n2, n3, n4, n5, d2, d3, n6, n7, this.insDefault, 1, 1);
    }
}

