/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.isqlviewer.swing.AbstractItemAction;
import org.isqlviewer.swing.ActionManager;

public abstract class ActionMenuBar
extends JMenuBar {
    public ActionManager manager;

    public ActionMenuBar(ActionManager actionManager) {
        this.manager = actionManager;
        this.configureMenu();
    }

    public void addMenuItem(JMenu jMenu, Action action) {
        if (action == null) {
            return;
        }
        JMenuItem jMenuItem = jMenu.add(action);
        this.configureMenuItem(jMenuItem, action);
    }

    public void addMenuItem(JPopupMenu jPopupMenu, Action action) {
        JMenuItem jMenuItem = jPopupMenu.add(action);
        this.configureMenuItem(jMenuItem, action);
    }

    public abstract void configureMenu();

    public ActionManager getManager() {
        return this.manager;
    }

    public JMenu createMenu(String string, char c2) {
        JMenu jMenu = new JMenu(string);
        jMenu.setMnemonic(c2);
        return jMenu;
    }

    public void addCheckBoxMenuItem(JMenu jMenu, AbstractItemAction abstractItemAction) {
        this.addCheckBoxMenuItem(jMenu, abstractItemAction, false);
    }

    public void addCheckBoxMenuItem(JMenu jMenu, AbstractItemAction abstractItemAction, boolean bl2) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(abstractItemAction);
        jCheckBoxMenuItem.setSelected(bl2);
        jMenu.add(jCheckBoxMenuItem);
        this.configureMenuItem(jCheckBoxMenuItem, abstractItemAction);
        jCheckBoxMenuItem.addItemListener(abstractItemAction);
        jCheckBoxMenuItem.setIcon(null);
    }

    public void addRadioButtonMenuItem(JMenu jMenu, ButtonGroup buttonGroup, Action action) {
        this.addRadioButtonMenuItem(jMenu, buttonGroup, action, false);
    }

    public void addRadioButtonMenuItem(JMenu jMenu, ButtonGroup buttonGroup, Action action, boolean bl2) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(action);
        jRadioButtonMenuItem.setSelected(bl2);
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        this.configureMenuItem(jRadioButtonMenuItem, action);
        jRadioButtonMenuItem.setIcon(null);
    }

    public void configureMenuItem(JMenuItem jMenuItem, Action action) {
        try {
            KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
            jMenuItem.setAccelerator(keyStroke);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            jMenuItem.setName((String)action.getValue("Name"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

